; Shlobj.inc
; Version 1.0 - April 9, 1999 - by Lord Lucifer
;--------------------------------------------------------------------------------------------------

includelib shell32.lib

; Structures and Equates
;-------------------------------------------------------------------------------------------------

SHITEMID struct DWORD
	cb		WORD	?
	abID	BYTE	?
SHITEMID ends
LPSHITEMID		typedef	PTR SHITEMID

ITEMIDLIST struct DWORD
	mkid	SHITEMID	<?>
ITEMIDLIST ends
LPITEMIDLIST	typedef PTR ITEMIDLIST
LPPITEMIDLIST	typedef PTR LPITEMIDLIST

STRRET_WSTR				equ	0000h
STRRET_OFFSET			equ 0001h
STRRET_CSTR				equ	0002h

STRRET struct DWORD
   	uType				DWORD	?		
union
	pOleStr				DWORD	? 
    uOffset				DWORD	? 
    cStr				BYTE	MAX_PATH dup (?)
ends
STRRET ends
LPSTRRET		typedef PTR STRRET

CSIDL_DESKTOP           equ 0000h
CSIDL_PROGRAMS          equ 0002h
CSIDL_CONTROLS          equ 0003h
CSIDL_PRINTERS          equ 0004h
CSIDL_PERSONAL          equ 0005h
CSIDL_FAVORITES         equ 0006h
CSIDL_STARTUP           equ 0007h
CSIDL_RECENT            equ 0008h
CSIDL_SENDTO            equ 0009h
CSIDL_BITBUCKET         equ 000ah
CSIDL_STARTMENU         equ 000bh
CSIDL_DESKTOPDIRECTORY  equ 0010h
CSIDL_DRIVES            equ 0011h
CSIDL_NETWORK           equ 0012h
CSIDL_NETHOOD           equ 0013h
CSIDL_FONTS		 		equ 0014h
CSIDL_TEMPLATES         equ 0015h

BROWSEINFO struct DWORD
	hwndOwner			DWORD 	?
	pidlRoot			DWORD 	?
	pszDisplayName		DWORD 	?
	lpszTitle			DWORD 	?
	ulFlags				DWORD 	?
	lpfn				DWORD 	?
	lParam				DWORD 	?
	iImage				DWORD 	?
BROWSEINFO ends
LPBROWSEINFO	typedef	PTR BROWSEINFO

BIF_RETURNONLYFSDIRS   	equ	0001h  ; For finding a folder to start document searching
BIF_DONTGOBELOWDOMAIN  	equ	0002h  ; For starting the Find Computer
BIF_STATUSTEXT         	equ	0004h
BIF_RETURNFSANCESTORS  	equ	0008h

BIF_BROWSEFORCOMPUTER  	equ	1000h  ; Browsing for Computers.
BIF_BROWSEFORPRINTER   	equ	2000h  ; Browsing for Printers

BFFM_INITIALIZED        equ	1
BFFM_SELCHANGED         equ	2

BFFM_SETSTATUSTEXT      equ	WM_USER + 100
BFFM_ENABLEOK           equ	WM_USER + 101
BFFM_SETSELECTION       equ	WM_USER + 102

DVASPECT_SHORTNAME		equ	2

NRESARRAY struct DWORD
	cItems				DWORD	?
	nr					NETRESOURCE <?>
NRESARRAY ends
LPNRESARRAY	typedef		PTR NRESARRAY

CIDA struct DWORD
	cidl				DWORD	?
    aoffset				DWORD	?
CIDA ends
LPCIDA		typedef		PTR CIDA

FD_CLSID				equ 0001h
FD_SIZEPOINT			equ 0002h
FD_ATTRIBUTES       	equ 0004h
FD_CREATETIME       	equ 0008h
FD_ACCESSTIME       	equ 0010h
FD_WRITESTIME       	equ 0020h
FD_FILESIZE				equ 0040h
FD_LINKUI				equ 8000h


FILEDESCRIPTOR struct DWORD
    dwFlags				DWORD	?
	clsid				GUID	<?>
	sizel				SIZEL	<?>
	pointl				POINTL	<?>

    dwFileAttributes	DWORD	?
    ftCreationTime		FILETIME	<?>
    ftLastAccessTime	FILETIME	<?>
    ftLastWriteTime		FILETIME 	<?>
    nFileSizeHigh		DWORD	?
    nFileSizeLow		DWORD	?
    cFileName			BYTE	MAX_PATH dup (?)
FILEDESCRIPTOR ends
LPFILEDESCRIPTOR 		typedef PTR FILEDESCRIPTOR

FILEGROUPDESCRIPTOR struct DWORD
     cItems				DWORD	?
     fgd				FILEDESCRIPTOR <?>
FILEGROUPDESCRIPTOR ends
LPFILEGROUPDESCRIPTOR	typedef PTR FILEGROUPDESCRIPTOR

DROPFILES struct DWORD
   	pFiles              DWORD 	?
	pt					POINT 	<?>
   	fNC					DWORD	?				      
	fWide				DWORD	?
DROPFILES ends
LPDROPFILES		typedef	PTR DROPFILES

SHCNE_RENAMEITEM       	equ 00000001h
SHCNE_CREATE	       	equ 00000002h
SHCNE_DELETE	       	equ 00000004h
SHCNE_MKDIR	           	equ 00000008h
SHCNE_RMDIR             equ 00000010h
SHCNE_MEDIAINSERTED     equ 00000020h
SHCNE_MEDIAREMOVED      equ 00000040h
SHCNE_DRIVEREMOVED      equ 00000080h
SHCNE_DRIVEADD          equ 00000100h
SHCNE_NETSHARE          equ 00000200h
SHCNE_NETUNSHARE        equ 00000400h
SHCNE_ATTRIBUTES        equ 00000800h
SHCNE_UPDATEDIR         equ 00001000h
SHCNE_UPDATEITEM       	equ 00002000h
SHCNE_SERVERDISCONNECT 	equ 00004000h
SHCNE_UPDATEIMAGE       equ 00008000h
SHCNE_DRIVEADDGUI       equ 00010000h
SHCNE_RENAMEFOLDER      equ 00020000h
SHCNE_FREESPACE         equ 00040000h
SHCNE_ASSOCCHANGED      equ 08000000h
SHCNE_DISKEVENTS        equ 0002381Fh
SHCNE_GLOBALEVENTS      equ 0C0581E0h 
SHCNE_ALLEVENTS         equ 7FFFFFFFh
SHCNE_INTERRUPT         equ 80000000h 
                                          
SHCNF_IDLIST      		equ 0000h	
SHCNF_PATH        		equ 0001h	
SHCNF_PRINTER     		equ 0002h	
SHCNF_DWORD       		equ 0003h
SHCNF_TYPE        		equ 00FFh
SHCNF_FLUSH       		equ 1000h
SHCNF_FLUSHNOWAIT 		equ 2000h

SHARD_PIDL				equ	00000001h
SHARD_PATH     			equ	00000002h


; Shell Functions
;-------------------------------------------------------------------------------------------------

SHGetMalloc PROTO :DWORD
SHGetPathFromIDList PROTO :DWORD, :DWORD
SHGetSpecialFolderLocation PROTO :DWORD, :DWORD, :DWORD
SHBrowseForFolder PROTO :DWORD
SHLoadInProc PROTO :DWORD
SHGetDesktopFolder PROTO STDCALL :DWORD
SHChangeNotify PROTO :DWORD, :DWORD, :DWORD, :DWORD
SHAddToRecentDocs PROTO :DWORD, :DWORD
SHGetInstanceExplorer PROTO :DWORD
SHGetFileInfo PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD


; IContextMenu interface
;-------------------------------------------------------------------------------------------------

CMF_NORMAL	 			equ	00000000h
CMF_DEFAULTONLY  		equ	00000001h
CMF_VERBSONLY    		equ	00000002h
CMF_EXPLORE     		equ	00000004h
CMF_RESERVED	 		equ	0ffff0000h

GCS_VERB         		equ	00000000h     	; canonical verb
GCS_HELPTEXT     		equ	00000001h		; help text (for status bar)
GCS_VALIDATE     		equ	00000002h		; validate command exists
	
CMIC_MASK_HOTKEY		equ	SEE_MASK_HOTKEY
CMIC_MASK_ICON			equ	SEE_MASK_ICON
CMIC_MASK_FLAG_NO_UI	equ	SEE_MASK_FLAG_NO_UI
CMIC_MASK_MODAL         equ	80000000h				; Internal

CMIC_VALID_SEE_FLAGS	equ	SEE_VALID_CMIC_FLAGS	; Internal 

CMINVOKECOMMANDINFO struct DWORD
    cbSize				DWORD 	?	 	; must be sizeof(CMINVOKECOMMANDINFO)
	fMask				DWORD 	?		; any combination of CMIC_MASK_*
    hwnd				DWORD	?		; might be NULL (indicating no owner window)
    lpVerb				DWORD	?		; either a string of MAKEINTRESOURCE(idOffset)
    lpParameters		DWORD	?		; might be NULL (indicating no parameter)
    lpDirectory			DWORD	?		; might be NULL (indicating no specific directory)
    nShow		 		DWORD	?		; one of SW_ values for ShowWindow() API
	dwHotKey			DWORD	?
	hIcon				DWORD	?
CMINVOKECOMMANDINFO ends 
LPCMINVOKECOMMANDINFO typedef ptr CMINVOKECOMMANDINFO

LPCONTEXTMENU			typedef 	DWORD
LPPCONTEXTMENU			typedef		PTR LPCONTEXTMENU

IContextMenu_QueryContextMenuProto	typedef proto :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
IContextMenu_InvokeCommandProto		typedef proto :DWORD, :LPCMINVOKECOMMANDINFO
IContextMenu_GetCommandStringProto	typedef proto :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
IContextMenu_QueryContextMenu		typedef ptr IContextMenu_QueryContextMenuProto
IContextMenu_InvokeCommand			typedef ptr IContextMenu_InvokeCommandProto
IContextMenu_GetCommandString		typedef ptr IContextMenu_GetCommandStringProto

IContextMenu struct DWORD
	QueryInterface		IUnknown_QueryInterface 		?
	AddRef				IUnknown_AddRef					?
	Release				IUnknown_Release				?
	QueryContextMenu	IContextMenu_QueryContextMenu	?
	InvokeCommand		IContextMenu_InvokeCommand		?
	GetCommandString	IContextMenu_GetCommandString	?
IContextMenu ends


; IShellExtInit interface
;-------------------------------------------------------------------------------------------------

LPSHELLEXTINIT					typedef	DWORD
LPPSHELLEXTINIT					typedef	PTR LPSHELLEXTINIT
IShellExtInit_InitializeProto	typedef proto :DWORD, :LPITEMIDLIST, :DWORD, :DWORD
IShellExtInit_Initialize		typedef ptr IShellExtInit_InitializeProto

IShellExtInit struct DWORD
	QueryInterface		IUnknown_QueryInterface 		?
	AddRef				IUnknown_AddRef					?
	Release				IUnknown_Release				?
	Initialize			IShellExtInit_Initialize 		?
IShellExtInit ends


; IShellPropSheetExt
;-------------------------------------------------------------------------------------------------

LPSHELLPROPSHEETEXT					typedef	DWORD		
LPPSHELLPROPSHEETEXT				typedef	PTR LPSHELLPROPSHEETEXT
IShellPropSheetExt_AddPagesProto	typedef proto :DWORD, :DWORD, :DWORD
IShellPropSheetExt_ReplacePageProto	typedef proto :DWORD, :DWORD, :DWORD, :DWORD
IShellPropSheetExt_AddPages			typedef ptr IShellPropSheetExt_AddPagesProto
IShellPropSheetExt_ReplacePage		typedef ptr IShellPropSheetExt_ReplacePageProto

IShellPropSheetExt struct DWORD
	QueryInterface		IUnknown_QueryInterface 		?
	AddRef				IUnknown_AddRef					?
	Release				IUnknown_Release				?
	AddPages			IShellPropSheetExt_AddPages		?
	ReplacePage			IShellPropSheetExt_ReplacePage	?
IShellPropSheetExt ends


; IExtractIcon
;-------------------------------------------------------------------------------------------------

GIL_OPENICON    		equ 0001h      ; allows containers to specify an "open" look
GIL_FORSHELL     		equ	0002h      ; icon is to be displayed in a ShellFolder

GIL_SIMULATEDOC  		equ	0001h      ; simulate this document icon for this
GIL_PERINSTANCE  		equ	0002h      ; icons from this class are per instance (each file has its own)
GIL_PERCLASS     		equ	0004h      ; icons from this class per class (shared for all files of this type)
GIL_NOTFILENAME  		equ	0008h      ; location is not a filename, must call ::Extract
GIL_DONTCACHE    		equ	0010h      ; this icon should not be cached

LPEXTRACTICON			typedef			DWORD
LPPEXTRACTICON			typedef 		PTR LPEXTRACTICON

IExtractIcon_GetIconLocationProto		typedef proto :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
IExtractIcon_ExtractProto				typedef proto :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
IExtractIcon_GetIconLocation			typedef ptr IExtractIcon_GetIconLocationProto
IExtractIcon_Extract					typedef ptr IExtractIcon_ExtractProto

IExtractIcon struct DWORD
	QueryInterface		IUnknown_QueryInterface 		?
	AddRef				IUnknown_AddRef					?
	Release				IUnknown_Release				?
	GetIconLocation		IExtractIcon_GetIconLocation	?
	Extract				IExtractIcon_Extract			?
IExtractIcon ends


; IShellLink Interface
;-------------------------------------------------------------------------------------------------

SLR_NO_UI				equ 0001h
SLR_ANY_MATCH			equ 0002h
SLR_UPDATE          	equ 0004h

SLGP_SHORTPATH			equ 0001h
SLGP_UNCPRIORITY		equ 0002h

IShellLink_GetIDListProto			typedef proto :DWORD, :LPPITEMIDLIST
IShellLink_SetIDListProto			typedef proto :DWORD, :LPITEMIDLIST
IShellLink_GetDescriptionProto		typedef proto :DWORD, :DWORD, :DWORD
IShellLink_SetDescriptionProto		typedef proto :DWORD, :DWORD
IShellLink_GetWorkingDirectoryProto	typedef proto :DWORD, :DWORD, :DWORD
IShellLink_SetWorkingDirectoryProto	typedef proto :DWORD, :DWORD
IShellLink_GetArgumentsProto		typedef proto :DWORD, :DWORD, :DWORD
IShellLink_SetArgumentsProto		typedef proto :DWORD, :DWORD
IShellLink_GetHotkeyProto			typedef proto :DWORD, :DWORD
IShellLink_SetHotkeyProto			typedef proto :DWORD, :WORD 
IShellLink_GetShowCmdProto			typedef proto :DWORD, :DWORD
IShellLink_SetShowCmdProto			typedef proto :DWORD, :DWORD
IShellLink_GetIconLocationProto		typedef proto :DWORD, :DWORD, :DWORD, :DWORD
IShellLink_SetIconLocationProto		typedef proto :DWORD, :DWORD, :DWORD
IShellLink_SetRelativePathProto		typedef proto :DWORD, :DWORD, :LPITEMIDLIST
IShellLink_ResolveProto				typedef proto :DWORD, :DWORD, :DWORD
IShellLink_SetPathProto				typedef proto :DWORD, :DWORD

IShellLink_GetIDList				typedef ptr IShellLink_GetIDListProto
IShellLink_SetIDList				typedef ptr IShellLink_SetIDListProto
IShellLink_GetDescription			typedef ptr IShellLink_GetDescriptionProto
IShellLink_SetDescription			typedef ptr IShellLink_SetDescriptionProto
IShellLink_GetWorkingDirectory		typedef ptr IShellLink_GetWorkingDirectoryProto
IShellLink_SetWorkingDirectory		typedef ptr IShellLink_SetWorkingDirectoryProto
IShellLink_GetArguments				typedef ptr IShellLink_GetArgumentsProto
IShellLink_SetArguments				typedef ptr IShellLink_SetArgumentsProto
IShellLink_GetHotkey				typedef ptr IShellLink_GetHotkeyProto
IShellLink_SetHotkey				typedef ptr IShellLink_SetHotkeyProto
IShellLink_GetShowCmd				typedef ptr IShellLink_GetShowCmdProto
IShellLink_SetShowCmd				typedef ptr IShellLink_SetShowCmdProto
IShellLink_GetIconLocation			typedef ptr IShellLink_GetIconLocationProto
IShellLink_SetIconLocation			typedef ptr IShellLink_SetIconLocationProto
IShellLink_SetRelativePath			typedef ptr IShellLink_SetRelativePathProto
IShellLink_Resolve					typedef ptr IShellLink_ResolveProto
IShellLink_SetPath					typedef ptr IShellLink_SetPathProto

IShellLink struct DWORD
	QueryInterface		IUnknown_QueryInterface 		?
	AddRef				IUnknown_AddRef					?
	Release				IUnknown_Release				?
	GetIDList			IShellLink_GetIDList			?
	SetIDList			IShellLink_SetIDList			?
	GetDescription		IShellLink_GetDescription		?
	SetDescription		IShellLink_SetDescription		?
	GetWorkingDirectory	IShellLink_GetWorkingDirectory	?	
	SetWorkingDirectory	IShellLink_SetWorkingDirectory	?	
	GetArguments		IShellLink_GetArguments			?
	SetArguments		IShellLink_SetArguments			?
	GetHotkey			IShellLink_GetHotkey			?
	SetHotkey			IShellLink_SetHotkey			?
	GetShowCmd			IShellLink_GetShowCmd			?
	SetShowCmd			IShellLink_SetShowCmd			?
	GetIconLocation		IShellLink_GetIconLocation		?
	SetIconLocation		IShellLink_SetIconLocation		?
	SetRelativePath		IShellLink_SetRelativePath		?
	Resolve				IShellLink_Resolve				?
	SetPath				IShellLink_SetPath				?
IShellLink ends


; ICopyHook interface
;-------------------------------------------------------------------------------------------------

FO_MOVE          		equ 0001h
FO_COPY           		equ	0002h
FO_DELETE         		equ	0003h
FO_RENAME         		equ	0004h

FOF_MULTIDESTFILES      equ 0001h
FOF_CONFIRMMOUSE        equ	0002h
FOF_SILENT              equ	0004h  ; don't create progress/report
FOF_RENAMEONCOLLISION   equ	0008h
FOF_NOCONFIRMATION      equ	0010h  ; Don't prompt the user.
FOF_WANTMAPPINGHANDLE   equ	0020h  ; Fill in SHFILEOPSTRUCT.hNameMappings
                                   ; Must be freed using SHFreeNameMappings
FOF_ALLOWUNDO           equ	0040h
FOF_FILESONLY           equ	0080h  ; on *.*, do only files
FOF_SIMPLEPROGRESS      equ	0100h  ; means don't show names of files
FOF_NOCONFIRMMKDIR      equ	0200h  ; don't confirm making any needed dirs

PO_DELETE				equ	0013h  ; printer is being deleted
PO_RENAME				equ	0014h  ; printer is being renamed
PO_PORTCHANGE			equ	0020h  ; port this printer connected to is being changed
PO_REN_PORT				equ	0034h  ; PO_RENAME and PO_PORTCHANGE at same time.

LPCOPYHOOK							typedef DWORD
LPPCOPYHOOK							typedef PTR LPCOPYHOOK
ICopyHook_CopyCallbackProto			typedef	proto :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
ICopyHook_CopyCallback				typedef ptr ICopyHook_CopyCallbackProto

ICopyHook struct DWORD
	QueryInterface		IUnknown_QueryInterface 		?
	AddRef				IUnknown_AddRef					?
	Release				IUnknown_Release				?
	CopyCallback		ICopyHook_CopyCallback			?
ICopyHook ends


; IFileViewerSite Interface
;-------------------------------------------------------------------------------------------------

LPFILEVIEWERSITE		typedef		DWORD
LPPFILEVIEWERSITE		typedef		PTR LPFILEVIEWERSITE
IFileViewerSite_SetPinnedWindowProto	typedef proto :DWORD, :DWORD
IFileViewerSite_GetPinnedWindowProto	typedef proto :DWORD, :DWORD
IFileViewerSite_SetPinnedWindow			typedef ptr IFileViewerSite_SetPinnedWindowProto
IFileViewerSite_GetPinnedWindow			typedef ptr IFileViewerSite_GetPinnedWindowProto

IFileViewerSite struct DWORD
	QueryInterface		IUnknown_QueryInterface 		?
	AddRef				IUnknown_AddRef					?
	Release				IUnknown_Release				?
	SetPinnedWindow		IFileViewerSite_SetPinnedWindow ?
	GetPinnedWindow		IFileViewerSite_GetPinnedWindow	?
IFileViewerSite ends


; IFileViewer
;-------------------------------------------------------------------------------------------------

FVSHOWINFO struct DWORD
	cbSize				DWORD	?
	hwndOwner			DWORD	?
	iShow				DWORD	?
	dwFlags				DWORD	?
	rect				RECT	<?>
	punkRel				DWORD	?
	strNewFile			BYTE 	MAX_PATH dup (?)	;OLECHAR[MAX_PATH]
FVSHOWINFO ends
LPFVSHOWINFO			typedef ptr FVSHOWFILEINFO

FVSIF_RECT      		equ	00000001h      ; The rect variable has valid data.
FVSIF_PINNED    		equ 00000002h      ; We should Initialize pinned
FVSIF_NEWFAILED 		equ	08000000h      ; The new file passed back failed                                     
FVSIF_NEWFILE   		equ	80000000h      ; A new file to view has been returned
FVSIF_CANVIEWIT 		equ	40000000h      ; The viewer can view it.

LPFILEVIEWER			typedef		DWORD
LPPFILEVIEWER			typedef		DWORD
IFileViewer_ShowInitializeProto		typedef proto :DWORD, :LPFILEVIEWERSITE
IFileViewer_ShowProto				typedef proto :DWORD, :LPFVSHOWINFO
IFileViewer_PrintToProto			typedef proto :DWORD, :DWORD, :DWORD

IFileViewer_ShowInitialize			typedef ptr IFileViewer_ShowInitializeProto
IFileViewer_Show					typedef ptr IFileViewer_ShowProto
IFileViewer_PrintTo					typedef	ptr IFileViewer_PrintToProto

IFileViewer struct DWORD
	QueryInterface		IUnknown_QueryInterface 	?
	AddRef				IUnknown_AddRef				?
	Release				IUnknown_Release			?
	ShowInintialize		IFileViewer_ShowInitialize	?
	Show				IFileViewer_Show			?
	PrintTo				IFileViewer_PrintTo			?
IFileViewer ends


; IEnumIDList interface
;-------------------------------------------------------------------------------------------------

LPENUMIDLIST			typedef DWORD
LPPENUMIDLIST			typedef PTR LPENUMIDLIST
IEnumIDList_NextProto	typedef proto :DWORD, :DWORD, :LPPITEMIDLIST, :DWORD
IEnumIDList_SkipProto	typedef proto :DWORD, :DWORD
IEnumIDList_ResetProto	typedef proto :DWORD
IEnumIDList_CloneProto	typedef proto :DWORD, :LPPENUMIDLIST
IEnumIDList_Next		typedef ptr IEnumIDList_NextProto
IEnumIDList_Skip		typedef ptr IEnumIDList_SkipProto
IEnumIDList_Reset 		typedef ptr IEnumIDList_ResetProto
IEnumIDList_Clone		typedef ptr IEnumIDList_CloneProto

IEnumIDList struct DWORD
	QueryInterface	IUnknown_QueryInterface ?
	AddRef			IUnknown_AddRef			?
	Release			IUnknown_Release		?
	Next			IEnumIDList_Next		?
	Skip			IEnumIDList_Skip		?
	Reset			IEnumIDList_Reset		?
	Clone			IEnumIDList_Clone		?
IEnumIDList ends


; IShellFolder
;-------------------------------------------------------------------------------------------------

SHGDN_NORMAL	    	equ 0
SHGDN_INFOLDER          equ 1      
SHGDN_FORPARSING	    equ 8000h  

SHCONTF_FOLDERS         equ 32
SHCONTF_NONFOLDERS      equ 64
SHCONTF_INCLUDEHIDDEN   equ 128	

SFGAO_CANCOPY           equ DROPEFFECT_COPY 
SFGAO_CANMOVE           equ DROPEFFECT_MOVE
SFGAO_CANLINK           equ DROPEFFECT_LINK 
SFGAO_CANRENAME         equ 00000010h     
SFGAO_CANDELETE         equ 00000020h     
SFGAO_HASPROPSHEET      equ 00000040h    
SFGAO_DROPTARGET		equ 00000100h
SFGAO_CAPABILITYMASK    equ 00000177h
SFGAO_LINK              equ 00010000h
SFGAO_SHARE             equ 00020000h
SFGAO_READONLY          equ 00040000h 
SFGAO_GHOSTED           equ 00080000h  
SFGAO_DISPLAYATTRMASK   equ 000F0000h
SFGAO_FILESYSANCESTOR   equ 10000000h    
SFGAO_FOLDER            equ 20000000h     
SFGAO_FILESYSTEM        equ 40000000h     
SFGAO_HASSUBFOLDER      equ 80000000h     
SFGAO_CONTENTSMASK      equ 80000000h
SFGAO_VALIDATE          equ 01000000h    
SFGAO_REMOVABLE         equ 02000000h    

LPSHELLFOLDER						typedef DWORD
LPPSHELLFOLDER						typedef DWORD
IShellFolder_ParseDisplayNameProto	typedef proto :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :LPPENUMIDLIST, :DWORD 
IShellFolder_EnumObjectsProto		typedef proto :DWORD, :DWORD, :DWORD, :LPPENUMIDLIST
IShellFolder_BindToObjectProto		typedef proto :DWORD, :LPITEMIDLIST, :DWORD, :DWORD, :DWORD 
IShellFolder_BindToStorageProto		typedef proto :DWORD 
IShellFolder_CompareIDsProto		typedef proto :DWORD, :DWORD, :LPITEMIDLIST, :LPITEMIDLIST
IShellFolder_CreateViewObjectProto	typedef proto :DWORD, :DWORD, :DWORD, :DWORD
IShellFolder_GetAttributesOfProto	typedef proto :DWORD, :DWORD, :LPITEMIDLIST, :DWORD 
IShellFolder_GetUIObjectOfProto		typedef proto :DWORD, :DWORD, :DWORD, :LPPITEMIDLIST, :DWORD, :DWORD, :DWORD 
IShellFolder_GetDisplayNameOfProto	typedef proto :DWORD, :LPITEMIDLIST, :DWORD, :LPSTRRET 
IShellFolder_SetNameOfProto			typedef proto :DWORD, :DWORD, :LPITEMIDLIST, :DWORD, :DWORD, :LPPITEMIDLIST

IShellFolder_ParseDisplayName		typedef ptr IShellFolder_ParseDisplayNameProto
IShellFolder_EnumObjects			typedef ptr IShellFolder_EnumObjectsProto
IShellFolder_BindToObject			typedef ptr IShellFolder_BindToObjectProto
IShellFolder_BindToStorage			typedef ptr IShellFolder_BindToStorageProto
IShellFolder_CompareIDs				typedef ptr IShellFolder_CompareIDsProto
IShellFolder_CreateViewObject		typedef ptr IShellFolder_CreateViewObjectProto
IShellFolder_GetAttributesOf		typedef ptr IShellFolder_GetAttributesOfProto
IShellFolder_GetUIObjectOf			typedef ptr IShellFolder_GetUIObjectOfProto
IShellFolder_GetDisplayNameOf		typedef ptr IShellFolder_GetDisplayNameOfProto
IShellFolder_SetNameOf				typedef ptr IShellFolder_SetNameOfProto

IShellFolder struct DWORD
	QueryInterface		IUnknown_QueryInterface 		?
	AddRef				IUnknown_AddRef					?
	Release				IUnknown_Release				?
	ParseDisplayName	IShellFolder_ParseDisplayName	?
	EnumObjects			IShellFolder_EnumObjects		?
	BindToObject		IShellFolder_BindToObject		?
	BindToStorage		IShellFolder_BindToStorage		?
	CompareIDs			IShellFolder_CompareIDs			?
	CreateViewObject	IShellFolder_CreateViewObject	?
	GetAttributesOf		IShellFolder_GetAttributesOf	?
	GetUIObjectOf		IShellFolder_GetUIObjectOf		?
	GetDisplayNameOf	IShellFolder_GetDisplayNameOf	?
	SetNameOf			IShellFolder_SetNameOf			?
IShellFolder ends


;-------------------------------------------------------------------------------------------------
; Guids and Clsids

externdef	CLSID_ShellDesktop:IID
externdef	CLSID_ShellLink:IID

externdef	IDD_IUnknown:IID
externdef	IID_IContextMenu:IID
externdef	IID_IShellExtInit:IID
externdef	IID_IShellPropSheetExt:IID
externdef	IID_IExtractIcon:IID
externdef	IID_IShellLink:IID
externdef	IID_IShellCopyHook:IID
externdef	ID_IFileViewerSite:IID
externdef	IID_IFileViewer:IID
externdef	IID_IEnumIDList:IID
externdef	IID_IShellFolder:IID






















