; Splitter.asm
;--------------------------------------------------------------------------------------------------
.486p
.model flat, stdcall
                      
include windows.inc
include splitter.inc

include kernel32.inc 
include user32.inc  
include comctl32.inc 
include gdi32.inc

ID_SPLITTERBAR 			equ 10213
SPLIT_RESIZEBAR_LIMIT	equ	10 

;------------------------------------------------------------------------------------------------------------
.data?                                          	; uninitialized data
align DWORD
	hWndSplitter			dd		?				; splitter window
	hWndParent				dd		?				; splitter window's parent
	hDC						dd		?				; device context handle used when resizing
	hGDIObjOld				dd		?				; saved gdi object, used when resizing
	cxOldPos				dd		?				; previous position of the split resizer, used when resizing
	bResizing				dd		?				; flag to check if the splitter bar is currently being moved
	
;------------------------------------------------------------------------------------------------------------
.const                                          	; constant data segment
align DWORD
	SPLITTERCLASS		db		"SplitterClass",0
	

;------------------------------------------------------------------------------------------------------------
.code 

;--------------------------------------------------------------------------------------------------
; InitSplitterWindowClass
; PARAMS:	none
; RETURN: 	eax = return status of RegisterClassEx (TRUE if ok, FALSE if not)
;
InitSplitterWindowClass proc hInstance:DWORD
	LOCAL   wc:WNDCLASSEX

    mov     wc.cbSize, sizeof WNDCLASSEX    
    mov     wc.style, CS_VREDRAW + CS_HREDRAW + CS_BYTEALIGNCLIENT 				
    mov     wc.lpfnWndProc, offset SplitterBarWndProc
    mov     wc.cbClsExtra,0
    mov     wc.cbWndExtra,0	
	mov     eax,hInstance
    mov     wc.hInstance,eax
    mov     wc.hIcon, 0
    mov     wc.hIconSm, 0
	invoke	LoadCursor, 0, IDC_SIZEWE
    mov     wc.hCursor,eax
    mov     wc.hbrBackground, COLOR_WINDOW
    mov     wc.lpszMenuName, ID_SPLITTERBAR
    mov     wc.lpszClassName, offset SPLITTERCLASS

    invoke	RegisterClassEx, addr wc 

    ret                    
InitSplitterWindowClass endp


;--------------------------------------------------------------------------------------------------
; CreateSplitterWindow
; PARAMS:	hWndParent
;			hInstance
; RETURN:	eax = handle to splitter window
;
CreateSplitterWindow proc hWndOwner:DWORD, hInstance:DWORD
	LOCAL	rect:RECT

	mov		eax, hWndOwner
	mov		hWndParent, eax
	
	mov		bResizing, 0
	
	; get parent window size
	invoke	GetClientRect, hWndOwner, addr rect	
	
	; create the tree view window
	invoke	CreateWindowEx, 
			0,
			addr SPLITTERCLASS, 
			0,
			WS_CHILD or WS_VISIBLE,
			0, rect.top, 
			SPLIT_RESIZEBAR_WIDTH, rect.bottom,
			hWndParent,
			0, 
			hInstance, 
			NULL
	mov		hWndSplitter, eax
		
	ret
CreateSplitterWindow endp


;--------------------------------------------------------------------------------------------------
; SplitterBarWndProc
SplitterBarWndProc proc hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	LOCAL	rect:RECT
	LOCAL	point:POINT

	mov		eax,uMsg
	cmp		eax,WM_MOUSEMOVE
	je		wm_mousemove
	cmp		eax,WM_LBUTTONDOWN
	je		wm_lbuttondown
	cmp		eax,WM_LBUTTONUP
	je		wm_lbuttonup	
	cmp		eax,SPLIT_SETPOSITION
	je		split_setposition
	cmp		eax,SPLIT_GETPOSITION
	je		split_getposition
	cmp		eax,WM_MOVE
	je		wm_move
					
	invoke 	DefWindowProc, hWnd, uMsg, wParam, lParam
	jmp		return	

; mouse is being moved
wm_mousemove:
	; check to see the left button is down and we are currently resizing
	test	wParam,MK_LBUTTON
	jz		return0
	cmp		bResizing, 0
	je		return0
	
	invoke	GetClientRect, hWnd, addr rect
	
	; redraw the old position to resore it back to normal
	invoke	PatBlt, hDC, cxOldPos, rect.top, 3, rect.bottom, DSTINVERT

	; now invert at the new position
	invoke	GetCursorPos, addr point
	invoke	ScreenToClient, hWndParent, addr point
	mov		edx, point.x
	mov		cxOldPos, edx	; save position
	invoke	PatBlt, hDC, edx, rect.top, 3, rect.bottom, DSTINVERT

	jmp		return0

; left mouse button is pressed
wm_lbuttondown:
	mov		bResizing, 1
	
	; Capture the mouse input until button is released
	invoke	SetCapture, hWnd;hWndParent
		
	; Set up the device context
	invoke	GetDC, hWndParent
	mov		hDC, eax
	invoke	CreateSolidBrush, 0
	invoke 	SelectObject, hDC, eax
	mov		hGDIObjOld, eax

	; draw the resizing bar by inverting the pixels
	invoke	GetClientRect, hWnd, addr rect
	invoke	GetCursorPos, addr point
	invoke	ScreenToClient, hWndParent, addr point
	mov		edx, point.x
	mov		cxOldPos, edx	; save position
	invoke	PatBlt, hDC, edx, rect.top, 3, rect.bottom, DSTINVERT
	
	jmp		return0
	
; Left mouse button is released	
wm_lbuttonup:
	mov		bResizing, 0
	
	; invert to restore the window back to normal
	invoke	GetClientRect, hWnd, addr rect
	invoke	PatBlt, hDC, cxOldPos, rect.top, 3, rect.bottom, DSTINVERT
	
	; release the DC resources
	invoke	SelectObject, hDC, hGDIObjOld
	invoke	ReleaseDC, hWnd, hDC
	
	; Now send the SPLIT_MOVED message to the parent window to let them deal with it...
	invoke	GetCursorPos, addr point
	invoke	ScreenToClient, hWnd, addr point
	invoke	MapWindowPoints, hWnd, hWndParent, addr point, 1
	invoke	SendMessage, hWndParent, SPLIT_SPLITTERMOVED, 
			0,			; reserved ( for now )
			point.x		; x-position ( relative to parents client )		
			
	; Release the mouse csapture
	invoke	ReleaseCapture
	
	jmp		return0
	
; move the bar
wm_move:
	invoke	GetClientRect, hWndParent, addr rect
	mov		eax,lParam
	mov		ebx,eax
	and		eax,0000FFFFh ; loword lParam = xPos
	shr		ebx, 16	
	invoke	SetWindowPos, hWnd, 0, eax, ebx, SPLIT_RESIZEBAR_WIDTH, rect.bottom, SWP_SHOWWINDOW or SWP_NOZORDER	
	jmp		return0
	
; Paint the splitter bar
wm_paint:		
	jmp		return

; set the splitter bar position
split_setposition:
	invoke	SetWindowPos, hWnd, 0, lParam, 0, 0, 0, SWP_NOSIZE or SWP_SHOWWINDOW or SWP_NOZORDER
	cmp		wParam, 0
	jz		@F
	invoke	SendMessage, hWndParent, SPLIT_SPLITTERMOVED, 0, lParam
	@@:
	mov		eax, 1
	jmp		return

; get the splitter bar position
split_getposition:
	mov		point.x, 0
	invoke	MapWindowPoints, hWnd, hWndParent, addr point, 1
	mov		eax, point.x
	jmp		return

return0:
	xor		eax,eax
return:
	ret
SplitterBarWndProc endp





end