; Tree.asm
; Handles the View Bar
.486p
.model flat, stdcall
                      
include fman.inc    

ID_VIEWBAR equ 1349
ViewBarWndProc proto hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD

;------------------------------------------------------------------------------------------------------------
.const                                          	; constant data segment
align DWORD   
	szViewBarClassName		db		"ViewBar32",0   

;------------------------------------------------------------------------------------------------------------
.code    

   
InitViewBar proc uses ebx hWndParent:DWORD, hInstance:DWORD
	LOCAL	rect:RECT
	LOCAL   wc:WNDCLASSEX
	
    mov     wc.cbSize, sizeof WNDCLASSEX    
    mov     wc.style, CS_VREDRAW + CS_HREDRAW + CS_BYTEALIGNCLIENT 				
    mov     wc.lpfnWndProc, offset ViewBarWndProc
    mov     wc.cbClsExtra,0
    mov     wc.cbWndExtra,4 ; 4 bytes = pointer to window's VIEWBARINFO structure
	mov     eax,hInstance
    mov     wc.hInstance,eax
    mov     wc.hIcon, 0
    mov     wc.hIconSm, 0
	invoke	LoadCursor, 0, IDC_ARROW
    mov     wc.hCursor,eax
    mov     wc.hbrBackground, 0;COLOR_WINDOW
    mov     wc.lpszMenuName, ID_VIEWBAR
    mov     wc.lpszClassName, offset szViewBarClassName

    invoke	RegisterClassEx, addr wc 

	; get parent window size
	invoke	GetClientRect, hWndParent, addr rect

	; create the window
	invoke	CreateWindowEx, 
			0,
			addr szViewBarClassName, 
			addr szViewBarClassName,
			WS_VISIBLE or WS_CHILD,
			0, 0,
			rect.right, rect.bottom,
			hWndParent,
			0, 
			hInstance, 
			NULL
	                  
return:
	; return the window handle
	ret
InitViewBar endp


;--------------------------------------------------------------------------------------------------


ViewBarWndProc proc uses ebx edi esi hWnd:DWORD, uMsg:DWORD, wParam:DWORD, lParam:DWORD
	LOCAL	rect:RECT
	LOCAL	hDC:DWORD
	LOCAL	ps:PAINTSTRUCT
	LOCAL	hMenu:DWORD
	LOCAL	point:POINT
	LOCAL	dwTemp:DWORD
	
	mov		eax, uMsg
	
	cmp		eax, VIEWBAR_INSERT
	je		viewbar_insert
	cmp		eax, VIEWBAR_REMOVE
	je		viewbar_remove
	cmp		eax, VIEWBAR_SETACTIVE
	je		viewbar_setactive
	
	cmp		eax, VIEWBARITEM_SETTEXT
	je		viewbaritem_settext
	cmp		eax, VIEWBARITEM_SETICON
	je		viewbaritem_seticon
	cmp		eax, VIEWBARITEM_SETSTYLE
	je		viewbaritem_setstyle	
	
	cmp		eax, WM_PAINT
	je		wm_paint
	cmp		eax, WM_CREATE
	je		wm_create
	cmp		eax, WM_DESTROY
	je		wm_destroy	
	cmp		eax, WM_RBUTTONDOWN 
	je		wm_rbuttondown
	cmp		eax, WM_NOTIFY
	je		wm_notify
	
	cmp		eax, SPLIT_SPLITTERMOVED
	je		split_splittermoved
	
	invoke	DefWindowProc, hWnd, uMsg, wParam, lParam
	jmp		return
	
; VIEWBAR_INSERT
; wParam: index to insert to (-1 for end)
; lParam: address of VIEWBARITEM structure of item to add
; return: TRUE if added, FALSE if not
viewbar_insert:
	; Get the windwos VIEWBARINFO pointer and save to edi
	invoke	GetWindowLong, hWnd, 0
	mov		edi, eax	

	; check to see if we can add another
	cmp		wParam, VIEWBARS_MAXNUM
	jl		@F
	cmp		(VIEWBARINFO ptr [edi]).nNumBars, VIEWBARS_MAXNUM
	jl		@F
	cmp		wParam, -1
	jg		@F
	; max number of bars reached
	xor		eax,eax
	ret	
@@:
	; set the index, if -1 attach to end
	mov		eax, wParam
	cmp		eax, -1
	jne		@F
	mov		eax, (VIEWBARINFO ptr [edi]).nNumBars	
@@:	
	; now get the correct offset into the VIEWBARINFO struct
	imul	eax, sizeof VIEWBARITEM
	add		edi, eax
	
	; get the source pointer in esi
	mov		esi, lParam
	
	; set the size and direction
	mov		ecx, sizeof VIEWBARITEM
	cld
	
	; store the data
@@:
	lodsb
	stosb
	loop	@B

	; now we set the view-bars window's parent to this window
	mov		esi, lParam
	mov		eax, (VIEWBARITEM ptr [esi]).hWnd
	invoke	SetParent, eax, hWnd
	
	mov		eax, (VIEWBARITEM ptr [esi]).hWndAssoc
	invoke	SetParent, eax, hWnd
	
	; increment bar count
	invoke	GetWindowLong, hWnd, 0
	inc		(VIEWBARINFO ptr [eax]).nNumBars	
	
	; info written, return true
	mov		eax,1
	jmp		return
	
; VIEWBAR_REMOVE
; wParam: index to remove
; lParam: 0
; return: TRUE if successful, FALSE otherwise
viewbar_remove:
	; Get the windwos VIEWBARINFO pointer and save to edi 
	invoke	GetWindowLong, hWnd, 0
	mov		edi, eax
	
	; decrement the number of bars count
	dec		(VIEWBARINFO ptr [edi]).nNumBars
	
	; if the bar being removed is the current one, reset the current member to 0
	mov		eax, wParam
	cmp		(VIEWBARINFO ptr [edi]).iCurrentBar, eax
	jne		@F
	mov		(VIEWBARINFO ptr [edi]).iCurrentBar, 0
@@:
	; now get the correct pointer to the VIEWBARITEM member
	mov		eax, wParam
	imul	eax, sizeof VIEWBARITEM
	add		edi, eax
	
	; zero out the data
	mov		ecx, sizeof VIEWBARITEM
	cld
	xor		eax,eax
	rep		stosb
	
	mov		eax,1
	jmp		return

; VIEWBAR_SETACTIVE
; wParam: index of bar to set as the active one
; lParam: 0
; return: TRUE if bar is set
viewbar_setactive:
	; Get the windwos VIEWBARINFO pointer and save to edi 
	invoke	GetWindowLong, hWnd, 0
	mov		edi, eax

	; hide the current window
	mov		eax, (VIEWBARINFO ptr [edi]).iCurrentBar
	imul	eax, sizeof VIEWBARITEM
	mov		esi, edi
	add		esi, eax	
	invoke	ShowWindow, (VIEWBARITEM ptr [esi]).hWnd, SW_HIDE
	invoke	ShowWindow, (VIEWBARITEM ptr [esi]).hWndAssoc, SW_HIDE
	
		
	; set the new current bar member and show the window
	mov		eax, wParam
	mov		(VIEWBARINFO ptr [edi]).iCurrentBar, eax
	imul	eax, sizeof VIEWBARITEM
	mov		esi, edi
	add		esi, eax	
		
	invoke	SetWindowPos, (VIEWBARITEM ptr [esi]).hWnd, hWnd, 0, 0, 0, 0, SWP_NOSIZE or SWP_NOMOVE
	invoke	ShowWindow, (VIEWBARITEM ptr [esi]).hWnd, SW_SHOW

	; show the associated window
	invoke	SetWindowPos, (VIEWBARITEM ptr [esi]).hWndAssoc, hWnd, 0, 0, 0, 0, SWP_NOSIZE or SWP_NOMOVE
	invoke	ShowWindow, (VIEWBARITEM ptr [esi]).hWndAssoc, SW_SHOW
	
	; now repaint the whole bar
	invoke	InvalidateRect, hWnd, 0, TRUE
	
	mov		eax, 1
	jmp		return
	
	
; VIEWBAR_SETTEXT
; wParam: index of bar to modify (-1 for current)
; lParam: pointer to text string
viewbaritem_settext:
	jmp		return0
	
; VIEWBAR_SETICON
; wParam: index of bar to modify (-1 for current)
; lParam: ---
viewbaritem_seticon:
	jmp		return0
	
viewbaritem_setstyle:
	jmp		return0
	
	
;-------------------------------------------------------------------------------------------------
; WM_PAINT
; wParam: ?
; lParam: ?
; retrun: 0
wm_paint:
	; get the current bar's VIEWBARITEM structure into esi
	invoke	GetWindowLong, hWnd, 0	
	mov		esi, eax
	mov		eax, (VIEWBARINFO ptr [esi]).iCurrentBar	
	imul	eax, sizeof VIEWBARITEM
	add		esi, eax
	
	; get splitter pos
	invoke	GetWindowLong, hWnd, 0
	invoke	SendMessage, (VIEWBARINFO ptr [eax]).hWndSplitter, SPLIT_GETPOSITION, 0, 0
	mov		edi, eax ; edi is the width
	
	; paint the view bar's title	
	invoke	BeginPaint, hWnd, addr ps
	mov		hDC, eax
	invoke	GetClientRect, hWnd, addr rect
	mov		rect.bottom, VIEWBAR_TITLEHEIGHT
	mov		rect.right, edi
	invoke	FillRect, hDC, addr rect, COLOR_MENU + 1

	invoke	DrawEdge, hDC, addr rect, EDGE_SUNKEN, BF_TOPRIGHT
	invoke	DrawEdge, hDC, addr rect, EDGE_SUNKEN, BF_LEFT		
	
	add		rect.top, 2
	add		rect.left, 2
	sub		rect.right, 2
	invoke	DrawEdge, hDC, addr rect, EDGE_RAISED, BF_TOPRIGHT
	invoke	DrawEdge, hDC, addr rect, EDGE_RAISED, BF_LEFT
	
	; paint the icon and text
	invoke	GetStockObject, ANSI_VAR_FONT
	invoke 	SelectObject, hDC, eax 
	mov		ebx, eax
	invoke	SetBkMode, hDC, TRANSPARENT	
	
	invoke	LoadIcon, NULL, IDI_EXCLAMATION
	invoke	DrawIconEx, hDC, 7, 5, eax, 16, 16, 0, 0, DI_NORMAL
	add		[rect.top], 5
	add		[rect.left], 10 + 16
	lea		ecx, (VIEWBARITEM ptr [esi]).szTitle
	invoke	DrawTextEx, hDC, ecx, -1, addr rect, 0, 0
	
	invoke 	SelectObject, hDC, ebx
	invoke	EndPaint, hDC, addr ps		
			
	; paint the view bar's child
	invoke	GetClientRect, hWnd, addr rect
	sub		rect.bottom, VIEWBAR_TITLEHEIGHT
	mov		ebx, (VIEWBARITEM ptr [esi]).hWnd		
	invoke	SetWindowPos, ebx, 0, 0, VIEWBAR_TITLEHEIGHT, edi, rect.bottom, SWP_NOZORDER	
	
	; paint the associate window
	invoke	GetClientRect, hWnd, addr rect		
	mov		ebx, (VIEWBARITEM ptr [esi]).hWndAssoc
	mov		ecx, rect.right
	sub		ecx, edi
	sub		ecx, SPLIT_RESIZEBAR_WIDTH
	mov		edx, edi
	add		edx, SPLIT_RESIZEBAR_WIDTH
	invoke	SetWindowPos, ebx, 0, edx, 0, ecx, rect.bottom, SWP_NOZORDER
	
	; move the splitter
	invoke	GetWindowLong, hWnd, 0
	mov		ebx, (VIEWBARINFO ptr [eax]).hWndSplitter
	invoke	SendMessage, ebx, WM_MOVE, 0, edi
	invoke	UpdateWindow, ebx
	
	jmp		return0
	

; WM_CREATE
; wParam: ?
; lParam: LPCREATESTRUCT - structure with creation data 
; retrun: 0 to continue creation, -1 to destroy window
wm_create:
	; allocate some memory for the VIEWBARINFO structure for this window
	; offset 0 is the VIEWBARINFO structure value
	invoke	GlobalAlloc, GMEM_FIXED or GMEM_ZEROINIT, sizeof VIEWBARINFO
	mov		ebx, eax							; save the pointer to ebx
	invoke	SetWindowLong, hWnd, 0, ebx 	
	
	; create splitter and save its hwnd
	invoke	GetWindowLong, hWnd, GWL_HINSTANCE
	invoke	InitSplitterWindowClass, eax
	invoke	GetWindowLong, hWnd, GWL_HINSTANCE
	invoke	CreateSplitterWindow, hWnd, eax
	mov		(VIEWBARINFO ptr [ebx]).hWndSplitter, eax

	invoke	SendMessage, eax, SPLIT_SETPOSITION, TRUE, 200	; set default
		
	; fill in the windows VIEWBARINFO structure	
	invoke	GetParent, hWnd
	mov		(VIEWBARINFO ptr [ebx]).hWndParent, eax
	mov		(VIEWBARINFO ptr [ebx]).iCurrentBar, 0
	mov		(VIEWBARINFO ptr [ebx]).nNumBars, 0
		
	jmp		return0
	
	
; WM_DESTROY
; wParam: ?
; lParam: ?
; return: 0
wm_destroy:
	; free the VIEWBARINFO structure memory
	invoke	GetWindowLong, hWnd, 0
	invoke	GlobalFree, eax
	
	jmp		return0
	

; WM_LBUTTONDOWN
; wParam: fwKeys, key flags
; lParam: LOWORD=xPos, HIWORD=yPos
; return: 0
wm_rbuttondown:
	; check to position to see if its in the view bar's title
	mov		eax, lParam
	shr		eax, 16
	cmp		eax, VIEWBAR_TITLEHEIGHT
	jle		@F
	ret
	
@@:
	; create the menu and such...
	; get the current bar's VIEWBARITEM structure into edi
	invoke	GetWindowLong, hWnd, 0
	mov		edi, eax
	
	invoke	CreatePopupMenu
	mov		hMenu, eax
	
	; now loop
	xor		esi,esi
@Loop:
	mov		eax, esi
	imul	eax, sizeof VIEWBARITEM
	add		eax, edi
	
	lea		eax, (VIEWBARITEM ptr [eax]).szTitle
	cmp		dword ptr [eax], 0
	je		@F
	mov		ecx, esi
	add		ecx, 1
	invoke	InsertMenu, hMenu, -1, MF_BYPOSITION or MF_STRING, ecx, eax
@@:
	inc		esi
	cmp		esi, VIEWBARS_MAXNUM
	jl		@Loop

	; now show the menu
	invoke	GetCursorPos, addr point
	invoke	TrackPopupMenu, 
			hMenu, 
			TPM_RETURNCMD or TPM_LEFTALIGN or TPM_RIGHTBUTTON or TPM_LEFTBUTTON, 
			point.x, point.y, 
			0, 
			hWnd, 
			0
	test	eax, eax
	jnz		@F
	ret
@@:
	; now change the bar
	dec		eax
	invoke	SendMessage, hWnd, VIEWBAR_SETACTIVE, eax, 0	
	
	jmp		return0



; WM_NOTIFY 
; wParam: idCtrl
; lParam: pnmh (LPNMHDR)
; return: ?
wm_notify:

	; get the current bar's VIEWBARITEM structure into esi
	invoke	GetWindowLong, hWnd, 0	
	mov		esi, eax
	mov		eax, (VIEWBARINFO ptr [esi]).iCurrentBar	
	imul	eax, sizeof VIEWBARITEM
	add		esi, eax
	
	; get the current bar's ID
	mov		eax, (VIEWBARITEM ptr [esi]).hWnd
	invoke	GetWindowLong, eax, GWL_ID
	
	; compare the current bar's ID to the ID sending the notification
	cmp		eax, wParam
	jne		@F
	
	; call the notification procedure
	push	hWnd
	push	lParam
	mov		eax, (VIEWBARITEM ptr [esi]).lpfnNotifyProc
	call	eax	
	
@@:	
	jmp		return
	
	
; SPLIT_SPLITTERMOVED
; wParam = 0 (reserved for now)
; lParam = x-position ( relative to parents client )	
split_splittermoved:
	; move the splitter
	invoke	GetWindowLong, hWnd, 0
	invoke	SendMessage, (VIEWBARINFO ptr [eax]).hWndSplitter, WM_MOVE, 0, lParam
	
	; repaint the viewbar
	invoke	InvalidateRect, hWnd, 0, TRUE	
	
	jmp		return0


return0:	
	xor		eax,eax
return:
	ret
	
ViewBarWndProc endp



;--------------------------------------------------------------------------------------------------
; GetCurrentBar
; returns: pointer to current bar item
GetCurrentBar proc uses ebx hWnd:DWORD
	invoke	GetWindowLong, hWnd, 0
	mov		ebx, eax
	mov		eax, (VIEWBARINFO ptr [ebx]).iCurrentBar	
	imul	eax, sizeof VIEWBARITEM
	add		eax, ebx
	ret	
GetCurrentBar endp



end