; Get PE Loader - by Net Walker! May 1995
; First Public Version
; lnwlaker@hotmail.com

.386P
LOCALS
JUMPS
.MODEL FLAT, STDCALL
UNICODE=0
INCLUDE W32.inc
INCLUDE ResDef.inc	; include resource definitions

HostCodeOff		EQU	200h
HostObjTableOff 	EQU	178h
HostPEHeaderOff		EQU	80h

EXTRN	wsprintf	: PROC
EXTRN	MakeMappedFile	: PROC
EXTRN	EndMappedFile	: PROC
EXTRN	ShowErrorMsg	: PROC
EXTRN	MMGetFileSize	: PROC
EXTRN	MMSetFileSize	: PROC

.data

hInst           DD 0
hMain     	DD 0
hBROWSE		DD 0
hOK		DD 0
hEXE		DD 0
hIMAGE		DD 0

msg         	MSG	    	<0>
wc          	WNDCLASS    	<0>
OFN		OPENFILENAME 	<0>

Filter 		db 	"Executable Files (*.exe,*.dll)",0,"*.exe;*.dll",0, "All Files (*.*)",0, "*.*",0,0
szPathName	db 	MAX_PATH dup(0)
szHostFileName	DB 	"Host.exe",0
StrBuffer	DB	100 dup(0)
szHostPath	DB	MAX_PATH dup(0)
ExeFileAddr	DD 	0			; Initial aDDress of file mapped on memory
PEHeaderAddr	DD 	0
EntryPointRVA	DD	0
ObjTableAddr	DD	0
NumObj		DW	0
CodeOffset	DD	0
BytesToCopy	DD	0
ObjectName	DD	0
FileSize	DD	0
HostExeFileAddr	DD	0
HostPEHeaderAddr DD	0
HostObjTableAddr DD	0
AlignedCodeSize DD	0
MiniAddr	DD	0

szTitle		db 'Get PE Loader (by Net Walker! - 1998)',0
szMainClass     db 'NWPEC',0
szEditClass	db 'EDIT',0
szButtonClass	db 'BUTTON',0
szOKButton	db 'Browse',0
szNOBPXButton	db 'OK',0
szCheck		db 'Adjust Image Base',0
ErrorMsg1	DB "Not a Valid PE File",0
ErrorMsg2	DB "Cannot Found Entry Point RVA.", 0
ErrorMsg3	DB "HOST.EXE already exixts.  Continue?",0

szMsgSuccess	DB "Host.exe created <%d> with %d bytes from %s Object!", 0


.code

;-----------------------------------------------------------------------------
start:

        call    GetModuleHandle, 0          
        mov     hInst, eax            

; initialize the WndClass structure 
; Actually, we get the window class from a DIALOG (with CLASS directive) in the resource

	mov	wc.wc_cbSize, WNDCLASSEX_
	mov	wc.wc_style, CS_HREDRAW + CS_VREDRAW 
	mov	wc.wc_lpfnWndProc, offset WndProc
	mov	wc.wc_cbClsExtra, 0
	mov	wc.wc_cbWndExtra, DLGWINDOWEXTRA	; this is needed to use a dialogbox as
							; a window class
	mov	eax, hInst
	mov	wc.wc_hInstance, eax

; load main icon from resource
	call 	LoadIcon, hInst, IDI_ICON1
	mov	wc.wc_hIcon, eax
	mov	wc.wc_hIconSm, eax

; load a default cursor
  	call 	LoadCursor,NULL, IDC_ARROW
	mov	wc.wc_hCursor, eax
	
	mov	wc.wc_hbrBackground, COLOR_BACKGROUND
	mov	wc.wc_lpszMenuName, IDR_MENU1
	mov	wc.wc_lpszClassName, OFFSET szMainClass

  	call 	RegisterClassEx, OFFSET wc

; create window
	call	CreateDialogParam, hInst, offset szMainClass, 0, NULL, 0
	mov	hMain, eax

; get child control handles
	call 	GetDlgItem, hMain, ID_EXE
	mov	dword ptr [hEXE], eax
	call	GetDlgItem, hMain, ID_BROWSE
	mov	dword ptr [hBROWSE], eax
	call	GetDlgItem, [hMain], IDOK
	mov	dword ptr [hOK], eax
	call	GetDlgItem, hMain, ID_IMAGE
	mov	dword ptr [hIMAGE], eax

;Adjust some controls
	call 	SetFocus, hEXE
	call	SendMessage, hIMAGE, BM_SETCHECK, TRUE, 0
; adjust command line
	call	AdjustCommandLine

msg_loop:

        call    GetMessage, offset msg, 0, 0, 0
        cmp     ax, 0
        je      end_loop
	call	IsDialogMessage, hMain, offset msg	
	cmp	eax, TRUE			
	jz	msg_loop
        call    TranslateMessage, offset msg
        call    DispatchMessage, offset msg
        jmp     msg_loop

end_loop:
        call    ExitProcess, 0

;-----------------------------------------------------------------------------
WndProc          PROC USES ebx edi esi, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

        cmp     [wmsg], WM_DESTROY
        je      wmdestroy
        cmp     [wmsg], WM_COMMAND
        je      wmcommand
        jmp     defwndproc

wmdestroy:
        call    PostQuitMessage, 0
        mov     eax, 0
        jmp     finish

wmcommand:
        cmp	wparam, ID_BROWSE
	jne	@@1
	call	OpenDialog
@@1:	cmp	wparam, IDOK
	jne 	@@2
	call	CopyObject
@@2:	cmp	wparam, IDM_COPYCODE
	jne	@@3
	call	CopyObject
@@3:	cmp	wparam, IDM_OPEN
	jne 	@@4
	call	OpenDialog
@@4:	cmp	wparam, IDM_EXIT
	jne	@@5
	call	ExitProcess,0
@@5:	cmp	wparam, IDM_ABOUT
	jne	@@6
	call    DialogBoxParam, hInst, IDD_ABOUT, hMain, offset AboutDlg, 0
	
@@6:

defwndproc:
        call    DefWindowProc, hwnd, wmsg, wparam, lparam
        jmp     finish

finish:
        ret
WndProc          endp
;------------------------------------------------------------------------
OpenDialog	proc

	push	eax
; Fill OPENFILENAME Structure (OFN)
	mov	[OFN.on_lStructSize], OPENFILENAME_
	mov	eax, DWORD PTR [hMain]
	mov	[OFN.on_hwndOwner], eax
	mov    	eax, [hInst]
	mov	[OFN.on_hInstance], eax
	mov	[OFN.on_lpstrFilter], OFFSET Filter
	mov 	[OFN.on_lpstrFile], OFFSET szPathName
	mov	[OFN.on_nMaxFile], MAX_PATH-1
	mov 	[OFN.on_Flags], OFN_PATHMUSTEXIST+OFN_FILEMUSTEXIST + OFN_HIDEREADONLY
	call    GetOpenFileName, offset OFN
	cmp	eax, TRUE
	JNZ	EndOD
; Change EditBox text 
	call	SetWindowText, hEXE, offset szPathName

EndOD:
	pop	eax	
	ret

OpenDialog	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------
CopyObject		PROC
	pushad

; get szPathName from EditBox
	call	GetWindowText, hEXE, offset szPathName, MAX_PATH
; Create Memory Mapped File
	call	MakeMappedFile, LARGE 0, offset szPathName, NULL, NULL
	cmp 	eax, FALSE
	jz	EndCC

@CheckPE:
	mov	ExeFileAddr, eax			; ExeFileAddr = begining of file in memory
	call	MMGetFileSize, 0
	mov	FileSize, eax	
; Get some PE Header Parameters
	mov	eax, ExeFileAddr
	add	eax, 3Ch				; 3Ch = the place on .exe (MZ header) where we found the PEHeader offset
	mov	eax, dword ptr [eax]		
	cmp	eax, FileSize			; we dont wanna reference an invalid address (remember we are working with memory mapped file)
	jae	@NotPE
	add	eax, ExeFileAddr			; PEHeaderAddr=ExeFileADDr+PEHeaderOff
	mov	PEHeaderAddr, eax			; PEHeaderAddr = beggining of PE header in memory
 
; Check PE Signature
	cmp	dword ptr [eax], 00004550h
	jnz	@NotPE

; get EntryPoint Address
	mov	eax, PEHeaderAddr
	mov	eax, [eax+40d]
	mov	EntryPointRVA, eax
; get Object Table position
	mov	eax, PEHeaderAddr
	movzx	eax, word ptr [eax+20]	; get NTHeaderSize
	add	eax, 24			; aDD offset of Flag field
	add	eax, PEHeaderAddr
	mov	ObjTableAddr, eax
; get Number of Objects
	mov	eax, PEHeaderAddr
	movzx	eax, word ptr [eax+6]
	mov	NumObj, ax

; look for the object where AppEntryPoint is
	mov	esi, ObjTableAddr
	movzx	ecx, NumObj
ObjTableLoop:
	mov	edi, [esi+12]	; get RVA of the object

	cmp	edi, EntryPointRVA
	ja	@NextObject
	aDD	edi, [esi+8]	; add Virtual size to RVA

	cmp	edi, EntryPointRVA
	jbe	@NextObject
; object found
	mov	edx, EntryPointRVA
	sub	edx, [esi+12]	; edx = offset of the RVA from the begining of the object
	mov	eax, ExeFileAddr
	add	eax, [esi+20]	; esi+20  = physical offset of the code
	add	eax, edx
	mov	CodeOffset, eax
	mov	ecx, [esi+16]	; get physical size of object
	sub	ecx, edx
	mov 	BytesToCopy, ecx
	mov	ObjectName, esi
	jmp	@GetMini
@NextObject:
	add	esi, 40
	loop	ObjTableLoop
	jmp	@@EntryPointNotFound

; get Mini.bin from resources

@GetMini:
	call	FindResource, hInst, ID_MINI, PEHEADER
	call	LoadResource, hInst, eax
	call	LockResource, eax
	mov	MiniAddr, eax
;create HOST file path
	call	ExtractFilePath, offset szPathName, offset StrBuffer
	call	StrLen, offset StrBuffer
	mov	ecx, eax
	lea	edi, szHostPath
	lea	esi, StrBuffer
	cld
	rep	movsb
; copy host file name to hostpath
	lea	edi, szHostPath
	add 	edi, eax
	lea	esi, szHostFileName
	mov	ecx, 9
	cld
	rep 	movsb
	
; verify if HOST.EXE already exists
	call 	FindFirstFile, offset szHostPath, offset StrBuffer
	cmp	eax,  INVALID_HANDLE_VALUE
	jz	@CreateHost
	call	MessageBeep, 0FFFFFFFFh
	call	MessageBox, hMain, offset ErrorMsg3, offset szTitle, MB_YESNO
	cmp	eax, IDYES
	jnz	EndCC
; delete previous Host.exe
	call	DeleteFile, offset szHostFileName

@CreateHost:
; align Loader size to 512
	mov	eax, BytesToCopy
	mov 	ecx, 512
	xor	edx, edx
	div	ecx
	test	edx, edx
	jz	@@AlreadyFileAligned
	inc	eax
@@AlreadyFileAligned:
	mul 	ecx
	mov	AlignedCodeSize, eax

; Create Host.exe
	mov	eax, AlignedCodeSize
	add	eax, 512
	call	MakeMappedFile, 1, offset szHostPath, eax, OPEN_ALWAYS
	cmp 	eax, FALSE
	jz	EndCC
@CopyPEHeader:
	mov	HostExeFileAddr, eax
	mov	esi, MiniAddr
	mov	edi, HostExeFileAddr
	mov	ecx, 512
	cld
	rep	movsb

; adjust PEHeader params

	mov	edi, HostExeFileAddr	
	add	edi, HostPEHeaderOff		; edi = address of PE Header
	mov	eax, BytesToCopy
	mov	ecx, 1000h			; 1000h = Object Alignment
	xor	edx, edx
	div	ecx
	test	edx, edx
	jz	@@AlreadyObjAligned
	inc	eax
@@AlreadyObjAligned:
; adjust image size and code size
	mul	ecx
	mov	edx, eax			; edx will store Virtual size of Code to copy
	mov	[edi+28], eax			; eax = Code Size
	add	eax, 512
	mov	[edi+80], eax			; eax = Image Size = Code size + 512		

; adjust object table
	add	edi, HostObjTableOff-HostPEHeaderOff	; edi = Object Table address
	mov	dword ptr [edi+8], edx				; Virtual size
	mov	dword ptr [edi+12], 1000h				; RVA
	mov	eax, AlignedCodeSize
	mov	dword ptr [edi+16], eax				; physical size
	mov	dword ptr [edi+20], HostCodeOff			; physical offset
	mov	dword ptr [edi+36], 60000020h			; object flags

; copy code (loader)
	mov	esi, CodeOffset			
	mov	ecx, BytesToCopy
	mov	edi, HostCodeOff
	aDD	edi, HostExeFileAddr
	cld
	rep	movsb
; zero pad host.exe
	mov	ecx, AlignedCodeSize	; get size of host.exe
	sub	ecx, BytesToCopy	; sub code added
	xor 	eax, eax		; edi is already set from previous routine
	rep	stosb			; zero pad host's trailing

; change host object name
	mov 	esi, ObjectName
	mov	edi, HostExeFileAddr
	add	edi, HostObjTableOff
	mov	ecx, 8
	cld
	rep	movsb
; verify if we should adjust image base
	call	SendMessage, hIMAGE, BM_GETCHECK, 0,0
	cmp	eax, BST_CHECKED	; should adjust image base?
	jnz	@Success
; change Image Base 
	mov	eax, EntryPointRVA
	mov	ecx, PEHeaderAddr
	mov	ecx, [ecx+52]
	add	eax, ecx
	mov	ebx, HostExeFileAddr
	sub	eax, 1000h
	mov	[ebx+180], eax
@Success:
; show Final Message	
	mov	eax, AlignedCodeSize
	add	eax, 512
	call	wsprintf, offset StrBuffer, offset szMsgSuccess, eax, BytesToCopy, ObjectName 
	add	esp, 20
	call	MessageBox, hMain, offset StrBuffer, offset szTitle, MB_OK
	jmp	EndCC
;----------------------
@NotPE:
	call	ShowErrorMsg, offset ErrorMsg1
	jmp 	EndCC			
;----------------------
@@EntryPointNotFound:
	call	ShowErrorMsg, offset ErrorMsg2
	jmp	EndCC
;----------------------
EndCC:
	call	EndMappedFile, 00
	call	EndMappedFile, 01
	popad
	ret

CopyObject	ENDP
;------------------------------------------------------------------------


;-----------------------------------------------------------------------------
AboutDlg proc    hAbout:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
	cmp	wmsg, WM_INITDIALOG
	mov 	eax, TRUE
	jz	Return	
	cmp	wmsg, WM_COMMAND
	jnz	Default
	cmp	wparam, IDOK
	jz 	AboutEnd
	cmp	wparam, IDCANCEL
	jnz 	Default
AboutEnd:
	call	EndDialog, hAbout, TRUE
	mov	eax, TRUE
	jmp	Return
Default:
      	mov     eax, FALSE       
Return:
      ret                     
AboutDlg endp
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
ExtractFilePath 	PROC	Name:DWORD, Path:DWORD
	push	eax ebx ecx esi edi
	call	StrLen, Name
	mov	ebx, eax
	mov	ecx, eax
	mov	edi, Name
	mov	al, ' '
	repnz	scasb		; search for the first space character
	sub	ebx, ecx
	mov	ecx, ebx
	mov	al, '\'
	std
	repnz	scasb
	jz	SlashFound
	mov	ecx, ebx
	jmp	CopyPath
; copy path to buffer offset passed to the function
SlashFound:
	add	ecx, 2
CopyPath:
	mov	esi, Name
	mov	edi, Path
	cld
	rep 	movsb
	mov 	byte ptr [edi], 0
	pop	edi esi ecx ebx eax
	ret
ExtractFilePath		ENDP

;-----------------------------------------------------------------------------


;------------------------------------------------------------------------
AdjustCommandLine	PROC
	push	eax ecx esi edi
	call	GetCommandLine
; parse the command line - we want just the parameters
	mov	edi, eax
	call	StrLen, edi
	mov 	al,20h
	repnz 	scasb
	repz 	scasb
	test	ecx,ecx
	jz	EndGCL
	dec 	edi	

; adjust edit box text to command line parameter
	call	SetWindowText, hEXE, edi
	
EndGCL:
	pop	edi esi ecx eax
	ret
AdjustCommandLine	ENDP
;------------------------------------------------------------------------------


;-----------------------------------------------------------------------------
StrLen	PROC	StrOffset:DWORD
	push 	esi
	mov	esi,	StrOffset
	xor	eax, eax
@@LoopInit:
	cmp	byte ptr [esi],0
	jz	@FoundZero
	inc	eax
	inc 	esi
	jmp	@@LoopInit
@FoundZero:	
	pop	esi
	ret
StrLen	ENDP
;-----------------------------------------------------------------------------


ends
end start

