; Structs.inc, Revision 0.1
; ========================
;
; This is part of the NASM win32 Toolkit.
; This file should contain most Struct defintions used by Win32, it was
; converted from the win.h file supplied with LCC-WIN32.
; Because there are some C constructs that are hard to convert to NASM
; not all structs are present, some are missing and some are commented out,
; especially Structs containing Unions, This may be fixed in a future version.
; 
; This is a perliminary version, so i did not incorporate it into the main
; win32n.inc, although this file doesn't generate errors when included into
; an ASM file, it has not been fully checked. The idea is that until i verify
; this whole file ( and this may take a while. a long while. ), you should
; look here for structs not available in win32n.inc when needed, and copy 
; the prototype into your own code. I had to do this for lack of time.
; It's a compromise, on the one hand i don't want to convey the impression 
; that this is 100% usable, but on the other hand, I wanted to save as much
; time for you when coding, by supplying as comprehensive an include file 
; as possible.
; This was converted by a script, which did a fairly good job considering, 
; but i'm sure there are some errors in this, i may or may not get around to
; updating this in the future.
;
; WARNING: I STRONGLY recommend you verify any struct you use frm this file 
;          against another reference, or else you may  sneak some nasty bugs
;          into your code that might be very hard to track down. 
;          You have been Warned.
;
;
; Credit goes to the man behind LCC-WIN32 for making the original Header file.
;
; If you need to contact me, my e-mail is gij <at> bigfoot.com


MAX_PATH	equ 260

STRUC ABC
.abcA:            	 resd      	1	; int
.abcB:            	 resd      	1	; UINT
.abcC:            	 resd      	1	; int
ENDSTRUC

STRUC ABCFLOAT
.abcfA:           	 resd      	1	; FLOAT
.abcfB:           	 resd      	1	; FLOAT
.abcfC:           	 resd      	1	; FLOAT
ENDSTRUC

STRUC ACCEL
.fVirt:           	 resb      	1	; BYTE
.key:             	 resw      	1	; WORD
.cmd:             	 resw      	1	; WORD
ENDSTRUC

STRUC ACE_HEADER
.AceType:         	 resb      	1	; BYTE
.AceFlags:        	 resb      	1	; BYTE
.AceSize:         	 resw      	1	; WORD
ENDSTRUC

STRUC ACCESS_ALLOWED_ACE
; STRUC 'ACE_HEADER'
.Header.AceType   	 resb      	1	; BYTE
.Header.AceFlags  	 resb      	1	; BYTE
.Header.AceSize   	 resw      	1	; WORD
; ENDSTRUC 'ACE_HEADER'
.SidStart:        	 resd      	1	; DWORD
ENDSTRUC

STRUC ACCESS_DENIED_ACE
; STRUC 'ACE_HEADER'
.Header.AceType   	 resb      	1	; BYTE
.Header.AceFlags  	 resb      	1	; BYTE
.Header.AceSize   	 resw      	1	; WORD
; ENDSTRUC 'ACE_HEADER'
.SidStart:        	 resd      	1	; DWORD
ENDSTRUC

STRUC ACCESSTIMEOUT
.cbSize:          	 resd      	1	; UINT
.dwFlags:         	 resd      	1	; DWORD
.iTimeOutMSec:    	 resd      	1	; DWORD
ENDSTRUC

STRUC ACL
.AclRevision:     	 resb      	1	; BYTE
.Sbz1:            	 resb      	1	; BYTE
.AclSize:         	 resw      	1	; WORD
.AceCount:        	 resw      	1	; WORD
.Sbz2:            	 resw      	1	; WORD
ENDSTRUC

STRUC ACL_REVISION_INFORMATION
.AclRevision:     	 resd      	1	; DWORD
ENDSTRUC

STRUC ACL_SIZE_INFORMATION
.AceCount:        	 resd      	1	; DWORD
.AclBytesInUse:   	 resd      	1	; DWORD
.AclBytesFree:    	 resd      	1	; DWORD
ENDSTRUC

STRUC ACTION_HEADER
.transport_id:    	 resd      	1	; ULONG
.action_code:     	 resw      	1	; USHORT
.reserved:        	 resw      	1	; USHORT
ENDSTRUC

STRUC ADAPTER_STATUS
.adapter_address: 	 resb      	6	; UCHAR
.rev_major:       	 resb      	1	; UCHAR
.reserved0:       	 resb      	1	; UCHAR
.adapter_type:    	 resb      	1	; UCHAR
.rev_minor:       	 resb      	1	; UCHAR
.duration:        	 resw      	1	; WORD
.frmr_recv:       	 resw      	1	; WORD
.frmr_xmit:       	 resw      	1	; WORD
.iframe_recv_err: 	 resw      	1	; WORD
.xmit_aborts:     	 resw      	1	; WORD
.xmit_success:    	 resd      	1	; DWORD
.recv_success:    	 resd      	1	; DWORD
.iframe_xmit_err: 	 resw      	1	; WORD
.recv_buff_unavail:	 resw      	1	; WORD
.t1_timeouts:     	 resw      	1	; WORD
.ti_timeouts:     	 resw      	1	; WORD
.reserved1:       	 resd      	1	; DWORD
.free_ncbs:       	 resw      	1	; WORD
.max_cfg_ncbs:    	 resw      	1	; WORD
.max_ncbs:        	 resw      	1	; WORD
.xmit_buf_unavail:	 resw      	1	; WORD
.max_dgram_size:  	 resw      	1	; WORD
.pending_sess:    	 resw      	1	; WORD
.max_cfg_sess:    	 resw      	1	; WORD
.max_sess:        	 resw      	1	; WORD
.max_sess_pkt_size:	 resw      	1	; WORD
.name_count:      	 resw      	1	; WORD
ENDSTRUC

STRUC ADDJOB_INFO_1
.Path:            	 resd      	1	; LPTSTR
.JobId:           	 resd      	1	; DWORD
ENDSTRUC

STRUC ANIMATIONINFO
.cbSize:          	 resd      	1	; UINT
.iMinAnimate:     	 resd      	1	; int
ENDSTRUC

STRUC RECT
.left:            	 resd      	1	; LONG
.top:             	 resd      	1	; LONG
.right:           	 resd      	1	; LONG
.bottom:          	 resd      	1	; LONG
ENDSTRUC

STRUC RECTL
.left:            	 resd      	1	; LONG
.top:             	 resd      	1	; LONG
.right:           	 resd      	1	; LONG
.bottom:          	 resd      	1	; LONG
ENDSTRUC

STRUC BITMAP
.bmType:          	 resd      	1	; LONG
.bmWidth:         	 resd      	1	; LONG
.bmHeight:        	 resd      	1	; LONG
.bmWidthBytes:    	 resd      	1	; LONG
.bmPlanes:        	 resw      	1	; WORD
.bmBitsPixel:     	 resw      	1	; WORD
.bmBits:          	 resd      	1	; LPVOID
ENDSTRUC

STRUC BITMAPCOREHEADER
.bcSize:          	 resd      	1	; DWORD
.bcWidth:         	 resw      	1	; WORD
.bcHeight:        	 resw      	1	; WORD
.bcPlanes:        	 resw      	1	; WORD
.bcBitCount:      	 resw      	1	; WORD
ENDSTRUC

STRUC RGBTRIPLE
.rgbtBlue:        	 resb      	1	; BYTE
.rgbtGreen:       	 resb      	1	; BYTE
.rgbtRed:         	 resb      	1	; BYTE
ENDSTRUC

STRUC BITMAPCOREINFO
; STRUC 'BITMAPCOREHEADER'
.bmciHeader.bcSize	 resd      	1	; DWORD
.bmciHeader.bcWidth	 resw      	1	; WORD
.bmciHeader.bcHeight	 resw      	1	; WORD
.bmciHeader.bcPlanes	 resw      	1	; WORD
.bmciHeader.bcBitCount	 resw      	1	; WORD
; ENDSTRUC 'BITMAPCOREHEADER'
; STRUC 'RGBTRIPLE'
.bmciColors.rgbtBlue	 resb      	1	; BYTE
.bmciColors.rgbtGreen	 resb      	1	; BYTE
.bmciColors.rgbtRed	 resb      	1	; BYTE
; ENDSTRUC 'RGBTRIPLE'
ENDSTRUC

STRUC BITMAPFILEHEADER
.bfType:          	 resw      	1	; WORD
.bfSize:          	 resd      	1	; DWORD
.bfReserved1:     	 resw      	1	; WORD
.bfReserved2:     	 resw      	1	; WORD
.bfOffBits:       	 resd      	1	; DWORD
ENDSTRUC

STRUC BITMAPINFOHEADER
.biSize:          	 resd      	1	; DWORD
.biWidth:         	 resd      	1	; LONG
.biHeight:        	 resd      	1	; LONG
.biPlanes:        	 resw      	1	; WORD
.biBitCount:      	 resw      	1	; WORD
.biCompression:   	 resd      	1	; DWORD
.biSizeImage:     	 resd      	1	; DWORD
.biXPelsPerMeter: 	 resd      	1	; LONG
.biYPelsPerMeter: 	 resd      	1	; LONG
.biClrUsed:       	 resd      	1	; DWORD
.biClrImportant:  	 resd      	1	; DWORD
ENDSTRUC

STRUC RGBQUAD
.rgbBlue:         	 resb      	1	; BYTE
.rgbGreen:        	 resb      	1	; BYTE
.rgbRed:          	 resb      	1	; BYTE
.rgbReserved:     	 resb      	1	; BYTE
ENDSTRUC

STRUC BITMAPINFO
; STRUC 'BITMAPINFOHEADER'
.bmiHeader.biSize 	 resd      	1	; DWORD
.bmiHeader.biWidth	 resd      	1	; LONG
.bmiHeader.biHeight	 resd      	1	; LONG
.bmiHeader.biPlanes	 resw      	1	; WORD
.bmiHeader.biBitCount	 resw      	1	; WORD
.bmiHeader.biCompression	 resd      	1	; DWORD
.bmiHeader.biSizeImage	 resd      	1	; DWORD
.bmiHeader.biXPelsPerMeter	 resd      	1	; LONG
.bmiHeader.biYPelsPerMeter	 resd      	1	; LONG
.bmiHeader.biClrUsed	 resd      	1	; DWORD
.bmiHeader.biClrImportant	 resd      	1	; DWORD
; ENDSTRUC 'BITMAPINFOHEADER'
; STRUC 'RGBQUAD'
.bmiColors.rgbBlue	 resb      	1	; BYTE
.bmiColors.rgbGreen	 resb      	1	; BYTE
.bmiColors.rgbRed 	 resb      	1	; BYTE
.bmiColors.rgbReserved	 resb      	1	; BYTE
; ENDSTRUC 'RGBQUAD'
ENDSTRUC

STRUC CIEXYZ
.ciexyzX:         	 resd      	1	; FXPT2DOT30
.ciexyzY:         	 resd      	1	; FXPT2DOT30
.ciexyzZ:         	 resd      	1	; FXPT2DOT30
ENDSTRUC

STRUC CIEXYZTRIPLE
; STRUC 'CIEXYZ'
.ciexyzRed.ciexyzX	 resd      	1	; FXPT2DOT30
.ciexyzRed.ciexyzY	 resd      	1	; FXPT2DOT30
.ciexyzRed.ciexyzZ	 resd      	1	; FXPT2DOT30
; ENDSTRUC 'CIEXYZ'
; STRUC 'CIEXYZ'
.ciexyzGreen.ciexyzX	 resd      	1	; FXPT2DOT30
.ciexyzGreen.ciexyzY	 resd      	1	; FXPT2DOT30
.ciexyzGreen.ciexyzZ	 resd      	1	; FXPT2DOT30
; ENDSTRUC 'CIEXYZ'
; STRUC 'CIEXYZ'
.ciexyzBlue.ciexyzX	 resd      	1	; FXPT2DOT30
.ciexyzBlue.ciexyzY	 resd      	1	; FXPT2DOT30
.ciexyzBlue.ciexyzZ	 resd      	1	; FXPT2DOT30
; ENDSTRUC 'CIEXYZ'
ENDSTRUC

STRUC SHITEMID
.cb:              	 resw      	1	; USHORT
.abID:            	 resb      	1	; BYTE
ENDSTRUC

STRUC ITEMIDLIST
; STRUC 'SHITEMID'
.mkid.cb          	 resw      	1	; USHORT
.mkid.abID        	 resb      	1	; BYTE
; ENDSTRUC 'SHITEMID'
ENDSTRUC

STRUC browseinfo
.hwndOwner:       	 resd      	1	; HWND
.pszDisplayName:  	 resd      	1	; LPSTR
.lpszTitle:       	 resd      	1	; LPCSTR
.ulFlags:         	 resd      	1	; UINT
.lParam:          	 resd      	1	; LPARAM
.iImage:          	 resd      	1	; int
ENDSTRUC

STRUC FILETIME
.dwLowDateTime:   	 resd      	1	; DWORD
.dwHighDateTime:  	 resd      	1	; DWORD
ENDSTRUC

STRUC BY_HANDLE_FILE_INFORMATION
.dwFileAttributes:	 resd      	1	; DWORD
; STRUC 'FILETIME'
.ftCreationTime.dwLowDateTime	 resd      	1	; DWORD
.ftCreationTime.dwHighDateTime	 resd      	1	; DWORD
; ENDSTRUC 'FILETIME'
; STRUC 'FILETIME'
.ftLastAccessTime.dwLowDateTime	 resd      	1	; DWORD
.ftLastAccessTime.dwHighDateTime	 resd      	1	; DWORD
; ENDSTRUC 'FILETIME'
; STRUC 'FILETIME'
.ftLastWriteTime.dwLowDateTime	 resd      	1	; DWORD
.ftLastWriteTime.dwHighDateTime	 resd      	1	; DWORD
; ENDSTRUC 'FILETIME'
.dwVolumeSerialNumber:	 resd      	1	; DWORD
.nFileSizeHigh:   	 resd      	1	; DWORD
.nFileSizeLow:    	 resd      	1	; DWORD
.nNumberOfLinks:  	 resd      	1	; DWORD
.nFileIndexHigh:  	 resd      	1	; DWORD
.nFileIndexLow:   	 resd      	1	; DWORD
ENDSTRUC

STRUC FIXED
.fract:           	 resw      	1	; WORD
.value:           	 resw      	1	; short
ENDSTRUC

STRUC POINT
.x:               	 resd      	1	; LONG
.y:               	 resd      	1	; LONG
ENDSTRUC

STRUC POINTFX
; STRUC 'FIXED'
.x.fract          	 resw      	1	; WORD
.x.value          	 resw      	1	; short
; ENDSTRUC 'FIXED'
; STRUC 'FIXED'
.y.fract          	 resw      	1	; WORD
.y.value          	 resw      	1	; short
; ENDSTRUC 'FIXED'
ENDSTRUC

STRUC POINTL
.x:               	 resd      	1	; LONG
.y:               	 resd      	1	; LONG
ENDSTRUC

STRUC POINTS
.x:               	 resw      	1	; SHORT
.y:               	 resw      	1	; SHORT
ENDSTRUC

STRUC CANDIDATEFORM
.dwIndex:         	 resd      	1	; DWORD
.dwStyle:         	 resd      	1	; DWORD
; STRUC 'POINT'
.ptCurrentPos.x   	 resd      	1	; LONG
.ptCurrentPos.y   	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'RECT'
.rcArea.left      	 resd      	1	; LONG
.rcArea.top       	 resd      	1	; LONG
.rcArea.right     	 resd      	1	; LONG
.rcArea.bottom    	 resd      	1	; LONG
; ENDSTRUC 'RECT'
ENDSTRUC

STRUC CANDIDATELIST
.dwSize:          	 resd      	1	; DWORD
.dwStyle:         	 resd      	1	; DWORD
.dwCount:         	 resd      	1	; DWORD
.dwSelection:     	 resd      	1	; DWORD
.dwPageStart:     	 resd      	1	; DWORD
.dwPageSize:      	 resd      	1	; DWORD
.dwOffset:        	 resd      	1	; DWORD
ENDSTRUC

STRUC CREATESTRUCT
.lpCreateParams:  	 resd      	1	; LPVOID
.hInstance:       	 resd      	1	; HINSTANCE
.hMenu:           	 resd      	1	; HMENU
.hwndParent:      	 resd      	1	; HWND
.cy:              	 resd      	1	; int
.cx:              	 resd      	1	; int
.y:               	 resd      	1	; int
.x:               	 resd      	1	; int
.style:           	 resd      	1	; LONG
.lpszName:        	 resd      	1	; LPCTSTR
.lpszClass:       	 resd      	1	; LPCTSTR
.dwExStyle:       	 resd      	1	; DWORD
ENDSTRUC

STRUC CBT_CREATEWND
.hwndInsertAfter: 	 resd      	1	; HWND
ENDSTRUC

STRUC CBTACTIVATESTRUCT
.fMouse:          	 resd      	1	; BOOL
.hWndActive:      	 resd      	1	; HWND
ENDSTRUC

STRUC CHAR_INFO
; union
UnicodeChar:
AsciiChar:		 resb		2
; end of union
Attributes:		 resw		1

ENDSTRUC


STRUC charrange
.aflBlock:        	 resd      	3	; DWORD
.fsUsb:           	 resd      	4	; DWORD
;typedef struct {
.ciCharset:       	 resd      	1	; UINT
.ciACP:           	 resd      	1	; UINT
ENDSTRUC

STRUC LOGFONT
.lfHeight:        	 resd      	1	; LONG
.lfWidth:         	 resd      	1	; LONG
.lfEscapement:    	 resd      	1	; LONG
.lfOrientation:   	 resd      	1	; LONG
.lfWeight:        	 resd      	1	; LONG
.lfItalic:        	 resb      	1	; BYTE
.lfUnderline:     	 resb      	1	; BYTE
.lfStrikeOut:     	 resb      	1	; BYTE
.lfCharSet:       	 resb      	1	; BYTE
.lfOutPrecision:  	 resb      	1	; BYTE
.lfClipPrecision: 	 resb      	1	; BYTE
.lfQuality:       	 resb      	1	; BYTE
.lfPitchAndFamily:	 resb      	1	; BYTE
.lfFaceName:      	 resb      	0	; TCHAR
ENDSTRUC

STRUC IDA
.cidl:            	 resd      	1	; UINT
.aoffset:         	 resd      	1	; UINT
ENDSTRUC

STRUC CLIENTCREATESTRUCT
.hWindowMenu:     	 resd      	1	; HANDLE
.idFirstChild:    	 resd      	1	; UINT
ENDSTRUC

STRUC CMInvokeCommandInfo
.cbSize:          	 resd      	1	; DWORD
.fMask:           	 resd      	1	; DWORD
.hwnd:            	 resd      	1	; HWND
.lpVerb:          	 resd      	1	; LPCSTR
.lpParameters:    	 resd      	1	; LPCSTR
.lpDirectory:     	 resd      	1	; LPCSTR
.nShow:           	 resd      	1	; int
.dwHotKey:        	 resd      	1	; DWORD
.hIcon:           	 resd      	1	; HANDLE
ENDSTRUC

STRUC COLORADJUSTMENT
.caSize:          	 resw      	1	; WORD
.caFlags:         	 resw      	1	; WORD
.caIlluminantIndex:	 resw      	1	; WORD
.caRedGamma:      	 resw      	1	; WORD
.caGreenGamma:    	 resw      	1	; WORD
.caBlueGamma:     	 resw      	1	; WORD
.caReferenceBlack:	 resw      	1	; WORD
.caReferenceWhite:	 resw      	1	; WORD
.caContrast:      	 resw      	1	; SHORT
.caBrightness:    	 resw      	1	; SHORT
.caColorfulness:  	 resw      	1	; SHORT
.caRedGreenTint:  	 resw      	1	; SHORT
ENDSTRUC

STRUC COLORMAP
.from:            	 resd      	1	; COLORREF
.to:              	 resd      	1	; COLORREF
ENDSTRUC

STRUC DCB
.DCBlength:       	 resd      	1	; DWORD
.BaudRate:        	 resd      	1	; DWORD
.Flags			 resd		1	; 
	;	DWORD fBinary:1;
	;	DWORD fParity:1;
	;	DWORD fOutxCtsFlow:1;
	;	DWORD fOutxDsrFlow:1;
	;	DWORD fDtrControl:2;
	;	DWORD fDsrSensitivity:1;
	;	DWORD fTXContinueOnXoff:1;
	;	DWORD fOutX:1;
	;	DWORD fInX:1;
	;	DWORD fErrorChar:1;
	;	DWORD fNull:1;
	;	DWORD fRtsControl:2;
	;	DWORD fAbortOnError:1;
.wReserved:       	 resw      	1	; WORD
.XonLim:          	 resw      	1	; WORD
.XoffLim:         	 resw      	1	; WORD
.ByteSize:        	 resb      	1	; BYTE
.Parity:          	 resb      	1	; BYTE
.StopBits:        	 resb      	1	; BYTE
.XonChar:         	 resb      	1	; char
.XoffChar:        	 resb      	1	; char
.ErrorChar:       	 resb      	1	; char
.EofChar:         	 resb      	1	; char
.EvtChar:         	 resb      	1	; char
.wReserved1:      	 resw      	1	; WORD
ENDSTRUC

STRUC DECIMAL 
.wReserved 	 	 resw		1 
.scale 	 		 resb		1 
.sign		 	 resb		1
.Hi32:			 resd		1	; ULONG
.Lo64:			 resd		2	; __int64
ENDSTRUC

;typedef struct _COMM_CONFIG {
;.dwSize:          	 resd      	1	; DWORD
;.wVersion:        	 resw      	1	; WORD
;.wReserved:       	 resw      	1	; WORD
;; STRUC 'DCB'
;.dcb.DCBlength    	 resd      	1	; DWORD
;.dcb.BaudRate     	 resd      	1	; DWORD
;.dcb.wReserved    	 resw      	1	; WORD
;.dcb.XonLim       	 resw      	1	; WORD
;.dcb.XoffLim      	 resw      	1	; WORD
;.dcb.ByteSize     	 resb      	1	; BYTE
;.dcb.Parity       	 resb      	1	; BYTE
;.dcb.StopBits     	 resb      	1	; BYTE
;.dcb.XonChar      	 resb      	1	; char
;.dcb.XoffChar     	 resb      	1	; char
;.dcb.ErrorChar    	 resb      	1	; char
;.dcb.EofChar      	 resb      	1	; char
;.dcb.EvtChar      	 resb      	1	; char
;.dcb.wReserved1   	 resw      	1	; WORD
;; ENDSTRUC 'DCB'
;.dwProviderSubType:	 resd      	1	; DWORD
;.dwProviderOffset:	 resd      	1	; DWORD
;.dwProviderSize:  	 resd      	1	; DWORD
;.wcProviderData:  	 resw      	1	; WCHAR
;ENDSTRUC

STRUC COMMPROP
.wPacketLength:   	 resw      	1	; WORD
.wPacketVersion:  	 resw      	1	; WORD
.dwServiceMask:   	 resd      	1	; DWORD
.dwReserved1:     	 resd      	1	; DWORD
.dwMaxTxQueue:    	 resd      	1	; DWORD
.dwMaxRxQueue:    	 resd      	1	; DWORD
.dwMaxBaud:       	 resd      	1	; DWORD
.dwProvSubType:   	 resd      	1	; DWORD
.dwProvCapabilities:	 resd      	1	; DWORD
.dwSettableParams:	 resd      	1	; DWORD
.dwSettableBaud:  	 resd      	1	; DWORD
.wSettableData:   	 resw      	1	; WORD
.wSettableStopParity:	 resw      	1	; WORD
.dwCurrentTxQueue:	 resd      	1	; DWORD
.dwCurrentRxQueue:	 resd      	1	; DWORD
.dwProvSpec1:     	 resd      	1	; DWORD
.dwProvSpec2:     	 resd      	1	; DWORD
.wcProvChar:      	 resw      	1	; WCHAR
ENDSTRUC

STRUC COMMTIMEOUTS
.ReadIntervalTimeout:	 resd      	1	; DWORD
.ReadTotalTimeoutMultiplier:	 resd      	1	; DWORD
.ReadTotalTimeoutConstant:	 resd      	1	; DWORD
.WriteTotalTimeoutMultiplier:	 resd      	1	; DWORD
.WriteTotalTimeoutConstant:	 resd      	1	; DWORD
ENDSTRUC

STRUC COMPAREITEMSTRUCT
.CtlType:         	 resd      	1	; UINT
.CtlID:           	 resd      	1	; UINT
.hwndItem:        	 resd      	1	; HWND
.itemID1:         	 resd      	1	; UINT
.itemData1:       	 resd      	1	; DWORD
.itemID2:         	 resd      	1	; UINT
.itemData2:       	 resd      	1	; DWORD
ENDSTRUC

STRUC COMPOSITIONFORM
.dwStyle:         	 resd      	1	; DWORD
; STRUC 'POINT'
.ptCurrentPos.x   	 resd      	1	; LONG
.ptCurrentPos.y   	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'RECT'
.rcArea.left      	 resd      	1	; LONG
.rcArea.top       	 resd      	1	; LONG
.rcArea.right     	 resd      	1	; LONG
.rcArea.bottom    	 resd      	1	; LONG
; ENDSTRUC 'RECT'
ENDSTRUC

STRUC COMSTAT
.Flags			 resd		1
;	DWORD fCtsHold:1;
;	DWORD fDsrHold:1;
;	DWORD fRlsdHold:1;
;	DWORD fXoffHold:1;
;	DWORD fXoffSent:1;
;	DWORD fEof:1;
;	DWORD fTxim:1;
;        DWORD fReserved:25;
.cbInQue:         	 resd      	1	; DWORD
.cbOutQue:        	 resd      	1	; DWORD
ENDSTRUC

STRUC CONSOLE_CURSOR_INFO
.dwSize:          	 resd      	1	; DWORD
.bVisible:        	 resd      	1	; BOOL
ENDSTRUC

STRUC COORD
.X:               	 resw      	1	; SHORT
.Y:               	 resw      	1	; SHORT
ENDSTRUC

STRUC SMALL_RECT
.Left:            	 resw      	1	; SHORT
.Top:             	 resw      	1	; SHORT
.Right:           	 resw      	1	; SHORT
.Bottom:          	 resw      	1	; SHORT
ENDSTRUC

STRUC CONSOLE_SCREEN_BUFFER_INFO
; STRUC 'COORD'
.dwSize.X         	 resw      	1	; SHORT
.dwSize.Y         	 resw      	1	; SHORT
; ENDSTRUC 'COORD'
; STRUC 'COORD'
.dwCursorPosition.X	 resw      	1	; SHORT
.dwCursorPosition.Y	 resw      	1	; SHORT
; ENDSTRUC 'COORD'
.wAttributes:     	 resw      	1	; WORD
; STRUC 'SMALL_RECT'
.srWindow.Left    	 resw      	1	; SHORT
.srWindow.Top     	 resw      	1	; SHORT
.srWindow.Right   	 resw      	1	; SHORT
.srWindow.Bottom  	 resw      	1	; SHORT
; ENDSTRUC 'SMALL_RECT'
; STRUC 'COORD'
.dwMaximumWindowSize.X	 resw      	1	; SHORT
.dwMaximumWindowSize.Y	 resw      	1	; SHORT
; ENDSTRUC 'COORD'
ENDSTRUC

STRUC FLOATING_SAVE_AREA
.ControlWord:     	 resd      	1	; DWORD
.StatusWord:      	 resd      	1	; DWORD
.TagWord:         	 resd      	1	; DWORD
.ErrorOffset:     	 resd      	1	; DWORD
.ErrorSelector:   	 resd      	1	; DWORD
.DataOffset:      	 resd      	1	; DWORD
.DataSelector:    	 resd      	1	; DWORD
.RegisterArea:    	 resb      	80	; BYTE
.Cr0NpxState:     	 resd      	1	; DWORD
ENDSTRUC

STRUC CONTEXT
.ContextFlags:    	 resd      	1	; DWORD
.Dr0:             	 resd      	1	; DWORD
.Dr1:             	 resd      	1	; DWORD
.Dr2:             	 resd      	1	; DWORD
.Dr3:             	 resd      	1	; DWORD
.Dr6:             	 resd      	1	; DWORD
.Dr7:             	 resd      	1	; DWORD
; STRUC 'FLOATING_SAVE_AREA'
.FloatSave.ControlWord	 resd      	1	; DWORD
.FloatSave.StatusWord	 resd      	1	; DWORD
.FloatSave.TagWord	 resd      	1	; DWORD
.FloatSave.ErrorOffset	 resd      	1	; DWORD
.FloatSave.ErrorSelector	 resd      	1	; DWORD
.FloatSave.DataOffset	 resd      	1	; DWORD
.FloatSave.DataSelector	 resd      	1	; DWORD
.FloatSave.RegisterArea	 resb      	80	; BYTE
.FloatSave.Cr0NpxState	 resd      	1	; DWORD
; ENDSTRUC 'FLOATING_SAVE_AREA'
.SegGs:           	 resd      	1	; DWORD
.SegFs:           	 resd      	1	; DWORD
.SegEs:           	 resd      	1	; DWORD
.SegDs:           	 resd      	1	; DWORD
.Edi:             	 resd      	1	; DWORD
.Esi:             	 resd      	1	; DWORD
.Ebx:             	 resd      	1	; DWORD
.Edx:             	 resd      	1	; DWORD
.Ecx:             	 resd      	1	; DWORD
.Eax:             	 resd      	1	; DWORD
.Ebp:             	 resd      	1	; DWORD
.Eip:             	 resd      	1	; DWORD
.SegCs:           	 resd      	1	; DWORD
.EFlags:          	 resd      	1	; DWORD
.Esp:             	 resd      	1	; DWORD
.SegSs:           	 resd      	1	; DWORD
ENDSTRUC

STRUC LIST_ENTRY
ENDSTRUC

STRUC CRITICAL_SECTION_DEBUG
.Type:            	 resw      	1	; WORD
.CreatorBackTraceIndex:	 resw      	1	; WORD
; STRUC 'LIST_ENTRY'
; ENDSTRUC 'LIST_ENTRY'
.EntryCount:      	 resd      	1	; DWORD
.ContentionCount: 	 resd      	1	; DWORD
.Depth:           	 resd      	1	; DWORD
.OwnerBackTrace:  	 resd      	5	; PVOID
ENDSTRUC

STRUC CRITICAL_SECTION
.LockCount:       	 resd      	1	; LONG
.RecursionCount:  	 resd      	1	; LONG
.OwningThread:    	 resd      	1	; HANDLE
.LockSemaphore:   	 resd      	1	; HANDLE
.Reserved:        	 resd      	1	; DWORD
ENDSTRUC

STRUC SECURITY_QUALITY_OF_SERVICE
.Length:          	 resd      	1	; DWORD
.ContextTrackingMode:	 resd      	1	; BOOL
ENDSTRUC

STRUC CONVCONTEXT
.cb:              	 resd      	1	; UINT
.wFlags:          	 resd      	1	; UINT
.wCountryID:      	 resd      	1	; UINT
.iCodePage:       	 resd      	1	; int
.dwLangID:        	 resd      	1	; DWORD
.dwSecurity:      	 resd      	1	; DWORD
; STRUC 'SECURITY_QUALITY_OF_SERVICE'
.qos.Length       	 resd      	1	; DWORD
.qos.ContextTrackingMode resd      	1	; BOOL
; ENDSTRUC 'SECURITY_QUALITY_OF_SERVICE'
ENDSTRUC

STRUC CONVINFO
.cb:              	 resd      	1	; DWORD
.hUser:           	 resd      	1	; DWORD
.hszSvcPartner:   	 resd      	1	; HSZ
.hszServiceReq:   	 resd      	1	; HSZ
.hszTopic:        	 resd      	1	; HSZ
.hszItem:         	 resd      	1	; HSZ
.wFmt:            	 resd      	1	; UINT
.wType:           	 resd      	1	; UINT
.wStatus:         	 resd      	1	; UINT
.wConvst:         	 resd      	1	; UINT
.wLastError:      	 resd      	1	; UINT
; STRUC 'CONVCONTEXT'
.ConvCtxt.cb      	 resd      	1	; UINT
.ConvCtxt.wFlags  	 resd      	1	; UINT
.ConvCtxt.wCountryID	 resd      	1	; UINT
.ConvCtxt.iCodePage	 resd      	1	; int
.ConvCtxt.dwLangID	 resd      	1	; DWORD
.ConvCtxt.dwSecurity	 resd      	1	; DWORD
.ConvCtxt.qos.Length	 resd      	1	; DWORD
.ConvCtxt.qos.ContextTrackingMode	 resd      	1	; BOOL
; ENDSTRUC 'CONVCONTEXT'
.hwnd:            	 resd      	1	; HWND
.hwndPartner:     	 resd      	1	; HWND
ENDSTRUC

STRUC COPYDATASTRUCT
.dwData:          	 resd      	1	; DWORD
.cbData:          	 resd      	1	; DWORD
.lpData:          	 resd      	1	; PVOID
ENDSTRUC

STRUC cpinfo
.MaxCharSize:     	 resd      	1	; UINT
.DefaultChar:     	 resb      	0	; BYTE
.LeadByte:        	 resb      	0	; BYTE
ENDSTRUC

STRUC CPLINFO
.idIcon:          	 resd      	1	; int
.idName:          	 resd      	1	; int
.idInfo:          	 resd      	1	; int
.lData:           	 resd      	1	; LONG
ENDSTRUC

STRUC CREATE_PROCESS_DEBUG_INFO
.hFile:           	 resd      	1	; HANDLE
.hProcess:        	 resd      	1	; HANDLE
.hThread:         	 resd      	1	; HANDLE
.lpBaseOfImage:   	 resd      	1	; LPVOID
.dwDebugInfoFileOffset:	 resd      	1	; DWORD
.nDebugInfoSize:  	 resd      	1	; DWORD
.lpThreadLocalBase:	 resd      	1	; LPVOID
.lpImageName:     	 resd      	1	; LPVOID
.fUnicode:        	 resw      	1	; WORD
ENDSTRUC

STRUC CREATE_THREAD_DEBUG_INFO
.hThread:         	 resd      	1	; HANDLE
.lpThreadLocalBase:	 resd      	1	; LPVOID
ENDSTRUC

STRUC currencyfmt
.NumDigits:       	 resd      	1	; UINT
.LeadingZero:     	 resd      	1	; UINT
.Grouping:        	 resd      	1	; UINT
.lpDecimalSep:    	 resd      	1	; LPTSTR
.lpThousandSep:   	 resd      	1	; LPTSTR
.NegativeOrder:   	 resd      	1	; UINT
.PositiveOrder:   	 resd      	1	; UINT
.lpCurrencySymbol:	 resd      	1	; LPTSTR
ENDSTRUC

STRUC CURSORSHAPE
.xHotSpot:        	 resd      	1	; int
.yHotSpot:        	 resd      	1	; int
.cx:              	 resd      	1	; int
.cy:              	 resd      	1	; int
.cbWidth:         	 resd      	1	; int
.Planes:          	 resb      	1	; BYTE
.BitsPixel:       	 resb      	1	; BYTE
ENDSTRUC

STRUC CWPRETSTRUCT
.lParam:          	 resd      	1	; LPARAM
.wParam:          	 resd      	1	; WPARAM
.message:         	 resd      	1	; DWORD
.hwnd:            	 resd      	1	; HWND
ENDSTRUC

STRUC CWPSTRUCT
.lParam:          	 resd      	1	; LPARAM
.wParam:          	 resd      	1	; WPARAM
.message:         	 resd      	1	; UINT
.hwnd:            	 resd      	1	; HWND
ENDSTRUC

STRUC DATATYPES_INFO_1
.pName:           	 resd      	1	; LPTSTR
ENDSTRUC

STRUC DDEML_MSG_HOOK_DATA
.uiLo:            	 resd      	1	; UINT
.uiHi:            	 resd      	1	; UINT
.cbData:          	 resd      	1	; DWORD
.Data:            	 resd      	8	; DWORD
ENDSTRUC

STRUC EXCEPTION_RECORD
.ExceptionCode:   	 resd      	1	; DWORD
.ExceptionFlags:  	 resd      	1	; DWORD
.ExceptionAddress:	 resd      	1	; PVOID
.NumberParameters:	 resd      	1	; DWORD
.ExceptionInformation:	 resd      	0	; DWORD
ENDSTRUC

STRUC EXCEPTION_DEBUG_INFO
; STRUC 'EXCEPTION_RECORD'
.ExceptionRecord.ExceptionCode	 resd      	1	; DWORD
.ExceptionRecord.ExceptionFlags	 resd      	1	; DWORD
.ExceptionRecord.ExceptionAddress	 resd      	1	; PVOID
.ExceptionRecord.NumberParameters	 resd      	1	; DWORD
.ExceptionRecord.ExceptionInformation	 resd      	0	; DWORD
; ENDSTRUC 'EXCEPTION_RECORD'
.dwFirstChance:   	 resd      	1	; DWORD
ENDSTRUC

STRUC EXIT_PROCESS_DEBUG_INFO
.dwExitCode:      	 resd      	1	; DWORD
ENDSTRUC

STRUC EXIT_THREAD_DEBUG_INFO
.dwExitCode:      	 resd      	1	; DWORD
ENDSTRUC

STRUC LOAD_DLL_DEBUG_INFO
.hFile:           	 resd      	1	; HANDLE
.lpBaseOfDll:     	 resd      	1	; LPVOID
.dwDebugInfoFileOffset:	 resd      	1	; DWORD
.nDebugInfoSize:  	 resd      	1	; DWORD
.lpImageName:     	 resd      	1	; LPVOID
.fUnicode:        	 resw      	1	; WORD
ENDSTRUC

STRUC UNLOAD_DLL_DEBUG_INFO
.lpBaseOfDll:     	 resd      	1	; LPVOID
ENDSTRUC

STRUC OUTPUT_DEBUG_STRING_INFO
.lpDebugStringData:	 resd      	1	; LPSTR
.fUnicode:        	 resw      	1	; WORD
.nDebugStringLength:	 resw      	1	; WORD
ENDSTRUC

STRUC RIP_INFO
.dwError:         	 resd      	1	; DWORD
.dwType:          	 resd      	1	; DWORD
ENDSTRUC

;STRUC DEBUG_EVENT
;.dwDebugEventCode:	 resd      	1	; DWORD
;.dwProcessId:     	 resd      	1	; DWORD
;.dwThreadId:      	 resd      	1	; DWORD
;	union {
; STRUC 'EXCEPTION_DEBUG_INFO'
;.Exception.ExceptionRecord.ExceptionCode	 resd      	1	; DWORD
;.Exception.ExceptionRecord.ExceptionFlags	 resd      	1	; DWORD
;.Exception.ExceptionRecord.ExceptionAddress	 resd      	1	; PVOID
;.Exception.ExceptionRecord.NumberParameters	 resd      	1	; DWORD
;.Exception.ExceptionRecord.ExceptionInformation	 resd      	0	; DWORD
;.Exception.dwFirstChance	 resd      	1	; DWORD
; ENDSTRUC 'EXCEPTION_DEBUG_INFO'
; STRUC 'CREATE_THREAD_DEBUG_INFO'
;.CreateThread.hThread	 resd      	1	; HANDLE
;.CreateThread.lpThreadLocalBase	 resd      	1	; LPVOID
; ENDSTRUC 'CREATE_THREAD_DEBUG_INFO'
; STRUC 'CREATE_PROCESS_DEBUG_INFO'
;.CreateProcessInfo.hFile	 resd      	1	; HANDLE
;.CreateProcessInfo.hProcess	 resd      	1	; HANDLE
;.CreateProcessInfo.hThread	 resd      	1	; HANDLE
;.CreateProcessInfo.lpBaseOfImage	 resd      	1	; LPVOID
;.CreateProcessInfo.dwDebugInfoFileOffset resd      	1	; DWORD
;.CreateProcessInfo.nDebugInfoSize	 resd      	1	; DWORD
;.CreateProcessInfo.lpThreadLocalBase	 resd      	1	; LPVOID
;.CreateProcessInfo.lpImageName	 resd      	1	; LPVOID
;.CreateProcessInfo.fUnicode	 resw      	1	; WORD
;; ENDSTRUC 'CREATE_PROCESS_DEBUG_INFO'
; STRUC 'EXIT_THREAD_DEBUG_INFO'
;.ExitThread.dwExitCode	 	 resd      	1	; DWORD
; ENDSTRUC 'EXIT_THREAD_DEBUG_INFO'
; STRUC 'EXIT_PROCESS_DEBUG_INFO'
;.ExitProcess.dwExitCode	 	 resd      	1	; DWORD
; ENDSTRUC 'EXIT_PROCESS_DEBUG_INFO'
; STRUC 'LOAD_DLL_DEBUG_INFO'
;.LoadDll.hFile    	 	 resd      	1	; HANDLE
;.LoadDll.lpBaseOfDll	 	 resd      	1	; LPVOID
;.LoadDll.dwDebugInfoFileOffset	 resd      	1	; DWORD
;.LoadDll.nDebugInfoSize	 resd      	1	; DWORD
;.LoadDll.lpImageName	 resd      	1	; LPVOID
;.LoadDll.fUnicode 	 resw      	1	; WORD
;; ENDSTRUC 'LOAD_DLL_DEBUG_INFO'
; STRUC 'UNLOAD_DLL_DEBUG_INFO'
;.UnloadDll.lpBaseOfDll	 resd      	1	; LPVOID
; ENDSTRUC 'UNLOAD_DLL_DEBUG_INFO'
; STRUC 'OUTPUT_DEBUG_STRING_INFO'
;.DebugString.lpDebugStringData	 resd      	1	; LPSTR
;.DebugString.fUnicode	 resw      	1	; WORD
;.DebugString.nDebugStringLength	 resw      	1	; WORD
; ENDSTRUC 'OUTPUT_DEBUG_STRING_INFO'
; STRUC 'RIP_INFO'
;.RipInfo.dwError  	 resd      	1	; DWORD
;.RipInfo.dwType   	 resd      	1	; DWORD
; ENDSTRUC 'RIP_INFO'
;	} u;
;ENDSTRUC

STRUC DEBUGHOOKINFO
.idThread:        	 resd      	1	; DWORD
.idThreadInstaller:	 resd      	1	; DWORD
.lParam:          	 resd      	1	; LPARAM
.wParam:          	 resd      	1	; WPARAM
.code:            	 resd      	1	; int
ENDSTRUC

STRUC DELETEITEMSTRUCT
.CtlType:         	 resd      	1	; UINT
.CtlID:           	 resd      	1	; UINT
.itemID:          	 resd      	1	; UINT
.hwndItem:        	 resd      	1	; HWND
.itemData:        	 resd      	1	; UINT
ENDSTRUC

STRUC DEV_BROADCAST_HDR
.dbch_size:       	 resd      	1	; ULONG
.dbch_devicetype: 	 resd      	1	; ULONG
.dbch_reserved:   	 resd      	1	; ULONG
ENDSTRUC

STRUC DEV_BROADCAST_OEM
.dbco_size:       	 resd      	1	; ULONG
.dbco_devicetype: 	 resd      	1	; ULONG
.dbco_reserved:   	 resd      	1	; ULONG
.dbco_identifier: 	 resd      	1	; ULONG
.dbco_suppfunc:   	 resd      	1	; ULONG
ENDSTRUC

STRUC DEV_BROADCAST_PORT
.dbcp_size:       	 resd      	1	; ULONG
.dbcp_devicetype: 	 resd      	1	; ULONG
.dbcp_reserved:   	 resd      	1	; ULONG
.dbcp_name:       	 resb      	1	; char
ENDSTRUC

STRUC DEV_BROADCAST_USERDEFINED
.dbud_szName:     	 resb      	1	; char
.dbud_rgbUserDefined:	 resb      	1	; BYTE
ENDSTRUC

STRUC DEV_BROADCAST_VOLUME
.dbcv_size:       	 resd      	1	; ULONG
.dbcv_devicetype: 	 resd      	1	; ULONG
.dbcv_reserved:   	 resd      	1	; ULONG
.dbcv_unitmask:   	 resd      	1	; ULONG
.dbcv_flags:      	 resw      	1	; USHORT
ENDSTRUC

STRUC devicemode
.dmSpecVersion:   	 resw      	1	; WORD
.dmDriverVersion: 	 resw      	1	; WORD
.dmSize:          	 resw      	1	; WORD
.dmDriverExtra:   	 resw      	1	; WORD
.dmFields:        	 resd      	1	; DWORD
.dmOrientation:   	 resw      	1	; short
.dmPaperSize:     	 resw      	1	; short
.dmPaperLength:   	 resw      	1	; short
.dmPaperWidth:    	 resw      	1	; short
.dmScale:         	 resw      	1	; short
.dmCopies:        	 resw      	1	; short
.dmDefaultSource: 	 resw      	1	; short
.dmPrintQuality:  	 resw      	1	; short
.dmColor:         	 resw      	1	; short
.dmDuplex:        	 resw      	1	; short
.dmYResolution:   	 resw      	1	; short
.dmTTOption:      	 resw      	1	; short
.dmCollate:       	 resw      	1	; short
.dmLogPixels:     	 resw      	1	; WORD
.dmBitsPerPel:    	 resd      	1	; DWORD
.dmPelsWidth:     	 resd      	1	; DWORD
.dmPelsHeight:    	 resd      	1	; DWORD
.dmDisplayFlags:  	 resd      	1	; DWORD
.dmDisplayFrequency:	 resd      	1	; DWORD
.dmICMMethod:     	 resd      	1	; DWORD
.dmICMIntent:     	 resd      	1	; DWORD
.dmMediaType:     	 resd      	1	; DWORD
.dmDitherType:    	 resd      	1	; DWORD
.dmICCManufacturer:	 resd      	1	; DWORD
.dmICCModel:      	 resd      	1	; DWORD
ENDSTRUC

STRUC DEVNAMES
.wDriverOffset:   	 resw      	1	; WORD
.wDeviceOffset:   	 resw      	1	; WORD
.wOutputOffset:   	 resw      	1	; WORD
.wDefault:        	 resw      	1	; WORD
ENDSTRUC

STRUC DIBSECTION
; STRUC 'BITMAP'
.dsBm.bmType      	 resd      	1	; LONG
.dsBm.bmWidth     	 resd      	1	; LONG
.dsBm.bmHeight    	 resd      	1	; LONG
.dsBm.bmWidthBytes	 resd      	1	; LONG
.dsBm.bmPlanes    	 resw      	1	; WORD
.dsBm.bmBitsPixel 	 resw      	1	; WORD
.dsBm.bmBits      	 resd      	1	; LPVOID
; ENDSTRUC 'BITMAP'
; STRUC 'BITMAPINFOHEADER'
.dsBmih.biSize    	 resd      	1	; DWORD
.dsBmih.biWidth   	 resd      	1	; LONG
.dsBmih.biHeight  	 resd      	1	; LONG
.dsBmih.biPlanes  	 resw      	1	; WORD
.dsBmih.biBitCount	 resw      	1	; WORD
.dsBmih.biCompression	 resd      	1	; DWORD
.dsBmih.biSizeImage	 resd      	1	; DWORD
.dsBmih.biXPelsPerMeter	 resd      	1	; LONG
.dsBmih.biYPelsPerMeter	 resd      	1	; LONG
.dsBmih.biClrUsed 	 resd      	1	; DWORD
.dsBmih.biClrImportant	 resd      	1	; DWORD
; ENDSTRUC 'BITMAPINFOHEADER'
.dsBitfields:     	 resd      	3	; DWORD
.dshSection:      	 resd      	1	; HANDLE
.dsOffset:        	 resd      	1	; DWORD
ENDSTRUC

STRUC DOC_INFO_1
.pDocName:        	 resd      	1	; LPTSTR
.pOutputFile:     	 resd      	1	; LPTSTR
.pDatatype:       	 resd      	1	; LPTSTR
ENDSTRUC

STRUC DOC_INFO_2
.pDocName:        	 resd      	1	; LPTSTR
.pOutputFile:     	 resd      	1	; LPTSTR
.pDatatype:       	 resd      	1	; LPTSTR
.dwMode:          	 resd      	1	; DWORD
.JobId:           	 resd      	1	; DWORD
ENDSTRUC

STRUC DRAWITEMSTRUCT
.CtlType:         	 resd      	1	; UINT
.CtlID:           	 resd      	1	; UINT
.itemID:          	 resd      	1	; UINT
.itemAction:      	 resd      	1	; UINT
.itemState:       	 resd      	1	; UINT
.hwndItem:        	 resd      	1	; HWND
; STRUC 'RECT'
.rcItem.left      	 resd      	1	; LONG
.rcItem.top       	 resd      	1	; LONG
.rcItem.right     	 resd      	1	; LONG
.rcItem.bottom    	 resd      	1	; LONG
; ENDSTRUC 'RECT'
.itemData:        	 resd      	1	; DWORD
ENDSTRUC

STRUC DRIVER_INFO_1
.pName:           	 resd      	1	; LPTSTR
ENDSTRUC

STRUC DRIVER_INFO_2
.cVersion:        	 resd      	1	; DWORD
.pName:           	 resd      	1	; LPTSTR
.pEnvironment:    	 resd      	1	; LPTSTR
.pDriverPath:     	 resd      	1	; LPTSTR
.pDataFile:       	 resd      	1	; LPTSTR
.pConfigFile:     	 resd      	1	; LPTSTR
ENDSTRUC

STRUC DRIVER_INFO_3
.cVersion:        	 resd      	1	; DWORD
.pName:           	 resd      	1	; LPTSTR
.pEnvironment:    	 resd      	1	; LPTSTR
.pDriverPath:     	 resd      	1	; LPTSTR
.pDataFile:       	 resd      	1	; LPTSTR
.pConfigFile:     	 resd      	1	; LPTSTR
.pHelpFile:       	 resd      	1	; LPTSTR
.pDependentFiles: 	 resd      	1	; LPTSTR
.pMonitorName:    	 resd      	1	; LPTSTR
.pDefaultDataType:	 resd      	1	; LPTSTR
ENDSTRUC

STRUC editstream
.dwCookie:        	 resd      	1	; DWORD
.dwError:         	 resd      	1	; DWORD
ENDSTRUC

STRUC EMR
.iType:           	 resd      	1	; DWORD
.nSize:           	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRANGLEARC
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'POINTL'
.ptlCenter.x      	 resd      	1	; LONG
.ptlCenter.y      	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
.nRadius:         	 resd      	1	; DWORD
.eStartAngle:     	 resd      	1	; FLOAT
.eSweepAngle:     	 resd      	1	; FLOAT
ENDSTRUC

STRUC EMRARC
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBox.left      	 resd      	1	; LONG
.rclBox.top       	 resd      	1	; LONG
.rclBox.right     	 resd      	1	; LONG
.rclBox.bottom    	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
; STRUC 'POINTL'
.ptlStart.x       	 resd      	1	; LONG
.ptlStart.y       	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
; STRUC 'POINTL'
.ptlEnd.x         	 resd      	1	; LONG
.ptlEnd.y         	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
ENDSTRUC

STRUC XFORM
.eM11:            	 resd      	1	; FLOAT
.eM12:            	 resd      	1	; FLOAT
.eM21:            	 resd      	1	; FLOAT
.eM22:            	 resd      	1	; FLOAT
.eDx:             	 resd      	1	; FLOAT
.eDy:             	 resd      	1	; FLOAT
ENDSTRUC

STRUC EMRBITBLT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.xDest:           	 resd      	1	; LONG
.yDest:           	 resd      	1	; LONG
.cxDest:          	 resd      	1	; LONG
.cyDest:          	 resd      	1	; LONG
.dwRop:           	 resd      	1	; DWORD
.xSrc:            	 resd      	1	; LONG
.ySrc:            	 resd      	1	; LONG
; STRUC 'XFORM'
.xformSrc.eM11    	 resd      	1	; FLOAT
.xformSrc.eM12    	 resd      	1	; FLOAT
.xformSrc.eM21    	 resd      	1	; FLOAT
.xformSrc.eM22    	 resd      	1	; FLOAT
.xformSrc.eDx     	 resd      	1	; FLOAT
.xformSrc.eDy     	 resd      	1	; FLOAT
; ENDSTRUC 'XFORM'
.crBkColorSrc:    	 resd      	1	; COLORREF
.iUsageSrc:       	 resd      	1	; DWORD
.offBmiSrc:       	 resd      	1	; DWORD
.offBitsSrc:      	 resd      	1	; DWORD
.cbBitsSrc:       	 resd      	1	; DWORD
ENDSTRUC

STRUC LOGBRUSH
.lbStyle:         	 resd      	1	; UINT
.lbColor:         	 resd      	1	; COLORREF
.lbHatch:         	 resd      	1	; LONG
ENDSTRUC

STRUC EMRCREATEBRUSHINDIRECT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihBrush:         	 resd      	1	; DWORD
; STRUC 'LOGBRUSH'
.lb.lbStyle       	 resd      	1	; UINT
.lb.lbColor       	 resd      	1	; COLORREF
.lb.lbHatch       	 resd      	1	; LONG
; ENDSTRUC 'LOGBRUSH'
ENDSTRUC

STRUC LOGCOLORSPACE
.lcsSignature:    	 resd      	1	; DWORD
.lcsVersion:      	 resd      	1	; DWORD
.lcsSize:         	 resd      	1	; DWORD
; STRUC 'CIEXYZTRIPLE'
; ENDSTRUC 'CIEXYZTRIPLE'
.lcsGammaRed:     	 resd      	1	; DWORD
.lcsGammaGreen:   	 resd      	1	; DWORD
.lcsGammaBlue:    	 resd      	1	; DWORD
.lcsFilename:     	 resb      	0	; TCHAR
ENDSTRUC

STRUC EMRCREATECOLORSPACE
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihCS:            	 resd      	1	; DWORD
; STRUC 'LOGCOLORSPACE'
.lcs.lcsSignature 	 resd      	1	; DWORD
.lcs.lcsVersion   	 resd      	1	; DWORD
.lcs.lcsSize      	 resd      	1	; DWORD
.lcs.lcsEndpoints.ciexyzRed.ciexyzX	 resd 1	; FXPT2DOT30
.lcs.lcsEndpoints.ciexyzRed.ciexyzY	 resd 1	; FXPT2DOT30
.lcs.lcsEndpoints.ciexyzRed.ciexyzZ	 resd 1	; FXPT2DOT30
.lcs.lcsEndpoints.ciexyzGreen.ciexyzX	 resd 1	; FXPT2DOT30
.lcs.lcsEndpoints.ciexyzGreen.ciexyzY	 resd 1	; FXPT2DOT30
.lcs.lcsEndpoints.ciexyzGreen.ciexyzZ	 resd 1	; FXPT2DOT30
.lcs.lcsEndpoints.ciexyzBlue.ciexyzX	 resd 1	; FXPT2DOT30
.lcs.lcsEndpoints.ciexyzBlue.ciexyzY	 resd 1	; FXPT2DOT30
.lcs.lcsEndpoints.ciexyzBlue.ciexyzZ	 resd 1	; FXPT2DOT30
.lcs.lcsGammaRed  	 resd      	1	; DWORD
.lcs.lcsGammaGreen	 resd      	1	; DWORD
.lcs.lcsGammaBlue 	 resd      	1	; DWORD
.lcs.lcsFilename  	 resb      	MAX_PATH ; TCHAR
; ENDSTRUC 'LOGCOLORSPACE'
ENDSTRUC

STRUC EMRCREATEDIBPATTERNBRUSHPT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihBrush:         	 resd      	1	; DWORD
.iUsage:          	 resd      	1	; DWORD
.offBmi:          	 resd      	1	; DWORD
.cbBmi:           	 resd      	1	; DWORD
.offBits:         	 resd      	1	; DWORD
.cbBits:          	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRCREATEMONOBRUSH
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihBrush:         	 resd      	1	; DWORD
.iUsage:          	 resd      	1	; DWORD
.offBmi:          	 resd      	1	; DWORD
.cbBmi:           	 resd      	1	; DWORD
.offBits:         	 resd      	1	; DWORD
.cbBits:          	 resd      	1	; DWORD
ENDSTRUC

STRUC PALETTEENTRY
.peRed:           	 resb      	1	; BYTE
.peGreen:         	 resb      	1	; BYTE
.peBlue:          	 resb      	1	; BYTE
.peFlags:         	 resb      	1	; BYTE
ENDSTRUC

STRUC LOGPALETTE
.palVersion:      	 resw      	1	; WORD
.palNumEntries:   	 resw      	1	; WORD
; STRUC 'PALETTEENTRY'
.palPalEntry.peRed	 resb      	1	; BYTE
.palPalEntry.peGreen	 resb      	1	; BYTE
.palPalEntry.peBlue	 resb      	1	; BYTE
.palPalEntry.peFlags	 resb      	1	; BYTE
; ENDSTRUC 'PALETTEENTRY'
ENDSTRUC

STRUC EMRCREATEPALETTE
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihPal:           	 resd      	1	; DWORD
; STRUC 'LOGPALETTE'
.lgpl.palVersion  	 resw      	1	; WORD
.lgpl.palNumEntries	 resw      	1	; WORD
.lgpl.palPalEntry.peRed	 resb      	1	; BYTE
.lgpl.palPalEntry.peGreen	 resb      	1	; BYTE
.lgpl.palPalEntry.peBlue	 resb      	1	; BYTE
.lgpl.palPalEntry.peFlags	 resb      	1	; BYTE
; ENDSTRUC 'LOGPALETTE'
ENDSTRUC

STRUC LOGPEN
.lopnStyle:       	 resd      	1	; UINT
; STRUC 'POINT'
.lopnWidth.x      	 resd      	1	; LONG
.lopnWidth.y      	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.lopnColor:       	 resd      	1	; COLORREF
ENDSTRUC

STRUC EMRCREATEPEN
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihPen:           	 resd      	1	; DWORD
; STRUC 'LOGPEN'
.lopn.lopnStyle   	 resd      	1	; UINT
.lopn.lopnWidth.x 	 resd      	1	; LONG
.lopn.lopnWidth.y 	 resd      	1	; LONG
.lopn.lopnColor   	 resd      	1	; COLORREF
; ENDSTRUC 'LOGPEN'
ENDSTRUC

STRUC EMRELLIPSE
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBox.left      	 resd      	1	; LONG
.rclBox.top       	 resd      	1	; LONG
.rclBox.right     	 resd      	1	; LONG
.rclBox.bottom    	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
ENDSTRUC

STRUC EMREOF
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.nPalEntries:     	 resd      	1	; DWORD
.offPalEntries:   	 resd      	1	; DWORD
.nSizeLast:       	 resd      	1	; DWORD
ENDSTRUC

STRUC EMREXCLUDECLIPRECT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclClip.left     	 resd      	1	; LONG
.rclClip.top      	 resd      	1	; LONG
.rclClip.right    	 resd      	1	; LONG
.rclClip.bottom   	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
ENDSTRUC

STRUC PANOSE
.bFamilyType:     	 resb      	1	; BYTE
.bSerifStyle:     	 resb      	1	; BYTE
.bWeight:         	 resb      	1	; BYTE
.bProportion:     	 resb      	1	; BYTE
.bContrast:       	 resb      	1	; BYTE
.bStrokeVariation:	 resb      	1	; BYTE
.bArmStyle:       	 resb      	1	; BYTE
.bLetterform:     	 resb      	1	; BYTE
.bMidline:        	 resb      	1	; BYTE
.bXHeight:        	 resb      	1	; BYTE
ENDSTRUC

STRUC EXTLOGFONT
; STRUC 'LOGFONT'
.elfLogFont.lfHeight	 resd      	1	; LONG
.elfLogFont.lfWidth	 resd      	1	; LONG
.elfLogFont.lfEscapement	 resd      	1	; LONG
.elfLogFont.lfOrientation	 resd      	1	; LONG
.elfLogFont.lfWeight	 resd      	1	; LONG
.elfLogFont.lfItalic	 resb      	1	; BYTE
.elfLogFont.lfUnderline	 resb      	1	; BYTE
.elfLogFont.lfStrikeOut	 resb      	1	; BYTE
.elfLogFont.lfCharSet	 resb      	1	; BYTE
.elfLogFont.lfOutPrecision	 resb      	1	; BYTE
.elfLogFont.lfClipPrecision	 resb      	1	; BYTE
.elfLogFont.lfQuality	 resb      	1	; BYTE
.elfLogFont.lfPitchAndFamily	 resb      	1	; BYTE
.elfLogFont.lfFaceName	 resb      	0	; TCHAR
; ENDSTRUC 'LOGFONT'
.elfVersion:      	 resd      	1	; DWORD
.elfStyleSize:    	 resd      	1	; DWORD
.elfMatch:        	 resd      	1	; DWORD
.elfReserved:     	 resd      	1	; DWORD
.elfVendorId:     	 resb      	0	; BYTE
.elfCulture:      	 resd      	1	; DWORD
; STRUC 'PANOSE'
.elfPanose.bFamilyType	 resb      	1	; BYTE
.elfPanose.bSerifStyle	 resb      	1	; BYTE
.elfPanose.bWeight	 resb      	1	; BYTE
.elfPanose.bProportion	 resb      	1	; BYTE
.elfPanose.bContrast	 resb      	1	; BYTE
.elfPanose.bStrokeVariation	 resb      	1	; BYTE
.elfPanose.bArmStyle	 resb      	1	; BYTE
.elfPanose.bLetterform	 resb      	1	; BYTE
.elfPanose.bMidline	 resb      	1	; BYTE
.elfPanose.bXHeight	 resb      	1	; BYTE
; ENDSTRUC 'PANOSE'
ENDSTRUC

STRUC EMREXTCREATEFONTINDIRECTW
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihFont:          	 resd      	1	; DWORD
; STRUC 'EXTLOGFONT'
.elfw.elfLogFont.lfHeight	 resd      	1	; LONG
.elfw.elfLogFont.lfWidth	 resd      	1	; LONG
.elfw.elfLogFont.lfEscapement	 resd      	1	; LONG
.elfw.elfLogFont.lfOrientation	 resd      	1	; LONG
.elfw.elfLogFont.lfWeight	 resd      	1	; LONG
.elfw.elfLogFont.lfItalic	 resb      	1	; BYTE
.elfw.elfLogFont.lfUnderline	 resb      	1	; BYTE
.elfw.elfLogFont.lfStrikeOut	 resb      	1	; BYTE
.elfw.elfLogFont.lfCharSet	 resb      	1	; BYTE
.elfw.elfLogFont.lfOutPrecision	 resb      	1	; BYTE
.elfw.elfLogFont.lfClipPrecision	 resb      	1	; BYTE
.elfw.elfLogFont.lfQuality	 resb      	1	; BYTE
.elfw.elfLogFont.lfPitchAndFamily	 resb      	1	; BYTE
.elfw.elfLogFont.lfFaceName	 resb      	0	; TCHAR
.elfw.elfVersion  	 resd      	1	; DWORD
.elfw.elfStyleSize	 resd      	1	; DWORD
.elfw.elfMatch    	 resd      	1	; DWORD
.elfw.elfReserved 	 resd      	1	; DWORD
.elfw.elfVendorId 	 resb      	0	; BYTE
.elfw.elfCulture  	 resd      	1	; DWORD
.elfw.elfPanose.bFamilyType	 resb      	1	; BYTE
.elfw.elfPanose.bSerifStyle	 resb      	1	; BYTE
.elfw.elfPanose.bWeight	 resb      	1	; BYTE
.elfw.elfPanose.bProportion	 resb      	1	; BYTE
.elfw.elfPanose.bContrast	 resb      	1	; BYTE
.elfw.elfPanose.bStrokeVariation	 resb      	1	; BYTE
.elfw.elfPanose.bArmStyle	 resb      	1	; BYTE
.elfw.elfPanose.bLetterform	 resb      	1	; BYTE
.elfw.elfPanose.bMidline	 resb      	1	; BYTE
.elfw.elfPanose.bXHeight	 resb      	1	; BYTE
; ENDSTRUC 'EXTLOGFONT'
ENDSTRUC

STRUC EXTLOGPEN
.elpPenStyle:     	 resd      	1	; UINT
.elpWidth:        	 resd      	1	; UINT
.elpBrushStyle:   	 resd      	1	; UINT
.elpColor:        	 resd      	1	; COLORREF
.elpHatch:        	 resd      	1	; LONG
.elpNumEntries:   	 resd      	1	; DWORD
.elpStyleEntry:   	 resd      	1	; DWORD
ENDSTRUC

STRUC EMREXTCREATEPEN
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihPen:           	 resd      	1	; DWORD
.offBmi:          	 resd      	1	; DWORD
.cbBmi:           	 resd      	1	; DWORD
.offBits:         	 resd      	1	; DWORD
.cbBits:          	 resd      	1	; DWORD
; STRUC 'EXTLOGPEN'
.elp.elpPenStyle  	 resd      	1	; UINT
.elp.elpWidth     	 resd      	1	; UINT
.elp.elpBrushStyle	 resd      	1	; UINT
.elp.elpColor     	 resd      	1	; COLORREF
.elp.elpHatch     	 resd      	1	; LONG
.elp.elpNumEntries	 resd      	1	; DWORD
.elp.elpStyleEntry	 resd      	1	; DWORD
; ENDSTRUC 'EXTLOGPEN'
ENDSTRUC

STRUC EMREXTFLOODFILL
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'POINTL'
.ptlStart.x       	 resd      	1	; LONG
.ptlStart.y       	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
.crColor:         	 resd      	1	; COLORREF
.iMode:           	 resd      	1	; DWORD
ENDSTRUC

STRUC EMREXTSELECTCLIPRGN
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.cbRgnData:       	 resd      	1	; DWORD
.iMode:           	 resd      	1	; DWORD
.RgnData:         	 resb      	1	; BYTE
ENDSTRUC

STRUC EMRTEXT
; STRUC 'POINTL'
.ptlReference.x   	 resd      	1	; LONG
.ptlReference.y   	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
.nChars:          	 resd      	1	; DWORD
.offString:       	 resd      	1	; DWORD
.fOptions:        	 resd      	1	; DWORD
; STRUC 'RECTL'
.rcl.left         	 resd      	1	; LONG
.rcl.top          	 resd      	1	; LONG
.rcl.right        	 resd      	1	; LONG
.rcl.bottom       	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.offDx:           	 resd      	1	; DWORD
ENDSTRUC

STRUC EMREXTTEXTOUTA
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.iGraphicsMode:   	 resd      	1	; DWORD
.exScale:         	 resd      	1	; FLOAT
.eyScale:         	 resd      	1	; FLOAT
; STRUC 'EMRTEXT'
.emrtext.ptlReference.x	 resd      	1	; LONG
.emrtext.ptlReference.y	 resd      	1	; LONG
.emrtext.nChars   	 resd      	1	; DWORD
.emrtext.offString	 resd      	1	; DWORD
.emrtext.fOptions 	 resd      	1	; DWORD
.emrtext.rcl.left 	 resd      	1	; LONG
.emrtext.rcl.top  	 resd      	1	; LONG
.emrtext.rcl.right	 resd      	1	; LONG
.emrtext.rcl.bottom	 resd      	1	; LONG
.emrtext.offDx    	 resd      	1	; DWORD
; ENDSTRUC 'EMRTEXT'
ENDSTRUC

STRUC EMRFILLPATH
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
ENDSTRUC

STRUC EMRFILLRGN
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.cbRgnData:       	 resd      	1	; DWORD
.ihBrush:         	 resd      	1	; DWORD
.RgnData:         	 resb      	1	; BYTE
ENDSTRUC

STRUC EMRFORMAT
.dSignature:      	 resd      	1	; DWORD
.nVersion:        	 resd      	1	; DWORD
.cbData:          	 resd      	1	; DWORD
.offData:         	 resd      	1	; DWORD
ENDSTRUC

STRUC SIZE
.cx:              	 resd      	1	; LONG
.cy:              	 resd      	1	; LONG
ENDSTRUC

STRUC EMRFRAMERGN
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.cbRgnData:       	 resd      	1	; DWORD
.ihBrush:         	 resd      	1	; DWORD
.RgnData:         	 resb      	1	; BYTE
ENDSTRUC

STRUC EMRGDICOMMENT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.cbData:          	 resd      	1	; DWORD
.Data:            	 resb      	1	; BYTE
ENDSTRUC

STRUC EMRINVERTRGN
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.cbRgnData:       	 resd      	1	; DWORD
.RgnData:         	 resb      	1	; BYTE
ENDSTRUC

STRUC EMRLINETO
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'POINTL'
.ptl.x            	 resd      	1	; LONG
.ptl.y            	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
ENDSTRUC

STRUC EMRMASKBLT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.xDest:           	 resd      	1	; LONG
.yDest:           	 resd      	1	; LONG
.cxDest:          	 resd      	1	; LONG
.cyDest:          	 resd      	1	; LONG
.dwRop:           	 resd      	1	; DWORD
.xSrc:            	 resd      	1	; LONG
.ySrc:            	 resd      	1	; LONG
; STRUC 'XFORM'
.xformSrc.eM11    	 resd      	1	; FLOAT
.xformSrc.eM12    	 resd      	1	; FLOAT
.xformSrc.eM21    	 resd      	1	; FLOAT
.xformSrc.eM22    	 resd      	1	; FLOAT
.xformSrc.eDx     	 resd      	1	; FLOAT
.xformSrc.eDy     	 resd      	1	; FLOAT
; ENDSTRUC 'XFORM'
.crBkColorSrc:    	 resd      	1	; COLORREF
.iUsageSrc:       	 resd      	1	; DWORD
.offBmiSrc:       	 resd      	1	; DWORD
.cbBmiSrc:        	 resd      	1	; DWORD
.offBitsSrc:      	 resd      	1	; DWORD
.cbBitsSrc:       	 resd      	1	; DWORD
.xMask:           	 resd      	1	; LONG
.yMask:           	 resd      	1	; LONG
.iUsageMask:      	 resd      	1	; DWORD
.offBmiMask:      	 resd      	1	; DWORD
.cbBmiMask:       	 resd      	1	; DWORD
.offBitsMask:     	 resd      	1	; DWORD
.cbBitsMask:      	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRMODIFYWORLDTRANSFORM
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'XFORM'
.xform.eM11       	 resd      	1	; FLOAT
.xform.eM12       	 resd      	1	; FLOAT
.xform.eM21       	 resd      	1	; FLOAT
.xform.eM22       	 resd      	1	; FLOAT
.xform.eDx        	 resd      	1	; FLOAT
.xform.eDy        	 resd      	1	; FLOAT
; ENDSTRUC 'XFORM'
.iMode:           	 resd      	1	; DWORD
ENDSTRUC

STRUC EMROFFSETCLIPRGN
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'POINTL'
.ptlOffset.x      	 resd      	1	; LONG
.ptlOffset.y      	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
ENDSTRUC

STRUC EMRPLGBLT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
; STRUC 'POINTL'
.aptlDest.x       	 resd      	1	; LONG
.aptlDest.y       	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
.xSrc:            	 resd      	1	; LONG
.ySrc:            	 resd      	1	; LONG
.cxSrc:           	 resd      	1	; LONG
.cySrc:           	 resd      	1	; LONG
; STRUC 'XFORM'
.xformSrc.eM11    	 resd      	1	; FLOAT
.xformSrc.eM12    	 resd      	1	; FLOAT
.xformSrc.eM21    	 resd      	1	; FLOAT
.xformSrc.eM22    	 resd      	1	; FLOAT
.xformSrc.eDx     	 resd      	1	; FLOAT
.xformSrc.eDy     	 resd      	1	; FLOAT
; ENDSTRUC 'XFORM'
.crBkColorSrc:    	 resd      	1	; COLORREF
.iUsageSrc:       	 resd      	1	; DWORD
.offBmiSrc:       	 resd      	1	; DWORD
.cbBmiSrc:        	 resd      	1	; DWORD
.offBitsSrc:      	 resd      	1	; DWORD
.cbBitsSrc:       	 resd      	1	; DWORD
.xMask:           	 resd      	1	; LONG
.yMask:           	 resd      	1	; LONG
.iUsageMask:      	 resd      	1	; DWORD
.offBmiMask:      	 resd      	1	; DWORD
.cbBmiMask:       	 resd      	1	; DWORD
.offBitsMask:     	 resd      	1	; DWORD
.cbBitsMask:      	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRPOLYDRAW
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.cptl:            	 resd      	1	; DWORD
; STRUC 'POINTL'
.aptl.x           	 resd      	1	; LONG
.aptl.y           	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
.abTypes:         	 resb      	1	; BYTE
ENDSTRUC

STRUC EMRPOLYDRAW16
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.cpts:            	 resd      	1	; DWORD
; STRUC 'POINTS'
.apts.x           	 resw      	1	; SHORT
.apts.y           	 resw      	1	; SHORT
; ENDSTRUC 'POINTS'
.abTypes:         	 resb      	1	; BYTE
ENDSTRUC

STRUC EMRPOLYLINE
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.cptl:            	 resd      	1	; DWORD
; STRUC 'POINTL'
.aptl.x           	 resd      	1	; LONG
.aptl.y           	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
ENDSTRUC

STRUC EMRPOLYLINE16
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.cpts:            	 resd      	1	; DWORD
; STRUC 'POINTL'
.apts.x           	 resd      	1	; LONG
.apts.y           	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
ENDSTRUC

STRUC EMRPOLYPOLYLINE
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.nPolys:          	 resd      	1	; DWORD
.cptl:            	 resd      	1	; DWORD
.aPolyCounts:     	 resd      	1	; DWORD
; STRUC 'POINTL'
.aptl.x           	 resd      	1	; LONG
.aptl.y           	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
ENDSTRUC

STRUC EMRPOLYPOLYLINE16
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.nPolys:          	 resd      	1	; DWORD
.cpts:            	 resd      	1	; DWORD
.aPolyCounts:     	 resd      	1	; DWORD
; STRUC 'POINTS'
.apts.x           	 resw      	1	; SHORT
.apts.y           	 resw      	1	; SHORT
; ENDSTRUC 'POINTS'
ENDSTRUC

STRUC EMRPOLYTEXTOUTA
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.iGraphicsMode:   	 resd      	1	; DWORD
.exScale:         	 resd      	1	; FLOAT
.eyScale:         	 resd      	1	; FLOAT
.cStrings:        	 resd      	1	; LONG
; STRUC 'EMRTEXT'
.aemrtext.ptlReference.x	 resd      	1	; LONG
.aemrtext.ptlReference.y	 resd      	1	; LONG
.aemrtext.nChars  	 resd      	1	; DWORD
.aemrtext.offString	 resd      	1	; DWORD
.aemrtext.fOptions	 resd      	1	; DWORD
.aemrtext.rcl.left	 resd      	1	; LONG
.aemrtext.rcl.top 	 resd      	1	; LONG
.aemrtext.rcl.right	 resd      	1	; LONG
.aemrtext.rcl.bottom	 resd      	1	; LONG
.aemrtext.offDx   	 resd      	1	; DWORD
; ENDSTRUC 'EMRTEXT'
ENDSTRUC

STRUC EMRRESIZEPALETTE
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihPal:           	 resd      	1	; DWORD
.cEntries:        	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRRESTOREDC
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.iRelative:       	 resd      	1	; LONG
ENDSTRUC

STRUC EMRROUNDRECT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBox.left      	 resd      	1	; LONG
.rclBox.top       	 resd      	1	; LONG
.rclBox.right     	 resd      	1	; LONG
.rclBox.bottom    	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
ENDSTRUC

STRUC EMRSCALEVIEWPORTEXTEX
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.xNum:            	 resd      	1	; LONG
.xDenom:          	 resd      	1	; LONG
.yNum:            	 resd      	1	; LONG
.yDenom:          	 resd      	1	; LONG
ENDSTRUC

STRUC EMRSELECTCOLORSPACE
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihCS:            	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRSELECTOBJECT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihObject:        	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRSELECTPALETTE
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihPal:           	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRSETARCDIRECTION
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.iArcDirection:   	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRSETTEXTCOLOR
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.crColor:         	 resd      	1	; COLORREF
ENDSTRUC

STRUC EMRSETCOLORADJUSTMENT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'COLORADJUSTMENT'
.ColorAdjustment.caSize	 resw      	1	; WORD
.ColorAdjustment.caFlags	 resw      	1	; WORD
.ColorAdjustment.caIlluminantIndex	 resw      	1	; WORD
.ColorAdjustment.caRedGamma	 resw      	1	; WORD
.ColorAdjustment.caGreenGamma	 resw      	1	; WORD
.ColorAdjustment.caBlueGamma	 resw      	1	; WORD
.ColorAdjustment.caReferenceBlack	 resw      	1	; WORD
.ColorAdjustment.caReferenceWhite	 resw      	1	; WORD
.ColorAdjustment.caContrast	 resw      	1	; SHORT
.ColorAdjustment.caBrightness	 resw      	1	; SHORT
.ColorAdjustment.caColorfulness	 resw      	1	; SHORT
.ColorAdjustment.caRedGreenTint	 resw      	1	; SHORT
; ENDSTRUC 'COLORADJUSTMENT'
ENDSTRUC

STRUC EMRSETDIBITSTODEVICE
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.xDest:           	 resd      	1	; LONG
.yDest:           	 resd      	1	; LONG
.xSrc:            	 resd      	1	; LONG
.ySrc:            	 resd      	1	; LONG
.cxSrc:           	 resd      	1	; LONG
.cySrc:           	 resd      	1	; LONG
.offBmiSrc:       	 resd      	1	; DWORD
.cbBmiSrc:        	 resd      	1	; DWORD
.offBitsSrc:      	 resd      	1	; DWORD
.cbBitsSrc:       	 resd      	1	; DWORD
.iUsageSrc:       	 resd      	1	; DWORD
.iStartScan:      	 resd      	1	; DWORD
.cScans:          	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRSETMAPPERFLAGS
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.dwFlags:         	 resd      	1	; DWORD
ENDSTRUC

STRUC EMRSETMITERLIMIT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.eMiterLimit:     	 resd      	1	; FLOAT
ENDSTRUC

STRUC EMRSETPALETTEENTRIES
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.ihPal:           	 resd      	1	; DWORD
.iStart:          	 resd      	1	; DWORD
.cEntries:        	 resd      	1	; DWORD
; STRUC 'PALETTEENTRY'
.aPalEntries.peRed	 resb      	1	; BYTE
.aPalEntries.peGreen	 resb      	1	; BYTE
.aPalEntries.peBlue	 resb      	1	; BYTE
.aPalEntries.peFlags	 resb      	1	; BYTE
; ENDSTRUC 'PALETTEENTRY'
ENDSTRUC

STRUC EMRSETPIXELV
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'POINTL'
.ptlPixel.x       	 resd      	1	; LONG
.ptlPixel.y       	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
.crColor:         	 resd      	1	; COLORREF
ENDSTRUC

STRUC EMRSETVIEWPORTEXTEX
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
ENDSTRUC

STRUC EMRSETVIEWPORTORGEX
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'POINTL'
.ptlOrigin.x      	 resd      	1	; LONG
.ptlOrigin.y      	 resd      	1	; LONG
; ENDSTRUC 'POINTL'
ENDSTRUC

STRUC EMRSETWORLDTRANSFORM
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'XFORM'
.xform.eM11       	 resd      	1	; FLOAT
.xform.eM12       	 resd      	1	; FLOAT
.xform.eM21       	 resd      	1	; FLOAT
.xform.eM22       	 resd      	1	; FLOAT
.xform.eDx        	 resd      	1	; FLOAT
.xform.eDy        	 resd      	1	; FLOAT
; ENDSTRUC 'XFORM'
ENDSTRUC

STRUC EMRSTRETCHBLT
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.xDest:           	 resd      	1	; LONG
.yDest:           	 resd      	1	; LONG
.cxDest:          	 resd      	1	; LONG
.cyDest:          	 resd      	1	; LONG
.dwRop:           	 resd      	1	; DWORD
.xSrc:            	 resd      	1	; LONG
.ySrc:            	 resd      	1	; LONG
; STRUC 'XFORM'
.xformSrc.eM11    	 resd      	1	; FLOAT
.xformSrc.eM12    	 resd      	1	; FLOAT
.xformSrc.eM21    	 resd      	1	; FLOAT
.xformSrc.eM22    	 resd      	1	; FLOAT
.xformSrc.eDx     	 resd      	1	; FLOAT
.xformSrc.eDy     	 resd      	1	; FLOAT
; ENDSTRUC 'XFORM'
.crBkColorSrc:    	 resd      	1	; COLORREF
.iUsageSrc:       	 resd      	1	; DWORD
.offBmiSrc:       	 resd      	1	; DWORD
.cbBmiSrc:        	 resd      	1	; DWORD
.offBitsSrc:      	 resd      	1	; DWORD
.cbBitsSrc:       	 resd      	1	; DWORD
.cxSrc:           	 resd      	1	; LONG
.cySrc:           	 resd      	1	; LONG
ENDSTRUC

STRUC EMRSTRETCHDIBITS
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.xDest:           	 resd      	1	; LONG
.yDest:           	 resd      	1	; LONG
.xSrc:            	 resd      	1	; LONG
.ySrc:            	 resd      	1	; LONG
.cxSrc:           	 resd      	1	; LONG
.cySrc:           	 resd      	1	; LONG
.offBmiSrc:       	 resd      	1	; DWORD
.cbBmiSrc:        	 resd      	1	; DWORD
.offBitsSrc:      	 resd      	1	; DWORD
.cbBitsSrc:       	 resd      	1	; DWORD
.iUsageSrc:       	 resd      	1	; DWORD
.dwRop:           	 resd      	1	; DWORD
.cxDest:          	 resd      	1	; LONG
.cyDest:          	 resd      	1	; LONG
ENDSTRUC

STRUC ABORTPATH
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
ENDSTRUC

STRUC EMRSELECTCLIPPATH
; STRUC 'EMR'
.emr.iType        	 resd      	1	; DWORD
.emr.nSize        	 resd      	1	; DWORD
; ENDSTRUC 'EMR'
.iMode:           	 resd      	1	; DWORD
ENDSTRUC

STRUC NMHDR
.hwndFrom:        	 resd      	1	; HWND
.idFrom:          	 resd      	1	; UINT
.code:            	 resd      	1	; UINT
ENDSTRUC

STRUC encorrecttext
; STRUC 'NMHDR'
.nmhdr.hwndFrom   	 resd      	1	; HWND
.nmhdr.idFrom     	 resd      	1	; UINT
.nmhdr.code       	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
; STRUC 'CHARRANGE'
.chrg.aflBlock    	 resd      	3	; DWORD
.chrg.fsUsb       	 resd      	4	; DWORD
.chrg.ciCharset   	 resd      	1	; UINT
.chrg.ciACP       	 resd      	1	; UINT
; ENDSTRUC 'CHARRANGE'
.seltyp:          	 resw      	1	; WORD
ENDSTRUC

STRUC endropfiles
; STRUC 'NMHDR'
.nmhdr.hwndFrom   	 resd      	1	; HWND
.nmhdr.idFrom     	 resd      	1	; UINT
.nmhdr.code       	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.hDrop:           	 resd      	1	; HANDLE
.cp:              	 resd      	1	; LONG
.fProtected:      	 resd      	1	; BOOL
ENDSTRUC

STRUC ENHMETAHEADER
.iType:           	 resd      	1	; DWORD
.nSize:           	 resd      	1	; DWORD
; STRUC 'RECTL'
.rclBounds.left   	 resd      	1	; LONG
.rclBounds.top    	 resd      	1	; LONG
.rclBounds.right  	 resd      	1	; LONG
.rclBounds.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
; STRUC 'RECTL'
.rclFrame.left    	 resd      	1	; LONG
.rclFrame.top     	 resd      	1	; LONG
.rclFrame.right   	 resd      	1	; LONG
.rclFrame.bottom  	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
.dSignature:      	 resd      	1	; DWORD
.nVersion:        	 resd      	1	; DWORD
.nBytes:          	 resd      	1	; DWORD
.nRecords:        	 resd      	1	; DWORD
.nHandles:        	 resw      	1	; WORD
.sReserved:       	 resw      	1	; WORD
.nDescription:    	 resd      	1	; DWORD
.offDescription:  	 resd      	1	; DWORD
.nPalEntries:     	 resd      	1	; DWORD
ENDSTRUC

STRUC ENHMETARECORD
.iType:           	 resd      	1	; DWORD
.nSize:           	 resd      	1	; DWORD
.dParm:           	 resd      	1	; DWORD
ENDSTRUC

STRUC enprotected
; STRUC 'NMHDR'
.nmhdr.hwndFrom   	 resd      	1	; HWND
.nmhdr.idFrom     	 resd      	1	; UINT
.nmhdr.code       	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.msg:             	 resd      	1	; UINT
.wParam:          	 resd      	1	; WPARAM
.lParam:          	 resd      	1	; LPARAM
; STRUC 'CHARRANGE'
.chrg.aflBlock    	 resd      	3	; DWORD
.chrg.fsUsb       	 resd      	4	; DWORD
.chrg.ciCharset   	 resd      	1	; UINT
.chrg.ciACP       	 resd      	1	; UINT
; ENDSTRUC 'CHARRANGE'
ENDSTRUC

STRUC SERVICE_STATUS
.dwServiceType:   	 resd      	1	; DWORD
.dwCurrentState:  	 resd      	1	; DWORD
.dwControlsAccepted:	 resd      	1	; DWORD
.dwWin32ExitCode: 	 resd      	1	; DWORD
.dwServiceSpecificExitCode:	 resd      	1	; DWORD
.dwCheckPoint:    	 resd      	1	; DWORD
.dwWaitHint:      	 resd      	1	; DWORD
ENDSTRUC

STRUC ENUM_SERVICE_STATUS
.lpServiceName:   	 resd      	1	; LPTSTR
.lpDisplayName:   	 resd      	1	; LPTSTR
; STRUC 'SERVICE_STATUS'
.ServiceStatus.dwServiceType	 resd      	1	; DWORD
.ServiceStatus.dwCurrentState	 resd      	1	; DWORD
.ServiceStatus.dwControlsAccepted	 resd      	1	; DWORD
.ServiceStatus.dwWin32ExitCode	 resd      	1	; DWORD
.ServiceStatus.dwServiceSpecificExitCode	 resd      	1	; DWORD
.ServiceStatus.dwCheckPoint	 resd      	1	; DWORD
.ServiceStatus.dwWaitHint	 resd      	1	; DWORD
; ENDSTRUC 'SERVICE_STATUS'
ENDSTRUC

STRUC ENUMLOGFONT
; STRUC 'LOGFONT'
.elfLogFont.lfHeight	 resd      	1	; LONG
.elfLogFont.lfWidth	 resd      	1	; LONG
.elfLogFont.lfEscapement	 resd      	1	; LONG
.elfLogFont.lfOrientation	 resd      	1	; LONG
.elfLogFont.lfWeight	 resd      	1	; LONG
.elfLogFont.lfItalic	 resb      	1	; BYTE
.elfLogFont.lfUnderline	 resb      	1	; BYTE
.elfLogFont.lfStrikeOut	 resb      	1	; BYTE
.elfLogFont.lfCharSet	 resb      	1	; BYTE
.elfLogFont.lfOutPrecision	 resb      	1	; BYTE
.elfLogFont.lfClipPrecision	 resb      	1	; BYTE
.elfLogFont.lfQuality	 resb      	1	; BYTE
.elfLogFont.lfPitchAndFamily	 resb      	1	; BYTE
.elfLogFont.lfFaceName	 resb      	0	; TCHAR
; ENDSTRUC 'LOGFONT'
ENDSTRUC

STRUC ENUMLOGFONTEX
; STRUC 'LOGFONT'
.elfLogFont.lfHeight	 resd      	1	; LONG
.elfLogFont.lfWidth	 resd      	1	; LONG
.elfLogFont.lfEscapement	 resd      	1	; LONG
.elfLogFont.lfOrientation	 resd      	1	; LONG
.elfLogFont.lfWeight	 resd      	1	; LONG
.elfLogFont.lfItalic	 resb      	1	; BYTE
.elfLogFont.lfUnderline	 resb      	1	; BYTE
.elfLogFont.lfStrikeOut	 resb      	1	; BYTE
.elfLogFont.lfCharSet	 resb      	1	; BYTE
.elfLogFont.lfOutPrecision	 resb      	1	; BYTE
.elfLogFont.lfClipPrecision	 resb      	1	; BYTE
.elfLogFont.lfQuality	 resb      	1	; BYTE
.elfLogFont.lfPitchAndFamily	 resb      	1	; BYTE
.elfLogFont.lfFaceName	 resb      	0	; TCHAR
; ENDSTRUC 'LOGFONT'
ENDSTRUC

STRUC EVENTLOGRECORD
.Length:          	 resd      	1	; DWORD
.Reserved:        	 resd      	1	; DWORD
.RecordNumber:    	 resd      	1	; DWORD
.TimeGenerated:   	 resd      	1	; DWORD
.TimeWritten:     	 resd      	1	; DWORD
.EventID:         	 resd      	1	; DWORD
.EventType:       	 resw      	1	; WORD
.NumStrings:      	 resw      	1	; WORD
.EventCategory:   	 resw      	1	; WORD
.ReservedFlags:   	 resw      	1	; WORD
.ClosingRecordNumber:	 resd      	1	; DWORD
.StringOffset:    	 resd      	1	; DWORD
.UserSidLength:   	 resd      	1	; DWORD
.UserSidOffset:   	 resd      	1	; DWORD
.DataLength:      	 resd      	1	; DWORD
.DataOffset:      	 resd      	1	; DWORD
ENDSTRUC

STRUC EVENTMSG
.message:         	 resd      	1	; UINT
.paramL:          	 resd      	1	; UINT
.paramH:          	 resd      	1	; UINT
.time:            	 resd      	1	; DWORD
.hwnd:            	 resd      	1	; HWND
ENDSTRUC

STRUC EXCEPTION_POINTERS
ENDSTRUC

STRUC EXT_BUTTON
.idCommand:       	 resw      	1	; WORD
.idsHelp:         	 resw      	1	; WORD
.fsStyle:         	 resw      	1	; WORD
ENDSTRUC

STRUC FILTERKEYS
.cbSize:          	 resd      	1	; UINT
.dwFlags:         	 resd      	1	; DWORD
.iWaitMSec:       	 resd      	1	; DWORD
.iDelayMSec:      	 resd      	1	; DWORD
.iRepeatMSec:     	 resd      	1	; DWORD
.iBounceMSec:     	 resd      	1	; DWORD
ENDSTRUC

STRUC FIND_NAME_BUFFER
.length:          	 resb      	1	; UCHAR
.access_control:  	 resb      	1	; UCHAR
.frame_control:   	 resb      	1	; UCHAR
.destination_addr:	 resb      	6	; UCHAR
.source_addr:     	 resb      	6	; UCHAR
.routing_info:    	 resb      	18	; UCHAR
ENDSTRUC

STRUC FIND_NAME_HEADER
.node_count:      	 resw      	1	; WORD
.reserved:        	 resb      	1	; UCHAR
.unique_group:    	 resb      	1	; UCHAR
ENDSTRUC

STRUC findtext
; STRUC 'CHARRANGE'
.chrg.aflBlock    	 resd      	3	; DWORD
.chrg.fsUsb       	 resd      	4	; DWORD
.chrg.ciCharset   	 resd      	1	; UINT
.chrg.ciACP       	 resd      	1	; UINT
; ENDSTRUC 'CHARRANGE'
.lpstrText:       	 resd      	1	; LPSTR
ENDSTRUC

STRUC findtextex
; STRUC 'CHARRANGE'
.chrg.aflBlock    	 resd      	3	; DWORD
.chrg.fsUsb       	 resd      	4	; DWORD
.chrg.ciCharset   	 resd      	1	; UINT
.chrg.ciACP       	 resd      	1	; UINT
; ENDSTRUC 'CHARRANGE'
.lpstrText:       	 resd      	1	; LPSTR
; STRUC 'CHARRANGE'
.chrgText.aflBlock	 resd      	3	; DWORD
.chrgText.fsUsb   	 resd      	4	; DWORD
.chrgText.ciCharset	 resd      	1	; UINT
.chrgText.ciACP   	 resd      	1	; UINT
; ENDSTRUC 'CHARRANGE'
ENDSTRUC

STRUC FMS_GETDRIVEINFO
.dwTotalSpace:    	 resd      	1	; DWORD
.dwFreeSpace:     	 resd      	1	; DWORD
.szPath:          	 resb      	260	; TCHAR
.szVolume:        	 resb      	14	; TCHAR
.szShare:         	 resb      	128	; TCHAR
ENDSTRUC

STRUC FMS_GETFILESEL
; STRUC 'FILETIME'
.ftTime.dwLowDateTime	 resd      	1	; DWORD
.ftTime.dwHighDateTime	 resd      	1	; DWORD
; ENDSTRUC 'FILETIME'
.dwSize:          	 resd      	1	; DWORD
.bAttr:           	 resb      	1	; BYTE
.szName:          	 resb      	260	; TCHAR
ENDSTRUC

STRUC FMS_LOAD
.dwSize:          	 resd      	1	; DWORD
.szMenuName:      	 resb      	0	; TCHAR
.hMenu:           	 resd      	1	; HMENU
.wMenuDelta:      	 resd      	1	; UINT
ENDSTRUC

STRUC FMS_TOOLBARLOAD
.dwSize:          	 resd      	1	; DWORD
.cButtons:        	 resw      	1	; WORD
.cBitmaps:        	 resw      	1	; WORD
.idBitmap:        	 resw      	1	; WORD
ENDSTRUC

STRUC FOCUS_EVENT_RECORD
.bSetFocus:       	 resd      	1	; BOOL
ENDSTRUC

STRUC FORM_INFO_1
.Flags:           	 resd      	1	; DWORD
.pName:           	 resd      	1	; LPTSTR
; STRUC 'RECTL'
.ImageableArea.left	 resd      	1	; LONG
.ImageableArea.top	 resd      	1	; LONG
.ImageableArea.right	 resd      	1	; LONG
.ImageableArea.bottom	 resd      	1	; LONG
; ENDSTRUC 'RECTL'
ENDSTRUC

STRUC formatrange
; STRUC 'RECT'
.rc.left          	 resd      	1	; LONG
.rc.top           	 resd      	1	; LONG
.rc.right         	 resd      	1	; LONG
.rc.bottom        	 resd      	1	; LONG
; ENDSTRUC 'RECT'
; STRUC 'RECT'
.rcPage.left      	 resd      	1	; LONG
.rcPage.top       	 resd      	1	; LONG
.rcPage.right     	 resd      	1	; LONG
.rcPage.bottom    	 resd      	1	; LONG
; ENDSTRUC 'RECT'
; STRUC 'CHARRANGE'
.chrg.aflBlock    	 resd      	3	; DWORD
.chrg.fsUsb       	 resd      	4	; DWORD
.chrg.ciCharset   	 resd      	1	; UINT
.chrg.ciACP       	 resd      	1	; UINT
; ENDSTRUC 'CHARRANGE'
ENDSTRUC

STRUC GCP_RESULTS
.lStructSize:     	 resd      	1	; DWORD
.lpOutString:     	 resd      	1	; LPTSTR
.lpClass:         	 resd      	1	; LPTSTR
.nGlyphs:         	 resd      	1	; UINT
.nMaxFit:         	 resd      	1	; UINT
ENDSTRUC

STRUC GENERIC_MAPPING
ENDSTRUC

STRUC GLYPHMETRICS
.gmBlackBoxX:     	 resd      	1	; UINT
.gmBlackBoxY:     	 resd      	1	; UINT
; STRUC 'POINT'
.gmptGlyphOrigin.x	 resd      	1	; LONG
.gmptGlyphOrigin.y	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.gmCellIncX:      	 resw      	1	; short
.gmCellIncY:      	 resw      	1	; short
ENDSTRUC

STRUC HANDLETABLE
ENDSTRUC

STRUC HD_HITTESTINFO
; STRUC 'POINT'
.pt.x             	 resd      	1	; LONG
.pt.y             	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.flags:           	 resd      	1	; UINT
.iItem:           	 resd      	1	; int
ENDSTRUC

STRUC HD_ITEM
.mask:            	 resd      	1	; UINT
.cxy:             	 resd      	1	; int
.pszText:         	 resd      	1	; LPTSTR
.cchTextMax:      	 resd      	1	; int
.fmt:             	 resd      	1	; int
.lParam:          	 resd      	1	; LPARAM
ENDSTRUC

STRUC WINDOWPOS
.hwnd:            	 resd      	1	; HWND
.hwndInsertAfter: 	 resd      	1	; HWND
.x:               	 resd      	1	; int
.y:               	 resd      	1	; int
.cx:              	 resd      	1	; int
.cy:              	 resd      	1	; int
.flags:           	 resd      	1	; UINT
ENDSTRUC

STRUC HD_LAYOUT
; STRUC 'pr'
.c.pDatatype      	 resd      	1	; LPTSTR
; ENDSTRUC 'pr'
ENDSTRUC

STRUC HD_NOTIFY
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.iItem:           	 resd      	1	; int
.iButton:         	 resd      	1	; int
ENDSTRUC

STRUC HELPINFO
.cbSize:          	 resd      	1	; UINT
.iContextType:    	 resd      	1	; int
.iCtrlId:         	 resd      	1	; int
.hItemHandle:     	 resd      	1	; HANDLE
.dwContextId:     	 resd      	1	; DWORD
; STRUC 'POINT'
.MousePos.x       	 resd      	1	; LONG
.MousePos.y       	 resd      	1	; LONG
; ENDSTRUC 'POINT'
ENDSTRUC

STRUC HIGHCONTRAST
.cbSize:          	 resd      	1	; UINT
.dwFlags:         	 resd      	1	; DWORD
.lpszDefaultScheme:	 resd      	1	; LPTSTR
ENDSTRUC

STRUC HSZPAIR
.hszSvc:          	 resd      	1	; HSZ
.hszTopic:        	 resd      	1	; HSZ
ENDSTRUC

STRUC ICONINFO
.fIcon:           	 resd      	1	; BOOL
.xHotspot:        	 resd      	1	; DWORD
.yHotspot:        	 resd      	1	; DWORD
ENDSTRUC

STRUC ICONMETRICS
.cbSize:          	 resd      	1	; UINT
.iHorzSpacing:    	 resd      	1	; int
.iVertSpacing:    	 resd      	1	; int
.iTitleWrap:      	 resd      	1	; int
; STRUC 'LOGFONT'
.lfFont.lfHeight  	 resd      	1	; LONG
.lfFont.lfWidth   	 resd      	1	; LONG
.lfFont.lfEscapement	 resd      	1	; LONG
.lfFont.lfOrientation	 resd      	1	; LONG
.lfFont.lfWeight  	 resd      	1	; LONG
.lfFont.lfItalic  	 resb      	1	; BYTE
.lfFont.lfUnderline	 resb      	1	; BYTE
.lfFont.lfStrikeOut	 resb      	1	; BYTE
.lfFont.lfCharSet 	 resb      	1	; BYTE
.lfFont.lfOutPrecision	 resb      	1	; BYTE
.lfFont.lfClipPrecision	 resb      	1	; BYTE
.lfFont.lfQuality 	 resb      	1	; BYTE
.lfFont.lfPitchAndFamily	 resb      	1	; BYTE
.lfFont.lfFaceName	 resb      	0	; TCHAR
; ENDSTRUC 'LOGFONT'
ENDSTRUC

STRUC IMAGEINFO
.Unused1:         	 resd      	1	; int
.Unused2:         	 resd      	1	; int
; STRUC 'RECT'
.rcImage.left     	 resd      	1	; LONG
.rcImage.top      	 resd      	1	; LONG
.rcImage.right    	 resd      	1	; LONG
.rcImage.bottom   	 resd      	1	; LONG
; ENDSTRUC 'RECT'
ENDSTRUC

;STRUC KEY_EVENT_RECORD
;.bKeyDown:        	 resd      	1	; BOOL
;.wRepeatCount:    	 resw      	1	; WORD
;.wVirtualKeyCode: 	 resw      	1	; WORD
;.wVirtualScanCode:	 resw      	1	; WORD
;;	union {
;.UnicodeChar:     	 resw      	1	; WCHAR
;.AsciiChar:       	 resb      	1	; CHAR
;.dwControlKeyState:	 resd      	1	; DWORD
;ENDSTRUC

STRUC MOUSE_EVENT_RECORD
; STRUC 'COORD'
.dwMousePosition.X	 resw      	1	; SHORT
.dwMousePosition.Y	 resw      	1	; SHORT
; ENDSTRUC 'COORD'
.dwButtonState:   	 resd      	1	; DWORD
.dwControlKeyState:	 resd      	1	; DWORD
.dwEventFlags:    	 resd      	1	; DWORD
ENDSTRUC

STRUC WINDOW_BUFFER_SIZE_RECORD
; STRUC 'COORD'
.dwSize.X         	 resw      	1	; SHORT
.dwSize.Y         	 resw      	1	; SHORT
; ENDSTRUC 'COORD'
ENDSTRUC

STRUC MENU_EVENT_RECORD
.dwCommandId:     	 resd      	1	; UINT
ENDSTRUC

;STRUC INPUT_RECORD
;.EventType:       	 resw      	1	; WORD
;.__alignmentDummy:	 resw      	1	; WORD
;	union {
; STRUC 'KEY_EVENT_RECORD'
;.KeyEvent.bKeyDown	 resd      	1	; BOOL
;.KeyEvent.wRepeatCount	 resw      	1	; WORD
;.KeyEvent.wVirtualKeyCode	 resw      	1	; WORD
;.KeyEvent.wVirtualScanCode	 resw      	1	; WORD
;.KeyEvent.UnicodeChar	 resw      	1	; WCHAR
;.KeyEvent.AsciiChar	 resb      	1	; CHAR
;.KeyEvent.dwControlKeyState	 resd      	1	; DWORD
; ENDSTRUC 'KEY_EVENT_RECORD'
; STRUC 'MOUSE_EVENT_RECORD'
;.MouseEvent.dwMousePosition.X	 resw      	1	; SHORT
;.MouseEvent.dwMousePosition.Y	 resw      	1	; SHORT
;.MouseEvent.dwButtonState	 resd      	1	; DWORD
;.MouseEvent.dwControlKeyState	 resd      	1	; DWORD
;.MouseEvent.dwEventFlags	 resd      	1	; DWORD
; ENDSTRUC 'MOUSE_EVENT_RECORD'
; STRUC 'WINDOW_BUFFER_SIZE_RECORD'
;.WindowBufferSizeEvent.dwSize.X	 resw      	1	; SHORT
;.WindowBufferSizeEvent.dwSize.Y	 resw      	1	; SHORT
;; ENDSTRUC 'WINDOW_BUFFER_SIZE_RECORD'
;; STRUC 'MENU_EVENT_RECORD'
;.MenuEvent.dwCommandId	 resd      	1	; UINT
;; ENDSTRUC 'MENU_EVENT_RECORD'
;; STRUC 'FOCUS_EVENT_RECORD'
;.FocusEvent.bSetFocus	 resd      	1	; BOOL
;; ENDSTRUC 'FOCUS_EVENT_RECORD'
;; STRUC 'Even'
;.t.Length         	 resd      	1	; DWORD
;.t.Reserved       	 resd      	1	; DWORD
;.t.RecordNumber   	 resd      	1	; DWORD
;.t.TimeGenerated  	 resd      	1	; DWORD
;.t.TimeWritten    	 resd      	1	; DWORD
;.t.EventID        	 resd      	1	; DWORD
;.t.EventType      	 resw      	1	; WORD
;.t.NumStrings     	 resw      	1	; WORD
;.t.EventCategory  	 resw      	1	; WORD
;.t.ReservedFlags  	 resw      	1	; WORD
;.t.ClosingRecordNumber	 resd      	1	; DWORD
;.t.StringOffset   	 resd      	1	; DWORD
;.t.UserSidLength  	 resd      	1	; DWORD
;.t.UserSidOffset  	 resd      	1	; DWORD
;.t.DataLength     	 resd      	1	; DWORD
;.t.DataOffset     	 resd      	1	; DWORD
; ENDSTRUC 'Even'
;ENDSTRUC

STRUC SYSTEMTIME
.wYear:           	 resw      	1	; WORD
.wMonth:          	 resw      	1	; WORD
.wDayOfWeek:      	 resw      	1	; WORD
.wDay:            	 resw      	1	; WORD
.wHour:           	 resw      	1	; WORD
.wMinute:         	 resw      	1	; WORD
.wSecond:         	 resw      	1	; WORD
.wMilliseconds:   	 resw      	1	; WORD
ENDSTRUC

STRUC JOB_INFO_1
.JobId:           	 resd      	1	; DWORD
.pPrinterName:    	 resd      	1	; LPTSTR
.pMachineName:    	 resd      	1	; LPTSTR
.pUserName:       	 resd      	1	; LPTSTR
.pDocument:       	 resd      	1	; LPTSTR
.pDatatype:       	 resd      	1	; LPTSTR
.pStatus:         	 resd      	1	; LPTSTR
.Status:          	 resd      	1	; DWORD
.Priority:        	 resd      	1	; DWORD
.Position:        	 resd      	1	; DWORD
.TotalPages:      	 resd      	1	; DWORD
.PagesPrinted:    	 resd      	1	; DWORD
; STRUC 'SYSTEMTIME'
.Submitted.wYear  	 resw      	1	; WORD
.Submitted.wMonth 	 resw      	1	; WORD
.Submitted.wDayOfWeek	 resw      	1	; WORD
.Submitted.wDay   	 resw      	1	; WORD
.Submitted.wHour  	 resw      	1	; WORD
.Submitted.wMinute	 resw      	1	; WORD
.Submitted.wSecond	 resw      	1	; WORD
.Submitted.wMilliseconds	 resw      	1	; WORD
; ENDSTRUC 'SYSTEMTIME'
ENDSTRUC

STRUC SID_IDENTIFIER_AUTHORITY
.Value:           	 resb      	6	; BYTE
ENDSTRUC

STRUC SID
.Revision:        	 resb      	1	; BYTE
.SubAuthorityCount:	 resb      	1	; BYTE
; STRUC 'SID_IDENTIFIER_AUTHORITY'
.IdentifierAuthority.Value	 resb      	6	; BYTE
; ENDSTRUC 'SID_IDENTIFIER_AUTHORITY'
.SubAuthority:    	 resd      	0	; DWORD
ENDSTRUC

STRUC SECURITY_DESCRIPTOR
.Revision:        	 resb      	1	; BYTE
.Sbz1:            	 resb      	1	; BYTE
ENDSTRUC

STRUC JOB_INFO_2
.JobId:           	 resd      	1	; DWORD
.pPrinterName:    	 resd      	1	; LPTSTR
.pMachineName:    	 resd      	1	; LPTSTR
.pUserName:       	 resd      	1	; LPTSTR
.pDocument:       	 resd      	1	; LPTSTR
.pNotifyName:     	 resd      	1	; LPTSTR
.pDatatype:       	 resd      	1	; LPTSTR
.pPrintProcessor: 	 resd      	1	; LPTSTR
.pParameters:     	 resd      	1	; LPTSTR
.pDriverName:     	 resd      	1	; LPTSTR
.pStatus:         	 resd      	1	; LPTSTR
.Status:          	 resd      	1	; DWORD
.Priority:        	 resd      	1	; DWORD
.Position:        	 resd      	1	; DWORD
.StartTime:       	 resd      	1	; DWORD
.UntilTime:       	 resd      	1	; DWORD
.TotalPages:      	 resd      	1	; DWORD
.Size:            	 resd      	1	; DWORD
; STRUC 'SYSTEMTIME'
.Submitted.wYear  	 resw      	1	; WORD
.Submitted.wMonth 	 resw      	1	; WORD
.Submitted.wDayOfWeek	 resw      	1	; WORD
.Submitted.wDay   	 resw      	1	; WORD
.Submitted.wHour  	 resw      	1	; WORD
.Submitted.wMinute	 resw      	1	; WORD
.Submitted.wSecond	 resw      	1	; WORD
.Submitted.wMilliseconds	 resw      	1	; WORD
; ENDSTRUC 'SYSTEMTIME'
.Time:            	 resd      	1	; DWORD
.PagesPrinted:    	 resd      	1	; DWORD
ENDSTRUC

STRUC KERNINGPAIR
.wFirst:          	 resw      	1	; WORD
.wSecond:         	 resw      	1	; WORD
.iKernAmount:     	 resd      	1	; int
ENDSTRUC

STRUC LANA_ENUM
.length:          	 resb      	1	; UCHAR
.lana:            	 resb      	0	; UCHAR
ENDSTRUC

;STRUC LDT_ENTRY
;.LimitLow:        	 resw      	1	; WORD
;.BaseLow:         	 resw      	1	; WORD
;	union {
;		struct {
;.BaseMid:         	 resb      	1	; BYTE
;.Flags1:          	 resb      	1	; BYTE
;.Flags2:          	 resb      	1	; BYTE
;.BaseHi:          	 resb      	1	; BYTE
;.s:               	 resb      	1	; Byte
;		struct {
;			DWORD BaseMid:8;
;			DWORD Type:5;
;			DWORD Dpl:2;
;			DWORD Pres:1;
;			DWORD LimitHi:4;
;			DWORD Sys:1;
;			DWORD Reserved_0:1;
;			DWORD Default_Big:1;
;			DWORD Granularity:1;
;			DWORD BaseHi:8;
; STRUC 'Bit'
;.s.bmType         	 resd      	1	; LONG
;.s.bmWidth        	 resd      	1	; LONG
;.s.bmHeight       	 resd      	1	; LONG
;.s.bmWidthBytes   	 resd      	1	; LONG
;.s.bmPlanes       	 resw      	1	; WORD
;.s.bmBitsPixel    	 resw      	1	; WORD
;.s.bmBits         	 resd      	1	; LPVOID
; ENDSTRUC 'Bit'
;ENDSTRUC

STRUC LOCALESIGNATURE
.lsUsb:           	 resd      	4	; DWORD
.lsCsbDefault:    	 resd      	2	; DWORD
.lsCsbSupported:  	 resd      	2	; DWORD
ENDSTRUC

STRUC LOCALGROUP_MEMBERS_INFO_0
ENDSTRUC

STRUC LOCALGROUP_MEMBERS_INFO_3
ENDSTRUC

STRUC LUID_AND_ATTRIBUTES
.Luid			 resd		2	; LARGE_INTEGER
.Attributes:      	 resd      	1	; DWORD
ENDSTRUC

STRUC LV_COLUMN
.mask:            	 resd      	1	; UINT
.fmt:             	 resd      	1	; int
.cx:              	 resd      	1	; int
.pszText:         	 resd      	1	; LPTSTR
.cchTextMax:      	 resd      	1	; int
.iSubItem:        	 resd      	1	; int
ENDSTRUC

STRUC LV_ITEM
.mask:            	 resd      	1	; UINT
.iItem:           	 resd      	1	; int
.iSubItem:        	 resd      	1	; int
.state:           	 resd      	1	; UINT
.stateMask:       	 resd      	1	; UINT
.pszText:         	 resd      	1	; LPTSTR
.cchTextMax:      	 resd      	1	; int
.iImage:          	 resd      	1	; int
.lParam:          	 resd      	1	; LPARAM
ENDSTRUC

STRUC LV_DISPINFO
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
; STRUC 'LV_ITEM'
.item.mask        	 resd      	1	; UINT
.item.iItem       	 resd      	1	; int
.item.iSubItem    	 resd      	1	; int
.item.state       	 resd      	1	; UINT
.item.stateMask   	 resd      	1	; UINT
.item.pszText     	 resd      	1	; LPTSTR
.item.cchTextMax  	 resd      	1	; int
.item.iImage      	 resd      	1	; int
.item.lParam      	 resd      	1	; LPARAM
; ENDSTRUC 'LV_ITEM'
ENDSTRUC

STRUC LV_FINDINFO
.flags:           	 resd      	1	; UINT
.psz:             	 resd      	1	; LPCTSTR
.lParam:          	 resd      	1	; LPARAM
; STRUC 'POINT'
.pt.x             	 resd      	1	; LONG
.pt.y             	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.vkDirection:     	 resd      	1	; UINT
ENDSTRUC

STRUC LV_HITTESTINFO
; STRUC 'POINT'
.pt.x             	 resd      	1	; LONG
.pt.y             	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.flags:           	 resd      	1	; UINT
.iItem:           	 resd      	1	; int
ENDSTRUC

STRUC LV_KEYDOWN
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.wVKey:           	 resw      	1	; WORD
.flags:           	 resd      	1	; UINT
ENDSTRUC

STRUC MAT2
; STRUC 'FIXED'
.eM11.fract       	 resw      	1	; WORD
.eM11.value       	 resw      	1	; short
; ENDSTRUC 'FIXED'
; STRUC 'FIXED'
.eM12.fract       	 resw      	1	; WORD
.eM12.value       	 resw      	1	; short
; ENDSTRUC 'FIXED'
; STRUC 'FIXED'
.eM21.fract       	 resw      	1	; WORD
.eM21.value       	 resw      	1	; short
; ENDSTRUC 'FIXED'
; STRUC 'FIXED'
.eM22.fract       	 resw      	1	; WORD
.eM22.value       	 resw      	1	; short
; ENDSTRUC 'FIXED'
ENDSTRUC

STRUC MDICREATESTRUCT
.szClass:         	 resd      	1	; LPCTSTR
.szTitle:         	 resd      	1	; LPCTSTR
.hOwner:          	 resd      	1	; HANDLE
.x:               	 resd      	1	; int
.y:               	 resd      	1	; int
.cx:              	 resd      	1	; int
.cy:              	 resd      	1	; int
.style:           	 resd      	1	; DWORD
.lParam:          	 resd      	1	; LPARAM
ENDSTRUC

STRUC MEASUREITEMSTRUCT
.CtlType:         	 resd      	1	; UINT
.CtlID:           	 resd      	1	; UINT
.itemID:          	 resd      	1	; UINT
.itemWidth:       	 resd      	1	; UINT
.itemHeight:      	 resd      	1	; UINT
.itemData:        	 resd      	1	; DWORD
ENDSTRUC

STRUC MEMORY_BASIC_INFORMATION
.BaseAddress:     	 resd      	1	; PVOID
.AllocationBase:  	 resd      	1	; PVOID
.AllocationProtect:	 resd      	1	; DWORD
.RegionSize:      	 resd      	1	; DWORD
.State:           	 resd      	1	; DWORD
.Protect:         	 resd      	1	; DWORD
.Type:            	 resd      	1	; DWORD
ENDSTRUC

STRUC MEMORYSTATUS
.dwLength:        	 resd      	1	; DWORD
.dwMemoryLoad:    	 resd      	1	; DWORD
.dwTotalPhys:     	 resd      	1	; DWORD
.dwAvailPhys:     	 resd      	1	; DWORD
.dwTotalPageFile: 	 resd      	1	; DWORD
.dwAvailPageFile: 	 resd      	1	; DWORD
.dwTotalVirtual:  	 resd      	1	; DWORD
.dwAvailVirtual:  	 resd      	1	; DWORD
ENDSTRUC

STRUC MENUITEMINFO
.cbSize:          	 resd      	1	; UINT
.fMask:           	 resd      	1	; UINT
.fType:           	 resd      	1	; UINT
.fState:          	 resd      	1	; UINT
.wID:             	 resd      	1	; UINT
.hSubMenu:        	 resd      	1	; HMENU
.dwItemData:      	 resd      	1	; DWORD
.dwTypeData:      	 resd      	1	; LPTSTR
.cch:             	 resd      	1	; UINT
ENDSTRUC

STRUC METAFILEPICT
.mm:              	 resd      	1	; LONG
.xExt:            	 resd      	1	; LONG
.yExt:            	 resd      	1	; LONG
ENDSTRUC

STRUC METAHEADER
.mtType:          	 resw      	1	; WORD
.mtHeaderSize:    	 resw      	1	; WORD
.mtVersion:       	 resw      	1	; WORD
.mtSize:          	 resd      	1	; DWORD
.mtNoObjects:     	 resw      	1	; WORD
.mtMaxRecord:     	 resd      	1	; DWORD
.mtNoParameters:  	 resw      	1	; WORD
ENDSTRUC

STRUC METARECORD
.rdSize:          	 resd      	1	; DWORD
.rdFunction:      	 resw      	1	; WORD
.rdParm:          	 resw      	1	; WORD
ENDSTRUC

STRUC MINIMIZEDMETRICS
.cbSize:          	 resd      	1	; UINT
.iWidth:          	 resd      	1	; int
.iHorzGap:        	 resd      	1	; int
.iVertGap:        	 resd      	1	; int
.iArrange:        	 resd      	1	; int
ENDSTRUC

STRUC MINMAXINFO
; STRUC 'POINT'
.ptReserved.x     	 resd      	1	; LONG
.ptReserved.y     	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'POINT'
.ptMaxSize.x      	 resd      	1	; LONG
.ptMaxSize.y      	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'POINT'
.ptMaxPosition.x  	 resd      	1	; LONG
.ptMaxPosition.y  	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'POINT'
.ptMinTrackSize.x 	 resd      	1	; LONG
.ptMinTrackSize.y 	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'POINT'
.ptMaxTrackSize.x 	 resd      	1	; LONG
.ptMaxTrackSize.y 	 resd      	1	; LONG
; ENDSTRUC 'POINT'
ENDSTRUC

STRUC modemdevcaps_tag
.dwActualSize:    	 resd      	1	; DWORD
.dwRequiredSize:  	 resd      	1	; DWORD
.dwDevSpecificOffset:	 resd      	1	; DWORD
.dwDevSpecificSize:	 resd      	1	; DWORD
.dwModemProviderVersion:	 resd      	1	; DWORD
.dwModemManufacturerOffset:	 resd      	1	; DWORD
.dwModemManufacturerSize:	 resd      	1	; DWORD
.dwModemModelOffset:	 resd      	1	; DWORD
.dwModemModelSize:	 resd      	1	; DWORD
.dwModemVersionOffset:	 resd      	1	; DWORD
.dwModemVersionSize:	 resd      	1	; DWORD
.dwDialOptions:   	 resd      	1	; DWORD
.dwCallSetupFailTimer:	 resd      	1	; DWORD
.dwInactivityTimeout:	 resd      	1	; DWORD
.dwSpeakerVolume: 	 resd      	1	; DWORD
.dwSpeakerMode:   	 resd      	1	; DWORD
.dwModemOptions:  	 resd      	1	; DWORD
.dwMaxDTERate:    	 resd      	1	; DWORD
.dwMaxDCERate:    	 resd      	1	; DWORD
.abVariablePortion:	 resb      	1	; BYTE
ENDSTRUC

STRUC modemsettings_tag
.dwActualSize:    	 resd      	1	; DWORD
.dwRequiredSize:  	 resd      	1	; DWORD
.dwDevSpecificOffset:	 resd      	1	; DWORD
.dwDevSpecificSize:	 resd      	1	; DWORD
.dwCallSetupFailTimer:	 resd      	1	; DWORD
.dwInactivityTimeout:	 resd      	1	; DWORD
.dwSpeakerVolume: 	 resd      	1	; DWORD
.dwSpeakerMode:   	 resd      	1	; DWORD
.dwPreferredModemOptions:	 resd      	1	; DWORD
.dwNegotiatedModemOptions:	 resd      	1	; DWORD
.dwNegotiatedDCERate:	 resd      	1	; DWORD
.abVariablePortion:	 resb      	1	; BYTE
ENDSTRUC

STRUC MONCBSTRUCT
.cb:              	 resd      	1	; UINT
.dwTime:          	 resd      	1	; DWORD
.hTask:           	 resd      	1	; HANDLE
.dwRet:           	 resd      	1	; DWORD
.wType:           	 resd      	1	; UINT
.wFmt:            	 resd      	1	; UINT
.hsz1:            	 resd      	1	; HSZ
.hsz2:            	 resd      	1	; HSZ
.dwData1:         	 resd      	1	; DWORD
.dwData2:         	 resd      	1	; DWORD
; STRUC 'CONVCONTEXT'
.cc.cb            	 resd      	1	; UINT
.cc.wFlags        	 resd      	1	; UINT
.cc.wCountryID    	 resd      	1	; UINT
.cc.iCodePage     	 resd      	1	; int
.cc.dwLangID      	 resd      	1	; DWORD
.cc.dwSecurity    	 resd      	1	; DWORD
.cc.qos.Length    	 resd      	1	; DWORD
.cc.qos.ContextTrackingMode	 resd      	1	; BOOL
; ENDSTRUC 'CONVCONTEXT'
.cbData:          	 resd      	1	; DWORD
.Data:            	 resd      	8	; DWORD
ENDSTRUC

STRUC MONCONVSTRUCT
.cb:              	 resd      	1	; UINT
.fConnect:        	 resd      	1	; BOOL
.dwTime:          	 resd      	1	; DWORD
.hTask:           	 resd      	1	; HANDLE
.hszSvc:          	 resd      	1	; HSZ
.hszTopic:        	 resd      	1	; HSZ
ENDSTRUC

STRUC MONERRSTRUCT
.cb:              	 resd      	1	; UINT
.wLastError:      	 resd      	1	; UINT
.dwTime:          	 resd      	1	; DWORD
.hTask:           	 resd      	1	; HANDLE
ENDSTRUC

STRUC MONHSZSTRUCT
.cb:              	 resd      	1	; UINT
.fsAction:        	 resd      	1	; BOOL
.dwTime:          	 resd      	1	; DWORD
.hsz:             	 resd      	1	; HSZ
.hTask:           	 resd      	1	; HANDLE
.str:             	 resb      	1	; TCHAR
ENDSTRUC

STRUC MONITOR_INFO_1
.pName:           	 resd      	1	; LPTSTR
ENDSTRUC

STRUC MONITOR_INFO_2
.pName:           	 resd      	1	; LPTSTR
.pEnvironment:    	 resd      	1	; LPTSTR
.pDLLName:        	 resd      	1	; LPTSTR
ENDSTRUC

STRUC MONLINKSTRUCT
.cb:              	 resd      	1	; UINT
.dwTime:          	 resd      	1	; DWORD
.hTask:           	 resd      	1	; HANDLE
.fEstablished:    	 resd      	1	; BOOL
.fNoData:         	 resd      	1	; BOOL
.hszSvc:          	 resd      	1	; HSZ
.hszTopic:        	 resd      	1	; HSZ
.hszItem:         	 resd      	1	; HSZ
.wFmt:            	 resd      	1	; UINT
.fServer:         	 resd      	1	; BOOL
ENDSTRUC

STRUC MONMSGSTRUCT
.cb:              	 resd      	1	; UINT
.hwndTo:          	 resd      	1	; HWND
.dwTime:          	 resd      	1	; DWORD
.hTask:           	 resd      	1	; HANDLE
.wMsg:            	 resd      	1	; UINT
.wParam:          	 resd      	1	; WPARAM
.lParam:          	 resd      	1	; LPARAM
; STRUC 'DDEML_MSG_HOOK_DATA'
.dmhd.uiLo        	 resd      	1	; UINT
.dmhd.uiHi        	 resd      	1	; UINT
.dmhd.cbData      	 resd      	1	; DWORD
.dmhd.Data        	 resd      	8	; DWORD
; ENDSTRUC 'DDEML_MSG_HOOK_DATA'
ENDSTRUC

STRUC MOUSEHOOKSTRUCT
; STRUC 'POINT'
.pt.x             	 resd      	1	; LONG
.pt.y             	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.hwnd:            	 resd      	1	; HWND
.wHitTestCode:    	 resd      	1	; UINT
.dwExtraInfo:     	 resd      	1	; DWORD
ENDSTRUC

STRUC MOUSEKEYS
.cbSize:          	 resd      	1	; DWORD
.dwFlags:         	 resd      	1	; DWORD
.iMaxSpeed:       	 resd      	1	; DWORD
.iTimeToMaxSpeed: 	 resd      	1	; DWORD
.iCtrlSpeed:      	 resd      	1	; DWORD
.dwReserved1:     	 resd      	1	; DWORD
.dwReserved2:     	 resd      	1	; DWORD
ENDSTRUC

STRUC MSG
.hwnd:            	 resd      	1	; HWND
.message:         	 resd      	1	; UINT
.wParam:          	 resd      	1	; WPARAM
.lParam:          	 resd      	1	; LPARAM
.time:            	 resd      	1	; DWORD
; STRUC 'POINT'
.pt.x             	 resd      	1	; LONG
.pt.y             	 resd      	1	; LONG
; ENDSTRUC 'POINT'
ENDSTRUC

STRUC msgfilter
; STRUC 'NMHDR'
.nmhdr.hwndFrom   	 resd      	1	; HWND
.nmhdr.idFrom     	 resd      	1	; UINT
.nmhdr.code       	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.msg:             	 resd      	1	; UINT
.wParam:          	 resd      	1	; WPARAM
.lParam:          	 resd      	1	; LPARAM
ENDSTRUC

STRUC MULTIKEYHELP
.mkSize:          	 resd      	1	; DWORD
.mkKeylist:       	 resb      	1	; TCHAR
.szKeyphrase:     	 resb      	1	; TCHAR
ENDSTRUC

STRUC NAME_BUFFER
.name:            	 resb      	0	; UCHAR
.name_num:        	 resb      	1	; UCHAR
.name_flags:      	 resb      	1	; UCHAR
ENDSTRUC

STRUC NCB
.ncb_command:     	 resb      	1	; UCHAR
.ncb_retcode:     	 resb      	1	; UCHAR
.ncb_lsn:         	 resb      	1	; UCHAR
.ncb_num:         	 resb      	1	; UCHAR
.ncb_length:      	 resw      	1	; WORD
.ncb_callname:    	 resb      	0	; UCHAR
.ncb_name:        	 resb      	0	; UCHAR
.ncb_rto:         	 resb      	1	; UCHAR
.ncb_sto:         	 resb      	1	; UCHAR
;	void (*ncb_post) (struct _NCB *);
.ncb_lana_num:    	 resb      	1	; UCHAR
.ncb_cmd_cplt:    	 resb      	1	; UCHAR
.ncb_reserve:     	 resb      	10	; UCHAR
.ncb_event:       	 resd      	1	; HANDLE
ENDSTRUC

STRUC NCCALCSIZE_PARAMS
; STRUC 'RECT'
.rgrc.left        	 resd      	1	; LONG
.rgrc.top         	 resd      	1	; LONG
.rgrc.right       	 resd      	1	; LONG
.rgrc.bottom      	 resd      	1	; LONG
; ENDSTRUC 'RECT'
ENDSTRUC

STRUC NDDESHAREINFO
.lRevision:       	 resd      	1	; LONG
.lpszShareName:   	 resd      	1	; LPTSTR
.lShareType:      	 resd      	1	; LONG
.lpszAppTopicList:	 resd      	1	; LPTSTR
.fSharedFlag:     	 resd      	1	; LONG
.fService:        	 resd      	1	; LONG
.fStartAppFlag:   	 resd      	1	; LONG
.nCmdShow:        	 resd      	1	; LONG
.qModifyId:       	 resd      	2	; LONG
.cNumItems:       	 resd      	1	; LONG
.lpszItemList:    	 resd      	1	; LPTSTR
ENDSTRUC

STRUC NETRESOURCE
.dwScope:         	 resd      	1	; DWORD
.dwType:          	 resd      	1	; DWORD
.dwDisplayType:   	 resd      	1	; DWORD
.dwUsage:         	 resd      	1	; DWORD
.lpLocalName:     	 resd      	1	; LPTSTR
.lpRemoteName:    	 resd      	1	; LPTSTR
.lpComment:       	 resd      	1	; LPTSTR
.lpProvider:      	 resd      	1	; LPTSTR
ENDSTRUC

STRUC NEWCPLINFO
.dwSize:          	 resd      	1	; DWORD
.dwFlags:         	 resd      	1	; DWORD
.dwHelpContext:   	 resd      	1	; DWORD
.lData:           	 resd      	1	; LONG
.szName:          	 resb      	32	; TCHAR
.szInfo:          	 resb      	64	; TCHAR
.szHelpFile:      	 resb      	128	; TCHAR
ENDSTRUC

STRUC NEWTEXTMETRIC
.tmHeight:        	 resd      	1	; LONG
.tmAscent:        	 resd      	1	; LONG
.tmDescent:       	 resd      	1	; LONG
.tmInternalLeading:	 resd      	1	; LONG
.tmExternalLeading:	 resd      	1	; LONG
.tmAveCharWidth:  	 resd      	1	; LONG
.tmMaxCharWidth:  	 resd      	1	; LONG
.tmWeight:        	 resd      	1	; LONG
.tmOverhang:      	 resd      	1	; LONG
.tmDigitizedAspectX:	 resd      	1	; LONG
.tmDigitizedAspectY:	 resd      	1	; LONG
.tmItalic:        	 resb      	1	; BYTE
.tmUnderlined:    	 resb      	1	; BYTE
.tmStruckOut:     	 resb      	1	; BYTE
.tmPitchAndFamily:	 resb      	1	; BYTE
.tmCharSet:       	 resb      	1	; BYTE
.ntmFlags:        	 resd      	1	; DWORD
.ntmSizeEM:       	 resd      	1	; UINT
.ntmCellHeight:   	 resd      	1	; UINT
.ntmAvgWidth:     	 resd      	1	; UINT
ENDSTRUC

STRUC NEWTEXTMETRICEX
; STRUC 'NEWTEXTMETRIC'
.ntmentm.tmHeight 	 resd      	1	; LONG
.ntmentm.tmAscent 	 resd      	1	; LONG
.ntmentm.tmDescent	 resd      	1	; LONG
.ntmentm.tmInternalLeading	 resd      	1	; LONG
.ntmentm.tmExternalLeading	 resd      	1	; LONG
.ntmentm.tmAveCharWidth	 resd      	1	; LONG
.ntmentm.tmMaxCharWidth	 resd      	1	; LONG
.ntmentm.tmWeight 	 resd      	1	; LONG
.ntmentm.tmOverhang	 resd      	1	; LONG
.ntmentm.tmDigitizedAspectX	 resd      	1	; LONG
.ntmentm.tmDigitizedAspectY	 resd      	1	; LONG
.ntmentm.tmItalic 	 resb      	1	; BYTE
.ntmentm.tmUnderlined	 resb      	1	; BYTE
.ntmentm.tmStruckOut	 resb      	1	; BYTE
.ntmentm.tmPitchAndFamily	 resb      	1	; BYTE
.ntmentm.tmCharSet	 resb      	1	; BYTE
.ntmentm.ntmFlags 	 resd      	1	; DWORD
.ntmentm.ntmSizeEM	 resd      	1	; UINT
.ntmentm.ntmCellHeight	 resd      	1	; UINT
.ntmentm.ntmAvgWidth	 resd      	1	; UINT
; ENDSTRUC 'NEWTEXTMETRIC'
ENDSTRUC

STRUC NM_LISTVIEW
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.iItem:           	 resd      	1	; int
.iSubItem:        	 resd      	1	; int
.uNewState:       	 resd      	1	; UINT
.uOldState:       	 resd      	1	; UINT
.uChanged:        	 resd      	1	; UINT
; STRUC 'POINT'
.ptAction.x       	 resd      	1	; LONG
.ptAction.y       	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.lParam:          	 resd      	1	; LPARAM
ENDSTRUC

STRUC TV_ITEM
.mask:            	 resd      	1	; UINT
.state:           	 resd      	1	; UINT
.stateMask:       	 resd      	1	; UINT
.pszText:         	 resd      	1	; LPTSTR
.cchTextMax:      	 resd      	1	; int
.iImage:          	 resd      	1	; int
.iSelectedImage:  	 resd      	1	; int
.cChildren:       	 resd      	1	; int
.lParam:          	 resd      	1	; LPARAM
ENDSTRUC

STRUC NM_TREEVIEW
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.action:          	 resd      	1	; UINT
; STRUC 'TV_ITEM'
.itemOld.mask     	 resd      	1	; UINT
.itemOld.state    	 resd      	1	; UINT
.itemOld.stateMask	 resd      	1	; UINT
.itemOld.pszText  	 resd      	1	; LPTSTR
.itemOld.cchTextMax	 resd      	1	; int
.itemOld.iImage   	 resd      	1	; int
.itemOld.iSelectedImage	 resd      	1	; int
.itemOld.cChildren	 resd      	1	; int
.itemOld.lParam   	 resd      	1	; LPARAM
; ENDSTRUC 'TV_ITEM'
; STRUC 'TV_ITEM'
.itemNew.mask     	 resd      	1	; UINT
.itemNew.state    	 resd      	1	; UINT
.itemNew.stateMask	 resd      	1	; UINT
.itemNew.pszText  	 resd      	1	; LPTSTR
.itemNew.cchTextMax	 resd      	1	; int
.itemNew.iImage   	 resd      	1	; int
.itemNew.iSelectedImage	 resd      	1	; int
.itemNew.cChildren	 resd      	1	; int
.itemNew.lParam   	 resd      	1	; LPARAM
; ENDSTRUC 'TV_ITEM'
; STRUC 'POINT'
.ptDrag.x         	 resd      	1	; LONG
.ptDrag.y         	 resd      	1	; LONG
; ENDSTRUC 'POINT'
ENDSTRUC

STRUC NM_UPDOWN
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.iPos:            	 resd      	1	; int
.iDelta:          	 resd      	1	; int
ENDSTRUC

STRUC NONCLIENTMETRICS
.cbSize:          	 resd      	1	; UINT
.iBorderWidth:    	 resd      	1	; int
.iScrollWidth:    	 resd      	1	; int
.iScrollHeight:   	 resd      	1	; int
.iCaptionWidth:   	 resd      	1	; int
.iCaptionHeight:  	 resd      	1	; int
; STRUC 'LOGFONT'
.lfCaptionFont.lfHeight	 resd      	1	; LONG
.lfCaptionFont.lfWidth	 resd      	1	; LONG
.lfCaptionFont.lfEscapement	 resd      	1	; LONG
.lfCaptionFont.lfOrientation	 resd      	1	; LONG
.lfCaptionFont.lfWeight	 resd      	1	; LONG
.lfCaptionFont.lfItalic	 resb      	1	; BYTE
.lfCaptionFont.lfUnderline	 resb      	1	; BYTE
.lfCaptionFont.lfStrikeOut	 resb      	1	; BYTE
.lfCaptionFont.lfCharSet	 resb      	1	; BYTE
.lfCaptionFont.lfOutPrecision	 resb      	1	; BYTE
.lfCaptionFont.lfClipPrecision	 resb      	1	; BYTE
.lfCaptionFont.lfQuality	 resb      	1	; BYTE
.lfCaptionFont.lfPitchAndFamily	 resb      	1	; BYTE
.lfCaptionFont.lfFaceName	 resb      	0	; TCHAR
; ENDSTRUC 'LOGFONT'
.iSmCaptionWidth: 	 resd      	1	; int
.iSmCaptionHeight:	 resd      	1	; int
; STRUC 'LOGFONT'
.lfSmCaptionFont.lfHeight	 resd      	1	; LONG
.lfSmCaptionFont.lfWidth	 resd      	1	; LONG
.lfSmCaptionFont.lfEscapement	 resd      	1	; LONG
.lfSmCaptionFont.lfOrientation	 resd      	1	; LONG
.lfSmCaptionFont.lfWeight	 resd      	1	; LONG
.lfSmCaptionFont.lfItalic	 resb      	1	; BYTE
.lfSmCaptionFont.lfUnderline	 resb      	1	; BYTE
.lfSmCaptionFont.lfStrikeOut	 resb      	1	; BYTE
.lfSmCaptionFont.lfCharSet	 resb      	1	; BYTE
.lfSmCaptionFont.lfOutPrecision	 resb      	1	; BYTE
.lfSmCaptionFont.lfClipPrecision	 resb      	1	; BYTE
.lfSmCaptionFont.lfQuality	 resb      	1	; BYTE
.lfSmCaptionFont.lfPitchAndFamily	 resb      	1	; BYTE
.lfSmCaptionFont.lfFaceName	 resb      	0	; TCHAR
; ENDSTRUC 'LOGFONT'
.iMenuWidth:      	 resd      	1	; int
.iMenuHeight:     	 resd      	1	; int
; STRUC 'LOGFONT'
.lfMenuFont.lfHeight	 resd      	1	; LONG
.lfMenuFont.lfWidth	 resd      	1	; LONG
.lfMenuFont.lfEscapement	 resd      	1	; LONG
.lfMenuFont.lfOrientation	 resd      	1	; LONG
.lfMenuFont.lfWeight	 resd      	1	; LONG
.lfMenuFont.lfItalic	 resb      	1	; BYTE
.lfMenuFont.lfUnderline	 resb      	1	; BYTE
.lfMenuFont.lfStrikeOut	 resb      	1	; BYTE
.lfMenuFont.lfCharSet	 resb      	1	; BYTE
.lfMenuFont.lfOutPrecision	 resb      	1	; BYTE
.lfMenuFont.lfClipPrecision	 resb      	1	; BYTE
.lfMenuFont.lfQuality	 resb      	1	; BYTE
.lfMenuFont.lfPitchAndFamily	 resb      	1	; BYTE
.lfMenuFont.lfFaceName	 resb      	0	; TCHAR
; ENDSTRUC 'LOGFONT'
; STRUC 'LOGFONT'
.lfStatusFont.lfHeight	 resd      	1	; LONG
.lfStatusFont.lfWidth	 resd      	1	; LONG
.lfStatusFont.lfEscapement	 resd      	1	; LONG
.lfStatusFont.lfOrientation	 resd      	1	; LONG
.lfStatusFont.lfWeight	 resd      	1	; LONG
.lfStatusFont.lfItalic	 resb      	1	; BYTE
.lfStatusFont.lfUnderline	 resb      	1	; BYTE
.lfStatusFont.lfStrikeOut	 resb      	1	; BYTE
.lfStatusFont.lfCharSet	 resb      	1	; BYTE
.lfStatusFont.lfOutPrecision	 resb      	1	; BYTE
.lfStatusFont.lfClipPrecision	 resb      	1	; BYTE
.lfStatusFont.lfQuality	 resb      	1	; BYTE
.lfStatusFont.lfPitchAndFamily	 resb      	1	; BYTE
.lfStatusFont.lfFaceName	 resb      	0	; TCHAR
; ENDSTRUC 'LOGFONT'
; STRUC 'LOGFONT'
.lfMessageFont.lfHeight	 resd      	1	; LONG
.lfMessageFont.lfWidth	 resd      	1	; LONG
.lfMessageFont.lfEscapement	 resd      	1	; LONG
.lfMessageFont.lfOrientation	 resd      	1	; LONG
.lfMessageFont.lfWeight	 resd      	1	; LONG
.lfMessageFont.lfItalic	 resb      	1	; BYTE
.lfMessageFont.lfUnderline	 resb      	1	; BYTE
.lfMessageFont.lfStrikeOut	 resb      	1	; BYTE
.lfMessageFont.lfCharSet	 resb      	1	; BYTE
.lfMessageFont.lfOutPrecision	 resb      	1	; BYTE
.lfMessageFont.lfClipPrecision	 resb      	1	; BYTE
.lfMessageFont.lfQuality	 resb      	1	; BYTE
.lfMessageFont.lfPitchAndFamily	 resb      	1	; BYTE
.lfMessageFont.lfFaceName	 resb      	0	; TCHAR
; ENDSTRUC 'LOGFONT'
ENDSTRUC

STRUC SERVICE_ADDRESS
.dwAddressType:   	 resd      	1	; DWORD
.dwAddressFlags:  	 resd      	1	; DWORD
.dwAddressLength: 	 resd      	1	; DWORD
.dwPrincipalLength:	 resd      	1	; DWORD
ENDSTRUC

STRUC SERVICE_ADDRESSES
.dwAddressCount:  	 resd      	1	; DWORD
; STRUC 'SERVICE_ADDRESS'
.Addresses.dwAddressType	 resd      	1	; DWORD
.Addresses.dwAddressFlags	 resd      	1	; DWORD
.Addresses.dwAddressLength	 resd      	1	; DWORD
.Addresses.dwPrincipalLength	 resd      	1	; DWORD
; ENDSTRUC 'SERVICE_ADDRESS'
ENDSTRUC

STRUC GUID
Data1:			 resd		1
Data2:			 resw		1
Data3:			 resw		1
Data4:			 resb		8
ENDSTRUC

STRUC RemHGLOBAL
.fNullHGlobal:    	 resd      	1	; long
.cbData:		 resd		1	; unsigned LONG
ENDSTRUC

STRUC RemHMETAFILEPICT 
.mm:              	 resd      	1	; long
.xExt:            	 resd      	1	; long
.yExt:            	 resd      	1	; long
.cbData:		 resd		1	; unsigned LONG
ENDSTRUC

STRUC RemHENHMETAFILE
.cbData:		 resd		1	; unsigned LONG
.data:			 resb		1
ENDSTRUC

STRUC  RemHBITMAP 
.cbData:		 resd		1	; unsigned LONG
.data:            	 resb      	1	; char
ENDSTRUC

STRUC RemHPALETTE
.cbData:		 resd		1	; unsigned LONG
.data:            	 resb      	1	; char
ENDSTRUC

STRUC RemBRUSH
.cbData:		 resd		1	; unsigned LONG
.data:            	 resb      	1	; char
ENDSTRUC

STRUC SERVICE_INFO
.lpServiceName:   	 resd      	1	; LPTSTR
.lpComment:       	 resd      	1	; LPTSTR
.lpLocale:        	 resd      	1	; LPTSTR
.dwDisplayHint:   	 resd      	1	; DWORD
.dwVersion:       	 resd      	1	; DWORD
.dwTime:          	 resd      	1	; DWORD
.lpMachineName:   	 resd      	1	; LPTSTR
ENDSTRUC

STRUC NS_SERVICE_INFO
.dwNameSpace:     	 resd      	1	; DWORD
; STRUC 'SERVICE_INFO'
.ServiceInfo.lpServiceName	 resd      	1	; LPTSTR
.ServiceInfo.lpComment	 resd      	1	; LPTSTR
.ServiceInfo.lpLocale	 resd      	1	; LPTSTR
.ServiceInfo.dwDisplayHint	 resd      	1	; DWORD
.ServiceInfo.dwVersion	 resd      	1	; DWORD
.ServiceInfo.dwTime	 resd      	1	; DWORD
.ServiceInfo.lpMachineName	 resd      	1	; LPTSTR
; ENDSTRUC 'SERVICE_INFO'
ENDSTRUC

STRUC numberfmt
.NumDigits:       	 resd      	1	; UINT
.LeadingZero:     	 resd      	1	; UINT
.Grouping:        	 resd      	1	; UINT
.lpDecimalSep:    	 resd      	1	; LPTSTR
.lpThousandSep:   	 resd      	1	; LPTSTR
.NegativeOrder:   	 resd      	1	; UINT
ENDSTRUC

STRUC OFSTRUCT
.cBytes:          	 resb      	1	; BYTE
.fFixedDisk:      	 resb      	1	; BYTE
.nErrCode:        	 resw      	1	; WORD
.Reserved1:       	 resw      	1	; WORD
.Reserved2:       	 resw      	1	; WORD
.szPathName:      	 resb      	0	; CHAR
ENDSTRUC

STRUC OFN
.lStructSize:     	 resd      	1	; DWORD
.hwndOwner:       	 resd      	1	; HWND
.hInstance:       	 resd      	1	; HINSTANCE
.lpstrFilter:     	 resd      	1	; LPCTSTR
.lpstrCustomFilter:	 resd      	1	; LPTSTR
.nMaxCustFilter:  	 resd      	1	; DWORD
.nFilterIndex:    	 resd      	1	; DWORD
.lpstrFile:       	 resd      	1	; LPTSTR
.nMaxFile:        	 resd      	1	; DWORD
.lpstrFileTitle:  	 resd      	1	; LPTSTR
.nMaxFileTitle:   	 resd      	1	; DWORD
.lpstrInitialDir: 	 resd      	1	; LPCTSTR
.lpstrTitle:      	 resd      	1	; LPCTSTR
.Flags:           	 resd      	1	; DWORD
.nFileOffset:     	 resw      	1	; WORD
.nFileExtension:  	 resw      	1	; WORD
.lpstrDefExt:     	 resd      	1	; LPCTSTR
.lCustData:       	 resd      	1	; DWORD
.lpTemplateName:  	 resd      	1	; LPCTSTR
ENDSTRUC

STRUC OFNOTIFY
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.pszFile:         	 resd      	1	; LPTSTR
ENDSTRUC

STRUC OSVERSIONINFO
.dwOSVersionInfoSize:	 resd      	1	; DWORD
.dwMajorVersion:  	 resd      	1	; DWORD
.dwMinorVersion:  	 resd      	1	; DWORD
.dwBuildNumber:   	 resd      	1	; DWORD
.dwPlatformId:    	 resd      	1	; DWORD
.szCSDVersion:    	 resb      	128	; TCHAR
ENDSTRUC

STRUC TEXTMETRIC
.tmHeight:        	 resd      	1	; LONG
.tmAscent:        	 resd      	1	; LONG
.tmDescent:       	 resd      	1	; LONG
.tmInternalLeading:	 resd      	1	; LONG
.tmExternalLeading:	 resd      	1	; LONG
.tmAveCharWidth:  	 resd      	1	; LONG
.tmMaxCharWidth:  	 resd      	1	; LONG
.tmWeight:        	 resd      	1	; LONG
.tmOverhang:      	 resd      	1	; LONG
.tmDigitizedAspectX:	 resd      	1	; LONG
.tmDigitizedAspectY:	 resd      	1	; LONG
.tmItalic:        	 resb      	1	; BYTE
.tmUnderlined:    	 resb      	1	; BYTE
.tmStruckOut:     	 resb      	1	; BYTE
.tmPitchAndFamily:	 resb      	1	; BYTE
.tmCharSet:       	 resb      	1	; BYTE
.pad1:            	 resb      	1	; BYTE
.pad2:            	 resb      	1	; BYTE
.pad3:            	 resb      	1	; BYTE
ENDSTRUC

STRUC OUTLINETEXTMETRIC
.otmSize:         	 resd      	1	; UINT
; STRUC 'TEXTMETRIC'
.otmTextMetrics.tmHeight	 resd      	1	; LONG
.otmTextMetrics.tmAscent	 resd      	1	; LONG
.otmTextMetrics.tmDescent	 resd      	1	; LONG
.otmTextMetrics.tmInternalLeading	 resd      	1	; LONG
.otmTextMetrics.tmExternalLeading	 resd      	1	; LONG
.otmTextMetrics.tmAveCharWidth	 resd      	1	; LONG
.otmTextMetrics.tmMaxCharWidth	 resd      	1	; LONG
.otmTextMetrics.tmWeight	 resd      	1	; LONG
.otmTextMetrics.tmOverhang	 resd      	1	; LONG
.otmTextMetrics.tmDigitizedAspectX	 resd      	1	; LONG
.otmTextMetrics.tmDigitizedAspectY	 resd      	1	; LONG
.otmTextMetrics.tmItalic	 resb      	1	; BYTE
.otmTextMetrics.tmUnderlined	 resb      	1	; BYTE
.otmTextMetrics.tmStruckOut	 resb      	1	; BYTE
.otmTextMetrics.tmPitchAndFamily	 resb      	1	; BYTE
.otmTextMetrics.tmCharSet	 resb      	1	; BYTE
.otmTextMetrics.pad1	 resb      	1	; BYTE
.otmTextMetrics.pad2	 resb      	1	; BYTE
.otmTextMetrics.pad3	 resb      	1	; BYTE
; ENDSTRUC 'TEXTMETRIC'
.otmFiller:       	 resb      	1	; BYTE
; STRUC 'PANOSE'
.otmPanoseNumber.bFamilyType	 resb      	1	; BYTE
.otmPanoseNumber.bSerifStyle	 resb      	1	; BYTE
.otmPanoseNumber.bWeight	 resb      	1	; BYTE
.otmPanoseNumber.bProportion	 resb      	1	; BYTE
.otmPanoseNumber.bContrast	 resb      	1	; BYTE
.otmPanoseNumber.bStrokeVariation	 resb      	1	; BYTE
.otmPanoseNumber.bArmStyle	 resb      	1	; BYTE
.otmPanoseNumber.bLetterform	 resb      	1	; BYTE
.otmPanoseNumber.bMidline	 resb      	1	; BYTE
.otmPanoseNumber.bXHeight	 resb      	1	; BYTE
; ENDSTRUC 'PANOSE'
.otmfsSelection:  	 resd      	1	; UINT
.otmfsType:       	 resd      	1	; UINT
.otmsCharSlopeRise:	 resd      	1	; int
.otmsCharSlopeRun:	 resd      	1	; int
.otmItalicAngle:  	 resd      	1	; int
.otmEMSquare:     	 resd      	1	; UINT
.otmAscent:       	 resd      	1	; int
.otmDescent:      	 resd      	1	; int
.otmLineGap:      	 resd      	1	; UINT
.otmsCapEmHeight: 	 resd      	1	; UINT
.otmsXHeight:     	 resd      	1	; UINT
; STRUC 'RECT'
.otmrcFontBox.left	 resd      	1	; LONG
.otmrcFontBox.top 	 resd      	1	; LONG
.otmrcFontBox.right	 resd      	1	; LONG
.otmrcFontBox.bottom	 resd      	1	; LONG
; ENDSTRUC 'RECT'
.otmMacAscent:    	 resd      	1	; int
.otmMacDescent:   	 resd      	1	; int
.otmMacLineGap:   	 resd      	1	; UINT
.otmusMinimumPPEM:	 resd      	1	; UINT
; STRUC 'POINT'
.otmptSubscriptSize.x	 resd      	1	; LONG
.otmptSubscriptSize.y	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'POINT'
.otmptSubscriptOffset.x	 resd      	1	; LONG
.otmptSubscriptOffset.y	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'POINT'
.otmptSuperscriptSize.x	 resd      	1	; LONG
.otmptSuperscriptSize.y	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'POINT'
.otmptSuperscriptOffset.x	 resd      	1	; LONG
.otmptSuperscriptOffset.y	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.otmsStrikeoutSize:	 resd      	1	; UINT
.otmsStrikeoutPosition:	 resd      	1	; int
.otmsUnderscoreSize:	 resd      	1	; int
.otmsUnderscorePosition:	 resd      	1	; int
ENDSTRUC

STRUC OVERLAPPED
.Internal:        	 resd      	1	; DWORD
.InternalHigh:    	 resd      	1	; DWORD
.Offset:          	 resd      	1	; DWORD
.OffsetHigh:      	 resd      	1	; DWORD
.hEvent:          	 resd      	1	; HANDLE
ENDSTRUC

STRUC PSD
.lStructSize:     	 resd      	1	; DWORD
.hwndOwner:       	 resd      	1	; HWND
.Flags:           	 resd      	1	; DWORD
; STRUC 'POINT'
.ptPaperSize.x    	 resd      	1	; LONG
.ptPaperSize.y    	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'RECT'
.rtMinMargin.left 	 resd      	1	; LONG
.rtMinMargin.top  	 resd      	1	; LONG
.rtMinMargin.right	 resd      	1	; LONG
.rtMinMargin.bottom	 resd      	1	; LONG
; ENDSTRUC 'RECT'
; STRUC 'RECT'
.rtMargin.left    	 resd      	1	; LONG
.rtMargin.top     	 resd      	1	; LONG
.rtMargin.right   	 resd      	1	; LONG
.rtMargin.bottom  	 resd      	1	; LONG
; ENDSTRUC 'RECT'
.hInstance:       	 resd      	1	; HINSTANCE
.lCustData:       	 resd      	1	; LPARAM
.lpPageSetupTemplateName:	 resd      	1	; LPCTSTR
ENDSTRUC

STRUC PAINTSTRUCT
.fErase:          	 resd      	1	; BOOL
; STRUC 'RECT'
.rcPaint.left     	 resd      	1	; LONG
.rcPaint.top      	 resd      	1	; LONG
.rcPaint.right    	 resd      	1	; LONG
.rcPaint.bottom   	 resd      	1	; LONG
; ENDSTRUC 'RECT'
.fRestore:        	 resd      	1	; BOOL
.fIncUpdate:      	 resd      	1	; BOOL
.rgbReserved:     	 resb      	32	; BYTE
ENDSTRUC

STRUC paraformat
.cbSize:          	 resd      	1	; UINT
.dwMask:          	 resd      	1	; DWORD
.wNumbering:      	 resw      	1	; WORD
.wReserved:       	 resw      	1	; WORD
.dxStartIndent:   	 resd      	1	; LONG
.dxRightIndent:   	 resd      	1	; LONG
.dxOffset:        	 resd      	1	; LONG
.wAlignment:      	 resw      	1	; WORD
.cTabCount:       	 resw      	1	; SHORT
.rgxTabs:         	 resd      	0	; LONG
ENDSTRUC

STRUC POLYTEXT
.x:               	 resd      	1	; int
.y:               	 resd      	1	; int
.n:               	 resd      	1	; UINT
.lpstr:           	 resd      	1	; LPCTSTR
.uiFlags:         	 resd      	1	; UINT
; STRUC 'RECT'
.rcl.left         	 resd      	1	; LONG
.rcl.top          	 resd      	1	; LONG
.rcl.right        	 resd      	1	; LONG
.rcl.bottom       	 resd      	1	; LONG
; ENDSTRUC 'RECT'
; STRUC 'pd'
.x.lStructSize    	 resd      	1	; DWORD
.x.hwndOwner      	 resd      	1	; HWND
.x.hDevMode       	 resd      	1	; HANDLE
.x.hDevNames      	 resd      	1	; HANDLE
.x.Flags          	 resd      	1	; DWORD
.x.nFromPage      	 resw      	1	; WORD
.x.nToPage        	 resw      	1	; WORD
.x.nMinPage       	 resw      	1	; WORD
.x.nMaxPage       	 resw      	1	; WORD
.x.nCopies        	 resw      	1	; WORD
.x.hInstance      	 resd      	1	; HINSTANCE
.x.lCustData      	 resd      	1	; DWORD
.x.lpPrintTemplateName	 resd      	1	; LPCTSTR
.x.lpSetupTemplateName	 resd      	1	; LPCTSTR
.x.hPrintTemplate 	 resd      	1	; HANDLE
.x.hSetupTemplate 	 resd      	1	; HANDLE
; ENDSTRUC 'pd'
ENDSTRUC

STRUC PORT_INFO_1
.pName:           	 resd      	1	; LPTSTR
ENDSTRUC

STRUC PORT_INFO_2
.pPortName:       	 resd      	1	; LPSTR
.pMonitorName:    	 resd      	1	; LPSTR
.pDescription:    	 resd      	1	; LPSTR
.fPortType:       	 resd      	1	; DWORD
.Reserved:        	 resd      	1	; DWORD
ENDSTRUC

STRUC PD
.lStructSize:     	 resd      	1	; DWORD
.hwndOwner:       	 resd      	1	; HWND
.hDevMode:        	 resd      	1	; HANDLE
.hDevNames:       	 resd      	1	; HANDLE
.Flags:           	 resd      	1	; DWORD
.nFromPage:       	 resw      	1	; WORD
.nToPage:         	 resw      	1	; WORD
.nMinPage:        	 resw      	1	; WORD
.nMaxPage:        	 resw      	1	; WORD
.nCopies:         	 resw      	1	; WORD
.hInstance:       	 resd      	1	; HINSTANCE
.lCustData:       	 resd      	1	; DWORD
.lpPrintTemplateName:	 resd      	1	; LPCTSTR
.lpSetupTemplateName:	 resd      	1	; LPCTSTR
.hPrintTemplate:  	 resd      	1	; HANDLE
.hSetupTemplate:  	 resd      	1	; HANDLE
ENDSTRUC

STRUC PRINTER_DEFAULTS
.pDatatype:       	 resd      	1	; LPTSTR
ENDSTRUC

STRUC PRINTPROCESSOR_INFO_1
.pName:           	 resd      	1	; LPTSTR
ENDSTRUC

STRUC PRIVILEGE_SET
.PrivilegeCount:  	 resd      	1	; DWORD
.Control:         	 resd      	1	; DWORD
; STRUC 'LUID_AND_ATTRIBUTES'
.Privilege.Luid	 	 resd      	2	; LUID
.Privilege.Attributes	 resd      	1	; DWORD
; ENDSTRUC 'LUID_AND_ATTRIBUTES'
ENDSTRUC

STRUC PROCESS_HEAP_ENTRY
.lpData:          	 resd      	1	; PVOID
.cbData:          	 resd      	1	; DWORD
.cbOverhead:      	 resb      	1	; BYTE
.iRegionIndex:    	 resb      	1	; BYTE
.wFlags:          	 resw      	1	; WORD
.dwCommittedSize: 	 resd      	1	; DWORD
.dwUnCommittedSize:	 resd      	1	; DWORD
.lpFirstBlock:    	 resd      	1	; LPVOID
.lpLastBlock:     	 resd      	1	; LPVOID
.hMem:            	 resd      	1	; HANDLE
ENDSTRUC

STRUC PROCESS_INFORMATION
.hProcess:        	 resd      	1	; HANDLE
.hThread:         	 resd      	1	; HANDLE
.dwProcessId:     	 resd      	1	; DWORD
.dwThreadId:      	 resd      	1	; DWORD
ENDSTRUC

;STRUC PROPSHEETPAGE
;.dwSize:          	 resd      	1	; DWORD
;.dwFlags:         	 resd      	1	; DWORD
;.hInstance:       	 resd      	1	; HINSTANCE
;	union {
;.pszTemplate:     	 resd      	1	; LPCTSTR
;	};
;	union {
;.pszIcon:         	 resd      	1	; LPCTSTR
;	};
;.pszTitle:        	 resd      	1	; LPCTSTR
;.lParam:          	 resd      	1	; LPARAM
;ENDSTRUC

;STRUC PROPSHEETHEADER
;.dwSize:          	 resd      	1	; DWORD
;.dwFlags:         	 resd      	1	; DWORD
;.hwndParent:      	 resd      	1	; HWND
;.hInstance:       	 resd      	1	; HINSTANCE
;;	union {
;.pszIcon:         	 resd      	1	; LPCTSTR
;;	};
;.pszCaption:      	 resd      	1	; LPCTSTR
;.nPages:          	 resd      	1	; UINT
;	union {
;.nStartPage:      	 resd      	1	; UINT
;.pStartPage:      	 resd      	1	; LPCTSTR
;	};
;	union {
;	};
;ENDSTRUC

STRUC PROTOCOL_INFO
.dwServiceFlags:  	 resd      	1	; DWORD
.iAddressFamily:  	 resd      	1	; INT
.iMaxSockAddr:    	 resd      	1	; INT
.iMinSockAddr:    	 resd      	1	; INT
.iSocketType:     	 resd      	1	; INT
.iProtocol:       	 resd      	1	; INT
.dwMessageSize:   	 resd      	1	; DWORD
.lpProtocol:      	 resd      	1	; LPTSTR
ENDSTRUC

STRUC PROVIDOR_INFO_1
.pName:           	 resd      	1	; LPTSTR
.pEnvironment:    	 resd      	1	; LPTSTR
.pDLLName:        	 resd      	1	; LPTSTR
ENDSTRUC

STRUC PSHNOTIFY
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.lParam:          	 resd      	1	; LPARAM
ENDSTRUC

STRUC punctuation
.iSize:           	 resd      	1	; UINT
.szPunctuation:   	 resd      	1	; LPSTR
ENDSTRUC

STRUC QUERY_SERVICE_CONFIG
.dwServiceType:   	 resd      	1	; DWORD
.dwStartType:     	 resd      	1	; DWORD
.dwErrorControl:  	 resd      	1	; DWORD
.lpBinaryPathName:	 resd      	1	; LPTSTR
.lpLoadOrderGroup:	 resd      	1	; LPTSTR
.dwTagId:         	 resd      	1	; DWORD
.lpDependencies:  	 resd      	1	; LPTSTR
.lpServiceStartName:	 resd      	1	; LPTSTR
.lpDisplayName:   	 resd      	1	; LPTSTR
ENDSTRUC

STRUC QUERY_SERVICE_LOCK_STATUS
.fIsLocked:       	 resd      	1	; DWORD
.lpLockOwner:     	 resd      	1	; LPTSTR
.dwLockDuration:  	 resd      	1	; DWORD
ENDSTRUC

STRUC RASAMB
.dwSize:          	 resd      	1	; DWORD
.dwError:         	 resd      	1	; DWORD
;	TCHAR szNetBiosError[NETBIOS_NAME_LEN + 1];
.bLana:           	 resb      	1	; BYTE
ENDSTRUC

STRUC RASTERIZER_STATUS
.nSize:           	 resw      	1	; short
.wFlags:          	 resw      	1	; short
.nLanguageID:     	 resw      	1	; short
ENDSTRUC

STRUC REMOTE_NAME_INFO
.lpUniversalName: 	 resd      	1	; LPTSTR
.lpConnectionName:	 resd      	1	; LPTSTR
.lpRemainingPath: 	 resd      	1	; LPTSTR
ENDSTRUC

STRUC repastespecial
.dwAspect:        	 resd      	1	; DWORD
.dwParam:         	 resd      	1	; DWORD
ENDSTRUC

STRUC reqresize
; STRUC 'NMHDR'
.nmhdr.hwndFrom   	 resd      	1	; HWND
.nmhdr.idFrom     	 resd      	1	; UINT
.nmhdr.code       	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
; STRUC 'RECT'
.rc.left          	 resd      	1	; LONG
.rc.top           	 resd      	1	; LONG
.rc.right         	 resd      	1	; LONG
.rc.bottom        	 resd      	1	; LONG
; ENDSTRUC 'RECT'
ENDSTRUC

STRUC RGNDATAHEADER
.dwSize:          	 resd      	1	; DWORD
.iType:           	 resd      	1	; DWORD
.nCount:          	 resd      	1	; DWORD
.nRgnSize:        	 resd      	1	; DWORD
; STRUC 'RECT'
.rcBound.left     	 resd      	1	; LONG
.rcBound.top      	 resd      	1	; LONG
.rcBound.right    	 resd      	1	; LONG
.rcBound.bottom   	 resd      	1	; LONG
; ENDSTRUC 'RECT'
ENDSTRUC

STRUC RGNDATA
; STRUC 'RGNDATAHEADER'
.rdh.dwSize       	 resd      	1	; DWORD
.rdh.iType        	 resd      	1	; DWORD
.rdh.nCount       	 resd      	1	; DWORD
.rdh.nRgnSize     	 resd      	1	; DWORD
.rdh.rcBound.left 	 resd      	1	; LONG
.rdh.rcBound.top  	 resd      	1	; LONG
.rdh.rcBound.right	 resd      	1	; LONG
.rdh.rcBound.bottom	 resd      	1	; LONG
; ENDSTRUC 'RGNDATAHEADER'
.Buffer:          	 resb      	1	; char
ENDSTRUC

STRUC SCROLLINFO
.cbSize:          	 resd      	1	; UINT
.fMask:           	 resd      	1	; UINT
.nMin:            	 resd      	1	; int
.nMax:            	 resd      	1	; int
.nPage:           	 resd      	1	; UINT
.nPos:            	 resd      	1	; int
.nTrackPos:       	 resd      	1	; int
ENDSTRUC

STRUC SECURITY_ATTRIBUTES
.nLength:         	 resd      	1	; DWORD
.lpSecurityDescriptor:	 resd      	1	; LPVOID
.bInheritHandle:  	 resd      	1	; BOOL
ENDSTRUC

STRUC selchange
; STRUC 'NMHDR'
.nmhdr.hwndFrom   	 resd      	1	; HWND
.nmhdr.idFrom     	 resd      	1	; UINT
.nmhdr.code       	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
; STRUC 'CHARRANGE'
.chrg.aflBlock    	 resd      	3	; DWORD
.chrg.fsUsb       	 resd      	4	; DWORD
.chrg.ciCharset   	 resd      	1	; UINT
.chrg.ciACP       	 resd      	1	; UINT
; ENDSTRUC 'CHARRANGE'
.seltyp:          	 resw      	1	; WORD
ENDSTRUC

STRUC SERIALKEYS
.cbSize:          	 resd      	1	; DWORD
.dwFlags:         	 resd      	1	; DWORD
.lpszActivePort:  	 resd      	1	; LPSTR
.lpszPort:        	 resd      	1	; LPSTR
.iBaudRate:       	 resd      	1	; DWORD
.iPortState:      	 resd      	1	; DWORD
ENDSTRUC

STRUC SERVICE_TABLE_ENTRY
.lpServiceName:   	 resd      	1	; LPTSTR
ENDSTRUC

STRUC SERVICE_TYPE_VALUE_ABS
.dwNameSpace:     	 resd      	1	; DWORD
.dwValueType:     	 resd      	1	; DWORD
.dwValueSize:     	 resd      	1	; DWORD
.lpValueName:     	 resd      	1	; LPTSTR
.lpValue:         	 resd      	1	; PVOID
ENDSTRUC

STRUC SERVICE_TYPE_INFO_ABS
.lpTypeName:      	 resd      	1	; LPTSTR
.dwValueCount:    	 resd      	1	; DWORD
; STRUC 'SERVICE_TYPE_VALUE_ABS'
.Values.dwNameSpace	 resd      	1	; DWORD
.Values.dwValueType	 resd      	1	; DWORD
.Values.dwValueSize	 resd      	1	; DWORD
.Values.lpValueName	 resd      	1	; LPTSTR
.Values.lpValue   	 resd      	1	; PVOID
; ENDSTRUC 'SERVICE_TYPE_VALUE_ABS'
ENDSTRUC

STRUC SESSION_BUFFER
.lsn:             	 resb      	1	; UCHAR
.state:           	 resb      	1	; UCHAR
.local_name:      	 resb      	0	; UCHAR
.remote_name:     	 resb      	0	; UCHAR
.rcvs_outstanding:	 resb      	1	; UCHAR
.sends_outstanding:	 resb      	1	; UCHAR
ENDSTRUC

STRUC SESSION_HEADER
.sess_name:       	 resb      	1	; UCHAR
.num_sess:        	 resb      	1	; UCHAR
.rcv_dg_outstanding:	 resb      	1	; UCHAR
.rcv_any_outstanding:	 resb      	1	; UCHAR
ENDSTRUC

STRUC SHFILEINFO
.iIcon:           	 resd      	1	; int
.dwAttributes:    	 resd      	1	; DWORD
.szDisplayName:   	 resb      	0	; char
.szTypeName:      	 resb      	80	; char
ENDSTRUC

STRUC SID_AND_ATTRIBUTES
.Attributes:      	 resd      	1	; DWORD
ENDSTRUC

STRUC SINGLE_LIST_ENTRY
ENDSTRUC

STRUC SOUNDSENTRY
.cbSize:          	 resd      	1	; UINT
.dwFlags:         	 resd      	1	; DWORD
.iFSTextEffect:   	 resd      	1	; DWORD
.iFSTextEffectMSec:	 resd      	1	; DWORD
.iFSTextEffectColorBits:	 resd      	1	; DWORD
.iFSGrafEffect:   	 resd      	1	; DWORD
.iFSGrafEffectMSec:	 resd      	1	; DWORD
.iFSGrafEffectColor:	 resd      	1	; DWORD
.iWindowsEffect:  	 resd      	1	; DWORD
.iWindowsEffectMSec:	 resd      	1	; DWORD
.lpszWindowsEffectDLL:	 resd      	1	; LPTSTR
.iWindowsEffectOrdinal:	 resd      	1	; DWORD
ENDSTRUC

STRUC STARTUPINFO
.cb:              	 resd      	1	; DWORD
.lpReserved:      	 resd      	1	; LPTSTR
.lpDesktop:       	 resd      	1	; LPTSTR
.lpTitle:         	 resd      	1	; LPTSTR
.dwX:             	 resd      	1	; DWORD
.dwY:             	 resd      	1	; DWORD
.dwXSize:         	 resd      	1	; DWORD
.dwYSize:         	 resd      	1	; DWORD
.dwXCountChars:   	 resd      	1	; DWORD
.dwYCountChars:   	 resd      	1	; DWORD
.dwFillAttribute: 	 resd      	1	; DWORD
.dwFlags:         	 resd      	1	; DWORD
.wShowWindow:     	 resw      	1	; WORD
.cbReserved2:     	 resw      	1	; WORD
.hStdInput:       	 resd      	1	; HANDLE
.hStdOutput:      	 resd      	1	; HANDLE
.hStdError:       	 resd      	1	; HANDLE
ENDSTRUC

STRUC STICKYKEYS
.cbSize:          	 resd      	1	; DWORD
.dwFlags:         	 resd      	1	; DWORD
ENDSTRUC

;STRUC STRRET
;.uType:           	 resd      	1	; UINT
;	union {
;.uOffset:         	 resd      	1	; UINT
;.cStr:            	 resb      	0	; char
;ENDSTRUC

STRUC STYLEBUF
.dwStyle:         	 resd      	1	; DWORD
.szDescription:   	 resb      	32	; CHAR
ENDSTRUC

STRUC STYLESTRUCT
.styleOld:        	 resd      	1	; DWORD
.styleNew:        	 resd      	1	; DWORD
ENDSTRUC

STRUC SYSTEM_AUDIT_ACE
; STRUC 'ACE_HEADER'
.Header.AceType   	 resb      	1	; BYTE
.Header.AceFlags  	 resb      	1	; BYTE
.Header.AceSize   	 resw      	1	; WORD
; ENDSTRUC 'ACE_HEADER'
.SidStart:        	 resd      	1	; DWORD
ENDSTRUC

STRUC SYSTEM_INFO
.wProcessorArchitecture:	 resw      	1	; WORD
.wReserved:       	 resw      	1	; WORD
.dwPageSize:      	 resd      	1	; DWORD
.lpMinimumApplicationAddress:	 resd      	1	; LPVOID
.lpMaximumApplicationAddress:	 resd      	1	; LPVOID
.dwActiveProcessorMask:	 resd      	1	; DWORD
.dwNumberOfProcessors:	 resd      	1	; DWORD
.dwProcessorType: 	 resd      	1	; DWORD
.dwAllocationGranularity:	 resd      	1	; DWORD
.wProcessorLevel: 	 resw      	1	; WORD
.wProcessorRevision:	 resw      	1	; WORD
ENDSTRUC

STRUC SYSTEM_POWER_STATUS
.ACLineStatus:    	 resb      	1	; BYTE
.BatteryFlag:     	 resb      	1	; BYTE
.BatteryLifePercent:	 resb      	1	; BYTE
.Reserved1:       	 resb      	1	; BYTE
.BatteryLifeTime: 	 resd      	1	; DWORD
.BatteryFullLifeTime:	 resd      	1	; DWORD
ENDSTRUC

STRUC TAPE_ERASE
.Type:            	 resd      	1	; ULONG
ENDSTRUC

STRUC TAPE_GET_DRIVE_PARAMETERS
.DefaultBlockSize:	 resd      	1	; ULONG
.MaximumBlockSize:	 resd      	1	; ULONG
.MinimumBlockSize:	 resd      	1	; ULONG
.MaximumPartitionCount:	 resd      	1	; ULONG
.FeaturesLow:     	 resd      	1	; ULONG
.FeaturesHigh:    	 resd      	1	; ULONG
.EOTWarningZoneSize:	 resd      	1	; ULONG
ENDSTRUC

STRUC TAPE_GET_MEDIA_PARAMETERS
.BlockSize:       	 resd      	1	; DWORD
.PartitionCount:  	 resd      	1	; DWORD
ENDSTRUC

STRUC TAPE_GET_POSITION
.Type:            	 resd      	1	; ULONG
.Partition:       	 resd      	1	; ULONG
.OffsetLow:       	 resd      	1	; ULONG
.OffsetHigh:      	 resd      	1	; ULONG
ENDSTRUC

STRUC TAPE_PREPARE
.Operation:       	 resd      	1	; ULONG
ENDSTRUC

STRUC TAPE_SET_DRIVE_PARAMETERS
.EOTWarningZoneSize:	 resd      	1	; ULONG
ENDSTRUC

STRUC TAPE_SET_MEDIA_PARAMETERS
.BlockSize:       	 resd      	1	; ULONG
ENDSTRUC

STRUC TAPE_SET_POSITION
.Method:          	 resd      	1	; ULONG
.Partition:       	 resd      	1	; ULONG
.OffsetLow:       	 resd      	1	; ULONG
.OffsetHigh:      	 resd      	1	; ULONG
ENDSTRUC

STRUC TAPE_WRITE_MARKS
.Type:            	 resd      	1	; ULONG
.Count:           	 resd      	1	; ULONG
ENDSTRUC

STRUC TBBUTTON
.iBitmap:         	 resd      	1	; int
.idCommand:       	 resd      	1	; int
.fsState:         	 resb      	1	; BYTE
.fsStyle:         	 resb      	1	; BYTE
.bReserved:       	 resb      	2	; BYTE
.dwData:          	 resd      	1	; DWORD
.iString:         	 resd      	1	; int
ENDSTRUC

STRUC TC_HITTESTINFO
; STRUC 'POINT'
.pt.x             	 resd      	1	; LONG
.pt.y             	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.flags:           	 resd      	1	; UINT
ENDSTRUC

STRUC TC_ITEM
.mask:            	 resd      	1	; UINT
.lpReserved1:     	 resd      	1	; UINT
.lpReserved2:     	 resd      	1	; UINT
.pszText:         	 resd      	1	; LPTSTR
.cchTextMax:      	 resd      	1	; int
.iImage:          	 resd      	1	; int
.lParam:          	 resd      	1	; LPARAM
ENDSTRUC

STRUC TC_ITEMHEADER
.mask:            	 resd      	1	; UINT
.lpReserved1:     	 resd      	1	; UINT
.lpReserved2:     	 resd      	1	; UINT
.pszText:         	 resd      	1	; LPTSTR
.cchTextMax:      	 resd      	1	; int
.iImage:          	 resd      	1	; int
ENDSTRUC

STRUC TC_KEYDOWN
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.wVKey:           	 resw      	1	; WORD
.flags:           	 resd      	1	; UINT
ENDSTRUC

STRUC textrange
; STRUC 'CHARRANGE'
.chrg.aflBlock    	 resd      	3	; DWORD
.chrg.fsUsb       	 resd      	4	; DWORD
.chrg.ciCharset   	 resd      	1	; UINT
.chrg.ciACP       	 resd      	1	; UINT
; ENDSTRUC 'CHARRANGE'
.lpstrText:       	 resd      	1	; LPSTR
ENDSTRUC

STRUC TIME_ZONE_INFORMATION
.Bias:            	 resd      	1	; LONG
.StandardName:    	 resw      	32	; WCHAR
; STRUC 'SYSTEMTIME'
.StandardDate.wYear	 resw      	1	; WORD
.StandardDate.wMonth	 resw      	1	; WORD
.StandardDate.wDayOfWeek	 resw      	1	; WORD
.StandardDate.wDay	 resw      	1	; WORD
.StandardDate.wHour	 resw      	1	; WORD
.StandardDate.wMinute	 resw      	1	; WORD
.StandardDate.wSecond	 resw      	1	; WORD
.StandardDate.wMilliseconds	 resw      	1	; WORD
; ENDSTRUC 'SYSTEMTIME'
.StandardBias:    	 resd      	1	; LONG
.DaylightName:    	 resw      	32	; WCHAR
; STRUC 'SYSTEMTIME'
.DaylightDate.wYear	 resw      	1	; WORD
.DaylightDate.wMonth	 resw      	1	; WORD
.DaylightDate.wDayOfWeek	 resw      	1	; WORD
.DaylightDate.wDay	 resw      	1	; WORD
.DaylightDate.wHour	 resw      	1	; WORD
.DaylightDate.wMinute	 resw      	1	; WORD
.DaylightDate.wSecond	 resw      	1	; WORD
.DaylightDate.wMilliseconds	 resw      	1	; WORD
; ENDSTRUC 'SYSTEMTIME'
.DaylightBias:    	 resd      	1	; LONG
ENDSTRUC

STRUC TOGGLEKEYS
.cbSize:          	 resd      	1	; DWORD
.dwFlags:         	 resd      	1	; DWORD
ENDSTRUC


STRUC TPMPARAMS
.cbSize:          	 resd      	1	; UINT
; STRUC 'RECT'
.rcExclude.left   	 resd      	1	; LONG
.rcExclude.top    	 resd      	1	; LONG
.rcExclude.right  	 resd      	1	; LONG
.rcExclude.bottom 	 resd      	1	; LONG
; ENDSTRUC 'RECT'
ENDSTRUC

STRUC TT_HITTESTINFO
.hwnd:            	 resd      	1	; HWND
; STRUC 'POINT'
.pt.x             	 resd      	1	; LONG
.pt.y             	 resd      	1	; LONG
; ENDSTRUC 'POINT'
ENDSTRUC

STRUC TTPOLYCURVE
.wType:           	 resw      	1	; WORD
.cpfx:            	 resw      	1	; WORD
; STRUC 'POINTFX'
.apfx.x.fract     	 resw      	1	; WORD
.apfx.x.value     	 resw      	1	; short
.apfx.y.fract     	 resw      	1	; WORD
.apfx.y.value     	 resw      	1	; short
; ENDSTRUC 'POINTFX'
ENDSTRUC

STRUC TTPOLYGONHEADER
.cb:              	 resd      	1	; DWORD
.dwType:          	 resd      	1	; DWORD
; STRUC 'POINTFX'
.pfxStart.x.fract 	 resw      	1	; WORD
.pfxStart.x.value 	 resw      	1	; short
.pfxStart.y.fract 	 resw      	1	; WORD
.pfxStart.y.value 	 resw      	1	; short
; ENDSTRUC 'POINTFX'
ENDSTRUC

STRUC TV_DISPINFO
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
; STRUC 'TV_ITEM'
.item.mask        	 resd      	1	; UINT
.item.state       	 resd      	1	; UINT
.item.stateMask   	 resd      	1	; UINT
.item.pszText     	 resd      	1	; LPTSTR
.item.cchTextMax  	 resd      	1	; int
.item.iImage      	 resd      	1	; int
.item.iSelectedImage	 resd      	1	; int
.item.cChildren   	 resd      	1	; int
.item.lParam      	 resd      	1	; LPARAM
; ENDSTRUC 'TV_ITEM'
ENDSTRUC

STRUC TVHITTESTINFO
; STRUC 'POINT'
.pt.x             	 resd      	1	; LONG
.pt.y             	 resd      	1	; LONG
; ENDSTRUC 'POINT'
.flags:           	 resd      	1	; UINT
ENDSTRUC

STRUC TV_INSERTSTRUCT
; STRUC 'TV_ITEM'
.item.mask        	 resd      	1	; UINT
.item.state       	 resd      	1	; UINT
.item.stateMask   	 resd      	1	; UINT
.item.pszText     	 resd      	1	; LPTSTR
.item.cchTextMax  	 resd      	1	; int
.item.iImage      	 resd      	1	; int
.item.iSelectedImage	 resd      	1	; int
.item.cChildren   	 resd      	1	; int
.item.lParam      	 resd      	1	; LPARAM
; ENDSTRUC 'TV_ITEM'
ENDSTRUC

STRUC TV_KEYDOWN
; STRUC 'NMHDR'
.hdr.hwndFrom     	 resd      	1	; HWND
.hdr.idFrom       	 resd      	1	; UINT
.hdr.code         	 resd      	1	; UINT
; ENDSTRUC 'NMHDR'
.wVKey:           	 resw      	1	; WORD
.flags:           	 resd      	1	; UINT
ENDSTRUC

STRUC TV_SORTCB
.lParam:          	 resd      	1	; LPARAM
ENDSTRUC

STRUC ULARGE_INTEGER
.LowPart:         	 resd      	1	; DWORD
.HighPart:        	 resd      	1	; DWORD
ENDSTRUC

STRUC UNIVERSAL_NAME_INFO
.lpUniversalName: 	 resd      	1	; LPTSTR
ENDSTRUC

STRUC USEROBJECTFLAGS
.fInherit:        	 resd      	1	; BOOL
.fReserved:       	 resd      	1	; BOOL
.dwFlags:         	 resd      	1	; DWORD
ENDSTRUC

STRUC value_ent
.ve_valuename:    	 resd      	1	; LPTSTR
.ve_valuelen:     	 resd      	1	; DWORD
.ve_valueptr:     	 resd      	1	; DWORD
.ve_type:         	 resd      	1	; DWORD
ENDSTRUC

STRUC WIN32_FIND_DATA
.dwFileAttributes:	 resd      	1	; DWORD
; STRUC 'FILETIME'
.ftCreationTime.dwLowDateTime	 resd      	1	; DWORD
.ftCreationTime.dwHighDateTime	 resd      	1	; DWORD
; ENDSTRUC 'FILETIME'
; STRUC 'FILETIME'
.ftLastAccessTime.dwLowDateTime	 resd      	1	; DWORD
.ftLastAccessTime.dwHighDateTime	 resd      	1	; DWORD
; ENDSTRUC 'FILETIME'
; STRUC 'FILETIME'
.ftLastWriteTime.dwLowDateTime	 resd      	1	; DWORD
.ftLastWriteTime.dwHighDateTime	 resd      	1	; DWORD
; ENDSTRUC 'FILETIME'
.nFileSizeHigh:   	 resd      	1	; DWORD
.nFileSizeLow:    	 resd      	1	; DWORD
.dwReserved0:     	 resd      	1	; DWORD
.dwReserved1:     	 resd      	1	; DWORD
.cFileName:       	 resb      	0	; TCHAR
.cAlternateFileName:	 resb      	14	; TCHAR
.dummy:           	 resw      	1	; WORD
ENDSTRUC

STRUC WIN32_STREAM_ID
.dwStreamId:      	 resd      	1	; DWORD
.dwStreamAttributes:	 resd      	1	; DWORD
.dwStreamNameSize:	 resd      	1	; DWORD
ENDSTRUC

STRUC WINDOWPLACEMENT
.length:          	 resd      	1	; UINT
.flags:           	 resd      	1	; UINT
.showCmd:         	 resd      	1	; UINT
; STRUC 'POINT'
.ptMinPosition.x  	 resd      	1	; LONG
.ptMinPosition.y  	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'POINT'
.ptMaxPosition.x  	 resd      	1	; LONG
.ptMaxPosition.y  	 resd      	1	; LONG
; ENDSTRUC 'POINT'
; STRUC 'RECT'
.rcNormalPosition.left	 resd      	1	; LONG
.rcNormalPosition.top	 resd      	1	; LONG
.rcNormalPosition.right	 resd      	1	; LONG
.rcNormalPosition.bottom	 resd      	1	; LONG
; ENDSTRUC 'RECT'
ENDSTRUC

STRUC WNDCLASS
.style:           	 resd      	1	; UINT
.cbClsExtra:      	 resd      	1	; int
.cbWndExtra:      	 resd      	1	; int
.hInstance:       	 resd      	1	; HANDLE
.lpszMenuName:    	 resd      	1	; LPCTSTR
.lpszClassName:   	 resd      	1	; LPCTSTR
ENDSTRUC

STRUC WNDCLASSEX
.cbSize:          	 resd      	1	; UINT
.style:           	 resd      	1	; UINT
.cbClsExtra:      	 resd      	1	; int
.cbWndExtra:      	 resd      	1	; int
.hInstance:       	 resd      	1	; HANDLE
.lpszMenuName:    	 resd      	1	; LPCTSTR
.lpszClassName:   	 resd      	1	; LPCTSTR
ENDSTRUC

STRUC CONNECTDLGSTRUCT
.cbStructure:     	 resd      	1	; DWORD
.hwndOwner:       	 resd      	1	; HWND
.dwFlags:         	 resd      	1	; DWORD
.dwDevNum:        	 resd      	1	; DWORD
ENDSTRUC

STRUC DISCDLGSTRUCT
.cbStructure:     	 resd      	1	; DWORD
.hwndOwner:       	 resd      	1	; HWND
.lpLocalName:     	 resd      	1	; LPTSTR
.lpRemoteName:    	 resd      	1	; LPTSTR
.dwFlags:         	 resd      	1	; DWORD
ENDSTRUC

STRUC NETINFOSTRUCT
.cbStructure:     	 resd      	1	; DWORD
.dwProviderVersion:	 resd      	1	; DWORD
.dwStatus:        	 resd      	1	; DWORD
.dwCharacteristics:	 resd      	1	; DWORD
.dwHandle:        	 resd      	1	; DWORD
.wNetType:        	 resw      	1	; WORD
.dwPrinters:      	 resd      	1	; DWORD
.dwDrives:        	 resd      	1	; DWORD
ENDSTRUC

STRUC NETCONNECTINFOSTRUCT
.cbStructure:     	 resd      	1	; DWORD
.dwFlags:         	 resd      	1	; DWORD
.dwSpeed:         	 resd      	1	; DWORD
.dwDelay:         	 resd      	1	; DWORD
.dwOptDataSize:   	 resd      	1	; DWORD
ENDSTRUC

STRUC IMAGE_DOS_HEADER
.e_magic:         	 resw      	1	; WORD
.e_cblp:          	 resw      	1	; WORD
.e_cp:            	 resw      	1	; WORD
.e_crlc:          	 resw      	1	; WORD
.e_cparhdr:       	 resw      	1	; WORD
.e_minalloc:      	 resw      	1	; WORD
.e_maxalloc:      	 resw      	1	; WORD
.e_ss:            	 resw      	1	; WORD
.e_sp:            	 resw      	1	; WORD
.e_csum:          	 resw      	1	; WORD
.e_ip:            	 resw      	1	; WORD
.e_cs:            	 resw      	1	; WORD
.e_lfarlc:        	 resw      	1	; WORD
.e_ovno:          	 resw      	1	; WORD
.e_res:           	 resw      	4	; WORD
.e_oemid:         	 resw      	1	; WORD
.e_oeminfo:       	 resw      	1	; WORD
.e_res2:          	 resw      	10	; WORD
.e_lfanew:        	 resd      	1	; LONG
ENDSTRUC

STRUC IMAGE_OS2_HEADER
.ne_magic:        	 resw      	1	; WORD
.ne_ver:          	 resb      	1	; CHAR
.ne_rev:          	 resb      	1	; CHAR
.ne_enttab:       	 resw      	1	; WORD
.ne_cbenttab:     	 resw      	1	; WORD
.ne_crc:          	 resd      	1	; LONG
.ne_flags:        	 resw      	1	; WORD
.ne_autodata:     	 resw      	1	; WORD
.ne_heap:         	 resw      	1	; WORD
.ne_stack:        	 resw      	1	; WORD
.ne_csip:         	 resd      	1	; LONG
.ne_sssp:         	 resd      	1	; LONG
.ne_cseg:         	 resw      	1	; WORD
.ne_cmod:         	 resw      	1	; WORD
.ne_cbnrestab:    	 resw      	1	; WORD
.ne_segtab:       	 resw      	1	; WORD
.ne_rsrctab:      	 resw      	1	; WORD
.ne_restab:       	 resw      	1	; WORD
.ne_modtab:       	 resw      	1	; WORD
.ne_imptab:       	 resw      	1	; WORD
.ne_nrestab:      	 resd      	1	; LONG
.ne_cmovent:      	 resw      	1	; WORD
.ne_align:        	 resw      	1	; WORD
.ne_cres:         	 resw      	1	; WORD
.ne_exetyp:       	 resb      	1	; BYTE
.ne_flagsothers:  	 resb      	1	; BYTE
.ne_pretthunks:   	 resw      	1	; WORD
.ne_psegrefbytes: 	 resw      	1	; WORD
.ne_swaparea:     	 resw      	1	; WORD
.ne_expver:       	 resw      	1	; WORD
ENDSTRUC

STRUC IMAGE_VXD_HEADER
.e32_magic:       	 resw      	1	; WORD
.e32_border:      	 resb      	1	; BYTE
.e32_worder:      	 resb      	1	; BYTE
.e32_level:       	 resd      	1	; DWORD
.e32_cpu:         	 resw      	1	; WORD
.e32_os:          	 resw      	1	; WORD
.e32_ver:         	 resd      	1	; DWORD
.e32_mflags:      	 resd      	1	; DWORD
.e32_mpages:      	 resd      	1	; DWORD
.e32_startobj:    	 resd      	1	; DWORD
.e32_eip:         	 resd      	1	; DWORD
.e32_stackobj:    	 resd      	1	; DWORD
.e32_esp:         	 resd      	1	; DWORD
.e32_pagesize:    	 resd      	1	; DWORD
.e32_lastpagesize:	 resd      	1	; DWORD
.e32_fixupsize:   	 resd      	1	; DWORD
.e32_fixupsum:    	 resd      	1	; DWORD
.e32_ldrsize:     	 resd      	1	; DWORD
.e32_ldrsum:      	 resd      	1	; DWORD
.e32_objtab:      	 resd      	1	; DWORD
.e32_objcnt:      	 resd      	1	; DWORD
.e32_objmap:      	 resd      	1	; DWORD
.e32_itermap:     	 resd      	1	; DWORD
.e32_rsrctab:     	 resd      	1	; DWORD
.e32_rsrccnt:     	 resd      	1	; DWORD
.e32_restab:      	 resd      	1	; DWORD
.e32_enttab:      	 resd      	1	; DWORD
.e32_dirtab:      	 resd      	1	; DWORD
.e32_dircnt:      	 resd      	1	; DWORD
.e32_fpagetab:    	 resd      	1	; DWORD
.e32_frectab:     	 resd      	1	; DWORD
.e32_impmod:      	 resd      	1	; DWORD
.e32_impmodcnt:   	 resd      	1	; DWORD
.e32_impproc:     	 resd      	1	; DWORD
.e32_pagesum:     	 resd      	1	; DWORD
.e32_datapage:    	 resd      	1	; DWORD
.e32_preload:     	 resd      	1	; DWORD
.e32_nrestab:     	 resd      	1	; DWORD
.e32_cbnrestab:   	 resd      	1	; DWORD
.e32_nressum:     	 resd      	1	; DWORD
.e32_autodata:    	 resd      	1	; DWORD
.e32_debuginfo:   	 resd      	1	; DWORD
.e32_debuglen:    	 resd      	1	; DWORD
.e32_instpreload: 	 resd      	1	; DWORD
.e32_instdemand:  	 resd      	1	; DWORD
.e32_heapsize:    	 resd      	1	; DWORD
.e32_res3:        	 resb      	12	; BYTE
.e32_winresoff:   	 resd      	1	; DWORD
.e32_winreslen:   	 resd      	1	; DWORD
.e32_devid:       	 resw      	1	; WORD
.e32_ddkver:      	 resw      	1	; WORD
ENDSTRUC

STRUC IMAGE_FILE_HEADER
.Machine:         	 resw      	1	; WORD
.NumberOfSections:	 resw      	1	; WORD
.TimeDateStamp:   	 resd      	1	; DWORD
.PointerToSymbolTable:	 resd      	1	; DWORD
.NumberOfSymbols: 	 resd      	1	; DWORD
.SizeOfOptionalHeader:	 resw      	1	; WORD
.Characteristics: 	 resw      	1	; WORD
ENDSTRUC

STRUC IMAGE_DATA_DIRECTORY
.VirtualAddress:  	 resd      	1	; DWORD
.Size:            	 resd      	1	; DWORD
ENDSTRUC

STRUC IMAGE_OPTIONAL_HEADER
.Magic:           	 resw      	1	; WORD
.MajorLinkerVersion:	 resb      	1	; BYTE
.MinorLinkerVersion:	 resb      	1	; BYTE
.SizeOfCode:      	 resd      	1	; DWORD
.SizeOfInitializedData:	 resd      	1	; DWORD
.SizeOfUninitializedData:	 resd      	1	; DWORD
.AddressOfEntryPoint:	 resd      	1	; DWORD
.BaseOfCode:      	 resd      	1	; DWORD
.BaseOfData:      	 resd      	1	; DWORD
.ImageBase:       	 resd      	1	; DWORD
.SectionAlignment:	 resd      	1	; DWORD
.FileAlignment:   	 resd      	1	; DWORD
.MajorOperatingSystemVersion:	 resw      	1	; WORD
.MinorOperatingSystemVersion:	 resw      	1	; WORD
.MajorImageVersion:	 resw      	1	; WORD
.MinorImageVersion:	 resw      	1	; WORD
.MajorSubsystemVersion:	 resw      	1	; WORD
.MinorSubsystemVersion:	 resw      	1	; WORD
.Win32VersionValue:	 resd      	1	; DWORD
.SizeOfImage:     	 resd      	1	; DWORD
.SizeOfHeaders:   	 resd      	1	; DWORD
.CheckSum:        	 resd      	1	; DWORD
.Subsystem:       	 resw      	1	; WORD
.DllCharacteristics:	 resw      	1	; WORD
.SizeOfStackReserve:	 resd      	1	; DWORD
.SizeOfStackCommit:	 resd      	1	; DWORD
.SizeOfHeapReserve:	 resd      	1	; DWORD
.SizeOfHeapCommit:	 resd      	1	; DWORD
.LoaderFlags:     	 resd      	1	; DWORD
.NumberOfRvaAndSizes:	 resd      	1	; DWORD
; STRUC 'IMAGE_DATA_DIRECTORY'
.DataDirectory.VirtualAddress	 resd      	1	; DWORD
.DataDirectory.Size	 resd      	1	; DWORD
; ENDSTRUC 'IMAGE_DATA_DIRECTORY'
ENDSTRUC

STRUC IMAGE_ROM_OPTIONAL_HEADER
.Magic:           	 resw      	1	; WORD
.MajorLinkerVersion:	 resb      	1	; BYTE
.MinorLinkerVersion:	 resb      	1	; BYTE
.SizeOfCode:      	 resd      	1	; DWORD
.SizeOfInitializedData:	 resd      	1	; DWORD
.SizeOfUninitializedData:	 resd      	1	; DWORD
.AddressOfEntryPoint:	 resd      	1	; DWORD
.BaseOfCode:      	 resd      	1	; DWORD
.BaseOfData:      	 resd      	1	; DWORD
.BaseOfBss:       	 resd      	1	; DWORD
.GprMask:         	 resd      	1	; DWORD
.CprMask:         	 resd      	4	; DWORD
.GpValue:         	 resd      	1	; DWORD
ENDSTRUC

STRUC IMAGE_NT_HEADERS
.Signature:       	 resd      	1	; DWORD
; STRUC 'IMAGE_FILE_HEADER'
.FileHeader.Machine	 resw      	1	; WORD
.FileHeader.NumberOfSections	 resw      	1	; WORD
.FileHeader.TimeDateStamp	 resd      	1	; DWORD
.FileHeader.PointerToSymbolTable	 resd      	1	; DWORD
.FileHeader.NumberOfSymbols	 resd      	1	; DWORD
.FileHeader.SizeOfOptionalHeader	 resw      	1	; WORD
.FileHeader.Characteristics	 resw      	1	; WORD
; ENDSTRUC 'IMAGE_FILE_HEADER'
; STRUC 'IMAGE_OPTIONAL_HEADER'
.OptionalHeader.Magic	 resw      	1	; WORD
.OptionalHeader.MajorLinkerVersion	 resb      	1	; BYTE
.OptionalHeader.MinorLinkerVersion	 resb      	1	; BYTE
.OptionalHeader.SizeOfCode	 resd      	1	; DWORD
.OptionalHeader.SizeOfInitializedData	 resd      	1	; DWORD
.OptionalHeader.SizeOfUninitializedData	 resd      	1	; DWORD
.OptionalHeader.AddressOfEntryPoint	 resd      	1	; DWORD
.OptionalHeader.BaseOfCode	 resd      	1	; DWORD
.OptionalHeader.BaseOfData	 resd      	1	; DWORD
.OptionalHeader.ImageBase	 resd      	1	; DWORD
.OptionalHeader.SectionAlignment	 resd      	1	; DWORD
.OptionalHeader.FileAlignment	 resd      	1	; DWORD
.OptionalHeader.MajorOperatingSystemVersion	 resw      	1	; WORD
.OptionalHeader.MinorOperatingSystemVersion	 resw      	1	; WORD
.OptionalHeader.MajorImageVersion	 resw      	1	; WORD
.OptionalHeader.MinorImageVersion	 resw      	1	; WORD
.OptionalHeader.MajorSubsystemVersion	 resw      	1	; WORD
.OptionalHeader.MinorSubsystemVersion	 resw      	1	; WORD
.OptionalHeader.Win32VersionValue	 resd      	1	; DWORD
.OptionalHeader.SizeOfImage	 resd      	1	; DWORD
.OptionalHeader.SizeOfHeaders	 resd      	1	; DWORD
.OptionalHeader.CheckSum	 resd      	1	; DWORD
.OptionalHeader.Subsystem	 resw      	1	; WORD
.OptionalHeader.DllCharacteristics	 resw      	1	; WORD
.OptionalHeader.SizeOfStackReserve	 resd      	1	; DWORD
.OptionalHeader.SizeOfStackCommit	 resd      	1	; DWORD
.OptionalHeader.SizeOfHeapReserve	 resd      	1	; DWORD
.OptionalHeader.SizeOfHeapCommit	 resd      	1	; DWORD
.OptionalHeader.LoaderFlags	 resd      	1	; DWORD
.OptionalHeader.NumberOfRvaAndSizes	 resd      	1	; DWORD
.OptionalHeader.DataDirectory.VirtualAddress	 resd      	1	; DWORD
.OptionalHeader.DataDirectory.Size	 resd      	1	; DWORD
; ENDSTRUC 'IMAGE_OPTIONAL_HEADER'
ENDSTRUC

STRUC IMAGE_ROM_HEADERS
; STRUC 'IMAGE_FILE_HEADER'
.FileHeader.Machine	 resw      	1	; WORD
.FileHeader.NumberOfSections	 resw      	1	; WORD
.FileHeader.TimeDateStamp	 resd      	1	; DWORD
.FileHeader.PointerToSymbolTable	 resd      	1	; DWORD
.FileHeader.NumberOfSymbols	 resd      	1	; DWORD
.FileHeader.SizeOfOptionalHeader	 resw      	1	; WORD
.FileHeader.Characteristics	 resw      	1	; WORD
; ENDSTRUC 'IMAGE_FILE_HEADER'
; STRUC 'IMAGE_ROM_OPTIONAL_HEADER'
.OptionalHeader.Magic	 resw      	1	; WORD
.OptionalHeader.MajorLinkerVersion	 resb      	1	; BYTE
.OptionalHeader.MinorLinkerVersion	 resb      	1	; BYTE
.OptionalHeader.SizeOfCode	 resd      	1	; DWORD
.OptionalHeader.SizeOfInitializedData	 resd      	1	; DWORD
.OptionalHeader.SizeOfUninitializedData	 resd      	1	; DWORD
.OptionalHeader.AddressOfEntryPoint	 resd      	1	; DWORD
.OptionalHeader.BaseOfCode	 resd      	1	; DWORD
.OptionalHeader.BaseOfData	 resd      	1	; DWORD
.OptionalHeader.BaseOfBss	 resd      	1	; DWORD
.OptionalHeader.GprMask	 resd      	1	; DWORD
.OptionalHeader.CprMask	 resd      	4	; DWORD
.OptionalHeader.GpValue	 resd      	1	; DWORD
; ENDSTRUC 'IMAGE_ROM_OPTIONAL_HEADER'
ENDSTRUC

;STRUC IMAGE_SECTION_HEADER
;.Name:            	 resb      	0	; BYTE
;	union {
;.PhysicalAddress: 	 resd      	1	; DWORD
;.VirtualSize:     	 resd      	1	; DWORD
;.VirtualAddress:  	 resd      	1	; DWORD
;.SizeOfRawData:   	 resd      	1	; DWORD
;.PointerToRawData:	 resd      	1	; DWORD
;.PointerToRelocations:	 resd      	1	; DWORD
;.PointerToLinenumbers:	 resd      	1	; DWORD
;.NumberOfRelocations:	 resw      	1	; WORD
;.NumberOfLinenumbers:	 resw      	1	; WORD
;.Characteristics: 	 resd      	1	; DWORD
;ENDSTRUC

;STRUC IMAGE_SYMBOL
;	union {
;.ShortName:       	 resb      	8	; BYTE
;		struct {
;.Short:           	 resd      	1	; DWORD
;.Long:            	 resd      	1	; DWORD
;; STRUC 'Nam'
;.e.name           	 resb      	0	; UCHAR
;.e.name_num       	 resb      	1	; UCHAR
;.e.name_flags     	 resb      	1	; UCHAR
; ENDSTRUC 'Nam'
;	} N;
;.Value:           	 resd      	1	; DWORD
;.SectionNumber:   	 resw      	1	; SHORT
;.Type:            	 resw      	1	; WORD
;.StorageClass:    	 resb      	1	; BYTE
;.NumberOfAuxSymbols:	 resb      	1	; BYTE
;ENDSTRUC

;STRUC IMAGE_RELOCATION
;;#ifdef __LCC__ /* I do not support unnamed unions... jn */
;.VirtualAddress:  	 resd      	1	; DWORD
;;#else
;;	union {
;.VirtualAddress:  	 resd      	1	; DWORD
;.RelocCount:      	 resd      	1	; DWORD
;;	};
;;#endif
;.SymbolTableIndex:	 resd      	1	; DWORD
;.Type:            	 resw      	1	; WORD
;ENDSTRUC

STRUC IMAGE_BASE_RELOCATION
.VirtualAddress:  	 resd      	1	; DWORD
.SizeOfBlock:     	 resd      	1	; DWORD
ENDSTRUC

;STRUC IMAGE_LINENUMBER
;	union {
;.SymbolTableIndex:	 resd      	1	; DWORD
;.VirtualAddress:  	 resd      	1	; DWORD
;.Linenumber:      	 resw      	1	; WORD
;ENDSTRUC

STRUC IMAGE_ARCHIVE_MEMBER_HEADER
.Name:            	 resb      	16	; BYTE
.Date:            	 resb      	12	; BYTE
.UserID:          	 resb      	6	; BYTE
.GroupID:         	 resb      	6	; BYTE
.Mode:            	 resb      	8	; BYTE
.Size:            	 resb      	10	; BYTE
.EndHeader:       	 resb      	2	; BYTE
ENDSTRUC

STRUC IMAGE_EXPORT_DIRECTORY
.Characteristics: 	 resd      	1	; DWORD
.TimeDateStamp:   	 resd      	1	; DWORD
.MajorVersion:    	 resw      	1	; WORD
.MinorVersion:    	 resw      	1	; WORD
.Name:            	 resd      	1	; DWORD
.Base:            	 resd      	1	; DWORD
.NumberOfFunctions:	 resd      	1	; DWORD
.NumberOfNames:   	 resd      	1	; DWORD
ENDSTRUC

STRUC IMAGE_IMPORT_BY_NAME
.Hint:            	 resw      	1	; WORD
.Name:            	 resb      	1	; BYTE
ENDSTRUC

;STRUC IMAGE_THUNK_DATA
;;	union {
;.Ordinal:         	 resd      	1	; DWORD
;; STRUC 'u'
;.1.lpBaseOfDll    	 resd      	1	; LPVOID
;; ENDSTRUC 'u'
;ENDSTRUC

;STRUC IMAGE_IMPORT_DESCRIPTOR
;;	union {
;.Characteristics: 	 resd      	1	; DWORD
;; STRUC 'u'
;.1.lpBaseOfDll    	 resd      	1	; LPVOID
;; ENDSTRUC 'u'
;.TimeDateStamp:   	 resd      	1	; DWORD
;.ForwarderChain:  	 resd      	1	; DWORD
;.Name:            	 resd      	1	; DWORD
;ENDSTRUC

STRUC IMAGE_BOUND_IMPORT_DESCRIPTOR
.TimeDateStamp:   	 resd      	1	; DWORD
.OffsetModuleName:	 resw      	1	; WORD
.NumberOfModuleForwarderRefs:	 resw      	1	; WORD
ENDSTRUC

STRUC IMAGE_BOUND_FORWARDER_REF
.TimeDateStamp:   	 resd      	1	; DWORD
.OffsetModuleName:	 resw      	1	; WORD
.Reserved:        	 resw      	1	; WORD
ENDSTRUC

STRUC IMAGE_TLS_DIRECTORY
.StartAddressOfRawData:	 resd      	1	; DWORD
.EndAddressOfRawData:	 resd      	1	; DWORD
.SizeOfZeroFill:  	 resd      	1	; DWORD
.Characteristics: 	 resd      	1	; DWORD
ENDSTRUC

STRUC IMAGE_RESOURCE_DIRECTORY
.Characteristics: 	 resd      	1	; DWORD
.TimeDateStamp:   	 resd      	1	; DWORD
.MajorVersion:    	 resw      	1	; WORD
.MinorVersion:    	 resw      	1	; WORD
.NumberOfNamedEntries:	 resw      	1	; WORD
.NumberOfIdEntries:	 resw      	1	; WORD
ENDSTRUC

;STRUC IMAGE_RESOURCE_DIRECTORY_ENTRY
;	union {
;		struct {
;			DWORD NameIsString:1;
;		};
;.Name:            	 resd      	1	; DWORD
;.Id:              	 resw      	1	; WORD
; STRUC 'u'
;.1.lpBaseOfDll    	 resd      	1	; LPVOID
; ENDSTRUC 'u'
;	union {
;.OffsetToData:    	 resd      	1	; DWORD
;		struct {
;			DWORD DataIsDirectory:1;
;		};
;; STRUC 'u'
;.2.lpBaseOfDll    	 resd      	1	; LPVOID
;; ENDSTRUC 'u'
;ENDSTRUC

STRUC IMAGE_RESOURCE_DIRECTORY_STRING
.Length:          	 resw      	1	; WORD
.NameString:      	 resb      	1	; CHAR
ENDSTRUC

STRUC IMAGE_RESOURCE_DIR_STRING_U
.Length:          	 resw      	1	; WORD
.NameString:      	 resw      	1	; WCHAR
ENDSTRUC

STRUC IMAGE_RESOURCE_DATA_ENTRY
.OffsetToData:    	 resd      	1	; DWORD
.Size:            	 resd      	1	; DWORD
.CodePage:        	 resd      	1	; DWORD
.Reserved:        	 resd      	1	; DWORD
ENDSTRUC

STRUC IMAGE_LOAD_CONFIG_DIRECTORY
.Characteristics: 	 resd      	1	; DWORD
.TimeDateStamp:   	 resd      	1	; DWORD
.MajorVersion:    	 resw      	1	; WORD
.MinorVersion:    	 resw      	1	; WORD
.GlobalFlagsClear:	 resd      	1	; DWORD
.GlobalFlagsSet:  	 resd      	1	; DWORD
.CriticalSectionDefaultTimeout:	 resd      	1	; DWORD
.DeCommitFreeBlockThreshold:	 resd      	1	; DWORD
.DeCommitTotalFreeThreshold:	 resd      	1	; DWORD
.LockPrefixTable: 	 resd      	1	; PVOID
.MaximumAllocationSize:	 resd      	1	; DWORD
.VirtualMemoryThreshold:	 resd      	1	; DWORD
.ProcessHeapFlags:	 resd      	1	; DWORD
.Reserved:        	 resd      	4	; DWORD
ENDSTRUC

STRUC IMAGE_RUNTIME_FUNCTION_ENTRY
.BeginAddress:    	 resd      	1	; DWORD
.EndAddress:      	 resd      	1	; DWORD
.ExceptionHandler:	 resd      	1	; PVOID
.HandlerData:     	 resd      	1	; PVOID
.PrologEndAddress:	 resd      	1	; DWORD
ENDSTRUC

STRUC IMAGE_DEBUG_DIRECTORY
.Characteristics: 	 resd      	1	; DWORD
.TimeDateStamp:   	 resd      	1	; DWORD
.MajorVersion:    	 resw      	1	; WORD
.MinorVersion:    	 resw      	1	; WORD
.Type:            	 resd      	1	; DWORD
.SizeOfData:      	 resd      	1	; DWORD
.AddressOfRawData:	 resd      	1	; DWORD
.PointerToRawData:	 resd      	1	; DWORD
ENDSTRUC

STRUC IMAGE_COFF_SYMBOLS_HEADER
.NumberOfSymbols: 	 resd      	1	; DWORD
.LvaToFirstSymbol:	 resd      	1	; DWORD
.NumberOfLinenumbers:	 resd      	1	; DWORD
.LvaToFirstLinenumber:	 resd      	1	; DWORD
.RvaToFirstByteOfCode:	 resd      	1	; DWORD
.RvaToLastByteOfCode:	 resd      	1	; DWORD
.RvaToFirstByteOfData:	 resd      	1	; DWORD
.RvaToLastByteOfData:	 resd      	1	; DWORD
ENDSTRUC

STRUC FPO_DATA
.ulOffStart:      	 resd      	1	; DWORD
.cbProcSize:      	 resd      	1	; DWORD
.cdwLocals:       	 resd      	1	; DWORD
.cdwParams:       	 resw      	1	; WORD
;	WORD cbProlog:8;
;	WORD cbRegs:3;
;	WORD fHasSEH:1;
;	WORD fUseBP:1;
;	WORD reserved:1;
;	WORD cbFrame:2;
ENDSTRUC

STRUC IMAGE_DEBUG_MISC
.DataType:        	 resd      	1	; DWORD
.Length:          	 resd      	1	; DWORD
.Reserved:        	 resb      	3	; BYTE
.Data:            	 resb      	1	; BYTE
ENDSTRUC

STRUC IMAGE_FUNCTION_ENTRY
.StartingAddress: 	 resd      	1	; DWORD
.EndingAddress:   	 resd      	1	; DWORD
.EndOfPrologue:   	 resd      	1	; DWORD
ENDSTRUC

STRUC IMAGE_SEPARATE_DEBUG_HEADER
.Signature:       	 resw      	1	; WORD
.Flags:           	 resw      	1	; WORD
.Machine:         	 resw      	1	; WORD
.Characteristics: 	 resw      	1	; WORD
.TimeDateStamp:   	 resd      	1	; DWORD
.CheckSum:        	 resd      	1	; DWORD
.ImageBase:       	 resd      	1	; DWORD
.SizeOfImage:     	 resd      	1	; DWORD
.NumberOfSections:	 resd      	1	; DWORD
.ExportedNamesSize:	 resd      	1	; DWORD
.DebugDirectorySize:	 resd      	1	; DWORD
.SectionAlignment:	 resd      	1	; DWORD
.Reserved:        	 resd      	2	; DWORD
ENDSTRUC

STRUC NT_TIB
.StackBase:       	 resd      	1	; PVOID
.StackLimit:      	 resd      	1	; PVOID
.SubSystemTib:    	 resd      	1	; PVOID
.FiberData:       	 resd      	1	; PVOID
.ArbitraryUserPointer:	 resd      	1	; PVOID
; STRUC 'Sel'
.f.nmhdr.hwndFrom 	 resd      	1	; HWND
.f.nmhdr.idFrom   	 resd      	1	; UINT
.f.nmhdr.code     	 resd      	1	; UINT
.f.chrg.aflBlock  	 resd      	3	; DWORD
.f.chrg.fsUsb     	 resd      	4	; DWORD
.f.chrg.ciCharset 	 resd      	1	; UINT
.f.chrg.ciACP     	 resd      	1	; UINT
.f.seltyp         	 resw      	1	; WORD
; ENDSTRUC 'Sel'
ENDSTRUC

STRUC HEAPLIST32
.dwSize:          	 resd      	1	; DWORD
.th32ProcessID:   	 resd      	1	; DWORD
.th32HeapID:      	 resd      	1	; DWORD
.dwFlags:         	 resd      	1	; DWORD
ENDSTRUC

STRUC HEAPENTRY32
.dwSize:          	 resd      	1	; DWORD
.hHandle:         	 resd      	1	; HANDLE
.dwAddress:       	 resd      	1	; DWORD
.dwBlockSize:     	 resd      	1	; DWORD
.dwFlags:         	 resd      	1	; DWORD
.dwLockCount:     	 resd      	1	; DWORD
.dwResvd:         	 resd      	1	; DWORD
.th32ProcessID:   	 resd      	1	; DWORD
.th32HeapID:      	 resd      	1	; DWORD
ENDSTRUC

STRUC PROCESSENTRY32
.dwSize:          	 resd      	1	; DWORD
.cntUsage:        	 resd      	1	; DWORD
.th32ProcessID:   	 resd      	1	; DWORD
.th32DefaultHeapID:	 resd      	1	; DWORD
.th32ModuleID:    	 resd      	1	; DWORD
.cntThreads:      	 resd      	1	; DWORD
.th32ParentProcessID:	 resd      	1	; DWORD
.pcPriClassBase:  	 resd      	1	; LONG
.dwFlags:         	 resd      	1	; DWORD
.szExeFile:       	 resb      	0	; char
ENDSTRUC

STRUC THREADENTRY32
.dwSize:          	 resd      	1	; DWORD
.cntUsage:        	 resd      	1	; DWORD
.th32ThreadID:    	 resd      	1	; DWORD
.th32OwnerProcessID:	 resd      	1	; DWORD
.tpBasePri:       	 resd      	1	; LONG
.tpDeltaPri:      	 resd      	1	; LONG
.dwFlags:         	 resd      	1	; DWORD
ENDSTRUC

STRUC MODULEENTRY32
.dwSize:          	 resd      	1	; DWORD
.th32ModuleID:    	 resd      	1	; DWORD
.th32ProcessID:   	 resd      	1	; DWORD
.GlblcntUsage:    	 resd      	1	; DWORD
.ProccntUsage:    	 resd      	1	; DWORD
.modBaseSize:     	 resd      	1	; DWORD
.hModule:         	 resd      	1	; HMODULE
;	char szModule[MAX_MODULE_NAME32 + 1];
.szExePath:       	 resb      	0	; char
ENDSTRUC

STRUC PIXELFORMATDESCRIPTOR
.nSize:           	 resw      	1	; WORD
.nVersion:        	 resw      	1	; WORD
.dwFlags:         	 resd      	1	; DWORD
.iPixelType:      	 resb      	1	; BYTE
.cColorBits:      	 resb      	1	; BYTE
.cRedBits:        	 resb      	1	; BYTE
.cRedShift:       	 resb      	1	; BYTE
.cGreenBits:      	 resb      	1	; BYTE
.cGreenShift:     	 resb      	1	; BYTE
.cBlueBits:       	 resb      	1	; BYTE
.cBlueShift:      	 resb      	1	; BYTE
.cAlphaBits:      	 resb      	1	; BYTE
.cAlphaShift:     	 resb      	1	; BYTE
.cAccumBits:      	 resb      	1	; BYTE
.cAccumRedBits:   	 resb      	1	; BYTE
.cAccumGreenBits: 	 resb      	1	; BYTE
.cAccumBlueBits:  	 resb      	1	; BYTE
.cAccumAlphaBits: 	 resb      	1	; BYTE
.cDepthBits:      	 resb      	1	; BYTE
.cStencilBits:    	 resb      	1	; BYTE
.cAuxBuffers:     	 resb      	1	; BYTE
.iLayerType:      	 resb      	1	; BYTE
.bReserved:       	 resb      	1	; BYTE
.dwLayerMask:     	 resd      	1	; DWORD
.dwVisibleMask:   	 resd      	1	; DWORD
.dwDamageMask:    	 resd      	1	; DWORD
ENDSTRUC

STRUC WIN_CERTIFICATE
.dwLength:        	 resd      	1	; DWORD
.wRevision:       	 resw      	1	; WORD
.wCertificateType:	 resw      	1	; WORD
.bCertificate:    	 resb      	1	; BYTE
ENDSTRUC

STRUC WIN_TRUST_ACTDATA_CONTEXT_WITH_SUBJECT
.hClientToken:    	 resd      	1	; HANDLE
; STRUC 'WIN_TRUST_SUBJECT'
.Subject.hFile    	 resd      	1	; HANDLE
; ENDSTRUC 'WIN_TRUST_SUBJECT'
ENDSTRUC

STRUC WIN_TRUST_ACTDATA_SUBJECT_ONLY
; STRUC 'WIN_TRUST_SUBJECT'
.Subject.hFile    	 resd      	1	; HANDLE
; ENDSTRUC 'WIN_TRUST_SUBJECT'
ENDSTRUC

STRUC WIN_TRUST_SUBJECT_FILE
.hFile:           	 resd      	1	; HANDLE
ENDSTRUC

STRUC WIN_SPUB_TRUSTED_PUBLISHER_DATA
.hClientToken:    	 resd      	1	; HANDLE
ENDSTRUC

STRUC POINTFLOAT
.x:               	 resd      	1	; FLOAT
.y:               	 resd      	1	; FLOAT
ENDSTRUC

STRUC GLYPHMETRICSFLOAT
.gmfBlackBoxX:    	 resd      	1	; FLOAT
.gmfBlackBoxY:    	 resd      	1	; FLOAT
; STRUC 'POINTFLOAT'
.gmfptGlyphOrigin.x	 resd      	1	; FLOAT
.gmfptGlyphOrigin.y	 resd      	1	; FLOAT
; ENDSTRUC 'POINTFLOAT'
.gmfCellIncX:     	 resd      	1	; FLOAT
.gmfCellIncY:     	 resd      	1	; FLOAT
ENDSTRUC

STRUC LAYERPLANEDESCRIPTOR
.nSize:           	 resw      	1	; WORD
.nVersion:        	 resw      	1	; WORD
.dwFlags:         	 resd      	1	; DWORD
.iPixelType:      	 resb      	1	; BYTE
.cColorBits:      	 resb      	1	; BYTE
.cRedBits:        	 resb      	1	; BYTE
.cRedShift:       	 resb      	1	; BYTE
.cGreenBits:      	 resb      	1	; BYTE
.cGreenShift:     	 resb      	1	; BYTE
.cBlueBits:       	 resb      	1	; BYTE
.cBlueShift:      	 resb      	1	; BYTE
.cAlphaBits:      	 resb      	1	; BYTE
.cAlphaShift:     	 resb      	1	; BYTE
.cAccumBits:      	 resb      	1	; BYTE
.cAccumRedBits:   	 resb      	1	; BYTE
.cAccumGreenBits: 	 resb      	1	; BYTE
.cAccumBlueBits:  	 resb      	1	; BYTE
.cAccumAlphaBits: 	 resb      	1	; BYTE
.cDepthBits:      	 resb      	1	; BYTE
.cStencilBits:    	 resb      	1	; BYTE
.cAuxBuffers:     	 resb      	1	; BYTE
.iLayerPlane:     	 resb      	1	; BYTE
.bReserved:       	 resb      	1	; BYTE
.crTransparent:   	 resd      	1	; COLORREF
ENDSTRUC

