.486P
LOCALS
JUMPS
.MODEL FLAT, STDCALL			 

UNICODE = 0				; Used in w32.inc
INCLUDE W32.inc				; Windows definitions, messages, errors, structures,
					; API functions declarations, and so on.  Very usefull.
					; Thanks to Barry Kauler and Sven Schreiber.  Modified
					; by Net Walker!

;**********************************************************
;******		    RESOURCE IDENTIFIERS             ******
;/********************************************************\

IDI_ICON1	EQU	200
DLG_0100	EQU	100
ID_FILE		EQU	101
ID_BROWSE	EQU	103
ID_BACKUP	EQU	104

;\********************************************************/

EXTRN	_wsprintfA	: PROC
EXTRN	MakeMappedFile	: PROC
EXTRN	EndMappedFile	: PROC
EXTRN	ShowErrorMsg	: PROC
EXTRN	GetSizeOfFile	: PROC
EXTRN	SetFileSize	: PROC




.DATA

;**********************************************************
;******		         PATCH DATA                  ******
;/********************************************************\

; PatchOffset1 must be smaller than PatchOffset2 and so on.

PatchOffset1		DD	0C11Fh
OriginalData1		DB	0Fh, 85h, 0A4h, 01h, 00h, 00h, 39h, 5Dh, 0C4h, 0Fh, 85h, 9Bh, 01h, 00h, 00h
LenOriginalData1	DD 	$-OriginalData1
PatchData1		DB	15 dup (90h)
LenPatchData1		DD	$-PatchData1

PatchOffset2		DD	0C13Eh
OriginalData2		DB	3Bh, 0C3h
LenOriginalData2	DD 	$-OriginalData2
PatchData2		DB	39h, 0C0h
LenPatchData2		DD	$-PatchData2


;**************************************
;***     SOME GENERAL HANDLERS      ***
;/************************************\

hInst		DD	0
hMain		DD	0
hFILE		DD	0
hBACKUP		DD	0

;**************************************
;***           STRINGS              ***
;/************************************\

szTitle		DB 	"Net Walker Patcher",0
szClassName	DB	"NWPEC",0
Filter 		DB	"Executable Files (*.exe, *.dll)",0,"*.exe;*.dll",0,"All Files",0,"*.*",0,0
szPathName	DB	MAX_PATH dup(0)
szFileName	DB 	40 dup(0)
szBackupName	DB	MAX_PATH dup(0)
szBackupExt	DB	".bak",0
ErrorMsg1	DB	"File Not Original.  Patch Anyway?",0
ErrorMsg2	DB	"Cannot Patch File.",0
szMsgSuccess	DB	"File Successfully Patched",0
;**************************************
;***           STRUCTURES           ***
;/************************************\

wc		WNDCLASSEX		<0>
msg		MSG			<0>	
OFN		OPENFILENAME 		<0>

;**************************************
;***            OTHERS              ***
;/************************************\

FileAddr	DD	0
IsOriginal	DB	0



.CODE

;**********************************************************
;******		      INITIALIZATION                 ******
;/********************************************************\

start:

; First of all, get the ModuleHandle - needed for most functions

	call 	GetModuleHandle, NULL
	mov	hInst, eax

; initialize the WndClass structure 
; Actually, we get the window class from a DIALOG (with CLASS directive) in the resource

	mov	wc.wc_cbSize, WNDCLASSEX_
	mov	wc.wc_style, CS_HREDRAW + CS_VREDRAW 
	mov	wc.wc_lpfnWndProc, offset WinMain
	mov	wc.wc_cbClsExtra, 0
	mov	wc.wc_cbWndExtra, DLGWINDOWEXTRA	; this is needed to use a dialogbox as
							; a window class
	mov	eax, hInst
	mov	wc.wc_hInstance, eax

; load main icon from resource
	call 	LoadIcon, hInst, IDI_ICON1
	mov	wc.wc_hIcon, eax
	mov	wc.wc_hIconSm, eax
; load a default cursor
  	call 	LoadCursor,NULL, IDC_ARROW
	mov	wc.wc_hCursor, eax
	
	mov	wc.wc_hbrBackground, COLOR_BACKGROUND
	mov	wc.wc_lpszMenuName, NULL
	mov	wc.wc_lpszClassName, OFFSET szClassName

  	call 	RegisterClassEx, OFFSET wc

; create window, or better, the dialogbox that will work as the main window
	call	CreateDialogParam, hInst, offset szClassName, 0, NULL, 0
	mov	hMain, eax

; get child control handles
	call 	GetDlgItem, hMain, ID_FILE
	mov	dword ptr [hFILE], eax
	call	GetDlgItem, hMain, ID_BACKUP
	mov	dword ptr [hBACKUP], eax

;Adjust some controls
	call 	SetFocus, hFILE
	call	SendMessage, hBACKUP, BM_SETCHECK, BST_CHECKED, 0
	
	
;**********************************************************
;******		       MESSAGE LOOP                  ******
;/********************************************************\

msg_loop:
    	call 	GetMessage, OFFSET msg, 0,0,0
	cmp	ax, 0
        je      end_loop
	call	IsDialogMessage, hMain, offset msg	; put this if you want to let the 
	cmp	eax, TRUE				; system handle TAB, ENTER, etc
	jz	msg_loop

    	call 	TranslateMessage, OFFSET msg
    	call 	DispatchMessage, OFFSET msg
	jmp	msg_loop

end_loop:
    call 	ExitProcess, msg.ms_wParam
; we never get at this point

;**********************************************************
;******		         WINMAIN                     ******
;/********************************************************\

WinMain PROC USES ebx edi esi, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
	
	cmp	wmsg, WM_DESTROY
	jz	wmdestroy
	cmp	wmsg, WM_COMMAND
	jz	wmcommand
	call 	DefWindowProc, hwnd,wmsg,wparam,lparam
	jmp 	finish
;----------------------------------------------------------------
wmcommand: 
@@1:	cmp	wparam, IDOK
	jnz	@@2
	call	PatchFile
@@2:	cmp	wparam, ID_BROWSE
	jnz	@@3
	call	OpenDialog
@@3:	
	jmp	finish    
;----------------------------------------------------------------
wmdestroy:
        call    PostQuitMessage, 0
        mov     eax, 0
        jmp     finish
;----------------------------------------------------------------
finish:
	ret
WinMain 	ENDP

;------------------------------------------------------------------------
OpenDialog	PROC

; Fill OPENFILENAME Structure (OFN)
	mov	[OFN.on_lStructSize], OPENFILENAME_
	mov	eax, DWORD PTR [hMain]
	mov	[OFN.on_hwndOwner], eax
	mov    	eax, [hInst]
	mov	[OFN.on_hInstance], eax
	mov	[OFN.on_lpstrFilter], OFFSET Filter
	mov 	[OFN.on_lpstrFile], OFFSET szPathName
	mov	[OFN.on_nMaxFile], MAX_PATH-1
	mov 	[OFN.on_Flags], OFN_PATHMUSTEXIST+ OFN_FILEMUSTEXIST + OFN_HIDEREADONLY
	call    GetOpenFileName, offset OFN
	cmp	eax, FALSE
	jz	EndOD
; Change EditBox text
	call	SetWindowText, hFILE, offset szPathName
EndOD:
	ret

OpenDialog	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------
PatchFile	PROC
	call	MakeMappedFile, 0, offset szPathName, 0 , OPEN_EXISTING
	cmp 	eax, FALSE
	jz	EndPF
	mov	FileAddr, eax
; check if file size allows any patching
	mov	ebx, LenOriginalData2
	cmp	ebx, LenPatchData2
	jge	OriginalDataBigger
	mov	ebx, LenPatchData2
OriginalDataBigger:
	add	ebx, PatchOffset2
	call	GetSizeOfFile,0
	cmp	eax, ebx
	jge	Checks
	call	ShowErrorMsg, offset ErrorMsg2
	jmp	EndPF

Checks:
; check if file is original
	mov	IsOriginal, TRUE
Check1:
	mov 	ecx, LenOriginalData1
	mov	edi, FileAddr
	add	edi, PatchOffset1
	mov	esi, offset OriginalData1
	repz	cmpsb
	jz	FinalCheck
	mov	IsOriginal, FALSE
Check2:
	mov 	ecx, LenOriginalData2
	mov	edi, FileAddr
	add	edi, PatchOffset2
	mov	esi, offset OriginalData2
	repz	cmpsb
	jz	FinalCheck
	mov	IsOriginal, FALSE
FinalCheck:
	cmp	IsOriginal, FALSE
	jz	FileNotOriginal

ModifyFile:
;Create backup if necessary
	call	SendMessage, hBACKUP, BM_GETCHECK, 0,0
	cmp	eax, BST_CHECKED
	jnz	Patch1
	call	MakeBackup

Patch1:
	lea	esi, PatchData1
	mov	edi, FileAddr
	add	edi, PatchOffset1
	mov	ecx, LenPatchData1
	cld
	rep	movsb
Patch2:
	lea	esi, PatchData2
	mov	edi, FileAddr
	add	edi, PatchOffset2
	mov	ecx, LenPatchData2
	cld
	rep	movsb

; Success!
	call	MessageBox, hMain, offset szMsgSuccess, offset szTitle, MB_OK
	call 	EndMappedFile, 0
	jmp	EndPF	

FileNotOriginal:
	Call	MessageBox, hMain, offset ErrorMsg1, offset szTitle, MB_YESNO
	cmp	eax, IDYES
	jz	ModifyFile
	
EndPF:
	ret
	
PatchFile		ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------
MakeBackup	PROC
	push 	esi edi eax ebx ecx
	lea	edi, szPathName
	call	StrLen, edi
	inc 	eax
	mov	ebx, eax
	mov	ecx, eax
	mov	al, "."
	std
	repnz	scasb
	test 	ecx, ecx
	jnz	HasExtension
	mov 	ecx, ebx
HasExtension:
	lea	esi, szPathName
	lea 	edi, szBackupName
	cld	
	rep 	movsb
	lea	esi, szBackupExt
	mov	ecx, 5
	rep	movsb
	call	CopyFile, offset szPathName, offset szBackupName, FALSE
	pop 	ecx ebx eax edi esi 
	ret
MakeBackup	ENDP
;------------------------------------------------------------------------


;------------------------------------------------------------------------
StrLen	PROC	StrOffset:DWORD
	push 	esi
	mov	esi,	StrOffset
	xor	eax, eax
@LoopInit:
	cmp	byte ptr [esi],0
	jz	@FoundZero
	inc	eax
	inc 	esi
	jmp	@LoopInit
@FoundZero:	
	pop	esi
	ret
StrLen	ENDP
;-----------------------------------------------------------------------------
ends
end start
