; MWin.asm  (c) Mike Bibby  27/10/98 m_bibby@hotmail.com

; Feel free to use or distribute the package, part or whole, for any non-commercial use, 
; preferably crediting me.

; Also feel free to contact me at the above address if you've any problems.

; The assembled exe reads in a set of 32,  64 x 64 sprites from a bmp file (which 
; needs to be in the same directory). It then displays these in sequence
; in a 128 x 128 window, to give an "animated" effect.

; It is merely a demonstration program, and whilst it should work on most sensible desktops,
; it is merely a toy and makes no pretence at being optimised, efficient, highly practical
; or clever.

; For instance, it isn't too fussy about the Primary surface type, doesn't try to restore 
; lost surfaces, just blits unhesitatingly onto the surface, etc., etc....

; But it will get you up and running, showing how to create DirectDraw objects, how to
; call their methods, and how to perform a primitive animation in a window...

; Also there's a full ddraw.inc file (still in alpha test stage) and a
; couple of macros that let you call the methods without too much pushing,
; and so on. Please let me know if you find anything missing.



.586
.MODEL FLAT,STDCALL

include MWinwin.inc
include Mddraw.inc


FRAMELIFE = 15			; times how long each sprite is displayed (see Update).


;################################################################################
;#                                  MACROS                                      #
;################################################################################
;================================================================================
; pushrtol
; pushes the arguments of the macro onto the stack right to left
; uses recursion...
;================================================================================
pushrtol MACRO v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12
	IFNB <v1>
		pushrtol <v2>,<v3>,<v4>,<v5>,<v6>,<v7>,<v8>,<v9>,<v10>,<v11>,<v12>
		push v1
	ENDIF
ENDM
;================================================================================
; mcall
; used to call the DirectDraw methods. Pointer to object first, then offset into
; method table, then parameters.... e.g.
;		mcall [lpDD], DDSETCOOPERATIVELEVEL, [hWnd], DDSCL_NORMAL
;================================================================================
mcall MACRO ObjectPtr, MethodName, v1,v2,v3,v4,v5,v6,v7,v8,v9,v10,v11,v12
 	pushrtol <v1>,<v2>,<v3>,<v4>,<v5>,<v6>,<v7>,<v8>,<v9>,<v10>,<v11>,<v12>
 	mov eax, ObjectPtr
 	push eax
 	mov eax, [eax]
 	call DWORD PTR [eax+MethodName]
ENDM
;================================================================================

  
;################################################################################
;#                           prototypes of my PROCs                             #
;################################################################################

	Update  PROTO STDCALL:HWND
	Fail 	PROTO STDCALL :DWORD,  :DWORD
;################################################################################
;#                                 DATA                                         #
;################################################################################

.DATA

;--------------------------------------------------------------------------
	include GUID.inc						;<<<<<<<<< notice this include.
;--------------------------------------------------------------------------

	szClassName			DB 'MWin',0
	szWindowTitle		DB 'MWin',0

	hInstance			DWORD 	NULL
	hWnd	 			DWORD 	NULL
	hDC 				DWORD 	NULL

	wc					WNDCLASS    	<?>
	msg		 			MSG	 			<?>
	ps	 				PAINTSTRUCT 	<?>


	rect				RECT			<?>
	window				RECT			<?>
	frame				RECT			<?>

	fIsActive			DWORD			FALSE
;---------------------- Feedback messages ---------------------------------
	szMessage			DB  "MWin!",0
	dwMessageLen		DWORD $ - szMessage - 1
	szEscMessage		DB "Press Escape to exit",0
	dwEscMessageLen		DWORD $ - szEscMessage - 1
	
;---------------------- Direct Draw Objects, etc.---------------------------------
	lpDD 				LPDIRECTDRAW 		NULL    	; DirectDraw object
	lpDD2 				LPDIRECTDRAW 		NULL    	; DirectDraw object

	hDCOff				DD	NULL						; offscreen device context


	ddsd 				DDSURFACEDESC 	<0>            
	ddscaps				DDSCAPS			<0>	
	offddsd				DDSURFACEDESC 	<0>   
	offddscaps			DDSCAPS			<0>

	lpDDSPrimary		LPDIRECTDRAWSURFACE NULL 		; DirectDraw primary surface
	lpDDSOff			LPDIRECTDRAWSURFACE NULL 		; DirectDraw offscreen surface

	ddbltfx 			DDBLTFX 	<?>
	
	ddpf				DDPIXELFORMAT<?>
	
	lpClipper 			LPDIRECTDRAWCLIPPER  NULL

;	Since I'm only testing for DirectDraw2 I could use this instead 
; 	of the include GUID.inc which does them all.
;	IID_IDirectDraw2 GUID <0B3a6f3e0h,02b43h,011cfh, 				\
;							0a2h,0deh,000h,0aah,000h,0b9h,033h,056h>

;----------- to do with bitmap file --------------------

	szImages			DB "Images.bmp",0

	bmp 				BITMAP  <?>
	
	hbmp				HBITMAP 0
	hdcImage			DWORD 0
							
;-------- Sprite position and timing --------------------

	spritex 			DWORD 	0
	spritey 			DWORD 	0
	
	dwLastTickCount 	DWORD 	0
	dwTickCount 		DWORD 	0



;--------------------------------------------------------------------------
;---------------------- Feedback messages ---------------------------------
;----------------------- for DirectDraw   ---------------------------------
;---------------------- related failures  ---------------------------------
;--------------------------------------------------------------------------
szDirectDrawCreateFail 		DB 	"Unable to create DirectDraw object.",0
szSetCooperativeLevelFail 	DB 	"Unable to set cooperative level.",0
szSetDisplayModeFail 		DB 	"Unable to set display mode."
szCreateSurfaceFail 		DB 	"Unable to create (primary) surface.",0
szGetAttachedSurfaceFail	DB 	"Unable to find the attached surface (back buffer).",0
szBltFail					DB 	"Unable to do the blit.",0
szFlipFail					DB 	"Unable to perform flip." ,0
szGetDCFail					DB	"Unable to get DC.",0
szReleaseDCFail				DB	"Unable to release DC.",0
szCreateClipperFail 		DB 	"Unable to create clipper",0
szSetClipperFail			DB  "Unable to set clipper",0
szSetHwndFail				DB  "Unable to link clipper with window",0
szGetPixelFormat  			DB 	"Unable to GetPixelFormat",0
szRestore 					DB 	"Unable to Restore",0
szLoadImageA 				DB 	"Unable to Load Image",0
szCreateCompatible			DB 	"CreateCompatible",0
szSelectObject				DB 	"SelectObject",0
szQueryInterface			DB 	"QueryInterface Failed",0
szPalettised  				DB 	"Palettised",0

szForYourInfo				DB "For Your Info",0



;################################################################################
;#                                 CODE                                         #
;################################################################################

.CODE

;===============================================================================
;=== WinMain																 ===
;=== Initialise window, show/update it, enter message loop					 ===
;===============================================================================

WinMain	PROC

; first get the module handle
	invoke GetModuleHandleA, NULL	
	mov	[hInstance], eax

; initialise the main window
	call Initialise  
     
    invoke ShowWindow, hWnd,SW_SHOWNORMAL			
    invoke UpdateWindow, hWnd
 
	call doDDInit   
   	      
.WHILE TRUE
	invoke PeekMessageA, OFFSET msg,0,0,0,PM_NOREMOVE
	.IF eax != 0
    	invoke GetMessageA, OFFSET msg, 0,0,0
		cmp	eax, 0
    	je  end_message_loop
    	invoke TranslateMessage, OFFSET msg
    	invoke DispatchMessageA, OFFSET msg
    .ELSE
    	mov eax,[fIsActive]
    	.IF eax == TRUE
    		invoke Update,hWnd
    	.ELSE
    		invoke WaitMessage
    	.ENDIF	
    .ENDIF
.ENDW

end_message_loop::
    invoke ExitProcess, msg.msg_wParam

	ret

WinMain ENDP


;================================================================================
;=== WindowProc                     										  === 
;=== Deals with the messages by calling specific subroutines			      ===
;=== or passes them on to the default window procedure.						  ===
;================================================================================

WindowProc PROC  STDCALL, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

	mov eax,[wmsg]
	
	.if eax == WM_ACTIVATEAPP
		mov eax,wparam
		mov [fIsActive],eax
		xor eax,eax
		ret
	.elseif eax == WM_MOVE
		invoke GetClientRect,hwnd, offset window
		invoke ClientToScreen,hwnd, offset window
		invoke ClientToScreen,hwnd, (offset window)+8		
		xor eax,eax
		ret
	.elseif eax == WM_KEYDOWN
		mov eax,wparam
		.if eax==VK_ESCAPE
			invoke PostMessageA,hwnd,WM_CLOSE,0,0
			xor eax,eax
		.endif
		ret
    .elseif eax==WM_PAINT
		call wmPaint
		xor eax,eax
		ret
	.elseif eax==WM_DESTROY
	  	call wmDestroy
	  	xor eax,eax
	  	ret
	.else
	    invoke DefWindowProcA, hwnd,wmsg,wparam,lparam
	    ret
	.endif	

WindowProc ENDP
;===============================================================================

;================================================================================
;=== wmPaint                     											  === 
;=== Draws a message centrally in the window's client area.				      ===
;================================================================================
wmPaint PROC
	    	
    invoke BeginPaint, hWnd,OFFSET ps
    mov	hDC, eax
    		
	invoke GetClientRect,hWnd,offset rect
	invoke DrawTextA, hDC,offset szMessage,-1, offset rect, \ 
	     DT_CENTER OR DT_VCENTER OR DT_SINGLELINE
    invoke EndPaint, hWnd,OFFSET ps
    
	xor eax,eax
	ret
 
wmPaint ENDP
;===============================================================================

;================================================================================
;=== wmDestroy                     											  === 
;=== Calls for WM_QUIT to be put in message queue.           			      ===
;================================================================================
wmDestroy PROC
	call ReleaseObjects
	invoke PostQuitMessage,0					; exit code of 0
	
	ret

wmDestroy ENDP
;==============================================================================

;===============================================================================
;=== Initialise 															 ===
;=== fills in a class structure, registers the class						 ===
;=== and creates a window based on that class.					        	 ===
;=== Gives it a 128 by 128 client rectangle and positions it top left.       ===
;===============================================================================

Initialise PROC

; next initialize the window class structure
	mov	wc.wc_style, 		CS_HREDRAW + CS_VREDRAW	; redraw if height or width change
	mov	wc.wc_lpfnWndProc, 	offset WindowProc		; this handles messages for this class
	mov	wc.wc_cbClsExtra, 	0
	mov	wc.wc_cbWndExtra, 	0
	mov eax,[hInstance]								; superfluous - eax still has this
	mov	wc.wc_hInstance, 	eax						; got via GetModuleHandleA
	invoke LoadIconA, NULL, 	IDI_APPLICATION			; default application icon
	mov	wc.wc_hIcon, eax
  	invoke LoadCursorA,NULL, 	IDC_ARROW				; standard arrow cursor
	mov	wc.wc_hCursor, eax
	invoke GetStockObject, WHITE_BRUSH				; this ensures a white background...
	mov wc.wc_hbrBackground, eax					; ... on painting.
	mov wc.wc_lpszMenuName, NULL					; no menu to identify at present
    mov wc.wc_lpszClassName, offset szClassName		; used to identify the class you want
    												; whencreating an individual window
    
;now register this class of window  
    invoke RegisterClassA, 	offset wc				; tell it where the details are...
													; ... and log it in
													
; create a window based on the class registered above 
 	invoke CreateWindowExA,	0,							\ 
 	 						offset szClassName,			\ 
 	 						offset szWindowTitle,		\ 
							WS_SYSMENU OR WS_CAPTION 	\
							OR WS_MINIMIZEBOX,			\ 
							0,0,						\ 
							CW_USEDEFAULT,				\ 
							CW_USEDEFAULT,				\ 
							0, 							\ 
							0, 							\ 
							hInstance,					\ 
							0							\ 
					
	mov	hWnd, eax
	
; We want a client window 128 by 128 so we adjust a rectangle into that size
	invoke SetRect, offset rect,0,0,128,128
	invoke AdjustWindowRectEx, offset rect, WS_SYSMENU OR WS_CAPTION OR WS_MINIMIZEBOX, FALSE, 0

; We want the window at the top left corner of the screen (0,0)
; The FALSE ensures no WM_PAINT but there is a WM_MOVE which sets window rectangle initially.
	invoke MoveWindow, hWnd,0,0,rect.rect_right,rect.rect_bottom,FALSE  
	
	ret

Initialise ENDP

;==============================================================================
; doDDInit
;==============================================================================
; This:
; 1. Creates a DirectDraw object.
; 2  Queries the interface for IDirectDraw2. If we do find it, we substitute the
; &    new pointer we obtain for the old lpDD as we aren't going to use any of
; 3    the new interfaces methods, we can code for both interfaces identically.
; 4. Sets the cooperative level - normal for a windowed application.
; 5. Creates a simple primary surface  (no back buffer).
; 6. Ensures that the output to our window is clipped.
; 7. Checks for palettised.
; 8. Loads a bmp file onto a newly creatd offscreen surface to act as the 
;    source of our sprites.
;==============================================================================

doDDInit PROC

; 1. Create a DirectDraw object.
    invoke DirectDrawCreate, NULL, offset lpDD,NULL
    ;--- take action if it fails
    .IF eax != DD_OK
    	invoke Fail, hWnd, offset szDirectDrawCreateFail
    	jmp end_message_loop
    .ENDIF

; 2. Query the interface

	mcall [lpDD], DDQUERYINTERFACE, <offset IID_IDirectDraw2>,<offset lpDD2>
	
    .IF eax != DD_OK
    	invoke MessageBoxA, 0, offset szQueryInterface,offset szQueryInterface,0
    	jmp noIDirectDraw2
    .ENDIF

; 3. We got an IDirectDraw2 Interface. This was just to show how
;    it's done. We're not going to use any special IDirectDraw2 
;    features, so we won't need to have separate code for both 
;    interfaces. Hence we'll release the first object and copy
;    lpDD2 into lpDD so either interface can use the same code.
     
    ;--- release first DirectDraw object
    
    mcall [lpDD], DDRELEASE
    	
    ;--- ensure lpDD points to the interface	
    mov eax, [lpDD2]
	mov [lpDD],eax
  	mov [lpDD2], NULL					; delete reference
  		
noIDirectDraw2:

; 4. Set the cooperative level - normal for a windowed application

	mcall [lpDD], DDSETCOOPERATIVELEVEL, [hWnd], DDSCL_NORMAL

	;--- check for error
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szSetCooperativeLevelFail
    	jmp end_message_loop
    .ENDIF	


; 5. Create a primary surface
    mov ddsd.dwSize, SIZE ddsd
    mov ddsd.dwsurfFlags,DDSD_CAPS	

    mov ddsd.ddssurfCaps.dwCaps, DDSCAPS_PRIMARYSURFACE	
    
 	mcall [lpDD], DDCREATESURFACE, <offset ddsd>, <offset lpDDSPrimary>, NULL
 	
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szCreateSurfaceFail
    	jmp end_message_loop
    .ENDIF	
       

; 6. Ensure that the output to our window is clipped.

	call SetUpClipper 


; 7. Check for palettised. Information only at present

	mov [ddpf.dwSize], SIZE DDPIXELFORMAT
	mcall [lpDDSPrimary],DDSGETPIXELFORMAT,<offset ddpf>

	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szGetPixelFormat
    .ENDIF

	mov eax, [ddpf.dwpixFlags]
	and eax,DDPF_PALETTEINDEXED8

	.if eax !=0
		; un-comment the following call to be informed of palette state
		; invoke MessageBoxA,hWnd,offset szPalettised,offset szForYourInfo,0
	.endif

; 8. Load the BMP file with the sprites into memory and copy it onto a
;	 specially created offscreen surface.
	 call SetUpOffScreen

	ret
	
doDDInit ENDP
;===============================================================================
; SetUpClipper
;===============================================================================
; We create a clipper and associate it with the window and the primary surface.
; That is, it acts as a filter through which we blit onto the primary surface.
; It filters out everything except the currently visible portions of the window.
;===============================================================================	
SetUpClipper PROC

; 1. Create a clipper.

	mcall [lpDD], DDCREATECLIPPER, 0, <offset lpClipper>,0
	IF 0
	push 0
	push offset lpClipper
	push 0
	mov eax,[lpDD]
	push eax
	mov eax,[eax]
	invoke [eax + DDCREATECLIPPER]
	ENDIF
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szCreateClipperFail
    	jmp end_message_loop
    	ret
    .ENDIF


; 2. Link it with the window.

	mcall [lpClipper], DDCSETHWND, 0, [hWnd]
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szSetHwndFail
    	jmp end_message_loop
    	ret
    .ENDIF
    
    
; 3. Next link it with the primary surface.

	mcall [lpDDSPrimary], DDSSETCLIPPER, [lpClipper]
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szSetClipperFail
    	jmp end_message_loop
    	ret
    .ENDIF
    
    
; 4. Release clipper to decrease reference count by one.

	mcall [lpClipper], DDCRELEASE
	mov [lpClipper],NULL

ret

SetUpClipper ENDP
;===============================================================================
; SetUpOffScreen
;===============================================================================
; We read in Images.bmp which contains our "sprites" and blit it onto an offscreen 
; surface we create. It's from this surface that we'll later blit individual sprites
; onto our primary surface in Update.
;===============================================================================
SetUpOffScreen PROC


; 1. Load the bmp in from the file, bail out if it's not there. Get a handle.
	invoke LoadImageA, 0, offset szImages,IMAGE_BITMAP,0,0,LR_LOADFROMFILE
		.if eax == NULL
			invoke Fail, hWnd, offset szLoadImageA
    		jmp end_message_loop
		.endif
		
	mov [hbmp], eax	
	
; 2. Put the details of the BMP file into bmp, a BITMAP structure
	invoke GetObjectA, [hbmp], SIZE BITMAP, offset bmp

; 3. Superfluously zero out a surface descriptor and fill it
;    with the details of our offscreen surface
	invoke RtlZeroMemory, offset offddsd, SIZE offddsd

	mov [offddsd.dwSize], SIZE offddsd
    mov [offddsd.dwsurfFlags], DDSD_CAPS OR DDSD_HEIGHT OR DDSD_WIDTH
    mov [offddsd.ddssurfCaps.dwCaps], DDSCAPS_OFFSCREENPLAIN
    mov eax, bmp.bmWidth
    mov [offddsd.dwWidth], eax
    mov eax, bmp.bmHeight
    mov [offddsd.dwHeight], eax

; 4. Create an offscreen surface as wide and high as the bmp "surface"
;    we read in...
	
	mcall [lpDD],DDCREATESURFACE,<offset offddsd>,<offset lpDDSOff>,<NULL>

	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szCreateSurfaceFail
    	jmp end_message_loop
    .ENDIF

; 5. Restore, just for practice! We're not bothering going the whole hog
;    and bothering with IsLost in this demo.

	mcall [lpDDSOff], DDSRESTORE

	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szRestore
    	jmp end_message_loop
    	ret
    .ENDIF

	
; 6. Our plan is to transfer the bmp we read in to our offscreen surface by
;    blitting it,but we need a Device Context or two. So:

; First we get a device context for the bitmap we've read in...

	;--- So create a compatibleDC and then...
	invoke CreateCompatibleDC, 0
	mov [hdcImage],eax
	.if [hdcImage] == NULL
		invoke Fail, hWnd, offset szCreateCompatible
		jmp end_message_loop
	.endif	
	
	;... select the bitmap into that DC
	invoke SelectObject, [hdcImage],[hbmp]
	.if eax == NULL
		invoke Fail, hWnd, offset szSelectObject
	.endif 	
			
; Second get a device context for our offscreen surface 
	
	mcall [lpDDSOff], DDSGETDC, <offset hDCOff>
	
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szGetDCFail
    	ret
    .ENDIF  
 
	 
; Third use the GDI to blit the bitmap onto the surface...

	invoke BitBlt,[hDCOff], 0, 0,[offddsd.dwWidth] ,[offddsd.dwHeight], \
		 	[hdcImage],0, 0, SRCCOPY

	;--- We could use...
	;	invoke StretchBlt,[hDCOff], 0, 0,[offddsd.dwWidth] ,[offddsd.dwHeight], \
	;		 [hdcImage],0, 0, [offddsd.dwWidth] ,[offddsd.dwHeight], SRCCOPY
	;...but we're blitting "as is" with no stretching.
	
; Fourth we release the DC of the offscreen surface

	mcall [lpDDSOff], DDSRELEASEDC, [hDCOff]

	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szReleaseDCFail
    	jmp end_message_loop
    .ENDIF  
  
; Fifth we get rid of the compatible DC...
	invoke DeleteDC, [hdcImage] 
	
; Finally we delete the bitmap object we selected into it.
  	invoke DeleteObject, [hbmp]

	ret
SetUpOffScreen ENDP	
;===============================================================================
Update  PROC STDCALL, hwnd:HWND

; Find how many milliseconds have elapsed since the last update. Return
; if less than FRAMELIFE
	invoke GetTickCount
	mov [dwTickCount], eax
	sub eax,[dwLastTickCount]

	.if eax < FRAMELIFE
		ret
	.endif


; New frame to be displayed - record new LastTickCount as current system time.
	mov eax, [dwTickCount]
	mov [dwLastTickCount], eax

; We're not moving a sprite across the screen, we're choosing a different 64x64 
; sprite from the offscreen surface for each frame, then filling the whole of
; our 128x128 window with it. We cycle through 32 frames.
; spritex and spritey keep track of the source of this sprite on the offscreen 
; surface. frame is the rectangle we calculate from them as source rectangle.

	mov eax, [spritex]
	mov frame.rect_left,eax
	add eax,64
	mov frame.rect_right,eax

	mov eax,[spritey]
	mov frame.rect_top,eax
	add eax,64
	mov frame.rect_bottom,eax

; blit from frame on the offscreen surface to the (clipped) client window which we've
; calculated
	mcall [lpDDSPrimary], DDSBLT, <offset window>, [lpDDSOff], <offset frame>, DDBLT_WAIT,0
	.IF eax != DD_OK
    	invoke Fail, hwnd, offset szBltFail
    	ret
    .ENDIF
    
; alter parameters to pick next 64 x 64 sprite in sequence from
; the offscreen surface - 256 wide (0-255), 512 deep (0 - 511)
	 add [spritex],64		; increase horizontal by 64
	 .if [spritex]>= 256	; gone past end column
	 	mov [spritex],0		; start at far left column of next... (0)
	 	add [spritey],64	; row down.
	 	and [spritey],511   ; if past the bottom row, move back to top (0)
	 .endif
 
ret

Update  ENDP

;===============================================================================
; Fail
;===============================================================================
; This releases objects, outputs the supplied message and returns.
;===============================================================================
	szFromFail 	DB 'Message from Fail',0
	szFail		DB "Fail",0
	
Fail PROC, fhwnd:DWORD, ptrszMsg:DWORD
	call ReleaseObjects
	invoke MessageBoxA,fhwnd,ptrszMsg,offset szFromFail,MB_OK
	mov eax,0
	ret	

Fail ENDP
;===============================================================================


;===============================================================================
; ReleaseObjects
;===============================================================================
; This
; 1. Releases Primary and offscreen surfaces
; 2. Makes Primary and offscreen surface pointers NULL
; 3. Releases DirectDraw object
; 4. Makes pointer to DirectDraw object NULL
;===============================================================================
ReleaseObjects PROC
	.IF lpDD != NULL
		.IF lpDDSPrimary != NULL
			;release Primary surface
			mcall [lpDDSPrimary], DDSRELEASE
			mov [lpDDSPrimary],NULL
		.ENDIF
		.IF lpDDSOff != NULL
			;release off screen surface
			mcall [lpDDSOff], DDSRELEASE
			mov [lpDDSOff],NULL			
		.ENDIF
		;release DirectDraw object
		mcall [lpDD], DDRELEASE
		mov [lpDD],NULL
	.ENDIF
	ret
szReleaseObjects  	DB	"ReleaseObjects",0
ReleaseObjects ENDP
;===============================================================================


;################################################################################
;#                              CODE ENDS                                       #
;################################################################################

end WinMain 

################################################################################
#                              END OF FILE                                     #
################################################################################


