; MWinwin.asm  (c) Mike Bibby  27/10/98 m_bibby@hotmail.com

; Feel free to use or distribute the package, part or whole, for any non-commercial use, 
; preferably crediting me.

; Also feel free to contact me at the above address if you experience any
; problems or notice any omissions.


;################################################################################
;#                    fundamental equates and typedefs                          #
;################################################################################

	NULL				=	0					; null pointer
	FALSE				=	0					; boolean false
	TRUE				=	1					; boolean true


	BOOL				typedef DWORD			; boolean 
	UINT				typedef	DWORD			; unsigned integer 
	INTEGER				typedef	DWORD			; integer
	LONGINT				typedef	DWORD			; long integer
	LONG 				typedef DWORD
	LPARAM				typedef	DWORD			; long parameter
	WPARAM				typedef	DWORD			; word parameter
	WNDPROC				typedef	DWORD			; window procedure


	HWND				typedef	DWORD			; window handle
	HDC					typedef	DWORD			; device context handle
	HINSTANCE			typedef	DWORD			; instance handle
	HCURSOR				typedef	DWORD			; cursor handle
	HMENU				typedef	DWORD			; menu handle
	HICON				typedef	DWORD			; icon handle
	HBRUSH				typedef	DWORD			; brush handle

	COLORREF			typedef	DWORD			; rgb
	
	
	LPMSG				typedef	DWORD			; long pointer to message
	LPCSTR				typedef DWORD			; long pointer to string
	LPVOID				typedef	DWORD			; long pointer to void
	LPPAINTSTRUCT		typedef PTR PAINTSTRUCT	; long pointer to paint structure
	LPRECT				typedef	PTR RECT		; long pointer to rectangle



;################################################################################
;#                           structure definitions                              #
;################################################################################
;

POINT struct
	pt_x			LONGINT	  0	
	pt_y			LONGINT	  0		
POINT ends

LPPOINT typedef PTR POINT
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

RECT struct
	rect_left		LONGINT	  0		; left
	rect_top		LONGINT	  0		; top
	rect_right		LONGINT	  0		; right
	rect_bottom		LONGINT	  0		; bottom 
RECT ends


;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

WNDCLASS struct
	wc_style				UINT	  0		; class style
	wc_lpfnWndProc			WNDPROC	  0		; window procedure
	wc_cbClsExtra			INTEGER	  0		; class extra data
	wc_cbWndExtra			INTEGER	  0		; window extra data
	wc_hInstance			HINSTANCE 0		; class owner
	wc_hIcon				HICON	  0		; icon handle
	wc_hCursor				HCURSOR	  0		; cursor handle
	wc_hbrBackground		HBRUSH	  0		; background color
	wc_lpszMenuName			LPCSTR	  0		; menu name
	wc_lpszClassName		LPCSTR	  0		; class name
WNDCLASS ends


;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

MSG	struct
	msg_hwnd		HWND	  0		; window handle
	msg_message		UINT	  0		; message id
	msg_wParam		WPARAM	  0		; additional parameter
	msg_lParam		LPARAM	  0		; additional parameter
	msg_time		DWORD	  0		; time stamp
	msg_x			LONGINT	  0		; x coordinate
	msg_y			LONGINT	  0		; y coordinate
MSG	ends

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

PAINTSTRUCT	struct
	ps_hdc			HDC	  	0		  	; device context handle
	ps_fErase		BOOL	FALSE		; background erase flag
	ps_leftPaint	LONGINT	0			; left of clipping rect
	ps_topPaint		LONGINT	0			; top of clipping rect
	ps_rightPaint	LONGINT	0		 	; right of clipping rect
	ps_bottomPaint	LONGINT	0		   	; bottom of clipping rect
	ps_fRestore		BOOL	FALSE		; reserved
	ps_fIncUpdate	BOOL	FALSE		; reserved
	ps_rgbReserved	BYTE	32 dup (0)	; reserved
PAINTSTRUCT	ends
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

BITMAPFILEHEADER	struct
	bmfType			WORD	  0	
	bmfSize			DWORD	  0	
	bmfReserved1	WORD	  0	
	bmfReserved2	WORD	  0		
	bmfOffBits		DWORD	  0		
BITMAPFILEHEADER	ends
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

BITMAPINFOHEADER	struct
	bmiSize				DWORD	  0		
	bmiWidth			LONG	  0		
	bmiHeight			LONG	  0		
	bmiPlanes			WORD	  0		
	bmiBitCount			WORD	  0		
	bmiCompression		DWORD	  0		
	bmiSizeImage		DWORD	  0		
	bmiXPelsPerMeter	LONG	  0		
	bmiYPelsPerMeter	LONG	  0		
	bmiClrUsed			DWORD	  0		
	bmiClrImportant		DWORD	  0		
BITMAPINFOHEADER	ends

;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

BITMAP	struct
	bmType			LONG	  0		
	bmWidth			LONG	  0		
	bmHeight		LONG	  0		
	bmWidthBytes	LONG	  0		
	bmPlanes		WORD	  0		
	bmBitsPixel		WORD	  0		
	bmBits			LPVOID	  0		
BITMAP	ends

HBITMAP typedef PTR BITMAP
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------

_GUID struct
	Data1	DWORD 0
	Data2	WORD  0
	Data3	WORD  0
	Data4	BYTE  0
			BYTE 0
			BYTE 0
			BYTE 0
			BYTE 0
			BYTE 0
			BYTE 0
			BYTE 0
_GUID ends

GUID typedef  _GUID
;------------------------------------------------------------------------------

;################################################################################
;#                            windows equates                                   #
;################################################################################

;===== window messages equates
	WM_ACTIVATEAPP      =  	001ch
	WM_PAINT			=	000fh
	WM_DESTROY			=	0002h

	WM_CREATE			=	0001h
	WM_DESTROY			=	0002h
	WM_MOVE				=	0003h
	WM_NCDESTROY		=	0082h
	WM_CLOSE			=	0010h
	WM_KEYDOWN			=	0100h
	WM_TIMER			=	0113h

	VK_ESCAPE			=	1Bh
	VK_F1				=	70h
	VK_F2				=	71h
	VK_F3				=	72h
	VK_F4				=	73h
	VK_F5				=	74h
	VK_F6				=	75h
	VK_F7				=	76h
	VK_F8				=	77h
	VK_F9				=	78h
	VK_F10				=	79h
	VK_F11				=	7Ah
	VK_F12				=	7Bh
;============== equates used in various APIs ===================================

; used with ShowWindow
	SW_SHOWNORMAL		= 	01h
	SW_SHOW 			=   05h
	
; DrawText() options
	DT_CENTER       	= 	01h
	DT_VCENTER      	= 	04h
	DT_SINGLELINE   	= 	20h


; cursor and icon IDs - defaults for LoadIcon and LoadCursor
	IDI_APPLICATION 	= 	32512
	IDC_ARROW       	= 	32512

;=============== equates used in defining and registering window class =========
	WHITE_BRUSH			=	 0

; Window class style options
	CS_VREDRAW         		= 0001h
	CS_HREDRAW         		= 0002h


	CS_KEYCVTWINDOW			=	00000004h
	CS_DBLCLKS				=	00000008h
	CS_OWNDC				=	00000020h
	CS_CLASSDC				=	00000040h
	CS_PARENTDC				=	00000080h
	CS_NOKEYCVT				=	00000100h
	CS_NOCLOSE				=	00000200h
	CS_SAVEBITS				=	00000800h
	CS_BYTEALIGNCLIENT		=	00001000h
	CS_BYTEALIGNWINDOW		=	00002000h
	CS_GLOBALCLASS			=	00004000h
	CS_IME					=	00010000h
;
;=== equates used in CreateWindowEx to create a window of a registered class ===
;
	WS_OVERLAPPED   		= 	00000000h
	WS_TABSTOP				=	00010000h
	WS_GROUP				=	00020000h

	WS_SYSMENU				=	00080000h	
	WS_THICKFRAME			= 	00040000h
	WS_MINIMIZEBOX  		= 	00020000h
	WS_MAXIMIZEBOX  		= 	00010000h
	
	WS_HSCROLL				=	00100000h
	WS_VSCROLL				=	00200000h
	WS_DLGFRAME				= 	00400000h
	WS_BORDER				=	00800000h
	WS_MAXIMIZE				=	01000000h
	WS_CLIPCHILDREN			=	02000000h
	WS_CLIPSIBLINGS			=	04000000h
	WS_DISABLED				=	08000000h
	WS_VISIBLE				=	10000000h
	WS_MINIMIZE				=	20000000h
	WS_CHILD				=	40000000h
	WS_POPUP				=	80000000h

	WS_CAPTION      		= WS_DLGFRAME + WS_BORDER
	
	WS_OVERLAPPEDWINDOW 	= WS_OVERLAPPED + WS_CAPTION \
							+ WS_SYSMENU + WS_THICKFRAME \
							+ WS_MINIMIZEBOX + WS_MAXIMIZEBOX
						
	WS_POPUPWINDOW			=	WS_POPUP + WS_BORDER + WS_SYSMENU
	WS_MODAL				=	WS_CAPTION + WS_SYSMENU + WS_VISIBLE
	WS_MODELESS				=	WS_CAPTION + WS_SYSMENU + WS_VISIBLE
	WS_CONTROL				=	WS_CHILD + WS_VISIBLE


	WS_TILED				=	WS_OVERLAPPED
	WS_CHILDWINDOW			=	WS_CHILD
	WS_ICONIC				=	WS_MINIMIZE
	WS_SIZEBOX				=	WS_THICKFRAME
	WS_TILEDWINDOW			=	WS_OVERLAPPEDWINDOW

;------------------------------------------------------------------------------



	WS_EX_TOPMOST			=	00000008h


	CW_USEDEFAULT			=	80000000h

	HWND_TOP				=	000h


	SWP_NOSIZE				=	0001h
	SWP_NOMOVE				=	0002h
	SWP_NOZORDER			=	0004h
	SWP_NOREDRAW			=	0008h
	SWP_NOACTIVATE			=	0010h
	SWP_FRAMECHANGED		=	0020h
	SWP_SHOWWINDOW			=	0040h
	SWP_HIDEWINDOW			=	0080h
	SWP_NOCOPYBITS			=	0100h
	SWP_NOOWNERZORDER		=	0200h
	SWP_NOSENDCHANGING		=	0400h
	SWP_DEFERERASE			=	2000h
	SWP_ASYNCWINDOWPOS		=	4000h

	SWP_DRAWFRAME			=	SWP_FRAMECHANGED
	SWP_NOREPOSITION		=	SWP_NOOWNERZORDER

	GWL_WNDPROC				=	-04
	GWL_HINSTANCE			=	-06
	GWL_HWNDPARENT			=	-08
	GWL_STYLE				=	-16
	GWL_EXSTYLE				=	-20
	GWL_USERDATA			=	-21
	GWL_ID					=	-12
;================== equates used in PeekMessage =============						
	PM_NOREMOVE			=	00h
	PM_REMOVE			=	01h
	PM_NOYIELD			=	02h

	TA_LEFT				=	0000h
	TA_RIGHT			=	0002h
	TA_CENTER			=	0006h
	TA_TOP				=	000h
	TA_BOTTOM			=	008h
	TA_BASELINE			=	018h

	MB_OK				=	000000000h

	IMAGE_BITMAP 		= 0
	LR_LOADFROMFILE 	= 00000010h
	LR_CREATEDIBSECTION = 00002000h
	SRCCOPY				= 00cc0020h
;################################################################################
;#                               prototypes                                     #
;################################################################################



;################################################################################
;#                           prototypes of APIs                                 #
;################################################################################


;--- used in WinMain 	---------------------------
	GetModuleHandleA	PROTO	STDCALL	:DWORD

	ShowWindow			PROTO	STDCALL	:HWND, :SDWORD
	UpdateWindow		PROTO	STDCALL	:HWND
	SetWindowLongA 		PROTO 	STDCALL :DWORD, :DWORD, :DWORD
	SetWindowPos		PROTO	STDCALL	:HWND, :HWND, :UINT, :UINT, :UINT, :UINT, :UINT
	
;	GetClientRect		PROTO 	STDCALL	:HWND, :LPRECT
	GetWindowRect		PROTO 	STDCALL	:HWND, :LPRECT
	ClientToScreen		PROTO 	STDCALL	:HWND, :LPPOINT

; these are used in the message loop ----------
	PeekMessageA		PROTO	STDCALL	:LPMSG, :HWND, :UINT, :UINT, :UINT
	GetMessageA			PROTO	STDCALL	:LPMSG, :HWND, :UINT, :UINT
	TranslateMessage	PROTO	STDCALL	:LPMSG
	DispatchMessageA	PROTO	STDCALL	:LPMSG
	WaitMessage			PROTO	STDCALL
	ExitProcess			PROTO	STDCALL	:DWORD
	PostMessageA		PROTO	STDCALL	:HWND, :UINT, :WPARAM, :LPARAM
;---these are used in WindowProc ----------------

	; used if a message isn't handled 
	; specifically in the window routine

	DefWindowProcA		PROTO	STDCALL	:HWND, :UINT, :WPARAM, :LPARAM

	; used to handle WM_PAINT messages

	BeginPaint			PROTO	STDCALL	:HWND, 	:LPPAINTSTRUCT
	GetClientRect		PROTO	STDCALL	:HWND, 	:LPRECT
	DrawTextA			PROTO	STDCALL	:HDC, 	:LPCSTR, :UINT, :LPRECT, :UINT
	EndPaint			PROTO	STDCALL	:HWND, 	:LPPAINTSTRUCT

	; used to handle WM_DESTROY messages

	PostQuitMessage		PROTO	STDCALL	:SWORD

;--- these are used in Initialise --
	LoadCursorA			PROTO	STDCALL	:HINSTANCE, :LPCSTR
	LoadIconA			PROTO	STDCALL	:HINSTANCE, :LPCSTR
	GetStockObject		PROTO	STDCALL	:SDWORD				;used to get a brush

	RegisterClassA	    PROTO STDCALL :DWORD

	CreateWindowExA		PROTO	STDCALL	:DWORD, :LPCSTR, :LPCSTR, :DWORD, :SDWORD,\
	 					:SDWORD, :SDWORD, :SDWORD, :HWND, :HMENU, :HINSTANCE, :DWORD
	 					
;--- these are used in Update, Paint or whatever 
	GetDC				PROTO	STDCALL	:HWND
	TextOutA			PROTO	STDCALL	:HDC, :DWORD, :DWORD, :LPCSTR, :DWORD
	ReleaseDC			PROTO	STDCALL	:HWND, :HDC	

	
	SetTextAlign		PROTO	STDCALL	:HDC, :UINT
	SetTextColor		PROTO	STDCALL	:HDC, :COLORREF
	MessageBoxA			PROTO	STDCALL	:HWND, :LPCSTR, :LPCSTR, :UINT
	MessageBeep			PROTO	STDCALL	:DWORD
;----------------- multimedia, timing, etc. -------	
	timeGetTime 		PROTO 	STDCALL
	
	GetTickCount   		PROTO 	STDCALL 
	
	SetTimer 			PROTO 	STDCALL :HWND, :INTEGER, :INTEGER, :INTEGER
	
;----------------- rectangles and window adjustment -------------------
	SetRect 			PROTO 	STDCALL :LPRECT, :INTEGER, :INTEGER, :INTEGER, :INTEGER

	AdjustWindowRectEx 	PROTO 	STDCALL :LPRECT, :DWORD, :BOOL, :DWORD
	SetWindowLongA 		PROTO 	STDCALL :DWORD, :DWORD, :DWORD
	SetWindowPos		PROTO	STDCALL	:HWND, :HWND, :UINT, :UINT, :UINT, :UINT, :UINT
	MoveWindow  		PROTO 	STDCALL :HWND, :INTEGER, :INTEGER, :INTEGER, :INTEGER, :BOOL

;-----------------  utilities, tools... ------------------------------

	wsprintfA  			PROTO	C		
	lstrlenA			PROTO	STDCALL	:LPCSTR 
	MessageBeep  		PROTO 	STDCALL :DWORD
  	RtlZeroMemory 		PROTO 	STDCALL :DWORD, :DWORD	
	
;----------------- objects and images: the GDI ------------------------
	LoadImageA 			PROTO 	STDCALL :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
  	CreateCompatibleDC 	PROTO 	STDCALL :DWORD
  	SelectObject 		PROTO 	STDCALL :DWORD, :DWORD
  	StretchBlt 			PROTO 	STDCALL :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, \
  							  :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
 	BitBlt 				PROTO 	STDCALL :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, \
  							  :DWORD, :DWORD, :DWORD

  	GetObjectA 			PROTO 	STDCALL :DWORD, :DWORD, :DWORD

  	DeleteDC 			PROTO 	STDCALL :DWORD
  	DeleteObject 		PROTO 	STDCALL :DWORD
;################################################################################
;#                           prototypes of my PROCs                             #
;################################################################################








			
 	
  

 
