; tddraw.inc  (c) Minde  06/08/99 montana@is.lt
; Content:  TASM DirectDraw include file ver. 1.2
; converted from ddraw.h, DX ver. 6.1
;
;  Feel free to use or distribute the package, part or whole, for any
; non-commercial use preferably crediting me.
;  Also feel free to contact me at the above address if you experience any
; problems or notice any omissions.

;################################################################################
;#                                Direct Draw Stuff                             #
;################################################################################

DIRECTX_VERSION = 0600h

DirectDrawEnumerate     = DirectDrawEnumerateA
DirectDrawEnumerateEx   = DirectDrawEnumerateExA
DirectDrawCreate        PROCDESC STDCALL :DWORD, :DWORD, :DWORD
DirectDrawEnumerateA    PROCDESC STDCALL :DWORD, :DWORD
DirectDrawEnumerateExA  PROCDESC STDCALL :DWORD, :DWORD, :DWORD
DirectDrawCreateClipper PROCDESC STDCALL :DWORD, :DWORD, :DWORD


; GUIDS used by DirectDraw objects
CLSID_DirectDraw            GUID <0D7B70EE0h,04340h,011CFh,0B0h,063h,000h,020h,0AFh,0C2h,0CDh,035h>
CLSID_DirectDrawClipper     GUID <0593817A0h,07DB3h,011CFh,0A2h,0DEh,000h,0AAh,000h,0b9h,033h,056h>
CLSID_DirectDrawFactory     GUID <04fd2a832h,086c8h,011d0h,08fh,0cah,000h,0c0h,04fh,0d9h,018h,09dh>
IID_IDirectDraw             GUID <06C14DB80h,0A733h,011CEh,0A5h,021h,000h,020h,0AFh,00Bh,0E5h,060h>
IID_IDirectDraw2            GUID <0B3A6F3E0h,02B43h,011CFh,0A2h,0DEh,000h,0AAh,000h,0B9h,033h,056h>
IID_IDirectDraw3            GUID <0618f8ad4h,08b7ah,011d0h,08fh,0cch,000h,0c0h,04fh,0d9h,018h,09dh>
IID_IDirectDraw4            GUID <09c59509ah,039bdh,011d1h,08ch,04ah,000h,0c0h,04fh,0d9h,030h,0c5h>
IID_IDirectDrawSurface      GUID <06C14DB81h,0A733h,011CEh,0A5h,021h,000h,020h,0AFh,00Bh,0E5h,060h>
IID_IDirectDrawSurface2     GUID <057805885h,06eech,011cfh,094h,041h,0a8h,023h,003h,0c1h,00eh,027h>
IID_IDirectDrawSurface3     GUID <0DA044E00h,069B2h,011D0h,0A1h,0D5h,000h,0AAh,000h,0B8h,0DFh,0BBh>
IID_IDirectDrawSurface4     GUID <00B2B8630h,0AD35h,011D0h,08Eh,0A6h,000h,060h,097h,097h,0EAh,05Bh>
IID_IDirectDrawPalette      GUID <06C14DB84h,0A733h,011CEh,0A5h,021h,000h,020h,0AFh,00Bh,0E5h,060h>
IID_IDirectDrawClipper      GUID <06C14DB85h,0A733h,011CEh,0A5h,021h,000h,020h,0AFh,00Bh,0E5h,060h>
IID_IDirectDrawColorControl GUID <04B9F0EE0h,00D7Eh,011D0h,09Bh,006h,000h,0A0h,0C9h,003h,0A3h,0B8h>
IID_IDirectDrawGammaControl GUID <069C11C3Eh,0B46Bh,011D1h,0ADh,07Ah,000h,0C0h,04Fh,0C2h,09Bh,04Eh>



DD_ROP_SPACE = (256 / 32);       // space required to store ROP array
MAX_DDDEVICEID_STRING   = 512;
DDGDI_GETHOSTIDENTIFIER         = 00000001h;


REFGUID struct
    union
refguid_guid        DD ?
refguid_dwFlags     DD ?
    ends
REFGUID ends

DDRGBA struct
ddrgba_red         DB ?
ddrgba_green       DB ?
ddrgba_blue        DB ?
ddrgba_alpha       DB ?
DDRGBA ends

DDCOLORKEY struct
ddcolorkey_dwColorSpaceLowValue    DD ?
ddcolorkey_dwColorSpaceHighValue   DD ?
DDCOLORKEY ends

DDBLTFX struct
ddbltfx_dwSize                       DD ?
ddbltfx_dwDDFX                       DD ?
ddbltfx_dwROP                        DD ?
ddbltfx_dwDDROP                      DD ?
ddbltfx_dwRotationAngle              DD ?
ddbltfx_dwZBufferOpCode              DD ?
ddbltfx_dwZBufferLow                 DD ?
ddbltfx_dwZBufferHigh                DD ?
ddbltfx_dwZBufferBaseDest            DD ?
ddbltfx_dwZDestConstBitDepth         DD ?
    union
ddbltfx_dwZDestConst                 DD ?
ddbltfx_lpDDSZBufferDest             DD ?
    ends
ddbltfx_dwZSrcConstBitDepth          DD ?
    union
ddbltfx_dwZSrcConst                  DD ?
ddbltfx_lpDDSZBufferSrc              DD ?
    ends
ddbltfx_dwAlphaEdgeBlendBitDepth     DD ?
ddbltfx_dwAlphaEdgeBlend             DD ?
ddbltfx_dwBltFxReserved              DD ?
ddbltfx_dwAlphaDestConstBitDepth     DD ?
    union
ddbltfx_dwAlphaDestConst             DD ?
ddbltfx_lpDDSAlphaDest               DD ?
    ends
ddbltfx_dwAlphaSrcConstBitDepth      DD ?
    union
ddbltfx_dwAlphaSrcConst              DD ?
ddbltfx_lpDDSAlphaSrc                DD ?
    ends
    union
ddbltfx_dwFillColor                  DD ?
ddbltfx_dwFillDepth                  DD ?
ddbltfx_lpDDSPattern                 DD ?
    ends
ddbltfx_ddckDestColorkey             DDCOLORKEY <>
ddbltfx_ddckSrcColorkey              DDCOLORKEY <>
DDBLTFX ends

DDSCAPS struct
dwCaps      DD ?    ; ONLY THIS STRUCTURE NOT MODIFIED, ADDING TO MEMBER NAME TAG NAME
DDSCAPS ends

DDOSCAPS struct
ddoscaps_dwCaps      DD ?
DDOSCAPS ends

DDSCAPSEX struct
ddocapsex_dwCaps2     DD ?
ddocapsex_dwCaps3     DD ?
ddocapsex_dwCaps4     DD ?
DDSCAPSEX ends

DDSCAPS2 struct
ddocaps2_dwCaps      DD ?
ddocaps2_dwCaps2     DD ?
ddocaps2_dwCaps3     DD ?
ddocaps2_dwCaps4     DD ?
DDSCAPS2 ends


DDCAPS struct
ddcaps_dwSize                            DD ? ; size of  DDDRIVERCAPS
ddcaps_dwCaps                            DD ?
ddcaps_dwCaps2                           DD ?
ddcaps_dwCKeyCaps                        DD ?
ddcaps_dwFXCaps                          DD ?
ddcaps_dwFXAlphaCaps                     DD ?
ddcaps_dwPalCaps                         DD ?
ddcaps_dwSVCaps                          DD ?
ddcaps_dwAlphaBltConstBitDepths          DD ? ; DDBD_2,4,8
ddcaps_dwAlphaBltPixelBitDepths          DD ? ; DDBD_1,2,4,8
ddcaps_dwAlphaBltSurfaceBitDepths        DD ? ; DDBD_1,2,4,8
ddcaps_dwAlphaOverlayConstBitDepths      DD ? ; DDBD_2,4,8
ddcaps_dwAlphaOverlayPixelBitDepths      DD ? ; DDBD_1,2,4,8
ddcaps_dwAlphaOverlaySurfaceBitDepths    DD ? ; DDBD_1,2,4,8
ddcaps_dwZBufferBitDepths                DD ? ; DDBD_8,16,24,32
ddcaps_dwVidMemTotal                     DD ?
ddcaps_dwVidMemFree                      DD ?
ddcaps_dwMaxVisibleOverlays              DD ?
ddcaps_dwCurrVisibleOverlays             DD ?
ddcaps_dwNumFourCCCodes                  DD ?
ddcaps_dwAlignBoundarySrc                DD ?
ddcaps_dwAlignSizeSrc                    DD ?
ddcaps_dwAlignBoundaryDest               DD ?
ddcaps_dwAlignSizeDest                   DD ?
ddcaps_dwAlignStrideAlign                DD ?
ddcaps_dwRops                            DD DD_ROP_SPACE DUP (?)
IF DIRECTX_VERSION LT 0600h
ddcaps_ddsCaps                           DDSCAPS     <>
ELSE
ddcaps_ddsOldCaps                        DDSCAPS     <> ; was ddsCaps DDSCAPS, in dx6 is ddsOldCaps DDSCAPS
ENDIF
ddcaps_dwMinOverlayStretch               DD ? ; min overlay stretch factor * 1000
ddcaps_dwMaxOverlayStretch               DD ? ; max overlay stretch factor * 1000
ddcaps_dwMinLiveVideoStretch             DD ? ; min live video stretch factor * 1000
ddcaps_dwMaxLiveVideoStretch             DD ? ; max live video stretch factor * 1000
ddcaps_dwMinHwCodecStretch               DD ? ; min hardware codec stretch factor * 1000
ddcaps_dwMaxHwCodecStretch               DD ? ; max hardware codec stretch factor * 1000
ddcaps_dwReserved1                       DD ?
ddcaps_dwReserved2                       DD ?
ddcaps_dwReserved3                       DD ?
ddcaps_dwSVBCaps                         DD ?
ddcaps_dwSVBCKeyCaps                     DD ?
ddcaps_dwSVBFXCaps                       DD ?
ddcaps_dwSVBRops                         DD DD_ROP_SPACE DUP (?)
ddcaps_dwVSBCaps                         DD ?
ddcaps_dwVSBCKeyCaps                     DD ?
ddcaps_dwVSBFXCaps                       DD ?
ddcaps_dwVSBRops                         DD DD_ROP_SPACE DUP (?)
ddcaps_dwSSBCaps                         DD ?
ddcaps_dwSSBCKeyCaps                     DD ?
ddcaps_dwSSBFXCaps                       DD ?
ddcaps_dwSSBRops                         DD DD_ROP_SPACE DUP (?)
IF DIRECTX_VERSION LT 0500h
ddcaps_dwReserved4                       DD ?
ddcaps_dwReserved5                       DD ?
ddcaps_dwReserved6                       DD ?
ENDIF
IF DIRECTX_VERSION EQ 0500h
ddcaps_dwMaxVideoPorts                   DD ?
ddcaps_dwCurrVideoPorts                  DD ?
ddcaps_dwSVBCaps2                        DD ?
ddcaps_dwNLVBCaps                        DD ?
ddcaps_dwNLVBCaps2                       DD ?
ddcaps_dwNLVBCKeyCaps                    DD ?
ddcaps_dwNLVBFXCaps                      DD ?
ddcaps_dwNLVBRops                        DD DD_ROP_SPACE DUP (?)
ENDIF
IF DIRECTX_VERSION GE 0600h
; Members added for DX5 release
ddcaps_dwMaxVideoPorts                   DD ? ; maximum number of usable video ports
ddcaps_dwCurrVideoPorts                  DD ? ; current number of video ports used
ddcaps_dwSVBCaps2                        DD ? ; more driver specific capabilities for System->Vmem blts
ddcaps_dwNLVBCaps                        DD ? ; driver specific capabilities for non-local->local vidmem blts
ddcaps_dwNLVBCaps2                       DD ? ; more driver specific capabilities non-local->local vidmem blts
ddcaps_dwNLVBCKeyCaps                    DD ? ; driver color key capabilities for non-local->local vidmem blts
ddcaps_dwNLVBFXCaps                      DD ? ; driver FX capabilities for non-local->local blts
ddcaps_dwNLVBRops                        DD DD_ROP_SPACE DUP (?) ; ROPS supported for non-local->local blts
; Members added for DX6 release
ddcaps_ddsCaps                           DDSCAPS2 ? ; Surface Caps
ENDIF
DDCAPS ends


DDPIXELFORMAT struct
ddpixelformat_dwSize                       DD ?
ddpixelformat_dwFlags                      DD ?
ddpixelformat_dwFourCC                     DD ?
    union
ddpixelformat_dwRGBBitCount                DD ?
ddpixelformat_dwYUVBitCount                DD ?
ddpixelformat_dwZBufferBitDepth            DD ?
ddpixelformat_dwAlphaBitDepth              DD ?
IF DIRECTX_VERSION GE 0600h
ddpixelformat_dwLuminanceBitCount          DD ?
ddpixelformat_dwBumpBitCount               DD ?
ENDIF
    ends
    union
ddpixelformat_dwRBitMask                   DD ?
ddpixelformat_dwYBitMask                   DD ?
IF DIRECTX_VERSION GE 0600h
ddpixelformat_dwStencilBitDepth            DD ?
ddpixelformat_dwLuminanceBitMask           DD ?
ddpixelformat_dwBumpDuBitMask              DD ?
ENDIF
    ends
    union
ddpixelformat_dwGBitMask                   DD ?
ddpixelformat_dwUBitMask                   DD ?
IF DIRECTX_VERSION GE 0600h
ddpixelformat_dwZBitMask                   DD ?
ddpixelformat_dwBumpDvBitMask              DD ?
ENDIF
    ends
    union
ddpixelformat_dwBBitMask                   DD ?
ddpixelformat_dwVBitMask                   DD ?
IF DIRECTX_VERSION GE 0600h
ddpixelformat_dwStencilBitMask             DD ?
ddpixelformat_dwBumpLuminanceBitMask       DD ?
ENDIF
    ends
    union
ddpixelformat_dwRGBAlphaBitMask            DD ?
ddpixelformat_dwYUVAlphaBitMask            DD ?
IF DIRECTX_VERSION GE 0600h
ddpixelformat_dwLuminanceAlphaBitMask      DD ?
ENDIF
ddpixelformat_dwRGBZBitMask                DD ?
ddpixelformat_dwYUVZBitMask                DD ?
    ends
DDPIXELFORMAT  ends


DDOVERLAYFX struct
ddoverlayfx_dwSize                       DD ?
ddoverlayfx_dwAlphaEdgeBlendBitDepth     DD ?
ddoverlayfx_dwAlphaEdgeBlend             DD ?
ddoverlayfx_dwReserved                   DD ?
ddoverlayfx_dwAlphaDestConstBitDepth     DD ?
    union 
ddoverlayfx_dwAlphaDestConst             DD ?
ddoverlayfx_lpDDSAlphaDest               DD ?
    ends
ddoverlayfx_dwAlphaSrcConstBitDepth      DD ?
    union 
ddoverlayfx_dwAlphaSrcConst              DD ?
ddoverlayfx_lpDDSAlphaSrc                DD ?
ddoverlayfx_dckDestColorkey              DDCOLORKEY <>
ddoverlayfx_dckSrcColorkey               DDCOLORKEY <>
ddoverlayfx_dwDDFX                       DD ?
ddoverlayfx_dwFlags                      DD ?
    ends
DDOVERLAYFX ends

DDBLTBATCH struct
ddbltbatch_lprDest          DD ?
ddbltbatch_lpDDSSrc         DD ?
ddbltbatch_lprSrc           DD ?
ddbltbatch_dwFlags          DD ?
ddbltbatch_lpDDBltFx        DD ?
DDBLTBATCH ends

DDGAMMARAMP struct
ddgammaramp_red             DW 256 DUP (?)
ddgammaramp_green           DW 256 DUP (?)
ddgammaramp_blue            DW 256 DUP (?)
DDGAMMARAMP ends


DDDEVICEIDENTIFIER struct
dddeviceidentifier_szDriver                DB MAX_DDDEVICEID_STRING DUP (?)
dddeviceidentifier_szDescription           DB MAX_DDDEVICEID_STRING DUP (?)
dddeviceidentifier_liDriverVersion         DQ ?
dddeviceidentifier_dwVendorId              DD ?
dddeviceidentifier_dwDeviceId              DD ?
dddeviceidentifier_dwSubSysId              DD ?
dddeviceidentifier_dwRevision              DD ?
dddeviceidentifier_guidDeviceIdentifier    GUID <>
DDDEVICEIDENTIFIER ends


DDSURFACEDESC struct
ddsurfacedesc_dwSize                          DD ?
ddsurfacedesc_dwFlags                         DD ?
ddsurfacedesc_dwHeight                        DD ?
ddsurfacedesc_dwWidth                         DD ?
    union 
ddsurfacedesc_lPitch                          DD ?
ddsurfacedesc_dwLinearSize                    DD ?
    ends
ddsurfacedesc_dwBackBufferCount               DD ?
    union
ddsurfacedesc_dwMipMapCount                   DD ?
ddsurfacedesc_dwZBufferBitDepth               DD ?
ddsurfacedesc_dwRefreshRate                   DD ?
    ends
ddsurfacedesc_dwAlphaBitDepth                 DD ?
ddsurfacedesc_dwReserved                      DD ?
ddsurfacedesc_lpSurface                       DD ?
ddsurfacedesc_ddckCKDestOverlay               DDCOLORKEY ?
ddsurfacedesc_ddckCKDestBlt                   DDCOLORKEY ?
ddsurfacedesc_ddckCKSrcOverlay                DDCOLORKEY ?
ddsurfacedesc_ddckCKSrcBlt                    DDCOLORKEY ?
ddsurfacedesc_ddpfPixelFormat                 DDPIXELFORMAT ?
ddsurfacedesc_ddssurfCaps                     DDSCAPS ?
DDSURFACEDESC ends


DDSURFACEDESC2 struct
ddsurfacedesc2_dwSize                          DD ?
ddsurfacedesc2_dwFlags                         DD ?
ddsurfacedesc2_dwHeight                        DD ?
ddsurfacedesc2_dwWidth                         DD ?
    union 
ddsurfacedesc2_lPitch                          DD ?
ddsurfacedesc2_dwLinearSize                    DD ?
    ends
ddsurfacedesc2_dwBackBufferCount               DD ?
    union
ddsurfacedesc2_dwMipMapCount                   DD ?
ddsurfacedesc2_dwRefreshRate                   DD ?
    ends
ddsurfacedesc2_dwAlphaBitDepth                 DD ?
ddsurfacedesc2_dwReserved                      DD ?
ddsurfacedesc2_lpSurface                       DD ?
ddsurfacedesc2_ddckCKDestOverlay               DDCOLORKEY ?
ddsurfacedesc2_ddckCKDestBlt                   DDCOLORKEY ?
ddsurfacedesc2_ddckCKSrcOverlay                DDCOLORKEY ?
ddsurfacedesc2_ddckCKSrcBlt                    DDCOLORKEY ?
ddsurfacedesc2_ddpfPixelFormat                 DDPIXELFORMAT ?
ddsurfacedesc2_ddssurfCaps                     DDSCAPS2 ?
ddsurfacedesc2_dwTextureStage                  DD ?
DDSURFACEDESC2 ends


DDOPTSURFACEDESC struct
ddoptsurfacedesc_dwSize              DD ? ; size of the DDOPTSURFACEDESC structure
ddoptsurfacedesc_dwFlags             DD ? ; determines what fields are valid
ddoptsurfacedesc_ddSCaps             DDSCAPS2 ? ; Common caps like: Memory type
ddoptsurfacedesc_ddOSCaps            DDOSCAPS ? ; Common caps like: Memory type
ddoptsurfacedesc_guid                GUID ? ; Compression technique GUID
ddoptsurfacedesc_dwCompressionRatio  DD ? ; Compression ratio
DDOPTSURFACEDESC ends


DDCOLORCONTROL struct
ddcolorcontrol_dwSize          DD ?
ddcolorcontrol_dwFlags         DD ?
ddcolorcontrol_lBrightness     DD ?
ddcolorcontrol_lContrast       DD ?
ddcolorcontrol_lHue            DD ?
ddcolorcontrol_lSaturation     DD ?
ddcolorcontrol_lSharpness      DD ?
ddcolorcontrol_lGamma          DD ?
ddcolorcontrol_lColorEnable    DD ?
ddcolorcontrol_dwReserved1     DD ?
DDCOLORCONTROL ends

;==============================================================================
;                                    METHODS...
;==============================================================================

; IDirectDraw
; IUnknown methods
DDQueryInterface            = 0
DDAddRef                    = 4
DDRelease                   = 8
; IDirectDraw methods
DDCompact                   = 12
DDCreateClipper             = 16
DDCreatePalette             = 20
DDCreateSurface             = 24
DDDuplicateSurface          = 28
DDEnumDisplayModes          = 32
DDEnumSurfaces              = 36
DDFlipToGDISurface          = 40
DDGetCaps                   = 44
DDGetDisplayMode            = 48
DDGetFourCCCodes            = 52
DDGetGDISurface             = 56
DDGetMonitorFrequency       = 60
DDGetScanLine               = 64
DDGetVerticalBlankStatus    = 68
DDInitialize                = 72
DDRestoreDisplayMode        = 76
DDSetCooperativeLevel       = 80
DDSetDisplayMode            = 84
DDWaitForVerticalBlank      = 88
; IDirectDraw2
DD2GetAvailableVidMem       = 92
; IDirectDraw3
DD3GetSurfaceFromDC         = 96
; IDirectDraw4
DD3RestoreAllSurfaces       = 100
DD3TestCooperativeLevel     = 104
DD3GetDeviceIdentifier      = 108


; IDirectDrawPalette
; IUnknown methods
DDPQueryInterface                   = 0
DDPAddRef                           = 4
DDPRelease                          = 8
; IDirectDrawPalette methods
DDPGetCaps                          = 12
DDPGetEntries                       = 16
DDPInitialize                       = 20
DDPSetEntries                       = 24


; IDirectDrawSurface
; IUnknown methods
DDSQueryInterface                   = 0
DDSAddRef                           = 4
DDSRelease                          = 8
 ; IDirectDrawSurface methods
DDSAddAttachedSurface               = 12
DDSAddOverlayDirtyRect              = 16
DDSBlt                              = 20
DDSBltBatch                         = 24
DDSBltFast                          = 28
DDSDeleteAttachedSurface            = 32
DDSEnumAttachedSurfaces             = 36
DDSEnumOverlayZOrders               = 40
DDSFlip                             = 44
DDSGetAttachedSurface               = 48
DDSGetBltStatus                     = 52
DDSGetCaps                          = 56
DDSGetClipper                       = 60
DDSGetColorKey                      = 64
DDSGetDC                            = 68
DDSGetFlipStatus                    = 72
DDSGetOverlayPosition               = 76
DDSGetPalette                       = 80
DDSGetPixelFormat                   = 84
DDSGetSurfaceDesc                   = 88
DDSInitialize                       = 92
DDSIsLost                           = 96
DDSLock                             = 100
DDSReleaseDC                        = 104
DDSRestore                          = 108
DDSSetClipper                       = 112
DDSSetColorKey                      = 116
DDSSetOverlayPosition               = 120
DDSSetPalette                       = 124
DDSUnlock                           = 128
DDSUpdateOverlay                    = 132
DDSUpdateOverlayDisplay             = 136
DDSUpdateOverlayZOrder              = 140
; IDirectDrawSurface2 
DDS2GetDDInterface                  = 144
DDS2PageLock                        = 148
DDS2PageUnlock                      = 152
; IDirectDrawSurface3
DDS3SetSurfaceDesc                  = 156
; IDirectDrawSurface4
DDS4SetPrivateData                  = 160
DDS4GetPrivateData                  = 164
DDS4FreePrivateData                 = 168
DDS4GetUniquenessValue              = 172
DDS4ChangeUniquenessValue           = 176


; IDirectDrawClipper
; IUnknown methods
DDCQueryInterface                   = 0
DDCAddRef                           = 4
DDCRelease                          = 8
 ;IDirectDrawClipper methods
DDCGetClipList                      = 12
DDCGetHWnd                          = 16
DDCInitialize                       = 20
DDCIsClipListChanged                = 24
DDCSetClipList                      = 28
DDCSetHWnd                          = 32


; IDirectDrawColorControl
; IUnknown methods
DDCCQueryInterface                  = 0
DDCCAddRef                          = 4
DDCCRelease                         = 8
;IDirectDrawColorControl methods
DDCCGetColorControls                = 12
DDCCSetColorControls                = 16


; IDirectDrawGammaControl
; IUnknown methods
DDGCQueryInterface                  = 0
DDGCAddRef                          = 4
DDGCRelease                         = 8
;IDirectDrawGammaControl methods
DDGCGetGammaRamp                    = 12
DDGCSetGammaRamp                    = 16


; IDirectDrawFactory
; IUnknown methods
DDFQueryInterface           = 0
DDFAddRef                   = 4
DDFRelease                  = 8
; IDirectDrawFactory methods
DDFCreateDirectDraw         = 12
DDFDirectDrawEnumerate      = 16


;==============================================================================
;                       FLAGS, RETURN CODES, etc...
;==============================================================================

DDSD_CAPS               = 00000001h; ddsCaps field is valid.
DDSD_HEIGHT             = 00000002h; dwHeight field is valid.
DDSD_WIDTH              = 00000004h; dwWidth field is valid.
DDSD_PITCH              = 00000008h; lPitch is valid.
DDSD_BACKBUFFERCOUNT    = 00000020h; dwBackBufferCount is valid.
DDSD_ZBUFFERBITDEPTH    = 00000040h; dwZBufferBitDepth is valid.  (shouldnt be used in DDSURFACEDESC2)
DDSD_ALPHABITDEPTH      = 00000080h; dwAlphaBitDepth is valid.
DDSD_LPSURFACE          = 00000800h; lpSurface is valid.
DDSD_PIXELFORMAT        = 00001000h; ddpfPixelFormat is valid.
DDSD_CKDESTOVERLAY      = 00002000h; ddckCKDestOverlay is valid.
DDSD_CKDESTBLT          = 00004000h; ddckCKDestBlt is valid.
DDSD_CKSRCOVERLAY       = 00008000h; ddckCKSrcOverlay is valid.
DDSD_CKSRCBLT           = 00010000h; ddckCKSrcBlt is valid.
DDSD_MIPMAPCOUNT        = 00020000h; dwMipMapCount is valid.
DDSD_REFRESHRATE        = 00040000h; dwRefreshRate is valid
DDSD_LINEARSIZE         = 00080000h; dwLinearSize is valid
DDSD_TEXTURESTAGE       = 00100000h; dwTextureStage is valid
DDSD_ALL                = 001ff9eeh; All input fields are valid.
DDOSD_GUID              = 00000001h; guid field is valid.
DDOSD_COMPRESSION_RATIO = 00000002h; dwCompressionRatio field is valid.
DDOSD_SCAPS             = 00000004h; ddSCaps field is valid.
DDOSD_OSCAPS            = 00000008h; ddOSCaps field is valid.
DDOSD_ALL               = 0000000fh; All input fields are valid.
DDOSDCAPS_OPTCOMPRESSED     = 00000001h; The surface's optimized pixelformat is compressed
DDOSDCAPS_OPTREORDERED      = 00000002h; The surface's optimized pixelformat is reordered
DDOSDCAPS_MONOLITHICMIPMAP  = 00000004h; The opt surface is a monolithic mipmap


; The valid Surf caps:
DDSCAPS_SYSTEMMEMORY       = 000000800h;
DDSCAPS_VIDEOMEMORY        = 000004000h;
DDSCAPS_LOCALVIDMEM        = 010000000h;
DDSCAPS_NONLOCALVIDMEM     = 020000000h;

DDOSDCAPS_VALIDSCAPS       = 030004800h;
DDOSDCAPS_VALIDOSCAPS      = 000000007h; The valid OptSurf caps


DDCOLOR_BRIGHTNESS          = 00000001h; lBrightness field is valid.
DDCOLOR_CONTRAST            = 00000002h; lContrast field is valid.
DDCOLOR_HUE                 = 00000004h; lHue field is valid.
DDCOLOR_SATURATION          = 00000008h; lSaturation field is valid.
DDCOLOR_SHARPNESS           = 00000010h; lSharpness field is valid.
DDCOLOR_GAMMA               = 00000020h; lGamma field is valid.
DDCOLOR_COLORENABLE         = 00000040h; lColorEnable field is valid.



; *
; * DIRECTDRAWSURFACE CAPABILITY FLAGS
; *
DDSCAPS_RESERVED1                       = 00000001h; This bit currently has no meaning.
DDSCAPS_ALPHA                           = 00000002h;
DDSCAPS_BACKBUFFER                      = 00000004h;
DDSCAPS_COMPLEX                         = 00000008h;
DDSCAPS_FLIP                            = 00000010h;
DDSCAPS_FRONTBUFFER                     = 00000020h;
DDSCAPS_OFFSCREENPLAIN                  = 00000040h;
DDSCAPS_OVERLAY                         = 00000080h;
DDSCAPS_PALETTE                         = 00000100h;
DDSCAPS_PRIMARYSURFACE                  = 00000200h;
DDSCAPS_PRIMARYSURFACELEFT              = 00000400h;
DDSCAPS_SYSTEMMEMORY                    = 00000800h;
DDSCAPS_TEXTURE                         = 00001000h;
DDSCAPS_3DDEVICE                        = 00002000h;
DDSCAPS_VIDEOMEMORY                     = 00004000h;
DDSCAPS_VISIBLE                         = 00008000h;
DDSCAPS_WRITEONLY                       = 00010000h;
DDSCAPS_ZBUFFER                         = 00020000h;
DDSCAPS_OWNDC                           = 00040000h;
DDSCAPS_LIVEVIDEO                       = 00080000h;
DDSCAPS_HWCODEC                         = 00100000h;
DDSCAPS_MODEX                           = 00200000h;
DDSCAPS_MIPMAP                          = 00400000h;
DDSCAPS_RESERVED2                       = 00800000h;
DDSCAPS_ALLOCONLOAD                     = 04000000h;
DDSCAPS_VIDEOPORT                       = 08000000h;
DDSCAPS_LOCALVIDMEM                     = 10000000h;
DDSCAPS_NONLOCALVIDMEM                  = 20000000h;
DDSCAPS_STANDARDVGAMODE                 = 40000000h;
DDSCAPS_OPTIMIZED                       = 80000000h;
DDSCAPS2_HARDWAREDEINTERLACE            = 00000002h;
DDSCAPS2_HINTDYNAMIC                    = 00000004h;
DDSCAPS2_HINTSTATIC                     = 00000008h;
DDSCAPS2_TEXTUREMANAGE                  = 00000010h;
DDSCAPS2_RESERVED1                      = 00000020h;
DDSCAPS2_RESERVED2                      = 00000040h;
DDSCAPS2_OPAQUE                         = 00000080h;
DDSCAPS2_HINTANTIALIASING               = 00000100h;



; *
; * DIRECTDRAW DRIVER CAPABILITY FLAGS
; *

DDCAPS_3D                       = 000000001h;
DDCAPS_ALIGNBOUNDARYDEST        = 000000002h;
DDCAPS_ALIGNSIZEDEST            = 000000004h;
DDCAPS_ALIGNBOUNDARYSRC         = 000000008h;
DDCAPS_ALIGNSIZESRC             = 000000010h;
DDCAPS_ALIGNSTRIDE              = 000000020h;
DDCAPS_BLT                      = 000000040h;
DDCAPS_BLTQUEUE                 = 000000080h;
DDCAPS_BLTFOURCC                = 000000100h;
DDCAPS_BLTSTRETCH               = 000000200h;
DDCAPS_GDI                      = 000000400h;
DDCAPS_OVERLAY                  = 000000800h;
DDCAPS_OVERLAYCANTCLIP          = 000001000h;
DDCAPS_OVERLAYFOURCC            = 000002000h;
DDCAPS_OVERLAYSTRETCH           = 000004000h;
DDCAPS_PALETTE                  = 000008000h;
DDCAPS_PALETTEVSYNC             = 000010000h;
DDCAPS_READSCANLINE             = 000020000h;
DDCAPS_STEREOVIEW               = 000040000h;
DDCAPS_VBI                      = 000080000h;
DDCAPS_ZBLTS                    = 000100000h;
DDCAPS_ZOVERLAYS                = 000200000h;
DDCAPS_COLORKEY                 = 000400000h;
DDCAPS_ALPHA                    = 000800000h;
DDCAPS_COLORKEYHWASSIST         = 001000000h;
DDCAPS_NOHARDWARE               = 002000000h;
DDCAPS_BLTCOLORFILL             = 004000000h;
DDCAPS_BANKSWITCHED             = 008000000h;
DDCAPS_BLTDEPTHFILL             = 010000000h;
DDCAPS_CANCLIP                  = 020000000h;
DDCAPS_CANCLIPSTRETCHED         = 040000000h;
DDCAPS_CANBLTSYSMEM             = 080000000h;


; *
; * MORE DIRECTDRAW DRIVER CAPABILITY FLAGS (dwCaps2)
; *

DDCAPS2_CERTIFIED                 = 000000001h;
DDCAPS2_NO2DDURING3DSCENE         = 000000002h;
DDCAPS2_VIDEOPORT                 = 000000004h;
DDCAPS2_AUTOFLIPOVERLAY           = 000000008h;
DDCAPS2_CANBOBINTERLEAVED         = 000000010h;
DDCAPS2_CANBOBNONINTERLEAVED      = 000000020h;
DDCAPS2_COLORCONTROLOVERLAY       = 000000040h;
DDCAPS2_COLORCONTROLPRIMARY       = 000000080h;
DDCAPS2_CANDROPZ16BIT             = 000000100h;
DDCAPS2_NONLOCALVIDMEM            = 000000200h;
DDCAPS2_NONLOCALVIDMEMCAPS        = 000000400h;
DDCAPS2_NOPAGELOCKREQUIRED        = 000000800h;
DDCAPS2_WIDESURFACES              = 000001000h;
DDCAPS2_CANFLIPODDEVEN            = 000002000h;
DDCAPS2_CANBOBHARDWARE            = 000004000h;
DDCAPS2_COPYFOURCC                = 000008000h;
DDCAPS2_PRIMARYGAMMA              = 000020000h;
DDCAPS2_CANRENDERWINDOWED         = 000080000h;
DDCAPS2_CANCALIBRATEGAMMA         = 000100000h;
DDCAPS2_FLIPINTERVAL              = 000200000h;
DDCAPS2_FLIPNOVSYNC               = 000400000h;

; *
; * DIRECTDRAW FX ALPHA CAPABILITY FLAGS
; *

DDFXALPHACAPS_BLTALPHAEDGEBLEND         = 00000001h;
DDFXALPHACAPS_BLTALPHAPIXELS            = 00000002h;
DDFXALPHACAPS_BLTALPHAPIXELSNEG         = 00000004h;
DDFXALPHACAPS_BLTALPHASURFACES          = 00000008h;
DDFXALPHACAPS_BLTALPHASURFACESNEG       = 00000010h;
DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND     = 00000020h;
DDFXALPHACAPS_OVERLAYALPHAPIXELS        = 00000040h;
DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG     = 00000080h;
DDFXALPHACAPS_OVERLAYALPHASURFACES      = 00000100h;
DDFXALPHACAPS_OVERLAYALPHASURFACESNEG   = 00000200h;

; *
; * DIRECTDRAW FX CAPABILITY FLAGS
; *

DDFXCAPS_BLTARITHSTRETCHY       = 00000020h;
DDFXCAPS_BLTARITHSTRETCHYN      = 00000010h;
DDFXCAPS_BLTMIRRORLEFTRIGHT     = 00000040h;
DDFXCAPS_BLTMIRRORUPDOWN        = 00000080h;
DDFXCAPS_BLTROTATION            = 00000100h;
DDFXCAPS_BLTROTATION90          = 00000200h;
DDFXCAPS_BLTSHRINKX             = 00000400h;
DDFXCAPS_BLTSHRINKXN            = 00000800h;
DDFXCAPS_BLTSHRINKY             = 00001000h;
DDFXCAPS_BLTSHRINKYN            = 00002000h;
DDFXCAPS_BLTSTRETCHX            = 00004000h;
DDFXCAPS_BLTSTRETCHXN           = 00008000h;
DDFXCAPS_BLTSTRETCHY            = 00010000h;
DDFXCAPS_BLTSTRETCHYN           = 00020000h;
DDFXCAPS_OVERLAYARITHSTRETCHY   = 00040000h;
DDFXCAPS_OVERLAYARITHSTRETCHYN  = 00000008h;
DDFXCAPS_OVERLAYSHRINKX         = 00080000h;
DDFXCAPS_OVERLAYSHRINKXN        = 00100000h;
DDFXCAPS_OVERLAYSHRINKY         = 00200000h;
DDFXCAPS_OVERLAYSHRINKYN        = 00400000h;
DDFXCAPS_OVERLAYSTRETCHX        = 00800000h;
DDFXCAPS_OVERLAYSTRETCHXN       = 01000000h;
DDFXCAPS_OVERLAYSTRETCHY        = 02000000h;
DDFXCAPS_OVERLAYSTRETCHYN       = 04000000h;
DDFXCAPS_OVERLAYMIRRORLEFTRIGHT = 08000000h;
DDFXCAPS_OVERLAYMIRRORUPDOWN    = 010000000h;
DDFXCAPS_BLTALPHA               = 00000001h;
DDFXCAPS_BLTTRANSFORM           = 00000002h;
DDFXCAPS_BLTFILTER              = DDFXCAPS_BLTARITHSTRETCHY;
DDFXCAPS_OVERLAYALPHA           = 000000004h;
DDFXCAPS_OVERLAYTRANSFORM       = 020000000h;
DDFXCAPS_OVERLAYFILTER          = DDFXCAPS_OVERLAYARITHSTRETCHY;

; *
; * DIRECTDRAW STEREO VIEW CAPABILITIES
; *

DDSVCAPS_ENIGMA                 = 00000001h;
DDSVCAPS_FLICKER                = 00000002h;
DDSVCAPS_REDBLUE                = 00000004h;
DDSVCAPS_SPLIT                  = 00000008h;

; *
; * DIRECTDRAWPALETTE CAPABILITIES
; *

DDPCAPS_4BIT                    = 00000001h;
DDPCAPS_8BITENTRIES             = 00000002h;
DDPCAPS_8BIT                    = 00000004h;
DDPCAPS_INITIALIZE              = 00000008h;
DDPCAPS_PRIMARYSURFACE          = 00000010h;
DDPCAPS_PRIMARYSURFACELEFT      = 00000020h;
DDPCAPS_ALLOW256                = 00000040h;
DDPCAPS_VSYNC                   = 00000080h;
DDPCAPS_1BIT                    = 00000100h;
DDPCAPS_2BIT                    = 00000200h;
DDPCAPS_ALPHA                   = 00000400h;


; *
; * DIRECTDRAWSURFACE SETPALETTE CONSTANTS
; *

DDSPD_IUNKNOWNPOINTER           = 00000001h;
DDSPD_VOLATILE                  = 00000002h;

; *
; * DIRECTDRAW BITDEPTH CONSTANTS
; *
; * NOTE:  These are only used to indicate supported bit depths.   These
; * are flags only, they are not to be used as an actual bit depth.   The
; * absolute numbers 1, 2, 4, 8, 16, 24 and 32 are used to indicate actual
; * bit depths in a surface or for changing the display mode.
; *

DDBD_1                  = 00004000h;
DDBD_2                  = 00002000h;
DDBD_4                  = 00001000h;
DDBD_8                  = 00000800h;
DDBD_16                 = 00000400h;
DDBD_24                 = 00000200h;
DDBD_32                 = 00000100h;

; *
; * DIRECTDRAWSURFACE SET/GET COLOR KEY FLAGS
; *

DDCKEY_COLORSPACE       = 00000001h;
DDCKEY_DESTBLT          = 00000002h;
DDCKEY_DESTOVERLAY      = 00000004h;
DDCKEY_SRCBLT           = 00000008h;
DDCKEY_SRCOVERLAY       = 00000010h;


; *
; * DIRECTDRAW COLOR KEY CAPABILITY FLAGS
; *

DDCKEYCAPS_DESTBLT                      = 00000001h;
DDCKEYCAPS_DESTBLTCLRSPACE              = 00000002h;
DDCKEYCAPS_DESTBLTCLRSPACEYUV           = 00000004h;
DDCKEYCAPS_DESTBLTYUV                   = 00000008h;
DDCKEYCAPS_DESTOVERLAY                  = 00000010h;
DDCKEYCAPS_DESTOVERLAYCLRSPACE          = 00000020h;
DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV       = 00000040h;
DDCKEYCAPS_DESTOVERLAYONEACTIVE         = 00000080h;
DDCKEYCAPS_DESTOVERLAYYUV               = 00000100h;
DDCKEYCAPS_SRCBLT                       = 00000200h;
DDCKEYCAPS_SRCBLTCLRSPACE               = 00000400h;
DDCKEYCAPS_SRCBLTCLRSPACEYUV            = 00000800h;
DDCKEYCAPS_SRCBLTYUV                    = 00001000h;
DDCKEYCAPS_SRCOVERLAY                   = 00002000h;
DDCKEYCAPS_SRCOVERLAYCLRSPACE           = 00004000h;
DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV        = 00008000h;
DDCKEYCAPS_SRCOVERLAYONEACTIVE          = 00010000h;
DDCKEYCAPS_SRCOVERLAYYUV                = 00020000h;
DDCKEYCAPS_NOCOSTOVERLAY                = 00040000h;


; *
; * DIRECTDRAW PIXELFORMAT FLAGS
; *

DDPF_ALPHAPIXELS                        = 00000001h;
DDPF_ALPHA                              = 00000002h;
DDPF_FOURCC                             = 00000004h;
DDPF_PALETTEINDEXED4                    = 00000008h;
DDPF_PALETTEINDEXEDTO8                  = 00000010h;
DDPF_PALETTEINDEXED8                    = 00000020h;
DDPF_RGB                                = 00000040h;
DDPF_COMPRESSED                         = 00000080h;
DDPF_RGBTOYUV                           = 00000100h;
DDPF_YUV                                = 00000200h;
DDPF_ZBUFFER                            = 00000400h;
DDPF_PALETTEINDEXED1                    = 00000800h;
DDPF_PALETTEINDEXED2                    = 00001000h;
DDPF_ZPIXELS                            = 00002000h;
DDPF_STENCILBUFFER                      = 00004000h;
DDPF_ALPHAPREMULT                       = 00008000h;
DDPF_LUMINANCE                          = 00020000h;
DDPF_BUMPLUMINANCE                      = 00040000h;
DDPF_BUMPDUDV                           = 00080000h;


; *
; * DIRECTDRAW ENUMSURFACES FLAGS
; *

DDENUMSURFACES_ALL                      = 00000001h;
DDENUMSURFACES_MATCH                    = 00000002h;
DDENUMSURFACES_NOMATCH                  = 00000004h;
DDENUMSURFACES_CANBECREATED             = 00000008h;
DDENUMSURFACES_DOESEXIST                = 00000010h;

; *
; * DIRECTDRAW SETDISPLAYMODE FLAGS
; *

DDSDM_STANDARDVGAMODE                   = 00000001h;

; *
; * DIRECTDRAW ENUMDISPLAYMODES FLAGS
; *

DDEDM_REFRESHRATES                      = 00000001h;
DDEDM_STANDARDVGAMODES                  = 00000002h;


; *
; * DIRECTDRAW SETCOOPERATIVELEVEL FLAGS
; *

DDSCL_FULLSCREEN                        = 00000001h;
DDSCL_ALLOWREBOOT                       = 00000002h;
DDSCL_NOWINDOWCHANGES                   = 00000004h;
DDSCL_NORMAL                            = 00000008h;
DDSCL_EXCLUSIVE                         = 00000010h;
DDSCL_ALLOWMODEX                        = 00000040h;
DDSCL_SETFOCUSWINDOW                    = 00000080h;
DDSCL_SETDEVICEWINDOW                   = 00000100h;
DDSCL_CREATEDEVICEWINDOW                = 00000200h;
DDSCL_MULTITHREADED                     = 00000400h;
DDSCL_FPUSETUP                          = 00000800h;

; *
; * DIRECTDRAW BLT FLAGS
; *

DDBLT_ALPHADEST                         = 00000001h;
DDBLT_ALPHADESTCONSTOVERRIDE            = 00000002h;
DDBLT_ALPHADESTNEG                      = 00000004h;
DDBLT_ALPHADESTSURFACEOVERRIDE          = 00000008h;
DDBLT_ALPHAEDGEBLEND                    = 00000010h;
DDBLT_ALPHASRC                          = 00000020h;
DDBLT_ALPHASRCCONSTOVERRIDE             = 00000040h;
DDBLT_ALPHASRCNEG                       = 00000080h;
DDBLT_ALPHASRCSURFACEOVERRIDE           = 00000100h;
DDBLT_ASYNC                             = 00000200h;
DDBLT_COLORFILL                         = 00000400h;
DDBLT_DDFX                              = 00000800h;
DDBLT_DDROPS                            = 00001000h;
DDBLT_KEYDEST                           = 00002000h;
DDBLT_KEYDESTOVERRIDE                   = 00004000h;
DDBLT_KEYSRC                            = 00008000h;
DDBLT_KEYSRCOVERRIDE                    = 00010000h;
DDBLT_ROP                               = 00020000h;
DDBLT_ROTATIONANGLE                     = 00040000h;
DDBLT_ZBUFFER                           = 00080000h;
DDBLT_ZBUFFERDESTCONSTOVERRIDE          = 00100000h;
DDBLT_ZBUFFERDESTOVERRIDE               = 00200000h;
DDBLT_ZBUFFERSRCCONSTOVERRIDE           = 00400000h;
DDBLT_ZBUFFERSRCOVERRIDE                = 00800000h;
DDBLT_WAIT                              = 01000000h;
DDBLT_DEPTHFILL                         = 02000000h;


; *
; * BLTFAST FLAGS
; *

DDBLTFAST_NOCOLORKEY                    = 00000000h;
DDBLTFAST_SRCCOLORKEY                   = 00000001h;
DDBLTFAST_DESTCOLORKEY                  = 00000002h;
DDBLTFAST_WAIT                          = 00000010h;


; *
; * FLIP FLAGS
; *

DDFLIP_WAIT                          = 00000001h;
DDFLIP_EVEN                          = 00000002h;
DDFLIP_ODD                           = 00000004h;
DDFLIP_NOVSYNC                       = 00000008h;
DDFLIP_INTERVAL2                     = 02000000h;
DDFLIP_INTERVAL3                     = 03000000h;
DDFLIP_INTERVAL4                     = 04000000h;

; *
; * DIRECTDRAW SURFACE OVERLAY FLAGS
; *

DDOVER_ALPHADEST                        = 00000001h;
DDOVER_ALPHADESTCONSTOVERRIDE           = 00000002h;
DDOVER_ALPHADESTNEG                     = 00000004h;
DDOVER_ALPHADESTSURFACEOVERRIDE         = 00000008h;
DDOVER_ALPHAEDGEBLEND                   = 00000010h;
DDOVER_ALPHASRC                         = 00000020h;
DDOVER_ALPHASRCCONSTOVERRIDE            = 00000040h;
DDOVER_ALPHASRCNEG                      = 00000080h;
DDOVER_ALPHASRCSURFACEOVERRIDE          = 00000100h;
DDOVER_HIDE                             = 00000200h;
DDOVER_KEYDEST                          = 00000400h;
DDOVER_KEYDESTOVERRIDE                  = 00000800h;
DDOVER_KEYSRC                           = 00001000h;
DDOVER_KEYSRCOVERRIDE                   = 00002000h;
DDOVER_SHOW                             = 00004000h;
DDOVER_ADDDIRTYRECT                     = 00008000h;
DDOVER_REFRESHDIRTYRECTS                = 00010000h;
DDOVER_REFRESHALL                       = 00020000h;
DDOVER_DDFX                             = 00080000h;
DDOVER_AUTOFLIP                         = 00100000h;
DDOVER_BOB                              = 00200000h;
DDOVER_OVERRIDEBOBWEAVE                 = 00400000h;
DDOVER_INTERLEAVED                      = 00800000h;
DDOVER_BOBHARDWARE                      = 01000000h;

; *
; * DIRECTDRAWSURFACE LOCK FLAGS
; *

DDLOCK_SURFACEMEMORYPTR                 = 00000000h;    // = default
DDLOCK_WAIT                             = 00000001h;
DDLOCK_EVENT                            = 00000002h;
DDLOCK_READONLY                         = 00000010h;
DDLOCK_WRITEONLY                        = 00000020h;
DDLOCK_NOSYSLOCK                        = 00000800h;


; *
; * DIRECTDRAWSURFACE PAGELOCK FLAGS
; *

; No flags defined at present


; *
; * DIRECTDRAWSURFACE PAGEUNLOCK FLAGS
; *

; No flags defined at present



; *
; * DIRECTDRAWSURFACE BLT FX FLAGS
; *

DDBLTFX_ARITHSTRETCHY                   = 00000001h;
DDBLTFX_MIRRORLEFTRIGHT                 = 00000002h;
DDBLTFX_MIRRORUPDOWN                    = 00000004h;
DDBLTFX_NOTEARING                       = 00000008h;
DDBLTFX_ROTATE180                       = 00000010h;
DDBLTFX_ROTATE270                       = 00000020h;
DDBLTFX_ROTATE90                        = 00000040h;
DDBLTFX_ZBUFFERRANGE                    = 00000080h;
DDBLTFX_ZBUFFERBASEDEST                 = 00000100h;

; *
; * DIRECTDRAWSURFACE OVERLAY FX FLAGS
; *

DDOVERFX_ARITHSTRETCHY                  = 00000001h;
DDOVERFX_MIRRORLEFTRIGHT                = 00000002h;
DDOVERFX_MIRRORUPDOWN                   = 00000004h;

; *
; * Flags for dwDDFX member of DDSPRITEFX structure
; *

DDSPRITEFX_AFFINETRANSFORM              = 00000001h;
DDSPRITEFX_RGBASCALING                  = 00000002h;
DDSPRITEFX_DEGRADERGBASCALING           = 00000004h;
DDSPRITEFX_BILINEARFILTER               = 00000008h;
DDSPRITEFX_BLURFILTER                   = 00000010h;
DDSPRITEFX_FLATFILTER                   = 00000020h;
DDSPRITEFX_DEGRADEFILTER                = 00000040h;

; *
; * DIRECTDRAW WAITFORVERTICALBLANK FLAGS
; *

DDWAITVB_BLOCKBEGIN                     = 00000001h;
DDWAITVB_BLOCKBEGINEVENT                = 00000002h;
DDWAITVB_BLOCKEND                       = 00000004h;

; *
; * DIRECTDRAW GETFLIPSTATUS FLAGS
; *

DDGFS_CANFLIP                   = 00000001h;
DDGFS_ISFLIPDONE                = 00000002h;

; *
; * DIRECTDRAW GETBLTSTATUS FLAGS
; *

DDGBS_CANBLT                    = 00000001h;
DDGBS_ISBLTDONE                 = 00000002h;


; *
; * DIRECTDRAW ENUMOVERLAYZORDER FLAGS
; *

DDENUMOVERLAYZ_BACKTOFRONT      = 00000000h;
DDENUMOVERLAYZ_FRONTTOBACK      = 00000001h;

; *
; * DIRECTDRAW UPDATEOVERLAYZORDER FLAGS
; *

DDOVERZ_SENDTOFRONT             = 00000000h;
DDOVERZ_SENDTOBACK              = 00000001h;
DDOVERZ_MOVEFORWARD             = 00000002h;
DDOVERZ_MOVEBACKWARD            = 00000003h;
DDOVERZ_INSERTINFRONTOF         = 00000004h;
DDOVERZ_INSERTINBACKOF          = 00000005h;

; *
; * DIRECTDRAW SETGAMMARAMP FLAGS
; *

DDSGR_CALIBRATE                 = 00000001h;

; *
; *
; * DIRECTDRAW RETURN CODES
; *

DD_OK                                   = 0;
DD_FALSE                                = S_FALSE;

; *
; * DIRECTDRAW ENUMCALLBACK RETURN VALUES
; *

DDENUMRET_CANCEL                        = 0;
DDENUMRET_OK                            = 1;

; *
; * DIRECTDRAW ERRORS
; *

MAKE_DDHRESULT = 088760000h;
DDERR_ALREADYINITIALIZED            = MAKE_DDHRESULT + 5;
DDERR_CANNOTATTACHSURFACE           = MAKE_DDHRESULT + 10;
DDERR_CANNOTDETACHSURFACE           = MAKE_DDHRESULT + 20;
DDERR_CURRENTLYNOTAVAIL             = MAKE_DDHRESULT + 40;
DDERR_EXCEPTION                     = MAKE_DDHRESULT + 55;
DDERR_GENERIC                       = E_FAIL;
DDERR_HEIGHTALIGN                   = MAKE_DDHRESULT + 90;
DDERR_INCOMPATIBLEPRIMARY           = MAKE_DDHRESULT + 95;
DDERR_INVALIDCAPS                   = MAKE_DDHRESULT + 100;
DDERR_INVALIDCLIPLIST               = MAKE_DDHRESULT + 110;
DDERR_INVALIDMODE                   = MAKE_DDHRESULT + 120;
DDERR_INVALIDOBJECT                 = MAKE_DDHRESULT + 130;
DDERR_INVALIDPARAMS                 = E_INVALIDARG;
DDERR_INVALIDPIXELFORMAT            = MAKE_DDHRESULT + 145;
DDERR_INVALIDRECT                   = MAKE_DDHRESULT + 150;
DDERR_LOCKEDSURFACES                = MAKE_DDHRESULT + 160;
DDERR_NO3D                          = MAKE_DDHRESULT + 170;
DDERR_NOALPHAHW                     = MAKE_DDHRESULT + 180;
DDERR_NOCLIPLIST                    = MAKE_DDHRESULT + 205;
DDERR_NOCOLORCONVHW                 = MAKE_DDHRESULT + 210;
DDERR_NOCOOPERATIVELEVELSET         = MAKE_DDHRESULT + 212;
DDERR_NOCOLORKEY                    = MAKE_DDHRESULT + 215;
DDERR_NOCOLORKEYHW                  = MAKE_DDHRESULT + 220;
DDERR_NODIRECTDRAWSUPPORT           = MAKE_DDHRESULT + 222;
DDERR_NOEXCLUSIVEMODE               = MAKE_DDHRESULT + 225;
DDERR_NOFLIPHW                      = MAKE_DDHRESULT + 230;
DDERR_NOGDI                         = MAKE_DDHRESULT + 240;
DDERR_NOMIRRORHW                    = MAKE_DDHRESULT + 250;
DDERR_NOTFOUND                      = MAKE_DDHRESULT + 255;
DDERR_NOOVERLAYHW                   = MAKE_DDHRESULT + 260;
DDERR_OVERLAPPINGRECTS              = MAKE_DDHRESULT + 270;
DDERR_NORASTEROPHW                  = MAKE_DDHRESULT + 280;
DDERR_NOROTATIONHW                  = MAKE_DDHRESULT + 290;
DDERR_NOSTRETCHHW                   = MAKE_DDHRESULT + 310;
DDERR_NOT4BITCOLOR                  = MAKE_DDHRESULT + 316;
DDERR_NOT4BITCOLORINDEX             = MAKE_DDHRESULT + 317;
DDERR_NOT8BITCOLOR                  = MAKE_DDHRESULT + 320;
DDERR_NOTEXTUREHW                   = MAKE_DDHRESULT + 330;
DDERR_NOVSYNCHW                     = MAKE_DDHRESULT + 335;
DDERR_NOZBUFFERHW                   = MAKE_DDHRESULT + 340;
DDERR_NOZOVERLAYHW                  = MAKE_DDHRESULT + 350;
DDERR_OUTOFCAPS                     = MAKE_DDHRESULT + 360;
DDERR_OUTOFMEMORY                   = E_OUTOFMEMORY;
DDERR_OUTOFVIDEOMEMORY              = MAKE_DDHRESULT + 380;
DDERR_OVERLAYCANTCLIP               = MAKE_DDHRESULT + 382;
DDERR_OVERLAYCOLORKEYONLYONEACTIVE  = MAKE_DDHRESULT + 384;
DDERR_PALETTEBUSY                   = MAKE_DDHRESULT + 387;
DDERR_COLORKEYNOTSET                = MAKE_DDHRESULT + 400;
DDERR_SURFACEALREADYATTACHED        = MAKE_DDHRESULT + 410;
DDERR_SURFACEALREADYDEPENDENT       = MAKE_DDHRESULT + 420;
DDERR_SURFACEBUSY                   = MAKE_DDHRESULT + 430;
DDERR_CANTLOCKSURFACE               = MAKE_DDHRESULT + 435;
DDERR_SURFACEISOBSCURED             = MAKE_DDHRESULT + 440;
DDERR_SURFACELOST                   = MAKE_DDHRESULT + 450;
DDERR_SURFACENOTATTACHED            = MAKE_DDHRESULT + 460;
DDERR_TOOBIGHEIGHT                  = MAKE_DDHRESULT + 470;
DDERR_TOOBIGSIZE                    = MAKE_DDHRESULT + 480;
DDERR_TOOBIGWIDTH                   = MAKE_DDHRESULT + 490;
DDERR_UNSUPPORTED                   = E_NOTIMPL;
DDERR_UNSUPPORTEDFORMAT             = MAKE_DDHRESULT + 510;
DDERR_UNSUPPORTEDMASK               = MAKE_DDHRESULT + 520;
DDERR_INVALIDSTREAM                 = MAKE_DDHRESULT + 521;
DDERR_VERTICALBLANKINPROGRESS       = MAKE_DDHRESULT + 537;
DDERR_WASSTILLDRAWING               = MAKE_DDHRESULT + 540;
DDERR_XALIGN                        = MAKE_DDHRESULT + 560;
DDERR_INVALIDDIRECTDRAWGUID         = MAKE_DDHRESULT + 561;
DDERR_DIRECTDRAWALREADYCREATED      = MAKE_DDHRESULT + 562;
DDERR_NODIRECTDRAWHW                = MAKE_DDHRESULT + 563;
DDERR_PRIMARYSURFACEALREADYEXISTS   = MAKE_DDHRESULT + 564;
DDERR_NOEMULATION                   = MAKE_DDHRESULT + 565;
DDERR_REGIONTOOSMALL                = MAKE_DDHRESULT + 566;
DDERR_CLIPPERISUSINGHWND            = MAKE_DDHRESULT + 567;
DDERR_NOCLIPPERATTACHED             = MAKE_DDHRESULT + 568;
DDERR_NOHWND                        = MAKE_DDHRESULT + 569;
DDERR_HWNDSUBCLASSED                = MAKE_DDHRESULT + 570;
DDERR_HWNDALREADYSET                = MAKE_DDHRESULT + 571;
DDERR_NOPALETTEATTACHED             = MAKE_DDHRESULT + 572;
DDERR_NOPALETTEHW                   = MAKE_DDHRESULT + 573;
DDERR_BLTFASTCANTCLIP               = MAKE_DDHRESULT + 574;
DDERR_NOBLTHW                       = MAKE_DDHRESULT + 575;
DDERR_NODDROPSHW                    = MAKE_DDHRESULT + 576;
DDERR_OVERLAYNOTVISIBLE             = MAKE_DDHRESULT + 577;
DDERR_NOOVERLAYDEST                 = MAKE_DDHRESULT + 578;
DDERR_INVALIDPOSITION               = MAKE_DDHRESULT + 579;
DDERR_NOTAOVERLAYSURFACE            = MAKE_DDHRESULT + 580;
DDERR_EXCLUSIVEMODEALREADYSET       = MAKE_DDHRESULT + 581;
DDERR_NOTFLIPPABLE                  = MAKE_DDHRESULT + 582;
DDERR_CANTDUPLICATE                 = MAKE_DDHRESULT + 583;
DDERR_NOTLOCKED                     = MAKE_DDHRESULT + 584;
DDERR_CANTCREATEDC                  = MAKE_DDHRESULT + 585;
DDERR_NODC                          = MAKE_DDHRESULT + 586;
DDERR_WRONGMODE                     = MAKE_DDHRESULT + 587;
DDERR_IMPLICITLYCREATED             = MAKE_DDHRESULT + 588;
DDERR_NOTPALETTIZED                 = MAKE_DDHRESULT + 589;
DDERR_UNSUPPORTEDMODE               = MAKE_DDHRESULT + 590;
DDERR_NOMIPMAPHW                    = MAKE_DDHRESULT + 591;
DDERR_INVALIDSURFACETYPE            = MAKE_DDHRESULT + 592;
DDERR_NOOPTIMIZEHW                  = MAKE_DDHRESULT + 600;
DDERR_NOTLOADED                     = MAKE_DDHRESULT + 601;
DDERR_NOFOCUSWINDOW                 = MAKE_DDHRESULT + 602;
DDERR_DCALREADYCREATED              = MAKE_DDHRESULT + 620;
DDERR_NONONLOCALVIDMEM              = MAKE_DDHRESULT + 630;
DDERR_CANTPAGELOCK                  = MAKE_DDHRESULT + 640;
DDERR_CANTPAGEUNLOCK                = MAKE_DDHRESULT + 660;
DDERR_NOTPAGELOCKED                 = MAKE_DDHRESULT + 680;
DDERR_MOREDATA                      = MAKE_DDHRESULT + 690;
DDERR_EXPIRED                       = MAKE_DDHRESULT + 691;
DDERR_VIDEONOTACTIVE                = MAKE_DDHRESULT + 695;
DDERR_DEVICEDOESNTOWNSURFACE        = MAKE_DDHRESULT + 699;
DDERR_NOTINITIALIZED                = CO_E_NOTINITIALIZED;


; * Flags for DirectDrawEnumerateEx

DDENUM_ATTACHEDSECONDARYDEVICES     = 00000001h;
DDENUM_DETACHEDSECONDARYDEVICES     = 00000002h;
DDENUM_NONDISPLAYDEVICES            = 00000004h;

REGSTR_KEY_DDHW_DESCRIPTION textequ <'Description'>
REGSTR_KEY_DDHW_DRIVERNAME  textequ <'DriverName'>
REGSTR_PATH_DDHW            textequ <'Hardware\DirectDrawDrivers'>

DDCREATE_HARDWAREONLY       = 00000001h;
DDCREATE_EMULATIONONLY      = 00000002h;


;end of file
