; td3dcaps.inc  (c) Minde  06/08/99 montana@is.lt
; Content:  TASM Direct3DRM include file ver. 1.2 
; converted from d3drmdef.h, DX ver. 6.1
;
;  Feel free to use or distribute the package, part or whole, for any
; non-commercial use preferably crediting me.
;  Also feel free to contact me at the above address if you experience any
; problems or notice any omissions.

D3DRMVECTOR4D struct   
d3drmvector4d_x           D3DVALUE ? ;
d3drmvector4d_y           D3DVALUE ? ;
d3drmvector4d_z           D3DVALUE ? ;
d3drmvector4d_w           D3DVALUE ? ;
D3DRMVECTOR4D ends

D3DRMMATRIX4D   D3DVALUE 16 dup (?)

D3DRMQUATERNION struct
d3drmquaternion_s           D3DVALUE  ? ;
d3drmquaternion_v           D3DVECTOR ? ;
D3DRMQUATERNION ends

D3DRMRAY struct
d3drmray_dvDir       D3DVECTOR ? ;
d3drmray_dvPos       D3DVECTOR ? ;
D3DRMRAY ends

D3DRMBOX struct
d3drmbox_min         D3DVECTOR ? ;
d3drmbox_max         D3DVECTOR ? ;
D3DRMBOX ends


D3DRMLIGHTTYPE enum D3DRMLIGHT_AMBIENT, D3DRMLIGHT_POINT, D3DRMLIGHT_SPOT, \
    D3DRMLIGHT_DIRECTIONAL, D3DRMLIGHT_PARALLELPOINT

D3DRMSHADEMODE enum D3DRMSHADE_FLAT = 0, D3DRMSHADE_GOURAUD = 1, \
    D3DRMSHADE_PHONG = 2, D3DRMSHADE_MASK = 7, D3DRMSHADE_MAX = 8

D3DRMLIGHTMODE enum D3DRMLIGHT_OFF = 0 * D3DRMSHADE_MAX, \
    D3DRMLIGHT_ON = 1 * D3DRMSHADE_MAX, \
    D3DRMLIGHT_MASK = 7 * D3DRMSHADE_MAX, \
    D3DRMLIGHT_MAX = 8 * D3DRMSHADE_MAX

D3DRMFILLMODE enum D3DRMFILL_POINTS = 0 * D3DRMLIGHT_MAX, \
    D3DRMFILL_WIREFRAME = 1 * D3DRMLIGHT_MAX, \
    D3DRMFILL_SOLID = 2 * D3DRMLIGHT_MAX, \
    D3DRMFILL_MASK = 7 * D3DRMLIGHT_MAX, \
    D3DRMFILL_MAX = 8 * D3DRMLIGHT_MAX

D3DRMRENDER_WIREFRAME   = D3DRMSHADE_FLAT + D3DRMLIGHT_OFF + D3DRMFILL_WIREFRAME
D3DRMRENDER_UNLITFLAT   = D3DRMSHADE_FLAT + D3DRMLIGHT_OFF + D3DRMFILL_SOLID
D3DRMRENDER_FLAT        = D3DRMSHADE_FLAT + D3DRMLIGHT_ON + D3DRMFILL_SOLID
D3DRMRENDER_GOURAUD     = D3DRMSHADE_GOURAUD + D3DRMLIGHT_ON + D3DRMFILL_SOLID
D3DRMRENDER_PHONG       = D3DRMSHADE_PHONG + D3DRMLIGHT_ON + D3DRMFILL_SOLID

D3DRMRENDERMODE_BLENDEDTRANSPARENCY   =  1;
D3DRMRENDERMODE_SORTEDTRANSPARENCY    =  2;
D3DRMRENDERMODE_LIGHTINMODELSPACE     =  8;
D3DRMRENDERMODE_VIEWDEPENDENTSPECULAR = 16;

D3DRMTEXTUREQUALITY enum D3DRMTEXTURE_NEAREST, \ ; choose nearest texel
    D3DRMTEXTURE_LINEAR,        \ ; interpolate 4 texels
    D3DRMTEXTURE_MIPNEAREST,    \ ; nearest texel in nearest mipmap
    D3DRMTEXTURE_MIPLINEAR,     \ ; interpolate 2 texels from 2 mipmaps
    D3DRMTEXTURE_LINEARMIPNEAREST,  \ ; interpolate 4 texels in nearest mipmap
    D3DRMTEXTURE_LINEARMIPLINEAR      ; interpolate 8 texels from 2 mipmaps

; Texture flags
D3DRMTEXTURE_FORCERESIDENT          = 000000001h ; texture should be kept in video memory
D3DRMTEXTURE_STATIC                 = 000000002h ; texture will not change
D3DRMTEXTURE_DOWNSAMPLEPOINT        = 000000004h ; point filtering should be used when downsampling
D3DRMTEXTURE_DOWNSAMPLEBILINEAR     = 000000008h ; bilinear filtering should be used when downsampling
D3DRMTEXTURE_DOWNSAMPLEREDUCEDEPTH  = 000000010h ; reduce bit depth when downsampling
D3DRMTEXTURE_DOWNSAMPLENONE         = 000000020h ; texture should never be downsampled
D3DRMTEXTURE_CHANGEDPIXELS          = 000000040h ; pixels have changed
D3DRMTEXTURE_CHANGEDPALETTE         = 000000080h ; palette has changed
D3DRMTEXTURE_INVALIDATEONLY         = 000000100h ; dirty regions are invalid

; Shadow flags
D3DRMSHADOW_TRUEALPHA               = 000000001h ; shadow should render without artifacts when true alpha is on

D3DRMCOMBINETYPE enum D3DRMCOMBINE_REPLACE, D3DRMCOMBINE_BEFORE, \
    D3DRMCOMBINE_AFTER

D3DRMCOLORMODEL typedef D3DCOLORMODEL

D3DRMPALETTEFLAGS enum D3DRMPALETTE_FREE,\ ; renderer may use this entry freely
    D3DRMPALETTE_READONLY,       \ ; fixed but may be used by renderer
    D3DRMPALETTE_RESERVED          ; may not be used by renderer


D3DRMPALETTEENTRY struct
d3drmpaletteentry_red                 db ? ; 0 .. 255
d3drmpaletteentry_green               db ? ; 0 .. 255
d3drmpaletteentry_blue                db ? ; 0 .. 255
d3drmpaletteentry_flags               db ? ; one of D3DRMPALETTEFLAGS
D3DRMPALETTEENTRY ends

D3DRMIMAGE struct
d3drmimage_width           dw ? 
d3drmimage_height          dw ? ; width and height in pixels
d3drmimage_aspectx         dw ? 
d3drmimage_aspecty         dw ? ; aspect ratio for non-square pixels
d3drmimage_depth           dw ? ; bits per pixel
d3drmimage_rgb             dw ? ; if false, pixels are indices into a palette otherwise, pixels encode RGB values.
d3drmimage_bytes_per_line  dw ? ; number of bytes of memory for a scanline. This must be a multiple of 4.
d3drmimage_buffer1         dd ? ; memory to render into (first buffer).
d3drmimage_buffer2         dd ? ; second rendering buffer for double buffering, set to NULL for single buffering.
d3drmimage_red_mask        dd ? ;
d3drmimage_green_mask      dd ? ;
d3drmimage_blue_mask       dd ? ;
d3drmimage_alpha_mask      dd ? ; if rgb is true, these are masks for the red, green and blue parts of a pixel.  Otherwise, these are masks for the significant bits of the red, green and blue elements in the palette.  For instance, most SVGA displays use 64 intensities of red, green and blue, so the masks should all be set to 0xfc.
d3drmimage_palette_size    dw ? ; number of entries in palette
d3drmimage_palette         dd ? ;ptr D3DRMPALETTEENTRY ; description of the palette (only if rgb is false).  Must be (1<<depth) elements.
D3DRMIMAGE ends

D3DRMWRAPTYPE enum D3DRMWRAP_FLAT, D3DRMWRAP_CYLINDER, \
    D3DRMWRAP_SPHERE, D3DRMWRAP_CHROME, D3DRMWRAP_SHEET, D3DRMWRAP_BOX

D3DRMWIREFRAME_CULL           =  1 ; cull backfaces
D3DRMWIREFRAME_HIDDENLINE     =  2 ; lines are obscured by closer objects

D3DRMPROJECTIONTYPE enum D3DRMPROJECT_PERSPECTIVE, D3DRMPROJECT_ORTHOGRAPHIC, \
    D3DRMPROJECT_RIGHTHANDPERSPECTIVE, \ ; Only valid pre-DX6
    D3DRMPROJECT_RIGHTHANDORTHOGRAPHIC   ; Only valid pre-DX6

D3DRMOPTIONS_LEFTHANDED  = 00000001 ; Default
D3DRMOPTIONS_RIGHTHANDED = 00000002 ;

D3DRMXOFFORMAT enum D3DRMXOF_BINARY, D3DRMXOF_COMPRESSED, D3DRMXOF_TEXT

D3DRMSAVEOPTIONS typedef DWORD
D3DRMXOFSAVE_NORMALS            = 1
D3DRMXOFSAVE_TEXTURECOORDINATES = 2
D3DRMXOFSAVE_MATERIALS          = 4
D3DRMXOFSAVE_TEXTURENAMES       = 8
D3DRMXOFSAVE_ALL                = 15
D3DRMXOFSAVE_TEMPLATES          = 16
D3DRMXOFSAVE_TEXTURETOPOLOGY    = 32

D3DRMCOLORSOURCE enum D3DRMCOLOR_FROMFACE, D3DRMCOLOR_FROMVERTEX

D3DRMFRAMECONSTRAINT enum D3DRMCONSTRAIN_Z, \ ; use only X and Y rotations
    D3DRMCONSTRAIN_Y, \ ; use only X and Z rotations
    D3DRMCONSTRAIN_X    ; use only Y and Z rotations

D3DRMMATERIALMODE enum D3DRMMATERIAL_FROMMESH,  D3DRMMATERIAL_FROMPARENT, \
    D3DRMMATERIAL_FROMFRAME

D3DRMFOGMODE enum D3DRMFOG_LINEAR, \ ; linear between start and end
    D3DRMFOG_EXPONENTIAL,      \ ; density * exp(-distance)
    D3DRMFOG_EXPONENTIALSQUARED  ; density * exp(-distance*distance)

D3DRMZBUFFERMODE enum D3DRMZBUFFER_FROMPARENT, \ ; default
    D3DRMZBUFFER_ENABLE,    \ ; enable zbuffering
    D3DRMZBUFFER_DISABLE      ; disable zbuffering

D3DRMSORTMODE enum D3DRMSORT_FROMPARENT, \ ; default
    D3DRMSORT_NONE,     \ ; don't sort child frames
    D3DRMSORT_FRONTTOBACK,  \ ; sort child frames front-to-back
    D3DRMSORT_BACKTOFRONT     ; sort child frames back-to-front

D3DRMMATERIALOVERRIDE struct
d3drmmaterialoverride_dwSize          DD ? ; Size of this structure *)
d3drmmaterialoverride_dwFlags         DD ? ; Indicate which fields are valid *)
d3drmmaterialoverride_dcDiffuse       D3DCOLORVALUE ? ; RGBA
d3drmmaterialoverride_dcAmbient       D3DCOLORVALUE ? ; RGBA
d3drmmaterialoverride_dcEmissive      D3DCOLORVALUE ? ; RGBA
d3drmmaterialoverride_dcSpecular      D3DCOLORVALUE ? ; RGBA
d3drmmaterialoverride_dvPower         D3DVALUE ? ;
d3drmmaterialoverride_lpD3DRMTex      DD ? ;
D3DRMMATERIALOVERRIDE ends


D3DRMMATERIALOVERRIDE_DIFFUSE_ALPHAONLY     = 000000001h;
D3DRMMATERIALOVERRIDE_DIFFUSE_RGBONLY       = 000000002h;
D3DRMMATERIALOVERRIDE_DIFFUSE               = 000000003h;
D3DRMMATERIALOVERRIDE_AMBIENT               = 000000004h;
D3DRMMATERIALOVERRIDE_EMISSIVE              = 000000008h;
D3DRMMATERIALOVERRIDE_SPECULAR              = 000000010h;
D3DRMMATERIALOVERRIDE_POWER                 = 000000020h;
D3DRMMATERIALOVERRIDE_TEXTURE               = 000000040h;
D3DRMMATERIALOVERRIDE_DIFFUSE_ALPHAMULTIPLY = 000000080h;
D3DRMMATERIALOVERRIDE_ALL                   = 0000000FFh;

D3DRMFPTF_ALPHA                             = 000000001h;
D3DRMFPTF_NOALPHA                           = 000000002h;
D3DRMFPTF_PALETTIZED                        = 000000004h;
D3DRMFPTF_NOTPALETTIZED                     = 000000008h;

D3DRMSTATECHANGE_UPDATEONLY                 = 000000001h;
D3DRMSTATECHANGE_VOLATILE                   = 000000002h;
D3DRMSTATECHANGE_NONVOLATILE                = 000000004h;
D3DRMSTATECHANGE_RENDER                     = 000000020h;
D3DRMSTATECHANGE_LIGHT                      = 000000040h;

D3DRMDEVICE_NOZBUFFER           = 00000001h;

D3DRMCLIENTDATA_NONE            = 00000001h;
D3DRMCLIENTDATA_LOCALFREE       = 00000002h;
D3DRMCLIENTDATA_IUNKNOWN        = 00000004h;

D3DRMCALLBACK_PREORDER      = 0;
D3DRMCALLBACK_POSTORDER     = 1;

D3DRMRAYPICK_ONLYBOUNDINGBOXES          = 001h;
D3DRMRAYPICK_IGNOREFURTHERPRIMITIVES    = 002h;
D3DRMRAYPICK_INTERPOLATEUV              = 004h;
D3DRMRAYPICK_INTERPOLATECOLOR           = 008h;
D3DRMRAYPICK_INTERPOLATENORMAL          = 010h;

D3DRMADDFACES_VERTICESONLY             = 1;

D3DRMGENERATENORMALS_PRECOMPACT         = 1;
D3DRMGENERATENORMALS_USECREASEANGLE     = 2;

D3DRMMESHBUILDER_DIRECTPARENT          = 1;
D3DRMMESHBUILDER_ROOTMESH              = 2;

D3DRMMESHBUILDER_RENDERENABLE   = 00000001h;
D3DRMMESHBUILDER_PICKENABLE     = 00000002h;

D3DRMMESHBUILDERAGE_GEOMETRY    = 00000001h;
D3DRMMESHBUILDERAGE_MATERIALS   = 00000002h;
D3DRMMESHBUILDERAGE_TEXTURES    = 00000004h;

D3DRMFVF_TYPE                   = 00000001h;
D3DRMFVF_NORMAL                 = 00000002h;
D3DRMFVF_COLOR                  = 00000004h;
D3DRMFVF_TEXTURECOORDS          = 00000008h;
D3DRMVERTEX_STRIP               = 00000001h;
D3DRMVERTEX_FAN                 = 00000002h;
D3DRMVERTEX_LIST                = 00000004h;

D3DRMCLEAR_TARGET               = 00000001h;
D3DRMCLEAR_ZBUFFER              = 00000002h;
D3DRMCLEAR_DIRTYRECTS           = 00000004h;
D3DRMCLEAR_ALL                  = (D3DRMCLEAR_TARGET or D3DRMCLEAR_ZBUFFER or \
    D3DRMCLEAR_DIRTYRECTS)

D3DRMFOGMETHOD_VERTEX          = 00000001h;
D3DRMFOGMETHOD_TABLE           = 00000002h;
D3DRMFOGMETHOD_ANY             = 00000004h;

D3DRMFRAME_RENDERENABLE        = 00000001h;
D3DRMFRAME_PICKENABLE          = 00000002h;



D3DRMANIMATIONOPTIONS typedef DWORD
D3DRMANIMATION_OPEN             = 001h
D3DRMANIMATION_CLOSED           = 002h
D3DRMANIMATION_LINEARPOSITION   = 004h
D3DRMANIMATION_SPLINEPOSITION   = 008h
D3DRMANIMATION_SCALEANDROTATION = 000000010h
D3DRMANIMATION_POSITION         = 000000020h

D3DRMINTERPOLATIONOPTIONS typedef DWORD
D3DRMINTERPOLATION_OPEN         = 001h;
D3DRMINTERPOLATION_CLOSED       = 002h;
D3DRMINTERPOLATION_NEAREST      = 0100h;
D3DRMINTERPOLATION_LINEAR       = 004h;
D3DRMINTERPOLATION_SPLINE       = 008h;
D3DRMINTERPOLATION_VERTEXCOLOR  = 040h;
D3DRMINTERPOLATION_SLERPNORMALS = 080h;

D3DRMLOADOPTIONS typedef DWORD
D3DRMLOAD_FROMFILE              = 000h
D3DRMLOAD_FROMRESOURCE          = 001h
D3DRMLOAD_FROMMEMORY            = 002h
D3DRMLOAD_FROMSTREAM            = 004h
D3DRMLOAD_BYNAME                = 010h
D3DRMLOAD_BYPOSITION            = 020h
D3DRMLOAD_BYGUID                = 040h
D3DRMLOAD_FIRST                 = 080h
D3DRMLOAD_INSTANCEBYREFERENCE   = 0100h
D3DRMLOAD_INSTANCEBYCOPYING     = 0200h
D3DRMLOAD_ASYNCHRONOUS          = 0400h

D3DRMLOADRESOURCE struct
d3drmloadresource_hModule         dd ? ;
d3drmloadresource_lpName          dd ? ;
d3drmloadresource_lpType          dd ? ;
D3DRMLOADRESOURCE ends

D3DRMLOADMEMORY struct
d3drmloadmemory_lpMemory        dd ? ;
d3drmloadmemory_dSize           dd ? ;
D3DRMLOADMEMORY ends

D3DRMPMESHSTATUS_VALID              = 001h;
D3DRMPMESHSTATUS_INTERRUPTED        = 002h;
D3DRMPMESHSTATUS_BASEMESHCOMPLETE   = 004h;
D3DRMPMESHSTATUS_COMPLETE           = 008h;
D3DRMPMESHSTATUS_RENDERABLE         = 010h;

D3DRMPMESHEVENT_BASEMESH            = 001h;
D3DRMPMESHEVENT_COMPLETE            = 002h;

D3DRMPMESHLOADSTATUS struct
d3drmpmeshloadstatus_dwSize              DD ? ; Size of this structure
d3drmpmeshloadstatus_dwPMeshSize         DD ? ; Total Size (bytes)
d3drmpmeshloadstatus_dwBaseMeshSize      DD ? ; Total Size of the Base Mesh
d3drmpmeshloadstatus_dwBytesLoaded       DD ? ; Total bytes loaded
d3drmpmeshloadstatus_dwVerticesLoaded    DD ? ; Number of vertices loaded
d3drmpmeshloadstatus_dwFacesLoaded       DD ? ; Number of faces loaded
d3drmpmeshloadstatus_dwLoadResult        DD ? ; Result of the load operation
d3drmpmeshloadstatus_dwFlags             DD ? ;
D3DRMPMESHLOADSTATUS ends

D3DRMUSERVISUALREASON enum D3DRMUSERVISUAL_CANSEE, D3DRMUSERVISUAL_RENDER

D3DRMANIMATIONKEY struct
d3drmanimationkey_dwSize          DD ?
d3drmanimationkey_dwKeyType       DD ?
d3drmanimationkey_dvTime          D3DVALUE ?
d3drmanimationkey_dwID            DD ?
    union
d3drmanimationkey_dqRotateKey     D3DRMQUATERNION ?
d3drmanimationkey_dvScaleKey      D3DVECTOR ?
d3drmanimationkey_dvPositionKey   D3DVECTOR ? 
    ends
D3DRMANIMATIONKEY ends


D3DRMANIMATION_ROTATEKEY        = 01h;
D3DRMANIMATION_SCALEKEY         = 02h;
D3DRMANIMATION_POSITIONKEY      = 03h;

D3DRMMAPPING        typedef DWORD
D3DRMMAPPINGFLAG    typedef DWORD
D3DRMMAP_WRAPU      D3DRMMAPPINGFLAG 1
D3DRMMAP_WRAPV      D3DRMMAPPINGFLAG 2
D3DRMMAP_PERSPCORRECT   D3DRMMAPPINGFLAG 4


D3DRMVERTEX struct
d3drmvertex_position    D3DVECTOR ? ;
d3drmvertex_normal      D3DVECTOR ? ;
d3drmvertex_tu          D3DVALUE  ? ;
d3drmvertex_tv          D3DVALUE  ? ;
d3drmvertex_color       D3DCOLOR  ? ;
D3DRMVERTEX ends


D3DRMGROUPINDEX typedef DWORD ; group indexes begin a 0
D3DRMGROUP_ALLGROUPS    D3DRMGROUPINDEX -1

; Create a color from three components in the range 0-1 inclusive.
D3DRMCreateColorRGB     PROCDESC STDCALL :D3DVALUE, :D3DVALUE, :D3DVALUE
D3DRMCreateColorRGBA    PROCDESC STDCALL :D3DVALUE, :D3DVALUE, :D3DVALUE, :D3DVALUE

; Get the red component of a color.
D3DRMColorGetRed    PROCDESC STDCALL :D3DCOLOR

; Get the green component of a color.
D3DRMColorGetGreen  PROCDESC STDCALL :D3DCOLOR

; Get the blue component of a color.
D3DRMColorGetBlue   PROCDESC STDCALL :D3DCOLOR

; Get the alpha component of a color.
D3DRMColorGetAlpha  PROCDESC STDCALL :D3DCOLOR

; Add two vectors.  Returns its first argument.
D3DRMVectorAdd      PROCDESC STDCALL :DWORD, :DWORD, :DWORD

; Subtract two vectors.  Returns its first argument.
D3DRMVectorSubtract PROCDESC STDCALL :DWORD, :DWORD, :DWORD

; Reflect a ray about a given normal.  Returns its first argument.
D3DRMVectorReflect  PROCDESC STDCALL :DWORD, :DWORD, :DWORD

; Calculate the vector cross product.  Returns its first argument.
D3DRMVectorCrossProduct PROCDESC STDCALL :DWORD, :DWORD, :DWORD

; Return the vector dot product.
D3DRMVectorDotProduct   PROCDESC STDCALL :DWORD, :DWORD

; Scale a vector so that its modulus is 1.  Returns its argument or
; NULL if there was an error (e.g. a zero vector was passed).
D3DRMVectorNormalize    PROCDESC STDCALL :DWORD

D3DRMVectorNormalise equ D3DRMVectorNormalize

; Return the length of a vector (e.g. sqrt(x*x + y*y + z*z)).
D3DRMVectorModulus  PROCDESC STDCALL :DWORD

; Set the rotation part of a matrix to be a rotation of theta radians
; around the given axis.
D3DRMVectorRotate   PROCDESC STDCALL :DWORD, :DWORD, :DWORD, :D3DVALUE

; Scale a vector uniformly in all three axes
D3DRMVectorScale    PROCDESC STDCALL :DWORD, :DWORD, :D3DVALUE

; Return a random unit vector
D3DRMVectorRandom   PROCDESC STDCALL :DWORD

; Returns a unit quaternion that represents a rotation of theta radians
; around the given axis.
D3DRMQuaternionFromRotation PROCDESC STDCALL :DWORD, :DWORD, :D3DVALUE

; Calculate the product of two quaternions
D3DRMQuaternionMultiply PROCDESC STDCALL :DWORD, :DWORD, :DWORD

; Interpolate between two quaternions
D3DRMQuaternionSlerp    PROCDESC STDCALL :DWORD, :DWORD, :DWORD, :D3DVALUE

; Calculate the matrix for the rotation that a unit quaternion represents
D3DRMMatrixFromQuaternion   PROCDESC STDCALL :DWORD, :DWORD

; Calculate the quaternion that corresponds to a rotation matrix
D3DRMQuaternionFromMatrix   PROCDESC STDCALL :DWORD, :DWORD

;end of file
