; Tddraw.inc  (c) Mike Bibby  27/10/98 m_bibby@hotmail.com

; Feel free to use or distribute the package, part or whole, for any non-commercial use, 
; preferably crediting me.

; Also feel free to contact me at the above address if you experience any
; problems or notice any omissions.

;################################################################################
;#                                Direct Draw Stuff                             #
;################################################################################

	DIRECTDRAW_VERSION = 0500h

	LPDIRECTDRAW  typedef DWORD
	LPDIRECTDRAWSURFACE typedef DWORD
	LPDIRECTDRAWCLIPPER typedef DWORD


 _DirectDrawCreate PROCDESC STDCALL :DWORD, :LPDIRECTDRAW, :DWORD
 
;################################################################################
;#                 Direct Draw  structure definitions                           #
;################################################################################
;------------------------------------------------------------------------------
; DDCOLORKEY structure
;------------------------------------------------------------------------------
 _DDCOLORKEY struct
    dwColorSpaceLowValue  DWORD ? 
    dwColorSpaceHighValue   DWORD ? 
_DDCOLORKEY ends

DDCOLORKEY typedef _DDCOLORKEY
;------------------------------------------------------------------------------
; DDBLTFX structure
;------------------------------------------------------------------------------
; Used to pass override information to the DIRECTDRAWSURFACE ; callback Blt.

 _DDBLTFX struct 
    dwSize  					DWORD  				0    
    dwDDFX  					DWORD  				0    
    dwROP   					DWORD  				0    
    dwDDROP 					DWORD  				0    
  	dwRotationAngle 			DWORD  				0
 	dwZBufferOpCode 			DWORD  				0
  	dwZBufferLow 				DWORD  				0
   	dwZBufferHigh 				DWORD  				0
  	dwZBufferBaseDest 			DWORD  				0 
  	dwZDestConstBitDepth  		DWORD 				0
 union
  	dwZDestConst 				DWORD 				0
 	lpDDSZBufferDest 			LPDIRECTDRAWSURFACE ?
 ends
	dwZSrcConstBitDepth 		DWORD 				0    
 union
 	dwZSrcConst 				DWORD 				0
  	lpDDSZBufferSrc 			LPDIRECTDRAWSURFACE ?                                                   
 ends
 	dwAlphaEdgeBlendBitDepth 	DWORD 				0
 	dwAlphaEdgeBlend 			DWORD 				0
   	dwBltFxReserved  			DWORD 				0
 	dwAlphaDestConstBitDepth 	DWORD 				0             
union
  	dwAlphaDestConst 			DWORD 				0
 	lpDDSAlphaDest 				LPDIRECTDRAWSURFACE ?                                      
ends
 	dwAlphaSrcConstBitDepth 	DWORD 				0               
union
	dwAlphaSrcConst  			DWORD 				0
 	lpDDSAlphaSrc  				LPDIRECTDRAWSURFACE ?                             
ends
union
 	dwFillColor  				DWORD 				0
 	dwFillDepth 				DWORD 				?
  	lpDDSPattern 				LPDIRECTDRAWSURFACE ?                   
ends
 	ddckDestColorkey  			DDCOLORKEY 			<>
  	ddckSrcColorkey  			DDCOLORKEY 			<>
_DDBLTFX ends

DDBLTFX 		typedef  		_DDBLTFX
LPDDBLTFX 		typedef 		PTR DDBLTFX 
;------------------------------------------------------------------------------
; DDSCAPS structure
;------------------------------------------------------------------------------
_DDSCAPS struct
   	dwCaps  					DWORD 				?  
_DDSCAPS ends

DDSCAPS 		typedef 		_DDSCAPS
LPDDSCAPS 		typedef 		PTR DDSCAPS

DD_ROP_SPACE	=	(256/32)	


IF DIRECTDRAW_VERSION GE 0500h

_DDCAPS_DX3 struct 
   	dwSize 						DWORD 				0 ; size of  DDDRIVERCAPS 
    dwDX3Caps 					DWORD 				0 ;	changed from dwCaps because of global structure members...	
    dwCaps2 					DWORD 				0 
    dwCKeyCaps 					DWORD 				0 	
    dwFXCaps 					DWORD 				0 		
    dwFXAlphaCaps 				DWORD 				0 	
    dwPalCaps 					DWORD 				0 	
    dwSVCaps 					DWORD 				0 	
    dwAlphaBltConstBitDepths 	DWORD 				0 ; DDBD_2,4,8
    dwAlphaBltPixelBitDepths 	DWORD 				0 ; DDBD_1,2,4,8
    dwAlphaBltSurfaceBitDepths 	DWORD 				0 ; DDBD_1,2,4,8
    dwAlphaOverlayConstBitDepths DWORD 				0 ; DDBD_2,4,8
    dwAlphaOverlayPixelBitDepths DWORD 				0 ; DDBD_1,2,4,8
    dwAlphaOverlaySurfaceBitDepths DWORD 			0 ; DDBD_1,2,4,8
    dwZBufferBitDepths 			DWORD 				0 ; DDBD_8,16,24,32
    dwVidMemTotal 				DWORD 				0 	
    dwVidMemFree 				DWORD 				0 	
    dwMaxVisibleOverlays 		DWORD 				0 
    dwCurrVisibleOverlays 		DWORD 				0 
    dwNumFourCCCodes 			DWORD 				0 
    dwAlignBoundarySrc 			DWORD 				0 
    dwAlignSizeSrc 				DWORD 				0 
    dwAlignBoundaryDest 		DWORD 				0 
    dwAlignSizeDest 			DWORD 				0 
    dwAlignStrideAlign 			DWORD 				0 
    dwRops 						DWORD DD_ROP_SPACE DUP (0)
    ddsCaps DDSCAPS	<0>
    dwMinOverlayStretch 		DWORD 				0 ; min overlay stretch factor * 1000
    dwMaxOverlayStretch 		DWORD 				0 ; max overlay stretch factor * 1000
    dwMinLiveVideoStretch 		DWORD 				0 ; min live video stretch factor * 1000
    dwMaxLiveVideoStretch 		DWORD 				0 ; max live video stretch factor * 1000
    dwMinHwCodecStretch 		DWORD 				0 ; min hardware codec stretch factor * 1000
    dwMaxHwCodecStretch 		DWORD 				0 ; max hardware codec stretch factor * 1000
    dwReserved1 				DWORD 				0 
    dwReserved2 				DWORD 				0 
    dwReserved3 				DWORD 				0 
    dwSVBCaps 					DWORD 				0 
   	dwSVBCKeyCaps 				DWORD 				0 
    dwSVBFXCaps 				DWORD 				0 
    dwSVBRops 					DWORD DD_ROP_SPACE DUP (0)
    dwVSBCaps 					DWORD 0 
    dwVSBCKeyCaps 				DWORD 0 
    dwVSBFXCaps 				DWORD 0 
    dwVSBRops 					DWORD DD_ROP_SPACE DUP (0)
    dwSSBCaps 					DWORD 0 
    dwSSBCKeyCaps 				DWORD 0 
    dwSSBFXCaps 				DWORD 0 
    dwSSBRops 					DWORD DD_ROP_SPACE DUP (0)
    dwReserved4 				DWORD 0 
    dwReserved5 				DWORD 0 
    dwReserved6 				DWORD 0 
_DDCAPS_DX3 ends
DDCAPS_DX3 		typedef 		_DDCAPS_DX3
LPDDCAPS_DX3 	typedef 		PTR DDCAPS_DX3

ENDIF

_DDCAPS struct 
	dwSize 							DWORD 	0  	;  0  ize of  DDDRIVERCAPS 
	dwDX5Caps 						DWORD 	0 	;  4  altered - DX5 added, global members	
	dwCaps2 						DWORD 	0  	;  8 
	dwCKeyCaps 						DWORD 	0  	;  c  
	dwFXCaps 						DWORD 	0  	; 10 
	dwFXAlphaCaps 					DWORD 	0  	; 14 
	dwPalCaps 						DWORD 	0  	; 18  
	dwSVCaps 						DWORD 	0  	; 1c  
	dwAlphaBltConstBitDepths 		DWORD 	0  	; 20  DDBD_2,4,8
	dwAlphaBltPixelBitDepths 		DWORD 	0  	; 24  DDBD_1,2,4,8
	dwAlphaBltSurfaceBitDepths 		DWORD 	0  	; 28  DDBD_1,2,4,8
	dwAlphaOverlayConstBitDepths 	DWORD 	0  	; 30  DDBD_2,4,8
	dwAlphaOverlayPixelBitDepths 	DWORD 	0  	; 30  DDBD_1,2,4,8
	dwAlphaOverlaySurfaceBitDepths 	DWORD 	0  	; 34  DDBD_1,2,4,8
	dwZBufferBitDepths 				DWORD 	0  	; 38  DDBD_8,16,24,32
	dwVidMemTotal 					DWORD 	0  	; 3c  
	dwVidMemFree 					DWORD 	0  	; 40  
	dwMaxVisibleOverlays 			DWORD 	0  	; 44  
	dwCurrVisibleOverlays 			DWORD 	0  	; 48  
	dwNumFourCCCodes 				DWORD 	0  	; 4c  
	dwAlignBoundarySrc 				DWORD 	0  	; 50  
	dwAlignSizeSrc 					DWORD 	0  	; 54  
	dwAlignBoundaryDest 			DWORD 	0  	; 58  
	dwAlignSizeDest 				DWORD 	0  	; 5c  
	dwAlignStrideAlign 				DWORD 	0  	; 60  
	dwRops 							DWORD  DD_ROP_SPACE DUP (0) ; 64	
	ddsCaps 						DDSCAPS	<0> ; 84  
	dwMinOverlayStretch 			DWORD 	0  	; 88 	min * 1000
	dwMaxOverlayStretch 			DWORD 	0  	; 8c 	max * 1000 
	dwMinLiveVideoStretch 			DWORD 	0  	; 90  	min * 1000
	dwMaxLiveVideoStretch 			DWORD 	0  	; 94  	max * 1000
	dwMinHwCodecStretch 			DWORD 	0  	; 98  	min * 1000
	dwMaxHwCodecStretch 			DWORD 	0  	; 9c  	max * 1000
	dwReserved1 					DWORD 	0  	; a0 
	dwReserved2 					DWORD 	0  	; a4  
	dwReserved3 					DWORD 	0  	; a8  
	dwSVBCaps 						DWORD 	0  	; ac  
	dwSVBCKeyCaps 					DWORD 	0  	; b0  
	dwSVBFXCaps 					DWORD 	0  	; b4  
	dwSVBRops 						DWORD 	DD_ROP_SPACE DUP (0) ; b8 
	dwVSBCaps 						DWORD 	0  	; d8 
	dwVSBCKeyCaps 					DWORD 	0  	; dc  
	dwVSBFXCaps 					DWORD 	0  	; e0 
	dwVSBRops 						DWORD DD_ROP_SPACE DUP (0) ; e4 
	dwSSBCaps 						DWORD 	0  	;104  
	dwSSBCKeyCaps 					DWORD 	0  	;108  
	dwSSBFXCaps 					DWORD 	0  	;10c 
	dwSSBRops  						DWORD DD_ROP_SPACE DUP (0)  ;110  
IF DIRECTDRAW_VERSION GE 0500h
	dwMaxVideoPorts 				DWORD 	0  ;130  
	dwCurrVideoPorts 				DWORD 	0  ;134  
	dwSVBCaps2 						DWORD 	0  ;138  
	dwNLVBCaps 						DWORD 	0  ;13c  
	dwNLVBCaps2 					DWORD 	0  ;140  
	dwNLVBCKeyCaps 					DWORD 	0  ;144  
	dwNLVBFXCaps 					DWORD 	0  ;148  
	dwNLVBRops  					DWORD DD_ROP_SPACE DUP (0) ;14c 
ELSE  
	dwReserved4 					DWORD 	0  ;130
	dwReserved5 					DWORD 	0  ;134 
	dwReserved6 					DWORD 	0  ;138  
ENDIF  
_DDCAPS ends

DDCAPS 			typedef 			_DDCAPS
LPDDCAPS 		typedef 			PTR DDCAPS
;------------------------------------------------------------------------------
; Pixel Format Flags
;------------------------------------------------------------------------------
	DDPF_ALPHAPIXELS		= 00000001h
	DDPF_ALPHA				= 00000002h
	DDPF_FOURCC				= 00000004h
	DDPF_PALETTEINDEXED4	= 00000008h
	DDPF_PALETTEINDEXEDTO8	= 00000010h
	DDPF_PALETTEINDEXED8	= 00000020h
	DDPF_RGB				= 00000040h
	DDPF_COMPRESSED			= 00000080h
	DDPF_RGBTOYUV			= 00000100h
	DDPF_YUV				= 00000200h
	DDPF_ZBUFFER			= 00000400h
	DDPF_PALETTEINDEXED1	= 00000800h
	DDPF_PALETTEINDEXED2	= 00001000h
	DDPF_ZPIXELS			= 00002000h
;------------------------------------------------------------------------------
; DDPIXELFORMAT structure
;------------------------------------------------------------------------------

_DDPIXELFORMAT struct
           dwSize    			DWORD 	? 
           dwpixFlags  			DWORD  	?  ;  altered from dwFlags because struct members global        
           dwFour   			DWORD   ?      
    union
           dwRGBBitCount 		DWORD  	?   
           dwYUVBitCount 		DWORD  	?   
           dwZBufferBitDepth 	DWORD   ?   
           dwAlphaBitDepth 		DWORD  	?   
    ends
    union
           dwRBitMask   		DWORD  	?  
           dwYBitMask   		DWORD  	?  
    ends
    union
           dwGBitMask  			DWORD  	? 
           dwUBitMask 			DWORD  	?  
  	ends
    union
           dwBBitMask 			DWORD  	? 
           dwVBitMask 			DWORD   ? 
   	ends
    union
    
           dwRGBAlphaBitMask 	DWORD  	? 
           dwYUVAlphaBitMask 	DWORD 	? 
	ends

_DDPIXELFORMAT  ends

DDPIXELFORMAT  	typedef _DDPIXELFORMAT 

LPDDPIXELFORMAT typedef PTR DDPIXELFORMAT 
;------------------------------------------------------------------------------
; DDSURFACEDESC structure
;------------------------------------------------------------------------------

_DDSURFACEDESC struct 
     	dwSize					DWORD           ? 
     	dwsurfFlags        		DWORD           ? ; altered: surf added
      	dwHeight     			DWORD       	? 
      	dwWidth   				DWORD       	? 
       	lPitch           		DWORD           ? 
       	dwBackBufferCount   	DWORD   		? 

    Union 
      	dwMipMapCount  			DWORD         	?
       	dwsurfZBufferBitDepth 	DWORD 			? ; altered: surf added
        dwsurfRefreshRate  		DWORD  			? ; altered: surf added                                                   ;                    described)
   	ends

      	dwsurfAlphaBitDepth 	DWORD 			? ; altered: surf added
      	dwReserved 				DWORD 			? 
      	lpSurface 				LPVOID 			?
     	ddckCKDestOverlay 		DDCOLORKEY 		? 
    	ddckCKDestBlt 			DDCOLORKEY 		? 
    	ddckCKSrcOverlay 		DDCOLORKEY 		?
    	ddckCKSrcBlt 			DDCOLORKEY 		? 
    	ddpfPixelFormat 		DDPIXELFORMAT 	? 
     	ddssurfCaps 			DDSCAPS  		? 
_DDSURFACEDESC ends

DDSURFACEDESC typedef _DDSURFACEDESC
LPDDSURFACEDESC typedef PTR DDSURFACEDESC
;------------------------------------------------------------------------------

 	DDSD_CAPS					= 00000001h
 	DDSD_HEIGHT					= 00000002h
 	DDSD_WIDTH					= 00000004h
 	DDSD_PITCH					= 00000008h
 	DDSD_BACKBUFFERCOUNT		= 00000020h
 	DDSD_ZBUFFERBITDEPTH		= 00000040h
 	DDSD_ALPHABITDEPTH			= 00000080h
 	DDSD_LPSURFACE				= 00000800h
 	DDSD_PIXELFORMAT			= 00001000h
 	DDSD_CKDESTOVERLAY			= 00002000h
 	DDSD_CKDESTBLT				= 00004000h
 	DDSD_CKSRCOVERLAY			= 00008000h
 	DDSD_CKSRCBLT				= 00010000h
 	DDSD_MIPMAPCOUNT        	= 00020000h
 	DDSD_REFRESHRATE			= 00040000h
 	DDSD_LINEARSIZE				= 00080000h
 	DDSD_ALL					= 000ff9eeh



;============   DIRECTDRAWSURFACE CAPABILITY FLAGS  ===================

  	DDSCAPS_RESERVED1			= 00000001h
 	DDSCAPS_ALPHA				= 00000002h
 	DDSCAPS_BACKBUFFER			= 00000004h
 	DDSCAPS_COMPLEX				= 00000008h
 	DDSCAPS_FLIP				= 00000010h
 	DDSCAPS_FRONTBUFFER			= 00000020h
 	DDSCAPS_OFFSCREENPLAIN		= 00000040h
 	DDSCAPS_OVERLAY				= 00000080h
 	DDSCAPS_PALETTE				= 00000100h
 	DDSCAPS_PRIMARYSURFACE		= 00000200h
 	DDSCAPS_PRIMARYSURFACELEFT	= 00000400h
 	DDSCAPS_SYSTEMMEMORY		= 00000800h
 	DDSCAPS_TEXTURE				= 00001000h
 	DDSCAPS_3DDEVICE           	= 00002000h
 	DDSCAPS_VIDEOMEMORY			= 00004000h
 	DDSCAPS_VISIBLE				= 00008000h
 	DDSCAPS_WRITEONLY			= 00010000h
 	DDSCAPS_ZBUFFER				= 00020000h
 	DDSCAPS_OWNDC				= 00040000h
 	DDSCAPS_LIVEVIDEO			= 00080000h
 	DDSCAPS_HWCODEC				= 00100000h
 	DDSCAPS_MODEX				= 00200000h
 	DDSCAPS_MIPMAP              = 00400000h
 	DDSCAPS_RESERVED2           = 00800000h
 	DDSCAPS_ALLOCONLOAD       	= 04000000h
 	DDSCAPS_VIDEOPORT			= 08000000h
 	DDSCAPS_LOCALVIDMEM         = 10000000h
 	DDSCAPS_NONLOCALVIDMEM      = 20000000h
 	DDSCAPS_STANDARDVGAMODE     = 40000000h
 	DDSCAPS_OPTIMIZED           = 80000000h


;============   DIRECTDRAW DRIVER CAPABILITY FLAGS   =====================

 	DDCAPS_3D					= 000000001h
 	DDCAPS_ALIGNBOUNDARYDEST	= 000000002h
 	DDCAPS_ALIGNSIZEDEST		= 000000004h
 	DDCAPS_ALIGNBOUNDARYSRC		= 000000008h
 	DDCAPS_ALIGNSIZESRC			= 000000010h
 	DDCAPS_ALIGNSTRIDE			= 000000020h
 	DDCAPS_BLT					= 000000040h
 	DDCAPS_BLTQUEUE				= 000000080h
 	DDCAPS_BLTFOURCC			= 000000100h
 	DDCAPS_BLTSTRETCH			= 000000200h
 	DDCAPS_GDI					= 000000400h
 	DDCAPS_OVERLAY				= 000000800h
 	DDCAPS_OVERLAYCANTCLIP		= 000001000h
 	DDCAPS_OVERLAYFOURCC		= 000002000h
 	DDCAPS_OVERLAYSTRETCH		= 000004000h
 	DDCAPS_PALETTE				= 000008000h
 	DDCAPS_PALETTEVSYNC			= 000010000h
 	DDCAPS_READSCANLINE			= 000020000h
 	DDCAPS_STEREOVIEW			= 000040000h
 	DDCAPS_VBI					= 000080000h
 	DDCAPS_ZBLTS				= 000100000h
 	DDCAPS_ZOVERLAYS			= 000200000h
 	DDCAPS_COLORKEY				= 000400000h
 	DDCAPS_ALPHA				= 000800000h
 	DDCAPS_COLORKEYHWASSIST		= 001000000h
 	DDCAPS_NOHARDWARE			= 002000000h
 	DDCAPS_BLTCOLORFILL			= 004000000h
 	DDCAPS_BANKSWITCHED			= 008000000h
 	DDCAPS_BLTDEPTHFILL			= 010000000h
 	DDCAPS_CANCLIP				= 020000000h
 	DDCAPS_CANCLIPSTRETCHED		= 040000000h
 	DDCAPS_CANBLTSYSMEM			= 080000000h



;=== MORE DIRECTDRAW DRIVER CAPABILITY FLAGS (dwCaps2) ===
 
 	DDCAPS2_CERTIFIED				= 000000001h
 	DDCAPS2_NO2DDURING3DSCENE   	= 000000002h
 	DDCAPS2_VIDEOPORT				= 000000004h
 	DDCAPS2_AUTOFLIPOVERLAY			= 000000008h
 	DDCAPS2_CANBOBINTERLEAVED		= 000000010h
 	DDCAPS2_CANBOBNONINTERLEAVED	= 000000020h
 	DDCAPS2_COLORCONTROLOVERLAY		= 000000040h
 	DDCAPS2_COLORCONTROLPRIMARY		= 000000080h
 	DDCAPS2_CANDROPZ16BIT			= 000000100h
 	DDCAPS2_NONLOCALVIDMEM          = 000000200h
 	DDCAPS2_NONLOCALVIDMEMCAPS      = 000000400h
 	DDCAPS2_NOPAGELOCKREQUIRED      = 000000800h
 	DDCAPS2_WIDESURFACES            = 000001000h
 	DDCAPS2_CANFLIPODDEVEN          = 000002000h
 
 
; ===========  DIRECTDRAW FX ALPHA CAPABILITY FLAGS =======
 


 	DDFXALPHACAPS_BLTALPHAEDGEBLEND			=  000000001h
 	DDFXALPHACAPS_BLTALPHAPIXELS			=  000000002h
	DDFXALPHACAPS_BLTALPHAPIXELSNEG			=  000000004h
	DDFXALPHACAPS_BLTALPHASURFACES			=  000000008h
	DDFXALPHACAPS_BLTALPHASURFACESNEG		=  000000010h
	DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND		=  000000020h
	DDFXALPHACAPS_OVERLAYALPHAPIXELS		=  000000040h
	DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG		=  000000080h
	DDFXALPHACAPS_OVERLAYALPHASURFACES		=  000000100h
 	DDFXALPHACAPS_OVERLAYALPHASURFACESNEG	=  000000200h

;========  DIRECTDRAW FX CAPABILITY FLAGS  ===============

 	DDFXCAPS_BLTARITHSTRETCHY		=  000000020h
 	DDFXCAPS_BLTARITHSTRETCHYN		=  000000010h
 	DDFXCAPS_BLTMIRRORLEFTRIGHT		=  000000040h
 	DDFXCAPS_BLTMIRRORUPDOWN		=  000000080h
 	DDFXCAPS_BLTROTATION			=  000000100h
 	DDFXCAPS_BLTROTATION90			=  000000200h
 	DDFXCAPS_BLTSHRINKX				=  000000400h
 	DDFXCAPS_BLTSHRINKXN			=  000000800h
 	DDFXCAPS_BLTSHRINKY				=  000001000h
 	DDFXCAPS_BLTSHRINKYN			=  000002000h
 	DDFXCAPS_BLTSTRETCHX			=  000004000h
 	DDFXCAPS_BLTSTRETCHXN			=  000008000h
 	DDFXCAPS_BLTSTRETCHY			=  000010000h
 	DDFXCAPS_BLTSTRETCHYN			=  000020000h
 	DDFXCAPS_OVERLAYARITHSTRETCHY	=  000040000h
 	DDFXCAPS_OVERLAYARITHSTRETCHYN	=  000000008h
 	DDFXCAPS_OVERLAYSHRINKX			=  000080000h
 	DDFXCAPS_OVERLAYSHRINKXN		=  000100000h
 	DDFXCAPS_OVERLAYSHRINKY			=  000200000h
 	DDFXCAPS_OVERLAYSHRINKYN		=  000400000h
 	DDFXCAPS_OVERLAYSTRETCHX		=  000800000h
 	DDFXCAPS_OVERLAYSTRETCHXN		=  001000000h
 	DDFXCAPS_OVERLAYSTRETCHY		=  002000000h
 	DDFXCAPS_OVERLAYSTRETCHYN		=  004000000h
 	DDFXCAPS_OVERLAYMIRRORLEFTRIGHT	=  008000000h
 	DDFXCAPS_OVERLAYMIRRORUPDOWN	=  010000000h

;=========  DIRECTDRAW STEREO VIEW CAPABILITIES ===========
 
 	DDSVCAPS_ENIGMA					=  000000001h
 	DDSVCAPS_FLICKER				=  000000002h
 	DDSVCAPS_REDBLUE				=  000000004h
 	DDSVCAPS_SPLIT					=  000000008h

;======== DIRECTDRAWPALETTE CAPABILITIES  =================

 	DDPCAPS_4BIT					=  000000001h
 	DDPCAPS_8BITENTRIES				=  000000002h
 	DDPCAPS_8BIT					=  000000004h
 	DDPCAPS_INITIALIZE				=  000000008h
 	DDPCAPS_PRIMARYSURFACE			=  000000010h
 	DDPCAPS_PRIMARYSURFACELEFT		=  000000020h
 	DDPCAPS_ALLOW256				=  000000040h
 	DDPCAPS_VSYNC					=  000000080h
 	DDPCAPS_1BIT					=  000000100h
 	DDPCAPS_2BIT					=  000000200h

;============= DIRECTDRAW BITDEPTH CONSTANTS  ==============

 	DDBD_1							=  000004000h
 	DDBD_2							=  000002000h
 	DDBD_4							=  000001000h
 	DDBD_8							=  000000800h
 	DDBD_16							=  000000400h
 	DDBD_24							=	000000200h
 	DDBD_32							=  000000100h

;==========  DIRECTDRAWSURFACE SET/GET COLOR KEY FLAGS  =============


 	DDCKEY_COLORSPACE	=  000000001h
 	DDCKEY_DESTBLT		=  000000002h
 	DDCKEY_DESTOVERLAY	=  000000004h
 	DDCKEY_SRCBLT		=  000000008h
 	DDCKEY_SRCOVERLAY	=  000000010h

;=========== DIRECTDRAW COLOR KEY CAPABILITY FLAGS ==================
 

 	DDCKEYCAPS_DESTBLT					=  000000001h
 	DDCKEYCAPS_DESTBLTCLRSPACE			=  000000002h
 	DDCKEYCAPS_DESTBLTCLRSPACEYUV		=  000000004h
 	DDCKEYCAPS_DESTBLTYUV				=  000000008h
 	DDCKEYCAPS_DESTOVERLAY				=  000000010h
 	DDCKEYCAPS_DESTOVERLAYCLRSPACE		=  000000020h
 	DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV	=  000000040h
 	DDCKEYCAPS_DESTOVERLAYONEACTIVE		=  000000080h
 	DDCKEYCAPS_DESTOVERLAYYUV			=  000000100h
 	DDCKEYCAPS_SRCBLT					=  000000200h
 	DDCKEYCAPS_SRCBLTCLRSPACE			=  000000400h
 	DDCKEYCAPS_SRCBLTCLRSPACEYUV		=  000000800h
 	DDCKEYCAPS_SRCBLTYUV				=  000001000h
 	DDCKEYCAPS_SRCOVERLAY				=  000002000h
 	DDCKEYCAPS_SRCOVERLAYCLRSPACE		=  000004000h
 	DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV	=  000008000h
 	DDCKEYCAPS_SRCOVERLAYONEACTIVE		=  000010000h
 	DDCKEYCAPS_SRCOVERLAYYUV			=  000020000h
 	DDCKEYCAPS_NOCOSTOVERLAY			=  000040000h

;============ DIRECTDRAW PIXELFORMAT FLAGS ==================

 	DDPF_ALPHAPIXELS				=  000000001h
 	DDPF_ALPHA						=  000000002h
 	DDPF_FOURCC						=  000000004h
 	DDPF_PALETTEINDEXED4			=  000000008h
 	DDPF_PALETTEINDEXEDTO8			=  000000010h
 	DDPF_PALETTEINDEXED8			=  000000020h
 	DDPF_RGB						=  000000040h
 	DDPF_COMPRESSED					=  000000080h
 	DDPF_RGBTOYUV					=  000000100h
 	DDPF_YUV						=  000000200h
 	DDPF_ZBUFFER					=  000000400h
 	DDPF_PALETTEINDEXED1			=  000000800h
 	DDPF_PALETTEINDEXED2			=  000001000h
 	DDPF_ZPIXELS					=  000002000h



;================ DIRECTDRAW ENUMSURFACES FLAGS ===================

 	DDENUMSURFACES_ALL				=  000000001h
 	DDENUMSURFACES_MATCH			=  000000002h
 	DDENUMSURFACES_NOMATCH			=  000000004h
 	DDENUMSURFACES_CANBECREATED		=  000000008h
 	DDENUMSURFACES_DOESEXIST		=  000000010h


;============    DIRECTDRAW SETDISPLAYMODE FLAGS    =====================
 
 	DDSDM_STANDARDVGAMODE          =  000000001h




;============   DIRECTDRAW ENUMDISPLAYMODES FLAGS   ======================

 	DDEDM_REFRESHRATES				=  000000001h
 	DDEDM_STANDARDVGAMODES        	=  000000002h
 
 
;================= SETCOOPERATIVELEVEL FLAGS =========================


	DDSCL_FULLSCREEN 		=	00000001h
	DDSCL_ALLOWREBOOT 		=	00000002h
	DDSCL_NOWINDOWCHANGES 	= 	00000004h
	DDSCL_NORMAL 			=	00000008h
	DDSCL_EXCLUSIVE 		=	00000010h
	DDSCL_ALLOWMODEX     	=   00000040h

; ============  DIRECTDRAW BLT FLAGS ===========================
 
 	DDBLT_ALPHADEST						= 000000001h
 	DDBLT_ALPHADESTCONSTOVERRIDE		= 000000002h
 	DDBLT_ALPHADESTNEG					= 000000004h
 	DDBLT_ALPHADESTSURFACEOVERRIDE		= 000000008h
 	DDBLT_ALPHAEDGEBLEND				= 000000010h
 	DDBLT_ALPHASRC						= 000000020h
 	DDBLT_ALPHASRCCONSTOVERRIDE			= 000000040h
 	DDBLT_ALPHASRCNEG					= 000000080h
 	DDBLT_ALPHASRCSURFACEOVERRIDE		= 000000100h
 	DDBLT_ASYNC							= 000000200h
 	DDBLT_COLORFILL						= 000000400h
 	DDBLT_DDFX							= 000000800h
 	DDBLT_DDROPS						= 000001000h
 	DDBLT_KEYDEST						= 000002000h
 	DDBLT_KEYDESTOVERRIDE				= 000004000h
 	DDBLT_KEYSRC						= 000008000h
 	DDBLT_KEYSRCOVERRIDE				= 000010000h
 	DDBLT_ROP							= 000020000h
 	DDBLT_ROTATIONANGLE					= 000040000h
 	DDBLT_ZBUFFER						= 000080000h
 	DDBLT_ZBUFFERDESTCONSTOVERRIDE		= 000100000h
 	DDBLT_ZBUFFERDESTOVERRIDE			= 000200000h
 	DDBLT_ZBUFFERSRCCONSTOVERRIDE		= 000400000h
 	DDBLT_ZBUFFERSRCOVERRIDE           	= 000800000h
 	DDBLT_WAIT                      	= 001000000h
 	DDBLT_DEPTHFILL						= 002000000h

; =============== BLTFAST FLAGS  ========================

 	DDBLTFAST_NOCOLORKEY              	= 000000000
 	DDBLTFAST_SRCCOLORKEY             	= 000000001
 	DDBLTFAST_DESTCOLORKEY            	= 000000002
 	DDBLTFAST_WAIT                    	= 000000010

;================ FLIP FLAGS ===========================
 
 	DDFLIP_WAIT                          = 000000001h
 	DDFLIP_EVEN                          = 000000002h
 	DDFLIP_ODD                           = 000000004h

;====  DIRECTDRAW SURFACE OVERLAY FLAGS  ===============
 
 	DDOVER_ALPHADEST					= 000000001h
 	DDOVER_ALPHADESTCONSTOVERRIDE		= 000000002h
 	DDOVER_ALPHADESTNEG					= 000000004h
 	DDOVER_ALPHADESTSURFACEOVERRIDE		= 000000008h
 	DDOVER_ALPHAEDGEBLEND				= 000000010h
 	DDOVER_ALPHASRC						= 000000020h
 	DDOVER_ALPHASRCCONSTOVERRIDE		= 000000040h
 	DDOVER_ALPHASRCNEG					= 000000080h
 	DDOVER_ALPHASRCSURFACEOVERRIDE		= 000000100h
 	DDOVER_HIDE							= 000000200h
 	DDOVER_KEYDEST						= 000000400h
 	DDOVER_KEYDESTOVERRIDE				= 000000800h
 	DDOVER_KEYSRC						= 000001000h
 	DDOVER_KEYSRCOVERRIDE				= 000002000h
 	DDOVER_SHOW							= 000004000h
 	DDOVER_ADDDIRTYRECT               	= 000008000h
 	DDOVER_REFRESHDIRTYRECTS			= 000010000h
 	DDOVER_REFRESHALL             		= 000020000h
 	DDOVER_DDFX                       	= 000080000h
 	DDOVER_AUTOFLIP                  	= 000100000h
 	DDOVER_BOB                       	= 000200000h
 	DDOVER_OVERRIDEBOBWEAVE				= 000400000h
 	DDOVER_INTERLEAVED					= 000800000h

;========   DIRECTDRAWSURFACE LOCK FLAGS  ===================
 
 	DDLOCK_SURFACEMEMORYPTR			= 000000000h	
 	DDLOCK_WAIT						= 000000001h
 	DDLOCK_EVENT					= 000000002h
 	DDLOCK_READONLY					= 000000010h
 	DDLOCK_WRITEONLY				= 000000020h
 	DDLOCK_NOSYSLOCK             	= 000000800h

;=======  DIRECTDRAWSURFACE BLT FX FLAGS    =================
 
 	DDBLTFX_ARITHSTRETCHY			= 000000001h
 	DDBLTFX_MIRRORLEFTRIGHT			= 000000002h
 	DDBLTFX_MIRRORUPDOWN			= 000000004h
 	DDBLTFX_NOTEARING				= 000000008h
 	DDBLTFX_ROTATE180				= 000000010h
 	DDBLTFX_ROTATE270				= 000000020h
 	DDBLTFX_ROTATE90				= 000000040h
 	DDBLTFX_ZBUFFERRANGE			= 000000080h
 	DDBLTFX_ZBUFFERBASEDEST			= 000000100h

;========== DIRECTDRAWSURFACE OVERLAY FX FLAGS  =============
 	DDOVERFX_ARITHSTRETCHY			= 000000001h
 	DDOVERFX_MIRRORLEFTRIGHT		= 000000002h
 	DDOVERFX_MIRRORUPDOWN			= 000000004h

;========= DIRECTDRAW WAITFORVERTICALBLANK FLAGS  ============
 	DDWAITVB_BLOCKBEGIN				= 000000001h
 	DDWAITVB_BLOCKBEGINEVENT		= 000000002h
 	DDWAITVB_BLOCKEND				= 000000004h

;=========== DIRECTDRAW GETFLIPSTATUS FLAGS    ===============
 
 	DDGFS_CANFLIP					= 000000001h
 	DDGFS_ISFLIPDONE				= 000000002h

;============ DIRECTDRAW GETBLTSTATUS FLAGS ==================
 
 	DDGBS_CANBLT					= 000000001h
 	DDGBS_ISBLTDONE					= 000000002h

;============= DIRECTDRAW ENUMOVERLAYZORDER FLAGS ============
 
 	DDENUMOVERLAYZ_BACKTOFRONT		= 000000000h
 	DDENUMOVERLAYZ_FRONTTOBACK		= 000000001h

;============ DIRECTDRAW UPDATEOVERLAYZORDER FLAGS ===========
 
 	DDOVERZ_SENDTOFRONT				= 000000000h
 	DDOVERZ_SENDTOBACK				= 000000001h
 	DDOVERZ_MOVEFORWARD				= 000000002h
 	DDOVERZ_MOVEBACKWARD			= 000000003h
 	DDOVERZ_INSERTINFRONTOF			= 000000004h
 	DDOVERZ_INSERTINBACKOF			= 000000005h

;===== DIRECTDRAW RETURN CODES ===============================
 
	DD_OK							= 0

;====== DIRECTDRAW ENUMCALLBACK RETURN VALUES ==============================
 
	DDENUMRET_CANCEL				= 0
	DDENUMRET_OK					= 1

;====== DIRECTDRAW ERRORS ===================================================

	DDERR_ALREADYINITIALIZED 	=  	88760005h			;  MAKE_DDHRESULT( 5 )
	DDERR_CANNOTATTACHSURFACE 	= 	8876000ah			;  MAKE_DDHRESULT( 10 )
	DDERR_CANNOTDETACHSURFACE 	= 	88760014h			;  MAKE_DDHRESULT( 20 )
	DDERR_CURRENTLYNOTAVAIL		= 	88760028h			;  MAKE_DDHRESULT( 40 )
	DDERR_EXCEPTION				= 	88760037h			;  MAKE_DDHRESULT( 55 )
	DDERR_GENERIC 				=  	80004005h			; DDERR_GENERIC is defined as E_FAIL =  80004005h		
	DDERR_HEIGHTALIGN 			=  	8876005ah			;  MAKE_DDHRESULT( 90 )
	DDERR_INCOMPATIBLEPRIMARY 	= 	8876005fh			;  MAKE_DDHRESULT( 95 )
	DDERR_INVALIDCAPS 			= 	88760064h			;  MAKE_DDHRESULT( 100 )
	DDERR_INVALIDCLIPLIST 		= 	8876006eh			;  MAKE_DDHRESULT( 110 )
	DDERR_INVALIDMODE 			=  	88760078h			;  MAKE_DDHRESULT( 120 )
	DDERR_INVALIDOBJECT 		= 	88760082h			;  MAKE_DDHRESULT( 130 )
	; DDERR_INVALIDPARAMS is defined as E_INVALIDARG =  80070057h	
	DDERR_INVALIDPARAMS 		=  	80070057h			; DDERR_INVALIDPARAMS is defined as E_INVALIDARG =  80070057h	
	DDERR_INVALIDPIXELFORMAT 	=  	88760091h			;  MAKE_DDHRESULT( 145 )
	DDERR_INVALIDRECT 			=  	88760096h			;  MAKE_DDHRESULT( 150 )
	DDERR_LOCKEDSURFACES 		=  	887600a0h			;  MAKE_DDHRESULT( 160 )
	DDERR_NO3D 					=  	887600aah			;  MAKE_DDHRESULT( 170 )
	DDERR_NOALPHAHW				=  	887600b4h			;  MAKE_DDHRESULT( 180 )
	DDERR_NOCLIPLIST 			=  	887600cdh			;  MAKE_DDHRESULT( 205 )
	DDERR_NOCOLORCONVHW			=  	887600d2h			;  MAKE_DDHRESULT( 210 )
	DDERR_NOCOOPERATIVELEVELSET	= 	887600d4h			;  MAKE_DDHRESULT( 212 )
	DDERR_NOCOLORKEY 			=  	887600d7h			;  MAKE_DDHRESULT( 215 )
	DDERR_NOCOLORKEYHW 			=  	887600dch			;  MAKE_DDHRESULT( 220 )
	DDERR_NODIRECTDRAWSUPPORT 	=  	887600deh			;  MAKE_DDHRESULT( 222 )
	DDERR_NOEXCLUSIVEMODE 		=  	887600e1h			;  MAKE_DDHRESULT( 225 )
	DDERR_NOFLIPHW				=  	887600e6h			;  MAKE_DDHRESULT( 230 )
	DDERR_NOGDI					= 	887600f0h			;  MAKE_DDHRESULT( 240 )
	DDERR_NOMIRRORHW 			=  	887600fah			;  MAKE_DDHRESULT( 250 )
	DDERR_NOTFOUND				= 	887600ffh			;  MAKE_DDHRESULT( 255 )
	DDERR_NOOVERLAYHW 			=  	88760104h			;  MAKE_DDHRESULT( 260 )
	DDERR_NORASTEROPHW 			=  	88760118h			;  MAKE_DDHRESULT( 280 )
	DDERR_NOROTATIONHW			= 	88760122h			;  MAKE_DDHRESULT( 290 )
	DDERR_NOSTRETCHHW			= 	88760136h			;  MAKE_DDHRESULT( 310 )
	DDERR_NOT4BITCOLOR			=  	8876013ch			;  MAKE_DDHRESULT( 316 )
	DDERR_NOT4BITCOLORINDEX		= 	8876013dh			;  MAKE_DDHRESULT( 317 )
	DDERR_NOT8BITCOLOR			=  	88760140h			;  MAKE_DDHRESULT( 320 )
	DDERR_NOTEXTUREHW 			=  	8876014ah			;  MAKE_DDHRESULT( 330 )
	DDERR_NOVSYNCHW				=  	8876014fh			;  MAKE_DDHRESULT( 335 )
	DDERR_NOZBUFFERHW 			=  	88760154h			;  MAKE_DDHRESULT( 340 )
	DDERR_NOZOVERLAYHW			=  	8876015eh			;  MAKE_DDHRESULT( 350 )
	DDERR_OUTOFCAPS				=  	88760168h			;  MAKE_DDHRESULT( 360 )
	; DDERR_OUTOFMEMORY is defined as E_OUTOFMEMORY	=  8007000eh
	DDERR_OUTOFMEMORY 			=  	8007000eh			; #defined to above
	DDERR_OUTOFVIDEOMEMORY 		=  	8876017ch			;  MAKE_DDHRESULT( 380 )
	DDERR_OVERLAYCANTCLIP 		=  	8876017eh			;  MAKE_DDHRESULT( 382 )
	DDERR_OVERLAYCOLORKEYONLYONEACTIVE =  88760180h		;  MAKE_DDHRESULT( 384 )
	DDERR_PALETTEBUSY			=  	88760183h			;  MAKE_DDHRESULT( 387 )
	DDERR_COLORKEYNOTSET 		=  	88760190h			;  MAKE_DDHRESULT( 400 )
	DDERR_SURFACEALREADYATTACHED =  8876019ah			;  MAKE_DDHRESULT( 410 )
	DDERR_SURFACEALREADYDEPENDENT =	887601a4h			;  MAKE_DDHRESULT( 420 )
	DDERR_SURFACEBUSY			=  	887601aeh			;  MAKE_DDHRESULT( 430 )
	DDERR_CANTLOCKSURFACE 		=  	887601b3h          	;  MAKE_DDHRESULT( 435 )
	DDERR_SURFACEISOBSCURED		=  	887601b8h			;  MAKE_DDHRESULT( 440 )
	DDERR_SURFACELOST 			=  	887601c2h			;  MAKE_DDHRESULT( 450 )
	DDERR_SURFACENOTATTACHED 	=  	887601cch			;  MAKE_DDHRESULT( 460 )
	DDERR_TOOBIGHEIGHT			=  	887601d6h			;  MAKE_DDHRESULT( 470 )
	DDERR_TOOBIGSIZE 			= 	887601e0h			;  MAKE_DDHRESULT( 480 )
	DDERR_TOOBIGWIDTH			=  	887601eah			;  MAKE_DDHRESULT( 490 )
	DDERR_UNSUPPORTED 			= 	80004001h			; DDERR_UNSUPPORTED is defined as E_NOTIMPL	=  80004001h;	
	DDERR_UNSUPPORTEDFORMAT		=  	887601feh			;  MAKE_DDHRESULT( 510 )
	DDERR_UNSUPPORTEDMASK 		=  	88760208h			;  MAKE_DDHRESULT( 520 )
	DDERR_VERTICALBLANKINPROGRESS =	88760219h			;  MAKE_DDHRESULT( 537 )
	DDERR_WASSTILLDRAWING 		=  	8876021ch			;  MAKE_DDHRESULT( 540 )
	DDERR_XALIGN 				=  	88760230h			;  MAKE_DDHRESULT( 560 )
	DDERR_INVALIDDIRECTDRAWGUID	= 	88760231h			;  MAKE_DDHRESULT( 561 )
	DDERR_DIRECTDRAWALREADYCREATED	= 88760232h			;  MAKE_DDHRESULT( 562 )
	DDERR_NODIRECTDRAWHW 		=  	88760233h			;  MAKE_DDHRESULT( 563 )
	DDERR_PRIMARYSURFACEALREADYEXISTS = 88760234h		;  MAKE_DDHRESULT( 564 )
	DDERR_NOEMULATION 			=  	88760235h			;  MAKE_DDHRESULT( 565 )
	DDERR_REGIONTOOSMALL 		=  	88760236h			;  MAKE_DDHRESULT( 566 )
	DDERR_CLIPPERISUSINGHWND 	=  	88760237h			;  MAKE_DDHRESULT( 567 )
	DDERR_NOCLIPPERATTACHED		=  	88760238h			;  MAKE_DDHRESULT( 568 )
	DDERR_NOHWND				=  	88760239h			;  MAKE_DDHRESULT( 569 )
	DDERR_HWNDSUBCLASSED 		=  	8876023ah			;  MAKE_DDHRESULT( 570 )
	DDERR_HWNDALREADYSET 		=  	8876023bh			;  MAKE_DDHRESULT( 571 )
	DDERR_NOPALETTEATTACHED		=  	8876023ch			;  MAKE_DDHRESULT( 572 )
	DDERR_NOPALETTEHW			=  	8876023dh			;  MAKE_DDHRESULT( 573 )
	DDERR_BLTFASTCANTCLIP 		=  	8876023eh			;  MAKE_DDHRESULT( 574 )
	DDERR_NOBLTHW				=  	8876023fh			;  MAKE_DDHRESULT( 575 )
	DDERR_NODDROPSHW 			=  	88760240h			;  MAKE_DDHRESULT( 576 )
	DDERR_OVERLAYNOTVISIBLE		= 	88760241h			;  MAKE_DDHRESULT( 577 )
	DDERR_NOOVERLAYDEST			= 	88760242h			;  MAKE_DDHRESULT( 578 )
	DDERR_INVALIDPOSITION 		=  	88760243h			;  MAKE_DDHRESULT( 579 )
	DDERR_NOTAOVERLAYSURFACE 	= 	88760244h			;  MAKE_DDHRESULT( 580 )
	DDERR_EXCLUSIVEMODEALREADYSET	= 88760245h			;  MAKE_DDHRESULT( 581 )
	DDERR_NOTFLIPPABLE			= 	88760246h			;  MAKE_DDHRESULT( 582 )
	DDERR_CANTDUPLICATE			= 	88760247h			;  MAKE_DDHRESULT( 583 )
	DDERR_NOTLOCKED				= 	88760248h			;  MAKE_DDHRESULT( 584 )
	DDERR_CANTCREATEDC			= 	88760249h			;  MAKE_DDHRESULT( 585 )
	DDERR_NODC					= 	8876024ah			;  MAKE_DDHRESULT( 586 )
	DDERR_WRONGMODE				= 	8876024bh			;  MAKE_DDHRESULT( 587 )
	DDERR_IMPLICITLYCREATED		=  	8876024ch			;  MAKE_DDHRESULT( 588 )
	DDERR_NOTPALETTIZED			= 	8876024dh			;  MAKE_DDHRESULT( 589 )
	DDERR_UNSUPPORTEDMODE 		=  	8876024eh			;  MAKE_DDHRESULT( 590 )
	DDERR_NOMIPMAPHW 			=	8876024fh			;  MAKE_DDHRESULT( 591 )
	DDERR_INVALIDSURFACETYPE  	= 	88760250h          	;  MAKE_DDHRESULT( 592 )
	DDERR_NOOPTIMIZEHW         	= 	88760258h          	;  MAKE_DDHRESULT( 600 )
	DDERR_NOTLOADED     		=  	88760259h         	;  MAKE_DDHRESULT( 601 )
	DDERR_DCALREADYCREATED		= 	8876026ch			;  MAKE_DDHRESULT( 620 )
	DDERR_NONONLOCALVIDMEM    	= 	88760276h          	;  MAKE_DDHRESULT( 630 )
	DDERR_CANTPAGELOCK			= 	88760280h			;  MAKE_DDHRESULT( 640 )
	DDERR_CANTPAGEUNLOCK 		=  	88760294h			;  MAKE_DDHRESULT( 660 )
	DDERR_NOTPAGELOCKED			= 	887602a8h			;  MAKE_DDHRESULT( 680 )
	DDERR_MOREDATA    			= 	887602b2h     		;  MAKE_DDHRESULT( 690 )
	DDERR_VIDEONOTACTIVE   		= 	887602b7h			;  MAKE_DDHRESULT( 695 )
	DDERR_DEVICEDOESNTOWNSURFACE = 	887602bbh 			;  MAKE_DDHRESULT( 699 )	
	DDERR_NOTINITIALIZED  		= 	800401f0h          	; DDERR_NOTINITIALIZED is defined as CO_E_NOTINITIALIZED = 800401f0h  

 

;================== METHODS ============================
; IDirectDraw
; IUnknown methods 
    DDQUERYINTERFACE 			=	 0
    DDADDREF					= 	 4
    DDRELEASE					=	 8
  ; IDirectDraw methods
    DDCOMPACT					= 	 12
    DDCREATECLIPPER				=	 16
    DDCREATEPALETTE				=	 20
    DDCREATESURFACE				=	 24
    DDDUPLICATESURFACE			=	 28
    DDENUMDISPLAYMODES  		=    32
    DDENUMSYURFACES				=	 36
    DDFLIPTOGDISURFACE			=	 40
    DDGETCAPS					=	 44
    DDGETDISPLAYMODE			=	 48
    DDGETFOURCCCODES			=	 52
    DDGETGDISURFACE				=	 56
    DDGETMONITORFREQUENCY		=	 60
    DDGETSCANLINE				=	 64
    DDGETVERTICALBLANKSTATUS 	= 	 68
    DDINITIALIZE				=	 72
    DDRESTOREDISPLAYMODE		= 	 76
    DDSETCOOPERATIVELEVEL		= 	 80
    DDSETDISPLAYMODE			=	 84
    DDWAITFORVERTICALBLANK		=	 88
; IDirectDraw2
 	DD2GETAVAILABLEVIDMEM		=	 92


; IDirectDrawPalette
; IUnknown methods
    DDPQUERYINTERFACE			= 	  0
  	DDPADDREF					= 	  4
    DDPRELEASE					= 	  8
; IDirectDrawPalette methods
    DDPDGETCAPS					=	 12
    DDPGETENTRIES				=	 16
    DDPINITIALIZE				=	 20
    DDPSETENTRIES				=	 24


 ; IDirectDrawSurface and related interfaces
 ; IUnknown methods
    DDSQUERYINTERFACE 			= 	  0
    DDSADDREF					=	  4
    DDSRELEASE  				= 	  8
 ; IDirectDrawSurface methods
    DDSADDATTACHEDSURFACE 		= 	 12
    DDSADDOVERLAYDIRTYRECT 		= 	 16
    DDSBLT 						= 	 20
    DDSBLTBATCH 				=  	 24
    DDSBLTFASTBLT	 			= 	 28
	DDSDELETATTACHEDSURFACE 	= 	 32
	DDSENUMATTACHEDSURFACES 	=	 36
	DDSENUMOVERLAYZORDERS 		=	 40
	DDSFLIP 					= 	 44
	DDSGETATTACHEDSURFACE 		= 	 48
	DDSGETBLTSTATUS 			= 	 52
	DDSGETCAPS 					= 	 56
    DDSGETCLIPPER 				= 	 60
    DDSGETCOLORKEY 				= 	 64
    DDSGETDC 					= 	 68
    DDSGETFLIPSTATUS 			=	 72
    DDSGETOVERLAYPOSITION 		=	 76
    DDSGETPALETTE 				= 	 80
    DDSGETPIXELFORMAT 			= 	 84
    DDSGETSURFACEDESC 			= 	 88
    DDSINITIALIZE 				= 	 92
    DDSISLOST 					= 	 96
    DDSLOCK 					= 	100
    DDSRELEASEDC				=	104
    DDSRESTORE 					= 	108
    DDSSETCLIPPER				= 	112
    DDSSETCOLORKEY 				= 	116
    DDSSETOVERLAYPOSITION 		= 	120
    DDSSETPALETTE				= 	124
    DDSUNLOCK					=	128
    DDSUPDATEOVERLAY 			= 	132
    DDSUPDATEOVERLAYDISPLAY 	= 	136
    DDSUPDATEOVERLAYZORDER 		= 	140
 ; IDirectDrawSurface2
	DDS2GETDDINTERFACE 			= 	144
	DDS2PAGELOCK 				= 	148
	DDS2PAGEUNLOCK 				= 	152
 ; IDirectDrawSurface3
	DDS3SETSURFACEDESC 			= 	156


;IDirectDrawClipper
;IUnknown methods
    DDCQUERYINTERFACE 			= 	  0
    DDCADDREF 					= 	  4
    DDCRELEASE 					= 	  8
 ;IDirectDrawClipper methods
    DDCGETCLIPLIST 				= 	 12
    DDCGETHWND 					= 	 16
    DDCINITIALIZE 				= 	 20 
    DDCISCLIPLISTCHANGED 		= 	 24
    DDCSETCLIPLIST 				= 	 28
    DDCSETHWND 					= 	 32


; IDirectDrawColorControl
; IUnknown methods
	DDCCQUERYINTERFACE			=	  0
	DDCCADDREF					=	  4
	DDCCRELEASE					=	  8
;IDirectDrawColorControl methods
	DDGETCOLORCONTROLS			=	 12
	DDSETCOLORCONTROLS			=	 16
