
NAME    tstvm

COMMENT /

TSTVM.ASM
Written by 	Christopher G. Hill
Copyright 	15 May 1991 all rights reserved

You are free to use this example in your own code. You may not sell this
for any price, nor may you charge for its distribution. You are free to 
pass it on to any friend or aquaintance. I will accept no responsibility
for damages occuring due your use of this code in any way. Any use of this
is to be done at your own risk.

/
 
INCLUDE VVMD.INC

.MODEL	SMALL
.RADIX	16


CR      	equ     0Dh
LF      	equ     0A
EOL		equ	'$'
NOT_ENHANCED	equ	-10
NOT_INSTALLED	equ	-11
VER_ERROR	equ	-12
TABLE_OFLOW	equ	-13
MAXHANDLES	equ	10

.STACK	100

.DATA

APIentry	dd	0
ListSize	dw	0
List		dd	MAXHANDLES dup(0) ;That should be enough to hold a few

version_msg	db	CR,LF,'VMMD version '
VERSION_MSGL	=	$-version_msg
		db	' . ',CR,LF,EOL
err_not_enh	db	CR,LF,'Not running Windows enhanced mode.',CR,LF,EOL
err_no_VVMD	db	CR,LF,'VVMD is not installed.',CR,LF,EOL
err_invalid_vm	db	CR,LF,'Specified VM does not exist.',CR,LF,EOL
err_cur_vm	db	CR,LF,'Specified VM is the current VM.',CR,LF,EOL
err_sys_vm	db	CR,LF,'Specified VM is the System VM.',CR,LF,EOL
err_bad_handle	db	CR,LF,'Specified VM handle is invalid.',CR,LF,EOL
err_bad_func	db	CR,LF,'Invalid VVMD function number.',CR,LF,EOL
err_internal	db	CR,LF,'Internal error - bad error code.',CR,LF,EOL
err_ver		db	CR,LF,'VVMD version does not match.',CR,LF,EOL
err_table_ovfl	db	CR,LF,'Too many handles for the internal table.',CR,LF,EOL
done_msg	db	CR,LF,'Done.',CR,LF,EOL

.386C

.CODE

tstvm   proc    far
        mov     ax,@DATA
        mov     ds,ax

        mov     ax,1600h                ; enhanced mode?
        int     2fh                     ; api call
        test    al,7fh                  ; enhance mode running?
        jnz     TSTVM_0
	mov	ax,NOT_ENHANCED
	call	errmsg
	jmp	exit
TSTVM_0:
        mov     ax,1684h                ; Get Device API call
        mov     bx,VVMD_Dev_ID          ; for the VWFD VxD
        int     2fh                     ; do enhanced api
        mov     WORD PTR Apientry,di    ; save the callback address
        mov     WORD PTR Apientry+2,es

        mov     ax,es                   ; is VVMD installed?
        or      ax,di
	jnz	TSTVM_1
	mov	ax,NOT_INSTALLED
	call	errmsg
	jmp	short exit
TSTVM_1:
	mov	ax,VER_ID
        call    DWORD PTR APIentry      ; get VVMD version back in AX
	cmp	ax,VERSION
	je	TSTVM_2
	mov	ax,VER_ERROR
	call	errmsg
	jmp	short exit
TSTVM_2:
	or	ax,3030			;version # change to ascii chars
	mov	bx,OFFSET version_msg	;print sign on message
	mov	dx,bx
	add	bx,version_msgl
	mov	[bx],ah
	add	bx,2
	mov	[bx],al
	call	msg

	mov	ax,GET_LIST_SIZE	;get # of VMs active in the system
	call	DWORD PTR APIentry
	cmp	ax,MAXHANDLES		;make sure we have enough space
	jbe	TSTVM_3			; in the handle table
	mov	ax,TABLE_OFLOW
	call	errmsg
	jmp	short exit
TSTVM_3:
	mov	[ListSize],ax		;number of 32-bit VM handles active
	mov	bx,ds
	movzx	ebx,bx
	shl	ebx,4			;linear address to list in ebx
	add	ebx,OFFSET List
	mov	ax,GET_LIST
	call	DWORD PTR APIentry	;let VVMD fill the table for us
	mov	cx,[ListSize]
	mov	si,OFFSET List
TSTVM_L1:	
	mov	ax,KILL_VM		;kill all VMs off except sys & ours
	mov	ebx,[si]
	add	si,4
	call	DWORD PTR APIentry
	jnc	TSTVM_L2		;carry set on error
	call	errmsg			; with error code in AX
TSTVM_L2:
	loop	TSTVM_L1		
	mov	dx,OFFSET done_msg	;print done messsage
	call	msg

	xor	al,al			;DOS error level 0
exit:
        mov     ah,4c			;exit to DOS
        int     21h
tstvm endp

msg	proc
	mov	ah,9			;print string in ds:dx
	int	21
	ret
msg	endp

errmsg	proc				;set up error message from error
	cmp	ax,INVALID_FN		; code in AX
	jne	em_0
	mov	dx,OFFSET err_bad_func
	jmp	short em_exit
em_0:
	cmp	ax,INVALID_HANDLE
	jne	em_1
	mov	dx,OFFSET err_bad_handle
	jmp	short em_exit
em_1:
	cmp	ax,SYS_VM_ERR
	jne	em_2
	mov	dx,OFFSET err_sys_vm
	jmp	short em_exit
em_2:
	cmp	ax,CUR_VM_ERR
	jne	em_3
	mov	dx,OFFSET err_cur_vm
	jmp	short em_exit
em_3:
	cmp	ax,NOT_ENHANCED
	jne	em_4
	mov	dx,OFFSET err_not_enh
	jmp	short em_exit
em_4:
	cmp	ax,NOT_INSTALLED
	jne	em_5
	mov	dx,OFFSET err_no_VVMD
	jmp	short em_exit
em_5:
	cmp	ax,VER_ERROR
	jne	em_6
	mov	dx,OFFSET err_ver
	jmp	short em_exit
em_6:
	cmp	ax,TABLE_OFLOW
	jne	em_7
	mov	dx,OFFSET err_table_ovfl
	jmp	short em_exit
em_7:
	mov	dx,OFFSET err_internal
em_exit:
	call	msg
	ret
errmsg	endp


	END     tstvm


