;ASMDEMO1.ASM --> ASMDEMO1.EXE	Windows demo program.
;This skeleton assembly language program has been written for Microsoft
;MASM (ML.EXE) v6.1.
;It uses PROLOGUE.INC to force the correct Windows prolog/epilog on
;all FAR PROCs.
;It has the startup code built-in, rather than as a separate object file.
;Note that Borland provide startup object module as C0WS.OBJ (small model)
;and Microsoft provide APPENTRY.OBJ with v6.1. If used, these are linked.

.MODEL SMALL

WINVER EQU	0300h
?WINPROLOGUE EQU 1	;forces win prolog/epil on far procs.
INCLUDE	winasm60.INC	;this is not the same WINDOWS.INC used by the
			;TASM programs. It is generated by H2INC.EXE,
			;and contains prototypes. Generated by...
			;  H2INC /C /Gc WINDOWS.H . . .
;note the inc file should not instantiate any data in data seg.
IDM_QUIT		EQU	100		;menu-identifiers -- must be
IDM_ABOUT		EQU	101		;same as defined in .RC file.

;...........................................
;This is the equates & data for the startup code...
STACKSLOP EQU 256			; amount of stack slop space required
maxRsrvPtrs EQU 5			       ; number of Windows reserved pointers
.DATA
;This must be at beginning of data segment...
	 DWORD	0			; Windows reserved data space.
rsrvptrs WORD   maxRsrvPtrs             ; 16 bytes at the top of the DATA seg.
	 WORD   maxRsrvPtrs DUP (0)     ; Do not alter

hPrev    WORD    0                      ; space to save WinMain parameters
hInst    WORD    0
lpszCmd  DWORD   0
cmdShow  WORD    0
;.........................................................

.DATA
szwintitle	DB	'HULLO DEMO PROGRAM',0
szASMDEMO1name	DB	'ASMDEMO1',0
hOemFont	DW	0			;handle to OEM font.
soutstring 	DB	'Hullo World'
szaboutstr	DB	'Assembly Language Windows Demo',0	;messagebox
sztitlestr	DB	'Karda Prints',0			;	/

;...........................................................
.CODE
;Here is the startup code...
start:
	xor bp,bp                       ; zero bp
	push bp
	INVOKE InitTask                 ; Initialize the stack
	or ax,ax
	jz noinit
	add cx,STACKSLOP                ; Add in stack slop space.
	jc noinit                       ; If overflow, return error.
	mov hPrev,si
	mov hInst,di
	mov word ptr lpszCmd,bx
	mov word ptr lpszCmd+2,es
	mov cmdShow,dx
	xor ax,ax                       ; Clear initial event that
	INVOKE WaitEvent, ax            ;   started this task.
	INVOKE InitApp, hInst           ; Initialize the queue.
	or ax,ax
	jz noinit

	INVOKE WINMAIN, hInst,hPrev,lpszCmd,cmdShow
ix:
	mov ah,4Ch
	INVOKE Dos3Call                 ; Exit with return code from app.
noinit:
	mov al,0FFh                     ; Exit with error code.
	jmp short ix

;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC NEAR PASCAL, hInstance:WORD,hPrevInstance:WORD,lpCmdLine:LPSTR, \
								nCmdShow:SWORD
	LOCAL	@hWnd:HWND
	LOCAL	s1:WNDCLASS
	LOCAL	s2:MSG

	cmp	hPrevInstance,0		;=0 if no previous instance.
	je	yes1st
	jmp	createwin
yes1st:
;Setup the window class structure for REGISTERCLASS()...
	mov 	s1.Style,3
	lea	di,s1.lpfnwndproc
	mov	[di],OFFSET ASMDEMO1Proc
	mov	[di+2],SEG ASMDEMO1Proc
	mov 	s1.CbClsExtra,0
	mov 	s1.CbWndExtra,0
	mov	ax,hInstance
	mov 	s1.HInstance,ax

  invoke LOADICON,null, IDI_APPLICATION
	mov 	s1.@HIcon,ax

  invoke LOADCURSOR,null, IDC_ARROW
	mov 	s1.@HCursor,ax

	mov 	s1.hbrBackground,COLOR_BACKGROUND
	mov	ax,OFFSET szASMDEMO1name
	lea	di,s1.lpszmenuname
	mov 	[di],ax
	mov 	[di+2],ds
	lea	di,s1.lpszclassname
	mov 	[di],ax
	mov 	[di+2],ds

	lea	ax,s1
  invoke REGISTERCLASS,ss::ax
	or	ax,ax
	jne	createwin
	jmp	quitwinmain

createwin:
 invoke CREATEWINDOW, ADDR szASMDEMO1name, ADDR szwintitle, 00CF0000h,\
				   150, 0, 400, 300, 0, 0, hInstance, 0
	mov 	@hWnd,ax
  invoke SHOWWINDOW,ax,nCmdShow
  invoke UPDATEWINDOW,@hWnd
	jmp	SHORT messageloop			;go to the main message-loop.


;This is the main message loop, in which Windows waits for messages
mainloop:
	lea	ax,s2
	invoke	TRANSLATEMESSAGE,ss::ax
	lea	ax,s2
	invoke	DISPATCHMESSAGE,ss::ax
messageloop:
	lea 	ax,s2
	invoke GETMESSAGE, ss::ax, null, null, null
	or	ax,ax
	jne	mainloop

;GetMessage() returns FALSE (AX=0) if a "quit" message...
;so here we are quiting....
	mov	ax,s2.WPARAM		;return wparam to windows OS.
quitwinmain:
	ret
WINMAIN	ENDP
;....................................................................

;.....................................................................
ASMDEMO1PROC	 PROTO FAR PASCAL,  :HWND, :WORD, :SWORD, :SDWORD
ASMDEMO1PROC	PROC FAR PASCAL, ihWnd:HWND, iMessage:WORD, iwParam:SWORD,\
				 ilParam:SDWORD
	LOCAL	dummy [5]:WORD
	LOCAL	@hDC:HDC
	LOCAL	s3:PAINTSTRUCT

	mov	ax,imessage		;get message-type.
	cmp	ax,WM_CREATE		;message received after CreateWindow()
	je	xcreate			;function is called.
	cmp	ax,WM_DESTROY		;message received if a window is closed.
	je	xquitmessage
	cmp	ax,WM_PAINT		;message received if Windows has (already)
						;redrawn any part of the window (due to
						;a size-change for example).
	je	xpaint
	cmp	ax,WM_COMMAND		;any selection of the menu will produce
	jne	notwmcommand
	jmp	xmenu			;this message.
notwmcommand:
	cmp	ax,WM_LBUTTONDOWN	;one of many mouse messages.
	jne	notwmlbutton
	jmp	xbreak
notwmlbutton:
	cmp	ax,WM_CHAR		;message that a key pressed.
	je	xchar

defhandler:
;Default handling of messages....
  invoke DEFWINDOWPROC,ihWnd,imessage,iwParam, ilParam
	jmp	xreturn

;.................................
xcreate:
  invoke	GETSTOCKOBJECT,OEM_FIXED_FONT
	mov	hOemFont,ax		;handle to font.
	jmp	xbreak

xquitmessage:
  invoke	POSTQUITMESSAGE,0
	jmp	xbreak

xchar:
	jmp 	xbreak

xpaint:
	lea	ax,s3  			;ss:ax -- far-addr of paint-structure.
  invoke BEGINPAINT,ihWnd,ss::ax
	mov	@hDC,ax			;hDC -- display-context, required
					;before can output to screen.

;For this simple demo, any redraw of the Window will cause output of our
;"hullo world" string....
  invoke	SELECTOBJECT,ax,hOemFont
  invoke	TEXTOUT,@hDC,10,20, ADDR soutstring,11
	lea	ax,s3  			; -- far-addr of paint-structure.
  invoke	ENDPAINT,ihWnd,ss::ax
	jmp	SHORT xbreak
;........................
xmenu:
	cmp	WORD PTR ilParam,0	;low-half of lParam
	jne	xbreak			;test if a menu-message.
	cmp	iwParam,IDM_QUIT		;wParam.
	jne	notquit
	jmp	xquitmessage
notquit:
	cmp	iwParam,IDM_ABOUT
	jne	xbreak			;no other menu items.
		;let's put up a message about this program...
 invoke MESSAGEBOX, ihWnd, ADDR szaboutstr, ADDR sztitlestr, MB_OK

;.........................
xbreak:
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
xreturn:
	ret
ASMDEMO1PROC	ENDP
;.....................................................................

 END	start
