;ADLLTEST.ASM --> ADLLTEST.EXE	Windows demo program.
;This program works like ASMDEMO2.ASM, except has been modified
;to load a DLL (ASMDLL.DLL, written in MASM 6.1) and call a function.
;... This is achieved, at execution time, by pressing any key
; (see the WM_CHAR case below).

;This skeleton assembly language program has been written for Microsoft
;MASM (ML.EXE) v6.1.   (Do NOT use Borland's TASM!).
;It uses PROLOGUE.INC to force the correct Windows prolog/epilog on
;all FAR PROCs.
;This program does NOT have the startup code built-in.
;Note that Borland provide startup object module as C0WS.OBJ (small model)
;and Microsoft provide APPENTRY.OBJ with v6.1. One of these must be linked.
;Note that APPENTRY.OBJ should be for the small model, to suit this
;program -- if not assemble APPENTRY.ASM, with switches as described in
;APPENTRY.ASM comments.

.286
.MODEL SMALL

WINVER EQU	0300h
?WINPROLOGUE EQU 1	;forces win prolog/epil on far procs.
INCLUDE	winasm60.INC	;this is not the same WINDOWS.INC used by the
			;TASM programs. It is generated by H2INC.EXE,
			;and contains prototypes. Generated by...
			;  H2INC /C /Gc WINDOWS.H . . .
IDM_QUIT		EQU	100		;menu-identifiers -- must be
IDM_ABOUT		EQU	101		;same as defined in .RC file.

	EXTRN __astart:FAR	;startup code, in APPENTRY.OBJ
				;(referenced at END)
;.........................................................
.DATA
szwintitle	DB	'MASM DEMO PROGRAM',0
szASMDEMOname	DB	'ADLLTEST',0
hOemFont	DW	0			;handle to OEM font.
soutstring	DB	'Press any key, to load DLL'
szaboutstr	DB	'Assembly Language Windows Demo',0	;messagebox
sztitlestr	DB	'Karda Prints',0			;	/

szdllfilename	DB	"ASMDLL.DLL",0	;our own masm dll.
hdll		DW	0		;handle to our dll.
szdemofunc	DB	"demofunc",0	;function in our dll.

DEMOFUNCPROTO	TYPEDEF PROTO FAR PASCAL, :HWND
DEMOFUNCPTR	TYPEDEF PTR DEMOFUNCPROTO
lpDEMOFUNC	DEMOFUNCPTR	0	;far addr of function in our dll.
;...........................................................
.CODE
	PUBLIC	WINMAIN
WINMAIN	PROC NEAR PASCAL, hInstance:WORD,hPrevInstance:WORD,lpCmdLine:LPSTR, \
								nCmdShow:SWORD
	LOCAL	@hWnd:HWND
	LOCAL	s1:WNDCLASS
	LOCAL	s2:MSG

	cmp	hPrevInstance,0		;=0 if no previous instance.
	je	yes1st
	jmp	createwin
yes1st:
;Setup the window class structure for REGISTERCLASS()...
	mov 	s1.Style,3
	lea	di,s1.lpfnwndproc
	mov	[di],OFFSET ASMDEMOPROC
	mov	[di+2],SEG ASMDEMOPROC
	mov 	s1.CbClsExtra,0
	mov 	s1.CbWndExtra,0
	mov	ax,hInstance
	mov 	s1.HInstance,ax

  invoke LOADICON,null, IDI_APPLICATION
	mov 	s1.@HIcon,ax

  invoke LOADCURSOR,null, IDC_ARROW
	mov 	s1.@HCursor,ax

	mov 	s1.hbrBackground,COLOR_BACKGROUND
	mov	ax,OFFSET szASMDEMOname
	lea	di,s1.lpszmenuname
	mov 	[di],ax
	mov 	[di+2],ds
	lea	di,s1.lpszclassname
	mov 	[di],ax
	mov 	[di+2],ds

	lea	ax,s1
  invoke REGISTERCLASS,ss::ax
	or	ax,ax
	jne	createwin
	jmp	quitwinmain

createwin:
 invoke CREATEWINDOW, ADDR szASMDEMOname, ADDR szwintitle, 00CF0000h,\
				   150, 0, 400, 300, 0, 0, hInstance, 0
	mov 	@hWnd,ax
  invoke SHOWWINDOW,ax,nCmdShow
  invoke UPDATEWINDOW,@hWnd
	jmp	SHORT messageloop		;go to the main message-loop.


;This is the main message loop, in which Windows waits for messages
mainloop:
	lea	ax,s2
	invoke	TRANSLATEMESSAGE,ss::ax
	lea	ax,s2
	invoke	DISPATCHMESSAGE,ss::ax
messageloop:
	lea 	ax,s2
	invoke GETMESSAGE, ss::ax, null, null, null
	or	ax,ax
	jne	mainloop

;GetMessage() returns FALSE (AX=0) if a "quit" message...
;so here we are quiting....
	mov	ax,s2.WPARAM		;return wparam to windows OS.
quitwinmain:
	ret
WINMAIN	ENDP
;....................................................................

;.....................................................................
ASMDEMOPROC	 PROTO FAR PASCAL,  :HWND, :WORD, :SWORD, :SDWORD
ASMDEMOPROC	PROC FAR PASCAL, ihWnd:HWND, iMessage:WORD, iwParam:SWORD,\
				 ilParam:SDWORD
	LOCAL	dummy [5]:WORD
	LOCAL	@hDC:HDC
	LOCAL	s3:PAINTSTRUCT

	mov	ax,imessage
	.IF	ax == WM_CREATE
		call	xcreate
	.ELSEIF ax == WM_DESTROY
		call	xquitmessage
	.ELSEIF ax == WM_PAINT
		call	xpaint
	.ELSEIF ax == WM_COMMAND
		call	xmenu
	.ELSEIF ax == WM_LBUTTONDOWN

	.ELSEIF ax == WM_CHAR
		call	xchar
	.ELSE
  invoke DEFWINDOWPROC,ihWnd,imessage,iwParam, ilParam	;default handling
	.ENDIF

;	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
;	cwd					;return a 32-bit (long) value).
	ret
;.....................................................................
xcreate:
  invoke	GETSTOCKOBJECT,OEM_FIXED_FONT
	mov	hOemFont,ax		;handle to font.
	ret
;..........................................
;****************************************************************
xchar:
	lea ax,szdllfilename
	invoke LOADLIBRARY, ds::ax	;returns handle to dll in ax.
	cmp ax,22
	jb	dllerror1		;not valid handle
	mov	hdll,ax 		;save handle
	lea	bx,szdemofunc
	invoke GETPROCADDRESS, ax,ds::bx	;returns address of func.
	cmp	dx,0
	je	dllerror2
	mov	WORD PTR lpDEMOFUNC,ax		;store addr of func.
	mov	WORD PTR lpDEMOFUNC+2,dx	;	/
	invoke	DEMOFUNCPTR PTR lpDEMOFUNC, ihWnd
dllerror2:
	invoke	FREELIBRARY, hdll
dllerror1:
	ret
;**************************************************************
;......................................
xpaint:
	lea	ax,s3  			;ss:ax -- far-addr of paint-structure.
  invoke BEGINPAINT,ihWnd,ss::ax
	mov	@hDC,ax			;hDC -- display-context, required
					;before can output to screen.

;For this simple demo, any redraw of the Window will cause output of our
;"hullo world" string....
  invoke	SELECTOBJECT,ax,hOemFont
  invoke	TEXTOUT,@hDC,10,20, ADDR soutstring,26
	lea	ax,s3  			; -- far-addr of paint-structure.
  invoke	ENDPAINT,ihWnd,ss::ax
	ret
;........................
xmenu:
	.IF	WORD PTR ilParam != 0	;test low-half of lParam
	.ELSEIF iwParam == IDM_QUIT
xquitmessage:	invoke	POSTQUITMESSAGE,0
	.ELSEIF iwParam == IDM_ABOUT
 invoke MESSAGEBOX, ihWnd, ADDR szaboutstr, ADDR sztitlestr, MB_OK
	.ENDIF
	ret
ASMDEMOPROC	ENDP
;.....................................................................

 END	__astart		;name of startup code.
