;ASMDLL.DLL
;This is an assembly langauge DLL.
;Written for MASM v6.1
;It is very simple, and has a function, demofunc(), that puts up a
;messagebox.  A program that tests this DLL is ADLLTEST.ASM.

.286
.MODEL	MEDIUM, FARSTACK	;ss=calling app's stack, not local ds.

;..................................
; Prolog and epilog for DLL exported far functions....
Prolog	MACRO
	mov	ax, ds			; Must be 1st, since Windows overwrites
	nop				; Placeholder for 3rd byte
	inc	bp			; Push odd BP.  Not required, but
	push	bp			;   allows CodeView to recognize stack
	mov	bp, sp			; Set up stack frame to access params
	push	ds			; Save DS
	mov	ds, ax			; Point DS to DLL's data segment
	ENDM

Epilog	MACRO
	pop	ds			; Recover original DS
	pop	bp			;   and BP+1
	dec	bp			; Reset to original BP
	ENDM

; WINVER = 0x0300 ;if you want it to work with windows 3.0
	;****commented this stupid line out, as doesn't do anything,
	;despite MS documentation.
INCLUDE	winasm60.inc ;win.inc ;Windows include file supplied with MASM v6.1
		;****I have a problem with win.inc**** even though NOKERNEL
		;(etc) isn't defined, behaves as though is, and can't
		;resolve the prototypes. Probably something simple....

;..........................................................
.DATA
TaskHead	BYTE	16 DUP(0)		; 1st paragraph reserved
						;   for Windows task header
szabout 	DB	"Select button to return to App",0
sztitle 	DB	"Demo of an ASM DLL",0

;............................................................
.CODE
;The first thing to do is put in the startup code.  I decided not to
;use DLLENTRY.OBJ (or LIBENTRY) on the link line, but to insert it here...
startup PROC FAR PASCAL PUBLIC	;ds=library data seg,di=lib instance handle,
				;cx=library heap size, in bytes.
	jcxz	xx		;jump if no heap
	invoke	LOCALINIT,ds,0,cx	;set up the heap
	.IF	ax != 0 		;if successful...
		invoke UNLOCKSEGMENT,-1 ;unlock data segment
xx:		call	initialise	;our dll initialisation
		mov	ax,1		;return true
	.ENDIF
	ret
startup ENDP
;.....................................................
initialise	PROC	NEAR	;initialisations specific to this dll.


		ret			; Return to startup
initialise	ENDP
;.................................

; Exported library routines
;--------------------------
 OPTION	PROLOGUE:None			; Disable automatic prolog/epilog
 OPTION	EPILOGUE:None			;   generation for DLL routines

demofunc	PROTO	FAR PASCAL, :HWND
demofunc	PROC	FAR PASCAL EXPORT, handlewnd:HWND
		Prolog				; Prologue macro

		;let's put up a message...
  invoke MESSAGEBOX, handlewnd, ADDR szabout, ADDR sztitle, MB_OK


		Epilog				; Epilogue macro
		ret

demofunc	ENDP

;..............

;.....................................................

;* Place WEP procedure in its own code segment, set as PRELOAD FIXED
;* in the .DEF module-definition file
;*
CODE2	SEGMENT WORD 'CODE'
	ASSUME	cs:CODE2

;* WEP
;*
;* Windows Exit Procedure called by Windows before unloading.
;* 
;* Entry:	wExitCode = 0 if unloading
;*			  = 1 if Windows shutting down
;* Return:	AX	  = 1 to signal okay

WEP		PROC	FAR PASCAL EXPORT

		Prolog
		mov	ax, 1		; Return AX = TRUE
		Epilog
		ret

WEP		ENDP

CODE2	ENDS
;..................................................................
END	startup
