;DPMI.ASM
;This demo program is written in TASM v3.0.
;It uses the WINASMOO.INC OO-file developed in Chapter 7.
;This program makes use of DPMI & low-level Windows functions.
;This program relates to discussion in Chapter 9.
;remember that Windows funcs only preserve SI,DI,BP & DS.

INCLUDE	WINDOWS.INC
INCLUDE	WINASMOO.INC
IDM_QUIT 	EQU	100
IDM_ABOUT	EQU	101

.DATA
window1	WINDOW { szclassname="DPMI",sztitlename="DPMI DEMO",\
		 paint=w1paint,create=w1create,command=w1command, \
		 createstylehi=WS_OVERLAPPEDWINDOW+WS_CLIPCHILDREN, \
		 char=w1char, sziconname="icon_1",y_coord=10,timer=w1timer,\
		 destroy=w1destroy }
control1 CONTROL { szclassname="BUTTON",sztitlename="OK",\
		 x_coord=20,y_coord=40,wwidth=30,wheight=20, \
		 hmenu=IDOK,createstylehi=WS_CHILD+WS_VISIBLE,\
		 createstylelo=BS_PUSHBUTTON }
.CODE
kickstart:
	lea	si,window1			;addr of window object.
	call	[si].make PASCAL,si		;make the window.
	lea	si,control1
	call	[si].make PASCAL,si		;make child window
	ret
;............................
w1paint	PROC PASCAL
	LOCAL	hdc:WORD
	LOCAL	paintstructa:PAINTSTRUCT
	lea	di,paintstructa
	call 	BEGINPAINT PASCAL,[si].hwnd, ss,di
	mov	hdc,ax
	call 	SELECTOBJECT PASCAL,ax, [si].hfont
	call 	TEXTOUT PASCAL,hdc,10,20, cs,OFFSET outstring,33
	call 	ENDPAINT PASCAL,[si].hwnd, ss,di
	ret
outstring	DB "Click button for direct video o/p "
w1paint	ENDP
;.............................................
w1create:
	call	GETSTOCKOBJECT PASCAL,OEM_FIXED_FONT	;Windows func.
	mov	[si].hfont,ax
	ret
;.............................................
w1command:
	cmp	WORD PTR [si].lparam,0	;lo half=0 if a menu selection.
	jne	notmenu
	ret
notmenu:
	cmp	[si].wparam,IDOK	;button child window selected?
		;note that lo-word of lparam has handle of control window,
		;hi-word of lparam has notification code.
	jne	notbutton
	lea	si,control1	;since si points to window1.
	call	DESTROYWINDOW PASCAL,[si].hwnd	;kill the button
	mov	[si].hwnd,0	;must clear hwnd, if want to make() later.

;what we will do now is make the new window always stay visible....
	lea	si,window1
	call	SETTIMER PASCAL,[si].hwnd,1,200, 0,0	;200mSec timeout.
		;post WM_TIMER to window every 200mS. 1=timer id.

notbutton:
	ret
szmsg	DB	"Created by Barry Kauler, 1992",0
szhdg	DB	"Message Box",0
;...................................................
w1char:
;let's bring back the button if any key pressed...
	lea	si,control1		;since si points to window1.
	call	[si].make PASCAL,si
	ret
;......................
w1destroy:
	call	KILLTIMER PASCAL,[si].hwnd,1	;created by SETTIMER().
	call 	POSTQUITMESSAGE PASCAL,0
	ret
;........................
w1timer:
;comes this way if a WM_TIMER message....
;this WinApp keeps on posting a WM_TIMER message to itself, thus this
;section is in a continuous loop...
	call 	dpmidemo
	ret
;............................................................
dpmidemo:
;comes here if button selected.  now we will do some direct video...
	mov	ah,0Fh	   ;get current video state
	int	10h		;--> al=mode,ah=width,bh=page
	mov	mode,al		;save
	mov	columns,ah	;	/
	mov	vpage,bh		;	/
	mov	ah,3	   ;get current cursor position
	mov	bh,vpage		;video page
	int	10h		;-->dh=row,dl=col,cx=cur.size
	mov	curpos,dx	;save.
;all of this below, writes the pseudo text mode window onto the scrn...
	mov	ah,2	   ;set cursor position
	mov	dh,5		;row=5
	mov	dl,columns
	shr	dl,1		;centre cursor on screen
	mov	bh,vpage		;video page
	push	dx		;save
	int	10h
	mov	dx,OFFSET szdirect
	mov	ah,9	   ;write a string to scrn
	int	21h
	pop	dx		;restore
	inc	dh		;next row
	mov	bh,vpage
	mov	ah,2
	push	dx		;save
	int	10h		;set cursor
	mov	ah,9	       ;write string
	mov	dx,OFFSET szdir2
	int	21h
	pop	dx		;restore
	inc	dh		;next row on scrn
	mov	bh,vpage
	mov	ah,2
	int	10h		;set cursor
	mov	ah,9		;write string
	mov	dx,OFFSET szdir3
	int	21h

	mov	ah,2  		;restore cursor pos.
	mov	dx,curpos
	mov	bh,vpage
	int	10h
	ret
.DATA
mode	DB	0
columns	DB	0
vpage	DB	0
curpos	DW	0
szdirect DB "Ŀ$"
szdir2	 DB "BIOS/DOS O/P$"
szdir3	 DB "$"
;...........................................................
 END
