;WINASMOO.INC + WINASMOO.ASM --> WINASMOO.EXE  Windows OO program.
;remember that Windows funcs only preserve SI,DI,BP & DS.
.MODEL SMALL
LOCALS			;turns on "@@" prefix for auto local name-mangling.
;......
;These are Windows functions ...
EXTRN	UPDATEWINDOW:FAR,BEGINPAINT:FAR,ENDPAINT:FAR
EXTRN	DEFWINDOWPROC:FAR,POSTQUITMESSAGE:FAR,REGISTERCLASS:FAR
EXTRN	GETSTOCKOBJECT:FAR,CREATEWINDOW:FAR,SHOWWINDOW:FAR
EXTRN	GETMESSAGE:FAR,LOADCURSOR:FAR,TRANSLATEMESSAGE:FAR
EXTRN	DISPATCHMESSAGE:FAR,LOADICON:FAR,TEXTOUT:FAR
EXTRN	MESSAGEBOX:FAR,GETDC:FAR,RELEASEDC:FAR
EXTRN	SELECTOBJECT:FAR,GETWINDOWWORD:FAR,SETWINDOWWORD:FAR
EXTRN	SENDMESSAGE:FAR,DESTROYWINDOW:FAR,GETCLASSINFO:FAR
EXTRN	POSTMESSAGE:FAR,YIELD:FAR,SETTIMER:FAR,KILLTIMER:FAR
;.........................................................

.DATA
;..........................................................
MAIN	TABLE	{
	VIRTUAL	initinstance:WORD =	kickstart	;see WINASMOO.ASM
	VIRTUAL	hinstance:WORD =	0
	VIRTUAL	hprevinstance:WORD =	0
	VIRTUAL	ncmdshow:WORD =		0
	}

;...
WINDOW	TABLE	{
	VIRTUAL	definewndclass:WORD = 	WINDOWdefinewndclass
	VIRTUAL	create:WORD =		WINDOWcreate
	VIRTUAL	paint:WORD =		WINDOWpaint
	VIRTUAL	command:WORD =		WINDOWcommand
	VIRTUAL	timer:WORD =		WINDOWtimer
	VIRTUAL	resize:WORD =		WINDOWresize
	VIRTUAL	mousemove:WORD =	WINDOWmousemove
	VIRTUAL	lbuttondown:WORD =	WINDOWlbuttondown
	VIRTUAL	lbuttonup:WORD =	WINDOWlbuttonup
	VIRTUAL	char:WORD =		WINDOWchar
	VIRTUAL user:WORD =		WINDOWuser
	VIRTUAL	defaultproc:WORD =	WINDOWdefaultproc
	VIRTUAL	destroy:WORD =		WINDOWdestroy
	VIRTUAL	make:WORD =		WINDOWmake
	VIRTUAL	wndproc:WORD =		WINDOWwndproc
	VIRTUAL	hwnd:WORD =		0	;must=0 for make() to work.
	VIRTUAL	wmessage:WORD =		0
	VIRTUAL	wparam:WORD =		0
	VIRTUAL	lparam:DWORD =		0
	VIRTUAL	 classstyle:WORD =	CS_VREDRAW + CS_HREDRAW
	VIRTUAL	 sziconname:BYTE:32 =	0
	VIRTUAL	 szcursorname:BYTE:32 =	0
	VIRTUAL	 hbrbackground:WORD =	COLOR_BACKGROUND
	VIRTUAL	 szclassname:BYTE:32 =	0
	VIRTUAL	 sztitlename:BYTE:32 =	0
	VIRTUAL	 hmenu:WORD =		0
	VIRTUAL	 hwndparent:WORD =	0
	VIRTUAL	 wheight:WORD =		200
	VIRTUAL	 wwidth:WORD =		250
	VIRTUAL	 y_coord:WORD =		0
	VIRTUAL	 x_coord:WORD =		150
	VIRTUAL	 createstylelo:WORD =	0
	VIRTUAL	 createstylehi:WORD =	WS_OVERLAPPEDWINDOW
	VIRTUAL	hfont:WORD =		0
	}


main1	MAIN	{ }			;create static instance.
pwindow		DW	0		;ptr to current window object.
pwindowflag	DB	0 ;1		;=0 pwindow not valid. initialise=1.
;..........................................................

.CODE
;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC PASCAL NEAR @@hInstance:WORD,@@hPrevInstance:WORD,\
			@@lpCmdLine:DWORD,@@nCmdShow:WORD
	LOCAL	msg:MSGSTRUCT

	lea	si,main1
	mov	ax,@@hinstance		;save params in main1 object.
	mov	[si].hinstance,ax	;	/
	mov	ax,@@hprevinstance	;	/
	mov	[si].hprevinstance,ax	;	/
	mov	ax,@@ncmdshow		;	/
	mov	[si].ncmdshow,ax	;	/
  call [si].initinstance 		;call kickstart() ***no pascal***
	or	ax,ax
	jne	messageloop
	ret

loopback:
	call TRANSLATEMESSAGE PASCAL, ss,di
	call DISPATCHMESSAGE PASCAL, ss,di
messageloop:
	lea 	di,msg
	call GETMESSAGE PASCAL, ss,di, null, null, null
	or	ax,ax
	jne	loopback
	mov	ax,[di].msWPARAM		;return wparam to windows OS.
	ret
WINMAIN	ENDP

;.....................................................................
	PUBLIC	exportwndproc
exportwndproc	PROC WINDOWS PASCAL FAR @@hwnd:WORD,@@message:WORD,\
					@@wparam:WORD,@@lparam:DWORD
	LOCAL	dummy:WORD:5

	cmp	pwindowflag,0
	jne	normalwndproc
  call DEFWINDOWPROC PASCAL,@@hwnd,@@message,@@wparam,@@lparam
	ret

normalwndproc:
	push	si	;weird. callback must preserve si.
	push	di	;and di?
  call GETWINDOWWORD PASCAL,@@hwnd,0	;0=offset in Windows internal data.
	mov	pwindow,ax		;get addr of current window object.
	mov	si,ax  			;don't use LEA

	mov	ax,@@message		;save params in window object.
	mov	[si].wmessage,ax
	mov	ax,@@wparam
	mov	[si].wparam,ax
	mov	ax,WORD PTR @@lparam
	mov	WORD PTR [si].lparam,ax
	mov	ax,WORD PTR @@lparam+2
	mov	WORD PTR [si].lparam+2,ax

  call [si].wndproc PASCAL,si

	pop	di
	pop	si
	ret
exportwndproc	ENDP
;..................................

WINDOWwndproc PROC PASCAL now
	mov	si,now			;current window object.
	mov	dx,0			;hi return flag. set default 0.

	mov	ax,[si].wmessage	;get message
	cmp	ax,WM_CREATE		;message received after CreateWindow()
	jne	case2
	call	[si].create		;**note no pascal**
	jmp	SHORT	endx
case2: cmp	ax,WM_DESTROY		;message received if a window is closed.
	jne	case3
	call	[si].destroy
	jmp	SHORT	endx
case3: cmp	ax,WM_PAINT		;message if Window redrawn.
	jne	case4
	call	[si].paint
	jmp	SHORT	endx
case4: cmp	ax,WM_COMMAND		;any selection of the menu will produce
	jne	case5
	call	[si].command
	jmp	SHORT	endx
case5: cmp	ax,WM_LBUTTONDOWN	;one of many mouse messages.
	jne	case6
	call	[si].lbuttondown
	jmp	SHORT	endx
case6: cmp	ax,WM_CHAR		;message that a key pressed.
	jne	case7
	call	[si].char
	jmp	SHORT	endx
case7:	cmp	ax,WM_USER		;user specific
	jne	case8
	call	[si].user
	jmp	SHORT endx
case8:	cmp	ax,WM_TIMER		;timer event
	jne	case9
	call	[si].timer
	jmp	SHORT endx
case9:
	call	[si].defaultproc

endx: 	ret				;return dx:ax flag (maybe).
WINDOWwndproc	ENDP
;...............................................................

WINDOWmake	PROC PASCAL now
	LOCAL	wndclassa:WNDCLASS
	mov	si,now
	xor	ax,ax			;clear ax (default return value).

;does this window already exist?  check hwnd...
	cmp	[si].hwnd,0
	je	nexist
	jmp	endhere

;Is it a child? ... this make() can't handle a child ...
nexist: cmp	[si].hwndparent,0
	je	nochild
	jmp	endhere
nochild:

	lea	di,[si].wndclassa
  call [si].definewndclass PASCAL, di, si
  call	REGISTERCLASS PASCAL, ss,di

	mov	pwindowflag,0		;disable wndproc() processing.
	lea	bx,[si].szclassname
	lea	ax,[si].sztitlename
  call CREATEWINDOW PASCAL, ds,bx, ds,ax, [si].createstylehi,[si].createstylelo,\
			[si].x_coord,[si].y_coord,[si].wwidth,[si].wheight,\
			[si].hwndparent,[si].hmenu,main1.hinstance,0,0
	mov	[si].hwnd,ax	;save handle in window object.
	mov	di,ax
	or	ax,ax		;exit if handle is 0.
	jz	endhere

  call SETWINDOWWORD PASCAL,di,0,si ;store addr of window object (at offs.0)
	mov	pwindowflag,1	;enable callback normal processing.
;Callback disabled above, but my callback needs WM_CREATE. So send it now...
  call SENDMESSAGE PASCAL, di, WM_CREATE, 0, 0,0  ;note lparam incorrect.

  call SHOWWINDOW PASCAL, di ,main1.ncmdshow
  call UPDATEWINDOW PASCAL, di

  mov	ax,1
endhere:	ret
WINDOWmake	ENDP
;........................................
WINDOWdefinewndclass PROC PASCAL pwndclass,now
	push	di
	push	si
	mov	si,now
	mov	di,pwndclass

	mov	ax,[si].classstyle
	mov	[di].clsStyle,ax

;Setup the window class structure for REGISTERCLASS()...
	mov 	[di].WORD PTR clsLpfnWndProc,OFFSET exportwndproc
	mov 	[di].WORD PTR clsLpfnWndProc+2,SEG exportwndproc

	mov	[di].clsCbClsExtra,0
	mov	[di].clsCbWndExtra,2

	mov	ax,main1.hInstance
	mov 	[di].clsHInstance,ax

	cmp	[si].sziconname,0
	je	noicon
	lea	ax,[si].sziconname
  call LOADICON PASCAL, main1.hinstance, ds,ax
	jmp	SHORT yesicon
noicon:
  call LOADICON PASCAL, null, 0,IDI_APPLICATION
yesicon:
	mov 	[di].clsHIcon,ax

	cmp	[si].szcursorname,0
	je	nocursor
	lea	ax,[si].szcursorname
  call LOADCURSOR PASCAL, main1.hinstance, ds,ax
	jmp	SHORT yescursor
nocursor:
  call LOADCURSOR PASCAL, null, 0,IDC_ARROW
yescursor:
	mov 	[di].clsHCursor,ax

	mov	ax,[si].hbrbackground
	mov 	[di].clsHbrBackground,ax

	lea     ax,[si].szclassname
	mov 	[di].WORD PTR clsLpszMenuname,ax
	mov 	[di].WORD PTR clsLpszMenuName+2,ds
	mov 	[di].WORD PTR clsLpszClassName,ax
	mov 	[di].WORD PTR clsLpszClassName+2,ds

	pop	si
	pop	di
	ret
WINDOWdefinewndclass ENDP

;....................................................
;default message processing ...  no pascal & si already set to window object.
;......
WINDOWdestroy:
  call POSTQUITMESSAGE PASCAL,0
	ret
;......
WINDOWcreate:
WINDOWpaint:
WINDOWcommand:
WINDOWlbuttondown:
WINDOWlbuttonup:
WINDOWchar:
WINDOWuser:
WINDOWtimer:
WINDOWresize:
WINDOWmousemove:
WINDOWdefaultproc:
  call DEFWINDOWPROC PASCAL,[si].hwnd,[si].wmessage,[si].wparam,[si].lparam
	ret
;......................................................
;Here are extensions for handling controls ...
;......
.DATA
CONTROL	TABLE {
	WINDOW,
	VIRTUAL make:WORD = CONTROLmake
	}
;.........
.CODE
CONTROLmake	PROC PASCAL now
	mov	si,now
	xor	ax,ax			;clear ax (default return value).

;does this window already exist?  check hwnd...
	cmp	[si].hwnd,0
	jnz	ending
;Is it a child? ... all controls are child windows ...
	cmp	[si].hwndparent,0
	jne	nending
;so, we have to give it one .... (this involves an assumption)...
;pwindow still points to the parent window object, so...
	mov	bx,pwindow
	mov	ax,[bx].hwnd
	mov	[si].hwndparent,ax

nending:
	lea	bx,[si].szclassname
	lea	ax,[si].sztitlename
  call CREATEWINDOW PASCAL, ds,bx, ds,ax, [si].createstylehi, \
			[si].createstylelo,[si].x_coord,[si].y_coord, \
			[si].wwidth,[si].wheight,[si].hwndparent, \
			[si].hmenu,main1.hinstance,0,0
	mov	[si].hwnd,ax	;save handle in window object.

ending:	ret
CONTROLmake	ENDP
;........................................
