;ASMRING0.ASM --> ASMRING0.EXE	Windows demo program.
;This skeleton assembly language program has been written for Microsoft
;MASM (ML.EXE) v6.1.
;It uses PROLOGUE.INC to force the correct Windows prolog/epilog on
;all FAR PROCs.
;It has the startup code built-in, rather than as a separate object file.
;Note that Borland provide startup object module as C0WS.OBJ (small model)
;and Microsoft provide APPENTRY.OBJ with v6.1. If used, these are linked.

.286
.MODEL SMALL

EXTERN RING0FUNC:NEAR   ;this is in HEAVEN.ASM. It is the ring0 code.

WINVER EQU	0300h
?WINPROLOGUE EQU 1	;forces win prolog/epil on far procs.
INCLUDE	winasm60.INC	;this is not the same WINDOWS.INC used by the
			;TASM programs. It is generated by H2INC.EXE,
			;and contains prototypes. Generated by...
			;  H2INC /C /Gc WINDOWS.H . . .
;note the inc file should not instantiate any data in data seg.
IDM_QUIT		EQU	100		;menu-identifiers -- must be
IDM_ABOUT		EQU	101		;same as defined in .RC file.

;...........................................
;This is the equates & data for the startup code...
STACKSLOP EQU 256			; amount of stack slop space required
maxRsrvPtrs EQU 5			       ; number of Windows reserved pointers
.DATA
;This must be at beginning of data segment...
	 DWORD	0			; Windows reserved data space.
rsrvptrs WORD   maxRsrvPtrs             ; 16 bytes at the top of the DATA seg.
	 WORD   maxRsrvPtrs DUP (0)     ; Do not alter

hPrev    WORD    0                      ; space to save WinMain parameters
hInst    WORD    0
lpszCmd  DWORD   0
cmdShow  WORD    0
;.........................................................

.DATA
szwintitle	DB	'RING0 DEMO PROGRAM',0
szASMDEMO1name	DB	'ASMRING0',0
hOemFont	DW	0			;handle to OEM font.
handlemain      DW      0                       ;handle of main window.
soutstring 	DB	'Hullo World'
szaboutstr	DB	'Assembly Language Windows Demo',0	;messagebox
sztitlestr	DB	'Barry Kauler',0			;	/
szerror         DB      "!ERROR!",0             ;used by error message box.

PUBLIC  ring0stack
PUBLIC  default0esp
PUBLIC  default0ss
ring0stack      DD      2000 DUP(0)
default0esp     DD      0                       ;default ring-0 stack
default0ss      DW      0                       ;       /


;...........................................................
.CODE
;Here is the startup code...
start:
	xor bp,bp                       ; zero bp
	push bp
	INVOKE InitTask                 ; Initialize the stack
	or ax,ax
	jz noinit
	add cx,STACKSLOP                ; Add in stack slop space.
	jc noinit                       ; If overflow, return error.
	mov hPrev,si
	mov hInst,di
	mov word ptr lpszCmd,bx
	mov word ptr lpszCmd+2,es
	mov cmdShow,dx
	xor ax,ax                       ; Clear initial event that
	INVOKE WaitEvent, ax            ;   started this task.
	INVOKE InitApp, hInst           ; Initialize the queue.
	or ax,ax
	jz noinit

	INVOKE WINMAIN, hInst,hPrev,lpszCmd,cmdShow
ix:
	mov ah,4Ch
	INVOKE Dos3Call                 ; Exit with return code from app.
noinit:
	mov al,0FFh                     ; Exit with error code.
	jmp short ix

;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC NEAR PASCAL, hInstance:WORD,hPrevInstance:WORD,lpCmdLine:LPSTR, \
								nCmdShow:SWORD
	LOCAL	@hWnd:HWND
	LOCAL	s1:WNDCLASS
	LOCAL	s2:MSG

	cmp	hPrevInstance,0		;=0 if no previous instance.
	je	yes1st
	jmp	createwin
yes1st:
;Setup the window class structure for REGISTERCLASS()...
	mov 	s1.Style,3
	lea	di,s1.lpfnwndproc
	mov	[di],OFFSET ASMDEMOProc
	mov	[di+2],SEG ASMDEMOProc
	mov 	s1.CbClsExtra,0
	mov 	s1.CbWndExtra,0
	mov	ax,hInstance
	mov 	s1.HInstance,ax

  invoke LOADICON,null, IDI_APPLICATION
	mov 	s1.@HIcon,ax

  invoke LOADCURSOR,null, IDC_ARROW
	mov 	s1.@HCursor,ax

	mov 	s1.hbrBackground,COLOR_BACKGROUND
	mov	ax,OFFSET szASMDEMO1name
	lea	di,s1.lpszmenuname
	mov 	[di],ax
	mov 	[di+2],ds
	lea	di,s1.lpszclassname
	mov 	[di],ax
	mov 	[di+2],ds

	lea	ax,s1
  invoke REGISTERCLASS,ss::ax
	or	ax,ax
	jne	createwin
	jmp	quitwinmain

createwin:
 invoke CREATEWINDOW, ADDR szASMDEMO1name, ADDR szwintitle, 00CF0000h,\
				   150, 0, 400, 300, 0, 0, hInstance, 0
	mov 	@hWnd,ax
        mov     handlemain,ax           ;useful to save static also.
  invoke SHOWWINDOW,ax,nCmdShow
  invoke UPDATEWINDOW,@hWnd
	jmp	SHORT messageloop			;go to the main message-loop.


;This is the main message loop, in which Windows waits for messages
mainloop:
	lea	ax,s2
	invoke	TRANSLATEMESSAGE,ss::ax
	lea	ax,s2
	invoke	DISPATCHMESSAGE,ss::ax
messageloop:
	lea 	ax,s2
	invoke GETMESSAGE, ss::ax, null, null, null
	or	ax,ax
	jne	mainloop

;GetMessage() returns FALSE (AX=0) if a "quit" message...
;so here we are quiting....
	mov	ax,s2.WPARAM		;return wparam to windows OS.
quitwinmain:
	ret
WINMAIN	ENDP
;....................................................................

;.....................................................................
ASMDEMOPROC	 PROTO FAR PASCAL,  :HWND, :WORD, :SWORD, :SDWORD
ASMDEMOPROC	PROC FAR PASCAL, ihWnd:HWND, iMessage:WORD, iwParam:SWORD,\
				 ilParam:SDWORD
	LOCAL	dummy [5]:WORD
	LOCAL	@hDC:HDC
	LOCAL	s3:PAINTSTRUCT

	mov	ax,imessage		;get message-type.
	.IF	ax==WM_CREATE		;message received after CreateWindow()
	call	xcreate			;function is called.
	.ELSEIF	ax==WM_DESTROY		;message received if a window is closed.
	call	xquitmessage            ;posts WM_QUIT and does cleanup.
	.ELSEIF	ax==WM_PAINT		;message received if Windows has (already)
	call	xpaint
	.ELSEIF	ax==WM_COMMAND		;any selection of the menu will produce
	call	xmenu			;this message.
	.ELSEIF	ax==WM_LBUTTONDOWN	;one of many mouse messages.
	call	xlbutton
	.ELSEIF	ax==WM_CHAR		;message that a key pressed.
	call	xchar
        .ELSE
	invoke DEFWINDOWPROC,ihWnd,imessage,iwParam, ilParam
        ret
        .ENDIF
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
	ret
;........................................
xlbutton:
        ret
;.................................
xcreate:
        call    makering0selector

      	invoke	GETSTOCKOBJECT,OEM_FIXED_FONT
	mov	hOemFont,ax		;handle to font.
        ret
;..................................
xchar:
 in al,61h      ;####turn off tone
 and al,0FCh    ;####
 out 61h,al     ;####
        ret
;...................................
xpaint:
	lea	ax,s3  			;ss:ax -- far-addr of paint-structure.
  invoke BEGINPAINT,ihWnd,ss::ax
	mov	@hDC,ax			;hDC -- display-context, required
;For this simple demo, any redraw of the Window will cause output of our
;"hullo world" string....
  invoke	SELECTOBJECT,ax,hOemFont
  invoke	TEXTOUT,@hDC,10,20, ADDR soutstring,11
	lea	ax,s3  			; -- far-addr of paint-structure.
  invoke	ENDPAINT,ihWnd,ss::ax
        ret
;........................
xmenu:
	cmp	WORD PTR ilParam,0	;low-half of lParam
	jne	zxcv			;test if a menu-message.
	cmp	iwParam,IDM_QUIT		;wParam.
	jne	notquit
        call    xquitmessage
        jmp     zxcv
notquit:
	cmp	iwParam,IDM_ABOUT
	jne	zxcv			;no other menu items.
		;let's put up a message about this program...
 	invoke MESSAGEBOX, ihWnd, ADDR szaboutstr, ADDR sztitlestr, MB_OK

        cli
        call RING0CALLGATE      ;will call ring-0 code
; in al,61h      ;####turn off tone
; and al,0FCh    ;####
; out 61h,al     ;####
        sti

zxcv:        ret
;.........................

ASMDEMOPROC	ENDP
;.....................................................................
xquitmessage    PROC
	invoke	POSTQUITMESSAGE,0
        call    freeourselectors
        ret
xquitmessage    ENDP
;..................................................................
errormsgproc    PROC
;entered with ds:si pointing to message....
 invoke MESSAGEBOX,handlemain, ds::si, ADDR szerror, MB_OK+MB_ICONEXCLAMATION
        ret
errormsgproc    ENDP
;....................................................................
.DATA
dpmiproc        DD      0       ;dpmi extensions entry point.
RING0CALLGATE LABEL DWORD       ;use this to call ring-0 code.
ring0_off       DW      0       ;callgate selector for RING0FUNC
ring0_cs        DW      0       ;       /
ms_dos_str      DB      "MS-DOS",0
ldt_selector    DW      0       ;for direct writing to ldt.
descriptor_selector DW  0       ;ring0, cannot be accessed directly.
ring0errormsg DB "There was an error creating ring 0 access... aborting program.",0
PUBLIC  tss_selector_alias
tss_selector_alias    DW      0       ;selector to the current tss.
PUBLIC  descdword1
PUBLIC  descdword2
descdword2      DD      0               ;used to build a gdt entry.
descdword1      DD      0               ;       / (high half)
PUBLIC  flatdatalin
flatdatalin     DD      0       ;Flat linear addr of this progs data seg.

.CODE
makering0selector PROC

        LOCAL cssize:WORD
        LOCAL flatlin:DWORD

        invoke GLOBALPAGELOCK,cs
        cmp     ax,0
        je      lockfailed

        lea     si,ms_dos_str
        mov     ax,168Ah        ;get dpmi extensions entry point.
        int     2Fh             ;-->es:di (undocumented)
;***        cmp     al,0                 ?????
;***        jne      extensionsnotfnd
        mov     WORD PTR[dpmiproc],di   ;save entry point
        mov     WORD PTR[dpmiproc+2],es ;       /
        mov     ax,100h         ;undocumented
        call    dpmiproc        ;-->ax=selector to ldt.
        jc      extensionsnotfnd
        mov     ldt_selector,ax
        mov     es,ax


;create a ring-0 32-bit descriptor...
;         push   es
;        invoke  ALLOCSELECTOR,cs        ;-->ax=alias to cs.
;         pop    es
;        cmp     ax,0
;        je      selectorerror
;        and     ax,0FFF8h               ;get offset of descriptor in ldt.
;        mov     bx,ax
;        mov     al,es:[bx+5]            ;get access-rights byte.
;        and     al,10011111b            ;clear dpl field.#
;        mov     es:[bx+5],al
;        mov     al,es:[bx+6]            ;get granularity & seg-size bits.
;        or      al,01000000b            ;set bit7, for 32-bit.
;        mov     es:[bx+6],al
;        or      bx,0100b                ;set bit-2, selects ldt.leave dpl=0.#
;        mov     di,bx                   ;temp save.
;        mov     descriptor_selector,bx  ;save.

;find the linear address of CS...
        mov     bx,cs
        and 	bx,0FFF8h                   ;get offset in ldt
        mov     ax,es:[bx]              ;get size of segment.
        mov     cssize,ax
        mov     ax,es:[bx+2]            ;get lo-half of lin.addr.
        mov     WORD PTR flatlin,ax
        mov     al,es:[bx+4]            ;get hi-half of lin. addr.
        mov     ah,es:[bx+7]            ;       /
        mov     WORD PTR flatlin+2,ax
;calculate FLAT linear address of ring0func...
        mov     ax,WORD PTR flatlin
        add     ax,ring0func            ;note: "OFFSET" is optional
        jnc     moppi
        mov	bx,WORD PTR flatlin+2
        inc     bx
        mov     WORD PTR flatlin+2,bx
moppi:
        mov     WORD PTR flatlin,ax



;create callgate to ring0func.....
         push   es
        invoke  ALLOCSELECTOR,0         ;create a descriptor in ldt.
         pop    es
        cmp     ax,0
        je      selectorerror
        mov     ring0_cs,ax             ;save final selector.
        and     ax,0FFF8h               ;get offset of descriptor in ldt.
        mov     bx,ax
        mov     ax,WORD PTR flatlin     ;my ring0 linear address
        mov     es:[bx],ax       	;       /
        mov     ax,WORD PTR flatlin+2   ;       /
        mov     es:[bx+6],ax    	;       /
        mov     WORD PTR es:[bx+2],28h  ;FLAT code selector(in gdt).
        mov     BYTE PTR es:[bx+4],0 ;04        ;****??dwords copied to stack.
        mov     BYTE PTR es:[bx+5],11101100b    ;present=1,dpl=3,app=00,type=C
        			            ;      (type=C: 386 callgate)


;find the FLAT linear address of this programs data segment...
        mov     bx,ds
        and 	bx,0FFF8h                   ;get offset in ldt
        mov     ax,es:[bx+2]            ;get lo-half of lin.addr.
        mov     WORD PTR flatdatalin,ax
        mov     al,es:[bx+4]            ;get hi-half of lin. addr.
        mov     ah,es:[bx+7]            ;       /
        mov     WORD PTR flatdatalin+2,ax


;create a ring-0 descriptor for data segment...
;         push   es
;        invoke  ALLOCSELECTOR,ds        ;-->ax=alias to ds.
;         pop    es
;        cmp     ax,0
;        je      selectorerror
;        and     ax,0FFF8h               ;get offset of descriptor in ldt.
;        mov     bx,ax
;        mov     al,es:[bx+5]            ;get access-rights byte.
;        and     al,10011111b            ;clear dpl field.#
;        mov     es:[bx+5],al
;        mov     al,es:[bx+6]            ;get granularity & seg-size bits.
;        or      al,01000000b            ;set bit7, for 32-bit.
;        mov     es:[bx+6],al
;        or      bx,0100b                ;set bit-2, selects ldt.leave dpl=0.#
;        mov     di,bx                   ;temp save.
;        mov     ring0_ds_ss,bx  ;save.


qwert:  jmp     SHORT qwerty
lockfailed:
extensionsnotfnd:
selectorerror:
        lea     si,ring0errormsg
        call 	errormsgproc
        call    xquitmessage            ;quit program.
qwerty:
        ret
makering0selector ENDP
;....................................
freeourselectors PROC
        invoke  FREESELECTOR,descriptor_selector
        invoke  FREESELECTOR,ring0_cs
        invoke GLOBALPAGEUNLOCK,cs
        ret
freeourselectors ENDP

;.....................................................................

;....................................................................
 END	start
