

Undefined_Device_ID		EQU	00000h
VMM_Device_ID			EQU	00001h	; Used for dynalink table
Debug_Device_ID 		EQU	00002h
VPICD_Device_ID 		EQU	00003h
VDMAD_Device_ID 		EQU	00004h
VTD_Device_ID			EQU	00005h
V86MMGR_Device_ID		EQU	00006h
PageSwap_Device_ID		EQU	00007h
Parity_Device_ID		EQU	00008h
Reboot_Device_ID		EQU	00009h
VDD_Device_ID			EQU	0000Ah
VSD_Device_ID			EQU	0000Bh
VMD_Device_ID			EQU	0000Ch
VKD_Device_ID			EQU	0000Dh
VCD_Device_ID			EQU	0000Eh
VPD_Device_ID			EQU	0000Fh
BlockDev_Device_ID		EQU	00010h
VMCPD_Device_ID 		EQU	00011h
EBIOS_Device_ID 		EQU	00012h
BIOSXlat_Device_ID		EQU	00013h
VNETBIOS_Device_ID		EQU	00014h
DOSMGR_Device_ID		EQU	00015h
WINLOAD_Device_ID		EQU	00016h
SHELL_Device_ID 		EQU	00017h
VMPoll_Device_ID		EQU	00018h
VPROD_Device_ID 		EQU	00019h
DOSNET_Device_ID		EQU	0001Ah
VFD_Device_ID			EQU	0001Bh
VDD2_Device_ID			EQU	0001Ch	; Secondary display adapter
WINDEBUG_Device_ID		EQU	0001Dh
TSRLoad_Device_ID		EQU	0001Eh	; TSR instance utility ID
BiosHook_Device_ID		EQU	0001Fh	; Bios interrupt hooker VxD
Int13_Device_ID 		EQU	00020h
PageFile_Device_ID		EQU	00021h	; Paging File device
SCSI_Device_ID			EQU     00022h  ; SCSI device
MCA_POS_Device_ID		EQU     00023h  ; MCA_POS device
SCSIFD_Device_ID		EQU	00024h	; SCSI FastDisk device
VPEND_Device_ID 		EQU	00025h	; Pen device
APM_Device_ID			EQU	00026h	; Power Management device

;
;   Initialization order equates.  Devices are initialized in order from
;   LOWEST to HIGHEST.	If 2 or more devices have the same initialization
;   order value, then they are initialized in order of occurance, so a
;   specific order is not guaranteed.  Holes have been left to allow maximum
;   flexibility in ordering devices.
;

VMM_Init_Order			EQU	000000000h
APM_Init_Order			EQU	001000000h
Debug_Init_Order		EQU	004000000h
BiosHook_Init_Order		EQU	006000000h
VPROD_Init_Order		EQU	008000000h
VPICD_Init_Order		EQU	00C000000h
VTD_Init_Order			EQU	014000000h
PageFile_Init_Order		EQU	018000000h
PageSwap_Init_Order		EQU	01C000000h
Parity_Init_Order		EQU	020000000h
Reboot_Init_Order		EQU	024000000h
EBIOS_Init_Order		EQU	026000000h
VDD_Init_Order			EQU	028000000h
VSD_Init_Order			EQU	02C000000h
VCD_Init_Order			EQU	030000000h
VMD_Init_Order			EQU	034000000h
VKD_Init_Order			EQU	038000000h
VPD_Init_Order			EQU	03C000000h
BlockDev_Init_Order		EQU	040000000h
MCA_POS_Init_Order		EQU	041000000h
SCSIFD_Init_Order		EQU	041400000h
SCSIMaster_Init_Order	        EQU     041800000h
Int13_Init_Order		EQU	042000000h
VFD_Init_Order			EQU	044000000h
VMCPD_Init_Order		EQU	048000000h
BIOSXlat_Init_Order		EQU	050000000h
VNETBIOS_Init_Order		EQU	054000000h
DOSMGR_Init_Order		EQU	058000000h
DOSNET_Init_Order		EQU	05C000000h
WINLOAD_Init_Order		EQU	060000000h
VMPoll_Init_Order		EQU	064000000h

Undefined_Init_Order		EQU	080000000h

WINDEBUG_Init_Order		EQU	081000000h
VDMAD_Init_Order		EQU	090000000h
V86MMGR_Init_Order		EQU	0A0000000h

Undef_Touch_Mem_Init_Order	EQU	0A8000000h  ; Device that must touch
						    ; memory in 1st Mb at
						    ; crit init (after V86mmgr)
SHELL_Init_Order		EQU	0B0000000h

;*********************************************************************


;******************************************************************************
;			    V M M   S E R V I C E S
;******************************************************************************

Get_VMM_Version		=	0		; MUST REMAIN SERVICE 0!

Get_Cur_VM_Handle       =       0001
Test_Cur_VM_Handle      =       0002
Get_Sys_VM_Handle       =       0003
Test_Sys_VM_Handle       =       0004
Validate_VM_Handle       =       0005

Get_VMM_Reenter_Count       =       0006
Begin_Reentrant_Execution       =       0007
End_Reentrant_Execution       =       0008

Install_V86_Break_Point       =       0009
Remove_V86_Break_Point        =       0010
Allocate_V86_Call_Back        =       0011
Allocate_PM_Call_Back         =       0012

Call_When_VM_Returns          =       0013

Schedule_Global_Event         =       0014
Schedule_VM_Event             =       0015
Call_Global_Event             =       0016
Call_VM_Event                 =       0017
Cancel_Global_Event           =       0018
Cancel_VM_Event               =       0019
Call_Priority_VM_Event        =       0020
Cancel_Priority_VM_Event       =       0021

Get_NMI_Handler_Addr          =       00022
Set_NMI_Handler_Addr          =       00023
Hook_NMI_Event                =       00024

Call_When_VM_Ints_Enabled       =       00025
Enable_VM_Ints                  =       00026
Disable_VM_Ints                 =       00027

Map_Flat                        =       00028
Map_Lin_To_VM_Addr              =       00029

;
;   Scheduler services
;
Adjust_Exec_Priority            =       00030
Begin_Critical_Section          =       00031
End_Critical_Section            =       00032
End_Crit_And_Suspend            =       00033
Claim_Critical_Section          =       00034
Release_Critical_Section        =       00035
Call_When_Not_Critical          =       00036
Create_Semaphore                =       00037
Destroy_Semaphore               =       00038
Wait_Semaphore                  =       00039
Signal_Semaphore                =       00040
Get_Crit_Section_Status         =       00041
Call_When_Task_Switched         =       00042
Suspend_VM                      =       00043
Resume_VM                       =       00044
No_Fail_Resume_VM               =       00045
Nuke_VM                         =       00046
Crash_Cur_VM                    =       00047

Get_Execution_Focus             =       00048
Set_Execution_Focus             =       00049
Get_Time_Slice_Priority         =       00050
Set_Time_Slice_Priority         =       00051
Get_Time_Slice_Granularity       =       00052
Set_Time_Slice_Granularity       =       00053
Get_Time_Slice_Info              =       00054
Adjust_Execution_Time            =       00055
Release_Time_Slice               =       00056
Wake_Up_VM                       =       00057
Call_When_Idle                   =       00058

Get_Next_VM_Handle               =       00059

;
;   Time-out and system timer services
;
Set_Global_Time_Out              =       00060
Set_VM_Time_Out                  =       00061
Cancel_Time_Out                  =       00062
Get_System_Time                  =       00063
Get_VM_Exec_Time                 =       00064

Hook_V86_Int_Chain               =       00065
Get_V86_Int_Vector               =       00066
Set_V86_Int_Vector               =       00067
Get_PM_Int_Vector                =       00068
Set_PM_Int_Vector                =       00069

Simulate_Int                     =       00070
Simulate_Iret                    =       00071
Simulate_Far_Call                =       00072
Simulate_Far_Jmp                 =       00073
Simulate_Far_Ret                 =       00074
Simulate_Far_Ret_N               =       00075
Build_Int_Stack_Frame            =       00076

Simulate_Push                    =       00077
Simulate_Pop                     =       00078

;
; Heap Manager
;
_HeapAllocate                    =       00079
_HeapReAllocate                  =       00080
_HeapFree                        =       00081
_HeapGetSize                     =       00082

; ---------------------------------------------------
;
;	 Flags for heap allocator calls
;
; ---------------------------------------------------


HeapZeroInit	equ	00000000000000000000000000000001B
HeapZeroReInit	equ	00000000000000000000000000000010B
HeapNoCopy	equ	00000000000000000000000000000100B

; NOTE: HIGH 8 BITS (bits 24-31) are reserved


;
; Page Manager
;
_PageAllocate                    =       00083
_PageReAllocate                  =       00084
_PageFree                        =       00085
_PageLock                        =       00086
_PageUnLock                      =       00087
_PageGetSizeAddr                 =       00088
_PageGetAllocInfo                =       00089
_GetFreePageCount                =       00090
_GetSysPageCount                 =       00091
_GetVMPgCount                    =       00092
_MapIntoV86                      =       00093
_PhysIntoV86                     =       00094
_TestGlobalV86Mem                =       00095
_ModifyPageBits                  =       00096
_CopyPageTable                   =       00097
_LinMapIntoV86                   =       00098
_LinPageLock                     =       00099
_LinPageUnLock                   =       000100
_SetResetV86Pageable             =       000101
_GetV86PageableArray             =       000102
_PageCheckLinRange               =       000103
_PageOutDirtyPages               =       000104
_PageDiscardPages                =       000105

; ---------------------------------------------------
;
;	 Flags for other page allocator calls
;
; ---------------------------------------------------
PageZeroInit		equ	00000000000000000000000000000001B
PageUseAlign		equ	00000000000000000000000000000010B
PageContig		equ	00000000000000000000000000000100B
PageFixed		equ	00000000000000000000000000001000B
PageDEBUGNulFault	equ	00000000000000000000000000010000B
PageZeroReInit		equ	00000000000000000000000000100000B
PageNoCopy		equ	00000000000000000000000001000000B
PageLocked		equ	00000000000000000000000010000000B
PageLockedIfDP		equ	00000000000000000000000100000000B
PageSetV86Pageable	equ	00000000000000000000001000000000B
PageClearV86Pageable	equ	00000000000000000000010000000000B
PageSetV86IntsLocked	equ	00000000000000000000100000000000B
PageClearV86IntsLocked	equ	00000000000000000001000000000000B
PageMarkPageOut 	equ	00000000000000000010000000000000B
PagePDPSetBase		equ	00000000000000000100000000000000B
PagePDPClearBase	equ	00000000000000001000000000000000B
PageDiscard		equ	00000000000000010000000000000000B
PagePDPQueryDirty	equ	00000000000000100000000000000000B
;
; New for 3.10
;
PageMapFreePhysReg	equ	00000000000001000000000000000000B



; NOTE: HIGH 8 BITS (bits 24-31) are reserved

;
; Informational services
;
_GetNulPageHandle                =       000106
_GetFirstV86Page                 =       000107
_MapPhysToLinear                 =       000108
_GetAppFlatDSAlias               =       000109
_SelectorMapFlat                 =       000110
_GetDemandPageInfo               =       000111
;
; Data structure for _GetDemandPageInfo
;
DemandInfoStruc struc
DILin_Total_Count     dd	      ?       ; # pages in linear address space
DIPhys_Count	      dd	      ?       ; Count of phys pages
DIFree_Count	      dd	      ?       ; Count of free phys pages
DIUnlock_Count	      dd	      ?       ; Count of unlocked Phys Pages
DILinear_Base_Addr    dd	      ?       ; Base of pageable address space
DILin_Total_Free      dd	      ?       ; Total Count of free linear pages
DIReserved	      dd      10 dup (?)      ; Resvd for expansion
DemandInfoStruc ends

_GetSetPageOutCount              =       000112
;
; Flags bits for _GetSetPageOutCount
;
GSPOC_F_Get	equ	00000000000000000000000000000001B

;
; Device VM page manager
;
Hook_V86_Page                    =       000113
_Assign_Device_V86_Pages         =       000114
_DeAssign_Device_V86_Pages       =       000115
_Get_Device_V86_Pages_Array       =       000116
MMGR_SetNULPageAddr               =       000117

;
; GDT/LDT management
;
_Allocate_GDT_Selector            =       000118
_Free_GDT_Selector                =       000119
_Allocate_LDT_Selector            =       000120
_Free_LDT_Selector                =       000121
_BuildDescriptorDWORDs            =       000122
;
; Flag equates for _BuildDescriptorDWORDs
;
BDDExplicitDPL	EQU	00000000000000000000000000000001B
;
; Flag equates for _Allocate_LDT_Selector
;
ALDTSpecSel	EQU	00000000000000000000000000000001B

_GetDescriptor                    =       000123
_SetDescriptor                    =       000124


_MMGR_Toggle_HMA                  =       0003
;
; Flag equates for _MMGR_Toggle_HMA
;
MMGRHMAPhysical EQU	00000000000000000000000000000001B
MMGRHMAEnable	EQU	00000000000000000000000000000010B
MMGRHMADisable	EQU	00000000000000000000000000000100B
MMGRHMAQuery	EQU	00000000000000000000000000001000B


Get_Fault_Hook_Addrs              =       0003
Hook_V86_Fault                    =       0003
Hook_PM_Fault                     =       0003
Hook_VMM_Fault                    =       0003
Begin_Nest_V86_Exec               =       0003
Begin_Nest_Exec                   =       0003
Exec_Int                          =       0003
Resume_Exec                       =       0003
End_Nest_Exec                     =       0003

Allocate_PM_App_CB_Area       =       0003
Get_Cur_PM_App_CB                        =       0003

Set_V86_Exec_Mode                        =       0003
Set_PM_Exec_Mode                         =       0003

Begin_Use_Locked_PM_Stack                =       0003
End_Use_Locked_PM_Stack                  =       0003

Save_Client_State                        =       0003
Restore_Client_State                     =       0003

Exec_VxD_Int                             =       0003

Hook_Device_Service                      =       0003

Hook_Device_V86_API                      =       0003
Hook_Device_PM_API                       =       0003

System_Control                           =       0003

;
;   I/O and software interrupt hooks
;
Simulate_IO                              =       0003
Install_Mult_IO_Handlers                 =       0003
Install_IO_Handler                       =       0003
Enable_Global_Trapping                   =       0003
Enable_Local_Trapping                    =       0003
Disable_Global_Trapping                  =       0003
Disable_Local_Trapping                   =       0003


;
;   Linked List Abstract Data Type Services
;
List_Create                              =       0003
List_Destroy                             =       0003
List_Allocate                            =       0003
List_Attach                              =       0003
List_Attach_Tail                         =       0003
List_Insert                              =       0003
List_Remove                              =       0003
List_Deallocate                          =       0003
List_Get_First                           =       0003
List_Get_Next                            =       0003
List_Remove_First                        =       0003

;
;   Flags used by List_Create
;
LF_Async		EQU	00000001b
LF_Async_Bit		EQU	0
LF_Use_Heap		EQU	00000010b
LF_Use_Heap_Bit 	EQU	1
LF_Alloc_Error		EQU	00000100b
LF_Alloc_Error_Bit	EQU	2


;==============================================================================
;	I N I T I A L I Z A T I O N   P R O C E D U R E S
;------------------------------------------------------------------------------


;
; Instance data manager
;
_AddInstanceItem                         =       0003
;
; Data structure for _AddInstanceItem
;
InstDataStruc struc
InstLinkF	      dd	      0       ; RESERVED SET TO 0
InstLinkB	      dd	      0       ; RESERVED SET TO 0
InstLinAddr	      dd	      ?       ; Linear address of start of block
InstSize	      dd	      ?       ; Size of block in bytes
InstType	      dd	      ?       ; Type of block
InstDataStruc ends
;
; Values for InstType
;
INDOS_Field	equ	100h	; Bit indicating INDOS switch requirements
ALWAYS_Field	equ	200h	; Bit indicating ALWAYS switch requirements

;
; System structure data manager
;
_Allocate_Device_CB_Area             =       0003
_Allocate_Global_V86_Data_Area       =       0003
_Allocate_Temp_V86_Data_Area         =       0003
_Free_Temp_V86_Data_Area             =       0003

;
; Flag bits for _Allocate_Global_V86_Data_Area
;
GVDAWordAlign		EQU		00000000000000000000000000000001B
GVDADWordAlign		EQU		00000000000000000000000000000010B
GVDAParaAlign		EQU		00000000000000000000000000000100B
GVDAPageAlign		EQU		00000000000000000000000000001000B
GVDAInstance		EQU		00000000000000000000000100000000B
GVDAZeroInit		EQU		00000000000000000000001000000000B
GVDAReclaim		EQU		00000000000000000000010000000000B
;
; New for 3.10
;
GVDAInquire		EQU		00000000000000000000100000000000B
GVDAHighSysCritOK	EQU		00000000000000000001000000000000B

;
; Initialization information calls (win.ini and environment parameters)
;
Get_Profile_Decimal_Int              =       0003
Convert_Decimal_String               =       0003
Get_Profile_Fixed_Point              =       0003
Convert_Fixed_Point_String           =       0003
Get_Profile_Hex_Int                  =       0003
Convert_Hex_String                   =       0003
Get_Profile_Boolean                  =       0003
Convert_Boolean_String               =       0003
Get_Profile_String                   =       0003
Get_Next_Profile_String              =       0003
Get_Environment_String               =       0003
Get_Exec_Path                        =       0003
Get_Config_Directory                 =       0003
OpenFile                             =       0003
Get_PSP_Segment                      =       0003
GetDOSVectors                        =       0003
Get_Machine_Info                                =       0003

GMIF_80486	EQU	00010000h
GMIF_80486_Bit	EQU	10h
GMIF_PCXT	EQU	00020000h
GMIF_PCXT_Bit	EQU	11h
GMIF_MCA	EQU	00040000h
GMIF_MCA_Bit	EQU	12h
GMIF_EISA	EQU	00080000h
GMIF_EISA_Bit	EQU	13h


;
; Following service is not restricted to initialization
;
GetSet_HMA_Info                                 =       0003
Set_System_Exit_Code                            =       0003

Fatal_Error_Handler                             =       0003
Fatal_Memory_Error                              =       0003

;
;   Called by VTD only
;
Update_System_Clock                             =       0003

;==============================================================================
;		    D E B U G G I N G	E X T E R N S
;==============================================================================

Test_Debug_Installed		       =       0003; Valid call in retail also

Out_Debug_String		       =       0003; Valid in DEBLEVEL=1
Out_Debug_Chr                          =       0003
In_Debug_Chr                           =       0003
Debug_Convert_Hex_Binary               =       0003
Debug_Convert_Hex_Decimal              =       0003

Debug_Test_Valid_Handle                =       0003
Validate_Client_Ptr                    =       0003
Test_Reenter                           =       0003
Queue_Debug_String                     =       0003
Log_Proc_Call                          =       0003
Debug_Test_Cur_VM                      =       0003

Get_PM_Int_Type                        =       0003
Set_PM_Int_Type                        =       0003

Get_Last_Updated_System_Time           =       0003
Get_Last_Updated_VM_Exec_Time          =       0003

; for DBCS Enabling
Test_DBCS_Lead_Byte                    =       0003

;*************************************************************************
;*************************************************************************
;
; END OF 3.00 SERVICE TABLE MUST NOT SHUFFLE SERVICES BEFORE THIS POINT
;	FOR COMPATIBILITY.
;

_AddFreePhysPage                     =       0003
_PageResetHandlePAddr                           =       0003
_SetLastV86Page                      =       0003
_GetLastV86Page                                 =       0003
_MapFreePhysReg                                 =       0003
_UnmapFreePhysReg                               =       0003
_XchgFreePhysReg                                =       0003
_SetFreePhysRegCalBk                 =       0003
Get_Next_Arena                       =       0003
Get_Name_Of_Ugly_TSR                 =       0003
Get_Debug_Options                    =       0003

;
; Bits for the ECX return of Get_Next_Arena
;
GNA_HiDOSLinked  equ	 0000000000000010B	; High DOS arenas were linked in
						;   when WIN386 was started
GNA_IsHighDOS	 equ	 0000000000000100B	; High DOS arenas do exist

Set_Physical_HMA_Alias               =       0003
_GetGlblRng0V86IntBase               =       0003
_Add_Global_V86_Data_Area            =       0003

GetSetDetailedVMError                           =       0003
;
; Error code values for the GetSetDetailedVMError service. PLEASE NOTE
;   that all of these error code values need to have bits set in the high
;   word. This is to prevent collisions with other VMDOSAPP standard errors.
;   Also, the low word must be non-zero.
;
; First set of errors (high word = 0001) are intended to be used
;   when a VM is CRASHED (VNE_Crashed or VNE_Nuked bit set on
;   VM_Not_Executeable).
;
; PLEASE NOTE that each of these errors (high word == 0001) actually
;   has two forms:
;
;	0001xxxxh
;	8001xxxxh
;
;   The device which sets the error initially always sets the error with
;   the high bit CLEAR. The system will then optionally set the high bit
;   depending on the result of the attempt to "nicely" crash the VM. This
;   bit allows the system to tell the user whether the crash is likely or
;   unlikely to destabalize the system.
;
GSDVME_PrivInst 	equ	00010001h	; Privledged instruction
GSDVME_InvalInst	equ	00010002h	; Invalid instruction
GSDVME_InvalPgFlt	equ	00010003h	; Invalid page fault
GSDVME_InvalGpFlt	equ	00010004h	; Invalid GP fault
GSDVME_InvalFlt 	equ	00010005h	; Invalid fault, not any of abv
GSDVME_UserNuke 	equ	00010006h	; User requested NUKE of running
						;    VM
GSDVME_DevNuke		equ	00010007h	; Device specific problem
GSDVME_DevNukeHdwr	equ	00010008h	; Device specific problem,
						;   invalid hardware fiddling
						;   by VM (invalid I/O)
GSDVME_NukeNoMsg	equ	00010009h	; Supress standard messgs,
						;   SHELL_Message used for
						;   custom msg.

GSDVME_OkNukeMask	equ	80000000h	; "Nice nuke" bit

;
; Second set of errors (high word = 0002) are intended to be used
;   when a VM start up is failed (VNE_CreateFail, VNE_CrInitFail, or
;   VNE_InitFail bit set on VM_Not_Executeable).
;
GSDVME_InsMemV86	equ	00020001h	; base V86 mem	   - V86MMGR
GSDVME_InsV86Space	equ	00020002h	; Kb Req too large - V86MMGR
GSDVME_InsMemXMS	equ	00020003h	; XMS Kb Req	   - V86MMGR
GSDVME_InsMemEMS	equ	00020004h	; EMS Kb Req	   - V86MMGR
GSDVME_InsMemV86Hi	equ	00020005h	; Hi DOS V86 mem   - DOSMGR
						;		     V86MMGR
GSDVME_InsMemVid	equ	00020006h	; Base Video mem   - VDD
GSDVME_InsMemVM 	equ	00020007h	; Base VM mem	   - VMM
						;   CB, Inst Buffer
GSDVME_InsMemDev	equ	00020008h	; Couldn't alloc base VM
						;   memory for device.
GSDVME_CrtNoMsg 	equ	00020009h	; Supress standard messgs,
						;   SHELL_Message used for
						;   custom msg.
Is_Debug_Chr                                    =       0003
;
; Mono_Out services
;
Clear_Mono_Screen                               =       0003
Out_Mono_Chr                                    =       0003
Out_Mono_String                                 =       0003
Set_Mono_Cur_Pos                                =       0003
Get_Mono_Cur_Pos                                =       0003
Get_Mono_Chr                                    =       0003

;
;   Service locates a byte in ROM
;
Locate_Byte_In_ROM                   =       0003

Hook_Invalid_Page_Fault                         =       0003
Unhook_Invalid_Page_Fault                       =       0003
;
; This is the structure of the "invalid page fault information"
; which is pointed to by EDI when Invalid page fault hookers
; are called.
;
; page faults can occur on a VM which is not current by touching the VM at
;   its high linear address. In this case, IPF_FaultingVM may not = the
;   current VM, it will be set to the VM whos high linear address was touched.
;
IPF_Data	struc

  IPF_LinAddr	    dd	    ?	; CR2 address of fault
  IPF_MapPageNum    dd	    ?	; Possible converted page # of fault
  IPF_PTEEntry	    dd	    ?	; Contents of PTE that faulted
  IPF_FaultingVM    dd	    ?	; May not = Current VM (IPF_V86PgH set)
  IPF_Flags	    dd	    ?	; Flags

IPF_Data	ends
;
; Flag bits of IPF_Flags
;
			; Page directory entry not-present (not pres page table)
IPF_PgDir	equ	000000000000000000000000000000001b
			; Unexpected not present Page in V86
IPF_V86Pg	equ	000000000000000000000000000000010b
			; Unexpected not present Page in V86 at high linear
IPF_V86PgH	equ	000000000000000000000000000000100b
			; page has invalid not present type
IPF_InvTyp	equ	000000000000000000000000000001000b
			; pageswap device couldn't page for some reason
IPF_PgErr	equ	000000000000000000000000000010000b
			; re-entrant page fault
IPF_ReFlt	equ	000000000000000000000000000100000b
			; Page fault caused by a VxD
IPF_VMM 	equ	000000000000000000000000001000000b
			; Page fault caused by VM running in Prot Mode
IPF_PM		equ	000000000000000000000000010000000b
			; Page fault caused by VM running in V86 Mode
IPF_V86 	equ	000000000000000000000000100000000b

Set_Delete_On_Exit_File                         =       0003

Close_VM                                        =       0003
;
;   Flags for Close_VM service
;
CVF_Continue_Exec   equ 00000001b
CVF_Continue_Exec_Bit equ 0

Enable_Touch_1st_Meg		       =       0003; Debugging only
Disable_Touch_1st_Meg		       =       0003; Debugging only

Install_Exception_Handler              =       0003
Remove_Exception_Handler               =       0003

Exception_Handler_Struc STRUC
EH_Reserved	dd	?
EH_Start_EIP	dd	?
EH_End_EIP	dd	?
EH_Handler	dd	?
Exception_Handler_Struc ENDS

Get_Crit_Status_No_Block               =       0003


;*************************************************************************
;*************************************************************************
;*************************************************************************
;
; END OF 3.10 SERVICE TABLE MUST NOT SHUFFLE SERVICES BEFORE THIS POINT
;	FOR COMPATIBILITY.
;
