
;LV-DLL.ASM --> LV-DLL.DLL
;WRITTEN FOR LABVIEW.
;This DLL installs an interrupt handler.
;It runs at ring-3, and is written for 16-bit Windows.
;This DLL exports function, ISR_FUNC(), that must be called by LabView,
;Installs the hook on 1st entry, subsequently just returns with ncount.
;Prototype is: uint16 ISR_FUNC(intnum:uint16)
;intnum is the interupt to hook.
;ncount is the number of times interrupt has occurred.

;***FURTHER READING****
;***"Windows Assembly Language and Systems Programming"
;***by Barry Kauler, published by Prentice Hall.
;.....................................................................

.MODEL MEDIUM, FARSTACK    ;****PASCAL, FARSTACK
.286
INCLUDE winasm60.inc            ;or, use the WIN.INC supplied with masm 6.1.

PROLOG  MACRO
	mov     ax, ds                  ; Must be 1st, since Windows overwrites
	nop                             ; Placeholder for 3rd byte
	inc     bp                      ; Push odd BP.  Not required, but
	push    bp                      ;   allows CodeView to recognize stack
	mov     bp, sp                  ; Set up stack frame to access params
	push    ds                      ; Save DS
	mov     ds, ax                  ; Point DS to DLL's data segment
	ENDM

EPILOG  MACRO
	pop     ds                      ; Recover original DS
	pop     bp                      ;   and BP+1
	dec     bp                      ; Reset to original BP
	ENDM

;*************************************************************************
.DATA
        DB 16 DUP(0)    ;reserved area.
doldvector DD   0
ncount     DW   0               ;counts interrupts, so as not to lose any.
hooked     DB   0               ;prevent multiple hooks.
intnumx    DW   0               ;int that has been hooked.
toggle     DB   0               ;used to toggle beep on/off.

;**************************************************************************
.CODE
libmain PROC FAR PASCAL
;libmain is called when the dll is first loaded (by DLLENTRY).
;libmain should return value of 1, if successful.
;NOTE: DLLENTRY.ASM is supplied with MASM 6.1.  It passes no params to
;libmain.  If you use LIBENTRY.OBJ, supplied with the SDK 3.1, it
;does pass params to libmain --- see Prog's Ref. Vol.2, on LibMain().

	mov     ax,1            ;ok.
	ret
libmain ENDP

;****************************************************************************

;Exported functions are beyond this point....
OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE
;..............................................
doint   PROC FAR PASCAL EXPORT
;It was convenient to export this procedure, so when ISR calls it, it
;is entered with DS=data segment of this dll --> so can get at old vector.
	PROLOG
	push ds ;save
	pushf
	call    DWORD PTR doldvector ; call previous handler
	pop ds  ;restore

	inc ncount              ;not doing much in this ISR!
        call togglebeep         ;       /


doiexit:
	EPILOG
	retf
doint ENDP
;.......................................................
	; ****  Entry point of ISR  ****
MyISR:                                  ;Our ISR
	    pusha
	    push    ds
	    push    es

	    invoke   doint               ;Do Interrupt Handling


	    pop     es
	    pop     ds
	    popa
	    iret                        ;exit MyISR
		
;...............................................
wep     PROC FAR PASCAL EXPORT, wexitcode:WORD
;windows calls wep() when unloading dll. We need to deinstall hook...
	PROLOG
	push    ds
	push    dx
	mov     dx,WORD PTR doldvector
	mov     ax,WORD PTR doldvector+2
	cmp     dx,0                    ;were we installed?
	jnz     dih_go
	cmp     ax,0
	jz      dih_skip
dih_go:
	push ax
	mov     ax,intnumx          ;set vector.
	mov     ah,25h
	pop  ds         ;ds:dx=new vector.
	int     21h
dih_skip:
	pop     dx
	pop     ds
	mov     ax,1            ;ok.
	EPILOG
	retf 2
wep     ENDP
;*****************************************************************
ISR_FUNC PROC FAR PASCAL EXPORT intnum:WORD  ;param passed by LabView.
;
	PROLOG

	cmp hooked,0            ;should be set by hook_int, on 1st entry.
	jne hookdone
	mov ax,intnum
	mov intnumx,ax          ;save into data segment (only on 1st entry).
	call hook_int
hookdone:

       mov ax,ncount                ; ax-->o/p to LV.
	mov ncount,0            ;clear interrupt counter.

	EPILOG
	retf 2                  ;dump 2-byte param.
ISR_FUNC ENDP
;..................................
hook_int PROC
;hook the interrupt....
	cli
	push    bx                      ;Save previous vector
	push    es
	mov     ax,intnumx    ;get idt vector number
	mov     ah,35h
	int     21h
	mov     WORD PTR doldvector,bx
	mov     WORD PTR doldvector+2,es
	pop     es
	pop     bx

	push    ds                      ;Install handler
	push    dx                      ;
	mov     dx,OFFSET MyISR
	mov     ax,intnumx          ;set idt vector number.
	mov     ah,25h
	push    cs
	pop     ds                      ;ds:dx is new vector.
	int     21h
	pop     dx                      ;restore
	pop     ds                      ; /
	mov hooked,1    ;so cannot rehook.
	sti
	ret
hook_int ENDP
;........................
togglebeep PROC
 xor toggle,1
 cmp toggle,1
 jne stopbeep
   mov al,0B6h
   out 43h,al
   mov bx,07C5h ;600h
   mov al,bl
   out 42h,al
   mov al,bh
   out 42h,al
   in al,61h
   or al,3
   out 61h,al
   jmp goout
stopbeep:
 in al,61h
 and al,0FCh
 out 61h,al
goout:
 ret
togglebeep ENDP
;****************************************************************************

	end
