;DOSTSR9.COM. This program works with \REAL2WIN\DPMI.EXE.
;It hooks INT-9 in the IVT, thus getting all keypresses/release
;while in a DOS VM, control is passed to the System VM and then up
;to WinApp DPMI.EXE.
;This "passing up" can only be done in Enhanced mode.
;This DOS TSR demonstrates transfer of control between VMs, access
;to global memory in the TSR (global to all VMs), and passing of
;control from real-mode up to protected mode via the IVT.
;
;Access to BIOS/DOS services from within this TSR ISR (Interrupt
;Service Routine) may be a problem, due to the preemptive nature of
;hardware interrupts.  You may like to look at additional code to
;check the "inDos" flag, etc -- another program on the Companion Disk,
;DOSTSR16.ASM will give some clues.  Hooking of INT-9 does involve
;some different techniques than INT016h -- no need to hook INT-28h,
;but instead hook INT-8 to check the inDos flag defore "popping up"
; -- "DOS 5: A Developer's Guide", by Al Williams, M&T Publishing, 1991,
;is most useful.
;...................................................
.286
int9	SEGMENT BYTE PUBLIC 'CODE'
	ASSUME	cs:int9,ds:int9
	ORG	100h
install:	jmp start
oldoffivt2F	DW	0	;save old int-2F vector here.
oldsegivt2F	DW	0	;	/
winloaded	DB	0	;set when Windows is loaded, & viceversa.
winmode		DB	0	;bit-0=1 if Standard, =0 if Enhanced.
oldoffivt9	DW	0	;save old vector here.
oldsegivt9	DW  0	;	/
oldss		DW	0	;host stack
oldsp		DW	0	;	/
tsrpspseg	DW	0	;seg addr of psp
localstack	DB	511 DUP(0)	;local stack
localendstack	DB	0		;	/
isrbusy		DB	0	;set to prevent reentrance.

;................................................................
start:
	mov	tsrpspseg,es	;save psp seg. addr.
;hook int-2Fh vector in ivt.  Windows calls this with AX=1605h when it loads,
;with regs telling useful info, such as if loading in Standard or
;Enhanced mode....
	mov	ax,352Fh		;get int-2F vector in ivt.
	int	21h			;	/
	mov	oldoffivt2F,bx	;save it
	mov	oldsegivt2F,es	;	/
	mov	ax,252Fh	;hook int-2F
	lea	dx,runtime2F	;set ivt vector.
	int	21h			;	/
;
doit: 	mov   	ax, 2561h   	;hook INT 61h so signaller can find
	lea   	dx, callback  	;forwarder in System VM, from another VM
	int   	21h	    	;   ..
;
;hook keypresses/releases ...
	mov	ax,3509h		;get int-9 vector in ivt.
	int	21h			;	/
	mov	oldoffivt9,bx	;save it
	mov	oldsegivt9,es	;	/
	mov	ax,2509h	;hook int-9
	lea	dx,runtime9	;set ivt vector.
	int	21h			;	/
;
;initialise int-60h in ivt, as used to test if WinApp has hooked it...
	push	ds
	mov	ax,0
	mov	ds,ax
	mov	dx,0
	mov	ax,2560h	;put 0 into int-60.
	int	21h		;(this hook will be in all Vm's).
	pop	ds
;...actually, DOS does this anyway... but do all versions do it? play safe.
;
;free the environment block ... ###
;	mov	es,ds:[2Ch]	;pointer to seg. addr. of env. block
;	mov	ah,49h		;deallocate memory
;	int	21h		;	/

;
	lea	dx,endprog+17  ;point past all code in this module.
	shr	dx,4	;compute # paragraphs to keep.
	mov	ax,3100h	;terminate and stay resident.
	int	21h	;	/
;....................................................................
runtime9:
;this is now the "signaller".  it is entered at every keypress/release...
;but only when in a DOS VM or in standard real-mode...
;First, I only want this ISR to work when Windows is loaded, so test
;winloaded flag...
	cmp	cs:winloaded,0
	jne	firsthurdle
chain:	jmp	DWORD PTR cs:oldoffivt9	;chain to old int-9.
firsthurdle:
	cmp	cs:isrbusy,0
	jne	chain
	mov	cs:isrbusy,1	;prevent reentrance. (though may miss
				; key releases!)
secondhurdle:
	;we're in, but call old int-9 first, which will take care of EOI...
	pushf			;...and normal processing of keyboard!
	call DWORD PTR cs:oldoffivt9	;call old int-9
;now setup registers...
	mov	cs:oldss,ss	;use local stack
	mov	cs:oldsp,sp	;	/ (though not really necessary for
	mov	ss,cs:tsrpspseg	;	/  this TSR -- put in to show how)
	mov	sp,OFFSET cs:localendstack  ;  /
	push	es	;save working registers
	push	ds	;	/
	pusha		;	/
	push	cs	;set ds == cs
	pop	ds	;    /
	sti		;since will be inside isr for sometime.
;.......
;next hurdle is to find out if Windows is in Standard or Enhanced mode.
;One way is to test INT-60 to see if it is hooked -- if not then we
;must be in Enhanced mode, as WinApp only hooks IVT in System VM.
;However all we will do is test winmode flag...
	mov	al,winmode
	and	al,1
	jz	enhanced	;bit-0 =0 if enhanced.
;
standard:
;This is how you would call the WinApp, but DON'T....
 jmp SHORT exit4
systemvm:
	 xor	ax,ax		;get current int-60 vector address
	 mov	es,ax		;  /  (don't use int21/35, as DOS
	 mov	si,60h*4	;  /  (may not be stable!)
	 mov	bx,es:[si]	;  /
	 mov	ax,es:[si+2]	;  /
	 mov	es,ax		; -->es:bx
	 or  	ax,bx		;is there a WinApp handler?
	 jz    exit4		  ; if not, don't call it!
	int	60h	;go ahead and call WinApp (bypass forwarder)
	jmp	SHORT exit4

enhanced:
;I will be a little bit fussy here. In theory, this ISR could be entered
;when the CPU is in the System VM, hence we will not want to do the
;transfer from another VM, as performed by 2F/1685... though it
;appears that this will still function.  Instead I have used 2F/1683
;to query the current VM...
	mov	ax,1683h
	int	2Fh		;returns VM id in BX
	cmp	bx,1		;1=System VM
	je	systemvm

;
;switch to the system virtual machine and call the forwarder program...
	 xor	ax,ax		;get current int-61 vector address
	 mov	es,ax		;  /  (don't use int21/35, as DOS
	 mov	si,61h*4	;  /  (may not be stable!)
	 mov	bx,es:[si]	;  /
	 mov	ax,es:[si+2]	;  /
	 mov	es,ax		; -->es:bx
	 mov   ax, 1685h	  ; fcn 1685: switch VM's and callback
	 mov   di, bx		  ; ES:DI = callback address (int 61 hdlr)
	 mov   bx, 1		  ; BX = VM to switch to (system VM)
	 mov   cx, 3
	 xor   dx, dx		  ; DX:SI = priority boost (zero)
	 xor   si, si		  ;   ..
	 int   2Fh		  ; switch to system VM & do INT 60
;
exit4:
	popa		;restore registers.
	pop	ds	;	/
	pop	es	;	/
	cli		;disable interrupts.
	mov	ss,cs:oldss	;restore host stack.
	mov	sp,cs:oldsp	;	/
	mov	cs:isrbusy,0	;allow reentrance.
	iret		;return from interrupt.
;....................................................................

callback:
;this is the forwarder, entered from the signaller in another VM, via
;the int-2F/1685h mechanism...
	 push  es		  ; save working registers
	 push  ds		  ;   ..
	 pusha			  ;   ..
	 sti		;important!
	 mov   ax, cs		  ; set DS == CS
	 mov   ds, ax		  ;   ..

	 xor	ax,ax		;get current int-60 vector address
	 mov	es,ax		;  /  (don't use int21/35, as DOS
	 mov	si,60h*4	;  /  (may not be stable!)
	 mov	bx,es:[si]	;  /
	 mov	ax,es:[si+2]	;  /
	 mov	es,ax		; -->es:bx
	 or  	ax, bx		;is there a WinApp handler?
	 jz    done60		  ; if not, don't call it!
	 int   60h		  ; call WinApp
done60:  popa			  ; restore registers
	 pop   ds
	 pop   es		  ;   ..
	 iret			  ; return to other VM.
;.................................................................
runtime2F:
;entered when Windows loads, with AX=1605h, and when Windows unloads,
;with AX=1606h....
;detect when Windows loads, and set a flag so that runtime9 will
;be activated...
	sti			;documentation says this req'd.
	cmp	ax,1605h	;test if Win is loading
	jne	notload
	cmp	cx,0		;this must always be 0, else error.
	jne	loaderror
	mov	cs:winloaded,1
	mov	cs:winmode,dl
	jmp	SHORT notunload
notload: cmp	ax,1606h	;test if Win is unloading.
	jne	notunload
	mov	cs:winloaded,0
	jmp	SHORT notunload
loaderror:
notunload:
	jmp DWORD PTR cs:oldoffivt2F
;..................................................................
endprog:
int9	ENDS
	END	install


