;DPMI2.ASM --> DPMI2.EXE  Windows DPMI program.
;This program has two parts: DPMI.EXE, which is a Windows program, and
;DOSTSR9.COM which is a DOS TSR.  The former one is this file.
;If you run just DPMI.EXE, it will hook INT-9 in the IDT, the keyboard
;hardware interrupt, and will beep on every keypress/release.  That's
;all it will do.
;However DPMI.EXE also hooks INT-60h in the IVT and provides an ISR,
;in protected mode, that a DPMI handler will "pass up" from real mode
;when a real mode INT 60h occurs.
;Thus this program is a mechanism for passing control from a real mode
;DOSApp up to a protected mode WinApp.
;DOSTSR9.COM is a TSR, that can be loaded prior to Windows. It executes
;INT 60h and thus passes control up to the WinApp.  As it is loaded
;prior to Windows, it exists in all VM's, and it also hooks INT-9 in
;all VM's -- any keypress/release while a DOSApp is running will go
;into the TSR, which will pass control across to the System VM (Enhanced
;mode) and will execute INT 60h to pass control up.
;The DOS TSR will not be able to pass control up in Standard mode.
;
;Note that if you examine the code for DOSTSR9, and for the protected
;mode ISR for WinApps in this file, that I have prevented reentrancy
;problems by simply locking out interrupts -- this can result in lost
;interrupts. You can use Borland's WINSIGHT program to look at WM_USER
;messages going to DPMI.EXE -- pressing a key too fast will result in
;only one message, missing the key-release.
;
.286
.MODEL SMALL

INCLUDE	WINDOWS.INC
IDM_QUIT		EQU	100		;menu-identifiers -- must be
IDM_ABOUT		EQU	101		;same as defined in .RC file.

REGSTRUC STRUC
 edi1 DD	0
 esi1 DD	0
 ebp1 DD	0
 res1 DD	0
 ebx1 DD	0
 edx1 DD	0
 ecx1 DD	0
 eax1 DD	0
 flags1 DW	0
 es1 DW	0
 ds1 DW	0
 fs1 DW	0
 gs1 DW	0
 ip1 DW	0
 cs1 DW	0
 sp1 DW	0
 ss1 DW	0
REGSTRUC ENDS


;......

EXTRN	UPDATEWINDOW:FAR	;these are Windows functions.
EXTRN	BEGINPAINT:FAR
EXTRN	ENDPAINT:FAR
EXTRN	DEFWINDOWPROC:FAR
EXTRN	POSTQUITMESSAGE:FAR
EXTRN	REGISTERCLASS:FAR
EXTRN	GETSTOCKOBJECT:FAR
EXTRN	CREATEWINDOW:FAR
EXTRN	SHOWWINDOW:FAR
EXTRN	GETMESSAGE:FAR
EXTRN	LOADCURSOR:FAR
EXTRN	TRANSLATEMESSAGE:FAR
EXTRN	DISPATCHMESSAGE:FAR
EXTRN	LOADICON:FAR
EXTRN	TEXTOUT:FAR
EXTRN	INVALIDATERECT:FAR
EXTRN	MESSAGEBOX:FAR
EXTRN	GETDC:FAR
EXTRN	RELEASEDC:FAR
EXTRN	SELECTOBJECT:FAR
EXTRN	GETWINFLAGS:FAR
;.........
EXTRN	GETMODULEHANDLE:FAR
EXTRN	GETPROCADDRESS:FAR
EXTRN	GETBIOSKEYPROC:FAR
EXTRN	DOS3CALL:FAR
EXTRN	DISABLE:FAR
;....
EXTRN	ENABLEHARDWAREINPUT:FAR
EXTRN 	POSTMESSAGE:FAR
EXTRN	LOCKSEGMENT:FAR
EXTRN	GLOBALHANDLE:FAR
EXTRN	GLOBALFIX:FAR
EXTRN	GLOBALPAGELOCK:FAR
;.....
.DATA
wintitle	DB	'DPMI DEMO PROGRAM',0
windpminame	DB	'DPMI',0
hOemFont	DW	0			;handle to OEM font.
outstring 	DB	'Hullo World'
aboutstr	DB	'Assembly Language Windows DPMI Demo',0	;messagebox
titlestr	DB	'Barry Kauler',0			;	/
;.......
offdosint9	DW	0	;the original dos int-9 vector.
segdosint9	DW	0	;	/
szkeyboarddrv	DB	"KEYBOARD.DRV",0
lpdisable	DD	0
lpenable	DD	0
lpgetmouseeventproc DD	0
lpeventproc	DD	0
keystate	DB	256 DUP(0)

dpmiflag	DB	0	;=1 dpmi running okay
dpmiversion	DW	0	;ah=major, al=minor.
mode386flag	DB	0	;=1 386 dpmi type.
realmodeintsflag  DB	0	;=1 real mode interr.
virtualmemflag  DB	0	;=1 virt. mem support.
cputype	DB	0	;=2,3,4  286,386,486
AOOOselector	DW	0	;selector video-RAM
OOOOselector	DW	0
szmodulename	DB	"USER.EXE",0
winvideomode	DB	0
bxcnt		DW	0
isrinstalled	DB	0	;set if isr's installed.

.CODE
;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC PASCAL NEAR hInstance:WORD,hPrevInstance:WORD,lpCmdLine:DWORD, \
								nCmdShow:WORD
	LOCAL	hWnd:WORD
	LOCAL	s1:WNDCLASS
	LOCAL	s2:MSGSTRUCT

	cmp hPrevInstance,0
	je	qqqq
	jmp	quitwinmain	;disable multiple instances
qqqq:
;......
;Can lock the code into linear memory...
	call	GLOBALHANDLE PASCAL,cs	;hMem-->ax
	call	GLOBALFIX PASCAL,ax
;... will speed up ISR access, as will always remain in RAM.
;... however, crashes a DOSApp in Standard mode!
;Put this in for Enhanced mode (Standard mode won't object to it)...
	call	GLOBALPAGELOCK PASCAL,cs
;.......
	mov	ax,1686h		;test if dpmi running.
	int	2Fh
	or	ax,ax
	jz	yesitis
	jmp	quitwinmain
yesitis: mov	dpmiflag,1		;set flag, dpmi okay.
	mov	ax,0400h		;get dpmi version.
	int	31h
	mov	dpmiversion,ax
	mov	al,bl
	and	al,01		;bit-0 =1 if 386 dpmi
	mov	mode386flag,al
	mov	al,bl
	shr	al,1
	and	al,01	;bit-1 =1 if not virtual86 int handling
	mov	realmodeintsflag,al
	shr	bl,2
	and	bl,01	;bit-2 =1 if virtual mem. supported.
	mov	virtualmemflag,bl
	mov	cputype,cl	;cl=2,3,4 if 286, 386, or 486.
;.......
;Get selectors for conventional memory areas...
	mov	ax,2
	mov	bx,0A000h  	;segment addr of video RAM.
	int	31h
	mov	AOOOselector,ax	;note - dont start a label with 0-9.
	mov	ax,2
	mov	bx,0000
	int	31h
	mov	OOOOselector,ax
;.....
	mov	ah,0Fh		;get current video mode.
	int	10h
	mov	winvideomode,al
;......
;Setup the window class structure for REGISTERCLASS()...
	mov 	s1.clsStyle,3
	mov 	s1.WORD PTR clsLpfnWndProc,OFFSET DPMICALLBACK
	mov 	s1.WORD PTR clsLpfnWndProc+2,SEG DPMICALLBACK
	mov 	s1.clsCbClsExtra,0
	mov 	s1.clsCbWndExtra,0
	mov	ax,hInstance
	mov 	s1.clsHInstance,ax
  call FAR PTR LOADICON PASCAL,null, 0,IDI_APPLICATION
	mov 	s1.clsHIcon,ax
  call FAR PTR LOADCURSOR PASCAL,null, 0,IDC_ARROW
	mov 	s1.clsHCursor,ax
	mov 	s1.clsHbrBackground,COLOR_BACKGROUND
	mov	ax,OFFSET windpminame
	mov 	s1.WORD PTR clsLpszMenuname,ax
	mov 	s1.WORD PTR clsLpszMenuName+2,ds
	mov 	s1.WORD PTR clsLpszClassName,ax
	mov 	s1.WORD PTR clsLpszClassName+2,ds
	lea	ax,s1
  call FAR PTR REGISTERCLASS PASCAL,ss,ax
	or	ax,ax					;
	jne	createwin
	jmp	quitwinmain
;.......
createwin:
 call CREATEWINDOW PASCAL, ds,OFFSET windpminame, ds,OFFSET wintitle, 207,0,\
				   150, 0, 400, 300, 0, 0, hInstance, 0,0
	mov 	hWnd,ax
	call 	SHOWWINDOW PASCAL,ax,nCmdShow
	call 	UPDATEWINDOW PASCAL,hWnd
	jmp	SHORT messageloop			;go to the main message-loop.
;.......
;This is the main message loop, in which Windows waits for messages
mainloop:
	lea	ax,s2
	call	TRANSLATEMESSAGE PASCAL,ss,ax
	lea	ax,s2
	call	DISPATCHMESSAGE PASCAL,ss,ax
messageloop:
	lea 	ax,s2
	call 	GETMESSAGE PASCAL, ss,ax, null, null, null
	or	ax,ax
	jne	mainloop
	mov	ax,s2.msWPARAM		;return wparam to windows OS.
quitwinmain:
	ret
WINMAIN	ENDP

;.....................................................................

	PUBLIC	DPMICALLBACK
DPMICALLBACK PROC WINDOWS PASCAL FAR hWnd:WORD,msgtype:WORD,wParam:WORD, \
							    lParam:DWORD
	LOCAL	dummy:WORD:5
	LOCAL	hDC:WORD
	LOCAL	s3:PAINTSTRUCT
;
	mov	ax,msgtype
	cmp	ax,WM_CREATE
	je	xcreate
	cmp	ax,WM_DESTROY
	je	xquitmessage
	cmp	ax,WM_PAINT
	jne nxpaint
	jmp	xpaint
nxpaint:
	cmp	ax,WM_COMMAND
	jne	notwmcommand
	jmp	xmenu
notwmcommand:
	cmp	ax,WM_LBUTTONDOWN
	jne	notwmlbutton
	jmp	xbreak
notwmlbutton:
	cmp	ax,WM_CHAR
	jne	xdefhandle
	jmp	xchar
xdefhandle:
	cmp	ax,WM_USER
	jne	nuser
	push ax
	push dx
	mov ah,2	;write char to scrn
	mov dl,07	;beep
	int 21h
	pop dx
	pop ax
	jmp xdef
nuser:	cmp	ax,WM_USER+1	;message sent from xcreate.
	jne	xdef
	call	installint	;install ivt/idt hook/s.
	mov	isrinstalled,1	;flags that isr's now installed.
	jmp	xbreak

xdef:
;Default handling of messages....
  call	FAR PTR DEFWINDOWPROC PASCAL,hWnd,msgtype,wParam, WORD PTR lParam+2, \
							  WORD PTR lParam
	jmp	xreturn
;.................................
xcreate:
  call	FAR PTR GETSTOCKOBJECT PASCAL,OEM_FIXED_FONT
	mov	hOemFont,ax		;handle to font.
;It is best to install the ISR indirectly....
	call POSTMESSAGE PASCAL,hwnd,WM_USER+1,0, 0,0
	jmp	xbreak
;.........................................................
xquitmessage:
  call	FAR PTR POSTQUITMESSAGE PASCAL,0
;.....
  ;unhook the int-9 in IDT...
	push dx
	push ds
	mov dx,offsetint
	mov ax,selectorint
	mov	ds,ax
	mov ax,2509h  ;2551h  ;2550h
	int 21h
	pop ds
	pop dx
;.....
unhookreal:
;also unhook the int-60h in the real mode ivt...
	mov	cx,cs:segmentrealint	;old saved vector
	mov	dx,cs:offsetrealint	;	/
	mov	ax,0201h		;set real mode int vector
	mov	bl,60h  		;vector 60h
	int	31h
;.....
	jmp	xbreak
;......
xpaint:
  call	DEFWINDOWPROC PASCAL,hWnd,msgtype,wParam,lParam
  jmp   xreturn
;..................................................
xmenu:
	cmp	WORD PTR lParam,0	;low-half of lParam
	jne	xbreak			;test if a menu-message.
	cmp	wParam,IDM_QUIT		;wParam.
	jne	notquit
	jmp	xquitmessage
notquit:
	cmp	wParam,IDM_ABOUT
	jne	xbreak			;no other menu items.
		;let's put up a message about this program...
 call FAR PTR MessageBox PASCAL, hWnd, SEG aboutstr,OFFSET aboutstr, \
					SEG titlestr,OFFSET titlestr, MB_OK
	jmp xbreak
;.......................
xchar:
	jmp 	xbreak
;.........................
xbreak:
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
xreturn:
	ret
DPMICALLBACK	ENDP

;................................................................
.DATA
offsetint		DW	0	;old  idt vector
selectorint	DW	0	;	/
;.....................
.CODE
offsetrealint	DW	0		;old ivt vector
segmentrealint	DW	0		;	/
dsselector 	DW 0			;data alias to code seg
dataselector	DW	0	;selector of this WinApps data seg.
musicflag	DB	0 ;turn music on/off
hwndcs 		DW 0	;save window handle for use in isr
callbackbuffer	REGSTRUC < >  	;used by func 0303h.
enhancedmode	DB	0	;set if in enhanced mode.
;.......
installint PROC   	;no params
install:
	pusha
	push es
	push ds
;will create alias in ldt ...
	mov	ax,000Ah	;create alias data descriptor for code segment.
	push	cs
	pop	bx		;selector to be aliased
	int 31h		;returns ax
	push ax
	pop es
	mov ax,hwnd
	mov es:hwndcs,ax	;save handle of window in code seg.
	mov ax,es
	mov es:dsselector,ax	;save data alias in code seg.
	mov	es:dataselector,ds	;save ds in code seg.
;....
;this is a way of finding out mode of Windows...
	push	es	;save
	call	GETWINFLAGS PASCAL	;flags --> dx:ax
	pop	es	;restore
	and	ax,0020h	;ax=xxxx xxxx xx1x xxxxb if enhanced mode
	jz	eeee
	mov	es:enhancedmode,1	;save in code seg (for isr)
eeee:
;...............
;Now to hook INT-9 in the IDT....
	mov al,9  	;get vector in idt.. 9...
	mov	ah,35h          ;-->ES:BX
	int 21h
	push es
	pop  ax
	mov	offsetint,bx	;save old int-9 idt vector
	mov	selectorint,ax	;	/
;....
	mov	dx,OFFSET runtime	;hook int-9 in idt...
	push	cs
	pop	ds	;new vector in ds:dx
	mov	al,9  	;
	mov	ah,25h	;set vector
	int	21h
;......................
	pop	ds	;restore ds.
	push	ds	;save it again
 ;let's hook int60 in idt, to use as old vector...
	mov dx,offsetint
	mov ds,selectorint
	mov ax,2560h
	int 21h
;...........................................
hookreal:
	pop	ds	;restore it again.
;okay, now to hook real mode ints....   hook 60, in ivt...
;have created extra data; offsetrealint, segmentrealint, callbackbuffer...
	mov	ax,0200h	;get real mode vector
	mov	bl,60h
	int	31h		;-->cx:dx (seg:off)
	mov	es,cs:dsselector
	mov	es:offsetrealint,dx 	;save old vect
	mov	es:segmentrealint,cx
;.......
;now must reflect the real mode int up to prot mode code....
	push	ds		;save
	mov	es,cs:dsselector	;get alias
				;addr of buffer in es:di
	mov	di,OFFSET callbackbuffer	;  /
	mov	ax,0303h	;alloc real mode callback
	push	cs
	pop	ds		;addr of prot code
	mov	si,OFFSET runtime2	;  /
	int	31h		;-->cx:dx (seg:off)
	pop	ds		;restore
;now hook the ivt....
	mov	ax,0201h	;set real mode vector
	mov	bl,60h  	;hook int-60 in ivt
	int	31h
;................
getout:
	pop es
	popa
	ret

;...........................................................
runtime:	;isr for prot mode interrupts, via idt.
	int 60h	;call old int-9 (vector saved here).
	pusha
	push 	ds
	push 	es
	mov 	es,cs:dsselector
	mov 	ax,cs:hwndcs
	push ax
	push WM_USER
	push 0
	push 0
	push 0
	call POSTMESSAGE	;works when interrupt via IDT, or
	pop 	es		; via IVT when Windows in Enhanced mode.
	pop 	ds
	popa
	iret
;...............................
runtime2:	;isr for real-mode ints via ivt, reflected up to prot-mode.
;entered with ds:si = real-mode ss:sp,  es:di = real-mode reg structure,
; ss:sp=locked prot mode dpmi stack, and interrupts disabled...
;should exit with es:di still pointing to real-mode-reg structure...
;(note that in some circumstances, reentrancy is a problem, and should
;allocate data, incl reg structure, dynamically).
	pusha
	push 	ds
	push 	es
;	sti		;(reentrancy becomes an issue once this is done).
;
;get addressability of data in code seg...
;...in Standard mode there is a serious problem. it appears that Windows
; shoves the entire conventional memory area out to disk, to make way
; for the DOSApp ... our WinApp could be the victim.
;Actually, this program should test for Enhanced mode at WINMAIN(), and
;refuse to install the handler, or disable the real-mode ISR, if
;Windows is in Standard mode.

;	mov 	es,cs:dsselector	;to write to data.

;here's another way to write to data...
	mov	es,cs:dataselector	;WinApps data seg.

;find out if in Enhanced mode...
	mov	al,cs:enhancedmode
	or	al,al
	jz	notenhanced
	mov 	ax,cs:hwndcs	;handle of window.
	push ax			;post WM_USER msg
	push WM_USER		;	/
	push 0			;	/
	push 0			;	/
	push 0			;	/
	call POSTMESSAGE	;	/
	jmp	SHORT msgposted
notenhanced:
msgposted:
;send char to printer...
;	mov	al,10	;linefeed
;	mov	dx,0
;	mov	ah,0
;	int	17h
	pop 	es		;restore regs
	pop 	ds
	popa
;for returning to real mode prog prior to interrupt...
	cld
	lodsw			;ip from real mode stack
	mov	es:[di].ip1,ax
	lodsw			;cs from real mode stack
	mov	es:[di].cs1,ax
	lodsw			;flags from real mode stack
	mov	es:[di].flags1,ax
	add	es:[di].sp1,6
;
;can chain to original vector by putting it into callback data structure...
;	mov	ax,cs:segmentrealint
;	mov	es:[di].cs1,ax
;	mov	ax,cs:offsetrealint
;	mov	es:[di].ip1,ax
;
	iret
;
installint ENDP
;..............................................................

	END
