;this file is an extract from GOOFEE.ASM, Barry Kauler's
;Windows CASE tool, GOOFEE Diagrammer.
;This extract shows how the data segment is exported for other
;16- and 32-bit WinApps to have direct access into the data
;of this application.
;There is a demo W32DEMO.ASM 32-bit WinApp that shows how to
;utilise the access.

;Of course, copying the entire data segment to below 1M is a bit
;radical, and in your own application you may just want a small
;memory block apart from your apps data that is shared across
;winapps.

;the message loop is very unusual. unlike normal message loops,
;this app never stops executing. Even if there is no message for
;this app, still it is in a loop, which gives it the opportunity
;to process a command sent from another application.
;GOOFEE.EXE will process commands placed in control1/2/3 variables
;by other apps -- see documentation on web site.

;look at http://www.goofee.com/
;for further details.

;the data is left out.
;only WINMAIN() is left in, as that is the essential part.


;...........................................................
.CODE
;Here is the startup code...
start:
	xor bp,bp                       ; zero bp
	push bp
	INVOKE InitTask                 ; Initialize the stack
	or ax,ax
	jz noinit
	add cx,STACKSLOP                ; Add in stack slop space.
	jc noinit                       ; If overflow, return error.
	mov hPrev,si
	mov hInst,di
	mov word ptr lpszCmd,bx
	mov word ptr lpszCmd+2,es
	mov cmdShow,dx
	xor ax,ax                       ; Clear initial event that
	INVOKE WaitEvent, ax            ;   started this task.
	INVOKE InitApp, hInst           ; Initialize the queue.
	or ax,ax
	jz noinit

	INVOKE WINMAIN, hInst,hPrev,lpszCmd,cmdShow
ix:
	mov ah,4Ch
	INVOKE Dos3Call                 ; Exit with return code from app.
noinit:
	mov al,0FFh                     ; Exit with error code.
	jmp short ix

;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC NEAR PASCAL, hInstance:WORD,hPrevInstance:WORD,lpCmdLine:LPSTR, \
								nCmdShow:SWORD
	LOCAL	@hWnd:HWND
	LOCAL	s1:WNDCLASS
	LOCAL	s2:MSG

	cmp	hPrevInstance,0		;=0 if no previous instance.
	je	yes1st
	jmp	quitwinmain	;createwin
			;no, problems with GLOBALDS.DAT if multiple insts.
yes1st:



;Setup the window class structure for REGISTERCLASS()...
	mov	s1.Style,CS_HREDRAW+CS_VREDRAW+CS_DBLCLKS
	lea	di,s1.lpfnwndproc
	mov	[di],OFFSET ASMPROC
	mov	[di+2],SEG ASMPROC
	mov 	s1.CbClsExtra,0
	mov 	s1.CbWndExtra,0
	mov	ax,hInstance
	mov 	s1.HInstance,ax

;  invoke LOADICON,null, IDI_APPLICATION
   invoke LOADICON, hinstance,ADDR sziconname
	mov 	s1.@HIcon,ax

  invoke LOADCURSOR,null, IDC_ARROW
	mov 	s1.@HCursor,ax

        invoke GETSTOCKOBJECT, WHITE_BRUSH      ;-->ax=handle

	mov 	s1.hbrBackground,ax    ;COLOR_BACKGROUND+1
	mov	ax,OFFSET szwin51name
	lea	di,s1.lpszmenuname
	mov 	[di],ax
	mov 	[di+2],ds
	lea	di,s1.lpszclassname
	mov 	[di],ax
	mov 	[di+2],ds

	lea	ax,s1
  invoke REGISTERCLASS,ss::ax
	or	ax,ax
	jne	createwin
	jmp	quitwinmain

createwin:                            ;(style was 00CF0000h)
 invoke CREATEWINDOW, ADDR szwin51name, ADDR szwintitle,\
                    WS_OVERLAPPEDWINDOW+WS_MAXIMIZE,\
		    0, 0, 640, 480, 0, 0, hInstance, 0
	mov	@hWnd,ax
  invoke SHOWWINDOW,ax,nCmdShow
  invoke UPDATEWINDOW,@hWnd

;initialise pointers in database....
	mov  pszfile,OFFSET szfile

;***9-4-97*** want to export the data segment so other apps can access...
;INT31h/function0100h allocates a memory block below 1M...
;	mov  ax,0100h
;	mov  bx,1000h	;number of paragraphs to allocate (64K).
;	int  31h	;returns ax=real-mode segment address
;	jc errx1	;  dx=selector
	;...doesn't work, says none available! so, use...
	invoke GLOBALDOSALLOC, 0FFFFh	;allocates 64K bytes below 1M.
	;dx=real-mode segment value, ax=selector, fail=0.
	cmp ax,0
	je  errx1
	mov dx,ax
;now, copy our entire data segment to it, and change ds...
;let's leave ss as-is, so it has plenty of room!
	mov  lowdataseg,dx	;save it.
	mov  si,0		;source block is ds:si
	mov  di,0		;destination block is es:di
	mov  es,dx		;/
	mov  cx,0F000h ;0FFFFh		;copy 64K bytes.
	cld
	rep  movsb
	push dx
	pop  ds 		;that's it!

;10-4-97 need to save new low selector to a file...
	lea dx,szglobalds
	invoke _LCREAT, ds::dx,0	;open GLOBALDS.DAT
	cmp  ax,-1
	je   errx2
	mov  di,ax
	lea  dx,lowdataseg		;our new global selector.
	invoke _LWRITE, di,ds::dx,2	;write 2 bytes.
	cmp  ax,-1
	je   errx3
	invoke _LCLOSE, di

	jmp  SHORT messageloop
errx1:
   invoke MESSAGEBOX,@hWnd, ADDR szdpmierr, 0, MB_OK+MB_ICONEXCLAMATION
   ;maybe should make sure GLOBALDS.DAT is empty...
	lea dx,szglobalds
	invoke _LCREAT, ds::dx,READ_WRITE
	cmp  ax,-1
	je   errx2
	mov  di,ax
	lea  dx,zeroword
	invoke _LWRITE, di,ds::dx,2
	cmp  ax,-1
	je   errx3
	invoke _LCLOSE, di
	cmp  ax,-1
	je   errx2
	jmp  SHORT messageloop
errx3:
	invoke _LCLOSE, di
errx2:
   invoke MESSAGEBOX,@hWnd, ADDR szglobaldserr, 0, MB_OK+MB_ICONEXCLAMATION
	jmp	SHORT messageloop			;go to the main message-loop.


;This is the main message loop, in which Windows waits for messages
;mainloop:
;	lea	ax,s2
;	invoke	TRANSLATEMESSAGE,ss::ax
;	lea	ax,s2
;	invoke	DISPATCHMESSAGE,ss::ax
;messageloop:
;	lea	ax,s2
;	invoke GETMESSAGE, ss::ax, null, null, null
;	or	ax,ax
;	jne	mainloop

;this is an alternative messageloop, that doesn't stay outside this app...
messageloop:
	lea    di,s2
	invoke GETMESSAGE, ss::di,0,0,0	 ;remove message from queue.
        or      ax,ax                   ;quit if WM_QUIT message.
	jz	normalexit		 ;really!
	.IF  fEXTsuspend==2	;dump all msgs.
	.ELSE
	  invoke TRANSLATEMESSAGE, ss::di
	  invoke DISPATCHMESSAGE, ss::di
	.ENDIF
messloop2:
	.IF fEXTsuspend==0	;see object.control3.0/1/2.
messl3:	  lea	di,s2
	  invoke PEEKMESSAGE, ss::di,0,0,0,PM_NOREMOVE
			     ;see if a message for this app.
	  or	ax,ax			;=0 if no msg from windows.
	  jnz	messageloop
	.ELSEIF fEXTSUSPEND==1	;ignore msgs.
	  lea  di,s2
	  invoke PEEKMESSAGE, ss::di,0,0,0,PM_NOREMOVE
	  ;...put this in as allows other win16 apps to run.
	.ELSEIF fEXTsuspend==2	;sleep -- dump all msgs.
	  jmp  messl3
	.ENDIF

	  .IF externsync==0
	    ;***this is where we are idling***...
	    mov	ax,@hwnd	;well, really only need to do once
	    mov	hwindow1,ax	;when open a data file.
	    mov ax,clientrect.top
	    mov xtop,ax
	    mov ax,clientrect.left
	    mov yleft,ax
	    or	control1,80h		;set goofee-ready flag(bit7).
	    mov	al,control1
	    and	al,01111100b		;are any bits 2--6 set?
	    .IF	al==0			;no.
	    .ELSE
	      invoke VALIDATERGN, @hwnd,0 ;tell win nothing to update.
	      invoke SETFOCUS,@hwnd	;set keyboard focus to GOOFEE.
	      call   processcommands
	    .ENDIF
	  .ELSEIF externsync<0	;error
	    mov  externsync,0	;ungraceful recovery.
	  .ENDIF

	jmp   messloop2
normalexit:

;10-4-97 empty GLOBALDS.DAT...
	lea dx,szglobalds
	invoke _LOPEN, ds::dx,READ_WRITE
	cmp  ax,-1
	je   xerrx2
	mov  di,ax
	lea  dx,zeroword
	invoke _LWRITE, di,ds::dx,2
	cmp  ax,-1
	je   xerrx2
	invoke _LCLOSE, di
	cmp  ax,-1
	je   xerrx2
	jmp  SHORT fr1
xerrx2:
   invoke MESSAGEBOX,@hWnd, ADDR szglobaldserr, 0, MB_OK+MB_ICONEXCLAMATION

;***9-4-97***free the dos block...
fr1:	cmp  lowdataseg,0
	je   x2quit
	mov  dx,lowdataseg  ;ds
	push ss
	pop  ds ;make ds a valid data segment.
	invoke GLOBALDOSFREE,dx
	mov  lowdataseg,0
x2quit:


;GetMessage() returns FALSE (AX=0) if a "quit" message...
;so here we are quiting....
	mov	ax,s2.WPARAM		;return wparam to windows OS.
quitwinmain:
	ret
WINMAIN	ENDP
;....................................................................
processcommands PROC
;GOOFEE is idling. no msgs to process, so can process command
;from companion application...



pro1x:	mov  control1,0 	;clear all flags.
pro1:
	ret
pro1z:	mov  control1,80h	;invalid command, so ready for another.
	ret
processcommands ENDP
;.............................................


;GOOFEE.ASM shifts the entire data segment below 1M, but Windows
;doesn't know that. Windows will enter all callbacks with DS set
;to the original value.  So, the following is required...

ASMPROC	 PROTO FAR PASCAL,  :HWND, :WORD, :SWORD, :SDWORD
ASMPROC	PROC FAR PASCAL USES ds di si, ihWnd:HWND, iMessage:WORD, iwParam:SWORD,\
				 ilParam:SDWORD
	LOCAL	dummy [5]:WORD

;***9-4-97*** if have changed to low data segment, need to change ds
;everytime enter here...
;(Win always enters this proc with the old value)
	cmp lowdataseg,0	;=0 not yet created
	je  asmx1
	mov ax,lowdataseg
	mov ds,ax
asmx1:
