;WINHULLO.ASM --> WINHULLO.EXE  Windows demo program.
;Requires WINHULLO.MAK, WINHULLO.RC & WINHULLO.DEF in this directory.
;This skeleton program puts a window on the screen, with "File" menu
;-item and "Quit" & "About" selections.  The latter produces a
;message-box.
;WINHULLO.ASM can be assembled using just about any assembler. It has
;been tested with Microsoft's MASM v5.1 and Borland's TASM v2.5.
;Note that These two versions do have the "simplified directives", 
;specifically, .MODEL, .DATA, .CODE & .STACK, which have been used.

.MODEL SMALL

;the following equates could have been placed in a separate
;include file.... (note that I got these from WINDOWS.H which is
;part of the Microsoft SDK. They are also in WINDOWS.INC)
IDI_APPLICATION EQU	32512	;identifier for icon type.
IDC_ARROW		EQU	32512	;identifier for cursor type.
OEM_FIXED_FONT	EQU	10		;identifier for font type.
COLOR_BACKGROUND EQU 1		;identifier for background colour.

WM_CREATE		EQU	1		;these are messages from Windows.
WM_DESTROY	EQU	2		;	/
WM_PAINT		EQU	15		;	/
WM_COMMAND	EQU	273		;	/
WM_LBUTTONDOWN	EQU	513		;	/
WM_CHAR		EQU	258		;	/

IDM_QUIT		EQU	100		;menu-identifiers from Windows -- must
IDM_ABOUT		EQU	101		;be same as defined in .RC file.

MB_OK		EQU	0		;a messagebox type.

;......
EXTRN	UPDATEWINDOW:FAR	;these are Windows functions.
EXTRN	BEGINPAINT:FAR
EXTRN	ENDPAINT:FAR
EXTRN	DEFWINDOWPROC:FAR
EXTRN	POSTQUITMESSAGE:FAR
EXTRN	REGISTERCLASS:FAR
EXTRN	GETSTOCKOBJECT:FAR
EXTRN	CREATEWINDOW:FAR
EXTRN	SHOWWINDOW:FAR
EXTRN	GETMESSAGE:FAR
EXTRN	LOADCURSOR:FAR
EXTRN	TRANSLATEMESSAGE:FAR
EXTRN	DISPATCHMESSAGE:FAR
EXTRN	LOADICON:FAR
EXTRN	TEXTOUT:FAR
EXTRN	INVALIDATERECT:FAR
EXTRN	MESSAGEBOX:FAR
EXTRN	GETDC:FAR
EXTRN	RELEASEDC:FAR
EXTRN	SELECTOBJECT:FAR
;..............................................
.DATA

szwintitle	DB	'HULLO DEMO PROGRAM',0
szwinhulloname	DB	'WINHULLO',0
hOemFont	DW	0			;handle to OEM font.
hInst	DW	0
soutstring 	DB	'Hullo World'
szaboutstr	DB	'Assembly Language Windows Demo',0	;messagebox
sztitlestr	DB	'Karda Prints',0				;	/

;..............................................................
.CODE

	PUBLIC	WINMAIN
WINMAIN	PROC NEAR			;entry point from Windows.
;						;stack will contain return-addr (only 2
;						;bytes), nCmdShow (2), lpCmdLine (4),
;						;hPrevInstance (2), hInstance (2 bytes).
;						;(ret-addr is at top of stack).
	push	bp				;save BP so can use to access params.
	mov	bp,sp			;BP will now point to top-of-stack.
	sub	sp,46			;mov stack to free region.
	cmp	WORD PTR [bp+10],0	;hPrevInstance. (=0 if no previous inst).
	jne	createwin
;...................
;we only come this way if this is the first instance of the application.
;The first instance needs to create certain resources, and all following
;instances can use them....
;The code below is creating a window-class data-structure, as required
;by RegisterClass() further down....
	mov	WORD PTR [bp-46],3					;wndclass
	mov	WORD PTR [bp-44],OFFSET WINHULLOPROC	;addr of callback
	mov	[bp-42],SEG WINHULLOPROC		;function for window.
	sub	ax,ax
	mov	[bp-40],ax
	mov	[bp-38],ax
	mov	ax,[bp+12]	;hInstance
	mov	[bp-36],ax
	sub	ax,ax				;null -- use Windows default icons.
	push	ax						;	/
	mov	cx,IDI_APPLICATION			;Default application icon.
	sub	dx,dx					;	/
	push	dx						;	/
	push	cx						;	/
	call	LOADICON
	mov	[bp-34],ax
	sub	ax,ax				;null -- use Windows default cursor.
	push	ax						;	/
	mov	ax,IDC_ARROW				;Standard arrow cursor.
	cwd							;	/
	push	dx						;	/
	push	ax						;	/
	call	LOADCURSOR
	mov	[bp-32],ax
;	mov	ax,WHITE_BRUSH		
;	push	ax
;	call	GETSTOCKOBJECT
	mov ax,COLOR_BACKGROUND
	mov	[bp-30],ax
	mov	ax,OFFSET szwinhulloname
	mov	[bp-28],ax
	mov	[bp-26],ds
	mov	[bp-24],ax
	mov	[bp-22],ds
	lea	ax,[bp-46]			;wndclass
	push	ss						;this is address of above data
	push	ax						;structure.
	call	REGISTERCLASS		;registers this class of window.
	or	ax,ax					;
	je	quitwinmain
;........................
createwin:
;CreateWindow() requires the following params on the stack --
;long pointer to window class name, lp to window title, type of window,
;x coord, y coord, width, height, parent-handle, menu-handle, instance-
;handle, lp to params to pass-on.
	mov	ax,OFFSET szwinhulloname	;see _DATA segment.
	push	ds						;long-pointer (far address) of
	push	ax						;class-name.
	mov	ax,OFFSET szwintitle	;see _DATA segment.
	push	ds						;far address of window-title.
	push	ax						;	/
	sub	ax,ax					;type of window (32-bit value).
	mov	dx,207					;	/
	push	dx						;	/
	push	ax						;	/
	mov	ax,150					;x-coord (16-bit).
	push	ax						;	/
	sub	ax,ax					;y-coord (16-bit).
	push	ax						;	/
	mov	ax,400					;width (16-bit).
	push	ax						;	/
	mov	ax,300					;height (16-bit).
	push	ax						;	/
	sub	ax,ax
	push	ax						;0=no parent for this window.
	push	ax						;0=use the class menu.
	mov	ax,[bp+12]			;hInstance -- handle for this
	mov	hInst,ax			;application's instance.
	push	ax						;(passed to applic from Windows).
	sub	ax,ax
	push	ax						;0=no params to pass-on.
	push	ax						;(32-bit long-pointer).
	call	CREATEWINDOW
	mov	[bp-2],ax			;returns hWnd in AX
								;(handle to the window).
								;Here we save it temporarily.

	push ax						;ShowWindow() requires hWnd and
	push	WORD PTR [bp+4]	;nCmdShow	;nCmdShow on the stack.
	call	SHOWWINDOW			;Tells Windows to display window.

	push	WORD PTR [bp-2]			;hWnd
	call	UPDATEWINDOW		;tells Windows to redraw now.
	jmp	SHORT messageloop			;go to the main message-loop.

;........................
;This is the main message loop, in which Windows waits for messages
;by calling GetMessage(), then translates keypresses with
;TranslateMessage() then passes them back to Windows with
;DispatchMessage()....
mainloop:
	lea	ax,[bp-20]			;far-addr of message.
	push	ss						;	/
	push	ax						;	/
	call	TRANSLATEMESSAGE
;.....
	lea	ax,[bp-20]			;far-addr of message.
	push	ss						;	/
	push	ax						;	/
	call	DISPATCHMESSAGE
;.....
messageloop:
	lea	ax,[bp-20]			;long-pointer (far addr) of
	push	ss						;message. (we use the stack
	push	ax						;region for convenience).
	sub	ax,ax
	push	ax						;null
	push	ax						;null
	push	ax						;null
	call	GETMESSAGE
	or	ax,ax
	jne	mainloop
;......
;GetMessage() returns FALSE (AX=0) if a "quit" message...
;so here we are quiting....
	mov	ax,[bp-16]	;return wParam to Windows.
quitwinmain:
	mov	sp,bp
	pop	bp
	ret	10				;Causes RET to add 10 to SP after
						;popping ret-address, effectively dumping
						;all params (as for PASCAL convention).
WINMAIN	ENDP

;.....................................................................
;What follows is the "callback" function, that Windows calls after the
;message has been given back to it via DispatchMessage().
;This function employs CASE logic to direct execution to specific
;routines to handle each message.  In many cases the message
;cannot be handled by the application, so it is sent back to
;Windows (again!) for default handling....

	PUBLIC	WINHULLOPROC
WINHULLOPROC	PROC FAR
;The function is entered with far-return-addr (4 bytes), lParam (4),
;wParam (2), message-type (2), and window-handle (2 bytes) on the stack
;(ret-addr on top).

	push	ds				;This is some standard preliminary
	pop	ax				;shuffling of the registers.
	nop					;	/
	inc	bp				;	/ (it is called the prolog code)
	push	bp				;	/
	mov	bp,sp			;	/
	push	ds				;	/
	mov	ds,ax			;	/
	ASSUME DS: NOTHING		;	/ (enters function with DS=_DATA)
;...
	sub	sp,146			;move the stack to a free region
						;(so as not to mess-up the params).
	mov	ax,[bp+12]		;get message-type.
;....
	cmp	ax,WM_CREATE		;message received after CreateWindow()
	je	xcreate			;function is called.
	cmp	ax,WM_DESTROY		;message received if a window is closed.
	je	xquitmessage
	cmp	ax,WM_PAINT		;message received if Windows has (already)
						;redrawn any part of the window (due to
						;a size-change for example).
	je	xpaint
	cmp	ax,WM_COMMAND		;any selection of the menu will produce
	jne	notwmcommand
	jmp	xmenu			;this message.
notwmcommand:
	cmp	ax,WM_LBUTTONDOWN	;one of many mouse messages.
	jne	notwmlbutton
	jmp	xbreak
notwmlbutton:
	cmp	ax,WM_CHAR		;message that a key pressed.
	je	xchar

;Default handling of messages....
	push	WORD PTR [bp+14]	;hWnd
	push	WORD PTR [bp+12]	;Message-type
	push	WORD PTR [bp+10]	;wParam
	push	WORD PTR [bp+8]	;hi-half of lParam
	push	WORD PTR [bp+6]	;low-half of lParam
	call	DEFWINDOWPROC
	jmp	xreturn			;Back to Windows, which will in turn
						;return to after DispatchMessage().
;.................................
xcreate:
	mov 	ax,OEM_FIXED_FONT
	push	ax
	call	GETSTOCKOBJECT
	mov	hOemFont,ax		;handle to font.
	jmp	xbreak
;.....
xquitmessage:
	sub	ax,ax
	push	ax
	call	POSTQUITMESSAGE
	jmp	xbreak
;......
xchar:
;If I wanted this program to display "Hullo World" only when any key is
;pressed, TextOut() would have been placed here.
;note below that BeginPaint() returned a "display context", a handle
;required for drawing, but we don't normally use BeginPaint() outside
;of WM_PAINT cases -- instead we use GetDC()....
;here is what the code would look like if placed here (in C)....
;	hDC = GetDC(hWnd);
;	TextOut(hDC,10,20,"Hullo World",11);
;	ReleaseDC(hWnd,hDC);
;If we want the string to be redrawn everytime the window is redrawn,
;it is better to put TextOut() within the WM_PAINT case... this will
;also mean that "Hullo World" will appear when the window is first drawn.
	jmp 	xbreak
;.....
xpaint:
	push	WORD PTR [bp+14]	;hWnd -- handle of current window.
	lea	ax,[bp-42]	;ps -- far-addr of paint-structure.
	push	ss				;(BeginPaint() will fill the structure).
	push	ax				;	/
	call	BEGINPAINT		;BeginPaint() returns handle hDC.
	mov	[bp-146],ax	;hDC -- display-context, required
							;before can output to screen.

;For this simple demo, any redraw of the Window will cause output of our
;"hullo world" string....
		;Windows by default uses the System font, but I
		;am changing it. I need to attach the new font to the
		;display....
		push	ax				;hDC
		push	hOemFont
		call	SELECTOBJECT	;attaches hOemFont to hDC.

	push	WORD PTR [bp-146] 		;hDC					;hDC
	mov	ax,10				;16-bit x-coord
	push	ax					;	/
	mov	ax,20				;16-bit y-coord
	push	ax					;	/
	mov	ax,offset soutstring		;far-address of string to o/p
	push	ds					;	/
	push	ax					;	/ (note low half pushed 2nd)
	mov	ax,11				;number of chars in string.
	push	ax
	call	TEXTOUT

	push	WORD PTR [bp+14]	;hWnd
	lea	ax,[bp-42]	;ps -- far-addr of paint-structure.
	push	ss				;(filled by BeginPaint()).
	push	ax				;	/
	call	ENDPAINT
	jmp	SHORT xbreak
;........................
xmenu:
;comes here if WM_COMMAND message.  The two parameters associated with
;the message, lParam & wParam, tell us more....
;low-order word of lParam=0 if message is a menu-selection.
;hi-order word of lParam=1 if message is an accelerator-key.
;If low/lParam<>0, message is from a "control" (such as a scrollbar), and
;low/lParam=handle of control, hi/lParam=notification code.
;wParam contains the menu-item, the control-ID or the accelerator-key-ID.

;let's stick with menus... the .RC file assigns the number for each
;menu-item, and this is what we look for in wParam...
	cmp	WORD PTR [bp+6],0			;low-half of lParam
	jne	xbreak					;test if a menu-message.
	cmp	WORD PTR [bp+10],IDM_QUIT	;wParam.
	jne	notquit
	jmp	xquitmessage
notquit:
	cmp	WORD PTR [bp+10],IDM_ABOUT
	jne	xbreak					;no other menu items.
		;let's put up a message about this program...
		push	WORD PTR [bp+14]	;hWnd -- handle of parent window.
		mov	ax,OFFSET szaboutstr	;far-addr of string to display.
		push	ds				;	/
		push	ax				;	/
		mov	ax,OFFSET sztitlestr	;far-addr of title of dialog-box.
		push	ds				;	/
		push	ax				;	/
		mov	ax,MB_OK			;type of message-box.
		push	ax				;	/ (displays single "ok" button)
		call	MESSAGEBOX

;.........................
xbreak:
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
xreturn:
	dec	bp				;final standard manipulation of regs.
	dec	bp				;	/
	mov	sp,bp			;	/ (it is called the epilog code).
	pop	ds				;	/
	pop	bp				;	/
	dec	bp				;	/
	ret	10				;removes parameters.

WINHULLOPROC	ENDP
;.....................................................................

 END
