;WINHULLO.ASM --> WINHULLO.EXE  Windows demo program.
;This skeleton assembly language program has been written for Borland
;TASM v2.5 or later.

.MODEL SMALL

INCLUDE	WINDOWS.INC
IDM_QUIT		EQU	100		;menu-identifiers -- must be
IDM_ABOUT		EQU	101		;same as defined in .RC file.

;......
EXTRN	UPDATEWINDOW:FAR	;these are Windows functions.
EXTRN	BEGINPAINT:FAR
EXTRN	ENDPAINT:FAR
EXTRN	DEFWINDOWPROC:FAR
EXTRN	POSTQUITMESSAGE:FAR
EXTRN	REGISTERCLASS:FAR
EXTRN	GETSTOCKOBJECT:FAR
EXTRN	CREATEWINDOW:FAR
EXTRN	SHOWWINDOW:FAR
EXTRN	GETMESSAGE:FAR
EXTRN	LOADCURSOR:FAR
EXTRN	TRANSLATEMESSAGE:FAR
EXTRN	DISPATCHMESSAGE:FAR
EXTRN	LOADICON:FAR
EXTRN	TEXTOUT:FAR
EXTRN	INVALIDATERECT:FAR
EXTRN	MESSAGEBOX:FAR
EXTRN	GETDC:FAR
EXTRN	RELEASEDC:FAR
EXTRN	SELECTOBJECT:FAR
;.................................
.DATA
szwintitle	DB	'HULLO DEMO PROGRAM',0
szwinhulloname	DB	'WINHULLO',0
hOemFont	DW	0			;handle to OEM font.
soutstring 	DB	'Hullo World'
szaboutstr	DB	'Assembly Language Windows Demo',0	;messagebox
sztitlestr	DB	'Karda Prints',0			;	/

.CODE
;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC PASCAL NEAR hInstance:WORD,hPrevInstance:WORD,lpCmdLine:DWORD, \
								nCmdShow:WORD
;Define all 'automatic' data...
	LOCAL	hWnd:WORD
;window class structure for REGISTERCLASS()....
	LOCAL	s1:WNDCLASS
;message structure for GETMESSAGE()...
	LOCAL	s2:MSGSTRUCT

;Note: LOCAL inserts SUB size-of-this-structure from SP, so stack in free region.
;Note:s1, s2, equate to [bp-val], so automatically reference the stack segment.
;Can also use LOCAL to define automatic variables (equate to [bp-val]).
;...hInstance, hPrevInstance,etc,(see above) are examples of auto variables.
;...they can be accessed directly by name...

	cmp	hPrevInstance,0		;=0 if no previous instance.
	je	yes1st
	jmp	createwin
yes1st:
;Setup the window class structure for REGISTERCLASS()...
	mov 	s1.clsStyle,3
	mov 	s1.WORD PTR clsLpfnWndProc,OFFSET WinHulloProc
	mov 	s1.WORD PTR clsLpfnWndProc+2,SEG WinHulloProc
	mov 	s1.clsCbClsExtra,0
	mov 	s1.clsCbWndExtra,0
	mov	ax,hInstance
	mov 	s1.clsHInstance,ax

  call LOADICON PASCAL,null, 0,IDI_APPLICATION
	mov 	s1.clsHIcon,ax

  call LOADCURSOR PASCAL,null, 0,IDC_ARROW
	mov 	s1.clsHCursor,ax

	mov 	s1.clsHbrBackground,COLOR_BACKGROUND
	mov	ax,OFFSET szwinhulloname
	mov 	s1.WORD PTR clsLpszMenuname,ax
	mov 	s1.WORD PTR clsLpszMenuName+2,ds
	mov 	s1.WORD PTR clsLpszClassName,ax
	mov 	s1.WORD PTR clsLpszClassName+2,ds

	lea	ax,s1
  call REGISTERCLASS PASCAL,ss,ax
	or	ax,ax					;
	jne	createwin
	jmp	quitwinmain

createwin:
 call CREATEWINDOW PASCAL, ds,OFFSET szwinhulloname, ds,OFFSET szwintitle, 207,0,\
				   150, 0, 400, 300, 0, 0, hInstance, 0,0
	mov 	hWnd,ax
  call SHOWWINDOW PASCAL,ax,nCmdShow
  call UPDATEWINDOW PASCAL,hWnd
	jmp	SHORT messageloop			;go to the main message-loop.


;This is the main message loop, in which Windows waits for messages
mainloop:
	lea	ax,s2
	call	TRANSLATEMESSAGE PASCAL,ss,ax
	lea	ax,s2
	call	DISPATCHMESSAGE PASCAL,ss,ax
messageloop:
	lea 	ax,s2
	call GETMESSAGE PASCAL, ss,ax, null, null, null
	or	ax,ax
	jne	mainloop

;GetMessage() returns FALSE (AX=0) if a "quit" message...
;so here we are quiting....
	mov	ax,s2.msWPARAM		;return wparam to windows OS.
quitwinmain:
	ret
WINMAIN	ENDP

;.....................................................................

	PUBLIC	WINHULLOPROC
WINHULLOPROC PROC WINDOWS PASCAL FAR hWnd:WORD,msgtype:WORD,wParam:WORD, \
							    lParam:DWORD
	LOCAL	dummy:WORD:5	;4 or less here can cause a crash.
	LOCAL	hDC:WORD
	LOCAL	s3:PAINTSTRUCT

	mov	ax,msgtype		;get message-type.
	cmp	ax,WM_CREATE		;message received after CreateWindow()
	je	xcreate			;function is called.
	cmp	ax,WM_DESTROY		;message received if a window is closed.
	je	xquitmessage
	cmp	ax,WM_PAINT		;message received if Windows has (already)
						;redrawn any part of the window (due to
						;a size-change for example).
	je	xpaint
	cmp	ax,WM_COMMAND		;any selection of the menu will produce
	jne	notwmcommand
	jmp	xmenu			;this message.
notwmcommand:
	cmp	ax,WM_LBUTTONDOWN	;one of many mouse messages.
	jne	notwmlbutton
	jmp	xbreak
notwmlbutton:
	cmp	ax,WM_CHAR		;message that a key pressed.
	je	xchar

;Default handling of messages....
  call	DEFWINDOWPROC PASCAL,hWnd,msgtype,wParam, WORD PTR lParam+2, \
							  WORD PTR lParam
	jmp	xreturn			;Back to Windows, which will in turn
					;return to after DispatchMessage().
;.................................
xcreate:
  call	GETSTOCKOBJECT PASCAL,OEM_FIXED_FONT
	mov	hOemFont,ax		;handle to font.
	jmp	xbreak

xquitmessage:
  call	POSTQUITMESSAGE PASCAL,0
	jmp	xbreak

xchar:
	jmp 	xbreak

xpaint:
	lea	ax,s3  			;ps -- far-addr of paint-structure.
  call BEGINPAINT PASCAL,hWnd,ss,ax
	mov	hDC,ax			;hDC -- display-context, required
					;before can output to screen.

;For this simple demo, any redraw of the Window will cause output of our
;"hullo world" string....
  call	SELECTOBJECT PASCAL,ax,hOemFont
  call	TEXTOUT PASCAL,hDC,10,20, ds,OFFSET soutstring,11
	lea	ax,s3  			; -- far-addr of paint-structure.
  call	ENDPAINT PASCAL,hWnd,ss,ax
	jmp	SHORT xbreak
;........................
xmenu:
	cmp	WORD PTR lParam,0	;low-half of lParam
	jne	xbreak			;test if a menu-message.
	cmp	wParam,IDM_QUIT		;wParam.
	jne	notquit
	jmp	xquitmessage
notquit:
	cmp	wParam,IDM_ABOUT
	jne	xbreak			;no other menu items.
		;let's put up a message about this program...
call MESSAGEBOX PASCAL, hWnd, SEG szaboutstr,OFFSET szaboutstr, \
					SEG sztitlestr,OFFSET sztitlestr, MB_OK

;.........................
xbreak:
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
xreturn:
	ret

WINHULLOPROC	ENDP

;.....................................................................

 END
