;WINHULLO.ASM --> WINHULLO.EXE  Windows demo program.
;This skeleton assembly language program has been written for Microsoft
;MASM (ML.EXE) v6.0.
;Note that where a PROTO declaration has declared a parameter to be
;passed to a Windows function as 32-bit, such as a FAR pointer, in the
;TASM code I just defined two values, for example
;	call DISPATCHMESSAGE PASCAL,ss,ax
;However ML will pick this up as a type mis-match, due to the PROTO,
;but ML has a mechansim for passing a 32-bit value in two regs:
;	invoke DISPATCHMESSAGE, ss::ax
;ML also has another mechanism to make it easy to pass a NEAR or FAR
;address.  With TASM, if I had something like this...
;	call CREATEWINDOW PASCAL, ds,OFFSET szwinhulloname, ...etc...
;This is requiring the FAR address of szwinhulloname. With ML...
;	 invoke CREATEWINDOW, ADDR szwinhulloname,...etc...
;ADDR is an operator that loads the NEAR or FAR address as required.
;Note that i renamed hwnd as @hwnd, as WINDOWS.INC uses HWND as a
;data type. Ditto for hDc.


.MODEL SMALL

INCLUDE	WINDOWS.INC	;this is not the same WINDOWS.INC used by the
			;TASM programs. It is generated by H2INC.EXE,
			;and contains prototypes. Generated by...
			;  H2INC /C /Gc WINDOWS.H . . .
IDM_QUIT		EQU	100		;menu-identifiers -- must be
IDM_ABOUT		EQU	101		;same as defined in .RC file.

;......

;.................................
.DATA
szwintitle	DB	'HULLO DEMO PROGRAM',0
szwinhulloname	DB	'WINHULLO',0
hOemFont	DW	0			;handle to OEM font.
soutstring 	DB	'Hullo World'
szaboutstr	DB	'Assembly Language Windows Demo',0	;messagebox
sztitlestr	DB	'Karda Prints',0			;	/

.CODE
;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC NEAR PASCAL, hInstance:WORD,hPrevInstance:WORD,lpCmdLine:LPSTR, \
								nCmdShow:SWORD
;Define all 'automatic' data...
	LOCAL	@hWnd:HWND
;window class structure for REGISTERCLASS()....
	LOCAL	s1:WNDCLASS
;message structure for GETMESSAGE()...
	LOCAL	s2:MSG

	cmp	hPrevInstance,0		;=0 if no previous instance.
	je	yes1st
	jmp	createwin
yes1st:
;Setup the window class structure for REGISTERCLASS()...
	mov 	s1.Style,3
	lea	di,s1.lpfnwndproc
	mov 	[di],OFFSET WinHulloProc
	mov 	[di+2],SEG WinHulloProc
	mov 	s1.CbClsExtra,0
	mov 	s1.CbWndExtra,0
	mov	ax,hInstance
	mov 	s1.HInstance,ax

  invoke LOADICON,null, IDI_APPLICATION
	mov 	s1.@HIcon,ax

  invoke LOADCURSOR,null, IDC_ARROW
	mov 	s1.@HCursor,ax

	mov 	s1.hbrBackground,COLOR_BACKGROUND
	mov	ax,OFFSET szwinhulloname
	lea	di,s1.lpszmenuname
	mov 	[di],ax
	mov 	[di+2],ds
	lea	di,s1.lpszclassname
	mov 	[di],ax
	mov 	[di+2],ds

	lea	ax,s1
  invoke REGISTERCLASS,ss::ax
	or	ax,ax
	jne	createwin
	jmp	quitwinmain

createwin:
 invoke CREATEWINDOW, ADDR szwinhulloname, ADDR szwintitle, 00CF0000h,\
				   150, 0, 400, 300, 0, 0, hInstance, 0
	mov 	@hWnd,ax
  invoke SHOWWINDOW,ax,nCmdShow
  invoke UPDATEWINDOW,@hWnd
	jmp	SHORT messageloop			;go to the main message-loop.


;This is the main message loop, in which Windows waits for messages
mainloop:
	lea	ax,s2
	invoke	TRANSLATEMESSAGE,ss::ax
	lea	ax,s2
	invoke	DISPATCHMESSAGE,ss::ax
messageloop:
	lea 	ax,s2
	invoke GETMESSAGE, ss::ax, null, null, null
	or	ax,ax
	jne	mainloop

;GetMessage() returns FALSE (AX=0) if a "quit" message...
;so here we are quiting....
	mov	ax,s2.WPARAM		;return wparam to windows OS.
quitwinmain:
	ret
WINMAIN	ENDP
;....................................................................

;.....................................................................
;Note that TEXTEQU is not the same as EQU.  This is a source of
;serious incompatibility with earlier MASM's.  MASM-6 does not allow
;EQU to provide a text alias... to do that you must use TEXTEQU,
;and the text to be aliased must be between "< >", as shown...

	@hwnd	TEXTEQU	<WORD PTR [bp+14]>
	msgtype	TEXTEQU	<WORD PTR [bp+12]>
	wparam	TEXTEQU	<WORD PTR [bp+10]>
	lparam	TEXTEQU	<DWORD PTR [bp+6]>
	dummy	TEXTEQU	<WORD PTR [bp-10]>
	@hdc	TEXTEQU	<WORD PTR [bp-12]>
	s3	TEXTEQU	<[bp-(12+SIZE PAINTSTRUCT)]>


;	PUBLIC	WINHULLOPROC
;WINHULLOPROC PROC FAR PASCAL, @hWnd:HWND,msgtype:WORD,wParam:WORD, \
;							    lParam:DWORD
;	LOCAL	dummy [5]:WORD	;4 or less here can cause a crash.
;	LOCAL	@hDC:HDC
;	LOCAL	s3:PAINTSTRUCT

	PUBLIC	WINHULLOPROC
WINHULLOPROC PROC FAR
	push	ds	;prolog code
	pop	ax
	nop
	inc	bp
	push	bp
	mov	bp,sp
	push	ds
	mov	ds,ax
;	sub	sp,100	;leave sufficient space for local data.
;no, you can do it more precisely...
 lea	sp,s3	;move stack to beyond local data.

	mov	ax,msgtype		;get message-type.
	cmp	ax,WM_CREATE		;message received after CreateWindow()
	je	xcreate			;function is called.
	cmp	ax,WM_DESTROY		;message received if a window is closed.
	je	xquitmessage
	cmp	ax,WM_PAINT		;message received if Windows has (already)
						;redrawn any part of the window (due to
						;a size-change for example).
	je	xpaint
	cmp	ax,WM_COMMAND		;any selection of the menu will produce
	jne	notwmcommand
	jmp	xmenu			;this message.
notwmcommand:
	cmp	ax,WM_LBUTTONDOWN	;one of many mouse messages.
	jne	notwmlbutton
	jmp	xbreak
notwmlbutton:
	cmp	ax,WM_CHAR		;message that a key pressed.
	je	xchar

defhandler:
;Default handling of messages....
  invoke DEFWINDOWPROC,@hWnd,msgtype,wParam, lParam
	jmp	xreturn

;.................................
xcreate:
  invoke	GETSTOCKOBJECT,OEM_FIXED_FONT
	mov	hOemFont,ax		;handle to font.
	jmp	xbreak

xquitmessage:
  invoke	POSTQUITMESSAGE,0
	jmp	xbreak

xchar:
	jmp 	xbreak

xpaint:
	lea	ax,s3  			;ss:ax -- far-addr of paint-structure.
  invoke BEGINPAINT,@hWnd,ss::ax
	mov	@hDC,ax			;hDC -- display-context, required
					;before can output to screen.

;For this simple demo, any redraw of the Window will cause output of our
;"hullo world" string....
  invoke	SELECTOBJECT,ax,hOemFont
  invoke	TEXTOUT,@hDC,10,20, ADDR soutstring,11
	lea	ax,s3  			; -- far-addr of paint-structure.
  invoke	ENDPAINT,@hWnd,ss::ax
	jmp	SHORT xbreak
;........................
xmenu:
	cmp	WORD PTR lParam,0	;low-half of lParam
	jne	xbreak			;test if a menu-message.
	cmp	wParam,IDM_QUIT		;wParam.
	jne	notquit
	jmp	xquitmessage
notquit:
	cmp	wParam,IDM_ABOUT
	jne	xbreak			;no other menu items.
		;let's put up a message about this program...
 invoke MESSAGEBOX, @hWnd, ADDR szaboutstr, ADDR sztitlestr, MB_OK

;.........................
xbreak:
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
xreturn:


	dec	bp	;Windows epilog
	dec	bp
	mov	sp,bp
	pop	ds
	pop	bp
	dec	bp
	ret	10

WINHULLOPROC	ENDP
;.....................................................................

 END
