;DPMI2.ASM --> DPMI2.EXE  Windows DPMI program.
;this program demonstrates hooking a hardware interrupt.
;It hooks INT-9 in the IDT (Interrupt Descriptor Table), and the ISR
;(Interrupt Service Routine) is part of this program (not in a separate
;code segment, nor as a DLL -- for an example of the latter, look
;in the Companion Disk in \ISR-DLL).
;All that this ISR does is cause a beep on the loudspeaker every
;time a key is pressed or released.  You only need to double-click
;on DPMI.EXE to install the ISR -- it will continue to function even
;when the window is iconised or overlapped.  Exiting from the program
;will unhook the ISR.
;NOTE that with Windows Enhanced mode, the ISR will continue to
;function even while a DOS program (or the DOS prompt) is running,
;due to the preemptive timeslicing between VM's (Virtual Machines)...
;...however, although hardware interrupts first go to the IDT, we
;are hooking a "virtualised IDT" (see diagram in Chapter 12)... so
;...the virtualised (or reflected) vector doesn't actually get called.
;Instead, Windows redirects control down to the IVT.  What this
;means is that you won't get beeps while in a DOS box.
;NOTE that GLOBALFIX() is likely to cause a malfunction in Standard
;mode when a DOSApp is run. I show below how to test which mode
;Windows is in.
;NOTE that the ISR itself does not send the beep to the loudspeaker 
;(though it could). For demonstration purposes, the ISR calls
;POSTMESSAGE() to send a message to the callback of this (DPMI.EXE)
;program.  It is the callback that processes the message and generates
;a beep.
;Thus this program demonstrates preemption within Windows. 

.286
.MODEL SMALL

INCLUDE	WINDOWS.INC
IDM_QUIT		EQU	100		;menu-identifiers -- must be
IDM_ABOUT		EQU	101		;same as defined in .RC file.

;......

EXTRN	UPDATEWINDOW:FAR	;these are Windows functions.
EXTRN	BEGINPAINT:FAR
EXTRN	ENDPAINT:FAR
EXTRN	DEFWINDOWPROC:FAR
EXTRN	POSTQUITMESSAGE:FAR
EXTRN	REGISTERCLASS:FAR
EXTRN	GETSTOCKOBJECT:FAR
EXTRN	CREATEWINDOW:FAR
EXTRN	SHOWWINDOW:FAR
EXTRN	GETMESSAGE:FAR
EXTRN	LOADCURSOR:FAR
EXTRN	TRANSLATEMESSAGE:FAR
EXTRN	DISPATCHMESSAGE:FAR
EXTRN	LOADICON:FAR
EXTRN	TEXTOUT:FAR
EXTRN	INVALIDATERECT:FAR
EXTRN	MESSAGEBOX:FAR
EXTRN	GETDC:FAR
EXTRN	RELEASEDC:FAR
EXTRN	SELECTOBJECT:FAR
EXTRN	GETWINFLAGS:FAR
;.........
EXTRN	GETMODULEHANDLE:FAR
EXTRN	GETPROCADDRESS:FAR
EXTRN	GETBIOSKEYPROC:FAR
EXTRN	DOS3CALL:FAR
EXTRN	DISABLE:FAR
;....
EXTRN	ENABLEHARDWAREINPUT:FAR
EXTRN 	POSTMESSAGE:FAR
EXTRN	LOCKSEGMENT:FAR
EXTRN	GLOBALHANDLE:FAR
EXTRN	GLOBALFIX:FAR
EXTRN	GLOBALPAGELOCK:FAR
;.....
.DATA
wintitle	DB	'DPMI DEMO PROGRAM',0
windpminame	DB	'DPMI',0
hOemFont	DW	0			;handle to OEM font.
outstring 	DB	'Hullo World'
aboutstr	DB	'Assembly Language Hardware ISR Demo',0	;messagebox
titlestr	DB	'Karda Prints',0			;	/
;.......
offdosint9	DW	0	;the original dos int-9 vector.
segdosint9	DW	0	;	/
;......
dpmiflag	DB	0	;=1 dpmi running okay
dpmiversion	DW	0	;ah=major, al=minor.
mode386flag	DB	0	;=1 386 dpmi type.
realmodeintsflag  DB	0	;=1 real mode interr.
virtualmemflag  DB	0	;=1 virt. mem support.
cputype	DB	0	;=2,3,4  286,386,486
AOOOselector	DW	0	;selector video-RAM
OOOOselector	DW	0
winvideomode	DB	0
isrinstalled	DB	0	;set if isr's installed.

.CODE
;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC PASCAL NEAR hInstance:WORD,hPrevInstance:WORD,lpCmdLine:DWORD, \
								nCmdShow:WORD
	LOCAL	hWnd:WORD
	LOCAL	s1:WNDCLASS
	LOCAL	s2:MSGSTRUCT

	cmp hPrevInstance,0
	je	qqqq
	jmp	quitwinmain	;disable multiple instances
qqqq:

;lock the code into linear memory...
;	call	GLOBALHANDLE PASCAL,cs	;hMem-->ax
;	call	GLOBALFIX PASCAL,ax
;... will speed up ISR access, as will always remain in RAM.
;... however, crashes a DOSApp in Standard mode!
;... do NOT rely on FIXED specification in .DEF file.
;Also, for Enhanced mode, need to lock pages also...
	call	GLOBALPAGELOCK PASCAL,cs

	mov	ax,1686h		;test if dpmi running.
	int	2Fh
	or	ax,ax
	jz	yesitis
	jmp	quitwinmain
yesitis: mov	dpmiflag,1		;set flag, dpmi okay.
	mov	ax,0400h		;get dpmi version.
	int	31h
	mov	dpmiversion,ax
	mov	al,bl
	and	al,01		;bit-0 =1 if 386 dpmi
	mov	mode386flag,al
	mov	al,bl
	shr	al,1
	and	al,01	;bit-1 =1 if not virtual86 int handling
	mov	realmodeintsflag,al
	shr	bl,2
	and	bl,01	;bit-2 =1 if virtual mem. supported.
	mov	virtualmemflag,bl
	mov	cputype,cl	;cl=2,3,4 if 286, 386, or 486.

	mov	ax,2
	mov	bx,0A000h  	;segment addr of video RAM.
	int	31h
	mov	AOOOselector,ax	;note - dont start a label with 0-9.
	mov	ax,2
	mov	bx,0000
	int	31h
	mov	OOOOselector,ax

	mov	ah,0Fh		;get current video mode.
	int	10h
	mov	winvideomode,al

;Setup the window class structure for REGISTERCLASS()...
	mov 	s1.clsStyle,3
	mov 	s1.WORD PTR clsLpfnWndProc,OFFSET DPMICALLBACK
	mov 	s1.WORD PTR clsLpfnWndProc+2,SEG DPMICALLBACK
	mov 	s1.clsCbClsExtra,0
	mov 	s1.clsCbWndExtra,0
	mov	ax,hInstance
	mov 	s1.clsHInstance,ax
  call FAR PTR LOADICON PASCAL,null, 0,IDI_APPLICATION
	mov 	s1.clsHIcon,ax
  call FAR PTR LOADCURSOR PASCAL,null, 0,IDC_ARROW
	mov 	s1.clsHCursor,ax
	mov 	s1.clsHbrBackground,COLOR_BACKGROUND
	mov	ax,OFFSET windpminame
	mov 	s1.WORD PTR clsLpszMenuname,ax
	mov 	s1.WORD PTR clsLpszMenuName+2,ds
	mov 	s1.WORD PTR clsLpszClassName,ax
	mov 	s1.WORD PTR clsLpszClassName+2,ds
	lea	ax,s1
  call FAR PTR REGISTERCLASS PASCAL,ss,ax
	or	ax,ax					;
	jne	createwin
	jmp	quitwinmain
;....
createwin:
 call FAR PTR CREATEWINDOW PASCAL, ds,OFFSET windpminame, ds,OFFSET wintitle, 207,0,\
				   150, 0, 400, 300, 0, 0, hInstance, 0,0
	mov 	hWnd,ax
  call FAR PTR SHOWWINDOW PASCAL,ax,nCmdShow
  call FAR PTR UPDATEWINDOW PASCAL,hWnd
	jmp	SHORT messageloop			;go to the main message-loop.
;.....
;This is the main message loop, in which Windows waits for messages
mainloop:
	lea	ax,s2
	call	FAR PTR TRANSLATEMESSAGE PASCAL,ss,ax
	lea	ax,s2
	call	FAR PTR DISPATCHMESSAGE PASCAL,ss,ax
messageloop:
	lea 	ax,s2
	call FAR PTR GETMESSAGE PASCAL, ss,ax, null, null, null
	or	ax,ax
	jne	mainloop
	mov	ax,s2.msWPARAM		;return wparam to windows OS.
quitwinmain:
	ret
WINMAIN	ENDP

;.....................................................................

	PUBLIC	DPMICALLBACK
DPMICALLBACK PROC WINDOWS PASCAL FAR hWnd:WORD,msgtype:WORD,wParam:WORD, \
							    lParam:DWORD
	LOCAL	dummy:WORD:5
	LOCAL	hDC:WORD
	LOCAL	s3:PAINTSTRUCT
;
	mov	ax,msgtype
	cmp	ax,WM_CREATE
	je	xcreate
	cmp	ax,WM_DESTROY
	je	xquitmessage
	cmp	ax,WM_PAINT
	jne nxpaint
	jmp	xpaint
nxpaint:
;	cmp	ax,WM_MOVE
;	je	xpaint
	cmp	ax,WM_COMMAND
	jne	notwmcommand
	jmp	xmenu
notwmcommand:
	cmp	ax,WM_LBUTTONDOWN
	jne	notwmlbutton
	jmp	xbreak
notwmlbutton:
	cmp	ax,WM_CHAR
	jne	xdefhandle
	jmp	xchar
xdefhandle:
	cmp	ax,WM_USER
	jne	nuser
	push ax			;Comes here if WM_USER message
	push dx
	mov ah,2	;write char to scrn
	mov dl,07	;beep
	int 21h
	pop dx
	pop ax
	jmp xdef
nuser:	cmp	ax,WM_USER+1	;message sent from xcreate.
	jne	xdef
	call	installint	;install idt hook.
	mov	isrinstalled,1	;flags that isr now installed.
	jmp	xbreak

xdef:
;Default handling of messages....
  call	FAR PTR DEFWINDOWPROC PASCAL,hWnd,msgtype,wParam, WORD PTR lParam+2, \
							  WORD PTR lParam
	jmp	xreturn
;.................................
xcreate:
  call	FAR PTR GETSTOCKOBJECT PASCAL,OEM_FIXED_FONT
	mov	hOemFont,ax		;handle to font.
;Best to install the ISR indirectly...
	call POSTMESSAGE PASCAL,hwnd,WM_USER+1,0, 0,0
	jmp	xbreak

xquitmessage:
  call	FAR PTR POSTQUITMESSAGE PASCAL,0

;unhook INT-9 in IDT...
   	push dx
   	push ds
   	mov dx,offsetint
    	mov ax,selectorint
    	mov	ds,ax
 	mov ax,2509h  
 	int 21h
 	pop ds
 	pop dx
	mov	isrinstalled,0	;flag that INT-9 now unhooked.
	jmp	xbreak

xpaint:			;WM_PAINT & WM_MOVE both come here.
  call	DEFWINDOWPROC PASCAL,hWnd,msgtype,wParam,lParam
  jmp   xreturn
;........................
xmenu:
	cmp	WORD PTR lParam,0	;low-half of lParam
	jne	xbreak			;test if a menu-message.
	cmp	wParam,IDM_QUIT		;wParam.
	jne	notquit
	jmp	xquitmessage
notquit:
	cmp	wParam,IDM_ABOUT
	jne	xbreak			;no other menu items.
		;let's put up a message about this program...
 call FAR PTR MessageBox PASCAL, hWnd, SEG aboutstr,OFFSET aboutstr, \
					SEG titlestr,OFFSET titlestr, MB_OK
;	call installint
	jmp xbreak
xchar:
	jmp 	xbreak

;.........................
xbreak:
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
xreturn:
	ret

DPMICALLBACK	ENDP
;................................................................
.DATA
offsetint		DW	0	;old  idt vector
selectorint	DW	0	;	/

.CODE
dsselector 	DW 0			;data alias to code seg
dataselector	DW	0	;selector of this WinApps data seg.
hwndcs 		DW 	0	;save window handle for use in isr
enhancedmode	DB	0	;set if in enhanced mode.

installint PROC   	;no params
install:
	pusha
 	push es
 	push ds

;will create alias in ldt ...
	mov	ax,000Ah	;create alias data descriptor for code segment.
	push	cs
	pop	bx		;selector to be aliased
	int 31h		;returns ax
   push ax
   pop es
   mov ax,hwnd
   mov es:hwndcs,ax	;save handle of window in code seg.
   mov ax,es
   mov es:dsselector,ax	;save data alias in code seg.
   mov	es:dataselector,ds	;save ds in code seg.

	push	es	;save
	call	GETWINFLAGS PASCAL	;flags --> dx:ax
	pop	es	;restore
	and	ax,0020h	;ax=xxxx xxxx xx1x xxxxb if enhanced mode
	jz	eeee
	mov	es:enhancedmode,1	;save in code seg (for isr)
eeee:

 mov al,9  	;get vector in idt.. 9...
 mov	ah,35h          ;-->ES:BX
 int 21h
 push es
 pop  ax
 mov	offsetint,bx	;save old int-9 idt vector
 mov	selectorint,ax	;	/

 mov	dx,OFFSET runtime	;hook int-9 in idt...
  push	cs
 pop	ds	;new vector in ds:dx
 mov	al,9  	;
 mov	ah,25h	;set vector
 int	21h

  pop	ds	;restore ds.

	push	ds	;save it again
 ;let's hook int60 in idt, to use as old vector...
 mov dx,offsetint
 mov ds,selectorint
 mov ax,2560h
 int 21h

getout:
	pop	ds
 	pop 	es
	popa
 ret

;...........................................................
runtime:	;isr for prot mode interrupts, via idt.
	int 60h	;call old int-9 (vector saved here).
	pusha
	push 	ds
	push 	es
	mov 	es,cs:dsselector
	mov 	ax,cs:hwndcs
	push ax
	push WM_USER
	push 0
	push 0
	push 0
	call POSTMESSAGE	
	pop 	es		
	pop 	ds
	popa
	iret

installint ENDP
;..............................................................

	END
