;TSR2WIN.ASM --> TSR2WIN.EXE
;Chapter 14, "Windows Assembly Language & Systems Programming"
;by Barry Kauler (c)1997.
;This is a Windows-aware TSR, that is loaded before Windows.
;When Windows loads, this TSR will automatically cause a
;Windows application to start, and will automatically load
;a virtual device driver.

;This TSR must *not* be a separate file --
;it is specified as the "DOS stub" for the virtual device
;driver (VxD) that is to be automatically loaded.
;-- if your only requirement is to autoload a Windows app., then
;you can have this TSR stand-alone
;(or as a stub for the WinApp).

;The Windows application is called WINAPP.EXE
;the virtual device driver is called VDEMOD.EXE
;-- WINAPP must be in the root directory (or path spec'd below)
;-- VDEMOD.EXE can be anywhere.
;An interesting aspect of this TSR, is that it creates a
;global data structure and passes a FLAT 32-bit pointer via
;the IVT -- WINAPP and VDEMOD can access this pointer.

;Note that this TSR is a .EXE file, but data is in the code
;segment -- makes it easier to make into a TSR.

;More notes:
;Note that the VXD does not have .386 extension, as it must execute
;its stub from dos.
;to assemble & link:   TASM TSR2WIN and TLINK TSR2WIN, or ML TSR2WIN.ASM

.286
.MODEL SMALL		;16-bit Real mode app.
.STACK
.DATA

;...........................................................
.CODE
start:  jmp     installhooks

    winloaded   DB      0
    dpmiloaded  DB      0
    winmode     DB      0
    oldoffivt2F Dw      0       ;2F saved vector.
    oldsegivt2F DW      0       ;       /
    oldoffivt1C DW      0       ;1C saved vector.
    oldsegivt1C DW      0       ;       /
    oldoffivt9  DW      0
    oldsegivt9  Dw      0
    oldoffivt28 DW      0
    oldsegivt28 DW      0
    timeout1    DW      0       ;timeout for windows loading.
    bypass1C    DB      0       ;fix reentrancy problems.
    bypass28    DB      0       ;       /
    killkeyboard DB     1  ;0       ;=1 disable keyboard.
    dosbusyoff  DW      0
    dosbusyseg  Dw      0
;    isrwanted	 DB	 0	 ;=0
;    temp1	 DB	 0	 ;count of isrwanted's, so not to lose any.
;currenttime	 DW	 0	 ;used by runtime28, time in minutes.
;lasttime	Dw	0	;  / used as timeout, checking WINAPP active.

WIN386_STARTUP_INFO_STRUC       STRUC
SIS_VERSION		DB	3,0	  ;put 4,0 for win95.??
SIS_NEXT_PTR		DD	0
SIS_VIRT_DEV_FILE_PTR   DD      0
SIS_REFERENCE_DATA	DD	0
SIS_INSTANCE_DATA_PTR	DD	0
SIS_OPT_INSTANCE_DATA_PTR DD	0	   ;field required for win95.
WIN386_STARTUP_INFO_STRUC       ENDS

InstData Win386_Startup_Info_Struc <>


TSR_Info_Struc  STRUC
    TSR_Next		    dd	0
    TSR_PSP_Segment	    dw	0
    TSR_API_Ver_ID          dw  100h
    TSR_Exec_Flags          dw  0
    TSR_Exec_Cmd_Show       dw  0
    TSR_Exec_Cmd            dd  0
    TSR_Reserved            db  4 dup (0)
    TSR_ID_Block            dd  0
    TSR_Data_Block          dd  0
TSR_Info_Struc ENDS

tsr_info        TSR_INFO_STRUC  <>

Exec_Path_Name	db  "C:\WINAPP.EXE",0,0 ;path and filename of winapp.

psp_size        DW      0

My_ID_Block     dw  ?
My_Name 	db  'TSR autoload WinApp & VxD',0
My_Name_End     LABEL BYTE

;this ptr must get put into INT-60h....
INCLUDE GLOBL.INC	;global data, to be accessed by WINAPP & VDEMOD.
globaldata      GLOBALSTRUCTURE <>      ;instanced here only, but include
					;file must be in other programs.

;******************************************************************
runtime2F:
;entered when Windows loads, with AX=1605h, and when Windows unloads,
;with AX=1606h....
;detect when Windows loads, and set a flag ...
	sti                     ;documentation says this req'd.

	cmp     ax,1608h        ;enhanced mode loaded.
	jne     nexttry
	mov	cs:winloaded,1
	jmp     SHORT go2F

nexttry:
	cmp     ax,1605h        ;test if Win is loading
	jne     notload
	cmp     cx,0            ;this must always be 0, else error.
	jne     goerror2F
	mov     cs:winmode,dl   ;bit-0=0 if enhanced mode.
	test    dl,1            ;test bit-0
	jnz     standardload

;..................................................
;from GPTRAP.386 (DDK)...
;inserts our vxd into vxd chain....(see my book Appendix D)
	mov	word ptr cs:[instdata.SIS_Next_Ptr],bx
	mov	word ptr cs:[instdata.SIS_Next_Ptr][2],es
	push	cs
	pop	es		;chain, with es:bx ptg to our instdata
	lea	bx,InstData	;structure (our VxD data structure).
;...............

standardload:
	jmp     SHORT go2F

;..........
notload: cmp    ax,1606h        ;test if Win is unloading.
	jne     notunload
	mov     cs:winloaded,0
	mov     cs:dpmiloaded,0
	jmp     SHORT go2F
;..........

notunload:
	cmp     ax,160Bh        ;used for tsr registration with windows.
	jne     giveitanothergo
	jmp	dorego

giveitanothergo:

  jmp go2F ;***temp*** ;code below *was* working once upon a time
			;but something wrong now.

	cmp     ax,1687h
	je      go2F            ;otherwise will get in endless loop!
	cmp     cs:dpmiloaded,0
	jne     go2F            ;for all other cases, exit.

;after Windows has loaded, *if* we want to hook the IDT, need to test if ok...
	cmp     cs:winloaded,0
	je      go2F
;a problem exits... what if come here before the idt properly setup?...
	pusha
	mov     ax,1687h        ;test for dpmi host
	int     2Fh
	cmp     ax,0            ;ax=0 if dpmi host present.
	jne     exit5
	mov     cs:dpmiloaded,1
exit5:  popa

goerror2F:
go2f:
	jmp DWORD PTR cs:oldoffivt2F
;.........................................................................

dorego:
    ; return a pointer to the TSR structure
    mov     WORD PTR cs:[TSR_Info.TSR_Next], di
    mov     WORD PTR cs:[TSR_Info.TSR_Next+2], es
    push  cs
    pop   es
    mov     di, OFFSET TSR_Info
    jmp     go2f
;.......................................................................

;.....................................................................
longbeep:
	pusha
	mov     al,0B6h         ;turn on loudspeaker
	out     43h,al
	mov     bx,07C5h
	mov     al,bl
	out     42h,al
	mov     al,bh
	out     42h,al
	in      al,61h
	or      al,3
	out     61h,al
	mov     cx,0ffffh
xxx:    nop
	pusha                   ;just to kill time
	popa
	loop    xxx
	in      al,61h          ;turn off loudspeaker
	and     al,0FCh
	out     61h,al
	popa
	ret
;................................................................


;*****************************************************************
    DB      17      DUP(0)
dumpme:
;.................................................................
installhooks:

;is this tsr already installed?... i have given it a signature of CCh...
	push    es              ;just in case
	mov     ax,0CC00h        ;AL=0 is install-test code for my 2F handler.
	int     2Fh             ;multiplex interrupt (that we will hook)
	pop     es
	or      al,al           ;AL=non-0 means abort.
	jz      abba
	jmp     abortload
abba:

;**********************************************************************
	push    cs
	pop     ds              ;note cs: overrides thus not really reqd.
;got this out of \DDK\SAMPLES\GPTRAP.386 sample vxd....
;enables us to load a vxd without device= entry in system.ini.

; get a pointer to the name of the load file in the environment seg.
;entered with es=psp...
	mov     ax,es
	mov     bx,cs
	mov     WORD PTR cs:[TSR_info.TSR_PSP_Segment], ax
	sub     bx, ax                          ; size (in paras) of PSP
	mov     WORD PTR cs:[PSP_Size], bx
	mov     bx,2ch                  ;environment segment
	mov     es,es:[bx]
	xor     di,di
	mov     cx,-1                   ;big number
	xor     al,al                   ;search for a null
	cld
qq:
	repne   scasb                   ;get past one null and stop
	cmp     byte ptr es:[di],0      ;another null
	jnz     qq                      ;no.
	add     di,3                    ;skip the word before the name.

; prepare part of the instance data list. Stuff in pointer to the file name
; and reference data
	mov     word ptr CS:[instdata.SIS_Version],0A03h
	mov     word ptr CS:[instdata.SIS_Virt_Dev_File_Ptr],di
	mov     word ptr CS:[instdata.SIS_Virt_Dev_File_Ptr][2],es
	mov     word ptr cs:[instdata.SIS_Instance_Data_Ptr],0
	mov     word ptr cs:[instdata.SIS_Instance_Data_Ptr][2],0

;notes: it seems that this searches the environment-block, looking for
;fully-specified path/filename of this file (*VDEMOD.EXE*),
;then, inserts this address (es:di) into instdata.
;SIS_Virt_Dev_File_Ptr is the address of the vxd's filename. Note that it
;is normally assumed to be in the windows system directory -- but we are
;using the TSR's path -- as the TSR is a stub of the VxD.


;***************************************************************
;next problem, is we need to force WINAPP, our win-app, to load...


;insert this, from TSR.ASM (off knowledge-base CDROM),
;example of tsr_info usage...

; Initialize length of ID string
    mov     WORD PTR cs:[My_ID_Block], OFFSET My_Name_End - OFFSET My_Name

    mov     WORD PTR cs:[TSR_Info.TSR_Exec_Cmd], OFFSET Exec_Path_Name
    mov     WORD PTR cs:[TSR_Info.TSR_Exec_Cmd+2],cs
    mov     WORD PTR cs:[TSR_Info.TSR_Exec_Flags],1 ;=TSR_WINEXEC
;    mov     WORD PTR cs:[TSR_Info.TSR_Exec_Cmd_Show],4 ;=SW_SHOWNOACTIVATE
    mov     WORD PTR cs:[TSR_Info.TSR_Exec_Cmd_Show],1 ;=SW_SHOWNORMAL
    mov     WORD PTR cs:[TSR_Info.TSR_ID_Block], OFFSET My_ID_Block
    mov     WORD PTR cs:[TSR_Info.TSR_ID_Block+2],cs
    mov     WORD PTR cs:[TSR_Info.TSR_Data_Block], 0
    mov     WORD PTR cs:[TSR_Info.TSR_Data_Block+2], 0

;*****************************************************************

;get the addr of the dos-busy flag...
	mov     ah,34h
	int     21h             ;-->es:bx
	mov     dosbusyoff,bx
	mov     dosbusyseg,es


;hook int-2Fh vector in ivt.  Windows calls this with AX=1605h when it loads,
;with regs telling useful info, such as if loading in Standard or
;Enhanced mode....
	mov     ax,352Fh                ;get int-2F vector in ivt.
	int     21h                     ;       /
	mov     oldoffivt2F,bx  ;save it
	mov     oldsegivt2F,es  ;       /
	mov     ax,252Fh        ;hook int-2F
	lea     dx,runtime2F    ;set ivt vector. ds:dx
	int     21h                     ;       /


;finally, pass the address of our global data...
	lea     dx,globaldata
	mov     ax,ds
	shl     ax,4            ;convert para. to offset.
	jc      over64k
	add     dx,ax           ;get FLAT linear 32-bit address
	xor     ax,ax           ;       /
	mov     ds,ax           ;       / -->ds:dx
bb2:    mov     ax,2560h                ;hook int-60h
	int	21h		;ds:dx-->ivt60
	push    cs
	pop     ds              ;restore ds
	jmp     SHORT bb3
;i.e., real address is segment=0, offset=dx (works only if in 1st 64K).
;WINAPP can check the hi 2 bytes of int-60h ivt, to confirm that they
;are zero, and that no other program has overwritten.
;no, be careful...take care of over 64K...
over64k:
	add     dx,ax           ;as above (not likely to produce carry)
	mov     ax,1            ;this is the carry.
	mov     ds,ax
	jmp     bb2
bb3:

;terminate, leave resident....
	lea     dx,dumpme  ;point past all code in this module.
	shr     dx,4            ;compute # paragraphs to keep.
	add     dx,psp_size     ;       /
	mov     ax,3100h        ;terminate and stay resident.
	int     21h     ;       /

abortload:
	call    longbeep
	mov     ax,4C00h        ;don't make resident.
	int     21h

;....................................................................
;**************************************************************************

	END     start
