TITLE VDEMOD -
;example skeleton VxD, adapted from a skeleton in Microsoft's DDK.
;It is possible to monitor any I/O port, and allow or disallow
;it use.  Install_IO_Handler achieves this.


        .386p

        .XLIST
	INCLUDE VMM.Inc 	;supplied with DDK (or VxD-Lite)
	INCLUDE Debug.Inc	;/
	INCLUDE Shell.inc	;/
	.LIST
;.........................................................................
Declare_Virtual_Device VDEMOD, 3, 0, VDEMOD_Control, \
			Undefined_Device_ID, VMM_INIT_ORDER,,

;.........................................................................
;local data...

VxD_LOCKED_DATA_SEG
Device_Name   DB     "VDEMOD  ",0
VDEMOD_Owner  DD     ?
VxD_LOCKED_DATA_ENDS

;.........................................................................
;initilisation code...

VxD_ICODE_SEG

BeginProc VDEMOD_Device_Init

beep:	push eax
	mov     al,0B6h         ;turn on loudspeaker
	out     43h,al
	mov     bx,05C5h
	mov     al,bl
	out     42h,al
	mov     al,bh
	out     42h,al
	in      al,61h
	or      al,3
	out     61h,al
        pop eax

;firstly, let's hook anything (port 200h) and show a generalised
;handler...
	mov	edx, 200h
	mov	esi, OFFSET32 My_VDEMOD_Hook
        VMMCall Install_IO_Handler

;now, let's prevent printing...
        mov     edx, 3BDh                       ;lpt status
	mov	esi, OFFSET32 My_VDEMOD_lpt_Hook
        VMMCall Install_IO_Handler

        mov     edx, 379h                       ;lpt status
	mov	esi, OFFSET32 My_VDEMOD_lpt_Hook
        VMMCall Install_IO_Handler

        mov     edx, 279h                       ;lpt status
	mov	esi, OFFSET32 My_VDEMOD_lpt_Hook
        VMMCall Install_IO_Handler
;.....
        mov     edx, 3BEh                       ;lpt control
	mov	esi, OFFSET32 ctrl_VDEMOD_lpt_Hook
        VMMCall Install_IO_Handler

        mov     edx, 37Ah                       ;lpt control
	mov	esi, OFFSET32 ctrl_VDEMOD_lpt_Hook
        VMMCall Install_IO_Handler

        mov     edx, 27Ah                       ;lpt control
	mov	esi, OFFSET32 ctrl_VDEMOD_lpt_Hook
        VMMCall Install_IO_Handler


        xor     eax, eax
	mov	VDEMOD_Owner, eax	       ; no current owner
        
IFDEF DEBUG
	Trace_Out "VDEMOD installed"
ENDIF

        clc
        ret

EndProc VDEMOD_Device_Init

VxD_ICODE_ENDS

;.........................................................................
;main code segment...

VxD_CODE_SEG

BeginProc VDEMOD_Destroy_VM

	cmp	ebx, VDEMOD_Owner	       ; Destroying device owner?
        jnz     short VDM_Exit

        xor     eax, eax
	mov	VDEMOD_Owner, eax	       ; no current owner
        
VDM_Exit:
        clc
        ret

EndProc VDEMOD_Destroy_VM

VxD_CODE_ENDS

;.........................................................................
;locked code... the callbacks...

VxD_LOCKED_CODE_SEG

BeginProc VDEMOD_Control

	Control_Dispatch Device_Init, VDEMOD_Device_Init
	Control_Dispatch Destroy_VM, VDEMOD_Destroy_VM
        clc
        ret

EndProc VDEMOD_Control

VxD_LOCKED_CODE_ENDS

;.........................................................................
;the hooked ports get redirected here...

VxD_CODE_SEG

BeginProc My_VDEMOD_Hook

;firstly, resolve contention...
	pushad					; save regs
	mov	eax, VDEMOD_Owner	       ; get previous owner
        cmp     eax, ebx                        ; same as current owner?
        jz      short process_io                ; yes, just handle it
        or      eax, eax                        ; was there an old owner?
        jz      short new_owner                 ; no

        mov     esi, OFFSET32 Device_Name
        VxDCall Shell_Resolve_Contention

        jc      short dont_process              ; hmmm, couldn't resolve

	cmp	ebx, VDEMOD_Owner	       ; if contention winner is
                                                ; the current owner,
        je      short dont_process              ; then we shouldn't process

new_owner:

IFDEF DEBUG
	Trace_Out "VDEMOD: New Owner #EBX"
ENDIF

	mov	edx, 200h	 ; our arbitrary port address
        VMMCall Disable_Local_Trapping          ; give winner free access        

	xchg	ebx, VDEMOD_Owner	       ; save new owner, get old
        or      ebx, ebx                        ; no old owner?
        jz      short process_io                ; no, just process
        VMMCall Enable_Local_Trapping           ; old owner now locked out

process_io:
        popad

;secondly, handle I/O...
	Dispatch_Byte_IO Fall_Through, <SHORT VDEMOD_Out>
        in      al,dx                           ; do real in
        ret

VDEMOD_Out:
        out     dx,al                           ; do real out
        ret

dont_process:
        popad                                   ; restore regs
        mov     al, 0Eh                         ; indicate error to sample
                                                ; apps
IFDEF DEBUG
	Trace_Out "VDEMOD: I/O inhibited for VM #EBX"
ENDIF

        ret     

EndProc My_VDEMOD_Hook
;..........................................................................

BeginProc My_VDEMOD_lpt_Hook
;we come here if the printer status ports are trapped...
;set bit-3,7, clear bit-4...
        pushad


        popad

	Dispatch_Byte_IO Fall_Through, <SHORT VDEMOD_lpt_Out>
;        in      al,dx                           ; do real in
        mov     al,10101000b    ;this should stuff-up printing!
        ret                     ;(busy,out-0f-paper,offline,error)

VDEMOD_lpt_Out:
        out     dx,al                           ; do real out
        ret

EndProc My_VDEMOD_lpt_Hook
;.....................................................................
BeginProc ctrl_VDEMOD_lpt_Hook
;we come here if the printer control ports are trapped...
        pushad


        popad

        Dispatch_Byte_IO Fall_Through, <SHORT ctrl_lpt_Out>
        in      al,dx                           ; do real in
;        mov     al,0    ;
        ret

ctrl_lpt_Out:
;        out     dx,al                           ; do real out
        mov al,00001000b        ;bit-3=1,printer not selected.
        out dx,al
        ret


EndProc ctrl_VDEMOD_lpt_Hook
;.....................................................................




;...........................................................................

VxD_CODE_ENDS


        END
