;WINAPP.ASM --> WINAPP.EXE (writtem for MASM v6.1)
;Copyright Barry Kauler 1997.

; .286                  ;(if .386 place before, segments would be 32-bit).
.MODEL SMALL
.386                    ;after .MODEL, defaults to USE16 segments.

EXTERN RING0FUNC:NEAR   ;this is in HEAVEN.ASM. It is the ring0 code.

WINVER EQU	0300h
?WINPROLOGUE EQU 1	;forces windows prolog/epil on far procs.
OPTION OLDSTRUCTS	;required by global data struc, in WINVARS.INC
INCLUDE	WINASM60.INC	;this is not quite the same as WINDOWS.INC
;...........................................
.DATA
INCLUDE WINVARS.INC
INCLUDE GLOBL.INC    ;structure for global data(instanced in TSR2WIN,
                        ;and pointed-to in int-60h-ivt-entry.

;...........................................................
.CODE
;Here is the startup code...
;(startup data is in data include file).
start:
	xor bp,bp                       ; zero bp
	push bp
	INVOKE InitTask                 ; Initialize the stack
	or ax,ax
	jz noinit
	add cx,STACKSLOP                ; Add in stack slop space.
	jc noinit                       ; If overflow, return error.
	mov hPrev,si
	mov hInst,di
	mov word ptr lpszCmd,bx
	mov word ptr lpszCmd+2,es
	mov cmdShow,dx
	xor ax,ax                       ; Clear initial event that
	INVOKE WaitEvent, ax            ;   started this task.
	INVOKE InitApp, hInst           ; Initialize the queue.
	or ax,ax
	jz noinit

	INVOKE WINMAIN, hInst,hPrev,lpszCmd,cmdShow
ix:
	mov ah,4Ch
	INVOKE Dos3Call                 ; Exit with return code from app.
noinit:
	mov al,0FFh                     ; Exit with error code.
	jmp short ix
;........................................




;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC NEAR PASCAL, hInstance:WORD,hPrevInstance:WORD,lpCmdLine:LPSTR, \
								nCmdShow:SWORD

	cmp	hPrevInstance,0		;=0 if no previous instance.
	je	yes1stonce
	jmp     normalexit
yes1stonce:
        call    firsthooks              ;some initial once-only hooking.
        or      ax,ax
        je      quitwinmain
yes1st:
;.........................
;Setup the window class structure for REGISTERCLASS()...(WNDCLASS)...
	mov 	s1.Style,CS_HREDRAW+CS_VREDRAW
	lea	di,s1.lpfnwndproc
	mov	[di],OFFSET ASMDEMOProc
	mov	[di+2],SEG ASMDEMOProc
	mov 	s1.CbClsExtra,0
	mov 	s1.CbWndExtra,0
	mov	ax,hInst
	mov 	s1.HInstance,ax

  invoke LOADICON,null, IDI_APPLICATION
	mov 	s1.@HIcon,ax

  invoke LOADCURSOR,null, IDC_ARROW
	mov 	s1.@HCursor,ax

	mov 	s1.hbrBackground,COLOR_BACKGROUND+3
	mov	ax,OFFSET szASMDEMO1name        ;menu from resource file
	lea	di,s1.lpszmenuname		;WINAPP.
	mov 	[di],WORD PTR ax ;***back on.leave off menu
	mov 	[di+2],WORD PTR ds ;***    /
	lea	di,s1.lpszclassname             ;also call window class
	mov	[di],ax 			;WINAPP.
	mov 	[di+2],ds

	lea	ax,s1
  invoke REGISTERCLASS,ss::ax
	or	ax,ax
	je	quit2winmain

 invoke CREATEWINDOW, ADDR szASMDEMO1name, ADDR szwintitle,\
       WS_CAPTION+WS_BORDER, 150, 100, 300, 170, 0, 0, hInst, 0
        mov     handlemain,ax
  invoke SHOWWINDOW,ax,CmdShow
  invoke UPDATEWINDOW,handlemain
        mov     ax,1
quit2winmain:                   ;must test for ax==0 after return.
	or	ax,ax
	je	quitwinmain


;...........................................................
;This is the main message loop, in which Windows waits for messages
messageloop:
        lea    di,s2
 invoke GETMESSAGE, ss::di,0,0,0        ;remove message from queue.
        or      ax,ax                   ;quit if WM_QUIT message.
	jz	normalexit		 ;really!
	invoke TRANSLATEMESSAGE, ss::di
        invoke DISPATCHMESSAGE, ss::di
	lea	di,s2
messloop2:
 invoke PEEKMESSAGE, ss::di,0,0,0,PM_NOREMOVE  ;see if a message for this app.
        or     ax,ax            	;=0 if no msg from windows.
        jnz     messageloop

;...............................................................
		;post a global flag, that WINAPP is loaded and running ok...
        	mov     es,flatr3ldtselector  ;we keep doing this, so
		mov	ebx,lpglobaldata      ;it is a test that WINAPP
	mov es:(GLOBALSTRUCTURE PTR [ebx]).WINAPPLOADED,1 ;is active.

	      ;	int	28h	;generate the dos idle interrupt, for TSR2WIN.
;... a method for invoking the TSR regularly.
;................................................................
	jmp    messloop2
;....................................
quitwinmain:
;			;error, so**KILL SYSTEM**
;	 invoke errorhandler, 2,ADDR sznull,TRUE
;	invoke EXITWINDOWS,EW_REBOOTSYSTEM,0 ;dramatic exit!!!!
;getout:			 ;result of wm_quit
;NO, this is a dramatic exit, to show how it can be done.
;instead, exit normally...
normalexit:			;result of multiple-instances not allowed.
        mov     ax,s2.mywparam
        ret
WINMAIN	ENDP
;....................................................................
;.....................................................................
ASMDEMOPROC	 PROTO FAR PASCAL,  :HWND, :WORD, :SWORD, :SDWORD
ASMDEMOPROC	PROC FAR PASCAL, ihWnd:HWND, iMessage:WORD, iwParam:SWORD,\
				 ilParam:SDWORD
	LOCAL	dummy [5]:WORD
;	LOCAL	@hDC:HDC
;	LOCAL	s3:PAINTSTRUCT

    mov ax,ihwnd	;make these global.
    mov xhwnd,ax
    mov ax,imessage
    mov xmessage,ax
    mov ax,iwparam
    mov xwparam,ax
    mov ax,WORD PTR ilparam
    mov WORD PTR xlparam,ax
    mov ax,WORD PTR ilparam+2
    mov WORD PTR xlparam+2,ax


	mov	ax,xmessage		;get message-type.
	.IF	ax==WM_CREATE		;message received after CreateWindow()
		call	xcreate			;function is called.
	.ELSEIF	ax==WM_DESTROY		;message received if a window is closed.
		call	xquitmessage            ;posts WM_QUIT and does cleanup.
	.ELSEIF	ax==WM_PAINT		;message received if Windows has (already)
		call	xpaint
	.ELSEIF	ax==WM_COMMAND		;any selection of the menu or control
		call	xmenu
	.ELSEIF	ax==WM_LBUTTONDOWN	;one of many mouse messages.
		call	xlbutton
	.ELSE
		invoke DEFWINDOWPROC,xhwnd,xmessage,xwparam, xlparam
        	ret
        .ENDIF
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
	ret
;........................................
xlbutton:
        ret
;.................................
xcreate:
      	invoke	GETSTOCKOBJECT,OEM_FIXED_FONT
	mov	hOemFont,ax		;handle to font.
        ret
;...................................
xpaint:
;fill user-area of working-window...
	lea	di,s3  			;ss:ax -- far-addr of paint-structure.
  invoke BEGINPAINT,xhwnd,ds::di
	mov	HDC1,ax			;hDC -- display-context, required
  invoke CREATESOLIDBRUSH, 0080h   ;0FFFFh	    ; light yellow colour
        push    ax
  invoke SELECTOBJECT, HDC1,ax		;select object into display-context.
        mov     di,ax                   ;returns the old brush handle
  invoke RECTANGLE, HDC1, 180,60,215,95 ;border around .
  invoke SELECTOBJECT, HDC1,di		;restore old object.
        pop     ax
  invoke DELETEOBJECT, ax               ;delete solid brush

  invoke SETTEXTCOLOR, HDC1, di

  invoke RECTANGLE, HDC1, 0,107,600,108  ;horizontal line

	lea	di,s3
  invoke ENDPAINT,xhwnd,ds::di

        ret
;........................
xmenu:
;menu processing...
	cmp	WORD PTR xlparam,0	;low-half of lParam=0 if menu msg.
	jne	zxcv2
	.IF	xwparam==IDM_HELP
        	nop
	.ELSEIF xwparam==IDM_ABOUT
	invoke MESSAGEBOX, xhwnd, ADDR szaboutstr, ADDR szlogo, MB_OK
        .ELSE
        .ENDIF
        jmp     zxcv

zxcv2:
zxcv:	     ret
;.........................

ASMDEMOPROC	ENDP
;.....................................................................
xquitmessage    PROC
	invoke	POSTQUITMESSAGE,0	;posts WM_QUIT, to end program.

        call    freeourselectors

dontquit:
        ret
xquitmessage    ENDP
;.......................................................................

;...........................................................
firsthooks      PROC

;get addressability for ring-0....
;this hook must only be executed once....
;        cmp     flagring0hook,0
;        jne     ring0hookdone
        mov     flagring0hook,1
        call    makering0selector       ;sets up the addressability.
ring0hookdone:

;.........
;this proc gives us a flat 32-bit linear addr for tsr global data,
;in lpglobaldata, and a flat-model data selector in flatr3ldtselector...

;we need to get addressability to the global data area, in TSR2WIN...
        mov     ax,0200h        ;get ivt vector
        mov     bl,60h          ;60h
        int     31h             ;-->cx:dx (seg:off)
	cmp	cx,1		;must be zero or one (see TSR2WIN).
        ja      ivterror
        mov     WORD PTR lpglobaldata,dx        ;save
        mov     WORD PTR lpglobaldata+2,cx      ;  /
;...remember that cx=0 or 1, and cx:dx=flat-linear-address of the data.
        ;on the other hand, if cx:dx=0, this is an error, meaning tsr not wkg...
        cmp     dx,0
        jne     ok4
        cmp     cx,0
        je      tsrerror
ok4:

;reckon we need a selector to start of flat linear memory...
        mov     ax,0002h
        mov     bx,0            ;segment 0.
        int     31h             ;-->ax=selector(stupid thing has limit=64K).
        jc      segerror
        mov     flatr3ldtselector,ax
        ;increase the limit...
        mov     es,ldt_selector         ;(created in makering0selector()).
        mov     bx,ax
        and     bx,0FFF8h               ;convert to offset in ldt
        mov     al,es:[bx+6]            ;get top 4 bits of limit.
        or      al,0Fh                  ;set bits 16-19.
        mov     es:[bx+6],al

	mov	ax,1		       ;don't kill windows.
        ret
;.....
szee1   DB "segerror:",0
segerror:
tsrerror:
ivterror:
	mov ax,0
	ret

firsthooks      ENDP
;.......................................................................
errormsgproc	PROC
;entered with ds:si pointing to message....
 invoke MESSAGEBOX,handlemain, ds::si, ADDR szerror, MB_OK+MB_ICONEXCLAMATION
        ret
errormsgproc    ENDP
;....................................................................

makering0selector PROC
;get addressability of ring0, ring0func.....

        invoke GLOBALPAGELOCK,cs
        cmp     ax,0
        je      lockfailed

        lea     si,ms_dos_str
        mov     ax,168Ah        ;get dpmi extensions entry point.
        int     2Fh             ;-->es:di (undocumented)
;***        cmp     al,0                 ?????
;***        jne      extensionsnotfnd
        mov     WORD PTR[dpmiproc],di   ;save entry point
        mov     WORD PTR[dpmiproc+2],es ;       /
        mov     ax,100h         ;undocumented
        call    dpmiproc        ;-->ax=selector to ldt.
        jc      extensionsnotfnd
        mov     ldt_selector,ax
        mov     es,ax


;find the linear address of CS...
        mov     bx,cs
        and 	bx,0FFF8h                   ;get offset in ldt
        mov     ax,es:[bx]              ;get size of segment.
        mov     cssize,ax
        mov     ax,es:[bx+2]            ;get lo-half of lin.addr.
        mov     WORD PTR flatlin,ax
        mov     al,es:[bx+4]            ;get hi-half of lin. addr.
        mov     ah,es:[bx+7]            ;       /
        mov     WORD PTR flatlin+2,ax
;calculate FLAT linear address of ring0func...
        mov     ax,WORD PTR flatlin
        add     ax,ring0func            ;note: "OFFSET" is optional
        jnc     moppi
        mov	bx,WORD PTR flatlin+2
        inc     bx
        mov     WORD PTR flatlin+2,bx
moppi:
        mov     WORD PTR flatlin,ax



;create callgate to ring0func.....
         push   es
        invoke  ALLOCSELECTOR,0         ;create a descriptor in ldt.
         pop    es
        cmp     ax,0
        je      selectorerror
        mov     ring0_cs,ax             ;save final selector.
        and     ax,0FFF8h               ;get offset of descriptor in ldt.
        mov     bx,ax
        mov     ax,WORD PTR flatlin     ;my ring0 linear address
        mov     es:[bx],ax       	;       /
        mov     ax,WORD PTR flatlin+2   ;       /
        mov     es:[bx+6],ax    	;       /
        mov     WORD PTR es:[bx+2],28h  ;FLAT code selector(in gdt).
        mov     BYTE PTR es:[bx+4],0 ;04        ;****??dwords copied to stack.
        mov     BYTE PTR es:[bx+5],11101100b    ;present=1,dpl=3,app=00,type=C
        			            ;      (type=C: 386 callgate)


;find the FLAT linear address of this programs data segment...
        mov     bx,ds
        and 	bx,0FFF8h                   ;get offset in ldt
        mov     ax,es:[bx+2]            ;get lo-half of lin.addr.
        mov     WORD PTR flatdatalin,ax
        mov     al,es:[bx+4]            ;get hi-half of lin. addr.
        mov     ah,es:[bx+7]            ;       /
        mov     WORD PTR flatdatalin+2,ax



qwert:  jmp     SHORT qwerty
lockfailed:
extensionsnotfnd:
selectorerror:
        lea     si,ring0errormsg
        call 	errormsgproc
        call    xquitmessage            ;quit program.
qwerty:
        ret
makering0selector ENDP
;....................................
freeourselectors PROC
        invoke  FREESELECTOR,ring0_cs
        invoke GLOBALPAGEUNLOCK,cs
        ret
freeourselectors ENDP

;.....................................................................
 END	start
