;DPMI.ASM
;This skeleton assembly language program has been written for Borland
;TASM v2.5 or later.
;This program relates to discussion in Chapter 9/10.
;remember that Windows funcs only preserve SI,DI,BP & DS.
;
;This program shows how real mode code can be called via the IVT
;(Interrupt Vector Table).  It may seem devious, but when this program
;is active, any keypress will result in a beep -- firstly a WM_CHAR
;message will go to the callback, which will call the real-mode INT-16h
;function to put the character into the DOS keyboard buffer... then I have
;used the INT-16h function that reads a character from the buffer, and
;then a beep.
;What I have done here is call the real-mode INT-16h in two ways --
;firstly, to put the char into the buffer, I used a DPMI function,
;whereas in the second case I just put the "INT 16h" instruction straight
;into the program.  In the latter case, vector 16h in the IDT is not
;hooked by Windows, so Windows passes control down to the real-mode
;routine via the IVT.  This is the way most BIOS & DOS services will
;work from a Windows protected-mode program.
;However there may be cases where this automatic mechanism does not occur,
;such as a user-installed real-mode routine at a previously unused IVT
;vector, or where Windows has hooked the IDT vector.  In such cases,
;DPMI func.0300h can pass control down to the real-mode routine.
;Note that DPMI 0300h gets its destination address from a specified
;entry in the IVT, but funcs 0301h and 0302h are supplied with the
;destination seg:off address directly.
;I have used the DPMI function here, even though for INT-16h it isn't
;required, for demonstration purposes.
;
;What we have with DPMI function 0300h is a method for calling real
;mode code from protected mode. Note however that the real mode code
;has to be in the conventional memory area (within 1M) and in the
;System VM.  Normally this would be BIOS/DOS services and any TSR's
;and device drivers loaded prior to Windows (any DOS program loaded
;after Windows is loaded will go into another VM).  0300h will also
;work in Standard mode.
;
;Incidentally, calling the INT-16h function that places a character into
;the DOS keyboard buffer is a method for "pasting" characters to a DOS
;application from a WinApp, even if the DOSApp is running in the background.
;.........................................
;everything below is the basic skeleton program, with some extra
;code put into the WM_CHAR case...

.286
.MODEL SMALL

INCLUDE	WINDOWS.INC
IDM_QUIT		EQU	100		;menu-identifiers -- must be
IDM_ABOUT		EQU	101		;same as defined in .RC file.

;......
EXTRN	UPDATEWINDOW:FAR	;these are Windows functions.
EXTRN	BEGINPAINT:FAR
EXTRN	ENDPAINT:FAR
EXTRN	DEFWINDOWPROC:FAR
EXTRN	POSTQUITMESSAGE:FAR
EXTRN	REGISTERCLASS:FAR
EXTRN	GETSTOCKOBJECT:FAR
EXTRN	CREATEWINDOW:FAR
EXTRN	SHOWWINDOW:FAR
EXTRN	GETMESSAGE:FAR
EXTRN	LOADCURSOR:FAR
EXTRN	TRANSLATEMESSAGE:FAR
EXTRN	DISPATCHMESSAGE:FAR
EXTRN	LOADICON:FAR
EXTRN	TEXTOUT:FAR
EXTRN	INVALIDATERECT:FAR
EXTRN	MESSAGEBOX:FAR
EXTRN	GETDC:FAR
EXTRN	RELEASEDC:FAR
EXTRN	SELECTOBJECT:FAR
;.................................
.DATA
szwintitle	DB	'DPMI DEMO PROGRAM ',0
szwinhulloname	DB	'DPMI',0
hOemFont	DW	0			;handle to OEM font.
soutstring	DB	"Win-->real, via IVT. Press a key."
regstruc STRUC			;real-mode register structure.
 edi1 DD	0
 esi1 DD	0
 ebp1 DD	0
 res1 DD	0
 ebx1 DD	0
 edx1 DD	0
 ecx1 DD	0
 eax1 DD	0
 flags1 DW	0
 es1 DW	0
 ds1 DW	0
 fs1 DW	0
 gs1 DW	0
 ip1 DW	0
 cs1 DW	0
 sp1 DW	0
 ss1 DW	0
regstruc ENDS

	reg1 regstruc <>	;structure instance.


.CODE
;..........................................................
	PUBLIC 	WINMAIN
WINMAIN	PROC PASCAL NEAR hInstance:WORD,hPrevInstance:WORD,lpCmdLine:DWORD, \
								nCmdShow:WORD
	LOCAL	hWnd:WORD
	LOCAL	s1:WNDCLASS
	LOCAL	s2:MSGSTRUCT

	cmp	hPrevInstance,0		;=0 if no previous instance.
	je	yes1st
	jmp	createwin
yes1st:
;Setup the window class structure for REGISTERCLASS()...
	mov 	s1.clsStyle,3
	mov 	s1.WORD PTR clsLpfnWndProc,OFFSET DPMICALLBACK
	mov 	s1.WORD PTR clsLpfnWndProc+2,SEG DPMICALLBACK
	mov 	s1.clsCbClsExtra,0
	mov 	s1.clsCbWndExtra,0
	mov	ax,hInstance
	mov 	s1.clsHInstance,ax
  call LOADICON PASCAL,null, 0,IDI_APPLICATION
	mov 	s1.clsHIcon,ax
  call LOADCURSOR PASCAL,null, 0,IDC_ARROW
	mov 	s1.clsHCursor,ax
	mov 	s1.clsHbrBackground,COLOR_BACKGROUND
	mov	ax,OFFSET szwinhulloname
	mov 	s1.WORD PTR clsLpszMenuname,ax
	mov 	s1.WORD PTR clsLpszMenuName+2,ds
	mov 	s1.WORD PTR clsLpszClassName,ax
	mov 	s1.WORD PTR clsLpszClassName+2,ds
	lea	ax,s1
  call REGISTERCLASS PASCAL,ss,ax
	or	ax,ax					;
	jne	createwin
	jmp	quitwinmain

createwin:
 call CREATEWINDOW PASCAL, ds,OFFSET szwinhulloname, ds,OFFSET szwintitle, 207,0,\
				   150, 0, 400, 300, 0, 0, hInstance, 0,0
	mov 	hWnd,ax
  call SHOWWINDOW PASCAL,ax,nCmdShow
  call UPDATEWINDOW PASCAL,hWnd
	jmp	SHORT messageloop		;go to the main message-loop.


;This is the main message loop, in which Windows waits for messages
mainloop:
	lea	ax,s2
	call	TRANSLATEMESSAGE PASCAL,ss,ax
	lea	ax,s2
	call	DISPATCHMESSAGE PASCAL,ss,ax
messageloop:
	lea 	ax,s2
	call GETMESSAGE PASCAL, ss,ax, null, null, null
	or	ax,ax
	jne	mainloop

;GetMessage() returns FALSE (AX=0) if a "quit" message...
;so here we are quiting....
	mov	ax,s2.msWPARAM		;return wparam to windows OS.
quitwinmain:
	ret
WINMAIN	ENDP

;.....................................................................

	PUBLIC	DPMICALLBACK
DPMICALLBACK PROC WINDOWS PASCAL FAR hWnd:WORD,msgtype:WORD,wParam:WORD, \
							    lParam:DWORD
	LOCAL	dummy:WORD:5
	LOCAL	hDC:WORD
	LOCAL	s3:PAINTSTRUCT

	mov	ax,msgtype		;get message-type.
	cmp	ax,WM_DESTROY		;message received if a window is closed.
	je	xquitmessage
	cmp	ax,WM_PAINT
	jne	klm
	jmp  	xpaint
klm:	cmp	ax,WM_CHAR		;message that a char pressed.
	je	xchar
;Default handling of messages....
  call	DEFWINDOWPROC PASCAL,hWnd,msgtype,wParam, WORD PTR lParam+2, \
							  WORD PTR lParam
	jmp	xreturn
;.................................
xquitmessage:
  call	POSTQUITMESSAGE PASCAL,0
	jmp	xbreak
;....
xchar:
;Comes in here on any character keypress...
;As we are going to call a real-mode routine, we need to set up a
;real-mode register structure, to be passed by DPMI to the routine...
	pusha
	push 	ds
	push	ds
	pop	es
;Check a BIOS services reference for INT-16h/AH=5....(char AL -> DOS buffer)
	lea	di,reg1
	mov	WORD PTR [di].eax1,0500h	;5 into ah.
	mov	WORD PTR [di].ecx1,0007h  	;07=beep
	mov 	bx,0016h			;address to call is in IVT.
	mov	cx,0
	mov	ax,0300h		;Simulate Real Mode Interrupt.
	int	31h
	;use jc error
;Now, I am calling the same real-mode code, but by Windows automatic
;redirection for most BIOS/DOS services...
	mov 	ah,0	;get char from DOS key buffer
	int 	16h	;returns in ax ...will hang if no char in buff!
;If haven't hung, this program must have worked! Now send char to display...
	mov 	dl,al	;char in dl
	mov 	ah,2	;display a char (07 will cause a beep instead)
	int 	21h
	pop 	ds
	popa
	jmp 	xbreak
;.........
xpaint:
	lea	ax,s3  			;ps -- far-addr of paint-structure.
  call BEGINPAINT PASCAL,hWnd,ss,ax
	mov	hDC,ax
  call	TEXTOUT PASCAL,hDC,10,20, ds,OFFSET soutstring,33
	lea	ax,s3  			; -- far-addr of paint-structure.
  call	ENDPAINT PASCAL,hWnd,ss,ax
	jmp	SHORT xbreak
;........................
xbreak:
	sub	ax,ax			;returns 0 in DX:AX.  (callback functions
	cwd					;return a 32-bit (long) value).
xreturn:
	ret

DPMICALLBACK	ENDP

;.....................................................................

 END
