;WINASMOO.ASM --> WINASMOO.EXE  Windows OO program.
;remember that Windows funcs only preserve SI,DI,BP & DS.

INCLUDE	WINDOWS.INC
INCLUDE	WINASMOO.INC
IDM_QUIT 	EQU	100
IDM_ABOUT	EQU	101

.DATA
window1	WINDOW { szclassname="WINASMOO",sztitlename="Main Window",\
		 paint=w1paint,create=w1create,command=w1command, \
		 createstylehi=WS_OVERLAPPEDWINDOW+WS_CLIPCHILDREN, \
		 char=w1char, sziconname="icon_1" }
control1 CONTROL { szclassname="BUTTON",sztitlename="OK",\
		 x_coord=20,y_coord=40,wwidth=30,wheight=20, \
		 hmenu=IDOK,createstylehi=WS_CHILD+WS_VISIBLE,\
		 createstylelo=BS_PUSHBUTTON }
.CODE
kickstart:
	lea	si,window1			;addr of window object.
	call	[si].make PASCAL,si		;make the window.
	lea	si,control1
	call	[si].make PASCAL,si		;make child window
	ret

w1paint	PROC PASCAL
	LOCAL	hdc:WORD
	LOCAL	paintstructa:PAINTSTRUCT
	lea	di,paintstructa
  call BEGINPAINT PASCAL,[si].hwnd, ss,di
	mov	hdc,ax
  call SELECTOBJECT PASCAL,ax, [si].hfont
  call TEXTOUT PASCAL,hdc,10,20, cs,OFFSET outstring,16
  call ENDPAINT PASCAL,[si].hwnd, ss,di
	ret
outstring	DB "Demo OO Program!"
w1paint	ENDP

w1create:
  call	GETSTOCKOBJECT PASCAL,OEM_FIXED_FONT	;Windows func.
	mov	[si].hfont,ax
	ret

w1command:
	cmp	WORD PTR [si].lparam,0	;lo half=0 if a menu selection.
	jne	notmenu
	cmp	[si].wparam,IDM_QUIT 	;Is "Quit" selected?
	jne	notquit
	call	[si].destroy
	ret
notquit: cmp	[si].wparam,IDM_ABOUT	;Is "About.." selected?
	jne	notabout
  call MESSAGEBOX PASCAL, [si].hwnd, cs,OFFSET szmsg, cs,OFFSET szhdg, MB_OK
notabout: ret
notmenu:
	cmp	[si].wparam,IDOK	;button child window selected?
 ;note that lo-word of lparam has handle of control window,
 ;hi-word of lparam has notification code.
	jne	notbutton
	lea	si,control1	;since si points to window1.
	call	DESTROYWINDOW PASCAL,[si].hwnd	;kill the button
	mov	[si].hwnd,0	;must clear hwnd, if want to make() later.
notbutton:
	ret
szmsg	DB	"Created by Barry Kauler, 1992",0
szhdg	DB	"Message Box",0

w1char:
;let's bring back the button if any key pressed...
	lea	si,control1		;since si points to window1.
	call	[si].make PASCAL,si
	ret
;......................
 END
