
// VERY IMPORTANT NOTICE: COMPILE THIS DLL WITH BYTE ALIGNMENT OF STRUCTURES
// AND UNSIGNED CHAR!

#include <windows.h>
#include <stdio.h>
#include <string.h>

#include "plugin.h"


HINSTANCE        hinst;                // DLL instance
HWND             hwmain;               // Handle of main OllyDbg window
char             bookmarkwinclass[32]; // Name of bookmark window class
unsigned int	 NumberL=0;			   // Number of lines
ulong			 startC,endC,pocetBytu;// begin of copy,end of copy, number of bytes
char			 stringc[TEXTLEN];     // Operand  S   (any string)
int				 changes;


typedef struct t_bookmark {
  ulong          index;                // Bookmark index (0..9)
  ulong          size;                 // Size of index, always 1 in our case
  ulong          type;                 // Type of entry, always 0
  int			 length;			   // Length of opcode
  ulong          addr;                 // Address of instruction
  char			 code[TEXTLEN];		   // Bytes of code (string with spaces)
  ulong			 JumpTo;			   // Jump to address
  char			 ASM[TEXTLEN];		   // command
  ulong			 shift;				   // shift this instruction
  ulong			 JmpToIndex;		   // Jump to index
  int			 newSize;			   // New size of code
  char			 newCode[MAXCMDSIZE];  // New code for paste
  char			 Comment[TEXTLEN];	   // Comment
  int			 label;				   // Label
} t_bookmark;

t_table          bookmark;             // Table the block


//int Bookmarksortfunc(t_bookmark *b1,t_bookmark *b2,int sort);
LRESULT CALLBACK Bookmarkwinproc(HWND hw,UINT msg,WPARAM wp,LPARAM lp);
int Bookmarkgettext(char *s,char *mask,int *select,t_sortheader *ph,int column);

void copyInstructions(void *item);
void pasteInstructions(void *item);
void Createbookmarkwindow(void);
int TestJump(t_bookmark *pb, t_dump *pd,int *position,int *shift);
void CopyCode(t_bookmark *pb,int *position,int *shift);
void copyToClipboard(void *item);
int findLabel(ulong index);
//##########################################################################################
//##########################################################################################


BOOL WINAPI DllEntryPoint(HINSTANCE hi,DWORD reason,LPVOID reserved) {
  if (reason==DLL_PROCESS_ATTACH)
    hinst=hi;                          // Mark plugin instance
  return 1;                            // Report success
};

//##########################################################################################

extc int _export cdecl ODBG_Plugindata(char shortname[32]) {
  strcpy(shortname,"ExtraCopy");       // Name of plugin
  return PLUGIN_VERSION;
};

//##########################################################################################

extc int _export cdecl ODBG_Plugininit(
  int ollydbgversion,HWND hw,ulong *features) {

  // This plugin uses all the newest features, check that version of OllyDbg is
  // correct. I will try to keep backward compatibility at least to v1.99.
  if (ollydbgversion<PLUGIN_VERSION)
    return -1;

  hwmain=hw;
  if (Registerpluginclass(bookmarkwinclass,NULL,hinst,Bookmarkwinproc)<0) {
    // Failure! Destroy sorted data and exit.
    Destroysorteddata(&(bookmark.data));
    return -1; };

  Addtolist(0,0,"ExtraCopy plugin v0.90 by Regon");
  

  if (Plugingetvalue(VAL_RESTOREWINDOWPOS)!=0 &&
    Pluginreadintfromini(hinst,"Restore bookmarks window",0)!=0)
    Createbookmarkwindow();
  return 0;
};

//##########################################################################################

// Each window class needs its own window procedure. Both standard and custom
// OllyDbg windows must pass some system and OllyDbg-defined messages to
// Tablefunction(). See description of Tablefunction() for more details.
LRESULT CALLBACK Bookmarkwinproc(HWND hw,UINT msg,WPARAM wp,LPARAM lp) {
  int i,shiftkey,controlkey;
  HMENU menu;
  t_bookmark *pb;
  switch (msg) {
    // Standard messages. You can process them, but - unless absolutely sure -
    // always pass them to Tablefunction().
    case WM_DESTROY:
    case WM_MOUSEMOVE:
    case WM_LBUTTONDOWN:
    case WM_LBUTTONDBLCLK:
    case WM_LBUTTONUP:
    case WM_RBUTTONDOWN:
    case WM_RBUTTONDBLCLK:
    case WM_HSCROLL:
    case WM_VSCROLL:
    case WM_TIMER:
    case WM_SYSKEYDOWN:
      Tablefunction(&bookmark,hw,msg,wp,lp);
      break;                           // Pass message to DefMDIChildProc()
    // Custom messages responsible for scrolling and selection. User-drawn
    // windows must process them, standard OllyDbg windows without extra
    // functionality pass them to Tablefunction().
    case WM_USER_SCR:
    case WM_USER_VABS:
    case WM_USER_VREL:
    case WM_USER_VBYTE:
    case WM_USER_STS:
    case WM_USER_CNTS:
    case WM_USER_CHGS:
      return Tablefunction(&bookmark,hw,msg,wp,lp);
    case WM_USER_MENU:
      menu=CreatePopupMenu();
      // Find selected bookmark. Any operations with bookmarks make sense only
      // if at least one bookmark exists and is selected. Note that sorted data
      // has special sort index table which is updated only when necessary.
      // Getsortedbyselection() does this; some other sorted data functions
      // don't and you must call Sortsorteddata(). Read documentation!
      pb=(t_bookmark *)Getsortedbyselection(
        &(bookmark.data),bookmark.data.selected);
      if (menu!=NULL && pb!=NULL) {
        AppendMenu(menu,MF_STRING,1,"&Follow\tEnter");
	  };
      // Even when menu is NULL, call to Tablefunction is still meaningful.
      i=Tablefunction(&bookmark,hw,WM_USER_MENU,0,(LPARAM)menu);
      if (menu!=NULL) DestroyMenu(menu);
      if (i==1)                        // Follow bookmark in Disassembler
        Setcpu(0,pb->addr,0,0,CPU_ASMHIST|CPU_ASMCENTER|CPU_ASMFOCUS);
      return 0;
    case WM_KEYDOWN:
      // Processing of WM_KEYDOWN messages is - surprise, surprise - very
      // similar to that of corresponding menu entries.
      shiftkey=GetKeyState(VK_SHIFT) & 0x8000;
      controlkey=GetKeyState(VK_CONTROL) & 0x8000;
      if (wp==VK_RETURN && shiftkey==0 && controlkey==0) {
        // Return key follows bookmark in Disassembler.
        pb=(t_bookmark *)Getsortedbyselection(
          &(bookmark.data),bookmark.data.selected);
        if (pb!=NULL)
          Setcpu(0,pb->addr,0,0,CPU_ASMHIST|CPU_ASMCENTER|CPU_ASMFOCUS);
        ; }
      else
        // Add all this arrow, home and pageup functionality.
        Tablefunction(&bookmark,hw,msg,wp,lp);
      break;
    case WM_USER_DBLCLK:
      // Doubleclicking row follows bookmark in Disassembler.
      pb=(t_bookmark *)Getsortedbyselection(
        &(bookmark.data),bookmark.data.selected);
      if (pb!=NULL)
        Setcpu(0,pb->addr,0,0,CPU_ASMHIST|CPU_ASMCENTER|CPU_ASMFOCUS);
      return 1;                        // Doubleclick processed
    case WM_USER_CHALL:
    case WM_USER_CHMEM:
      InvalidateRect(hw,NULL,FALSE);
      return 0;
    case WM_PAINT:
      Painttable(hw,&bookmark,Bookmarkgettext);
      return 0;
    default: break;
  };
  return DefMDIChildProc(hw,msg,wp,lp);
};

//##########################################################################################

extc void _export cdecl ODBG_Pluginmainloop(DEBUG_EVENT *debugevent) {
};

//##########################################################################################

extc int _export cdecl ODBG_Pluginmenu(int origin,char data[4096],void *item) {
  int n;
  t_bookmark *pb;
  t_dump *pd;
  switch (origin) {
    // Menu creation is very simple. You just fill in data with menu pattern.
    // Some examples:
    // 0 Aaa,2 Bbb|3 Ccc|,,  - linear menu with 3items, relative IDs 0, 2 and 3,
    //                         separator between second and third item, last
    //                         separator and commas are ignored;
    // #A{0Aaa,B{1Bbb|2Ccc}} - unconditional separator, followed by popup menu
    //                         A with two elements, second is popup with two
    //                         elements and separator inbetween.
    case PM_MAIN:                      // Plugin menu in main window
      strcpy(data,"0 &ExtraCopy|1 &About");
      // If your plugin is more than trivial, I also recommend to include Help.
      return 1;
    case PM_DISASM:                    // Popup menu in Disassembler
      // First check that menu applies.
      pd=(t_dump *)item;
      if (pd==NULL || pd->size==0)
        return 0;                      // Window empty, don't add
      // Start second-level popup menu.
      n=sprintf(data,"ExtraCopy{");
      pb=(t_bookmark *)bookmark.data.data;

      strcpy(data+n,"0 &Copy \tAlt+F11,");
	  n=strlen(data);

	  if (bookmark.data.n>0){
		  strcpy(data+n,"10 &Paste \tAlt+F12");
		  n=strlen(data);
	  }
	  data[n++]='|';

	  if (bookmark.data.n>0){
		  strcpy(data+n,"20 C&opy to clipboard \tAlt+Shift+F11");
		  n=strlen(data);

	  }
      // Close popup. If you forget to do this, OllyDbg will try to correct
      // your error.
      sprintf(data+n,"}");
      return 1;
    default: break;                    // Any other window
  };
  return 0;                            // Window not supported by plugin
};

//##########################################################################################

extc void _export cdecl ODBG_Pluginaction(int origin,int action,void *item)
 {
  char			tmp=0;
  unsigned int	delkaCode=0;


  if (origin==PM_MAIN) 
  {
    switch (action) 
	{
      case 0:
        // Menu item "Bookmarks", creates bookmark window.
        Createbookmarkwindow();
        break;
      case 1:
        // Menu item "About", displays plugin info. If you write your own code,
        // please replace with own copyright!
        MessageBox(hwmain,
          "ExtraCopy plugin v1.0\n"
          "Regon",
          "ExtraCopy plugin",MB_OK|MB_ICONINFORMATION);
        break;
      default: break;
    };
  }//PM_MAIN
  else if (origin==PM_DISASM) 
  {
	if (action==0)//(action>=0 && action<10){//Insert bookmark
	{
		copyInstructions(item);
	}//end action=0
    else if (action==10)
	{// Delete bookmark
		pasteInstructions(item);
	}//Copy to clipboard
	else if (action==20)
		copyToClipboard(item);
	
  }//PM_DISASM
 };//ODBG_Pluginaction

//##########################################################################################

int Bookmarkgettext(char *s,char *mask,int *select,
  t_sortheader *ph,int column) {
  int			n;
  ulong			cmdsize,decodesize;
  char			cmd[MAXCMDSIZE],*pdecode;
  t_memory		*pmem;
  t_disasm		da;
  t_bookmark	*pb=(t_bookmark *)ph;

	if (column==0) {						// address
		pmem=Findmemory(pb->addr);			// Find memory block containing code
		if (pmem==NULL) {
		  *select=DRAW_GRAY; return sprintf(s,"???"); };
		cmdsize=pmem->base+pmem->size-pb->addr;
		if (cmdsize>MAXCMDSIZE)
		  cmdsize=MAXCMDSIZE;
		if (Readmemory(cmd,pb->addr,cmdsize,MM_RESTORE|MM_SILENT)!=cmdsize) {
		  *select=DRAW_GRAY; return sprintf(s,"???"); };
		pdecode=Finddecode(pb->addr,&decodesize);
		if (decodesize<cmdsize) pdecode=NULL;
		Disasm(cmd,cmdsize,pb->addr,pdecode,&da,DISASM_CODE,0);

		n=sprintf(s,"%08X",pb->addr);
	}
	else if (column==1){						// Code
		strcpy(s,da.dump);
		n=strlen(s);
	}
	else if (column==2){						// Disassembly
	strcpy(s,pb->ASM);
    n=strlen(s);
	}
	else if (column==3)							// Comment
		n=Findname(pb->addr,NM_COMMENT,s);	

	else n=0;                            // is not necessarily 0-terminated
	return n;
};

//##########################################################################################

void Createbookmarkwindow(void) {
  // Describe table columns. Note that column names are pointers, so strings
  // must exist as long as table itself.
  if (bookmark.bar.nbar==0) {
    // Bar still uninitialized.

	bookmark.bar.name[0]="Address";    // Code
    bookmark.bar.defdx[0]=9;
    bookmark.bar.mode[0]=0;
	
	bookmark.bar.name[1]="Code";	   // Address
    bookmark.bar.defdx[1]=15;
    bookmark.bar.mode[1]=0;

	bookmark.bar.name[2]="Disassembly";// Disassembled command
    bookmark.bar.defdx[2]=32;
    bookmark.bar.mode[2]=BAR_NOSORT;

	
	bookmark.bar.name[3]="Comment";    // Comment
    bookmark.bar.defdx[3]=256;
    bookmark.bar.mode[3]=BAR_NOSORT;
	bookmark.bar.nbar=4;
    bookmark.mode=TABLE_COPYMENU|TABLE_SORTMENU|TABLE_APPMENU|TABLE_SAVEPOS;
    bookmark.drawfunc=Bookmarkgettext; };
  Quicktablewindow(&bookmark,15,4,bookmarkwinclass,"Block");
};

//##########################################################################################

extc int _export cdecl ODBG_Pluginshortcut(int origin,int ctrl,int alt,int shift,int key,void *item) 
{
  if(alt!=0 && ctrl==0) 
  {
      if (key==VK_F11 && origin==PM_DISASM && item!=NULL) 
	  {
	    if (shift==0)
		  copyInstructions(item);
		else
			copyToClipboard(item); 
	  }
	  else if (key==VK_F12 && origin==PM_DISASM && item!=NULL) 
	    if (shift==0)
		    pasteInstructions(item);
//		else
//			pasteFromClipboard(item);Not yet implemented


  }	
  else
		return 0;                            // Shortcut not recognized
};

extc void _export cdecl ODBG_Pluginreset(void) {
  Deletesorteddatarange(&(bookmark.data),0,0xFFFFFFFF);
};

extc int _export cdecl ODBG_Pluginclose(void) {
  return 0;
};


extc void _export cdecl ODBG_Plugindestroy(void) {
  Unregisterpluginclass(bookmarkwinclass);
  Destroysorteddata(&(bookmark.data));
};

//##########################################################################################
//##########################################################################################

void copyInstructions(void *item)
{
  t_dump		*pd;
  t_memory		*pmem;
  t_bookmark	mark, *pb, *pb2;
  t_disasm		da;


  unsigned int	line=0,pocetBytup=0,NumberOfInstructions=0,i,j;
  ulong			cmdsize;
  char			cmd[MAXCMDSIZE],*pdecode;
  ulong			decodesize;

	line=0;
	pd=(t_dump *)item;
	pocetBytu=0;
	NumberOfInstructions=0;

	cmdsize=MAXCMDSIZE;
	// clear the bookamrk
	//Deletesorteddatarange(&(bookmark.data),0,0xFFFFFFFF);

	startC=pd->sel0;
	endC=pd->sel1;

	while(pd->sel1>(pd->sel0+pocetBytu)){
		NumberOfInstructions++;
		Readmemory(cmd,pd->sel0+pocetBytu,cmdsize,MM_RESTORE|MM_SILENT);
		pmem=Findmemory(pd->sel0+pocetBytu);
		pdecode=Finddecode(pd->sel0+pocetBytu,&decodesize);
		pocetBytu+=Disasm(cmd,cmdsize,(pd->sel0)+pocetBytu,pdecode,&da,DISASM_SIZE,0);
	}
	
	if (Createsorteddata(&(bookmark.data),"ExtraCopy",
	sizeof(t_bookmark),NumberOfInstructions,NULL,NULL)!=0)	
	{	
		MessageBox(hwmain,"Unable to allocate memory for the block","Info",MB_OK);
		return ;                         // Unable to allocate bookmark data
	}
	pocetBytu=0;
	for (i=0;i<NumberOfInstructions;i++){
		Readmemory(cmd,pd->sel0+pocetBytu,cmdsize,MM_RESTORE|MM_SILENT);
		pmem=Findmemory(pd->sel0+pocetBytu);
		pdecode=Finddecode(pd->sel0+pocetBytu,&decodesize);
		
		pocetBytup=pocetBytu;
		pocetBytu+=Disasm(cmd,cmdsize,(pd->sel0)+pocetBytu,pdecode,&da,DISASM_CODE,0);


		mark.index=line;
		mark.size=1;
		mark.type=0;
		mark.addr=pd->sel0+pocetBytup;
		mark.length=pocetBytu-pocetBytup;
		strcpy(mark.code,da.dump);
		strcpy(mark.ASM,da.result);		
		mark.JumpTo=da.jmpaddr;
		//set Jump To
		Addsorteddata(&(bookmark.data),&mark);
		if (bookmark.hw!=NULL) InvalidateRect(bookmark.hw,NULL,FALSE);
			line++;
	} //end while	
	
	NumberL=NumberOfInstructions;
	
	for(i=0;i<NumberL;i++){
		pb=(t_bookmark *)Findsorteddata(&(bookmark.data),i);
		pb->shift=0;
		pb->newSize=0;
		Findname(pb->addr,NM_COMMENT,pb->Comment);	

		if (pb!=NULL){
			if ((pb->JumpTo>=startC) && (pb->JumpTo<endC)){
				for(j=0;j<NumberL;j++){
					pb2=(t_bookmark *)Findsorteddata(&(bookmark.data),j);
					if (pb->JumpTo==pb2->addr){
						pb->JmpToIndex=j;
						break;
					}
				}
			}
			else pb->JmpToIndex=-1;
		}
	}
}

//##########################################################################################

void pasteInstructions(void *item)
{
  ulong			nn;		
  t_dump		*pd,*pasm;
  t_memory		*pmem;
  unsigned int	ii,position;
  int			shift; 
  t_bookmark	*pb;
  unsigned char tmp=0;
  

    shift=0;
	pd=(t_dump *)item;

	pmem=Findmemory(pd->sel0);
	if (pmem==NULL) {
		MessageBox(hwmain,"Attempt to assemble to non-existing memory", "ExtraCopy plugin",MB_OK|MB_ICONINFORMATION);   
	    return;}
	pasm=(t_dump *)Plugingetvalue(VAL_CPUDASM);
	if (pasm!=NULL && pmem->copy==NULL && pmem->base==pasm->base && pmem->size==pasm->size)
	  Dumpbackup(pasm,BKUP_CREATE);

	//Paste insturction
	position=0;	
	// control the code and change jumps and calls
	do{
		changes=0;
		position=0;
		shift=0;
		for(ii=0;ii<NumberL;ii++)  // for first to last instruction
		{
			pb=(t_bookmark *)Findsorteddata(&(bookmark.data),ii);
			if (pb!=NULL) 
			{
				nn=0;
				if (pb->JumpTo!=0){
					nn=TestJump(pb,pd,&position,&shift);
					if ((nn!=0) && (pb->JumpTo!=0)){
						position+=nn;			
					}
					else
						CopyCode(pb,&position,&shift);			
				}
				else 
				{
					CopyCode(pb,&position,&shift);			
				}// end else
			} //end if 
		}//end for
	}
	while(changes!=0);
		
	// write the code
		position=0;
		for(ii=0;ii<NumberL;ii++){  // for first to last instruction
			pb=(t_bookmark *)Findsorteddata(&(bookmark.data),ii);
			if (pb!=NULL){ 
				Writememory(pb->newCode,pd->sel0+position,pb->newSize,MM_RESTORE|MM_DELANAL);
				position+=pb->newSize;
				Insertname(pd->sel0+position, NM_COMMENT,pb->Comment);
			} //end if 
		}//end for
}

//##########################################################################################

int TestJump(t_bookmark *pb, t_dump *pd,int *position,int *shift)
{ 
  unsigned int j,k,good,ii,ni;
  char			s[TEXTLEN],answer[TEXTLEN],ASMtext[TEXTLEN],codeStr[TEXTLEN];
  t_asmmodel	model,attempt;
  t_bookmark	*pb2;
  int			n=0;
  	
	strcpy(codeStr,pb->code);
    //convert asm instruction
	for (ii=0;ii<strlen(pb->ASM);ii++){
		ASMtext[ii]=pb->ASM[ii];
		if (ASMtext[ii]==' '){
			ASMtext[ii+1]=0;

			if (pb->JmpToIndex!=-1){//in the block
				pb2=(t_bookmark *)Findsorteddata(&(bookmark.data),pb->JmpToIndex);
				ni=sprintf(&ASMtext[ii+1],"%08X",pd->sel0+*position-(pb->addr - pb->JumpTo+*shift-pb2->shift));
			}				
			else{//out of the block
				ni=sprintf(&ASMtext[ii+1],"%08X",pb->JumpTo);
			}
			break;
		}
	}
	if ((codeStr[0]=='7') || (codeStr[0]=='E') || (codeStr[0]=='0')){//short conditional jump or short call- 1b constant size
		model.length=0;
		for (j=0; ; j++){// Try all possible encodings
			good=0;
			for (k=1; k<4; k+=k+3) {            // Try all possible constant sizes
				n=Assemble(ASMtext,pd->sel0+*position,&attempt,j,k,model.length==0?answer:s);
				if (n>0){
					good=1;
				  // If another decoding is found, check if it is shorter.
					if (model.length==0 || n<model.length)
						model=attempt; // Shortest encoding so far
					
				
					if ((model.length==pb->length) || ((model.length!=pb->length) && (model.length>0))) 
						good=0;
				}
			}
			if (good==0) break;              // No more encodings
		}
		//1th way through							next ways through
		if (((n>pb->length) && (pb->newSize==0)) || ((n>pb->newSize) && (pb->newSize!=0)))
			changes++;
	}
	else
		return 0;

	pb->shift=*shift;
	*shift+=n-pb->length;
	pb->newSize=n;
	memcpy(pb->newCode,model.code,MAXCMDSIZE);

	return n;
}

//##########################################################################################

void CopyCode(t_bookmark *pb,int *position,int *shift)
{
  unsigned int	i,j;
  char			cmd[MAXCMDSIZE],codeStr[TEXTLEN];
  unsigned char tmp=0;

	strcpy(codeStr,pb->code);
	//remove spaces
	for(i=0; i<strlen(codeStr);i++)	{
		if (codeStr[i]==' '){
			for(j=i; j<strlen(codeStr); j++)
			  codeStr[j]=codeStr[j+1];
		}
	}
	for(i=0; i<pb->length;i++){
		if(codeStr[i*2]>='0' && codeStr[i*2]<='9')
			tmp=(codeStr[i*2]-0x30) * 0x10;
		else
			tmp=(codeStr[i*2]-0x37) * 0x10;
		if(codeStr[i*2+1]>='0' && codeStr[i*2+1]<='9')
			tmp+=(codeStr[i*2+1]-0x30);
		else
			tmp+=(codeStr[i*2+1]-0x37);
		cmd[i]=tmp;
	};
	memcpy(pb->newCode,cmd,pb->length);
	pb->newSize=pb->length;
	pb->shift=*shift;
	*position+=pb->newSize;
}


//##########################################################################################

void copyToClipboard(void *item)
{
  t_dump		*pd,*pasm;
  int			position,shift,space,name; 
  ulong			i,ii;
  t_bookmark	*pb;
  char			codeStr[TEXTLEN],codeStr2[TEXTLEN] ;
  unsigned char tmp=0;
  char			*buffer;
  HGLOBAL		clipbuffer;
  char			end[]={0xD,0x0A,0x0};
  unsigned int  n;

    shift=0;
	pd=(t_dump *)item;
	pasm=(t_dump *)Plugingetvalue(VAL_CPUDASM);
	

	n=0;
	for(ii=0;ii<NumberL;ii++){			// for first to last instruction	
		pb=(t_bookmark *)Findsorteddata(&(bookmark.data),ii);
		if (pb!=NULL) 
			n+=strlen(pb->ASM)+2;
		if(findLabel(pb->index)==0)n+=7;//Length of label
		n+2;							//2 spacesbefore command
	}

	//Paste insturction
	position=0;	

	if ( !OpenClipboard(NULL) )
	{
		MessageBox(hwmain,"Cannot open the Clipboard", "ExtraCopy plugin",MB_OK|MB_ICONINFORMATION);   
		return;
	}
	if( !EmptyClipboard(NULL) )
	{
		MessageBox(hwmain,"Cannot empty the Clipboard", "ExtraCopy plugin",MB_OK|MB_ICONINFORMATION);   		
		return;
	}

	clipbuffer = GlobalAlloc(GMEM_DDESHARE, n+1);
	buffer = (char*)GlobalLock(clipbuffer);
	
	n=0;	
	for(ii=0;ii<NumberL;ii++)  // for first to last instruction
	{
		pb=(t_bookmark *)Findsorteddata(&(bookmark.data),ii);
		if (pb!=NULL) 
		{
			if (pb->label!=0){
				strcpy(&buffer[n],"  ");
				n+=2;
			}
			else{
				n+=sprintf(&buffer[n],"L%03i:",pb->index)+2;
				strcpy(&buffer[n-2],end);
				strcpy(&buffer[n],"  ");
				n+=2;
			}

			if (pb->JmpToIndex==-1){
				space=0;
				name=0;
				if(strstr(pb->ASM,"[<&")!=NULL){
					strcpy(codeStr,pb->ASM);
					for(i=0; i<strlen(codeStr);i++)	{
						if (codeStr[i]==' ' && space==0)
							space=i;
						if (codeStr[i]=='.')
							name=i+1;
					}
					strcpy(codeStr2,pb->ASM);
					strcpy(&codeStr[space+1],&codeStr2[name]);
					strcpy(&buffer[n],codeStr);
					n+=strlen(codeStr);
				}
				else
				{
					strcpy(&buffer[n],pb->ASM);
					n+=strlen(pb->ASM)+2;
				}
			}
			else
			{
				strcpy(codeStr,pb->ASM);
				for(i=0; i<strlen(codeStr);i++)	{
					if (codeStr[i]==' '){
					    sprintf(&codeStr[i+1],"L%03i",pb->JmpToIndex);
						strcpy(&buffer[n],codeStr);
						n+=strlen(codeStr)+2;
						break;
					}
				}
			}
		strcpy(&buffer[n-2],end);

		}
	}

	GlobalUnlock(clipbuffer);

	if ( SetClipboardData( CF_TEXT, clipbuffer ) == NULL )
	{
		MessageBox(hwmain,"Unable to set Clipboard data", "ExtraCopy plugin",MB_OK|MB_ICONINFORMATION);   
		CloseClipboard(hwmain);
		return;
	}
	CloseClipboard(NULL);
}

//##########################################################################################

int findLabel(ulong index)
{
  t_bookmark *pb, *pb2;
  unsigned int i;
	pb2=(t_bookmark *)Findsorteddata(&(bookmark.data),index);
	for(i=0;i<NumberL;i++){
		pb=(t_bookmark *)Findsorteddata(&(bookmark.data),i);
		if (pb->JmpToIndex==index){
			pb2->label=0;
			return 0;
		}
	}
	pb2->label=-1;
	return -1;
}






