// VERY IMPORTANT NOTICE: COMPILE THIS DLL WITH BYTE ALIGNMENT OF STRUCTURES
// AND UNSIGNED CHAR!

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>

#include <odbg\plugin106.h>
#include "resource.h"

LRESULT CALLBACK DlgProc(HWND, UINT, WPARAM, LPARAM);
void SetWatches(void);
void ModifyWatch(int, const char *, int);
int strHEX2Int(char *, int);
BOOL IsValidNumber(char *, int, int);

#define NUM_DEC  1
#define NUM_HEX  2

#define MOD_NIL  0
#define MOD_SIZ  1
#define MOD_SIG  2

#define PNAME   "WatchMan"
#define PVERS   "v1.00"
#define ANAME   "Gigapede"

#define ISWAP(a,b) do { \
    int t; \
    t = a; \
    a = b; \
    b = t; \
} while(0)

enum EXPRESSION {
  LocX,
  ArgX,
  EbpX,
  EspX
} expression = LocX;

enum STR_MODIFIER {
  strNone,
  strAnsi,
  strUnic
} strMod = strNone;

enum ADR_MODIFIER {
  adrNone,
  adrPtr1,
  adrPtr2
} adrMod = adrNone;

HINSTANCE        hinst;                // DLL instance
HWND             hwmain;               // Handle of main OllyDbg window

char strFrom[9],strTo[9];

BOOL WINAPI DllEntryPoint(HINSTANCE hi,DWORD reason,LPVOID reserved) {
  if (reason==DLL_PROCESS_ATTACH)
    hinst=hi;                          // Mark plugin instance
  return 1;                            // Report success
};

extc int _export cdecl ODBG_Plugindata(char shortname[32]) {
  strcpy(shortname,PNAME);       // Name of plugin
  return PLUGIN_VERSION;
};

extc int _export cdecl ODBG_Plugininit(
  int ollydbgversion,HWND hw,ulong *features) {
  if (ollydbgversion<PLUGIN_VERSION)
    return -1;
  hwmain=hw;
  Addtolist(0, 0,PNAME" "PVERS"  by "ANAME);
  return 0;
};

extc int _export cdecl ODBG_Pluginmenu(int origin,char data[4096],void *item) {
  switch (origin) {
    case PM_MAIN: // Plugin menu in main window
      strcpy(data,"0 &Set Watches, 1 &Delete All Watches |63 &About");
      return 1;
    case PM_WATCHES:
      strcpy(data,
                 "#WatchMan{"
                   "0 Set &Watches...,"
                   "1 &Delete All Watches|"
                   "Change data format{"
                     "2  &string,"
                     "3  &unicode|"
                     "4  &byte,"
                     "5  &word,"
                     "6  &dword,"
                     "7  &qword,"
                     "8  &char,"
                     "9  s&hort,"
                     "10 &long,"
                     "11 &float,"
                     "12 d&ouble,"
                     "13 float&10|"
                     "14 s&igned,"
                     "15 u&nsigned|"
                     "16 delete si&ze modifier,"
                     "17 delete si&gn modifier,"
                     "18 delete &all modifier,"
                   "}"
                 "}"
            );
      return 1;
    default:
      break; // Any other window
  };
  return 0; // Window not supported by plugin
};

extc void _export cdecl ODBG_Pluginaction(int origin,int action,void *item) {

  switch(origin) {
  case PM_MAIN:
  case PM_WATCHES:
    switch (action) {
    case 0:
      SetWatches();
      break;
    case 1:
      while(Deletewatch(1));
      break;
    case 2:
      ModifyWatch((int)item+1,"string",MOD_SIZ);
      break;
    case 3:
      ModifyWatch((int)item+1,"unicode",MOD_SIZ);
      break;
    case 4:
      ModifyWatch((int)item+1,"byte",MOD_SIZ);
      break;
    case 5:
      ModifyWatch((int)item+1,"word",MOD_SIZ);
      break;
    case 6:
      ModifyWatch((int)item+1,"dword",MOD_SIZ);
      break;
    case 7:
      ModifyWatch((int)item+1,"qword",MOD_SIZ);
      break;
    case 8:
      ModifyWatch((int)item+1,"char",MOD_SIZ);
      break;
    case 9:
      ModifyWatch((int)item+1,"short",MOD_SIZ);
      break;
    case 10:
      ModifyWatch((int)item+1,"long",MOD_SIZ);
      break;
    case 11:
      ModifyWatch((int)item+1,"float",MOD_SIZ);
      break;
    case 12:
      ModifyWatch((int)item+1,"double",MOD_SIZ);
      break;
    case 13:
      ModifyWatch((int)item+1,"float10",MOD_SIZ);
      break;
    case 14:
      ModifyWatch((int)item+1,"signed",MOD_SIG);
      break;
    case 15:
      ModifyWatch((int)item+1,"unsigned",MOD_SIG);
      break;
    case 16:
      ModifyWatch((int)item+1,"",MOD_SIZ);
      break;
    case 17:
      ModifyWatch((int)item+1,"",MOD_SIG);
      break;
    case 18:
      ModifyWatch((int)item+1,"",MOD_NIL);
      break;
    case 63:
      // Menu item "About", displays plugin info.
      MessageBox(hwmain,
                 PNAME" "PVERS
                 "\n    "
                 "by "ANAME"  ",
                 "About "PNAME,
                 MB_OK|MB_ICONINFORMATION);
      break;
    default:
      break;
    }
  }
}

void SetWatches(void)
{
  char *szExp[4] = {"local.", "arg.", "EBP", "ESP"};
  char *szStr[3] = {"", "string", "unicode"};
  char *szAd1[3] = {"", "[", "[["};
  char *szAd2[3] = {"", "]", "]]"};
  char *szSgn[2]  = {"+","-"};
  char buf[TEXTLEN],frm[TEXTLEN];
  int i,id,iFrom,iTo,ibuf,idx,iSgn;
  BOOL direc = TRUE;

  idx = 1;
  while(Getwatch(idx,buf)) {
    idx++;
  }
  if(Getstatus() == STAT_NONE) {
    if(MessageBox(hwmain,"There is NO process to debug!!\nIt is nonsense, isn't it?","Ooooops!!",MB_YESNO | MB_ICONQUESTION) == IDNO) {
      MessageBox(hwmain,"Anyway, I don't want to set any watches now :p","hehehe",MB_OK|MB_ICONHAND);
    }
    return;
  }

  id = DialogBox(hinst,MAKEINTRESOURCE(IDD_ADDWATCH),hwmain,(DLGPROC)DlgProc);
  if(id == IDOK) {
    if(expression == LocX || expression == ArgX) {
      iFrom = atoi(strFrom);
      iTo   = atoi(strTo);
      if(iFrom > iTo) {
        ISWAP(iFrom,iTo);
        direc = FALSE;
      }
      for(i=iFrom; i<=iTo; i++) {
        wsprintf(buf,"%s%s%s%d%s",szStr[strMod],szAd1[adrMod],szExp[expression],i,szAd2[adrMod]);
        Insertwatch(idx,buf);
        if(direc) {
          idx++;
        }
      }
    }

    if(expression == EbpX || expression == EspX) {
      iFrom = strHEX2Int(strFrom,strlen(strFrom));
      iTo   = strHEX2Int(strTo  ,strlen(strTo)  );
      if(iFrom > iTo) {
        ISWAP(iFrom,iTo);
        direc = FALSE;
      }
      for(i=iFrom; i<=iTo; i+=4) {
        if(i<0) {
          iSgn = 1;
          ibuf = i * -1;
        }
        else {
          iSgn = 0;
          ibuf = i;
        }
        wsprintf(buf,"%X",ibuf);
        wsprintf(frm,"%%s%%s%%s%%s%%0%dX%%s",strlen(buf)+1);
        wsprintf(buf,frm,szStr[strMod],szAd1[adrMod],szExp[expression],szSgn[iSgn],ibuf,szAd2[adrMod]);
        Insertwatch(idx,buf);
        if(direc) {
          idx++;
        }
      }
    }
  }
}

void ModifyWatch(int idx, const char *Modifier, int ModType)
{
  char curexp[TEXTLEN],newexp[TEXTLEN],space[2];
  const char *psig,*psiz,*pdest;
  const char *SigMod[]  = {"signed","unsigned",""};
  const char *SizMod[] = {"byte","word","dword","char","short","long","qword","double","float10","float","string","unicode",""};
  const int iCanSig = 5;
  int i,idxsiz,sizcnt,sigcnt;

  if(idx < 1) {
    return;
  }
  if(!Getwatch(idx,curexp)) {
    return;
  }

  sizcnt = sizeof(SizMod)/sizeof(SizMod[0])-1;
  sigcnt = sizeof(SigMod)/sizeof(SigMod[0])-1;

  switch(ModType) {
  case MOD_SIZ:
    idxsiz = sizcnt;
    for(i=0; i<sizcnt; i++) {
      pdest = strstr(Modifier,SizMod[i]);
      if(pdest) {
        idxsiz = i;
        break;
      }
    }
    psiz = Modifier;

    psig = SigMod[sigcnt];
    for(i=0; i<sigcnt; i++) {
      pdest = strstr(curexp,SigMod[i]);
      if(pdest) {
        psig = SigMod[i];
        break;
      }
    }
    break;
  case MOD_SIG:
    psig = Modifier;
    psiz = SizMod[sizcnt];
    for(i=0; i<sizcnt; i++) {
      pdest = strstr(curexp,SizMod[i]);
      if(pdest) {
        psiz = SizMod[i];
        idxsiz = i;
        break;
      }
    }
    break;
  case MOD_NIL:
    psiz = psig = Modifier;
    break;
  default:
    break;
  }

  if(idxsiz > iCanSig && idxsiz < sizcnt) {
    psig = SigMod[sigcnt];
  }

  if(*psig=='\0' || *psiz=='\0') {
    wsprintf(space,"");
  }
  else {
    wsprintf(space," ");
  }

  pdest = strchr(curexp,'[');
  if(pdest!=NULL) {
    wsprintf(newexp,"%s%s%s%s",psig,space,psiz,pdest);
  }
  else {
    wsprintf(newexp,"%s%s%s[%s]",psig,space,psiz,curexp);
  }
  Deletewatch(idx);
  Insertwatch(idx,newexp);
  return;
}

LRESULT CALLBACK DlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{
  POINT pos;
  RECT  rect;
  UINT x,y,w,h,r,b,bMax,rMax;
  int l1,l2,mod;

  switch (msg) {
    case WM_INITDIALOG:
      SendMessage(GetDlgItem(hDlgWnd, IDC_LOCX)   , BM_SETCHECK, (WPARAM)1, 0L);
      SendMessage(GetDlgItem(hDlgWnd, IDC_STRNONE), BM_SETCHECK, (WPARAM)1, 0L);
      SendMessage(GetDlgItem(hDlgWnd, IDC_ADRNONE), BM_SETCHECK, (WPARAM)1, 0L);
      GetWindowRect(hDlgWnd,&rect);
      h = rect.bottom - rect.top;
      w = rect.right  - rect.left;
      GetCursorPos(&pos);
      b = pos.y + h;
      r = pos.x + w;
      rMax = GetSystemMetrics(SM_CXMAXIMIZED)-30;
      bMax = GetSystemMetrics(SM_CYMAXIMIZED)-30;
      if(b > bMax) {
        y = bMax - h;
      }
      else {
        y = pos.y;
      }
      if(r > rMax) {
        x = rMax - w;
      }
      else {
        x = pos.x;
      }
      MoveWindow(hDlgWnd,x,y,w,h,TRUE);

      return TRUE;
    case WM_COMMAND:
      switch (LOWORD(wp)) {
        case IDOK:

          // Expression
          if(IsDlgButtonChecked(hDlgWnd, IDC_LOCX) == BST_CHECKED) {
            expression = LocX;
          }
          if(IsDlgButtonChecked(hDlgWnd, IDC_ARGX) == BST_CHECKED) {
            expression = ArgX;
          }
          if(IsDlgButtonChecked(hDlgWnd, IDC_EBPX) == BST_CHECKED) {
            expression = EbpX;
          }
          if(IsDlgButtonChecked(hDlgWnd, IDC_ESPX) == BST_CHECKED) {
            expression = EspX;
          }

          // Get Number and Check
          l1 = GetWindowTextLength(GetDlgItem(hDlgWnd,IDC_FROM));
          l2 = GetWindowTextLength(GetDlgItem(hDlgWnd,IDC_TO)  );
          if(l1 == 0) {
            MessageBox(hDlgWnd,"Please specify range of watches.\n\nLOCs/ARGs -> DEC\nEBPs/ESPs -> HEX","Set Watches",MB_OK | MB_ICONINFORMATION);
            break;
          }
          else {
            GetDlgItemText(hDlgWnd,IDC_FROM,strFrom,8);
          }
          if(l2 == 0) {
            strcpy(strTo,strFrom);
          }
          else {
            GetDlgItemText(hDlgWnd,IDC_TO  ,strTo  ,8);
          }

          if(expression == LocX || expression == ArgX) {
            mod = NUM_DEC;
          }
          else if(expression == EbpX || expression == EspX) {
            mod = NUM_HEX;
          }

          if(!IsValidNumber(strFrom,strlen(strFrom),mod)) {
            goto NUM_INVALID;
          }
          if(!IsValidNumber(strTo,strlen(strTo),mod)) {
            goto NUM_INVALID;
          }

          // String Modification
          if(IsDlgButtonChecked(hDlgWnd, IDC_STRNONE) == BST_CHECKED) {
            strMod = strNone;
          }
          if(IsDlgButtonChecked(hDlgWnd, IDC_STRANSI) == BST_CHECKED) {
            strMod = strAnsi;
          }
          if(IsDlgButtonChecked(hDlgWnd, IDC_STRUNIC) == BST_CHECKED) {
            strMod = strUnic;
          }

          // Address Modification
          if(IsDlgButtonChecked(hDlgWnd, IDC_ADRNONE) == BST_CHECKED) {
            adrMod = adrNone;
          }
          if(IsDlgButtonChecked(hDlgWnd, IDC_ADRPTR1) == BST_CHECKED) {
            adrMod = adrPtr1;
          }
          if(IsDlgButtonChecked(hDlgWnd, IDC_ADRPTR2) == BST_CHECKED) {
            adrMod = adrPtr2;
          }

          EndDialog(hDlgWnd, IDOK);
          break;

NUM_INVALID:
          MessageBox(hDlgWnd,"Invalid Number!!\n\nLOCs/ARGs -> DEC\nEBPs/ESPs -> HEX","Set Watches",MB_OK | MB_ICONINFORMATION);
          break;

        case IDCANCEL:
          EndDialog(hDlgWnd, IDCANCEL);
          break;

        case IDC_STRNONE:
          EnableWindow(GetDlgItem(hDlgWnd, IDC_ADRNONE), TRUE);
          break;

        case IDC_STRANSI:
        case IDC_STRUNIC:
          SendMessage(GetDlgItem(hDlgWnd, IDC_ADRNONE)   , BM_SETCHECK, (WPARAM)0, 0L);
          SendMessage(GetDlgItem(hDlgWnd, IDC_ADRPTR1)   , BM_SETCHECK, (WPARAM)1, 0L);
          EnableWindow(GetDlgItem(hDlgWnd, IDC_ADRNONE), FALSE);
          break;

        default:
          return FALSE;
      }
    default:
      return FALSE;
  }
  return TRUE;
}

BOOL IsValidNumber(char *numstr, int size, int mode)
{
  int i;
  char *s;

  s = numstr;
  if(*s == '-' || *s == '+') {
    s++;
    size--;
  }
  for(i=0; i<size; i++) {
    switch(mode) {
    case NUM_DEC:
      if(*(s+i) < '0' || *(s+i) > '9') {
        return FALSE;
      }
      break;
    case NUM_HEX:
      if(!(   (*(s+i) >= '0' && *(s+i) <= '9')
           || (*(s+i) >= 'A' && *(s+i) <= 'F')
           || (*(s+i) >= 'a' && *(s+i) <= 'f') )) {
        return FALSE;
      }
      break;
    default:
      break;
    }
  }
  return TRUE;
}

int strHEX2Int(char *strHex, int size)
{
  int i,j,ibuf,inum = 0;
  char *h;
  BOOL Sign = FALSE;

  h = strHex;
  if(*h == '-') {
    Sign = TRUE;
    h++;
    size--;
  }

  for(i=0; i<size; i++) {
    ibuf = *(h+i);
    if(ibuf >= '0' && ibuf <= '9') {
      ibuf -= 0x30;
    }
    if(ibuf >= 'A' && ibuf <= 'F') {
      ibuf -= 0x37;
    }
    if(ibuf >= 'a' && ibuf <= 'f') {
      ibuf -= 0x57;
    }

    for(j=0; j<size-i-1; j++) {
      ibuf *= 0x10;
    }
    inum += ibuf;
  }
  if(Sign) {
    return inum * -1;
  }
  else {
    return inum;
  }
}
