/*

 Date:    9-20-04
 Author:  dzzie@yahoo.com
 Article: http://sandsprite.com/CodeStuff/VB_Plugin_for_Olly.html
 
 Same trick for IDA plugins   
          http://sandsprite.com/CodeStuff/IdaVbSample.zip

 VERY IMPORTANT NOTICE: COMPILE THIS DLL WITH BYTE ALIGNMENT OF STRUCTURES
 AND UNSIGNED CHAR!

*/
#include <windows.h>
#include <stdio.h>
#include <string.h>

#include <ole2.h>

#include "plugin.h"

HINSTANCE        hinst;
HWND             hwmain;

int DoAction(void);

BOOL WINAPI DllEntryPoint(HINSTANCE hi,DWORD reason,LPVOID reserved) {
  if (reason==DLL_PROCESS_ATTACH)
    hinst=hi;
  return 1;
};

extc int _export cdecl ODBG_Plugindata(char shortname[32]) {
  strcpy(shortname,"Vb Integration");
  return PLUGIN_VERSION;
};

extc int _export cdecl ODBG_Plugininit( int ollydbgversion,HWND hw,ulong *features) {
  if (ollydbgversion<PLUGIN_VERSION)
    return -1;
  hwmain=hw;
  Addtolist(0,0,"Vb Integration");
  Addtolist(0,-1,"  test line 2");
  return 0;
};

extc int _export cdecl ODBG_Pluginmenu(int origin,char data[4096],void *item) {
  switch (origin) {
    case PM_MAIN:
      strcpy(data,"0 &Do the VB thing");
      return 1;
    default: break;
  };
  return 0;
};

extc void _export cdecl ODBG_Pluginaction(int origin,int action,void *item) {
  if (origin==PM_MAIN) {
    switch (action) {
      case 0:
		DoAction();
        break;
      default: break;
    };
  };
};

extc void _export cdecl ODBG_Pluginreset(void) {
};

extc int _export cdecl ODBG_Pluginclose(void) {
  return 0;
};

extc void _export cdecl ODBG_Plugindestroy(void) {
};

int DoAction(){

    //Create an instance of our VB COM object, and execute
	//one of its methods so that it will load up and show a UI
	//for us, then it uses our other exports to access olly plugin API
	//methods

	CLSID      clsid;
	HRESULT	   hr;
	IDispatch *IDisp;

    LPOLESTR   p = OLESTR("VbOllyPlugin.CPlugin");

    hr = CoInitialize(NULL);

	 hr = CLSIDFromProgID( p , &clsid);
	 if( hr != S_OK  ){
		 MessageBox(0,"Failed to get Clsid from string\n","",0);
		 return 0;
	 }

	 // create an instance and get IDispatch pointer
	 hr =  CoCreateInstance( clsid,
							 NULL,
							 CLSCTX_INPROC_SERVER,
							 IID_IDispatch  ,
							 (void**) &IDisp
						   );

	 if ( hr != S_OK )
	 {
	   MessageBox(0,"CoCreate failed","",0);
	   return 0;
	 }

	 OLECHAR *sMethodName = OLESTR("DoPluginAction");
	 DISPID  dispid; // long integer containing the dispatch ID

	 // Get the Dispatch ID for the method name
	 hr=IDisp->GetIDsOfNames(IID_NULL,&sMethodName,1,LOCALE_USER_DEFAULT,&dispid);
	 if( FAILED(hr) ){
	    MessageBox(0,"GetIDS failed","",0);
		return 0;
	 }

	 DISPPARAMS dispparams;
	 VARIANTARG vararg[1]; //function takes one argument
	 VARIANT    retVal;

	 VariantInit(&vararg[0]);
	 /*
	 vararg[0].vt = VT_BSTR; //our argument is a BSTR type
	 vararg[0].bstrVal = SysAllocString(L"c:\\autoexec.bat"); //set string value 
	 */
	 dispparams.rgvarg = &vararg[0];
	 dispparams.cArgs = 0;  // num of args function takes
	 dispparams.cNamedArgs = 0;

	 // and invoke the method
	 hr=IDisp->Invoke( dispid, IID_NULL, LOCALE_USER_DEFAULT, DISPATCH_METHOD, &dispparams, &retVal, NULL, NULL);
	
	 /*
	 if( retVal.vt != VT_BOOL ){ 
			//cout << "Wrong return type from COM Function" ;
			return 0;
	 }
	

	 char buf[256];
	 sprintf(buf,"File %s", (retVal.boolVal ? "Exists" : "Not Found") ) ;
	 MessageBox(0,buf,"",0);
	 */
	 
	 MessageBox(0,"Plugin Done","",0);
	 IDisp->Release();

	 CoUninitialize();

	 return 0;






}



//Export API for the VB app to call and access Olly Plugin API data
//_________________________________________________________________

int __stdcall GetModuleBaseAddress(void){
  struct t_dump *currentmodule;
  
  currentmodule = (t_dump *)Plugingetvalue(VAL_CPUDASM);
  return (int)currentmodule->base;
}

int __stdcall GetModuleSize(void){
  struct t_dump *currentmodule;
  
  currentmodule = (t_dump *)Plugingetvalue(VAL_CPUDASM);
  return (int)currentmodule->size;
}

int __stdcall DoFindName(int *offset, LPSTR pszString){

  char name[256];
  struct t_dump *currentmodule;
  int retVal=0;
  //char msg[300];

  currentmodule = (t_dump *)Plugingetvalue(VAL_CPUDASM);

  retVal = Findname(*offset, NM_COMMENT, name) ;
  
  //sprintf(msg,"Ret: %d, Offset: %x , Comment: %s", retVal, *offset, name);
  //MessageBox(0,msg, "In Do FindName", 0);

  if(retVal > 0) strcpy(pszString, name);
	
  return retVal;

}


