/*--------------------------------------------------------*/
/* Copyright (c) PSW-soft 1996                            */
/*                                                        */
/* File:     MODIF.C                                      */
/*                                                        */
/* Project:  Password Cracking Library                    */
/* Version:  2.0                                          */
/*                                                        */
/* Author:   Pavel Semjanov                               */
/* Company:  PSW-soft                                     */
/*                                                        */
/* Comment:  String and modifiers routines                */
/*                                                        */
/* Create:   06.08.1996 01:32:26                          */
/* Update:   25.08.1998 20:00:10                          */
/*                                                        */
/* Revision: 2.0   25.08.1998 20:00:10 2.0 release        */
/* Revision: 1.0   06.08.1996 01:32:26 Initial revision   */
/*--------------------------------------------------------*/

#include <ctype.h>
#include <string.h>
#include "maindef.h"
#include "pcl.h"
#include "modif.h"

char *strrshrink (s, dummy)
char *s;
int16 dummy;
{
register char *p1, *p2;

   if (*s) {
     for (p1 = p2 = s+1; *p1; p1++)
       if (!isrvowel (*p1)) *p2++ = *p1;
     *p2 = '\0';
   }

   return (s);
}

char *strconvert (s, i)
char *s;
int16 i;
{
register char *p;

   for (p = s; *p; p++) {
     *p = convert_tables[i+2][(unsigned char)(*p)];
   }

  return (s);
}


char *strrtoupper (s, n)
char *s;
int16 n;
{
  if (n == 0) {
   register char *p;

   for (p = s; *p; p++) {
     *p = rtoupper (*p);
   }
  }
 else {
   if (n < 0) n += strlen(s);
   else n--;

/*     ..   MAX_PASSWORD */
   if (n >= 0 && n < MAX_PASSWORD)  s[n] = rtoupper (s[n]);

 }

  return (s);
}

char *strrtolower (s, n)
char *s;
int16 n;
{
  if (n == 0) {
   register char *p;

   for (p = s; *p; p++) {
     *p = rtolower (*p);
   }
  }
 else {

   if (n < 0) n += strlen(s);
   else n--;

/*     ..   MAX_PASSWORD+1 */
   if (n >= 0 && n < MAX_PASSWORD)  s[n] = rtolower (s[n]);
 }

  return (s);
}

char *strrtocool (s, param)
char *s;
int16 param;
{
register char *p;

 if (param == 0) {      /* odd */
   for (p = s; *p; p++) {
     *p = rtoupper (*p);
     if (*(++p) == '\0') break;
   }
 }
 else if (param == 1) { /* even */
   for (p=s; *p;) {
     if (*(++p) == '\0') break;
     *p = rtoupper (*p);
     p++;
   }
 }
 else if (param == 2) { /* vowels */
   for (p=s; *p; p++) {
     if (isrvowel (*p)) *p = rtoupper (*p);
   }
 }
 else { /* (if param == 3)  consonants */
   for (p=s; *p; p++) {
     if (!isrvowel (*p)) *p = rtoupper (*p);
   }
 }

  return (s);
}

char *strcut (s, n)
char *s;
int16 n;
{
   if (n < 0) n += strlen (s) + 1;

/*     ..   MAX_PASSWORD+1 */
   if (n >= 0 && n <= MAX_PASSWORD)  s[n] = '\0';

  return (s);
}

char *strduplicate (s, param)
char *s;
int16 param;
{
register char *p1, *p2;
int len;

  len = strlen (s);

  if (param == 0) {
    memcpy (s + len, s, min (len, MAX_PASSWORD - len));
    s[len+min (len, MAX_PASSWORD - len)] = '\0';
  }
  else /* if (param == 1) */ {
    p2 = s + len;
    p1 = p2 - 1;
    len = min (len, MAX_PASSWORD - len);
    while (len--) *p2++= *p1--;
    *p2 = '\0';
  }

  return (s);

}

char *strrevm (s, dummy)
char *s;
int16 dummy;
{
#ifdef __GNUC__

register int i;
register int len;

   len = strlen (s);

   for (i = 0; i < len / 2; i++)
     swap (s[i], s[len-1-i]);

   return (s);

#else
   return (strrev (s));
#endif

}



char *strscat (set1, set2)
char *set1, *set2;
{
char *s;

   s = set1 + strlen (set1);

   for (; *set2; set2++)
     if (strchr (set1, *set2) == NULL) {
       *s = *set2;
       *(++s) = '\0';
     }

  return (set1);
}

char *strsset (set)
char *set;
{
static char buf[256];

  buf[0] = '\0';
  return (strcpy (set, strscat (buf, set)));
}



