/*--------------------------------------------------------*/
/* Copyright (c) PSW-soft 1996                            */
/*                                                        */
/* File:     PCL.C                                        */
/*                                                        */
/* Project:  Password Cracking Library                    */
/* Version:  2.0c                                         */
/*                                                        */
/* Author:   Pavel Semjanov                               */
/* Company:  PSW-soft                                     */
/*                                                        */
/* Comment:  Main file                                    */
/*                                                        */
/* Create:   06.08.1996 21:39:20                          */
/* Update:   09.05.1999 20:56:20                          */
/*                                                        */
/* Revision: 2.0b   09.05.1999 20:56:20 .c(1) bug fixed.  */
/*           Password now is printing in hex.             */
/* Revision: 2.0   08.09.1998 18:09:28 v. 2.0 release     */
/* Revision: 1.1a  14.08.1997 17:52:44 NO_USER_BRUTE is   */
/*           global var now.                              */
/* Revision: 1.1   28.08.1996 22:31:04 Regular code       */
/*           changed. Implemented in YAAC 0.95.           */
/* Revision: 1.0   06.08.1996 21:39:20Initial revision   */
/*           (implemented in cRARk 1.5)                   */
/*--------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#ifdef DEBUG
#include <alloc.h>
#endif

#include "maindef.h"
#include "pcl.h"
#include "modif.h"

/* main variables. Interface with user's module */

char psw_chars[MAX_PASSWORD+1]; // current password. '\0' is NOT GUARANTIED!
int psw_len;                    // current password length


UPASS passwords;        // passwords tested. Must be incremented in user's module!

/* internal variables */

char defined_sets[10][256];	// predefined and user's defined sets */

char *convert_tables[256+2];    // convert tables (.c modifier)


FILE *yyin, *yyout;          // yacc files
int line;                    // current line in yyin

char *component [MAX_PASSWORD+1];  // password componets
int i_comp;                        // it's quantity


FILE *f_dict, *f_user;             // dictionary files descriptors
boolean _main_dict, _user_dict;    // used or not
boolean defined_main_dict, defined_user_dict; // defined or not
int min_psw_len, max_psw_len;      // min & max password length if '*' used

int reg_len;			   // MAX (!) current length of '*' (may be static chars)

char *_copyright = "(c) PSW-soft Password Cracking Library PCL v. 2.0c by P. Semjanov";

/* main function */

void parse_rules_file (rules_file, _min_psw_len, _max_psw_len)
char *rules_file;
int _min_psw_len, _max_psw_len;
{
register int i;
UPASS dummy;

  Time_F(START, &dummy);  // for abnormal exit

  min_psw_len = _min_psw_len;
  max_psw_len = _max_psw_len;

  if ((yyin = fopen (rules_file, "r")) == NULL) {
    perror (rules_file);
    exit (1);
  }

  line = 1;
//  passwords = 0;

  yyparse();

  for (i = MAX_PASSWORD; i >=0 ; i--)
    if (component[i]) free (component[i]);
  for (i = 256+1; i >= 0; i--)
    if (convert_tables[i]) free (convert_tables[i]);

  if (defined_main_dict) fclose (f_dict);
  if (defined_user_dict) fclose (f_user);
#ifdef DEBUG
  printf (" === heap = %d\n", heapcheck());
#endif

}


/* process one line from PDF */

void process_line ()
{
UPASS dummy;

#ifdef DEBUG
  int i;

  for (i = 0; i < i_comp; i++) printf ("%d %s | ", component[i][0], component[i] + 1);
  if (component[i_comp] != NULL) printf (" NOT NULL |");
  printf ("\n used_chars = |%s|\n", USED_CHARS);
#endif

   printf ("\nProcessing line %d of password definition file...\n", line);
   Time_F(START, &dummy);

   init_brute_force ();
   reg_len = min_psw_len;                   /* min_psw_len <= reg_len <= max_psw_len */
   if (isregular (component[i_comp-1])) {   /* '*' at the end */
     do {
//       if (reg_len > min_psw_len)
         printf ("Testing %d-chars passwords ...\n", reg_len);
       make_password (0, 0);
     } while (++reg_len <= max_psw_len);
   }
   else make_password (0, 0);

   print_password (STOP, FALSE);
   if (_main_dict) fseek (f_dict, 0L, SEEK_SET);
   if (_user_dict) fseek (f_user, 0L, SEEK_SET);
}

void open_user_file (char *name)
{
   if ((f_user = fopen (name, "r")) == NULL) {
     perror (name);
     exit (1);
   }
}

void open_dict_file (char *name)
{
  if ((f_dict = fopen (name, "r")) == NULL) {
    perror (name);
    exit (1);
  }
}

/* main password construction function */


void make_password (len, comp_len)
int len;            /* current password length */
int comp_len;       /* current component number */
{
register int word_len;
register char *s;
long d_fpos, u_fpos;

    if (comp_len == i_comp) { psw_len = len;  test (); }
    else {

      if (isregular (component[comp_len])) {   /* '*' at the end */
        if (reg_len - len <= 0) {
          psw_len = len;
          if (test() == -1)
            fprintf (stderr, "Warning: password beginning %*.*s doesn't match\n", len, len, psw_chars);
        }
        else {
//          if (len <= reg_len) {
          make_regular (reg_len, len+1, component[comp_len]+1);
//          }
        }
      }

      else if (isset (component[comp_len])) {  /* charset */
        if (isnull (component[comp_len])) make_password (len, comp_len+1);
        if (len == MAX_PASSWORD) yyerror ("Max password length exceeded");
        for (s = component[comp_len]+1; *s; s++) {
          psw_chars[len] = *s;
          make_password (len+1, comp_len+1);
        }
      }
      else if (ispermut (component[comp_len])) {   /* permutations */
        make_permutations (len, comp_len + 1, get_perm_number (component[comp_len]), len+1, len);
      }
      else {   /* word & modifiers */
        if (_main_dict) {
          d_fpos = ftell (f_dict);
          fseek (f_dict, 0L, SEEK_SET);
        }
        if (_user_dict) {
          u_fpos = ftell (f_user);
          fseek (f_user, 0L, SEEK_SET);
        }
        while ( (s = get_modify_word(component[comp_len])) != NULL) {
          word_len = strlen (s);
          if (len + word_len > MAX_PASSWORD)
            fprintf (stderr, "Warning: password %*.*s%s exceeds max length\n", len, len, psw_chars, s);
          else {
            strcpy (psw_chars + len, s);
            make_password (len + word_len, comp_len + 1);
          }
        }
        if (_user_dict) fseek (f_user, u_fpos, SEEK_SET);
        if (_main_dict) fseek (f_dict, d_fpos, SEEK_SET);
      }
    }
}

void make_permutations (len, comp_len, n, i_insert, i_replace)
int len;            /* current password length */
int comp_len;       /* current component number */
int n;              /* recursive permutation number */
int i_insert;       /* position of already inserted */
int i_replace;      /* position of already replaced */
{
    make_delete  (len, comp_len, n, i_insert, i_replace);
    make_insert  (len, comp_len, n, i_insert, i_replace);
    make_swap    (len, comp_len, n, i_insert, i_replace);
    make_replace (len, comp_len, n, i_insert, i_replace);

    make_password (len, comp_len);
}

/* swap permutations */

void make_swap (len, comp_len, n, i_insert, i_replace)
int len;            /* current password length */
int comp_len;       /* current component number */
int n;              /* recursive permutation number */
int i_insert;       /* position of already inserted */
int i_replace;      /* position of already replaced */
{
register int i;

  if (n == 0) return;

#ifdef DEBUG
  printf (" %*s swap %d\n", n, "====", n);
#endif
  for (i = len-2; i >= 0; i--) {
    if (psw_chars[i] != psw_chars[i+1]) {
        swap (psw_chars[i], psw_chars [i+1]);
        make_password (len, comp_len);
        make_swap    (len, comp_len, n-1, i_insert, i_replace);
        make_insert  (len, comp_len, n-1, i_insert, i_replace);
        make_replace (len, comp_len, n-1, i_insert, i_replace);
        swap (psw_chars[i], psw_chars [i+1]);
    }
  }
#ifdef DEBUG

  printf (" %*s end swap %d\n", n, "====", n);
#endif

}

/* delete permutations */

void make_delete (len, comp_len, n, i_insert, i_replace)
int len;            /* current password length */
int comp_len;       /* current component number */
int n;              /* recursive permutation number */
int i_insert;       /* position of already inserted */
int i_replace;      /* position of already replaced */
{
register int i;
register char c;

  if (n == 0) return;
#ifdef DEBUG
  printf (" %*s delete %d\n", n, "====", n);
#endif
  if (len == 0) return;
  c = psw_chars[len-1];

  for (i = len-1; i > 0; i--) {
//  if (i != i_insert && i != i_replace) {
    make_password (len-1, comp_len);
    make_swap     (len-1, comp_len, n-1, i_insert-1, i_replace-1);
    make_insert   (len-1, comp_len, n-1, i_insert-1, i_replace-1);
    make_delete   (len-1, comp_len, n-1, i_insert-1, i_replace-1);
    make_replace  (len-1, comp_len, n-1, i_insert-1, i_replace-1);
//    }
    swap (psw_chars[i-1], c);
  }

//  if (i_insert != 0 && i_replace != 0) {
    make_password (len-1, comp_len);
    make_swap     (len-1, comp_len, n-1, i_insert-1, i_replace-1);
    make_insert   (len-1, comp_len, n-1, i_insert-1, i_replace-1);
    make_delete   (len-1, comp_len, n-1, i_insert-1, i_replace-1);
    make_replace  (len-1, comp_len, n-1, i_insert-1, i_replace-1);
// }

  memmove (psw_chars+1, psw_chars, len-1);
  psw_chars[0] = c;

#ifdef DEBUG
  printf (" %*s end delete %d\n", n, "====", n);
#endif

}


/* insert permutation */

void make_insert (len, comp_len, n, i_insert, i_replace)
int len;            /* current password length */
int comp_len;       /* current component number */
int n;              /* recursive permutation number */
int i_insert;       /* position of already inserted */
int i_replace;      /* position of already replaced */
{
register int i;
register char *s;

  if (n == 0) return;

#ifdef DEBUG
  printf (" %*s insert %d\n", n, "====", n);
#endif

   for (i = len; i >= 0; i--) {
     if (i <= i_insert) {
     for (s = USED_CHARS; *s; s++) {
       psw_chars[i] = *s;
       make_password (len+1, comp_len);
       make_insert   (len+1, comp_len, n-1, i, ((i < i_replace) ? (i_replace + 1) : (i_replace)));
       make_replace  (len+1, comp_len, n-1, i, ((i < i_replace) ? (i_replace + 1) : (i_replace)));
       }
     }
    psw_chars[i] = psw_chars[i-1];
   }
   memmove (psw_chars, psw_chars+1, len);
#ifdef DEBUG
  printf (" %*s end insert %d\n", n, "====", n);
#endif
}

/* replace permutation */

void make_replace (len, comp_len, n, i_insert, i_replace)
int len;            /* current password length */
int comp_len;       /* current component number */
int n;              /* recursive permutation number */
int i_insert;       /* position of already inserted */
int i_replace;      /* position of already replaced */
{
register int i;
register char *s;
char c;

  if (n == 0) return;

#ifdef DEBUG
   printf (" %*s replace %d\n", n, "====", n);
#endif

   for (i = i_replace-1; i >= 0; i--) {
     if (i != i_insert) {
     c = psw_chars[i];
     for (s = USED_CHARS; *s; s++) {
       psw_chars[i] = *s;
       make_password (len, comp_len);
       make_replace  (len, comp_len, n-1, i_insert, i);
     }
    psw_chars[i] = c;
    }
   }

#ifdef DEBUG
   printf (" %*s end replace %d\n", n, "====", n);
#endif
}

/* work with '*' */


void make_regular (reg_len, len, s)
int reg_len;             /* final length */
int len;                 /* current password length */
char *s;                 /* charset */
{
if (!NO_USER_BRUTE) {
   psw_len = reg_len;
   brute_force (len, s);
} else {

int cnt;

  cnt = 0;
  while ( (psw_chars[len-1] = s[cnt++]) != 0) {
    if (len < reg_len) {
      psw_len = len;
  /*    if (test () == -1) goto NEXT_CHAR;    // only if needed (4% more passwords)
      else */  make_regular (reg_len, len+1, s);
    }
    else {
       psw_len = len;
       test ();
    }
NEXT_CHAR : ;
  }

} /* NO_USER_BRUTE */

}


/* gets and modifies the word */

char *get_modify_word (s)
char *s;
{
str_func *f;
static char buf[MAX_PASSWORD+1];
int ii =0;

   f = (str_func *) (s+1);
   if (! ismodif (s) || f->fnc == NULL) yyerror ("Internal error");
   for (; f->fnc != NULL; f++) 
     if ((f->fnc) (buf, f->param) == NULL) return (NULL);
//   puts (buf);
   return (buf);
}



char *get_dict_word (s, dummy)
char *s;
int16 dummy;
{
  return (mfgets (s, MAX_PASSWORD+1, f_dict));
}


char *get_user_word (s, dummy)
char *s;
int16 dummy;
{
  return (mfgets (s, MAX_PASSWORD+1, f_user));
}

/* Determines the set to insert in construction like {$w.u} */

char *make_wordset (s)
char *s;
{
str_func *f;
static char buf[256];
int ii = 0;

   f = (str_func *) (s+1);
   if (! ismodif (s) || f->fnc == NULL) yyerror ("Internal error");
   (f->fnc) (buf, f->param);  /* get_word */
   strcpy (buf, wordtoset(buf));
   for (f++; f->fnc != NULL; f++) 
     if (f->fnc != strrshrink && f->fnc != strcut)
       (f->fnc) (buf, f->param);
    if (_main_dict) fseek (f_dict, 0L, SEEK_SET);
    if (_user_dict) fseek (f_user, 0L, SEEK_SET);
   return (buf);
}


/* ,       */

char *wordtoset (c)
char *c;
{
register unsigned char *uc;
static char buf[256];
register int i;

  buf [0] = '\0';
  for (uc = c; *uc; uc++) {
    for (i=0; i <= 6; i++) {
      if (strchr (defined_sets[i], *uc) != NULL) {
        strscat (buf, defined_sets[i]); goto NEXT;
      }
    }
    { /*       */
      unsigned char ch;

      ch = *(uc+1);
      *(uc+1) = '\0';
      strscat (buf, uc);
      *(uc+1) = ch;
    }
  NEXT: ;
  }
  return (buf);
}


/* Does any defined set contain char c? */

void test_char (c)
char *c;
{
register int i;

    for (i=0; i <= 6; i++) {
      if (strchr (defined_sets[i], *c) != NULL) return;
    }
    /*       */

      yywarning ("No charset for", c);
}


/* predefined sets initilaization */

void init_set()
{
register int i;

  strcpy (defined_sets[0], D_ELOWER);
  strcpy (defined_sets[1], D_EUPPER);
  strcpy (defined_sets[2], D_DIGITS);
  strcpy (defined_sets[3], D_SPECIAL);

  if ((U_TOUPPER = (char *) malloc (256)) == NULL ||
      (U_TOLOWER = (char *) malloc (256)) == NULL)
    yyerror ("Out of memory");

  for (i = 0; i < 256; i++)
    U_TOUPPER[i] = U_TOLOWER[i] = (char) i;

  make_upper_lower (D_ELOWER, D_EUPPER, 1);
  make_upper_lower (D_EUPPER, D_ELOWER, 0);

}

/* makes convert table from string to string */ 


void make_upper_lower (from, to, i)
char *from, *to;
int i;
{
 register int j;
 char buf[2];
 buf[1] = '\0';

  for (j =0; from[j] && to [j]; j++)
   {
   if ( convert_tables[i][(unsigned char) from[j]] != from[j] &&
        convert_tables[i][(unsigned char) from[j]] != to[j] ) {
     buf[0] = from[j];
     yywarning ("ambiguous conversion of char", buf);
   }
   else convert_tables[i][(unsigned char) from[j]] = to[j];
   }
}

/* makes convert table from defined convert string */


void make_convert (to, i)
char *to;
int i;
{
register int j;

  if ((convert_tables[i+2] = (char *) malloc (256)) == NULL)
    yyerror ("Out of memory");

  for (j = 0; j < 256; j++)
    convert_tables[i+2][j] = (char) j;

  make_upper_lower (U_QUOT, to, i+2);

}

/* prints defined charsets and tests convert tables */


void test_definition()
{
 char buf[256];
 int i;

  printf ("$a   = %s (%d)\t$A   = %s (%d)\n", U_ELOWER, strlen (U_ELOWER), U_EUPPER, strlen (U_EUPPER));
  printf ("$a.u = %s\t", strrtoupper (strcpy(buf, U_ELOWER), 0));
  printf ("$A.l = %s\n", strrtolower (strcpy(buf, U_EUPPER), 0));
  printf ("$!   = %s (%d)\t$1   = %s (%d)\n", U_SPECIAL, strlen (U_SPECIAL), U_DIGITS, strlen (U_DIGITS));
  printf ("$i   = %s (%d)\t$I   = %s (%d)\n", U_RLOWER, strlen(U_RLOWER), U_RUPPER, strlen(U_RUPPER));
  printf ("$i.u = %s\t", strrtoupper (strcpy(buf, U_RLOWER), 0));
  printf ("$I.l = %s\n", strrtolower (strcpy(buf, U_RUPPER), 0));
  printf ("$o   = %s (%d)\n", U_USER, strlen (U_USER));
  printf ("?    = %s (%d)\n", U_QUOT, strlen (U_QUOT));
  printf ("$v   = %s (%d)\n", U_VOWELS, strlen (U_VOWELS));
  if (USED_CHARS[0] == '\0') 
  printf ("$p   = AUTO\n");
  else
  printf ("$p   = %s (%d)\n", USED_CHARS, strlen (USED_CHARS));

  for (i = 0; i < 256; i++) {
    if (convert_tables[i+2] != NULL)
      if (strcmp (U_QUOT, strconvert(strconvert(strcpy(buf, U_QUOT), i), i)) == 0)
        printf ("?.c(%d).c(%d) = ?\n", i, i);
      else printf ("?.c(%d).c(%d) != ?\n", i, i);
  }
  printf ("\n");
}

