/*--------------------------------------------------------*/
/* Copyright (c) PSW-soft 1996-98 by P. Semjanov          */
/*                                                        */
/* Prototype for PCL 2.0 using                            */
/*                                                        */
/*--------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "pcl.h"


int NO_USER_BRUTE = TRUE; // if no user's brute force function used,
                          // else FALSE


/* main variables. Interface with user's module

char psw_chars[256];          // current password. Ending '\0' is NOT GUARANTIED!
int psw_len;                  // current password length

UPASS passwords;      // passwords tested. Must be incremented in user's module

*/

main (argc, argv)
int argc;
char *argv[];
{

/* benchmark() does benchmarks */

  if (argc > 1) if (argv[1][0] == 'b') { benchmark(); exit(1); }
   passwords = 0;

/* parse_rules_file() is the main function. Is called from
user's module after command line
processing, all global operation doing etc. Arguments:
  rules_file       - password definition filename,
  min_psw_len, max_psw_len - min & max password lengths
*/

   parse_rules_file ("password.def", 1, 5);
   printf ("\n" UPASS_FMT " passwords tested\n", passwords);
}

/* test(). Callback test password function.
   Must increase "passwords" variable.
   Returns:
     0  - password is correct. In this case
          test() may exit(0) if no more password needed;
     any > 0 - password is not correct;
     -1 - password is not correct and no one (longer)
          password can begin with such chars
*/

int test (void)
{
  psw_chars[psw_len] = '\0';  /* before printing */
  if (psw_len)  printf ("%s\n", psw_chars);
  else puts ("NULL_PASSWORD");

#ifdef __GNUC__
#define MOD(a,b)  ((a) % (b))
#else
#define MOD(a,b)  ((a) - ((UPASS) (unsigned long)((a) / (UPASS)(b)) ) * (UPASS)(b))
#endif

  passwords++;

/* print_password() prints current password or/and statistics
   Arguments:
      mode = STOP - means stop the timer and print statistics
      mode = GET  - don't stop the timer and print current password
                    and statistics

      right_password = TRUE, if password found
                     = FALSE otherwise
 */

  if (MOD (passwords, 1000000L) == 0) print_password (GET, FALSE);

  if (strcmp (psw_chars, "yako")==0) print_password (STOP, TRUE);
  else return (1);
}

/* init_brute_force(). Callback function. 
 Any global operation before password testing should be done here.
 Called when new line of password definition file is processing */

void init_brute_force()
{}

/* get_special(). Callback function. 
   Gets user defined special charset or words.
   Called if $s encountered.
   Arguments:
       s  - already existing char[256] buffer. Copy return value to this;
       n  - the number of special charset (number after $s).
   Returns:
       buf or
       NULL if no more words.
*/

char *get_special (s, n)
char *s;
int16 n;
{
// let $s(1) may be "aa" or "bb"

char *special[] = { "aa", "bb"}; 

static int i = 0;

   if (n == 1) {
      if (i < 2) return (strcpy (s, special[i++]));
      else { i = 0; return (NULL); }
     }
   else yyerror ("Invalid special charset");

}

/* brute_force(). Callback function. Does user's brute force attack
  (maybe more effective) instead of standard (when '*' encountered 
   in password definition file).
   Called only if NO_USER_BRUTE is FALSE.
   Arguments:
       len - current length of psw_chars;
       charset - charset to add to the end of psw_chars;
   Here:
       psw_len - desired length of password.
*/


void brute_force (int len, char *charset) {
// must fill only if NO_USER_BRUTE == FALSE
}


/* definition_done(). Callback function. Is called when definition
part of password definintion file was parsed successfully */

void definition_done()
{

/* test_definition() prints defined charsets and tests
   defined convert strings */

 test_definition();
}

