/*--------------------------------------------------------*/
/* Copyright (c) PSW-soft 1996                            */
/*                                                        */
/* File:     PCL.H                                        */
/*                                                        */
/* Project:  Password Cracking Library                    */
/* Version:  2.0b                                         */
/*                                                        */
/* Author:   Pavel Semjanov                               */
/* Company:  PSW-soft                                     */
/*                                                        */
/* Comment:  Main header file                             */
/*                                                        */
/* Create:   06.08.1996 21:39:20                          */
/* Update:   08.05.1999 19:14:56                          */
/*                                                        */
/* Revision: 2.0b   08.05.1999 19:14:56 long long         */
/*           passwords. New parameter in                  */
/*           print_password(). LFN support.               */
/* Revision: 2.0a   21.11.1998 17:36:58 5th line bug      */
/*           fixed (Time_F prototype added)               */
/* Revision: 2.0   28.08.1998 15:05:00 2.0 release        */
/* Revision: 1.1a  14.08.1997 00:18:58 Russian charset    */
/*           bug fixed. NO_USER_BRUTE extern added.       */
/* Revision: 1.1   26.08.1996 12:54:56 str_func parameter */
/*           added. DJGPP compatibility added.            */
/* Revision: 1.0   06.08.1996 21:39:20 Initial revision   */
/*           (implemented in cRARk 1.5)                   */
/*--------------------------------------------------------*/

#include <stdio.h>
#include "maindef.h"

#define MAX_PASSWORD 255		/* very good if eq. 2^n-1 */

#define D_EUPPER  "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define D_ELOWER  "abcdefghijklmnopqrstuvwxyz"
#define D_DIGITS  "0123456789"
#define D_SPECIAL "{}:\"<>?[];\',./~!@#$%^&*()_+`-=\\|"

/* interface with user's module */

#ifdef __GNUC__
typedef unsigned long long UPASS;
#define UPASS_FMT "%llu"
#else
typedef double UPASS;
#define UPASS_FMT "%.0f"
#endif


extern char psw_chars[MAX_PASSWORD+1]; /* password (ending '\0' isn't necessary !!!) */
extern int psw_len;                    /* its length */
extern UPASS passwords;		       /* passwords tested */
extern int NO_USER_BRUTE;              /* set TRUE if standard brute force function is used, */
                                       /*    FALSE - your own  */

extern char *_copyright;

void parse_rules_file (char *rules_file,
                       int _min_psw_len, int _max_psw_len);

/* main function. Is called from user's module after command line
processing, all global operation doing etc. Arguments:
  rules_file       - password definition filename,
  min_psw_len, max_psw_len - min & max password lengths
*/

int test (void);

/* Callback test password function. Must increase "passwords" variable.
   Returns:
     0  - password is correct. In this case
          test() may exit(0) if no more password needed;
     any > 0 - password is not correct;
     -1 - password is not correct and no one (longer)
          password can begin with such chars
*/

void definition_done(void);

/* Callback function. Is called when definition part of password
definintion file was parsed successfully */

void init_brute_force(void);

/* Callback function. Any global operation before password testing.
 Called when new line of password definition file is processing */

void brute_force (int len, char *charset);

/* User callback (maybe more efficient) brute force attack instead of
   standard (when '*' encountered in password definition file).
   Called only if NO_USER_BRUTE is FALSE.
   Arguments:
       len - current length of psw_chars;
       charset - charset to add to the end of psw_chars;
   Here:
       psw_len - desired length of password.
*/

char *get_special (char *buf, int16 n);

/* Callback function. Get user defined special charset or words.
   Called if $s encountered.
   Arguments:
       buf - already existing char[256] buffer. Copy return value to this;
       n   - the number of special charset (number after $s).
   Returns:
       buf or
       NULL if no more words.
*/

void print_password (int mode, boolean right_password);

/* Prints current password or/and statistics
   Arguments:
      mode = STOP - means stop the timer and print statistics
      mode = GET  - don't stop the timer and print current password
                    and statistics

      right_password = TRUE, if password found
                     = FALSE otherwise
 */


void test_definition (void);

/* Prints defined charsets and tests defined convert strings */

/**********************************************************************/
/* OS Definitions */

#ifdef __GNUC__
#include <sys/param.h>
#else
#if defined (__TURBOC__)
#include <dir.h>
#else
#include <stdlib.h>
#endif

#if defined (MAXPATH)
#define MAXPATHLEN MAXPATH
#elif defined (_MAX_PATH)
#define MAXPATHLEN _MAX_PATH
#else
#error Please define Max path length
#endif
#endif


/**********************************************************************/
/* Internal definitions */

/* component types */

#define C_ERROR   0
#define C_NULL    16           /* null char */
#define C_SET     1            /* set of chars */
#define C_MODIF   2            /* word (and modificator) */
#define C_PERMUT  3            /* permutation */
#define C_ASTER   64           /* regular '*' */

#define isset(s) ( (*(s) & 7) == C_SET)
#define isnull(s) ( (*(s) & C_NULL) == C_NULL)
#define ismodif(s) ( (*(s) & 7) == C_MODIF)
#define ispermut(s) ( (*(s) & 7) == C_PERMUT)
#define isregular(s) ( (*(s) & C_ASTER) == C_ASTER)
#define get_perm_number(s) ( (int) s[1])

#define swap(c1, c2)   { register char _cc; _cc = (c1); (c1) = (c2); (c2) = _cc; }


/* type of get word & modifiers function pointer + short int parameter.
   Maybe different sizes because of alignment */

struct s_strfunc {
        char * (*fnc) (char *, int16);
        int16  param;
};

typedef struct s_strfunc str_func;

extern char defined_sets[10][256];

#define U_ELOWER   (defined_sets[0])  //       0 - english lower,
#define U_EUPPER   (defined_sets[1])  //       1 - english upper,
#define U_DIGITS   (defined_sets[2])  //       2 - digits,
#define U_SPECIAL  (defined_sets[3])  //       3 - special chars,
#define U_RLOWER   (defined_sets[4])  //       4 - international lower,
#define U_RUPPER   (defined_sets[5])  //       5 - international upper,
#define U_USER     (defined_sets[6])  //       6 - user's
#define U_QUOT     (defined_sets[7])  //       7 - metachar '?'
#define USED_CHARS (defined_sets[8])  //       8 - set to insert and replace
#define U_VOWELS   (defined_sets[9])  //       9 - all languages vowels

extern char *convert_tables[256+2];

#define U_TOLOWER (convert_tables[0]) // to lower
#define U_TOUPPER (convert_tables[1]) // to upper

extern char *component[MAX_PASSWORD+1];
extern int i_comp;
extern boolean _user_dict, _main_dict;
extern boolean defined_main_dict, defined_user_dict;

void process_line (void);
void open_dict_file (char *);
void open_user_file (char *);

void make_password (int, int);
void make_permutations (int, int, int, int, int);
void make_swap (int, int, int, int, int);
void make_delete (int, int, int, int, int);
void make_insert (int, int, int, int, int);
void make_replace (int, int, int, int, int);
void make_regular (int, int, char *);

void init_set(void);
void benchmark(void);

char *strscat (char *, char *);
char *strsset (char *);
char *get_modify_word (char *);
char *mfgets(char *string, int n, FILE *stream);

char *get_dict_word (char *, int16);
char *get_user_word (char *, int16);

char *make_wordset (char *);
char *wordtoset (char *);
void test_char (char *);
void make_upper_lower (char *, char *, int);
void make_convert (char *, int);

double Time_F (int, UPASS *);

#define START	0
#define STOP	1
#define GET     2
