#include <stdio.h>
#include <windows.h>
#include <conio.h>
#pragma hdrstop
#include <condefs.h>

#define BLOCK_SIZE 32768

//---------------------------------------------------------------------------

int memstr(const char *buf, const char *s, size_t size)
{
   int        off;
   const char *s_temp;

   //return -1;
   if(!buf || !s || !(*s)) return -1;

   for(off = 0; off < size; off++)
   {
      for(s_temp = s; *s_temp != 0 && *buf == *s_temp; buf++, s_temp++)
      {
         off++;
         if(off >= size) return -1;
      }
      if((*(buf - 1) == *(s_temp - 1)) && *s_temp == 0) return off;
      buf++;
   }
   return -1;
}

LPSTR findEncryptPass(const char *filename)
{
   FILE   *prot_file;
   char   *buff = 0, *s;
   size_t rc;
   int    off;

   prot_file = fopen(filename, "rb");
   if(!prot_file) return 0;
   buff = (char *)malloc(BLOCK_SIZE);
   if(!buff) return 0;
   do
   {
      rc = fread(buff, 1, BLOCK_SIZE, prot_file);
      if(!rc) break;
      off = memstr(buff, "DPB=\"", BLOCK_SIZE);
      if(off < 0)
      {
         if(rc < BLOCK_SIZE) break;
         fseek(prot_file, -32, SEEK_CUR);
         continue;
      }
      fseek(prot_file, off - rc, SEEK_CUR);
      rc = fread(buff, 1, BLOCK_SIZE, prot_file);
      if(!rc) break;
      s = strchr(buff, '\"');
      *s = 0;
      return buff;
   } while(!feof(prot_file));
   free(buff);
   return 0;
}

void decryptPassword(const char *encrypt_pass, char *s)
{
   char str[128], ch;
   char hs[] = { 0, 0, 0 };
   int  v1, v2, i, l;
   int  begin_found = 0;

   *s = 0;

   for(i = 0; encrypt_pass[i*2]; i++)
   {
      hs[0] = encrypt_pass[i*2]; hs[1] = encrypt_pass[i*2+1];
      v1 = strtol(hs, 0, 16);
      hs[0] = encrypt_pass[i*2+4]; hs[1] = encrypt_pass[i*2+5];
      v2 = strtol(hs, 0, 16);
      if(!begin_found)
      {
         if(v1 == v2) begin_found = 1;
      }
      else
      {
         if(v1 != v2)
            begin_found = 0;
         else
         {
            i += 3;
            break;
         }
      }
   }

   if(!begin_found) return;

   for(ch = 0, l = 0; encrypt_pass[i*2+2]; i++, l++)
   {
      hs[0] = encrypt_pass[(i-2)*2]; hs[1] = encrypt_pass[(i-2)*2+1];
      v1 = strtol(hs, 0, 16);
      hs[0] = encrypt_pass[i*2]; hs[1] = encrypt_pass[i*2+1];
      v2 = strtol(hs, 0, 16);
      ch = (ch + (char)v1) ^ (char)v2;
      str[l] = ch;
   }
   str[l] = 0;
   CharToOem(str, s);
}

#pragma argsused
int main(int argc, char **argv)
{
   char s[128];
   char *encrypt_pass_str;

   if(argc < 2)
   {
      printf("Usage: vbakey.exe filename\n");
      return 1;
   }

   if(!(encrypt_pass_str = findEncryptPass(argv[1])))
   {
      //CharToOem("  \n", s);
      printf("Password not found\n");
      return 1;
   }

   decryptPassword(encrypt_pass_str, s);
   printf("File password: %s\n", s);
   free(encrypt_pass_str);
   printf("Press any key for continue ... \n");
   getch();
   return 0;
}
