	;; textio.asm
	;; Robin Miyagi <deltak@telus.net>

	;; This is my implementation of some stdio.h like functions.
	;; This is implemented as a shared library.
		
	bits 32
	
	%include "pic.mac"
	
	%define stdin 0x0
	%define stdout 0x1
	%define stderr 0x2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	section .data
	global greet_str:data greet_str.len
	
greet_str:
	db "Have a nice day!", 0xa, 0x0
    .len equ $ - greet_str
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	section .bss
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	section .text
	extern _GLOBAL_OFFSET_TABLE_
	global put_string:function
	global get_string:function
	global friendly:function
			
	;; PROTOTYPE: int put_string (char *string); 
	;; This function accepts a pointer to the first character of the
	;; sting, and returns the number of characters actually
	;; outputted to standard output.
put_string:
    .string_ptr equ 8
	push ebp
	mov ebp, esp
	xor edx, edx
	mov ecx, [ebp + .string_ptr]
    .count_again:	
	cmp [ecx + edx], byte 0x0
	je .done_count
	inc edx
	jmp .count_again
    .done_count:	
	mov eax, 0x4			; system call 0x4 (write)
	mov ebx, stdout			; file desc. is stdout
	int 0x80
	leave
	ret

	;; PROTOTYPE: int get_string (char *string); 
	;; This function gets a string from the standard input, and
	;; stops reading when a newline character, or end-of-file
	;; character is received.  The terminating character is replaced
	;; with the NULL character, once the input has been completed.
	;; This function returns the number of characters that were
	;; actually read.  Care must be taken to ensure that no more
	;; characters are read, than the amount of allocated memory
	;; pointed to by char *string.
get_string:	
    .string_ptr equ 8
	push ebp
	mov ebp, esp
	xor esi, esi
	mov ebx, stdin			; file desc. is stdin
	mov ecx, [ebp + .string_ptr]	; ecx --> string
	xor edx, edx
	inc edx
    .get_char:	
	mov eax, 0x3			; system call 0x3 (read)
	int 0x80
	cmp [ecx], byte 0xa		; is character newline?
	je .done_get_char
	cmp [ecx], byte 0x4		; is character EOF (ctrl+D)?
	je .done_get_char
	inc ecx
	inc esi
	jmp .get_char
    .done_get_char:	
	mov [ecx], byte 0x0
	mov eax, esi			; return the no. of char. read
	leave
	ret

	;; PROTOTYPE: char *friendly (void); This function returns a
	;; pointer to a friendly message and is only included to
	;; demonstrate how data in the .data and .bss sections are
	;; accessed in position independent code.
friendly:	
	BEGIN_PIC_MODULE		; macro defined in pic.mac
	lea eax, [ebx + greet_str wrt ..gotoff]
	END_PIC_MODULE			; macro defined in pic.mac