// S3DRV Plugs for NDW 1.00 for Windows 9x
// Copyright (C) , 1999 ,
//
// Author:
//           Zhunanhao  , reached at nhzhu@163.net
//
// History :
//           1999.4.12 , Zhunanhao write origin code .
//

#include <wdm.h>
#include "...\INCLUDE\PLUGS.H"

// prototypes

extern "C" NTSTATUS
DriverEntry(IN PDRIVER_OBJECT DriverObject, IN PUNICODE_STRING RegistryPath);

VOID
PLUGS_Unload(IN PDRIVER_OBJECT DriverObject);


NTSTATUS
DriverEntry(IN PDRIVER_OBJECT DriverObject, IN PUNICODE_STRING RegistryPath)
{
	NTSTATUS	ntStatus = STATUS_SUCCESS;

	DriverObject->DriverUnload = PLUGS_Unload;

	return ntStatus;
}

VOID
PLUGS_Unload(IN PDRIVER_OBJECT DriverObject)
{
}

/****************** WDM Rountine End ****************/

// prototype

BOOL SaveRegister ( ) ;
BOOL RestoreRegister ( ) ;

// end

PLUGS_API*	api = 0 ;

EXC EXPORT BOOL Plugs_Init ( PLUGS_API* plugsapi )
{
	api = plugsapi ;

	api->hook( api->hh_DisplaySaveRegister , SaveRegister,0 ) ;
	api->hook( api->hh_DisplayRestoreRegister, RestoreRegister , 0 ) ;

	api->dprintf ( "S3DRV Plugs Ver 0.01 Initialized..." ) ;

	return TRUE ;
}

EXC EXPORT BOOL Plugs_Exit ( )
{
	api->unhook( api->hh_DisplaySaveRegister , SaveRegister ) ;
	api->unhook( api->hh_DisplayRestoreRegister, RestoreRegister );
	return TRUE ;
}

/***************** Save/Restore Register ***************/

BYTE S3_Register_State[0x51] = { 0 , 0 , 0 } ;
// Why we set 50H ? Because S3-special register is 30H-80H .

BOOL SaveRegister ( )
{
	BYTE Port_3D4_State ;

	_asm {
pushad

           mov      edx,3d4h        //EDX --> CRTC index register
           in       al,dx           //save current index reg value...
           mov      Port_3D4_State,al

           mov      ax,4838h
           out      dx,ax       //make S3 regs unlocked 30-3FH.
           mov      ax,0a539h   //make S3 regs unlocked 40-80H&36H
           out      dx,ax

           mov      edi,offset S3_Register_State
           mov      ecx,51h
           mov      ah,30h      // Begin from 30H
           cld

     Save_S3_Register:

           mov      al,ah
           out      dx,al
           inc      edx
           in       al,dx
           dec      edx
           stosb
           inc      ah
           loop     Save_S3_Register

           mov      dl,0d4h             //EDX --> CRTC index register
           mov      al,Port_3D4_State   //restore CRTC index register
           out      dx,al

           popad
     }

     return TRUE ;
}

BOOL RestoreRegister ( )
{
     BYTE Port_3D4_State ;

     _asm {
           pushad

           mov      edx,3d4h        //EDX --> CRTC index register
           in       al,dx           //save current index reg value...
           mov      Port_3D4_State,al

           mov      ax,4838h
           out      dx,ax           //make S3 regs unlocked 30-3FH.
           mov      ax,0a539h       //make S3 regs unlocked 40-80H&36H
           out      dx,ax

           mov      esi,offset S3_Register_State
           mov      ecx,51h
           mov      ah,30h          // Begin from 30H
           cld

     Restore_S3_Register:

           mov      al,ah
           out      dx,al
           inc      dx
           lodsb
           out      dx,al
           dec      dx
           inc      ah
           loop     Restore_S3_Register

           mov      dl,0d4h             //EDX --> CRTC index register
           mov      al,Port_3D4_State   //restore CRTC index register
           out      dx,al

           popad
     }

     return TRUE ;
}

