/************************************************************************
*                   common.cpp                                          *
* This includes the lptr class, and any other common functions that     *
* are needed.                                                           *
* The lptr class is a class of 'long pointers' which contain a segment  *
* and an offset value.                                                  *
* I have defined some arithmetic on these which make coding in Borg     *
* easier.                                                               *
* Within Borg the seg/offset values should be well defined, ie unique.  *
* This means we do not have to test for seg1:offs1==seg2:offs2 where    *
* seg1!=seg2. Borg addresses should all be individual. [Of course this  *
* may make some coding of DOS exe's harder later on, but I dont believe *
* it will be a great burden.                                            *
************************************************************************/

#include <windows.h>
#include "common.h"

/************************************************************************
* nlptr                                                                 *
* - this is a predefined null pointer                                   *
************************************************************************/
const lptr nlptr(0,0);

/************************************************************************
* lptr constructor with values                                          *
* - the standard constructor and destructor are defined in the header   *
*   as null functions. This constructor allows for declarations like    *
*   the nlptr declaration above                                         *
************************************************************************/
lptr::lptr(word seg,dword off)
{ segm=seg;
  offs=off;
}

/************************************************************************
* assign                                                                *
* - this is an assign function for the lptr, to give it a specific      *
*   segment and offset combination.                                     *
************************************************************************/
void lptr::assign(word seg,dword off)
{ segm=seg;
  offs=off;
}

/************************************************************************
* lptr == operator                                                      *
************************************************************************/
BOOL lptr::operator==(lptr loc2)
{ return ((segm==loc2.segm)&&(offs==loc2.offs));
}

/************************************************************************
* lptr <= operator                                                      *
* - this overload of <= is well defined given the constraints we have   *
*   placed on the lptr class. It allows simplification of code in many  *
*   of the lists and databases.                                         *
************************************************************************/
BOOL lptr::operator<=(lptr loc2)
{ if(segm!=loc2.segm) return (segm<=loc2.segm);
  return (offs<=loc2.offs);
}

/************************************************************************
* lptr >= operator                                                      *
* - this overload of >= is well defined given the constraints we have   *
*   placed on the lptr class. It allows simplification of code in many  *
*   of the lists and databases.                                         *
************************************************************************/
BOOL lptr::operator>=(lptr loc2)
{ if(segm!=loc2.segm) return (segm>=loc2.segm);
  return (offs>=loc2.offs);
}

/************************************************************************
* lptr < operator                                                       *
* - this overload of < is well defined given the constraints we have    *
*   placed on the lptr class. It allows simplification of code in many  *
*   of the lists and databases.                                         *
************************************************************************/
BOOL lptr::operator<(lptr loc2)
{ if(segm!=loc2.segm) return (segm<loc2.segm);
  return (offs<loc2.offs);
}

/************************************************************************
* lptr > operator                                                       *
* - this overload of > is well defined given the constraints we have    *
*   placed on the lptr class. It allows simplification of code in many  *
*   of the lists and databases.                                         *
************************************************************************/
BOOL lptr::operator>(lptr loc2)
{ if(segm!=loc2.segm) return (segm>loc2.segm);
  return (offs>loc2.offs);
}

/************************************************************************
* lptr != operator                                                      *
* - this overload of != is well defined given the constraints we have   *
*   placed on the lptr class. It allows simplification of code in many  *
*   of the lists and databases.                                         *
************************************************************************/
BOOL lptr::operator!=(lptr loc2)
{ return ((segm!=loc2.segm)||(offs!=loc2.offs));
}

/************************************************************************
* lptr + dword operator                                                 *
* - this has been defined to allowed an expression like lptr r+1 to be  *
*   used. It simply adds the dword to the offset of the lptr, and does  *
*   not change the segment at all                                       *
************************************************************************/
lptr lptr::operator+(dword offs2)
{ lptr tmp;
  tmp.segm=segm;
  tmp.offs=offs+offs2;
  return tmp;
}

/************************************************************************
* lptr ++ operator                                                      *
* - as for + dword we can define ++ similarly                           *
* - note that in these functions offsets can wrap around but generally  *
*   this should not be a problem for us                                 *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
// increment lptr.
lptr lptr::operator++(int x)
{ offs++;
  return *this;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

/************************************************************************
* lptr += operator                                                      *
* - An overload of +=, as for + and ++                                  *
************************************************************************/
lptr lptr::operator+=(dword offs2)
{ offs+=offs2;
  return *this;
}

/************************************************************************
* lptr - (dword) operator                                               *
* - If we can add a dword then we take one away also....                *
************************************************************************/
lptr lptr::operator-(dword offs2)
{ lptr tmp;
  tmp.segm=segm;
  tmp.offs=offs-offs2;
  return tmp;
}

/************************************************************************
* lptr1 - lptr2 operator                                                *
* - I have overloaded - in two ways. The first, above, takes a dword    *
*   from an operator, by taking it from the lptrs offset. This overload *
*   allows the difference in two operators to be taken, and returns a   *
*   dword which is the difference in offsets. Now you should only       *
*   really be interested in this if the segments are the same. I found  *
*   it useful to make this definition because it greatly simplifies     *
*   code elsewhere. Note that with some complex expressions you need to *
*   force operator precedence, for example dword+(loc1-loc2)+dword2     *
*   type expressions need the brackets for force the - to be performed  *
*   first.                                                              *
************************************************************************/
dword lptr::operator-(lptr loc2)
{ return offs-loc2.offs;
}

/************************************************************************
* Basic Support Functions                                               *
************************************************************************/

/************************************************************************
* cleanstring                                                           *
* - moved out of the disasm class build 211.                            *
* - simply changes any strange characters in a string into an           *
*   underscore, used for generating automatic names from disassembled   *
*   strings.                                                            *
************************************************************************/
void cleanstring(char *str)
{ unsigned int i;
  for(i=0;i<strlen(str);i++)
  { if(!isalnum(str[i]))str[i]='_';
  }
}




