/************************************************************************
*                  Dasm.cpp                                             *
*                                                                       *
*              Borg Disassembler                                        *
*                    v2.20                                              *
*                 by Cronos                                             *
*                                                                       *
* Contributors:                                                         *
* Thanks to Mark Ogden for many bugfixes and mods for assembly under    *
* VC++, in its early stages (v2 beta builds). Also changes from         *
* wvsprintf to wsprintf to allow compilation under VC++.                *
* Thanks to Eugen Polukhin for some interesting alternate code and      *
* ideas around v2.11 and feedback on fonts, etc.                        *
************************************************************************/

/************************************************************************
* dasm.cpp                                                              *
* - this whole file is a declaration and global routine dumping area    *
* - it includes winmain and the main message callback routine, along    *
*   with initialisation code and the registry read/write code, odd      *
*   dialog boxes and helper functions for the main routines. The whole  *
*   file is a bit of a mish-mash of stuff which hasnt found its way     *
*   elsewhere.                                                          *
* - a lot of the code in here has grown, and i mean grown from the      *
*   ground up, and at some point it will require reorganisation, or     *
*   maybe that point was long ago....                                   *
************************************************************************/

#define WM_MAXITOUT (WM_USER+100)

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>

#include "menuids.rh"
#include "fileload.h"
#include "data.h"
#include "schedule.h"
#include "proctab.h"
#include "disasm.h"
#include "dasm.h"
#include "names.h"
#include "mainwind.h"
#include "imports.h"
#include "exports.h"
#include "xref.h"
#include "relocs.h"
#include "srch.h"
#include "disio.h"
#include "range.h"
#include "decrypt.h"

/************************************************************************
* decaration dumping ground........                                     *
************************************************************************/
CRITICAL_SECTION cs;
volatile BOOL KillThread;
volatile BOOL InThread;
globaloptions options;

fileloader floader;
dataseg dta;
schedule scheduler;
disasm dsm;
disio dio;
names name;
xref xrefs;
imports import;
exports expt;
relocs reloc;
range blk;
decrypt decrypter;

LRESULT CALLBACK dasm(HWND,UINT,WPARAM,LPARAM);
BOOL FAR PASCAL habox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL FAR PASCAL shutbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL FAR PASCAL helpshortcuts(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
BOOL TestThread(void);
void optionsinit(void);
BOOL newfile(HWND hwnd);
void Thread(PVOID pvoid);
BOOL savefile_text(HWND hwnd,BOOL printaddrs,BOOL block);
void StatusMessage(char *msg);
void savedb(void);
void loaddb(void);
void changemenus(void);
void load_reg_entries(void);
void save_reg_entries(void);
void setupfont(void);
COLORREF choosecolour(COLORREF cr);
COLORREF crCustColors[16];
HFONT cf=NULL;

OPENFILENAME ofn;
CHOOSECOLOR cc;
char szDirName[MAX_PATH];
char szFile[260];
char szFilesave[260];
char szFilter[260];
char szFileTitle[260];
char winname[300];
BOOL winmax=false;
HINSTANCE hInst;
HWND hwndStatusBar;
HANDLE ThreadHandle;
HWND mainwindow;
DWORD ThreadId;
RECT mainwnd,mainwndsize,StatusWindowSize;
int cxChar,cyChar;
HMENU rmenu;
BOOL charinputenabled=FALSE;

char szWinName[]="Dasm";
char fname[]="Borg Disassembler";
char reg_borg[]="Software\\Borg";

/************************************************************************
* WinMain..... it all starts here                                       *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
int WINAPI WinMain(HINSTANCE hThisInst,HINSTANCE hPrevInst,LPSTR lpszArgs,int nWinMode)
{ HWND hwnd;
  MSG msg;
  WNDCLASSEX wcl;
  int cx,cy;

  InitCommonControls();

  cx=GetSystemMetrics(SM_CXFULLSCREEN);
  cy=GetSystemMetrics(SM_CYFULLSCREEN);
  /* Define window class */
  wcl.hInstance=hThisInst;
  wcl.lpszClassName=szWinName;
  wcl.lpfnWndProc=dasm;
  wcl.style=CS_DBLCLKS|CS_HREDRAW|CS_VREDRAW;

  wcl.cbSize=sizeof(WNDCLASSEX);

  wcl.hIcon=LoadIcon(NULL,IDI_APPLICATION);
  wcl.hIconSm=LoadIcon(NULL,IDI_WINLOGO);

  wcl.hCursor=LoadCursor(NULL,IDC_ARROW);
  wcl.lpszMenuName=MAKEINTRESOURCE(main_menu);

  wcl.cbClsExtra=0;
  wcl.cbWndExtra=0;
  // this was causing the flickering.........damn thing
  wcl.hbrBackground=NULL;//(HBRUSH)(COLOR_APPWORKSPACE+1);

  hInst=hThisInst;

  /* Register window class */
  if(!RegisterClassEx(&wcl))return 0;

  /* Create window */
  sprintf(winname,"Borg Disassembler v%0d.%2d",(int)BORG_VER/100,BORG_VER%100);
  hwnd=CreateWindow(szWinName,winname,WS_OVERLAPPEDWINDOW,
			 cx/2-320,cy/2-230,640,480,
			 NULL,NULL,hThisInst,NULL);

  mainwndsize.top=0;
  mainwndsize.bottom=cy-1;
  mainwndsize.left=0;
  mainwndsize.right=cx-1;

  /* Display window */
  ShowWindow(hwnd,nWinMode);
  UpdateWindow(hwnd);

  /* Message Loop */
  while(GetMessage(&msg,NULL,0,0))
  { TranslateMessage(&msg);
	 DispatchMessage(&msg);
  }

  return msg.wParam;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

/************************************************************************
* dasm                                                                  *
* - dasm is the application main window.                                *
* - everything the main window does is in this routine (for now) and    *
*   where a response is quick it appears in one of its helper functions *
*   later in this file, otherwise it has been substantial enough to     *
*   warrant its own file and routines........                           *
* - this is long                                                        *
************************************************************************/
LRESULT CALLBACK dasm(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ HDC hdc;
  TEXTMETRIC tm;
  POINT point;
  lptr scrll;
  int killcount;
  mainwindow=hwnd;
  RECT tmp_rect;
  switch(message)
  { case WM_COMMAND:
		switch(LOWORD(wParam))
		{ case file_exit:
			 SendMessage(mainwindow,WM_CLOSE,0,0);
			 break;
		  case file_save:
			 savefile_text(hwnd,TRUE,FALSE);
			 break;
        case get_comment:
          dio.getcomment();
          break;
		  case save_database:
			 savedb();
			 break;
		  case load_database:
			 loaddb();
			 break;
		  case save_asm:
			 savefile_text(hwnd,FALSE,FALSE);
			 break;
        case block_saveasm:
			 savefile_text(hwnd,FALSE,TRUE);
			 break;
        case block_savetext:
			 savefile_text(hwnd,TRUE,TRUE);
			 break;
        case cm_decrypt:
          decrypter.dialg();
          break;
		  case file_open:
			 newfile(hwnd);
			 break;
		  case view_segment:
			 dta.segviewer();
			 break;
		  case view_names:
			 name.namesviewer();
			 break;
		  case view_imports:
			 import.importsviewer();
			 break;
		  case view_exports:
			 expt.exportsviewer();
			 break;
		  case view_xrefs:
			 xrefs.xrefsviewer();
			 break;
		  case make_code:
			 scheduler.addtask(user_makecode,priority_userrequest,nlptr,NULL);
			 break;
		  case make_dword:
			 scheduler.addtask(user_makedword,priority_userrequest,nlptr,NULL);
			 break;
        case float_single:
			 scheduler.addtask(user_makesingle,priority_userrequest,nlptr,NULL);
			 break;
        case float_double:
			 scheduler.addtask(user_makedouble,priority_userrequest,nlptr,NULL);
			 break;
        case float_longdouble:
			 scheduler.addtask(user_makelongdouble,priority_userrequest,nlptr,NULL);
			 break;
		  case make_word:
			 scheduler.addtask(user_makeword,priority_userrequest,nlptr,NULL);
			 break;
		  case make_string:
			 scheduler.addtask(user_makestring,priority_userrequest,nlptr,NULL);
			 break;
		  case pascal_string:
			 scheduler.addtask(user_pascalstring,priority_userrequest,nlptr,NULL);
			 break;
		  case uc_string:
			 scheduler.addtask(user_ucstring,priority_userrequest,nlptr,NULL);
			 break;
		  case up_string:
			 scheduler.addtask(user_upstring,priority_userrequest,nlptr,NULL);
			 break;
		  case dos_string:
			 scheduler.addtask(user_dosstring,priority_userrequest,nlptr,NULL);
			 break;
		  case general_string:
			 scheduler.addtask(user_generalstring,priority_userrequest,nlptr,NULL);
			 break;
		  case argover_dec:
			 scheduler.addtask(user_argoverdec,priority_userrequest,nlptr,NULL);
			 break;
		  case arg_single:
			 scheduler.addtask(user_argsingle,priority_userrequest,nlptr,NULL);
			 break;
		  case argover_hex:
			 scheduler.addtask(user_argoverhex,priority_userrequest,nlptr,NULL);
			 break;
        case argnegate:
          scheduler.addtask(user_argnegate,priority_userrequest,nlptr,NULL);
          break;
		  case offset_dseg:
			 scheduler.addtask(user_argoveroffsetdseg,priority_userrequest,nlptr,NULL);
			 break;
		  case argover_char:
			 scheduler.addtask(user_argoverchar,priority_userrequest,nlptr,NULL);
			 break;
		  case undefine_line:
			 scheduler.addtask(user_undefineline,priority_userrequest,nlptr,NULL);
			 break;
		  case undefine_lines:
			 scheduler.addtask(user_undefinelines,priority_userrequest,nlptr,NULL);
			 break;
		  case undefine_lines_long:
			 scheduler.addtask(user_undefinelines_long,priority_userrequest,nlptr,NULL);
			 break;
        case block_undefine:
          scheduler.addtask(user_undefineblock,priority_userrequest,nlptr,NULL);
          break;
        case block_view:
          blockview();
          break;
        case block_top:
          scheduler.addtask(user_marktopblock,priority_userrequest,nlptr,NULL);
          break;
        case block_bottom:
          scheduler.addtask(user_markbottomblock,priority_userrequest,nlptr,NULL);
          break;
		  case line_jumpto:
			 scheduler.addtask(user_jumpto,priority_userrequest,nlptr,NULL);
			 break;
		  case line_jumptoarg2:
			 scheduler.addtask(user_jumptoarg2,priority_userrequest,nlptr,NULL);
			 break;
		  case Name_Location:
			 name.nameloc();
			 break;
		  case help_short:
			 DialogBox(hInst,MAKEINTRESOURCE(help_shortcuts),hwnd,(DLGPROC)helpshortcuts);
			 break;
		  case help_about:
			 DialogBox(hInst,MAKEINTRESOURCE(D_help_about),hwnd,(DLGPROC)habox);
			 break;
		  case Jump_Back:
			 scheduler.addtask(user_jumpback,priority_userrequest,nlptr,NULL);
			 break;
		  case main_search:
			 searchengine();
			 break;
        case search_again:
          searchmore();
          break;
        case set_bg_color:
          options.bgcolor=choosecolour(options.bgcolor);
          GetClientRect(mainwindow,&tmp_rect);
          InvalidateRect(mainwindow,&tmp_rect,TRUE);
          scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
          break;
        case set_high_color:
          options.highcolor=choosecolour(options.highcolor);
          GetClientRect(mainwindow,&tmp_rect);
          InvalidateRect(mainwindow,&tmp_rect,TRUE);
          scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
          break;
        case set_text_color:
          options.textcolor=choosecolour(options.textcolor);
          GetClientRect(mainwindow,&tmp_rect);
          InvalidateRect(mainwindow,&tmp_rect,TRUE);
          scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
          break;
        case font_system:
          options.font=systemfont;
          setupfont();
          break;
        case font_courier:
          options.font=courierfont;
          setupfont();
          break;
        case font_courier10:
          options.font=courierfont10;
          setupfont();
          break;
        case font_courier12:
          options.font=courierfont12;
          setupfont();
          break;
        case font_ansi:
          options.font=ansifont;
          setupfont();
          break;
		  default:
			 return DefWindowProc(hwnd,message,wParam,lParam);
		}
		break;
	 case WM_CHAR:
		if(charinputenabled)
		  switch(wParam)
		  { case 'c':
			   scheduler.addtask(user_makecode,priority_userrequest,nlptr,NULL);
			   break;
		    case 'C':
			   scheduler.addtask(user_argoverchar,priority_userrequest,nlptr,NULL);
			   break;
		    case 'd':
			   scheduler.addtask(user_makedword,priority_userrequest,nlptr,NULL);
			   break;
		    case 'D':
			   scheduler.addtask(user_argoverdec,priority_userrequest,nlptr,NULL);
			   break;
		    case 'H':
			   scheduler.addtask(user_argoverhex,priority_userrequest,nlptr,NULL);
			   break;
          case '-':
            scheduler.addtask(user_argnegate,priority_userrequest,nlptr,NULL);
            break;
		    case 'n':
			   name.nameloc();
			   break;
          case ';':
            dio.getcomment();
        	   break;
		    case 'o':
			   scheduler.addtask(user_argoveroffsetdseg,priority_userrequest,nlptr,NULL);
			   break;
		    case 'p':
			   scheduler.addtask(user_pascalstring,priority_userrequest,nlptr,NULL);
			   break;
		    case 's':
			   scheduler.addtask(user_makestring,priority_userrequest,nlptr,NULL);
			   break;
		    case 'u':
			   scheduler.addtask(user_undefineline,priority_userrequest,nlptr,NULL);
			   break;
		    case 'U':
			   scheduler.addtask(user_undefinelines,priority_userrequest,nlptr,NULL);
			   break;
		    case 'w':
			   scheduler.addtask(user_makeword,priority_userrequest,nlptr,NULL);
			   break;
          case 't':
            scheduler.addtask(user_marktopblock,priority_userrequest,nlptr,NULL);
            break;
          case 'b':
            scheduler.addtask(user_markbottomblock,priority_userrequest,nlptr,NULL);
            break;
		    default:
			   break;
		  }
		break;
	 case WM_LBUTTONDOWN:
		dio.setpos(HIWORD(lParam));
		break;
	 case WM_RBUTTONDOWN:
		dio.setpos(HIWORD(lParam));
		point.x=LOWORD(lParam);
		point.y=HIWORD(lParam);
		ClientToScreen(mainwindow,&point);
		TrackPopupMenu(rmenu,0,point.x,point.y,0,mainwindow,NULL);
		break;
	 case WM_PAINT:
		if(!KillThread)DoPaint(hwnd,cxChar,cyChar);
		else PaintBack(hwnd);
		//ValidateRect(mainwindow,NULL);
		break;
	 case WM_CLOSE:
		if(MessageBox(mainwindow,"Are you sure that you want to exit Borg ?\n\rHit Yes To Exit\n\rHit No to Stay","Borg Disassembler",
		  MB_ICONEXCLAMATION|MB_YESNO)==IDNO)break;
      scheduler.stopthread();
		scheduler.addtask(quitborg,priority_quit,nlptr,NULL);
		KillThread=TRUE;
		if(InThread)SetThreadPriority(ThreadHandle,THREAD_PRIORITY_TIME_CRITICAL);
		DestroyWindow(mainwindow);
		return 0;
	 case WM_DESTROY:
      save_reg_entries();
		KillThread=TRUE;
		killcount=0;
		Sleep(0);
		SetPriorityClass(ThreadHandle,HIGH_PRIORITY_CLASS);
		if(InThread)
		  while(TestThread())
		  { killcount++;
			 if(killcount>2)
			 { // this is a nasty way of getting out.
				// sometimes the thread just will not exit nicely when its busy.
				if(TerminateThread(ThreadHandle,1))
				{ CloseHandle(ThreadHandle);
				  break;
				}
			 }
		  }
		DeleteCriticalSection(&cs);
		PostQuitMessage(0);
		break;
	 case WM_SIZE:
    	if(wParam==SIZE_MAXIMIZED)
      	winmax=true;
      else if (wParam==SIZE_RESTORED)
      	winmax=false;
		mainwndsize.top=0;
		mainwndsize.left=0;
		mainwndsize.right=LOWORD(lParam);
		mainwndsize.bottom=HIWORD(lParam);
		GetWindowRect(hwndStatusBar,&StatusWindowSize);
		GetWindowRect(mainwindow,&mainwnd);
		MoveWindow(hwndStatusBar,0,mainwndsize.bottom-StatusWindowSize.bottom+StatusWindowSize.top,
		  mainwndsize.right,StatusWindowSize.bottom-StatusWindowSize.top,TRUE);
		break;
	 case WM_VSCROLL:
		switch(LOWORD(wParam))
		{ case SB_TOP:
			 break;
		  case SB_BOTTOM:
			 break;
		  case SB_LINEUP:
			 scrll.assign(0,-1);
			 if(InThread)scheduler.addtask(scrolling,priority_userrequest,scrll,NULL);
			 break;
		  case SB_LINEDOWN:
			 scrll.assign(0,1);
			 if(InThread)scheduler.addtask(scrolling,priority_userrequest,scrll,NULL);
			 break;
		  case SB_PAGEUP:
			 scrll.assign(0,-mainwndsize.bottom/cyChar+1);
			 if(InThread)scheduler.addtask(scrolling,priority_userrequest,scrll,NULL);
			 break;
		  case SB_PAGEDOWN:
			 scrll.assign(0,mainwndsize.bottom/cyChar-1);
			 if(InThread)scheduler.addtask(scrolling,priority_userrequest,scrll,NULL);
			 break;
		  case SB_THUMBPOSITION:
          scrll.assign(0,HIWORD(wParam));
          if(InThread)scheduler.addtask(vthumbposition,priority_userrequest,scrll,NULL);
			 break;
		  default:
			 break;
		}
		break;
	 case WM_HSCROLL:
		switch(LOWORD(wParam))
		{ case SB_LINEUP:
			 scrll.assign(0,-1);
			 scheduler.addtask(hscroll,priority_userrequest,scrll,NULL);
			 break;
		  case SB_LINEDOWN:
			 scrll.assign(0,1);
			 scheduler.addtask(hscroll,priority_userrequest,scrll,NULL);
			 break;
		  case SB_PAGEUP:
			 scrll.assign(0,-8);
			 scheduler.addtask(hscroll,priority_userrequest,scrll,NULL);
			 break;
		  case SB_PAGEDOWN:
			 scrll.assign(0,8);
			 scheduler.addtask(hscroll,priority_userrequest,scrll,NULL);
			 break;
		  case SB_THUMBPOSITION:
            scrll.assign(0,HIWORD(wParam));
            if(InThread)scheduler.addtask(hthumbposition,priority_userrequest,scrll,NULL);
			 break;
		  default:
			 break;
		}
		break;
    // maximises window, used when the reg is read in at the start to maximise
    // the main window after initialisation of it
    case WM_MAXITOUT:
    	ShowWindow(mainwindow,SW_MAXIMIZE);
      break;
	 case WM_CREATE:
		optionsinit();
		hdc=GetDC(hwnd);
		SelectObject(hdc,GetStockObject(ANSI_FIXED_FONT));
		GetTextMetrics(hdc,&tm);
		cxChar=tm.tmAveCharWidth;
		cyChar=tm.tmHeight+tm.tmExternalLeading;
		ReleaseDC(hwnd,hdc);
		InitializeCriticalSection(&cs);
		hwndStatusBar=CreateStatusWindow(WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS|CCS_BOTTOM,
		  "No File Loaded",hwnd,2);
		GetWindowRect(hwndStatusBar,&StatusWindowSize);
		GetWindowRect(mainwindow,&mainwnd);
		SetScrollRange(hwnd,SB_VERT,0,VERTSCROLLRANGE,FALSE);
		SetScrollPos(hwnd,SB_VERT,0,FALSE);
		KillThread=FALSE;
		InThread=FALSE;
		InitPaintSubsystem();
		rmenu=LoadMenu(hInst,MAKEINTRESOURCE(right_click_menu));
		rmenu=GetSubMenu(rmenu,0);
      load_reg_entries();
      setupfont();
		break;
	 case WM_KEYDOWN:
      if(!charinputenabled) break;
		switch(wParam)
		{ case VK_HOME:
			 SendMessage(hwnd,WM_VSCROLL,SB_TOP,0L);
			 break;
		  case VK_PRIOR:
			 SendMessage(hwnd,WM_VSCROLL,SB_PAGEUP,0L);
			 break;
		  case VK_NEXT:
			 SendMessage(hwnd,WM_VSCROLL,SB_PAGEDOWN,0L);
			 break;
		  case VK_DOWN:
			 SendMessage(hwnd,WM_VSCROLL,SB_LINEDOWN,0L);
			 break;
		  case VK_UP:
			 SendMessage(hwnd,WM_VSCROLL,SB_LINEUP,0L);
			 break;
		  case VK_LEFT:
			 SendMessage(hwnd,WM_HSCROLL,SB_PAGEUP,0L);
			 break;
		  case VK_RIGHT:
			 SendMessage(hwnd,WM_HSCROLL,SB_PAGEDOWN,0L);
			 break;
		  case VK_RETURN:
          if(GetKeyState(VK_SHIFT)&0x8000)
          	scheduler.addtask(user_jumptoarg2,priority_userrequest,nlptr,NULL);
          else
			 	scheduler.addtask(user_jumpto,priority_userrequest,nlptr,NULL);
			 break;
		  case VK_ESCAPE:
			 scheduler.addtask(user_jumpback,priority_userrequest,nlptr,NULL);
			 break;
		  case VK_F1:
			 DialogBox(hInst,MAKEINTRESOURCE(help_shortcuts),hwnd,(DLGPROC)helpshortcuts);
			 break;
        case VK_F3:
          searchmore();
          break;
        default:
          break;
		}
		break;
	 default:
		return DefWindowProc(hwnd,message,wParam,lParam);
  }
  return 0;
}

/************************************************************************
* habox                                                                 *
* - actually the 'Help -> About' dialog box                             *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL habox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  RECT drect;
  switch(message)
  { case WM_COMMAND:
		switch(wParam)
		{ case idc_email:
        	 ShellExecute(NULL,"open","mailto:cronos@ntlworld.com",NULL,NULL,SW_SHOWNORMAL);
          return TRUE;
        case idc_website:
        	 ShellExecute(NULL,"open","http://www.cronos.cc/",NULL,NULL,SW_SHOWNORMAL);
          return TRUE;
        case IDC_BUTTON1:
			 EndDialog(hdwnd,NULL);
			 return TRUE;
		}
		break;
	 case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		SetFocus(GetDlgItem(hdwnd,IDC_BUTTON1));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn -par
#endif

/************************************************************************
* changemenus                                                           *
* erm..... everytime I added a menu function I just added another line  *
* in here :)                                                            *
************************************************************************/
void changemenus(void)
{ HMENU hMenu;
  hMenu=GetMenu(mainwindow);
  EnableMenuItem(hMenu,file_open,MF_GRAYED);
  EnableMenuItem(hMenu,file_save,MF_ENABLED);
  EnableMenuItem(hMenu,save_asm,MF_ENABLED);
  EnableMenuItem(hMenu,view_segment,MF_ENABLED);
  EnableMenuItem(hMenu,view_names,MF_ENABLED);
  EnableMenuItem(hMenu,view_xrefs,MF_ENABLED);
  EnableMenuItem(hMenu,view_imports,MF_ENABLED);
  EnableMenuItem(hMenu,view_exports,MF_ENABLED);
  EnableMenuItem(hMenu,make_code,MF_ENABLED);
  EnableMenuItem(hMenu,undefine_line,MF_ENABLED);
  EnableMenuItem(hMenu,undefine_lines,MF_ENABLED);
  EnableMenuItem(hMenu,undefine_lines_long,MF_ENABLED);
  EnableMenuItem(hMenu,line_jumpto,MF_ENABLED);
  EnableMenuItem(hMenu,line_jumptoarg2,MF_ENABLED);
  EnableMenuItem(hMenu,make_dword,MF_ENABLED);
  EnableMenuItem(hMenu,make_word,MF_ENABLED);
  EnableMenuItem(hMenu,make_string,MF_ENABLED);
  EnableMenuItem(hMenu,pascal_string,MF_ENABLED);
  EnableMenuItem(hMenu,uc_string,MF_ENABLED);
  EnableMenuItem(hMenu,up_string,MF_ENABLED);
  EnableMenuItem(hMenu,dos_string,MF_ENABLED);
  EnableMenuItem(hMenu,general_string,MF_ENABLED);
  EnableMenuItem(hMenu,Name_Location,MF_ENABLED);
  EnableMenuItem(hMenu,Jump_Back,MF_ENABLED);
  EnableMenuItem(hMenu,argover_dec,MF_ENABLED);
  EnableMenuItem(hMenu,argover_hex,MF_ENABLED);
  EnableMenuItem(hMenu,argover_char,MF_ENABLED);
  EnableMenuItem(hMenu,argnegate,MF_ENABLED);
  EnableMenuItem(hMenu,offset_dseg,MF_ENABLED);
  EnableMenuItem(hMenu,main_search,MF_ENABLED);
  EnableMenuItem(hMenu,save_database,MF_ENABLED);
  EnableMenuItem(hMenu,load_database,MF_GRAYED);
  EnableMenuItem(hMenu,get_comment,MF_ENABLED);
  EnableMenuItem(hMenu,block_top,MF_ENABLED);
  EnableMenuItem(hMenu,block_bottom,MF_ENABLED);
  EnableMenuItem(hMenu,block_view,MF_ENABLED);
  EnableMenuItem(hMenu,block_saveasm,MF_ENABLED);
  EnableMenuItem(hMenu,block_savetext,MF_ENABLED);
  EnableMenuItem(hMenu,block_undefine,MF_ENABLED);
  EnableMenuItem(hMenu,float_single,MF_ENABLED);
  EnableMenuItem(hMenu,float_double,MF_ENABLED);
  EnableMenuItem(hMenu,float_longdouble,MF_ENABLED);
  EnableMenuItem(hMenu,arg_single,MF_ENABLED);
  EnableMenuItem(hMenu,search_again,MF_ENABLED);
  EnableMenuItem(hMenu,cm_decrypt,MF_ENABLED);
  EnableMenuItem(rmenu,cm_decrypt,MF_ENABLED);
  EnableMenuItem(rmenu,arg_single,MF_ENABLED);
  EnableMenuItem(rmenu,float_single,MF_ENABLED);
  EnableMenuItem(rmenu,float_double,MF_ENABLED);
  EnableMenuItem(rmenu,float_longdouble,MF_ENABLED);
  EnableMenuItem(rmenu,block_top,MF_ENABLED);
  EnableMenuItem(rmenu,block_bottom,MF_ENABLED);
  EnableMenuItem(rmenu,make_code,MF_ENABLED);
  EnableMenuItem(rmenu,get_comment,MF_ENABLED);
  EnableMenuItem(rmenu,undefine_line,MF_ENABLED);
  EnableMenuItem(rmenu,undefine_lines,MF_ENABLED);
  EnableMenuItem(rmenu,undefine_lines_long,MF_ENABLED);
  EnableMenuItem(rmenu,line_jumpto,MF_ENABLED);
  EnableMenuItem(rmenu,line_jumptoarg2,MF_ENABLED);
  EnableMenuItem(rmenu,make_dword,MF_ENABLED);
  EnableMenuItem(rmenu,make_word,MF_ENABLED);
  EnableMenuItem(rmenu,make_string,MF_ENABLED);
  EnableMenuItem(rmenu,pascal_string,MF_ENABLED);
  EnableMenuItem(rmenu,uc_string,MF_ENABLED);
  EnableMenuItem(rmenu,up_string,MF_ENABLED);
  EnableMenuItem(rmenu,dos_string,MF_ENABLED);
  EnableMenuItem(rmenu,general_string,MF_ENABLED);
  EnableMenuItem(rmenu,Name_Location,MF_ENABLED);
  EnableMenuItem(rmenu,view_xrefs,MF_ENABLED);
  EnableMenuItem(rmenu,argover_dec,MF_ENABLED);
  EnableMenuItem(rmenu,argover_hex,MF_ENABLED);
  EnableMenuItem(rmenu,argover_char,MF_ENABLED);
  EnableMenuItem(rmenu,argnegate,MF_ENABLED);
  EnableMenuItem(rmenu,offset_dseg,MF_ENABLED);
  charinputenabled=TRUE;
}

/************************************************************************
* newfile                                                               *
* - handles selecting a new file and its messages, using the standard   *
*   routine GetOpenFileName                                             *
* - starts up the secondary thread when the file is loaded              *
************************************************************************/
BOOL newfile(HWND hwnd)
{ int cbString,i;
  char chReplace;
  GetCurrentDirectory(sizeof(szDirName),szDirName);
  szFile[0]=0;
  cbString=LoadString(hInst,IDS_FILTERSTRING,szFilter,sizeof(szFilter));
  chReplace=szFilter[cbString-1];
  for(i=0;szFilter[i]!=0;i++)
  { if(szFilter[i]==chReplace) szFilter[i]=0;
  }
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=hwnd;
  ofn.lpstrFilter=szFilter;
  ofn.nFilterIndex=1;
  ofn.lpstrFile=szFile;
  ofn.nMaxFile=sizeof(szFile);
  ofn.lpstrFileTitle=szFileTitle;
  ofn.nMaxFileTitle=sizeof(szFileTitle);
  ofn.lpstrInitialDir=szDirName;
  ofn.lpstrCustomFilter=NULL;
  ofn.hInstance=NULL;
  ofn.lpTemplateName=NULL;
  ofn.lpstrTitle="Borg Disassembler - Select File";
  ofn.Flags=OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_LONGNAMES
				|OFN_EXPLORER;
  if(GetOpenFileName(&ofn))
  { if(floader.load(ofn.lpstrFile))
	 { StatusMessage("File Opened");
		strcat(winname," : ");
		strcat(winname,ofn.lpstrFile);
		SetWindowText(mainwindow,winname);
		InThread=TRUE;
		ThreadHandle=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)Thread,0,0,&ThreadId);
		changemenus();
	 }
	 else
		MessageBox(hwnd,"File open failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
  }
  return 0;
}

/************************************************************************
* Thread                                                                *
* - this is the secondary thread interface. It just keeps calling the   *
*   scheduler to process any items in the queue, until such time as the *
*   main thread wants to quit.                                          *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
void Thread(PVOID pvoid)
{ // needs to setup initial schedule list
  // continually monitor schedule list for jobs
  do
  { if(scheduler.process())
		if(!KillThread)StatusMessage("Processing Completed");
	 Sleep(1);
  } while(!KillThread);
  InThread=FALSE;
  ExitThread(0);
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

/************************************************************************
* savefile_text                                                         *
* - this is the savefile as text dialog which asks the user to select   *
*   a file for the save. The filedump is then controlled by disio       *
* - this is for text or asm saves                                       *
************************************************************************/
BOOL savefile_text(HWND hwnd,BOOL printaddrs,BOOL block)
{ int cbString,i;
  char chReplace;
  HWND sbox;
  if(scheduler.sizelist())
  { MessageBox(mainwindow,"There are still items to process yet","Borg Warning",MB_OK|MB_ICONEXCLAMATION);
	 return FALSE;
  }
  GetCurrentDirectory(sizeof(szDirName),szDirName);
  szFilesave[0]=0;
  cbString=LoadString(hInst,IDS_FILTERSAVE,szFilter,sizeof(szFilter));
  chReplace=szFilter[cbString-1];
  for(i=0;szFilter[i]!=0;i++)
  { if(szFilter[i]==chReplace) szFilter[i]=0;
  }
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=hwnd;
  ofn.lpstrFilter=szFilter;
  ofn.nFilterIndex=1;
  ofn.lpstrFile=szFilesave;
  ofn.nMaxFile=sizeof(szFilesave);
  ofn.lpstrFileTitle=szFileTitle;
  ofn.nMaxFileTitle=sizeof(szFileTitle);
  ofn.lpstrInitialDir=szDirName;
  ofn.lpstrCustomFilter=NULL;
  ofn.lpstrTitle="Borg Disassembler - Select File";
  ofn.Flags=OFN_PATHMUSTEXIST|OFN_HIDEREADONLY|OFN_LONGNAMES
				|OFN_EXPLORER;

  if(GetSaveFileName(&ofn))
  { sbox=CreateDialog(hInst,MAKEINTRESOURCE(save_box),mainwindow,(DLGPROC)savemessbox);
	 if(block)
      dio.dumpblocktofile(ofn.lpstrFile,printaddrs);
    else
      dio.dumptofile(ofn.lpstrFile,printaddrs);
	 DestroyWindow(sbox);
  }
  return 0;
}

/************************************************************************
* StatusMessage                                                         *
* - output a simple message to the status bar                           *
************************************************************************/
void StatusMessage(char *msg)
{ /*EnterCriticalSection(&cs);*/     // was causing locks (possibly)
  Status_SetText(hwndStatusBar,0,0,msg);
  /*LeaveCriticalSection(&cs);    */
}

/************************************************************************
* StatusMessageNItems                                                   *
* - shows how many items there are left to process                      *
************************************************************************/
void StatusMessageNItems(dword nolistitems)
{ static char buff[40];
  buff[39]=0; // just in case
  wsprintf(buff,"Items to Process :%lu",nolistitems);
  StatusMessage(buff);
}

/************************************************************************
* load_reg_entries                                                      *
* - Loads Borgs saved settings from the registry :)                     *
* - these are just colours, fonts, version, directory and window status *
* - settings are then restored                                          *
************************************************************************/
void load_reg_entries(void)
{  HKEY regkey;
	DWORD disposition;
   DWORD rver,dsize;
   COLORREF cl;
   char cdir[MAX_PATH];
	if(RegCreateKeyEx(HKEY_CURRENT_USER,reg_borg,0,"",REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
   	NULL,&regkey,&disposition)!=ERROR_SUCCESS)
      return;
   if(disposition==REG_CREATED_NEW_KEY)
   {	RegCloseKey(regkey);
   	return;
   }
   dsize=sizeof(rver);
   rver=0;
   RegQueryValueEx(regkey,"Version",NULL,NULL,(LPBYTE)&rver,&dsize);
   // now read values in.......
   cdir[0]=0;
   dsize=MAX_PATH;
   RegQueryValueEx(regkey,"Curdir",NULL,NULL,(LPBYTE)cdir,&dsize);
   if(cdir[0])
   	SetCurrentDirectory(cdir);
   dsize=sizeof(winmax);
   RegQueryValueEx(regkey,"Winmax",NULL,NULL,(LPBYTE)&winmax,&dsize);
   if(winmax)
   { PostMessage(mainwindow,WM_MAXITOUT,0,0);
   }
   dsize=sizeof(cl);
   if(RegQueryValueEx(regkey,"BackgroundColor",NULL,NULL,(LPBYTE)&cl,&dsize)==ERROR_SUCCESS)
   	options.bgcolor=cl;
   if(RegQueryValueEx(regkey,"HighlightColor",NULL,NULL,(LPBYTE)&cl,&dsize)==ERROR_SUCCESS)
   	options.highcolor=cl;
   if(RegQueryValueEx(regkey,"TextColor",NULL,NULL,(LPBYTE)&cl,&dsize)==ERROR_SUCCESS)
   	options.textcolor=cl;
   if(RegQueryValueEx(regkey,"Font",NULL,NULL,(LPBYTE)&cl,&dsize)==ERROR_SUCCESS)
   {	options.font=(fontselection)cl;
   }
   RegCloseKey(regkey);
   if(rver!=BORG_VER)
   {  RegCloseKey(regkey);
   	RegDeleteKey(HKEY_CURRENT_USER,reg_borg);
      save_reg_entries();
      return;
   }
}

/************************************************************************
* save_reg_entries                                                      *
* - Saves Borgs settings to the registry :)                             *
* - these are just colours, fonts, version, directory and window status *
************************************************************************/
void save_reg_entries(void)
{  HKEY regkey;
	DWORD disposition;
   DWORD rver,dsize;
   COLORREF cl;
	char cdir[MAX_PATH];
	if(RegCreateKeyEx(HKEY_CURRENT_USER,reg_borg,0,"",REG_OPTION_NON_VOLATILE,KEY_ALL_ACCESS,
   	NULL,&regkey,&disposition)!=ERROR_SUCCESS)
      return;
   // now write values out.......
   dsize=sizeof(rver);
   rver=BORG_VER;
   RegSetValueEx(regkey,"Version",0,REG_DWORD,(LPBYTE)&rver,dsize);
   GetCurrentDirectory(MAX_PATH,cdir);
	dsize=strlen(cdir)+1;
   RegSetValueEx(regkey,"Curdir",0,REG_SZ,(LPBYTE)cdir,dsize);
   dsize=sizeof(winmax);
   RegSetValueEx(regkey,"Winmax",0,REG_DWORD,(LPBYTE)&winmax,dsize);
   dsize=sizeof(COLORREF);
   cl=options.bgcolor;
   RegSetValueEx(regkey,"BackgroundColor",0,REG_DWORD,(LPBYTE)&cl,dsize);
   cl=options.highcolor;
   RegSetValueEx(regkey,"HighlightColor",0,REG_DWORD,(LPBYTE)&cl,dsize);
   cl=options.textcolor;
   RegSetValueEx(regkey,"TextColor",0,REG_DWORD,(LPBYTE)&cl,dsize);
   cl=options.font;
   RegSetValueEx(regkey,"Font",0,REG_DWORD,(LPBYTE)&cl,dsize);
   RegCloseKey(regkey);
}

/************************************************************************
* optionsinit                                                           *
* - initialises the global options struct with some default values      *
************************************************************************/
void optionsinit(void)
{ options.loaddebug=TRUE;
  options.mode16=FALSE;
  options.mode32=FALSE;
  options.loaddata=TRUE;
  options.loadresources=FALSE;
  options.cfa=TRUE;
  options.demangle=TRUE;
  options.processor=PROC_PENTIUM;
  options.codedetect=CD_PUSHBP|CD_EAXFROMESP|CD_MOVEAX;
  options.bgcolor=GetSysColor(COLOR_APPWORKSPACE);
  options.highcolor=RGB(0,255,0);
  options.textcolor=0;
  options.font=ansifont;
  options.readonly=FALSE;
}

/************************************************************************
* setupfont                                                             *
* - handles the setting up of a font (like selecting the object for     *
*   window painting and setting checkmarks on the menu, etc)            *
************************************************************************/
void setupfont(void)
{ HDC hdc;
  TEXTMETRIC tm;
  RECT tmp_rect;
  HMENU hMenu;
  hMenu=GetMenu(mainwindow);
  hdc=GetDC(mainwindow);
  CheckMenuItem(hMenu,font_ansi,MF_UNCHECKED);
  CheckMenuItem(hMenu,font_system,MF_UNCHECKED);
  CheckMenuItem(hMenu,font_courier,MF_UNCHECKED);
  CheckMenuItem(hMenu,font_courier10,MF_UNCHECKED);
  CheckMenuItem(hMenu,font_courier12,MF_UNCHECKED);
  switch(options.font)
  { case ansifont:
  		SelectObject(hdc,GetStockObject(ANSI_FIXED_FONT));
      CheckMenuItem(hMenu,font_ansi,MF_CHECKED);
      break;
    case systemfont:
  		SelectObject(hdc,GetStockObject(SYSTEM_FIXED_FONT));
      CheckMenuItem(hMenu,font_system,MF_CHECKED);
      break;
    case courierfont:
      if(cf!=NULL)
        DeleteObject(cf);
      cf=CreateFont(-MulDiv(8, GetDeviceCaps(hdc, LOGPIXELSY), 72),0,0,0,FW_LIGHT,0,0,0,0,0,0,0,0,"Courier New");
      if(cf==NULL)
  		  SelectObject(hdc,GetStockObject(ANSI_FIXED_FONT));
      else
        SelectObject(hdc,cf);
      CheckMenuItem(hMenu,font_courier,MF_CHECKED);
      break;
    case courierfont10:
      if(cf!=NULL)
        DeleteObject(cf);
      cf=CreateFont(-MulDiv(10, GetDeviceCaps(hdc, LOGPIXELSY), 72),0,0,0,FW_LIGHT,0,0,0,0,0,0,0,0,"Courier New");
      if(cf==NULL)
  		  SelectObject(hdc,GetStockObject(ANSI_FIXED_FONT));
      else
        SelectObject(hdc,cf);
      CheckMenuItem(hMenu,font_courier10,MF_CHECKED);
      break;
    case courierfont12:
      if(cf!=NULL)
        DeleteObject(cf);
      cf=CreateFont(-MulDiv(12, GetDeviceCaps(hdc, LOGPIXELSY), 72),0,0,0,FW_LIGHT,0,0,0,0,0,0,0,0,"Courier New");
      if(cf==NULL)
  		  SelectObject(hdc,GetStockObject(ANSI_FIXED_FONT));
      else
        SelectObject(hdc,cf);
      CheckMenuItem(hMenu,font_courier12,MF_CHECKED);
      break;
    default:
  		SelectObject(hdc,GetStockObject(ANSI_FIXED_FONT));
      CheckMenuItem(hMenu,font_ansi,MF_CHECKED);
      break;
  }
  GetTextMetrics(hdc,&tm);
  cxChar=tm.tmAveCharWidth;
  cyChar=tm.tmHeight+tm.tmExternalLeading;
  ReleaseDC(mainwindow,hdc);
  InitPaintSubsystem();
  GetClientRect(mainwindow,&tmp_rect);
  InvalidateRect(mainwindow,&tmp_rect,TRUE);
  scheduler.addtask(windowupdate,priority_window,nlptr,NULL);
}

/************************************************************************
* TestThread                                                            *
* - this is used on exit to wait for the secondary thread to finish.    *
* - I try every possible way of getting the thread to exit normally     *
*   before we eventually kill it in the mainwindow, WM_DESTROY handler  *
************************************************************************/
BOOL TestThread(void)
{ HWND sbox;
  BOOL ttest;
  sbox=CreateDialog(hInst,MAKEINTRESOURCE(Borg_Shutdown),mainwindow,(DLGPROC)shutbox);
  if(InThread)SetThreadPriority(ThreadHandle,THREAD_PRIORITY_TIME_CRITICAL);
  Sleep(2000);
  DestroyWindow(sbox);
  Sleep(5000);
  //EnterCriticalSection(&cs);
  ttest=InThread;
  //LeaveCriticalSection(&cs);
  return ttest;
}

/************************************************************************
* shutbox                                                               *
* - this is a shutdown warning box if Borg is having difficulty         *
*   quitting. It just puts up a 'shutting down' message for a couple of *
*   seconds                                                             *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL shutbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  switch(message)
  { case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}

/************************************************************************
* helpshortcuts                                                         *
* - the shortcuts help dialog box                                       *
* - simply a text summary of the shortcut keys in Borg                  *
************************************************************************/
BOOL FAR PASCAL helpshortcuts(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  RECT drect;
  switch(message)
  { case WM_COMMAND:
		{	switch(wParam)
		  { case IDOK:
				EndDialog(hdwnd,NULL);
				return TRUE;
			 default:
				break;
		  }
		}
		break;
	 case WM_INITDIALOG:
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		SetFocus(GetDlgItem(hdwnd,IDOK));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
	 default:
		break;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

/************************************************************************
* savedb                                                                *
* - the first place of call when save as database is selected.          *
* - asks the user to select a file before calling the fileloader savedb *
*   which is where the save to database is controlled from              *
************************************************************************/
void savedb(void)
{ int cbString,i;
  char chReplace;
  if(scheduler.sizelist())
  { MessageBox(mainwindow,"There are still items to process yet","Borg Warning",MB_OK|MB_ICONEXCLAMATION);
	 return;
  }
  GetCurrentDirectory(sizeof(szDirName),szDirName);
  szFilesave[0]=0;
  cbString=LoadString(hInst,IDS_FILTERSAVE,szFilter,sizeof(szFilter));
  chReplace=szFilter[cbString-1];
  for(i=0;szFilter[i]!=0;i++)
  { if(szFilter[i]==chReplace) szFilter[i]=0;
  }
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=mainwindow;
  ofn.lpstrFilter=szFilter;
  ofn.nFilterIndex=1;
  ofn.lpstrFile=szFilesave;
  ofn.nMaxFile=sizeof(szFilesave);
  ofn.lpstrFileTitle=szFileTitle;
  ofn.nMaxFileTitle=sizeof(szFileTitle);
  ofn.lpstrInitialDir=szDirName;
  ofn.lpstrCustomFilter=NULL;
  ofn.lpstrTitle="Borg Disassembler - Select File";
  ofn.Flags=OFN_PATHMUSTEXIST|OFN_HIDEREADONLY|OFN_LONGNAMES
				|OFN_EXPLORER;

  if(GetSaveFileName(&ofn))
  { floader.savedb(ofn.lpstrFile,szFile);
  }
}

/************************************************************************
* loaddb                                                                *
* - the first place of call when load from database is selected.        *
* - asks the user to select a file before calling the fileloader loaddb *
*   which is where the load from database is controlled from            *
* - starts up the secondary thread when the file is loaded              *
************************************************************************/
void loaddb(void)
{ int cbString,i;
  char chReplace;
  GetCurrentDirectory(sizeof(szDirName),szDirName);
  szFilesave[0]=0;
  cbString=LoadString(hInst,IDS_FILTERSTRING,szFilter,sizeof(szFilter));
  chReplace=szFilter[cbString-1];
  for(i=0;szFilter[i]!=0;i++)
  { if(szFilter[i]==chReplace) szFilter[i]=0;
  }
  ofn.lStructSize=sizeof(OPENFILENAME);
  ofn.hwndOwner=mainwindow;
  ofn.lpstrFilter=szFilter;
  ofn.nFilterIndex=1;
  ofn.lpstrFile=szFilesave;
  ofn.nMaxFile=sizeof(szFilesave);
  ofn.lpstrFileTitle=szFileTitle;
  ofn.nMaxFileTitle=sizeof(szFileTitle);
  ofn.lpstrInitialDir=szDirName;
  ofn.lpstrCustomFilter=NULL;
  ofn.hInstance=NULL;
  ofn.lpTemplateName=NULL;
  ofn.lpstrTitle="Borg Disassembler - Select File";
  ofn.Flags=OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_LONGNAMES
				|OFN_EXPLORER;
  if(GetOpenFileName(&ofn))
  { if(floader.loaddb(ofn.lpstrFile,szFile))
	 { StatusMessage("File Opened");
		strcat(winname," : ");
		strcat(winname,szFile);
		SetWindowText(mainwindow,winname);
		InThread=TRUE;
		ThreadHandle=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)Thread,0,0,&ThreadId);
		changemenus();
		scheduler.addtask(scrolling,priority_userrequest,nlptr,NULL);
	 }
	 else
		MessageBox(mainwindow,"File open failed ?",fname,MB_OK|MB_ICONEXCLAMATION);
  }
}

/************************************************************************
* choosecolour                                                          *
* - a small dialog box for colour choice (standard dialog) when setting *
*   background or text colours                                          *
************************************************************************/
COLORREF choosecolour(COLORREF cr)
{  cc.lStructSize=sizeof(CHOOSECOLOR);
	cc.hwndOwner=mainwindow;
   cc.hInstance=NULL;
   cc.rgbResult=cr;
   cc.lpCustColors=crCustColors;
   cc.Flags=CC_RGBINIT|CC_FULLOPEN;
   cc.lCustData=0;
   cc.lpfnHook=0;
   cc.lpTemplateName=0;
   if(ChooseColor(&cc)) return cc.rgbResult;
   return cr;
}


