//					DASM.H

#ifndef dasmh
#define dasmh

#include "common.h"

#define BORG_VER 221

#define CD_PUSHBP  1
#define CD_ENTER   2
#define CD_MOVBX   4
#define CD_AGGRESSIVE 8
#define CD_EAXFROMESP 16
#define CD_MOVEAX 32
#define VERTSCROLLRANGE 16000

enum fontselection {ansifont=1,systemfont,courierfont,courierfont10,courierfont12};

struct globaloptions
{ BOOL loaddebug;
  BOOL mode16,mode32;
  BOOL loaddata,loadresources;
  BOOL demangle;
  BOOL cfa;
  dword processor;
  lptr loadaddr;
  word dseg;
  word codedetect;
  COLORREF bgcolor,textcolor,highcolor;
  fontselection font;
  BOOL readonly;
};

void StatusMessageNItems(dword nolistitems);

extern CRITICAL_SECTION cs;
extern HINSTANCE hInst;
extern HWND mainwindow;
extern globaloptions options;
extern RECT mainwnd;
extern volatile BOOL KillThread;
extern char winname[];
extern HFONT cf;

#define Status_SetText(hwnd, iPart, uType, szText) \
	 (BOOL)PostMessage((hwnd), SB_SETTEXT, (WPARAM) (iPart | uType), (LPARAM) (LPSTR) szText)

#endif