//					data.h
//

#ifndef data_h
#define data_h

#include "list.h"
#include "common.h"
#include "savefile.h"

enum segtype {code16=1,code32,data16,data32,uninitdata,debugdata,resourcedata};

//essentially the data-mapping to the file.
//divides file into code/data segments or objects
//each set of data is then referenced through these sorted headers
struct dsegitem
{ lptr addr;
  dword size;
  byte *data;
  segtype typ;
  char *name;
};

struct dsegitemsave
{ lptr addr;
  dword size;
  dword fileoffset;
  segtype typ;
  BOOL name;
};

class dataseg: public slist
{ private:

  public:
	 dataseg();
	 ~dataseg();
	 void addseg(lptr loc,dword size,byte *dataptr,segtype t,char *name);
	 dsegitem *findseg(lptr loc);
	 BOOL beyondseg(lptr loc);
	 void nextseg(lptr *loc);
	 void lastseg(lptr *loc);
    unsigned long datagetpos(lptr loc);
    lptr getlocpos(unsigned long pos);
	 void possibleentrycode(lptr loc);
	 void segviewer(void);
	 void segheader(lptr loc);
	 BOOL savedb(savefile *sf,byte *filebuff);
	 BOOL loaddb(savefile *sf,byte *filebuff);
};

extern dataseg dta;

// for vertical scrollbar only
extern unsigned long total_data_size;
extern unsigned long current_data_pos;

#endif
