//			decrypt.h
//

#ifndef decrypt_h
#define decrypt_h

#include "common.h"
#include "list.h"
#include "savefile.h"

// decrypt types supported - add, sub, mul, xor
enum dectype {decnull=0,decadd,decsub,decmul,decrot,decxor,decxadd};

// decrypt lengths - byte,word,dword,array
enum ditemtype {decbyte=1,decword,decdword,decarray};

// decrypters are held in an array - this array is saved when a database is saved
// and the list is reapplied on loading the file.
struct declist
{  lptr dec_start;
   lptr dec_end;
   dectype typ;
   ditemtype dlength;
   dword value;
   lptr addr;
   BOOL patch;
   dword uid;
};

class decrypt:public slist
{ private:
    dword nextitemnum;

  public:
    decrypt();
    ~decrypt();
    dword add_decrypted(lptr dstart,lptr dend,dectype t,ditemtype ditem,dword val,lptr adr,BOOL patchedexe);
    void process_dec(dword dec_id);
    void process_reload(dword dec_id);
    BOOL savedb(savefile *sf);
    BOOL loaddb(savefile *sf);
    void dialg(void);
    void exepatch(dword dec_id);
};

extern decrypt decrypter;

#endif