//						disfuncs.h
//
// common disasm funcs for the disasm and disio classes
// to resolve mutual inclusion problems and forward declarations of
// class functions during splitting of classes :(

#ifndef disfuncs_h
#define disfuncs_h

#define BYTEPOS 14
#define ASMPOS 31
#define ARGPOS 38
#define COMMENTPOS 50
#define COMMENT_MAXLEN 100

#define CALLSTACKSIZE 100

enum dsmitemtype {dsmnull=0,dsmsegheader,dsmnameloc=5,dsmcomment,dsmxref,dsmcode};
enum byteoverride {over_null=0,over_decimal,over_char,over_dsoffset,over_single};

struct dsmitem
{ // these items should be dword size
  lptr addr;
  void *tptr;                     // string pointer for comment
											 // asminstdata ptr for code
  dword flags;
  byte *data;                     // data ptr

  // these items should be word size
  word length;

  // and these items should be just bytesize for efficiency
  dsmitemtype type;
  byte modrm;              // length, offset to  modrm byte
  BOOL mode32;
  byteoverride override;
  byte displayflags;
};

struct dsmitemsave
{ lptr addr;
  dword tptroffset;
  dsmitemtype type;
  word length;
  byte modrm;
  BOOL mode32;
  dword fileoffset;
  byteoverride override;
  dword flags;
  byte displayflags;
};

#endif
