//			disio.h
//
// - added version 2.11

#ifndef disio_h
#define disio_h

#include "list.h"
#include "common.h"
#include "proctab.h"
#include "stacks.h"
#include "disfuncs.h"
#include "savefile.h"

// display flags
#define DISPFLAG_NEGATE 1

class disio
{ private:
	 lptr curraddr,outend;
	 dsmitemtype subitem;  // subindex to top line of output
	 stack retstack;

  public:
  	disio();
   ~disio();
	BOOL savedb(savefile *sf,byte *filebuff);
	BOOL loaddb(savefile *sf,byte *filebuff);
	void dumptofile(char *fname,BOOL printaddrs);
	void dumpblocktofile(char *fname,BOOL printaddrs);
	void outcomment(dsmitem *inst);
   void outargs(dsmitem *inst,argtype a);
	void updatewindow(void);
	void scroller(dword amount);
	void updatewindowifinrange(lptr loc);
	void savecuraddr(void);
	void findcurrentaddr(lptr *loc);
	void vertsetpos(int pos);
	void jumpback(void);
	void jumpto(bool arg1);
	dsmitem *findcurrentline(void);
	void setcuraddr(lptr loc);
	void setpos(int ypos);
	void outinst(dsmitem *inst,BOOL printaddrs);
	void outdb(lptr *lp,BOOL printaddrs);
	void outprefix(byte prefixbyte);
	void argoverdec(void);
	void argoversingle(void);
	void arg_negate(void);
	void argoverhex(void);
	void argoveroffsetdseg(void);
	void argoverchar(void);
	void makecode(void);
	void makeword(void);
	void makedword(void);
	void makesingle(void);
	void makedouble(void);
	void makelongdouble(void);
	void makestring(void);
	void pascalstring(void);
	void ucstring(void);
	void upstring(void);
	void dosstring(void);
	void generalstring(void);
	void getcomment(void);
   static BOOL FAR PASCAL getcommentbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);
   void updatewindowifwithinrange(lptr loc_start,lptr loc_end);
};

extern disio dio;

#endif