/************************************************************************
*                  exports.cpp                                          *
* This is the exports class extension of the generic names class gname  *
* Exports were implemented as a separate class to normal names because  *
* this allowed an element of persistence to be given to them (you cant  *
* delete a name from the list unless you do it from code within Borg)   *
* Also exports and imports have been given different dialogs, and can   *
* be treated differently in disassembly and display. I suppose this     *
* could have been implemented as a property of the names class but I    *
* decided early on to separate the classes out                          *
************************************************************************/

#include <windows.h>

#include "menuids.rh"
#include "exports.h"
#include "disasm.h"
#include "schedule.h"
#include "mainwind.h"
#include "names.h"
#include "data.h"
#include "dasm.h"

/************************************************************************
* forward declarations                                                  *
************************************************************************/
BOOL FAR PASCAL exportsbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam);

/************************************************************************
* additional constructor - currently null                               *
************************************************************************/
exports::exports()
{
}

/************************************************************************
* additional destructor - currently null                                *
************************************************************************/
exports::~exports()
{
}

/************************************************************************
* exportsviewer                                                         *
* - stops the thread and displays the exports viewer dialog. Although   *
*   this supports the repeater variable, as for the names class, it is  *
*   currently unused                                                    *
************************************************************************/
void exports::exportsviewer(void)
{ repeater=TRUE;
  while(repeater)
  { if(!numlistitems())
	 { MessageBox(mainwindow,"There are no exports in the list","Borg Message",MB_OK);
		return;
	 }
	 scheduler.stopthread();
	 repeater=FALSE;
	 DialogBox(hInst,MAKEINTRESOURCE(Exports_Viewer),mainwindow,(DLGPROC)exportsbox);
    scheduler.continuethread();
  }
}

/************************************************************************
* exportsbox                                                            *
* - this is the exports viewer dialog box. It is simpler than the names *
*   class dialog box, featuring only a jump to option. As for the names *
*   class a request is added to the scheduler for any jump and the      *
*   dialog box exits. the main code is for filling the initial list box *
*   and for displaying a new address when the selection is changed      *
************************************************************************/
#ifdef __BORLANDC__
#pragma warn -par
#endif
BOOL FAR PASCAL exportsbox(HWND hdwnd,UINT message,WPARAM wParam,LPARAM lParam)
{ static HBRUSH hbrush;
  static char nseg[20],noffs[20];
  static gnameitem *t;
  dword st;
  dword i;
  RECT drect;
  switch(message)
  { case WM_COMMAND:
		{	switch(wParam)
		  { case IDC_OKBUTTON:
				EndDialog(hdwnd,NULL);
				return TRUE;
			 case IDC_JUMPTOBUTTON:
				scheduler.addtask(user_jumptoaddr,priority_userrequest,t->addr,NULL);
				EndDialog(hdwnd,NULL);
				return TRUE;
			 default:
				break;
		  }
		  switch(HIWORD(wParam))
		  { case LBN_SELCHANGE:
				i=SendDlgItemMessage(hdwnd,IDC_EXPORTSLISTBOX,LB_GETCURSEL,0,0);
				expt.resetiterator();
				t=(gnameitem *)expt.nextiterator();
				while(i)
				{ t=(gnameitem *)expt.nextiterator();
				  i--;
				}
				st=t->addr.segm;
				wsprintf(nseg,"0x%lx",st);
				wsprintf(noffs,"0x%lx",t->addr.offs);
				SendDlgItemMessage(hdwnd,EXPORTS_TEXTSTART,WM_SETTEXT,0,(LPARAM)(LPCTSTR)nseg);
				SendDlgItemMessage(hdwnd,EXPORTS_TEXTEND,WM_SETTEXT,0,(LPARAM)(LPCTSTR)noffs);
				break;
			 default:
				break;
		  }
		}
		break;
	 case WM_INITDIALOG:
		GetWindowRect(hdwnd,&drect);
		MoveWindow(hdwnd,((mainwnd.right+mainwnd.left)-(drect.right-drect.left))/2,
		  ((mainwnd.bottom+mainwnd.top)-(drect.bottom-drect.top))/2,drect.right-drect.left,drect.bottom-drect.top,TRUE);
		expt.resetiterator();
		for(i=0;i<expt.numlistitems();i++)
		{ t=(gnameitem *)expt.nextiterator();
		  SendDlgItemMessage(hdwnd,IDC_EXPORTSLISTBOX,LB_ADDSTRING,0,(LPARAM) (LPCTSTR)t->name);
		}
		SendDlgItemMessage(hdwnd,IDC_EXPORTSLISTBOX,LB_SETCURSEL,0,0);
		expt.resetiterator();
		t=(gnameitem *)expt.nextiterator();
		st=t->addr.segm;
		wsprintf(nseg,"0x%lx",st);
		wsprintf(noffs,"0x%lx",t->addr.offs);
		SendDlgItemMessage(hdwnd,EXPORTS_TEXTSTART,WM_SETTEXT,0,(LPARAM)(LPCTSTR)nseg);
		SendDlgItemMessage(hdwnd,EXPORTS_TEXTEND,WM_SETTEXT,0,(LPARAM)(LPCTSTR)noffs);
		hbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
		SetFocus(GetDlgItem(hdwnd,IDC_OKBUTTON));
		return 0;
	 case WM_DESTROY:
		DeleteObject(hbrush);
		return 0;
	 case WM_CTLCOLORSTATIC:
	 case WM_CTLCOLORBTN:
	 case WM_CTLCOLORDLG:
	 case WM_SYSCOLORCHANGE:
		SetBkColor((HDC)wParam,GetSysColor(COLOR_BTNFACE));
		return (LRESULT)hbrush;
  }
  return FALSE;
}
#ifdef __BORLANDC__
#pragma warn +par
#endif

